# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module FinancialServices
      module V1
        # Instance is a container for the rest of API resources.
        # Only resources in the same instance can interact with each other.
        # Child resources inherit the location (data residency) and encryption (CMEK).
        # The location of the provided input and output in requests must match the
        # location of the instance.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The full path to the Instance resource in this API.
        #     format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the Instance was created.
        #     Assigned by the server.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Timestamp when the Instance was last updated.
        #     Assigned by the server.
        # @!attribute [r] state
        #   @return [::Google::Cloud::FinancialServices::V1::Instance::State]
        #     Output only. State of the instance.
        #     Assigned by the server.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Required. The KMS key name used for CMEK (encryption-at-rest).
        #     format:
        #     `projects/{project}/locations/{location}/keyRings/{keyRing}/cryptoKeys/{cryptoKey}`
        #     VPC-SC restrictions apply.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The Resource State
          module State
            # State is unspecified, should not occur.
            STATE_UNSPECIFIED = 0

            # The resource has not finished being created.
            CREATING = 1

            # The resource is active/ready to be used.
            ACTIVE = 2

            # The resource is in the process of being updated.
            UPDATING = 3

            # The resource is in the process of being deleted.
            DELETING = 4
          end
        end

        # Request for retrieving a paginated list of Instance resources that meet the
        # specified criteria.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the Instance is the location for that Instance.
        #     Every location has exactly one instance.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The number of resources to be included in the response. The response
        #     contains a next_page_token, which can be used to retrieve the next page of
        #     resources.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     In case of paginated results, this is the token that was returned in the
        #     previous ListInstancesResponse. It should be copied here to retrieve the
        #     next page of resources. This will be empty for the first instance of
        #     ListInstancesRequest.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Specify a filter to narrow search results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Specify a field to use for ordering.
        class ListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for retrieving a list of Instances
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::FinancialServices::V1::Instance>]
        #     List of Instance resources
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     This token should be passed to the next ListInstancesRequest to retrieve
        #     the next page of Instances.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for retrieving a specific Instance resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Instance.
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for creating a Instance resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the Instance is the location for that Instance.
        #     Every location has exactly one instance.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. The resource id of the instance.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::FinancialServices::V1::Instance]
        #     Required. The instance that will be created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for updating a Instance
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Instance resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::FinancialServices::V1::Instance]
        #     Required. The new value of the instance fields that will be updated
        #     according to the update_mask
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for deleting a Instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Instance.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for adding/removing registered parties from BigQuery tables
        # specified by the customer.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full path to the Instance resource in this API.
        #     format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] party_tables
        #   @return [::Array<::String>]
        #     Optional. List of BigQuery tables. Union of tables will be taken if there
        #     is more than one table. VPC-SC restrictions apply. format:
        #     `bq://{project}.{bqDatasetID}.{bqTableID}` Use of `datasets` is preferred
        #     over the latter due to its simplicity and the reduced risk of errors
        #     `party_tables` and `datasets` must not be provided at the
        #     same time
        # @!attribute [rw] mode
        #   @return [::Google::Cloud::FinancialServices::V1::ImportRegisteredPartiesRequest::UpdateMode]
        #     Required. Mode of the request.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If the request will not register the parties, just determine what
        #     would happen.
        # @!attribute [rw] line_of_business
        #   @return [::Google::Cloud::FinancialServices::V1::LineOfBusiness]
        #     Required. LineOfBusiness for the specified registered parties.
        class ImportRegisteredPartiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # UpdateMode controls the behavior for ImportRegisteredParties.
          module UpdateMode
            # Default mode.
            UPDATE_MODE_UNSPECIFIED = 0

            # Replace parties that are removable in Parties Table with new parties.
            REPLACE = 1

            # Add new parties to Parties Table.
            APPEND = 2
          end
        end

        # Response for adding/removing registered parties from BigQuery tables.
        # @!attribute [rw] parties_added
        #   @return [::Integer]
        #     Number of parties added by this operation.
        # @!attribute [rw] parties_removed
        #   @return [::Integer]
        #     Number of parties removed by this operation.
        # @!attribute [rw] parties_total
        #   @return [::Integer]
        #     Total number of parties that are registered in this instance, after the
        #     update operation was completed.
        # @!attribute [rw] parties_failed_to_remove
        #   @return [::Integer]
        #     Number of parties that failed to be removed by this operation.
        # @!attribute [rw] parties_uptiered
        #   @return [::Integer]
        # @!attribute [rw] parties_downtiered
        #   @return [::Integer]
        #     Total number of parties that are downtiered in this instance
        # @!attribute [rw] parties_failed_to_downtier
        #   @return [::Integer]
        #     Number of parties that failed to be downtiered
        class ImportRegisteredPartiesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to export a list of currently registered parties.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The full path to the Instance resource in this API.
        #     format: `projects/{project}/locations/{location}/instances/{instance}`
        # @!attribute [rw] dataset
        #   @return [::Google::Cloud::FinancialServices::V1::BigQueryDestination]
        #     Required. The location to output the RegisteredParties.
        # @!attribute [rw] line_of_business
        #   @return [::Google::Cloud::FinancialServices::V1::LineOfBusiness]
        #     Required. LineOfBusiness to get RegisteredParties from.
        class ExportRegisteredPartiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to export registered parties request.
        class ExportRegisteredPartiesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
