# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module FinancialServices
      module V1
        # EngineVersion controls which version of the engine is used to tune, train,
        # and run the model.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the EngineVersion
        #     format:
        #     `/projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}`
        # @!attribute [r] state
        #   @return [::Google::Cloud::FinancialServices::V1::EngineVersion::State]
        #     Output only. The state of the version.
        # @!attribute [r] expected_limitation_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Planned time to stop allowing training/tuning using this
        #     version. Existing trained models can still be used for prediction/backtest.
        # @!attribute [r] expected_decommission_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Planned time to stop supporting the version, in addition
        #     to no training or tuning, models trained on this version
        #     can no longer be used for prediction/backtest.
        # @!attribute [r] line_of_business
        #   @return [::Google::Cloud::FinancialServices::V1::LineOfBusiness]
        #     Output only. The line of business (Retail/Commercial) this engine version
        #     is used for.
        class EngineVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State determines the lifecycle of a version and the models/engine configs
          # trained with it.
          module State
            # Default state, should never be used.
            STATE_UNSPECIFIED = 0

            # Version is available for training and inference.
            ACTIVE = 1

            # Models using this version can still be run, but new ones cannot be
            # trained.
            LIMITED = 2

            # Version is deprecated, listed for informational purposes only.
            DECOMMISSIONED = 3
          end
        end

        # Request for retrieving a paginated list of EngineVersion resources that meet
        # the specified criteria.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the EngineVersion is the Instance.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The number of resources to be included in the response. The
        #     response contains a next_page_token, which can be used to retrieve the next
        #     page of resources.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. In case of paginated results, this is the token that was returned
        #     in the previous ListEngineVersionsResponse. It should be copied here to
        #     retrieve the next page of resources. Empty will give the first page of
        #     ListEngineVersionsRequest, and the last page will return an empty
        #     page_token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Specify a filter to narrow search results.
        #     If empty or unset will default to "state!=DEPRECATED",
        #     to view deprecated versions use "state:*" or any other filter.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specify a field to use for ordering.
        class ListEngineVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response to a list call containing the list of engine versions.
        # @!attribute [rw] engine_versions
        #   @return [::Array<::Google::Cloud::FinancialServices::V1::EngineVersion>]
        #     List of EngineVersion resources
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     This token should be passed to the next EngineVersionsRequest to retrieve
        #     the next page of EngineVersions (empty indicates we are done).
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListEngineVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for retrieving a specific EngineVersion resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the EngineVersion
        class GetEngineVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
