# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module FinancialServices
      module V1
        # The EngineConfig resource creates the configuration for training a model.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the EngineConfig.
        #     format:
        #     `/projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engine_config}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of creation of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of the most recent update of this resource.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels
        # @!attribute [r] state
        #   @return [::Google::Cloud::FinancialServices::V1::EngineConfig::State]
        #     Output only. State of the EngineConfig (creating, active, deleting, etc.)
        # @!attribute [rw] engine_version
        #   @return [::String]
        #     Required. The resource name of the EngineVersion used in this model tuning.
        #     format:
        #     `/projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}`
        # @!attribute [rw] tuning
        #   @return [::Google::Cloud::FinancialServices::V1::EngineConfig::Tuning]
        #     Optional. Configuration for tuning in creation of the EngineConfig.
        #     This field is required if `hyperparameter_source.type` is not `INHERITED`,
        #     and output-only otherwise.
        # @!attribute [rw] performance_target
        #   @return [::Google::Cloud::FinancialServices::V1::EngineConfig::PerformanceTarget]
        #     Optional. PerformanceTarget gives information on how the tuning and
        #     training will be evaluated. This field is required if
        #     `hyperparameter_source.type` is not `INHERITED`, and output-only otherwise.
        # @!attribute [r] line_of_business
        #   @return [::Google::Cloud::FinancialServices::V1::LineOfBusiness]
        #     Output only. The line of business (Retail/Commercial) this engine config is
        #     used for. Determined by EngineVersion, cannot be set by user.
        # @!attribute [rw] hyperparameter_source_type
        #   @return [::Google::Cloud::FinancialServices::V1::EngineConfig::HyperparameterSourceType]
        #     Optional. The origin of hyperparameters for the created EngineConfig. The
        #     default is `TUNING`. In this case, the hyperparameters are selected as a
        #     result of a
        #      tuning run.
        # @!attribute [rw] hyperparameter_source
        #   @return [::Google::Cloud::FinancialServices::V1::EngineConfig::HyperparameterSource]
        #     Optional. Configuration of hyperparameters source EngineConfig.
        class EngineConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The parameters needed for the tuning operation, these are used only in
          # tuning and not passed on to training.
          # @!attribute [rw] primary_dataset
          #   @return [::String]
          #     Required. The resource name of the Primary Dataset used in this model
          #     tuning. For information about how primary and auxiliary datasets are
          #     used, refer to the engine version's documentation.  Format:
          #     `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Required. End_time specifies the latest time from which labels are used
          #     and from which data is used to generate features for tuning.  End_time
          #     should be no later than the end of the date_range of the dataset.
          class Tuning
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # PerformanceTarget gives hints on how to evaluate the performance of a
          # model.
          # @!attribute [rw] party_investigations_per_period_hint
          #   @return [::Integer]
          #     Required. A number that gives the tuner a hint on the number of parties
          #     from this data that will be investigated per period (monthly). This is
          #     used to control how the model is evaluated. For example, when trying AML
          #     AI for the first time, we recommend setting this to the number of parties
          #     investigated in an average month, based on alerts from your existing
          #     automated alerting system.
          class PerformanceTarget
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Parameters for bootstrapping an Engine Config with the results of another
          # one.
          # @!attribute [rw] source_engine_config
          #   @return [::String]
          #     Required. The resource name of the source EngineConfig whose outputs are
          #     used. Format:
          #     `/projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engine_config}`
          # @!attribute [r] source_engine_version
          #   @return [::String]
          #     Output only. The resource name of the EngineVersion that was used in the
          #     tuning run. Format:
          #     `/projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}`
          class HyperparameterSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible states of a resource.
          module State
            # State is unspecified, should not occur.
            STATE_UNSPECIFIED = 0

            # The resource has not finished being created.
            CREATING = 1

            # The resource is active/ready to be used.
            ACTIVE = 2

            # The resource is in the process of being updated.
            UPDATING = 3

            # The resource is in the process of being deleted.
            DELETING = 4
          end

          # The type of the hyperparameter source.
          module HyperparameterSourceType
            # Hyperparameter source type is unspecified, defaults to TUNING.
            HYPERPARAMETER_SOURCE_TYPE_UNSPECIFIED = 0

            # The EngineConfig creation starts a tuning job which selects the best
            # hyperparameters.
            TUNING = 1

            # The hyperparameters are inherited from another EngineConfig.
            INHERITED = 2
          end
        end

        # Request for retrieving a paginated list of EngineConfig resources that
        # meet the specified criteria.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the EngineConfig is the Instance.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The number of resources to be included in the response. The response
        #     contains a next_page_token, which can be used to retrieve the next page of
        #     resources.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     In case of paginated results, this is the token that was returned in the
        #     previous ListEngineConfigsResponse. It should be copied here to retrieve
        #     the next page of resources. Empty will give the first page of
        #     ListEngineConfigsRequest, and the last page will return an empty
        #     page_token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Specify a filter to narrow search results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Specify a field to use for ordering.
        class ListEngineConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for retrieving a list of EngineConfigs
        # @!attribute [rw] engine_configs
        #   @return [::Array<::Google::Cloud::FinancialServices::V1::EngineConfig>]
        #     List of EngineConfig resources
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     This token should be passed to the next ListEngineConfigsRequest to
        #     retrieve the next page of EngineConfigs (empty indicates we are done).
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListEngineConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for retrieving a specific EngineConfig resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the EngineConfig
        class GetEngineConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for creating an EngineConfig resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the EngineConfig is the Instance.
        # @!attribute [rw] engine_config_id
        #   @return [::String]
        #     Required. The resource id of the EngineConfig
        # @!attribute [rw] engine_config
        #   @return [::Google::Cloud::FinancialServices::V1::EngineConfig]
        #     Required. The EngineConfig that will be created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateEngineConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for updating an EngineConfig
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     EngineConfig resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] engine_config
        #   @return [::Google::Cloud::FinancialServices::V1::EngineConfig]
        #     Required. The new value of the EngineConfig fields that will be updated
        #     according to the update_mask.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateEngineConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for deleting an EngineConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the EngineConfig.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteEngineConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for exporting EngineConfig metadata.
        # @!attribute [rw] engine_config
        #   @return [::String]
        #     Required. The resource name of the EngineConfig.
        # @!attribute [rw] structured_metadata_destination
        #   @return [::Google::Cloud::FinancialServices::V1::BigQueryDestination]
        #     Required. BigQuery output where the metadata will be written.
        class ExportEngineConfigMetadataRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for exporting EngineConfig metadata.
        class ExportEngineConfigMetadataResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
