# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module FinancialServices
      module V1
        # The Dataset resource contains summary information about a dataset.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the Dataset.
        #     format:
        #     `/projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of creation of this resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of the most recent update of this resource.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels
        # @!attribute [rw] table_specs
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Required. The set of BigQuery tables in the dataset.  The key should be the
        #     table type and the value should be the BigQuery tables in the format
        #     `bq://{project}.{dataset}.{table}`.
        #     Current table types are:
        #
        #       * `party`
        #       * `account_party_link`
        #       * `transaction`
        #       * `risk_case_event`
        #       * `party_supplementary_data`
        # @!attribute [r] state
        #   @return [::Google::Cloud::FinancialServices::V1::Dataset::State]
        #     Output only. State of the dataset (creating, active, deleting, etc.)
        # @!attribute [rw] date_range
        #   @return [::Google::Type::Interval]
        #     Required. Core time window of the dataset. All tables should have complete
        #     data covering this period.
        # @!attribute [rw] time_zone
        #   @return [::Google::Type::TimeZone]
        #     The timezone of the data, default will act as UTC.
        class Dataset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TableSpecsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The possible states of a resource.
          module State
            # State is unspecified, should not occur.
            STATE_UNSPECIFIED = 0

            # The resource has not finished being created.
            CREATING = 1

            # The resource is active/ready to be used.
            ACTIVE = 2

            # The resource is in the process of being updated.
            UPDATING = 3

            # The resource is in the process of being deleted.
            DELETING = 4
          end
        end

        # Request for retrieving a paginated list of Dataset resources that meet the
        # specified criteria.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the Dataset is the Instance.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The number of resources to be included in the response. The response
        #     contains a next_page_token, which can be used to retrieve the next page of
        #     resources.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     In case of paginated results, this is the token that was returned in the
        #     previous ListDatasetResponse. It should be copied here to retrieve the
        #     next page of resources. Empty will give the first page of
        #     ListDatasetRequest, and the last page will return an empty page_token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Specify a filter to narrow search results.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Specify a field to use for ordering.
        class ListDatasetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for retrieving a list of Datasets
        # @!attribute [rw] datasets
        #   @return [::Array<::Google::Cloud::FinancialServices::V1::Dataset>]
        #     List of Dataset resources
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     This token should be passed to the next ListDatasetsRequest to retrieve
        #     the next page of Datasets (empty indicates we are done).
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDatasetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for retrieving a specific Dataset resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Dataset
        class GetDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for creating a Dataset resource.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent of the Dataset is the Instance.
        # @!attribute [rw] dataset_id
        #   @return [::String]
        #     Required. The resource id of the dataset
        # @!attribute [rw] dataset
        #   @return [::Google::Cloud::FinancialServices::V1::Dataset]
        #     Required. The dataset that will be created.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class CreateDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for updating a Dataset
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Field mask is used to specify the fields to be overwritten in the
        #     Dataset resource by the update.
        #     The fields specified in the update_mask are relative to the resource, not
        #     the full request. A field will be overwritten if it is in the mask. If the
        #     user does not provide a mask then all fields will be overwritten.
        # @!attribute [rw] dataset
        #   @return [::Google::Cloud::FinancialServices::V1::Dataset]
        #     Required. The new value of the dataset fields that will be updated
        #     according to the update_mask.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes since the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class UpdateDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for deleting a Dataset.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Dataset.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. An optional request ID to identify requests. Specify a unique
        #     request ID so that if you must retry your request, the server will know to
        #     ignore the request if it has already been completed. The server will
        #     guarantee that for at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request
        #     ID, the server can check if original operation with the same request ID
        #     was received, and if so, will ignore the second request. This prevents
        #     clients from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        class DeleteDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
