# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module FinancialServices
      module V1
        module AML
          # Path helper methods for the AML API.
          module Paths
            ##
            # Create a fully-qualified BacktestResult resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_num}/locations/{location}/instances/{instance}/backtestResults/{backtest_result}`
            #
            # @param project_num [String]
            # @param location [String]
            # @param instance [String]
            # @param backtest_result [String]
            #
            # @return [::String]
            def backtest_result_path project_num:, location:, instance:, backtest_result:
              raise ::ArgumentError, "project_num cannot contain /" if project_num.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project_num}/locations/#{location}/instances/#{instance}/backtestResults/#{backtest_result}"
            end

            ##
            # Create a fully-qualified Dataset resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_num}/locations/{location}/instances/{instance}/datasets/{dataset}`
            #
            # @param project_num [String]
            # @param location [String]
            # @param instance [String]
            # @param dataset [String]
            #
            # @return [::String]
            def dataset_path project_num:, location:, instance:, dataset:
              raise ::ArgumentError, "project_num cannot contain /" if project_num.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project_num}/locations/#{location}/instances/#{instance}/datasets/#{dataset}"
            end

            ##
            # Create a fully-qualified EngineConfig resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_num}/locations/{location}/instances/{instance}/engineConfigs/{engine_config}`
            #
            # @param project_num [String]
            # @param location [String]
            # @param instance [String]
            # @param engine_config [String]
            #
            # @return [::String]
            def engine_config_path project_num:, location:, instance:, engine_config:
              raise ::ArgumentError, "project_num cannot contain /" if project_num.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project_num}/locations/#{location}/instances/#{instance}/engineConfigs/#{engine_config}"
            end

            ##
            # Create a fully-qualified EngineVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_num}/locations/{location}/instances/{instance}/engineVersions/{engine_version}`
            #
            # @param project_num [String]
            # @param location [String]
            # @param instance [String]
            # @param engine_version [String]
            #
            # @return [::String]
            def engine_version_path project_num:, location:, instance:, engine_version:
              raise ::ArgumentError, "project_num cannot contain /" if project_num.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project_num}/locations/#{location}/instances/#{instance}/engineVersions/#{engine_version}"
            end

            ##
            # Create a fully-qualified Instance resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/instances/{instance}`
            #
            # @param project [String]
            # @param location [String]
            # @param instance [String]
            #
            # @return [::String]
            def instance_path project:, location:, instance:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/instances/#{instance}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Model resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_num}/locations/{location}/instances/{instance}/models/{model}`
            #
            # @param project_num [String]
            # @param location [String]
            # @param instance [String]
            # @param model [String]
            #
            # @return [::String]
            def model_path project_num:, location:, instance:, model:
              raise ::ArgumentError, "project_num cannot contain /" if project_num.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project_num}/locations/#{location}/instances/#{instance}/models/#{model}"
            end

            ##
            # Create a fully-qualified PredictionResult resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project_num}/locations/{location}/instances/{instance}/predictionResults/{prediction_result}`
            #
            # @param project_num [String]
            # @param location [String]
            # @param instance [String]
            # @param prediction_result [String]
            #
            # @return [::String]
            def prediction_result_path project_num:, location:, instance:, prediction_result:
              raise ::ArgumentError, "project_num cannot contain /" if project_num.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "instance cannot contain /" if instance.to_s.include? "/"

              "projects/#{project_num}/locations/#{location}/instances/#{instance}/predictionResults/#{prediction_result}"
            end

            extend self
          end
        end
      end
    end
  end
end
