# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/financial_services/v1/version"

require "google/cloud/financial_services/v1/aml/credentials"
require "google/cloud/financial_services/v1/aml/paths"
require "google/cloud/financial_services/v1/aml/operations"
require "google/cloud/financial_services/v1/aml/client"
require "google/cloud/financial_services/v1/aml/rest"

module Google
  module Cloud
    module FinancialServices
      module V1
        ##
        # The AML (Anti Money Laundering) service allows users to perform REST
        # operations on aml.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/financial_services/v1/aml"
        #     client = ::Google::Cloud::FinancialServices::V1::AML::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/financial_services/v1/aml/rest"
        #     client = ::Google::Cloud::FinancialServices::V1::AML::Rest::Client.new
        #
        module AML
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "aml", "helpers.rb"
require "google/cloud/financial_services/v1/aml/helpers" if ::File.file? helper_path
