# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Filestore
      module V1
        # Network configuration for the instance.
        # @!attribute [rw] network
        #   @return [::String]
        #     The name of the Google Compute Engine
        #     [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
        #     instance is connected.
        # @!attribute [rw] modes
        #   @return [::Array<::Google::Cloud::Filestore::V1::NetworkConfig::AddressMode>]
        #     Internet protocol versions for which the instance has IP addresses
        #     assigned. For this version, only MODE_IPV4 is supported.
        # @!attribute [rw] reserved_ip_range
        #   @return [::String]
        #     Optional, reserved_ip_range can have one of the following two types of
        #     values.
        #
        #     * CIDR range value when using DIRECT_PEERING connect mode.
        #     * [Allocated IP address
        #     range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
        #     when using PRIVATE_SERVICE_ACCESS connect mode.
        #
        #     When the name of an allocated IP address range is specified, it must be one
        #     of the ranges associated with the private service access connection.
        #     When specified as a direct CIDR value, it must be a /29 CIDR block for
        #     Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
        #     Enterprise tier in one of the [internal IP address
        #     ranges](https://www.arin.net/reference/research/statistics/address_filters/)
        #     that identifies the range of IP addresses reserved for this instance. For
        #     example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
        #     range you specify can't overlap with either existing subnets or assigned IP
        #     address ranges for other Filestore instances in the selected VPC
        #     network.
        # @!attribute [r] ip_addresses
        #   @return [::Array<::String>]
        #     Output only. IPv4 addresses in the format
        #     `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
        #     `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
        # @!attribute [rw] connect_mode
        #   @return [::Google::Cloud::Filestore::V1::NetworkConfig::ConnectMode]
        #     The network connect mode of the Filestore instance.
        #     If not provided, the connect mode defaults to DIRECT_PEERING.
        class NetworkConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Internet protocol versions supported by Filestore.
          module AddressMode
            # Internet protocol not set.
            ADDRESS_MODE_UNSPECIFIED = 0

            # Use the IPv4 internet protocol.
            MODE_IPV4 = 1
          end

          # Available connection modes.
          module ConnectMode
            # Not set.
            CONNECT_MODE_UNSPECIFIED = 0

            # Connect via direct peering to the Filestore service.
            DIRECT_PEERING = 1

            # Connect to your Filestore instance using Private Service
            # Access. Private services access provides an IP address range for multiple
            # Google Cloud services, including Filestore.
            PRIVATE_SERVICE_ACCESS = 2
          end
        end

        # File share configuration for the instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the file share. Must use 1-16 characters for the
        #     basic service tier and 1-63 characters for all other service tiers.
        #     Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
        #     start with a letter. Immutable.
        # @!attribute [rw] capacity_gb
        #   @return [::Integer]
        #     File share capacity in gigabytes (GB).
        #     Filestore defines 1 GB as 1024^3 bytes.
        # @!attribute [rw] source_backup
        #   @return [::String]
        #     The resource name of the backup, in the format
        #     `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
        #     that this file share has been restored from.
        # @!attribute [rw] nfs_export_options
        #   @return [::Array<::Google::Cloud::Filestore::V1::NfsExportOptions>]
        #     Nfs Export Options.
        #     There is a limit of 10 export options per file share.
        class FileShareConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # NFS export options specifications.
        # @!attribute [rw] ip_ranges
        #   @return [::Array<::String>]
        #     List of either an IPv4 addresses in the format
        #     `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
        #     `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
        #     file share.
        #     Overlapping IP ranges are not allowed, both within and across
        #     NfsExportOptions. An error will be returned.
        #     The limit is 64 IP ranges/addresses for each FileShareConfig among all
        #     NfsExportOptions.
        # @!attribute [rw] access_mode
        #   @return [::Google::Cloud::Filestore::V1::NfsExportOptions::AccessMode]
        #     Either READ_ONLY, for allowing only read requests on the exported
        #     directory, or READ_WRITE, for allowing both read and write requests.
        #     The default is READ_WRITE.
        # @!attribute [rw] squash_mode
        #   @return [::Google::Cloud::Filestore::V1::NfsExportOptions::SquashMode]
        #     Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
        #     or ROOT_SQUASH, for not allowing root access. The default is
        #     NO_ROOT_SQUASH.
        # @!attribute [rw] anon_uid
        #   @return [::Integer]
        #     An integer representing the anonymous user id with a default value of
        #     65534.
        #     Anon_uid may only be set with squash_mode of ROOT_SQUASH.  An error will be
        #     returned if this field is specified for other squash_mode settings.
        # @!attribute [rw] anon_gid
        #   @return [::Integer]
        #     An integer representing the anonymous group id with a default value of
        #     65534.
        #     Anon_gid may only be set with squash_mode of ROOT_SQUASH.  An error will be
        #     returned if this field is specified for other squash_mode settings.
        class NfsExportOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The access mode.
          module AccessMode
            # AccessMode not set.
            ACCESS_MODE_UNSPECIFIED = 0

            # The client can only read the file share.
            READ_ONLY = 1

            # The client can read and write the file share (default).
            READ_WRITE = 2
          end

          # The squash mode.
          module SquashMode
            # SquashMode not set.
            SQUASH_MODE_UNSPECIFIED = 0

            # The Root user has root access to the file share (default).
            NO_ROOT_SQUASH = 1

            # The Root user has squashed access to the anonymous uid/gid.
            ROOT_SQUASH = 2
          end
        end

        # Replica configuration for the instance.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Filestore::V1::ReplicaConfig::State]
        #     Output only. The replica state.
        # @!attribute [r] state_reasons
        #   @return [::Array<::Google::Cloud::Filestore::V1::ReplicaConfig::StateReason>]
        #     Output only. Additional information about the replication state, if
        #     available.
        # @!attribute [rw] peer_instance
        #   @return [::String]
        #     Optional. The peer instance.
        # @!attribute [r] last_active_sync_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of the latest replication snapshot taken on the
        #     active instance and is already replicated safely.
        class ReplicaConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The replica state.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # The replica is being created.
            CREATING = 1

            # The replica is ready.
            READY = 3

            # The replica is being removed.
            REMOVING = 4

            # The replica is experiencing an issue and might be unusable. You can get
            # further details from the `stateReasons` field of the `ReplicaConfig`
            # object.
            FAILED = 5
          end

          # Additional information about the replication state, if available.
          module StateReason
            # Reason not specified.
            STATE_REASON_UNSPECIFIED = 0

            # The peer instance is unreachable.
            PEER_INSTANCE_UNREACHABLE = 1

            # The remove replica peer instance operation failed.
            REMOVE_FAILED = 2
          end
        end

        # Replication specifications.
        # @!attribute [rw] role
        #   @return [::Google::Cloud::Filestore::V1::Replication::Role]
        #     Optional. The replication role.
        # @!attribute [rw] replicas
        #   @return [::Array<::Google::Cloud::Filestore::V1::ReplicaConfig>]
        #     Optional. Replication configuration for the replica instance associated
        #     with this instance. Only a single replica is supported.
        class Replication
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Replication role.
          module Role
            # Role not set.
            ROLE_UNSPECIFIED = 0

            # The instance is the `ACTIVE` replication member, functions as
            # the replication source instance.
            ACTIVE = 1

            # The instance is the `STANDBY` replication member, functions as
            # the replication destination instance.
            STANDBY = 2
          end
        end

        # A Filestore instance.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the instance, in the format
        #     `projects/{project}/locations/{location}/instances/{instance}`.
        # @!attribute [rw] description
        #   @return [::String]
        #     The description of the instance (2048 characters or less).
        # @!attribute [r] state
        #   @return [::Google::Cloud::Filestore::V1::Instance::State]
        #     Output only. The instance state.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Additional information about the instance state, if available.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the instance was created.
        # @!attribute [rw] tier
        #   @return [::Google::Cloud::Filestore::V1::Instance::Tier]
        #     The service tier of the instance.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Resource labels to represent user provided metadata.
        # @!attribute [rw] file_shares
        #   @return [::Array<::Google::Cloud::Filestore::V1::FileShareConfig>]
        #     File system shares on the instance.
        #     For this version, only a single file share is supported.
        # @!attribute [rw] networks
        #   @return [::Array<::Google::Cloud::Filestore::V1::NetworkConfig>]
        #     VPC networks to which the instance is connected.
        #     For this version, only a single network is supported.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Server-specified ETag for the instance resource to prevent simultaneous
        #     updates from overwriting each other.
        # @!attribute [r] satisfies_pzs
        #   @return [::Google::Protobuf::BoolValue]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     KMS key name used for data encryption.
        # @!attribute [r] suspension_reasons
        #   @return [::Array<::Google::Cloud::Filestore::V1::Instance::SuspensionReason>]
        #     Output only. Field indicates all the reasons the instance is in "SUSPENDED"
        #     state.
        # @!attribute [rw] replication
        #   @return [::Google::Cloud::Filestore::V1::Replication]
        #     Optional. Replication configuration.
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tag key-value pairs bound to this
        #     resource. Each key must be a namespaced name and each value a short name.
        #     Example:
        #     "123456789012/environment" : "production",
        #     "123456789013/costCenter" : "marketing"
        #     See the documentation for more information:
        #     - Namespaced name:
        #     https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing#retrieving_tag_key
        #     - Short name:
        #     https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing#retrieving_tag_value
        # @!attribute [rw] protocol
        #   @return [::Google::Cloud::Filestore::V1::Instance::FileProtocol]
        #     Immutable. The protocol indicates the access protocol for all shares in the
        #     instance. This field is immutable and it cannot be changed after the
        #     instance has been created. Default value: `NFS_V3`.
        # @!attribute [r] custom_performance_supported
        #   @return [::Boolean]
        #     Output only. Indicates whether this instance supports configuring its
        #     performance. If true, the user can configure the instance's performance by
        #     using the 'performance_config' field.
        # @!attribute [rw] performance_config
        #   @return [::Google::Cloud::Filestore::V1::Instance::PerformanceConfig]
        #     Optional. Used to configure performance.
        # @!attribute [r] performance_limits
        #   @return [::Google::Cloud::Filestore::V1::Instance::PerformanceLimits]
        #     Output only. Used for getting performance limits.
        # @!attribute [rw] deletion_protection_enabled
        #   @return [::Boolean]
        #     Optional. Indicates whether the instance is protected against deletion.
        # @!attribute [rw] deletion_protection_reason
        #   @return [::String]
        #     Optional. The reason for enabling deletion protection.
        class Instance
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # IOPS per TB.
          # Filestore defines TB as 1024^4 bytes (TiB).
          # @!attribute [rw] max_iops_per_tb
          #   @return [::Integer]
          #     Required. Maximum IOPS per TiB.
          class IOPSPerTB
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Fixed IOPS (input/output operations per second) parameters.
          # @!attribute [rw] max_iops
          #   @return [::Integer]
          #     Required. Maximum IOPS.
          class FixedIOPS
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Used for setting the performance configuration.
          # If the user doesn't specify PerformanceConfig, automatically provision
          # the default performance settings as described in
          # https://cloud.google.com/filestore/docs/performance. Larger instances will
          # be linearly set to more IOPS. If the instance's capacity is increased or
          # decreased, its performance will be automatically adjusted upwards or
          # downwards accordingly (respectively).
          # @!attribute [rw] iops_per_tb
          #   @return [::Google::Cloud::Filestore::V1::Instance::IOPSPerTB]
          #     Provision IOPS dynamically based on the capacity of the instance.
          #     Provisioned IOPS will be calculated by multiplying the capacity of the
          #     instance in TiB by the `iops_per_tb` value. For example, for a 2 TiB
          #     instance with an `iops_per_tb` value of 17000 the provisioned IOPS will
          #     be 34000.
          #
          #     If the calculated value is outside the supported range for the
          #     instance's capacity during instance creation, instance creation will
          #     fail with an `InvalidArgument` error. Similarly, if an instance
          #     capacity update would result in a value outside the supported range,
          #     the update will fail with an `InvalidArgument` error.
          #
          #     Note: The following fields are mutually exclusive: `iops_per_tb`, `fixed_iops`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] fixed_iops
          #   @return [::Google::Cloud::Filestore::V1::Instance::FixedIOPS]
          #     Choose a fixed provisioned IOPS value for the instance, which will
          #     remain constant regardless of instance capacity. Value must be a
          #     multiple of 1000.
          #
          #     If the chosen value is outside the supported range for the instance's
          #     capacity during instance creation, instance creation will fail with an
          #     `InvalidArgument` error. Similarly, if an instance capacity update
          #     would result in a value outside the supported range, the update will
          #     fail with an `InvalidArgument` error.
          #
          #     Note: The following fields are mutually exclusive: `fixed_iops`, `iops_per_tb`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class PerformanceConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The enforced performance limits, calculated from the instance's performance
          # configuration.
          # @!attribute [r] max_iops
          #   @return [::Integer]
          #     Output only. The max IOPS.
          # @!attribute [r] max_read_iops
          #   @return [::Integer]
          #     Output only. The max read IOPS.
          # @!attribute [r] max_write_iops
          #   @return [::Integer]
          #     Output only. The max write IOPS.
          # @!attribute [r] max_read_throughput_bps
          #   @return [::Integer]
          #     Output only. The max read throughput in bytes per second.
          # @!attribute [r] max_write_throughput_bps
          #   @return [::Integer]
          #     Output only. The max write throughput in bytes per second.
          class PerformanceLimits
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The instance state.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # The instance is being created.
            CREATING = 1

            # The instance is available for use.
            READY = 2

            # Work is being done on the instance. You can get further details from the
            # `statusMessage` field of the `Instance` resource.
            REPAIRING = 3

            # The instance is shutting down.
            DELETING = 4

            # The instance is experiencing an issue and might be unusable. You can get
            # further details from the `statusMessage` field of the `Instance`
            # resource.
            ERROR = 6

            # The instance is restoring a backup to an existing file share and may be
            # unusable during this time.
            RESTORING = 7

            # The instance is suspended. You can get further details from
            # the `suspension_reasons` field of the `Instance` resource.
            SUSPENDED = 8

            # The instance is in the process of becoming suspended.
            SUSPENDING = 9

            # The instance is in the process of becoming active.
            RESUMING = 10

            # The instance is reverting to a snapshot.
            REVERTING = 12

            # The replica instance is being promoted.
            PROMOTING = 13
          end

          # Available service tiers.
          module Tier
            # Not set.
            TIER_UNSPECIFIED = 0

            # STANDARD tier. BASIC_HDD is the preferred term for this tier.
            STANDARD = 1

            # PREMIUM tier. BASIC_SSD is the preferred term for this tier.
            PREMIUM = 2

            # BASIC instances offer a maximum capacity of 63.9 TB.
            # BASIC_HDD is an alias for STANDARD Tier, offering economical
            # performance backed by HDD.
            BASIC_HDD = 3

            # BASIC instances offer a maximum capacity of 63.9 TB.
            # BASIC_SSD is an alias for PREMIUM Tier, and offers improved
            # performance backed by SSD.
            BASIC_SSD = 4

            # HIGH_SCALE instances offer expanded capacity and performance scaling
            # capabilities.
            HIGH_SCALE_SSD = 5

            # ENTERPRISE instances offer the features and availability needed for
            # mission-critical workloads.
            ENTERPRISE = 6

            # ZONAL instances offer expanded capacity and performance scaling
            # capabilities.
            ZONAL = 7

            # REGIONAL instances offer the features and availability needed for
            # mission-critical workloads.
            REGIONAL = 8
          end

          # SuspensionReason contains the possible reasons for a suspension.
          module SuspensionReason
            # Not set.
            SUSPENSION_REASON_UNSPECIFIED = 0

            # The KMS key used by the instance is either revoked or denied access to.
            KMS_KEY_ISSUE = 1
          end

          # File access protocol.
          module FileProtocol
            # FILE_PROTOCOL_UNSPECIFIED serves a "not set" default value when
            # a FileProtocol is a separate field in a message.
            FILE_PROTOCOL_UNSPECIFIED = 0

            # NFS 3.0.
            NFS_V3 = 1

            # NFS 4.1.
            NFS_V4_1 = 2
          end
        end

        # CreateInstanceRequest creates an instance.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The instance's project and location, in the format
        #     `projects/{project_id}/locations/{location}`. In Filestore,
        #     locations map to Google Cloud zones, for example **us-west1-b**.
        # @!attribute [rw] instance_id
        #   @return [::String]
        #     Required. The name of the instance to create.
        #     The name must be unique for the specified project and location.
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::Filestore::V1::Instance]
        #     Required. An {::Google::Cloud::Filestore::V1::Instance instance resource}
        class CreateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetInstanceRequest gets the state of an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The instance resource name, in the format
        #     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
        class GetInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateInstanceRequest updates the settings of an instance.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask of fields to update.  At least one path must be supplied in this
        #     field.  The elements of the repeated paths field may only include these
        #     fields:
        #
        #     * "description"
        #     * "file_shares"
        #     * "labels"
        #     * "performance_config"
        #     * "deletion_protection_enabled"
        #     * "deletion_protection_reason"
        # @!attribute [rw] instance
        #   @return [::Google::Cloud::Filestore::V1::Instance]
        #     Only fields specified in update_mask are updated.
        class UpdateInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RestoreInstanceRequest restores an existing instance's file share from a
        # backup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the instance, in the format
        #     `projects/{project_number}/locations/{location_id}/instances/{instance_id}`.
        # @!attribute [rw] file_share
        #   @return [::String]
        #     Required. Name of the file share in the Filestore instance that the backup
        #     is being restored to.
        # @!attribute [rw] source_backup
        #   @return [::String]
        #     The resource name of the backup, in the format
        #     `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
        class RestoreInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RevertInstanceRequest reverts the given instance's file share to the
        # specified snapshot.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the instance, in the format
        #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`.
        # @!attribute [rw] target_snapshot_id
        #   @return [::String]
        #     Required. The snapshot resource ID, in the format 'my-snapshot', where the
        #     specified ID is the \\{snapshot_id} of the fully qualified name like
        #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}/snapshots/{snapshot_id}`
        class RevertInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteInstanceRequest deletes an instance.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The instance resource name, in the format
        #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     If set to true, all snapshots of the instance will also be deleted.
        #     (Otherwise, the request will only work if the instance has no snapshots.)
        class DeleteInstanceRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListInstancesRequest lists instances.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve instance
        #     information, in the format `projects/{project_id}/locations/{location}`. In
        #     Cloud Filestore, locations map to Google Cloud zones, for example
        #     **us-west1-b**. To retrieve instance information for all locations, use "-"
        #     for the
        #     `{location}` value.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value to use if there are additional
        #     results to retrieve for this list request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
        # @!attribute [rw] filter
        #   @return [::String]
        #     List filter.
        class ListInstancesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListInstancesResponse is the result of ListInstancesRequest.
        # @!attribute [rw] instances
        #   @return [::Array<::Google::Cloud::Filestore::V1::Instance>]
        #     A list of instances in the project for the specified location.
        #
        #     If the `{location}` value in the request is "-", the response contains a
        #     list of instances from all locations. If any location is unreachable, the
        #     response will only return instances in reachable locations and the
        #     "unreachable" field will be populated with a list of unreachable locations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token you can use to retrieve the next page of results. Not returned
        #     if there are no more results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListInstancesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Filestore snapshot.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the snapshot, in the format
        #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}/snapshots/{snapshot_id}`.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of the snapshot with 2048 characters or less.
        #     Requests with longer descriptions will be rejected.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Filestore::V1::Snapshot::State]
        #     Output only. The snapshot state.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the snapshot was created.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Resource labels to represent user provided metadata.
        # @!attribute [r] filesystem_used_bytes
        #   @return [::Integer]
        #     Output only. The amount of bytes needed to allocate a full copy of the
        #     snapshot content
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tag key-value pairs bound to this
        #     resource. Each key must be a namespaced name and each value a short name.
        #     Example:
        #     "123456789012/environment" : "production",
        #     "123456789013/costCenter" : "marketing"
        #     See the documentation for more information:
        #     - Namespaced name:
        #     https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing#retrieving_tag_key
        #     - Short name:
        #     https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing#retrieving_tag_value
        class Snapshot
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The snapshot state.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # Snapshot is being created.
            CREATING = 1

            # Snapshot is available for use.
            READY = 2

            # Snapshot is being deleted.
            DELETING = 3
          end
        end

        # CreateSnapshotRequest creates a snapshot.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The Filestore Instance to create the snapshots of, in the format
        #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
        # @!attribute [rw] snapshot_id
        #   @return [::String]
        #     Required. The ID to use for the snapshot.
        #     The ID must be unique within the specified instance.
        #
        #     This value must start with a lowercase letter followed by up to 62
        #     lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
        # @!attribute [rw] snapshot
        #   @return [::Google::Cloud::Filestore::V1::Snapshot]
        #     Required. A snapshot resource.
        class CreateSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetSnapshotRequest gets the state of a snapshot.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The snapshot resource name, in the format
        #     `projects/{project_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_id}`
        class GetSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteSnapshotRequest deletes a snapshot.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The snapshot resource name, in the format
        #     `projects/{project_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_id}`
        class DeleteSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateSnapshotRequest updates description and/or labels for a snapshot.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update. At least one path must be supplied in
        #     this field.
        # @!attribute [rw] snapshot
        #   @return [::Google::Cloud::Filestore::V1::Snapshot]
        #     Required. A snapshot resource.
        class UpdateSnapshotRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListSnapshotsRequest lists snapshots.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The instance for which to retrieve snapshot information,
        #     in the format
        #     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value to use if there are additional
        #     results to retrieve for this list request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
        # @!attribute [rw] filter
        #   @return [::String]
        #     List filter.
        # @!attribute [rw] return_partial_success
        #   @return [::Boolean]
        #     Optional. If true, allow partial responses for multi-regional Aggregated
        #     List requests.
        class ListSnapshotsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListSnapshotsResponse is the result of ListSnapshotsRequest.
        # @!attribute [rw] snapshots
        #   @return [::Array<::Google::Cloud::Filestore::V1::Snapshot>]
        #     A list of snapshots in the project for the specified instance.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token you can use to retrieve the next page of results. Not returned
        #     if there are no more results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListSnapshotsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A Filestore backup.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The resource name of the backup, in the format
        #     `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of the backup with 2048 characters or less.
        #     Requests with longer descriptions will be rejected.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Filestore::V1::Backup::State]
        #     Output only. The backup state.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the backup was created.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Resource labels to represent user provided metadata.
        # @!attribute [r] capacity_gb
        #   @return [::Integer]
        #     Output only. Capacity of the source file share when the backup was created.
        # @!attribute [r] storage_bytes
        #   @return [::Integer]
        #     Output only. The size of the storage used by the backup. As backups share
        #     storage, this number is expected to change with backup creation/deletion.
        # @!attribute [rw] source_instance
        #   @return [::String]
        #     The resource name of the source Filestore instance, in the format
        #     `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
        #     used to create this backup.
        # @!attribute [rw] source_file_share
        #   @return [::String]
        #     Name of the file share in the source Filestore instance that the
        #     backup is created from.
        # @!attribute [r] source_instance_tier
        #   @return [::Google::Cloud::Filestore::V1::Instance::Tier]
        #     Output only. The service tier of the source Filestore instance that this
        #     backup is created from.
        # @!attribute [r] download_bytes
        #   @return [::Integer]
        #     Output only. Amount of bytes that will be downloaded if the backup is
        #     restored. This may be different than storage bytes, since sequential
        #     backups of the same disk will share storage.
        # @!attribute [r] satisfies_pzs
        #   @return [::Google::Protobuf::BoolValue]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] kms_key
        #   @return [::String]
        #     Immutable. KMS key name used for data encryption.
        # @!attribute [rw] tags
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Input only. Immutable. Tag key-value pairs bound to this
        #     resource. Each key must be a namespaced name and each value a short name.
        #     Example:
        #     "123456789012/environment" : "production",
        #     "123456789013/costCenter" : "marketing"
        #     See the documentation for more information:
        #     - Namespaced name:
        #     https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing#retrieving_tag_key
        #     - Short name:
        #     https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing#retrieving_tag_value
        # @!attribute [r] file_system_protocol
        #   @return [::Google::Cloud::Filestore::V1::Instance::FileProtocol]
        #     Output only. The file system protocol of the source Filestore instance that
        #     this backup is created from.
        class Backup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class TagsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The backup state.
          module State
            # State not set.
            STATE_UNSPECIFIED = 0

            # Backup is being created.
            CREATING = 1

            # Backup has been taken and the operation is being finalized. At this
            # point, changes to the file share will not be reflected in the backup.
            FINALIZING = 2

            # Backup is available for use.
            READY = 3

            # Backup is being deleted.
            DELETING = 4

            # Backup is not valid and cannot be used for creating new instances or
            # restoring existing instances.
            INVALID = 5
          end
        end

        # CreateBackupRequest creates a backup.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The backup's project and location, in the format
        #     `projects/{project_number}/locations/{location}`. In Filestore,
        #     backup locations map to Google Cloud regions, for example **us-west1**.
        # @!attribute [rw] backup
        #   @return [::Google::Cloud::Filestore::V1::Backup]
        #     Required. A {::Google::Cloud::Filestore::V1::Backup backup resource}
        # @!attribute [rw] backup_id
        #   @return [::String]
        #     Required. The ID to use for the backup.
        #     The ID must be unique within the specified project and location.
        #
        #     This value must start with a lowercase letter followed by up to 62
        #     lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
        #     Values that do not match this pattern will trigger an INVALID_ARGUMENT
        #     error.
        class CreateBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeleteBackupRequest deletes a backup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The backup resource name, in the format
        #     `projects/{project_number}/locations/{location}/backups/{backup_id}`
        class DeleteBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # UpdateBackupRequest updates description and/or labels for a backup.
        # @!attribute [rw] backup
        #   @return [::Google::Cloud::Filestore::V1::Backup]
        #     Required. A {::Google::Cloud::Filestore::V1::Backup backup resource}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.  At least one path must be supplied in
        #     this field.
        class UpdateBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PromoteReplicaRequest promotes a Filestore standby instance (replica).
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the instance, in the format
        #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`.
        # @!attribute [rw] peer_instance
        #   @return [::String]
        #     Optional. The resource name of the peer instance to promote, in the format
        #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`.
        #     The peer instance is required if the operation is called on an active
        #     instance.
        class PromoteReplicaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetBackupRequest gets the state of a backup.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The backup resource name, in the format
        #     `projects/{project_number}/locations/{location}/backups/{backup_id}`.
        class GetBackupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListBackupsRequest lists backups.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The project and location for which to retrieve backup
        #     information, in the format
        #     `projects/{project_number}/locations/{location}`. In Filestore, backup
        #     locations map to Google Cloud regions, for example **us-west1**. To
        #     retrieve backup information for all locations, use "-" for the
        #     `{location}` value.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of items to return.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The next_page_token value to use if there are additional
        #     results to retrieve for this list request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
        # @!attribute [rw] filter
        #   @return [::String]
        #     List filter.
        class ListBackupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListBackupsResponse is the result of ListBackupsRequest.
        # @!attribute [rw] backups
        #   @return [::Array<::Google::Cloud::Filestore::V1::Backup>]
        #     A list of backups in the project for the specified location.
        #
        #     If the `{location}` value in the request is "-", the response contains a
        #     list of backups from all locations. If any location is unreachable, the
        #     response will only return backups in reachable locations and the
        #     "unreachable" field will be populated with a list of unreachable
        #     locations.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The token you can use to retrieve the next page of results. Not returned
        #     if there are no more results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Unordered list. Locations that could not be reached.
        class ListBackupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
