# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/filestore/v1/cloud_filestore_service.proto for package 'google.cloud.filestore.v1'
# Original file comments:
# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/filestore/v1/cloud_filestore_service_pb'

module Google
  module Cloud
    module Filestore
      module V1
        module CloudFilestoreManager
          # Configures and manages Filestore resources.
          #
          # Filestore Manager v1.
          #
          # The `file.googleapis.com` service implements the Filestore API and
          # defines the following resource model for managing instances:
          # * The service works with a collection of cloud projects, named: `/projects/*`
          # * Each project has a collection of available locations, named: `/locations/*`
          # * Each location has a collection of instances and backups, named:
          # `/instances/*` and `/backups/*` respectively.
          # * As such, Filestore instances are resources of the form:
          #   `/projects/{project_number}/locations/{location_id}/instances/{instance_id}`
          #   and backups are resources of the form:
          #   `/projects/{project_number}/locations/{location_id}/backup/{backup_id}`
          #
          # Note that location_id must be a Google Cloud `zone` for instances, but
          # a Google Cloud `region` for backups; for example:
          # * `projects/12345/locations/us-central1-c/instances/my-filestore`
          # * `projects/12345/locations/us-central1/backups/my-backup`
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.filestore.v1.CloudFilestoreManager'

            # Lists all instances in a project for either a specified location
            # or for all locations.
            rpc :ListInstances, ::Google::Cloud::Filestore::V1::ListInstancesRequest, ::Google::Cloud::Filestore::V1::ListInstancesResponse
            # Gets the details of a specific instance.
            rpc :GetInstance, ::Google::Cloud::Filestore::V1::GetInstanceRequest, ::Google::Cloud::Filestore::V1::Instance
            # Creates an instance.
            # When creating from a backup, the capacity of the new instance needs to be
            # equal to or larger than the capacity of the backup (and also equal to or
            # larger than the minimum capacity of the tier).
            rpc :CreateInstance, ::Google::Cloud::Filestore::V1::CreateInstanceRequest, ::Google::Longrunning::Operation
            # Updates the settings of a specific instance.
            rpc :UpdateInstance, ::Google::Cloud::Filestore::V1::UpdateInstanceRequest, ::Google::Longrunning::Operation
            # Restores an existing instance's file share from a backup.
            #
            # The capacity of the instance needs to be equal to or larger than the
            # capacity of the backup (and also equal to or larger than the minimum
            # capacity of the tier).
            rpc :RestoreInstance, ::Google::Cloud::Filestore::V1::RestoreInstanceRequest, ::Google::Longrunning::Operation
            # Revert an existing instance's file system to a specified snapshot.
            rpc :RevertInstance, ::Google::Cloud::Filestore::V1::RevertInstanceRequest, ::Google::Longrunning::Operation
            # Deletes an instance.
            rpc :DeleteInstance, ::Google::Cloud::Filestore::V1::DeleteInstanceRequest, ::Google::Longrunning::Operation
            # Lists all snapshots in a project for either a specified location
            # or for all locations.
            rpc :ListSnapshots, ::Google::Cloud::Filestore::V1::ListSnapshotsRequest, ::Google::Cloud::Filestore::V1::ListSnapshotsResponse
            # Gets the details of a specific snapshot.
            rpc :GetSnapshot, ::Google::Cloud::Filestore::V1::GetSnapshotRequest, ::Google::Cloud::Filestore::V1::Snapshot
            # Creates a snapshot.
            rpc :CreateSnapshot, ::Google::Cloud::Filestore::V1::CreateSnapshotRequest, ::Google::Longrunning::Operation
            # Deletes a snapshot.
            rpc :DeleteSnapshot, ::Google::Cloud::Filestore::V1::DeleteSnapshotRequest, ::Google::Longrunning::Operation
            # Updates the settings of a specific snapshot.
            rpc :UpdateSnapshot, ::Google::Cloud::Filestore::V1::UpdateSnapshotRequest, ::Google::Longrunning::Operation
            # Lists all backups in a project for either a specified location or for all
            # locations.
            rpc :ListBackups, ::Google::Cloud::Filestore::V1::ListBackupsRequest, ::Google::Cloud::Filestore::V1::ListBackupsResponse
            # Gets the details of a specific backup.
            rpc :GetBackup, ::Google::Cloud::Filestore::V1::GetBackupRequest, ::Google::Cloud::Filestore::V1::Backup
            # Creates a backup.
            rpc :CreateBackup, ::Google::Cloud::Filestore::V1::CreateBackupRequest, ::Google::Longrunning::Operation
            # Deletes a backup.
            rpc :DeleteBackup, ::Google::Cloud::Filestore::V1::DeleteBackupRequest, ::Google::Longrunning::Operation
            # Updates the settings of a specific backup.
            rpc :UpdateBackup, ::Google::Cloud::Filestore::V1::UpdateBackupRequest, ::Google::Longrunning::Operation
            # Promote the standby instance (replica).
            rpc :PromoteReplica, ::Google::Cloud::Filestore::V1::PromoteReplicaRequest, ::Google::Longrunning::Operation
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
