# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/filestore/v1/cloud_filestore_service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module Filestore
      module V1
        module CloudFilestoreManager
          ##
          # Client for the CloudFilestoreManager service.
          #
          # Configures and manages Filestore resources.
          #
          # Filestore Manager v1.
          #
          # The `file.googleapis.com` service implements the Filestore API and
          # defines the following resource model for managing instances:
          # * The service works with a collection of cloud projects, named: `/projects/*`
          # * Each project has a collection of available locations, named: `/locations/*`
          # * Each location has a collection of instances and backups, named:
          # `/instances/*` and `/backups/*` respectively.
          # * As such, Filestore instances are resources of the form:
          #   `/projects/{project_number}/locations/{location_id}/instances/{instance_id}`
          #   and backups are resources of the form:
          #   `/projects/{project_number}/locations/{location_id}/backup/{backup_id}`
          #
          # Note that location_id must be a Google Cloud `zone` for instances, but
          # a Google Cloud `region` for backups; for example:
          # * `projects/12345/locations/us-central1-c/instances/my-filestore`
          # * `projects/12345/locations/us-central1/backups/my-backup`
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "file.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :cloud_filestore_manager_stub

            ##
            # Configure the CloudFilestoreManager Client class.
            #
            # See {::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all CloudFilestoreManager clients
            #   ::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Filestore", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_instances.timeout = 60.0
                default_config.rpcs.list_instances.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_instance.timeout = 60.0
                default_config.rpcs.get_instance.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_instance.timeout = 60_000.0

                default_config.rpcs.update_instance.timeout = 14_400.0

                default_config.rpcs.restore_instance.timeout = 60_000.0

                default_config.rpcs.delete_instance.timeout = 600.0

                default_config.rpcs.list_backups.timeout = 60.0
                default_config.rpcs.list_backups.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_backup.timeout = 60.0
                default_config.rpcs.get_backup.retry_policy = {
                  initial_delay: 0.25, max_delay: 32.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_backup.timeout = 60_000.0

                default_config.rpcs.delete_backup.timeout = 600.0

                default_config.rpcs.update_backup.timeout = 600.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the CloudFilestoreManager Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @cloud_filestore_manager_stub.universe_domain
            end

            ##
            # Create a new CloudFilestoreManager client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the CloudFilestoreManager client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/filestore/v1/cloud_filestore_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @cloud_filestore_manager_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Filestore::V1::CloudFilestoreManager::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @cloud_filestore_manager_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @cloud_filestore_manager_stub.endpoint
                config.universe_domain = @cloud_filestore_manager_stub.universe_domain
                config.logger = @cloud_filestore_manager_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Filestore::V1::CloudFilestoreManager::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @cloud_filestore_manager_stub.logger
            end

            # Service calls

            ##
            # Lists all instances in a project for either a specified location
            # or for all locations.
            #
            # @overload list_instances(request, options = nil)
            #   Pass arguments to `list_instances` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::ListInstancesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::ListInstancesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_instances(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_instances` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve instance
            #     information, in the format `projects/{project_id}/locations/{location}`. In
            #     Cloud Filestore, locations map to Google Cloud zones, for example
            #     **us-west1-b**. To retrieve instance information for all locations, use "-"
            #     for the
            #     `{location}` value.
            #   @param page_size [::Integer]
            #     The maximum number of items to return.
            #   @param page_token [::String]
            #     The next_page_token value to use if there are additional
            #     results to retrieve for this list request.
            #   @param order_by [::String]
            #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
            #   @param filter [::String]
            #     List filter.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Filestore::V1::Instance>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Filestore::V1::Instance>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::ListInstancesRequest.new
            #
            #   # Call the list_instances method.
            #   result = client.list_instances request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Filestore::V1::Instance.
            #     p item
            #   end
            #
            def list_instances request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::ListInstancesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_instances.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_instances.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_instances.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :list_instances, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cloud_filestore_manager_stub, :list_instances, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a specific instance.
            #
            # @overload get_instance(request, options = nil)
            #   Pass arguments to `get_instance` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::GetInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::GetInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_instance(name: nil)
            #   Pass arguments to `get_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The instance resource name, in the format
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Filestore::V1::Instance]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Filestore::V1::Instance]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::GetInstanceRequest.new
            #
            #   # Call the get_instance method.
            #   result = client.get_instance request
            #
            #   # The returned object is of type Google::Cloud::Filestore::V1::Instance.
            #   p result
            #
            def get_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::GetInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :get_instance, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates an instance.
            # When creating from a backup, the capacity of the new instance needs to be
            # equal to or larger than the capacity of the backup (and also equal to or
            # larger than the minimum capacity of the tier).
            #
            # @overload create_instance(request, options = nil)
            #   Pass arguments to `create_instance` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::CreateInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::CreateInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_instance(parent: nil, instance_id: nil, instance: nil)
            #   Pass arguments to `create_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The instance's project and location, in the format
            #     `projects/{project_id}/locations/{location}`. In Filestore,
            #     locations map to Google Cloud zones, for example **us-west1-b**.
            #   @param instance_id [::String]
            #     Required. The name of the instance to create.
            #     The name must be unique for the specified project and location.
            #   @param instance [::Google::Cloud::Filestore::V1::Instance, ::Hash]
            #     Required. An {::Google::Cloud::Filestore::V1::Instance instance resource}
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::CreateInstanceRequest.new
            #
            #   # Call the create_instance method.
            #   result = client.create_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::CreateInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :create_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the settings of a specific instance.
            #
            # @overload update_instance(request, options = nil)
            #   Pass arguments to `update_instance` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::UpdateInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::UpdateInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_instance(update_mask: nil, instance: nil)
            #   Pass arguments to `update_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Mask of fields to update.  At least one path must be supplied in this
            #     field.  The elements of the repeated paths field may only include these
            #     fields:
            #
            #     * "description"
            #     * "file_shares"
            #     * "labels"
            #     * "performance_config"
            #     * "deletion_protection_enabled"
            #     * "deletion_protection_reason"
            #   @param instance [::Google::Cloud::Filestore::V1::Instance, ::Hash]
            #     Only fields specified in update_mask are updated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::UpdateInstanceRequest.new
            #
            #   # Call the update_instance method.
            #   result = client.update_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::UpdateInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.instance&.name
                header_params["instance.name"] = request.instance.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :update_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Restores an existing instance's file share from a backup.
            #
            # The capacity of the instance needs to be equal to or larger than the
            # capacity of the backup (and also equal to or larger than the minimum
            # capacity of the tier).
            #
            # @overload restore_instance(request, options = nil)
            #   Pass arguments to `restore_instance` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::RestoreInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::RestoreInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload restore_instance(name: nil, file_share: nil, source_backup: nil)
            #   Pass arguments to `restore_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the instance, in the format
            #     `projects/{project_number}/locations/{location_id}/instances/{instance_id}`.
            #   @param file_share [::String]
            #     Required. Name of the file share in the Filestore instance that the backup
            #     is being restored to.
            #   @param source_backup [::String]
            #     The resource name of the backup, in the format
            #     `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::RestoreInstanceRequest.new
            #
            #   # Call the restore_instance method.
            #   result = client.restore_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def restore_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::RestoreInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.restore_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.restore_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.restore_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :restore_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Revert an existing instance's file system to a specified snapshot.
            #
            # @overload revert_instance(request, options = nil)
            #   Pass arguments to `revert_instance` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::RevertInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::RevertInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload revert_instance(name: nil, target_snapshot_id: nil)
            #   Pass arguments to `revert_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the instance, in the format
            #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`.
            #   @param target_snapshot_id [::String]
            #     Required. The snapshot resource ID, in the format 'my-snapshot', where the
            #     specified ID is the \\{snapshot_id} of the fully qualified name like
            #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}/snapshots/{snapshot_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::RevertInstanceRequest.new
            #
            #   # Call the revert_instance method.
            #   result = client.revert_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def revert_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::RevertInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.revert_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.revert_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.revert_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :revert_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes an instance.
            #
            # @overload delete_instance(request, options = nil)
            #   Pass arguments to `delete_instance` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::DeleteInstanceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::DeleteInstanceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_instance(name: nil, force: nil)
            #   Pass arguments to `delete_instance` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The instance resource name, in the format
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #   @param force [::Boolean]
            #     If set to true, all snapshots of the instance will also be deleted.
            #     (Otherwise, the request will only work if the instance has no snapshots.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::DeleteInstanceRequest.new
            #
            #   # Call the delete_instance method.
            #   result = client.delete_instance request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_instance request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::DeleteInstanceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_instance.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_instance.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_instance.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :delete_instance, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all snapshots in a project for either a specified location
            # or for all locations.
            #
            # @overload list_snapshots(request, options = nil)
            #   Pass arguments to `list_snapshots` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::ListSnapshotsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::ListSnapshotsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_snapshots(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil, return_partial_success: nil)
            #   Pass arguments to `list_snapshots` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The instance for which to retrieve snapshot information,
            #     in the format
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`.
            #   @param page_size [::Integer]
            #     The maximum number of items to return.
            #   @param page_token [::String]
            #     The next_page_token value to use if there are additional
            #     results to retrieve for this list request.
            #   @param order_by [::String]
            #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
            #   @param filter [::String]
            #     List filter.
            #   @param return_partial_success [::Boolean]
            #     Optional. If true, allow partial responses for multi-regional Aggregated
            #     List requests.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Filestore::V1::Snapshot>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Filestore::V1::Snapshot>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::ListSnapshotsRequest.new
            #
            #   # Call the list_snapshots method.
            #   result = client.list_snapshots request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Filestore::V1::Snapshot.
            #     p item
            #   end
            #
            def list_snapshots request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::ListSnapshotsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_snapshots.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_snapshots.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_snapshots.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :list_snapshots, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cloud_filestore_manager_stub, :list_snapshots, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a specific snapshot.
            #
            # @overload get_snapshot(request, options = nil)
            #   Pass arguments to `get_snapshot` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::GetSnapshotRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::GetSnapshotRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_snapshot(name: nil)
            #   Pass arguments to `get_snapshot` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The snapshot resource name, in the format
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Filestore::V1::Snapshot]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Filestore::V1::Snapshot]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::GetSnapshotRequest.new
            #
            #   # Call the get_snapshot method.
            #   result = client.get_snapshot request
            #
            #   # The returned object is of type Google::Cloud::Filestore::V1::Snapshot.
            #   p result
            #
            def get_snapshot request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::GetSnapshotRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_snapshot.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_snapshot.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_snapshot.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :get_snapshot, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a snapshot.
            #
            # @overload create_snapshot(request, options = nil)
            #   Pass arguments to `create_snapshot` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::CreateSnapshotRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::CreateSnapshotRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_snapshot(parent: nil, snapshot_id: nil, snapshot: nil)
            #   Pass arguments to `create_snapshot` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The Filestore Instance to create the snapshots of, in the format
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}`
            #   @param snapshot_id [::String]
            #     Required. The ID to use for the snapshot.
            #     The ID must be unique within the specified instance.
            #
            #     This value must start with a lowercase letter followed by up to 62
            #     lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
            #   @param snapshot [::Google::Cloud::Filestore::V1::Snapshot, ::Hash]
            #     Required. A snapshot resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::CreateSnapshotRequest.new
            #
            #   # Call the create_snapshot method.
            #   result = client.create_snapshot request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_snapshot request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::CreateSnapshotRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_snapshot.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_snapshot.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_snapshot.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :create_snapshot, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a snapshot.
            #
            # @overload delete_snapshot(request, options = nil)
            #   Pass arguments to `delete_snapshot` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::DeleteSnapshotRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::DeleteSnapshotRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_snapshot(name: nil)
            #   Pass arguments to `delete_snapshot` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The snapshot resource name, in the format
            #     `projects/{project_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::DeleteSnapshotRequest.new
            #
            #   # Call the delete_snapshot method.
            #   result = client.delete_snapshot request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_snapshot request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::DeleteSnapshotRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_snapshot.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_snapshot.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_snapshot.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :delete_snapshot, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the settings of a specific snapshot.
            #
            # @overload update_snapshot(request, options = nil)
            #   Pass arguments to `update_snapshot` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::UpdateSnapshotRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::UpdateSnapshotRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_snapshot(update_mask: nil, snapshot: nil)
            #   Pass arguments to `update_snapshot` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update. At least one path must be supplied in
            #     this field.
            #   @param snapshot [::Google::Cloud::Filestore::V1::Snapshot, ::Hash]
            #     Required. A snapshot resource.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::UpdateSnapshotRequest.new
            #
            #   # Call the update_snapshot method.
            #   result = client.update_snapshot request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_snapshot request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::UpdateSnapshotRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_snapshot.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.snapshot&.name
                header_params["snapshot.name"] = request.snapshot.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_snapshot.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_snapshot.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :update_snapshot, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all backups in a project for either a specified location or for all
            # locations.
            #
            # @overload list_backups(request, options = nil)
            #   Pass arguments to `list_backups` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::ListBackupsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::ListBackupsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_backups(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_backups` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The project and location for which to retrieve backup
            #     information, in the format
            #     `projects/{project_number}/locations/{location}`. In Filestore, backup
            #     locations map to Google Cloud regions, for example **us-west1**. To
            #     retrieve backup information for all locations, use "-" for the
            #     `{location}` value.
            #   @param page_size [::Integer]
            #     The maximum number of items to return.
            #   @param page_token [::String]
            #     The next_page_token value to use if there are additional
            #     results to retrieve for this list request.
            #   @param order_by [::String]
            #     Sort results. Supported values are "name", "name desc" or "" (unsorted).
            #   @param filter [::String]
            #     List filter.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Filestore::V1::Backup>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Filestore::V1::Backup>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::ListBackupsRequest.new
            #
            #   # Call the list_backups method.
            #   result = client.list_backups request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Filestore::V1::Backup.
            #     p item
            #   end
            #
            def list_backups request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::ListBackupsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_backups.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_backups.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_backups.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :list_backups, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @cloud_filestore_manager_stub, :list_backups, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the details of a specific backup.
            #
            # @overload get_backup(request, options = nil)
            #   Pass arguments to `get_backup` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::GetBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::GetBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_backup(name: nil)
            #   Pass arguments to `get_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The backup resource name, in the format
            #     `projects/{project_number}/locations/{location}/backups/{backup_id}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Filestore::V1::Backup]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Filestore::V1::Backup]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::GetBackupRequest.new
            #
            #   # Call the get_backup method.
            #   result = client.get_backup request
            #
            #   # The returned object is of type Google::Cloud::Filestore::V1::Backup.
            #   p result
            #
            def get_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::GetBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :get_backup, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a backup.
            #
            # @overload create_backup(request, options = nil)
            #   Pass arguments to `create_backup` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::CreateBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::CreateBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_backup(parent: nil, backup: nil, backup_id: nil)
            #   Pass arguments to `create_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The backup's project and location, in the format
            #     `projects/{project_number}/locations/{location}`. In Filestore,
            #     backup locations map to Google Cloud regions, for example **us-west1**.
            #   @param backup [::Google::Cloud::Filestore::V1::Backup, ::Hash]
            #     Required. A {::Google::Cloud::Filestore::V1::Backup backup resource}
            #   @param backup_id [::String]
            #     Required. The ID to use for the backup.
            #     The ID must be unique within the specified project and location.
            #
            #     This value must start with a lowercase letter followed by up to 62
            #     lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
            #     Values that do not match this pattern will trigger an INVALID_ARGUMENT
            #     error.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::CreateBackupRequest.new
            #
            #   # Call the create_backup method.
            #   result = client.create_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::CreateBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :create_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a backup.
            #
            # @overload delete_backup(request, options = nil)
            #   Pass arguments to `delete_backup` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::DeleteBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::DeleteBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_backup(name: nil)
            #   Pass arguments to `delete_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The backup resource name, in the format
            #     `projects/{project_number}/locations/{location}/backups/{backup_id}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::DeleteBackupRequest.new
            #
            #   # Call the delete_backup method.
            #   result = client.delete_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::DeleteBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :delete_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the settings of a specific backup.
            #
            # @overload update_backup(request, options = nil)
            #   Pass arguments to `update_backup` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::UpdateBackupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::UpdateBackupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_backup(backup: nil, update_mask: nil)
            #   Pass arguments to `update_backup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param backup [::Google::Cloud::Filestore::V1::Backup, ::Hash]
            #     Required. A {::Google::Cloud::Filestore::V1::Backup backup resource}
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Mask of fields to update.  At least one path must be supplied in
            #     this field.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::UpdateBackupRequest.new
            #
            #   # Call the update_backup method.
            #   result = client.update_backup request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_backup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::UpdateBackupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_backup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.backup&.name
                header_params["backup.name"] = request.backup.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_backup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_backup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :update_backup, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Promote the standby instance (replica).
            #
            # @overload promote_replica(request, options = nil)
            #   Pass arguments to `promote_replica` via a request object, either of type
            #   {::Google::Cloud::Filestore::V1::PromoteReplicaRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Filestore::V1::PromoteReplicaRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload promote_replica(name: nil, peer_instance: nil)
            #   Pass arguments to `promote_replica` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the instance, in the format
            #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`.
            #   @param peer_instance [::String]
            #     Optional. The resource name of the peer instance to promote, in the format
            #     `projects/{project_id}/locations/{location_id}/instances/{instance_id}`.
            #     The peer instance is required if the operation is called on an active
            #     instance.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/filestore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Filestore::V1::PromoteReplicaRequest.new
            #
            #   # Call the promote_replica method.
            #   result = client.promote_replica request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def promote_replica request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Filestore::V1::PromoteReplicaRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.promote_replica.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Filestore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.promote_replica.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.promote_replica.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @cloud_filestore_manager_stub.call_rpc :promote_replica, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the CloudFilestoreManager API.
            #
            # This class represents the configuration for CloudFilestoreManager,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_instances to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_instances.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_instances.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Filestore::V1::CloudFilestoreManager::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "file.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the CloudFilestoreManager API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_instances`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_instances
                ##
                # RPC-specific configuration for `get_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_instance
                ##
                # RPC-specific configuration for `create_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_instance
                ##
                # RPC-specific configuration for `update_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_instance
                ##
                # RPC-specific configuration for `restore_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :restore_instance
                ##
                # RPC-specific configuration for `revert_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :revert_instance
                ##
                # RPC-specific configuration for `delete_instance`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_instance
                ##
                # RPC-specific configuration for `list_snapshots`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_snapshots
                ##
                # RPC-specific configuration for `get_snapshot`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_snapshot
                ##
                # RPC-specific configuration for `create_snapshot`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_snapshot
                ##
                # RPC-specific configuration for `delete_snapshot`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_snapshot
                ##
                # RPC-specific configuration for `update_snapshot`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_snapshot
                ##
                # RPC-specific configuration for `list_backups`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_backups
                ##
                # RPC-specific configuration for `get_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_backup
                ##
                # RPC-specific configuration for `create_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_backup
                ##
                # RPC-specific configuration for `delete_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_backup
                ##
                # RPC-specific configuration for `update_backup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_backup
                ##
                # RPC-specific configuration for `promote_replica`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :promote_replica

                # @private
                def initialize parent_rpcs = nil
                  list_instances_config = parent_rpcs.list_instances if parent_rpcs.respond_to? :list_instances
                  @list_instances = ::Gapic::Config::Method.new list_instances_config
                  get_instance_config = parent_rpcs.get_instance if parent_rpcs.respond_to? :get_instance
                  @get_instance = ::Gapic::Config::Method.new get_instance_config
                  create_instance_config = parent_rpcs.create_instance if parent_rpcs.respond_to? :create_instance
                  @create_instance = ::Gapic::Config::Method.new create_instance_config
                  update_instance_config = parent_rpcs.update_instance if parent_rpcs.respond_to? :update_instance
                  @update_instance = ::Gapic::Config::Method.new update_instance_config
                  restore_instance_config = parent_rpcs.restore_instance if parent_rpcs.respond_to? :restore_instance
                  @restore_instance = ::Gapic::Config::Method.new restore_instance_config
                  revert_instance_config = parent_rpcs.revert_instance if parent_rpcs.respond_to? :revert_instance
                  @revert_instance = ::Gapic::Config::Method.new revert_instance_config
                  delete_instance_config = parent_rpcs.delete_instance if parent_rpcs.respond_to? :delete_instance
                  @delete_instance = ::Gapic::Config::Method.new delete_instance_config
                  list_snapshots_config = parent_rpcs.list_snapshots if parent_rpcs.respond_to? :list_snapshots
                  @list_snapshots = ::Gapic::Config::Method.new list_snapshots_config
                  get_snapshot_config = parent_rpcs.get_snapshot if parent_rpcs.respond_to? :get_snapshot
                  @get_snapshot = ::Gapic::Config::Method.new get_snapshot_config
                  create_snapshot_config = parent_rpcs.create_snapshot if parent_rpcs.respond_to? :create_snapshot
                  @create_snapshot = ::Gapic::Config::Method.new create_snapshot_config
                  delete_snapshot_config = parent_rpcs.delete_snapshot if parent_rpcs.respond_to? :delete_snapshot
                  @delete_snapshot = ::Gapic::Config::Method.new delete_snapshot_config
                  update_snapshot_config = parent_rpcs.update_snapshot if parent_rpcs.respond_to? :update_snapshot
                  @update_snapshot = ::Gapic::Config::Method.new update_snapshot_config
                  list_backups_config = parent_rpcs.list_backups if parent_rpcs.respond_to? :list_backups
                  @list_backups = ::Gapic::Config::Method.new list_backups_config
                  get_backup_config = parent_rpcs.get_backup if parent_rpcs.respond_to? :get_backup
                  @get_backup = ::Gapic::Config::Method.new get_backup_config
                  create_backup_config = parent_rpcs.create_backup if parent_rpcs.respond_to? :create_backup
                  @create_backup = ::Gapic::Config::Method.new create_backup_config
                  delete_backup_config = parent_rpcs.delete_backup if parent_rpcs.respond_to? :delete_backup
                  @delete_backup = ::Gapic::Config::Method.new delete_backup_config
                  update_backup_config = parent_rpcs.update_backup if parent_rpcs.respond_to? :update_backup
                  @update_backup = ::Gapic::Config::Method.new update_backup_config
                  promote_replica_config = parent_rpcs.promote_replica if parent_rpcs.respond_to? :promote_replica
                  @promote_replica = ::Gapic::Config::Method.new promote_replica_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
