# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/eventarc/v1/eventarc_pb"
require "google/cloud/eventarc/v1/eventarc"

class ::Google::Cloud::Eventarc::V1::Eventarc::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::Trigger.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_trigger, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetTriggerRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_trigger({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_trigger name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_trigger ::Google::Cloud::Eventarc::V1::GetTriggerRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_trigger({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_trigger(::Google::Cloud::Eventarc::V1::GetTriggerRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_trigger_client_stub.call_rpc_count
    end
  end

  def test_list_triggers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListTriggersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_triggers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_triggers, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListTriggersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_triggers_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_triggers({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_triggers parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_triggers ::Google::Cloud::Eventarc::V1::ListTriggersRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_triggers({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_triggers(::Google::Cloud::Eventarc::V1::ListTriggersRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_triggers_client_stub.call_rpc_count
    end
  end

  def test_create_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    trigger = {}
    trigger_id = "hello world"
    validate_only = true

    create_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_trigger, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::CreateTriggerRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::Trigger), request["trigger"]
      assert_equal "hello world", request["trigger_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_trigger({ parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_trigger parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_trigger ::Google::Cloud::Eventarc::V1::CreateTriggerRequest.new(parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_trigger({ parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_trigger(::Google::Cloud::Eventarc::V1::CreateTriggerRequest.new(parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_trigger_client_stub.call_rpc_count
    end
  end

  def test_update_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    trigger = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_trigger, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::UpdateTriggerRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::Trigger), request["trigger"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_trigger({ trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_trigger trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_trigger ::Google::Cloud::Eventarc::V1::UpdateTriggerRequest.new(trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_trigger({ trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_trigger(::Google::Cloud::Eventarc::V1::UpdateTriggerRequest.new(trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_trigger_client_stub.call_rpc_count
    end
  end

  def test_delete_trigger
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_trigger_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_trigger, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::DeleteTriggerRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_trigger_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_trigger({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_trigger name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_trigger ::Google::Cloud::Eventarc::V1::DeleteTriggerRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_trigger({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_trigger(::Google::Cloud::Eventarc::V1::DeleteTriggerRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_trigger_client_stub.call_rpc_count
    end
  end

  def test_get_channel
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::Channel.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_channel, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetChannelRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_channel({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_channel name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_channel ::Google::Cloud::Eventarc::V1::GetChannelRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_channel({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_channel(::Google::Cloud::Eventarc::V1::GetChannelRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_channel_client_stub.call_rpc_count
    end
  end

  def test_list_channels
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListChannelsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_channels_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_channels, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListChannelsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_channels_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_channels({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_channels parent: parent, page_size: page_size, page_token: page_token, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_channels ::Google::Cloud::Eventarc::V1::ListChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_channels({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_channels(::Google::Cloud::Eventarc::V1::ListChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_channels_client_stub.call_rpc_count
    end
  end

  def test_create_channel
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel = {}
    channel_id = "hello world"
    validate_only = true

    create_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_channel, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::CreateChannelRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::Channel), request["channel"]
      assert_equal "hello world", request["channel_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_channel({ parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_channel parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_channel ::Google::Cloud::Eventarc::V1::CreateChannelRequest.new(parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_channel({ parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_channel(::Google::Cloud::Eventarc::V1::CreateChannelRequest.new(parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_channel_client_stub.call_rpc_count
    end
  end

  def test_update_channel
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    channel = {}
    update_mask = {}
    validate_only = true

    update_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_channel, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::UpdateChannelRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::Channel), request["channel"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_channel({ channel: channel, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_channel channel: channel, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_channel ::Google::Cloud::Eventarc::V1::UpdateChannelRequest.new(channel: channel, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_channel({ channel: channel, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_channel(::Google::Cloud::Eventarc::V1::UpdateChannelRequest.new(channel: channel, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_channel_client_stub.call_rpc_count
    end
  end

  def test_delete_channel
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true

    delete_channel_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_channel, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::DeleteChannelRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_channel_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_channel({ name: name, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_channel name: name, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_channel ::Google::Cloud::Eventarc::V1::DeleteChannelRequest.new(name: name, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_channel({ name: name, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_channel(::Google::Cloud::Eventarc::V1::DeleteChannelRequest.new(name: name, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_channel_client_stub.call_rpc_count
    end
  end

  def test_get_provider
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::Provider.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_provider_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_provider, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetProviderRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_provider_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_provider({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_provider name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_provider ::Google::Cloud::Eventarc::V1::GetProviderRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_provider({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_provider(::Google::Cloud::Eventarc::V1::GetProviderRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_provider_client_stub.call_rpc_count
    end
  end

  def test_list_providers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListProvidersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_providers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_providers, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListProvidersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_providers_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_providers({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_providers parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_providers ::Google::Cloud::Eventarc::V1::ListProvidersRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_providers({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_providers(::Google::Cloud::Eventarc::V1::ListProvidersRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_providers_client_stub.call_rpc_count
    end
  end

  def test_get_channel_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ChannelConnection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_channel_connection, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetChannelConnectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_channel_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_channel_connection({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_channel_connection name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_channel_connection ::Google::Cloud::Eventarc::V1::GetChannelConnectionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_channel_connection({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_channel_connection(::Google::Cloud::Eventarc::V1::GetChannelConnectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_channel_connection_client_stub.call_rpc_count
    end
  end

  def test_list_channel_connections
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListChannelConnectionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_channel_connections_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_channel_connections, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_channel_connections_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_channel_connections({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_channel_connections parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_channel_connections ::Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_channel_connections({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_channel_connections(::Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_channel_connections_client_stub.call_rpc_count
    end
  end

  def test_create_channel_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel_connection = {}
    channel_connection_id = "hello world"

    create_channel_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_channel_connection, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::ChannelConnection), request["channel_connection"]
      assert_equal "hello world", request["channel_connection_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_channel_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_channel_connection({ parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_channel_connection parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_channel_connection ::Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest.new(parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_channel_connection({ parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_channel_connection(::Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest.new(parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_channel_connection_client_stub.call_rpc_count
    end
  end

  def test_delete_channel_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_channel_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_channel_connection, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_channel_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_channel_connection({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_channel_connection name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_channel_connection ::Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_channel_connection({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_channel_connection(::Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_channel_connection_client_stub.call_rpc_count
    end
  end

  def test_get_google_channel_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::GoogleChannelConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_google_channel_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_google_channel_config, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_google_channel_config_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_google_channel_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_google_channel_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_google_channel_config ::Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_google_channel_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_google_channel_config(::Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_google_channel_config_client_stub.call_rpc_count
    end
  end

  def test_update_google_channel_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::GoogleChannelConfig.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    google_channel_config = {}
    update_mask = {}

    update_google_channel_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_google_channel_config, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::GoogleChannelConfig), request["google_channel_config"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_google_channel_config_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_google_channel_config({ google_channel_config: google_channel_config, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_google_channel_config google_channel_config: google_channel_config, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_google_channel_config ::Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest.new(google_channel_config: google_channel_config, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_google_channel_config({ google_channel_config: google_channel_config, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_google_channel_config(::Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest.new(google_channel_config: google_channel_config, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_google_channel_config_client_stub.call_rpc_count
    end
  end

  def test_get_message_bus
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::MessageBus.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_message_bus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_message_bus, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetMessageBusRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_message_bus_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_message_bus({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_message_bus name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_message_bus ::Google::Cloud::Eventarc::V1::GetMessageBusRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_message_bus({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_message_bus(::Google::Cloud::Eventarc::V1::GetMessageBusRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_message_bus_client_stub.call_rpc_count
    end
  end

  def test_list_message_buses
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListMessageBusesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_message_buses_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_message_buses, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListMessageBusesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_message_buses_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_message_buses({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_message_buses parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_message_buses ::Google::Cloud::Eventarc::V1::ListMessageBusesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_message_buses({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_message_buses(::Google::Cloud::Eventarc::V1::ListMessageBusesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_message_buses_client_stub.call_rpc_count
    end
  end

  def test_list_message_bus_enrollments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_message_bus_enrollments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_message_bus_enrollments, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_message_bus_enrollments_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_message_bus_enrollments({ parent: parent, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_message_bus_enrollments parent: parent, page_size: page_size, page_token: page_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_message_bus_enrollments ::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_message_bus_enrollments({ parent: parent, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_message_bus_enrollments(::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_message_bus_enrollments_client_stub.call_rpc_count
    end
  end

  def test_create_message_bus
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    message_bus = {}
    message_bus_id = "hello world"
    validate_only = true

    create_message_bus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_message_bus, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::CreateMessageBusRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::MessageBus), request["message_bus"]
      assert_equal "hello world", request["message_bus_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_message_bus_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_message_bus({ parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_message_bus parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_message_bus ::Google::Cloud::Eventarc::V1::CreateMessageBusRequest.new(parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_message_bus({ parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_message_bus(::Google::Cloud::Eventarc::V1::CreateMessageBusRequest.new(parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_message_bus_client_stub.call_rpc_count
    end
  end

  def test_update_message_bus
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    message_bus = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_message_bus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_message_bus, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::UpdateMessageBusRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::MessageBus), request["message_bus"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_message_bus_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_message_bus({ message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_message_bus message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_message_bus ::Google::Cloud::Eventarc::V1::UpdateMessageBusRequest.new(message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_message_bus({ message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_message_bus(::Google::Cloud::Eventarc::V1::UpdateMessageBusRequest.new(message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_message_bus_client_stub.call_rpc_count
    end
  end

  def test_delete_message_bus
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_message_bus_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_message_bus, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::DeleteMessageBusRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_message_bus_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_message_bus({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_message_bus name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_message_bus ::Google::Cloud::Eventarc::V1::DeleteMessageBusRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_message_bus({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_message_bus(::Google::Cloud::Eventarc::V1::DeleteMessageBusRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_message_bus_client_stub.call_rpc_count
    end
  end

  def test_get_enrollment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::Enrollment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_enrollment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_enrollment, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetEnrollmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_enrollment_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_enrollment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_enrollment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_enrollment ::Google::Cloud::Eventarc::V1::GetEnrollmentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_enrollment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_enrollment(::Google::Cloud::Eventarc::V1::GetEnrollmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_enrollment_client_stub.call_rpc_count
    end
  end

  def test_list_enrollments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListEnrollmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_enrollments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_enrollments, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListEnrollmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_enrollments_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_enrollments({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_enrollments parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_enrollments ::Google::Cloud::Eventarc::V1::ListEnrollmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_enrollments({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_enrollments(::Google::Cloud::Eventarc::V1::ListEnrollmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_enrollments_client_stub.call_rpc_count
    end
  end

  def test_create_enrollment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    enrollment = {}
    enrollment_id = "hello world"
    validate_only = true

    create_enrollment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_enrollment, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::CreateEnrollmentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::Enrollment), request["enrollment"]
      assert_equal "hello world", request["enrollment_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_enrollment_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_enrollment({ parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_enrollment parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_enrollment ::Google::Cloud::Eventarc::V1::CreateEnrollmentRequest.new(parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_enrollment({ parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_enrollment(::Google::Cloud::Eventarc::V1::CreateEnrollmentRequest.new(parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_enrollment_client_stub.call_rpc_count
    end
  end

  def test_update_enrollment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    enrollment = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_enrollment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_enrollment, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::Enrollment), request["enrollment"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_enrollment_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_enrollment({ enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_enrollment enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_enrollment ::Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest.new(enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_enrollment({ enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_enrollment(::Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest.new(enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_enrollment_client_stub.call_rpc_count
    end
  end

  def test_delete_enrollment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_enrollment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_enrollment, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_enrollment_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_enrollment({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_enrollment name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_enrollment ::Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_enrollment({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_enrollment(::Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_enrollment_client_stub.call_rpc_count
    end
  end

  def test_get_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::Pipeline.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pipeline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_pipeline, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetPipelineRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_pipeline({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_pipeline name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_pipeline ::Google::Cloud::Eventarc::V1::GetPipelineRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_pipeline({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_pipeline(::Google::Cloud::Eventarc::V1::GetPipelineRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_pipeline_client_stub.call_rpc_count
    end
  end

  def test_list_pipelines
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListPipelinesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_pipelines_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_pipelines, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListPipelinesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_pipelines_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_pipelines({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_pipelines parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_pipelines ::Google::Cloud::Eventarc::V1::ListPipelinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_pipelines({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_pipelines(::Google::Cloud::Eventarc::V1::ListPipelinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_pipelines_client_stub.call_rpc_count
    end
  end

  def test_create_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    pipeline = {}
    pipeline_id = "hello world"
    validate_only = true

    create_pipeline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_pipeline, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::CreatePipelineRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::Pipeline), request["pipeline"]
      assert_equal "hello world", request["pipeline_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_pipeline({ parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_pipeline parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_pipeline ::Google::Cloud::Eventarc::V1::CreatePipelineRequest.new(parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_pipeline({ parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_pipeline(::Google::Cloud::Eventarc::V1::CreatePipelineRequest.new(parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_pipeline_client_stub.call_rpc_count
    end
  end

  def test_update_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    pipeline = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_pipeline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_pipeline, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::UpdatePipelineRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::Pipeline), request["pipeline"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_pipeline({ pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_pipeline pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_pipeline ::Google::Cloud::Eventarc::V1::UpdatePipelineRequest.new(pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_pipeline({ pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_pipeline(::Google::Cloud::Eventarc::V1::UpdatePipelineRequest.new(pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_pipeline_client_stub.call_rpc_count
    end
  end

  def test_delete_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_pipeline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_pipeline, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::DeletePipelineRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_pipeline({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_pipeline name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_pipeline ::Google::Cloud::Eventarc::V1::DeletePipelineRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_pipeline({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_pipeline(::Google::Cloud::Eventarc::V1::DeletePipelineRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_pipeline_client_stub.call_rpc_count
    end
  end

  def test_get_google_api_source
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::GoogleApiSource.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_google_api_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_google_api_source, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_google_api_source_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_google_api_source({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_google_api_source name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_google_api_source ::Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_google_api_source({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_google_api_source(::Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_google_api_source_client_stub.call_rpc_count
    end
  end

  def test_list_google_api_sources
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_google_api_sources_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_google_api_sources, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_google_api_sources_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_google_api_sources({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_google_api_sources parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_google_api_sources ::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_google_api_sources({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_google_api_sources(::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_google_api_sources_client_stub.call_rpc_count
    end
  end

  def test_create_google_api_source
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    google_api_source = {}
    google_api_source_id = "hello world"
    validate_only = true

    create_google_api_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_google_api_source, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::GoogleApiSource), request["google_api_source"]
      assert_equal "hello world", request["google_api_source_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_google_api_source_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_google_api_source({ parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_google_api_source parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_google_api_source ::Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest.new(parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_google_api_source({ parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_google_api_source(::Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest.new(parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_google_api_source_client_stub.call_rpc_count
    end
  end

  def test_update_google_api_source
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    google_api_source = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_google_api_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_google_api_source, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Eventarc::V1::GoogleApiSource), request["google_api_source"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_google_api_source_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_google_api_source({ google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_google_api_source google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_google_api_source ::Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest.new(google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_google_api_source({ google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_google_api_source(::Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest.new(google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_google_api_source_client_stub.call_rpc_count
    end
  end

  def test_delete_google_api_source
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_google_api_source_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_google_api_source, name
      assert_kind_of ::Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_google_api_source_client_stub do
      # Create client
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_google_api_source({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_google_api_source name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_google_api_source ::Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_google_api_source({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_google_api_source(::Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_google_api_source_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Eventarc::V1::Eventarc::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Eventarc::V1::Eventarc::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Eventarc::V1::Eventarc::Operations, client.operations_client
  end
end
