# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/eventarc/v1/eventarc_pb"
require "google/cloud/eventarc/v1/eventarc/rest"


class ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_trigger
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::Trigger.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_trigger({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_trigger name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_trigger ::Google::Cloud::Eventarc::V1::GetTriggerRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_trigger({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_trigger(::Google::Cloud::Eventarc::V1::GetTriggerRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_trigger_client_stub.call_count
      end
    end
  end

  def test_list_triggers
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListTriggersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_triggers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_triggers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_triggers_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_triggers({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_triggers parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_triggers ::Google::Cloud::Eventarc::V1::ListTriggersRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_triggers({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_triggers(::Google::Cloud::Eventarc::V1::ListTriggersRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_triggers_client_stub.call_count
      end
    end
  end

  def test_create_trigger
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    trigger = {}
    trigger_id = "hello world"
    validate_only = true

    create_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_create_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_trigger({ parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_trigger parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_trigger ::Google::Cloud::Eventarc::V1::CreateTriggerRequest.new(parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_trigger({ parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_trigger(::Google::Cloud::Eventarc::V1::CreateTriggerRequest.new(parent: parent, trigger: trigger, trigger_id: trigger_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_trigger_client_stub.call_count
      end
    end
  end

  def test_update_trigger
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    trigger = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_update_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_trigger({ trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_trigger trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_trigger ::Google::Cloud::Eventarc::V1::UpdateTriggerRequest.new(trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_trigger({ trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_trigger(::Google::Cloud::Eventarc::V1::UpdateTriggerRequest.new(trigger: trigger, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_trigger_client_stub.call_count
      end
    end
  end

  def test_delete_trigger
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_trigger_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_delete_trigger_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_trigger_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_trigger({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_trigger name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_trigger ::Google::Cloud::Eventarc::V1::DeleteTriggerRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_trigger({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_trigger(::Google::Cloud::Eventarc::V1::DeleteTriggerRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_trigger_client_stub.call_count
      end
    end
  end

  def test_get_channel
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::Channel.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_channel({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_channel name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_channel ::Google::Cloud::Eventarc::V1::GetChannelRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_channel({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_channel(::Google::Cloud::Eventarc::V1::GetChannelRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_channel_client_stub.call_count
      end
    end
  end

  def test_list_channels
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListChannelsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"

    list_channels_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_channels_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_channels_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_channels({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_channels parent: parent, page_size: page_size, page_token: page_token, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_channels ::Google::Cloud::Eventarc::V1::ListChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_channels({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_channels(::Google::Cloud::Eventarc::V1::ListChannelsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_channels_client_stub.call_count
      end
    end
  end

  def test_create_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel = {}
    channel_id = "hello world"
    validate_only = true

    create_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_create_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_channel({ parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_channel parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_channel ::Google::Cloud::Eventarc::V1::CreateChannelRequest.new(parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_channel({ parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_channel(::Google::Cloud::Eventarc::V1::CreateChannelRequest.new(parent: parent, channel: channel, channel_id: channel_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_channel_client_stub.call_count
      end
    end
  end

  def test_update_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    channel = {}
    update_mask = {}
    validate_only = true

    update_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_update_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_channel({ channel: channel, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_channel channel: channel, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_channel ::Google::Cloud::Eventarc::V1::UpdateChannelRequest.new(channel: channel, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_channel({ channel: channel, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_channel(::Google::Cloud::Eventarc::V1::UpdateChannelRequest.new(channel: channel, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_channel_client_stub.call_count
      end
    end
  end

  def test_delete_channel
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    validate_only = true

    delete_channel_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_delete_channel_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_channel_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_channel({ name: name, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_channel name: name, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_channel ::Google::Cloud::Eventarc::V1::DeleteChannelRequest.new(name: name, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_channel({ name: name, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_channel(::Google::Cloud::Eventarc::V1::DeleteChannelRequest.new(name: name, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_channel_client_stub.call_count
      end
    end
  end

  def test_get_provider
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::Provider.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_provider_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_provider_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_provider_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_provider({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_provider name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_provider ::Google::Cloud::Eventarc::V1::GetProviderRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_provider({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_provider(::Google::Cloud::Eventarc::V1::GetProviderRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_provider_client_stub.call_count
      end
    end
  end

  def test_list_providers
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListProvidersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_providers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_providers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_providers_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_providers({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_providers parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_providers ::Google::Cloud::Eventarc::V1::ListProvidersRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_providers({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_providers(::Google::Cloud::Eventarc::V1::ListProvidersRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_providers_client_stub.call_count
      end
    end
  end

  def test_get_channel_connection
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ChannelConnection.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_channel_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_channel_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_channel_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_channel_connection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_channel_connection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_channel_connection ::Google::Cloud::Eventarc::V1::GetChannelConnectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_channel_connection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_channel_connection(::Google::Cloud::Eventarc::V1::GetChannelConnectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_channel_connection_client_stub.call_count
      end
    end
  end

  def test_list_channel_connections
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListChannelConnectionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_channel_connections_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_channel_connections_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_channel_connections_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_channel_connections({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_channel_connections parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_channel_connections ::Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_channel_connections({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_channel_connections(::Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_channel_connections_client_stub.call_count
      end
    end
  end

  def test_create_channel_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    channel_connection = {}
    channel_connection_id = "hello world"

    create_channel_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_create_channel_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_channel_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_channel_connection({ parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_channel_connection parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_channel_connection ::Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest.new(parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_channel_connection({ parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_channel_connection(::Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest.new(parent: parent, channel_connection: channel_connection, channel_connection_id: channel_connection_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_channel_connection_client_stub.call_count
      end
    end
  end

  def test_delete_channel_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_channel_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_delete_channel_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_channel_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_channel_connection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_channel_connection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_channel_connection ::Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_channel_connection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_channel_connection(::Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_channel_connection_client_stub.call_count
      end
    end
  end

  def test_get_google_channel_config
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::GoogleChannelConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_google_channel_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_google_channel_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_google_channel_config_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_google_channel_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_google_channel_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_google_channel_config ::Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_google_channel_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_google_channel_config(::Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_google_channel_config_client_stub.call_count
      end
    end
  end

  def test_update_google_channel_config
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::GoogleChannelConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    google_channel_config = {}
    update_mask = {}

    update_google_channel_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_update_google_channel_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_google_channel_config_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_google_channel_config({ google_channel_config: google_channel_config, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_google_channel_config google_channel_config: google_channel_config, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_google_channel_config ::Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest.new(google_channel_config: google_channel_config, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_google_channel_config({ google_channel_config: google_channel_config, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_google_channel_config(::Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest.new(google_channel_config: google_channel_config, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_google_channel_config_client_stub.call_count
      end
    end
  end

  def test_get_message_bus
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::MessageBus.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_message_bus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_message_bus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_message_bus_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_message_bus({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_message_bus name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_message_bus ::Google::Cloud::Eventarc::V1::GetMessageBusRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_message_bus({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_message_bus(::Google::Cloud::Eventarc::V1::GetMessageBusRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_message_bus_client_stub.call_count
      end
    end
  end

  def test_list_message_buses
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListMessageBusesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_message_buses_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_message_buses_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_message_buses_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_message_buses({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_message_buses parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_message_buses ::Google::Cloud::Eventarc::V1::ListMessageBusesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_message_buses({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_message_buses(::Google::Cloud::Eventarc::V1::ListMessageBusesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_message_buses_client_stub.call_count
      end
    end
  end

  def test_list_message_bus_enrollments
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_message_bus_enrollments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_message_bus_enrollments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_message_bus_enrollments_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_message_bus_enrollments({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_message_bus_enrollments parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_message_bus_enrollments ::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_message_bus_enrollments({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_message_bus_enrollments(::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_message_bus_enrollments_client_stub.call_count
      end
    end
  end

  def test_create_message_bus
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    message_bus = {}
    message_bus_id = "hello world"
    validate_only = true

    create_message_bus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_create_message_bus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_message_bus_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_message_bus({ parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_message_bus parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_message_bus ::Google::Cloud::Eventarc::V1::CreateMessageBusRequest.new(parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_message_bus({ parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_message_bus(::Google::Cloud::Eventarc::V1::CreateMessageBusRequest.new(parent: parent, message_bus: message_bus, message_bus_id: message_bus_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_message_bus_client_stub.call_count
      end
    end
  end

  def test_update_message_bus
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    message_bus = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_message_bus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_update_message_bus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_message_bus_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_message_bus({ message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_message_bus message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_message_bus ::Google::Cloud::Eventarc::V1::UpdateMessageBusRequest.new(message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_message_bus({ message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_message_bus(::Google::Cloud::Eventarc::V1::UpdateMessageBusRequest.new(message_bus: message_bus, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_message_bus_client_stub.call_count
      end
    end
  end

  def test_delete_message_bus
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_message_bus_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_delete_message_bus_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_message_bus_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_message_bus({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_message_bus name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_message_bus ::Google::Cloud::Eventarc::V1::DeleteMessageBusRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_message_bus({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_message_bus(::Google::Cloud::Eventarc::V1::DeleteMessageBusRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_message_bus_client_stub.call_count
      end
    end
  end

  def test_get_enrollment
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::Enrollment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_enrollment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_enrollment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_enrollment_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_enrollment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_enrollment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_enrollment ::Google::Cloud::Eventarc::V1::GetEnrollmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_enrollment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_enrollment(::Google::Cloud::Eventarc::V1::GetEnrollmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_enrollment_client_stub.call_count
      end
    end
  end

  def test_list_enrollments
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListEnrollmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_enrollments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_enrollments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_enrollments_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_enrollments({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_enrollments parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_enrollments ::Google::Cloud::Eventarc::V1::ListEnrollmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_enrollments({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_enrollments(::Google::Cloud::Eventarc::V1::ListEnrollmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_enrollments_client_stub.call_count
      end
    end
  end

  def test_create_enrollment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    enrollment = {}
    enrollment_id = "hello world"
    validate_only = true

    create_enrollment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_create_enrollment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_enrollment_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_enrollment({ parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_enrollment parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_enrollment ::Google::Cloud::Eventarc::V1::CreateEnrollmentRequest.new(parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_enrollment({ parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_enrollment(::Google::Cloud::Eventarc::V1::CreateEnrollmentRequest.new(parent: parent, enrollment: enrollment, enrollment_id: enrollment_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_enrollment_client_stub.call_count
      end
    end
  end

  def test_update_enrollment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    enrollment = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_enrollment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_update_enrollment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_enrollment_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_enrollment({ enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_enrollment enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_enrollment ::Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest.new(enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_enrollment({ enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_enrollment(::Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest.new(enrollment: enrollment, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_enrollment_client_stub.call_count
      end
    end
  end

  def test_delete_enrollment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_enrollment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_delete_enrollment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_enrollment_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_enrollment({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_enrollment name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_enrollment ::Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_enrollment({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_enrollment(::Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_enrollment_client_stub.call_count
      end
    end
  end

  def test_get_pipeline
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::Pipeline.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_pipeline({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_pipeline name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_pipeline ::Google::Cloud::Eventarc::V1::GetPipelineRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_pipeline({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_pipeline(::Google::Cloud::Eventarc::V1::GetPipelineRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_pipeline_client_stub.call_count
      end
    end
  end

  def test_list_pipelines
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListPipelinesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_pipelines_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_pipelines_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_pipelines_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_pipelines({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_pipelines parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_pipelines ::Google::Cloud::Eventarc::V1::ListPipelinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_pipelines({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_pipelines(::Google::Cloud::Eventarc::V1::ListPipelinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_pipelines_client_stub.call_count
      end
    end
  end

  def test_create_pipeline
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    pipeline = {}
    pipeline_id = "hello world"
    validate_only = true

    create_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_create_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_pipeline({ parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_pipeline parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_pipeline ::Google::Cloud::Eventarc::V1::CreatePipelineRequest.new(parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_pipeline({ parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_pipeline(::Google::Cloud::Eventarc::V1::CreatePipelineRequest.new(parent: parent, pipeline: pipeline, pipeline_id: pipeline_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_pipeline_client_stub.call_count
      end
    end
  end

  def test_update_pipeline
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    pipeline = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_update_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_pipeline({ pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_pipeline pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_pipeline ::Google::Cloud::Eventarc::V1::UpdatePipelineRequest.new(pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_pipeline({ pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_pipeline(::Google::Cloud::Eventarc::V1::UpdatePipelineRequest.new(pipeline: pipeline, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_pipeline_client_stub.call_count
      end
    end
  end

  def test_delete_pipeline
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_delete_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_pipeline({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_pipeline name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_pipeline ::Google::Cloud::Eventarc::V1::DeletePipelineRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_pipeline({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_pipeline(::Google::Cloud::Eventarc::V1::DeletePipelineRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_pipeline_client_stub.call_count
      end
    end
  end

  def test_get_google_api_source
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::GoogleApiSource.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_google_api_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_get_google_api_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_google_api_source_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_google_api_source({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_google_api_source name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_google_api_source ::Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_google_api_source({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_google_api_source(::Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_google_api_source_client_stub.call_count
      end
    end
  end

  def test_list_google_api_sources
    # Create test objects.
    client_result = ::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    filter = "hello world"

    list_google_api_sources_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_list_google_api_sources_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_google_api_sources_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_google_api_sources({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_google_api_sources parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_google_api_sources ::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_google_api_sources({ parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_google_api_sources(::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest.new(parent: parent, page_size: page_size, page_token: page_token, order_by: order_by, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_google_api_sources_client_stub.call_count
      end
    end
  end

  def test_create_google_api_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    google_api_source = {}
    google_api_source_id = "hello world"
    validate_only = true

    create_google_api_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_create_google_api_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_google_api_source_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_google_api_source({ parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_google_api_source parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_google_api_source ::Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest.new(parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_google_api_source({ parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_google_api_source(::Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest.new(parent: parent, google_api_source: google_api_source, google_api_source_id: google_api_source_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_google_api_source_client_stub.call_count
      end
    end
  end

  def test_update_google_api_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    google_api_source = {}
    update_mask = {}
    allow_missing = true
    validate_only = true

    update_google_api_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_update_google_api_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_google_api_source_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_google_api_source({ google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_google_api_source google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_google_api_source ::Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest.new(google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_google_api_source({ google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_google_api_source(::Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest.new(google_api_source: google_api_source, update_mask: update_mask, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_google_api_source_client_stub.call_count
      end
    end
  end

  def test_delete_google_api_source
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"
    allow_missing = true
    validate_only = true

    delete_google_api_source_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Eventarc::V1::Eventarc::Rest::ServiceStub.stub :transcode_delete_google_api_source_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_google_api_source_client_stub do
        # Create client
        client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_google_api_source({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_google_api_source name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_google_api_source ::Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_google_api_source({ name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_google_api_source(::Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest.new(name: name, etag: etag, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_google_api_source_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Eventarc::V1::Eventarc::Rest::Client::Configuration, config
  end
end
