# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Eventarc
      module V1
        # A representation of the trigger resource.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the trigger. Must be unique within the
        #     location of the project and must be in
        #     `projects/{project}/locations/{location}/triggers/{trigger}` format.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server-assigned unique identifier for the trigger. The value
        #     is a UUID4 string and guaranteed to remain unchanged until the resource is
        #     deleted.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last-modified time.
        # @!attribute [rw] event_filters
        #   @return [::Array<::Google::Cloud::Eventarc::V1::EventFilter>]
        #     Required. Unordered list. The list of filters that applies to event
        #     attributes. Only events that match all the provided filters are sent to the
        #     destination.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. The IAM service account email associated with the trigger. The
        #     service account represents the identity of the trigger.
        #
        #     The `iam.serviceAccounts.actAs` permission must be granted on the service
        #     account to allow a principal to impersonate the service account. For more
        #     information, see the
        #     [Roles and permissions](/eventarc/docs/all-roles-permissions) page specific
        #     to the trigger destination.
        # @!attribute [rw] destination
        #   @return [::Google::Cloud::Eventarc::V1::Destination]
        #     Required. Destination specifies where the events should be sent to.
        # @!attribute [rw] transport
        #   @return [::Google::Cloud::Eventarc::V1::Transport]
        #     Optional. To deliver messages, Eventarc might use other Google Cloud
        #     products as a transport intermediary. This field contains a reference to
        #     that transport intermediary. This information can be used for debugging
        #     purposes.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User labels attached to the triggers that can be used to group
        #     resources.
        # @!attribute [rw] channel
        #   @return [::String]
        #     Optional. The name of the channel associated with the trigger in
        #     `projects/{project}/locations/{location}/channels/{channel}` format.
        #     You must provide a channel to receive events from Eventarc SaaS partners.
        # @!attribute [r] conditions
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Eventarc::V1::StateCondition}]
        #     Output only. The reason(s) why a trigger is in FAILED state.
        # @!attribute [rw] event_data_content_type
        #   @return [::String]
        #     Optional. EventDataContentType specifies the type of payload in MIME
        #     format that is expected from the CloudEvent data field. This is set to
        #     `application/json` if the value is not defined.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Whether or not this Trigger satisfies the requirements of
        #     physical zone separation
        # @!attribute [rw] retry_policy
        #   @return [::Google::Cloud::Eventarc::V1::Trigger::RetryPolicy]
        #     Optional. The retry policy to use in the Trigger.
        #
        #     If unset, event delivery will be retried for up to 24 hours by default:
        #     https://cloud.google.com/eventarc/docs/retry-events
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. This checksum is computed by the server based on the value of
        #     other fields, and might be sent only on create requests to ensure that the
        #     client has an up-to-date value before proceeding.
        class Trigger
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The retry policy configuration for the Trigger.
          #
          # Can only be set with Cloud Run destinations.
          # @!attribute [rw] max_attempts
          #   @return [::Integer]
          #     Optional. The maximum number of delivery attempts for any message. The
          #     only valid value is 1.
          class RetryPolicy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Eventarc::V1::StateCondition]
          class ConditionsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Filters events based on exact matches on the CloudEvents attributes.
        # @!attribute [rw] attribute
        #   @return [::String]
        #     Required. The name of a CloudEvents attribute. Currently, only a subset of
        #     attributes are supported for filtering. You can [retrieve a specific
        #     provider's supported event
        #     types](/eventarc/docs/list-providers#describe-provider).
        #
        #     All triggers MUST provide a filter for the 'type' attribute.
        # @!attribute [rw] value
        #   @return [::String]
        #     Required. The value for the attribute.
        # @!attribute [rw] operator
        #   @return [::String]
        #     Optional. The operator used for matching the events with the value of the
        #     filter. If not specified, only events that have an exact key-value pair
        #     specified in the filter are matched. The allowed values are `path_pattern`
        #     and `match-path-pattern`. `path_pattern` is only allowed for GCFv1
        #     triggers.
        class EventFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A condition that is part of the trigger state computation.
        # @!attribute [rw] code
        #   @return [::Google::Rpc::Code]
        #     The canonical code of the condition.
        # @!attribute [rw] message
        #   @return [::String]
        #     Human-readable message.
        class StateCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a target of an invocation over HTTP.
        # @!attribute [rw] cloud_run
        #   @return [::Google::Cloud::Eventarc::V1::CloudRun]
        #     Cloud Run fully-managed resource that receives the events. The resource
        #     should be in the same project as the trigger.
        #
        #     Note: The following fields are mutually exclusive: `cloud_run`, `cloud_function`, `gke`, `workflow`, `http_endpoint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_function
        #   @return [::String]
        #     The Cloud Function resource name. Cloud Functions V1 and V2 are
        #     supported.
        #     Format: `projects/{project}/locations/{location}/functions/{function}`
        #
        #     This is a read-only field. Creating Cloud Functions V1/V2 triggers is
        #     only supported via the Cloud Functions product. An error will be returned
        #     if the user sets this value.
        #
        #     Note: The following fields are mutually exclusive: `cloud_function`, `cloud_run`, `gke`, `workflow`, `http_endpoint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gke
        #   @return [::Google::Cloud::Eventarc::V1::GKE]
        #     A GKE service capable of receiving events. The service should be running
        #     in the same project as the trigger.
        #
        #     Note: The following fields are mutually exclusive: `gke`, `cloud_run`, `cloud_function`, `workflow`, `http_endpoint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] workflow
        #   @return [::String]
        #     The resource name of the Workflow whose Executions are triggered by
        #     the events. The Workflow resource should be deployed in the same project
        #     as the trigger.
        #     Format: `projects/{project}/locations/{location}/workflows/{workflow}`
        #
        #     Note: The following fields are mutually exclusive: `workflow`, `cloud_run`, `cloud_function`, `gke`, `http_endpoint`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] http_endpoint
        #   @return [::Google::Cloud::Eventarc::V1::HttpEndpoint]
        #     An HTTP endpoint destination described by an URI.
        #
        #     Note: The following fields are mutually exclusive: `http_endpoint`, `cloud_run`, `cloud_function`, `gke`, `workflow`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] network_config
        #   @return [::Google::Cloud::Eventarc::V1::NetworkConfig]
        #     Optional. Network config is used to configure how Eventarc resolves and
        #     connect to a destination.
        #     This should only be used with HttpEndpoint destination type.
        class Destination
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the transport intermediaries created for the trigger to
        # deliver events.
        # @!attribute [rw] pubsub
        #   @return [::Google::Cloud::Eventarc::V1::Pubsub]
        #     The Pub/Sub topic and subscription used by Eventarc as a transport
        #     intermediary.
        class Transport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Cloud Run destination.
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. The name of the Cloud Run service being addressed. See
        #     https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services.
        #
        #     Only services located in the same project as the trigger object
        #     can be addressed.
        # @!attribute [rw] path
        #   @return [::String]
        #     Optional. The relative path on the Cloud Run service the events should be
        #     sent to.
        #
        #     The value must conform to the definition of a URI path segment (section 3.3
        #     of RFC2396). Examples: "/route", "route", "route/subroute".
        # @!attribute [rw] region
        #   @return [::String]
        #     Required. The region the Cloud Run service is deployed in.
        class CloudRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a GKE destination.
        # @!attribute [rw] cluster
        #   @return [::String]
        #     Required. The name of the cluster the GKE service is running in. The
        #     cluster must be running in the same project as the trigger being created.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The name of the Google Compute Engine in which the cluster
        #     resides, which can either be compute zone (for example, us-central1-a) for
        #     the zonal clusters or region (for example, us-central1) for regional
        #     clusters.
        # @!attribute [rw] namespace
        #   @return [::String]
        #     Required. The namespace the GKE service is running in.
        # @!attribute [rw] service
        #   @return [::String]
        #     Required. Name of the GKE service.
        # @!attribute [rw] path
        #   @return [::String]
        #     Optional. The relative path on the GKE service the events should be sent
        #     to.
        #
        #     The value must conform to the definition of a URI path segment (section 3.3
        #     of RFC2396). Examples: "/route", "route", "route/subroute".
        class GKE
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a Pub/Sub transport.
        # @!attribute [rw] topic
        #   @return [::String]
        #     Optional. The name of the Pub/Sub topic created and managed by Eventarc as
        #     a transport for the event delivery. Format:
        #     `projects/{PROJECT_ID}/topics/{TOPIC_NAME}`.
        #
        #     You can set an existing topic for triggers of the type
        #     `google.cloud.pubsub.topic.v1.messagePublished`. The topic you provide
        #     here is not deleted by Eventarc at trigger deletion.
        # @!attribute [r] subscription
        #   @return [::String]
        #     Output only. The name of the Pub/Sub subscription created and managed by
        #     Eventarc as a transport for the event delivery. Format:
        #     `projects/{PROJECT_ID}/subscriptions/{SUBSCRIPTION_NAME}`.
        class Pubsub
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a HTTP endpoint destination.
        # @!attribute [rw] uri
        #   @return [::String]
        #     Required. The URI of the HTTP endpoint.
        #
        #     The value must be a RFC2396 URI string.
        #     Examples: `http://10.10.10.8:80/route`,
        #     `http://svc.us-central1.p.local:8080/`.
        #     Only HTTP and HTTPS protocols are supported. The host can be either a
        #     static IP addressable from the VPC specified by the network config, or
        #     an internal DNS hostname of the service resolvable via Cloud DNS.
        class HttpEndpoint
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
