# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Eventarc
      module V1
        # A GoogleApiSource represents a subscription of 1P events from a MessageBus.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Resource name of the form
        #     projects/\\{project}/locations/\\{location}/googleApiSources/\\{google_api_source}
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Server assigned unique identifier for the channel. The value
        #     is a UUID4 string and guaranteed to remain unchanged until the resource is
        #     deleted.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. This checksum is computed by the server based on the value of
        #     other fields, and might be sent only on update and delete requests to
        #     ensure that the client has an up-to-date value before proceeding.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation time.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last-modified time.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource labels.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Resource annotations.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Resource display name.
        # @!attribute [rw] destination
        #   @return [::String]
        #     Required. Destination is the message bus that the GoogleApiSource is
        #     delivering to. It must be point to the full resource name of a MessageBus.
        #     Format:
        #     "projects/\\{PROJECT_ID}/locations/\\{region}/messagesBuses/{MESSAGE_BUS_ID)
        # @!attribute [rw] crypto_key_name
        #   @return [::String]
        #     Optional. Resource name of a KMS crypto key (managed by the user) used to
        #     encrypt/decrypt their event data.
        #
        #     It must match the pattern
        #     `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
        # @!attribute [rw] logging_config
        #   @return [::Google::Cloud::Eventarc::V1::LoggingConfig]
        #     Optional. Config to control Platform logging for the GoogleApiSource.
        # @!attribute [rw] organization_subscription
        #   @return [::Google::Cloud::Eventarc::V1::GoogleApiSource::OrganizationSubscription]
        #     Optional. Config to enable subscribing to events from all projects in the
        #     GoogleApiSource's org.
        #
        #     Note: The following fields are mutually exclusive: `organization_subscription`, `project_subscriptions`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] project_subscriptions
        #   @return [::Google::Cloud::Eventarc::V1::GoogleApiSource::ProjectSubscriptions]
        #     Optional. Config to enable subscribing to all events from a list of
        #     projects.
        #
        #     All the projects must be in the same org as the GoogleApiSource.
        #
        #     Note: The following fields are mutually exclusive: `project_subscriptions`, `organization_subscription`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class GoogleApiSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Config to enable subscribing to all events from a list of projects.
          # @!attribute [rw] list
          #   @return [::Array<::String>]
          #     Required. A list of projects to receive events from.
          #
          #     All the projects must be in the same org. The listed projects should have
          #     the format project/\\{identifier} where identifier can be either the
          #     project id for project number. A single list may contain both formats. At
          #     most 100 projects can be listed.
          class ProjectSubscriptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Config to enabled subscribing to events from other projects in the org.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Required. Enable org level subscription.
          class OrganizationSubscription
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
