# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Eventarc
      module V1
        # A representation of the Provider resource.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. In
        #     `projects/{project}/locations/{location}/providers/{provider_id}` format.
        # @!attribute [r] display_name
        #   @return [::String]
        #     Output only. Human friendly name for the Provider. For example "Cloud
        #     Storage".
        # @!attribute [r] event_types
        #   @return [::Array<::Google::Cloud::Eventarc::V1::EventType>]
        #     Output only. Event types for this provider.
        class Provider
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A representation of the event type resource.
        # @!attribute [r] type
        #   @return [::String]
        #     Output only. The full name of the event type (for example,
        #     "google.cloud.storage.object.v1.finalized"). In the form of
        #     \\{provider-specific-prefix}.\\{resource}.\\{version}.\\{verb}. Types MUST be
        #     versioned and event schemas are guaranteed to remain backward compatible
        #     within one version. Note that event type versions and API versions do not
        #     need to match.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. Human friendly description of what the event type is about.
        #     For example "Bucket created in Cloud Storage".
        # @!attribute [r] filtering_attributes
        #   @return [::Array<::Google::Cloud::Eventarc::V1::FilteringAttribute>]
        #     Output only. Filtering attributes for the event type.
        # @!attribute [r] event_schema_uri
        #   @return [::String]
        #     Output only. URI for the event schema.
        #     For example
        #     "https://github.com/googleapis/google-cloudevents/blob/master/proto/google/events/cloud/storage/v1/events.proto"
        class EventType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A representation of the FilteringAttribute resource.
        # Filtering attributes are per event type.
        # @!attribute [r] attribute
        #   @return [::String]
        #     Output only. Attribute used for filtering the event type.
        # @!attribute [r] description
        #   @return [::String]
        #     Output only. Description of the purpose of the attribute.
        # @!attribute [r] required
        #   @return [::Boolean]
        #     Output only. If true, the triggers for this provider should always specify
        #     a filter on these attributes. Trigger creation will fail otherwise.
        # @!attribute [r] path_pattern_supported
        #   @return [::Boolean]
        #     Output only. If true, the attribute accepts matching expressions in the
        #     Eventarc PathPattern format.
        class FilteringAttribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
