# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/eventarc/v1/eventarc_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Eventarc
      module V1
        module Eventarc
          ##
          # Client for the Eventarc service.
          #
          # Eventarc allows users to subscribe to various events that are provided by
          # Google Cloud services and forward them to supported destinations.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "eventarc.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :eventarc_stub

            ##
            # Configure the Eventarc Client class.
            #
            # See {::Google::Cloud::Eventarc::V1::Eventarc::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Eventarc clients
            #   ::Google::Cloud::Eventarc::V1::Eventarc::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Eventarc", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.get_trigger.timeout = 60.0
                default_config.rpcs.get_trigger.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_triggers.timeout = 60.0
                default_config.rpcs.list_triggers.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.create_trigger.timeout = 60.0

                default_config.rpcs.update_trigger.timeout = 60.0

                default_config.rpcs.delete_trigger.timeout = 60.0

                default_config.rpcs.get_channel.timeout = 60.0
                default_config.rpcs.get_channel.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_channels.timeout = 60.0
                default_config.rpcs.list_channels.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.create_channel.timeout = 60.0

                default_config.rpcs.update_channel.timeout = 60.0

                default_config.rpcs.delete_channel.timeout = 60.0

                default_config.rpcs.get_provider.timeout = 60.0
                default_config.rpcs.get_provider.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_providers.timeout = 60.0
                default_config.rpcs.list_providers.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.get_channel_connection.timeout = 60.0
                default_config.rpcs.get_channel_connection.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_channel_connections.timeout = 60.0
                default_config.rpcs.list_channel_connections.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.create_channel_connection.timeout = 60.0

                default_config.rpcs.delete_channel_connection.timeout = 60.0

                default_config.rpcs.get_google_channel_config.timeout = 60.0
                default_config.rpcs.get_google_channel_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.update_google_channel_config.timeout = 60.0

                default_config.rpcs.get_message_bus.timeout = 60.0
                default_config.rpcs.get_message_bus.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_message_buses.timeout = 60.0
                default_config.rpcs.list_message_buses.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_message_bus_enrollments.timeout = 60.0
                default_config.rpcs.list_message_bus_enrollments.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.create_message_bus.timeout = 60.0

                default_config.rpcs.update_message_bus.timeout = 60.0

                default_config.rpcs.delete_message_bus.timeout = 60.0

                default_config.rpcs.get_enrollment.timeout = 60.0
                default_config.rpcs.get_enrollment.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_enrollments.timeout = 60.0
                default_config.rpcs.list_enrollments.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.create_enrollment.timeout = 60.0

                default_config.rpcs.update_enrollment.timeout = 60.0

                default_config.rpcs.delete_enrollment.timeout = 60.0

                default_config.rpcs.get_pipeline.timeout = 60.0
                default_config.rpcs.get_pipeline.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_pipelines.timeout = 60.0
                default_config.rpcs.list_pipelines.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.create_pipeline.timeout = 60.0

                default_config.rpcs.update_pipeline.timeout = 60.0

                default_config.rpcs.delete_pipeline.timeout = 60.0

                default_config.rpcs.get_google_api_source.timeout = 60.0
                default_config.rpcs.get_google_api_source.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.list_google_api_sources.timeout = 60.0
                default_config.rpcs.list_google_api_sources.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 2]
                }

                default_config.rpcs.create_google_api_source.timeout = 60.0

                default_config.rpcs.update_google_api_source.timeout = 60.0

                default_config.rpcs.delete_google_api_source.timeout = 60.0

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Eventarc Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Eventarc::V1::Eventarc::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @eventarc_stub.universe_domain
            end

            ##
            # Create a new Eventarc client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Eventarc client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/eventarc/v1/eventarc_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @eventarc_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Eventarc::V1::Eventarc::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @eventarc_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @eventarc_stub.endpoint
                config.universe_domain = @eventarc_stub.universe_domain
                config.logger = @eventarc_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @eventarc_stub.endpoint
                config.universe_domain = @eventarc_stub.universe_domain
                config.logger = @eventarc_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::Eventarc::V1::Eventarc::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @eventarc_stub.logger
            end

            # Service calls

            ##
            # Get a single trigger.
            #
            # @overload get_trigger(request, options = nil)
            #   Pass arguments to `get_trigger` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetTriggerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetTriggerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_trigger(name: nil)
            #   Pass arguments to `get_trigger` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the trigger to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::Trigger]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::Trigger]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetTriggerRequest.new
            #
            #   # Call the get_trigger method.
            #   result = client.get_trigger request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::Trigger.
            #   p result
            #
            def get_trigger request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetTriggerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_trigger.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_trigger.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_trigger.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_trigger, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List triggers.
            #
            # @overload list_triggers(request, options = nil)
            #   Pass arguments to `list_triggers` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListTriggersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListTriggersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_triggers(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_triggers` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection to list triggers on.
            #   @param page_size [::Integer]
            #     The maximum number of triggers to return on each page.
            #
            #     Note: The service may send fewer.
            #   @param page_token [::String]
            #     The page token; provide the value from the `next_page_token` field in a
            #     previous `ListTriggers` call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListTriggers` must match
            #     the call that provided the page token.
            #   @param order_by [::String]
            #     The sorting order of the resources returned. Value should be a
            #     comma-separated list of fields. The default sorting order is ascending. To
            #     specify descending order for a field, append a `desc` suffix; for example:
            #     `name desc, trigger_id`.
            #   @param filter [::String]
            #     Filter field. Used to filter the Triggers to be listed. Possible filters
            #     are described in https://google.aip.dev/160. For example, using
            #     "?filter=destination:gke" would list only Triggers with a gke destination.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Trigger>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Trigger>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListTriggersRequest.new
            #
            #   # Call the list_triggers method.
            #   result = client.list_triggers request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Eventarc::V1::Trigger.
            #     p item
            #   end
            #
            def list_triggers request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListTriggersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_triggers.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_triggers.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_triggers.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_triggers, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @eventarc_stub, :list_triggers, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new trigger in a particular project and location.
            #
            # @overload create_trigger(request, options = nil)
            #   Pass arguments to `create_trigger` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::CreateTriggerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::CreateTriggerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_trigger(parent: nil, trigger: nil, trigger_id: nil, validate_only: nil)
            #   Pass arguments to `create_trigger` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection in which to add this trigger.
            #   @param trigger [::Google::Cloud::Eventarc::V1::Trigger, ::Hash]
            #     Required. The trigger to create.
            #   @param trigger_id [::String]
            #     Required. The user-provided ID to be assigned to the trigger.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::CreateTriggerRequest.new
            #
            #   # Call the create_trigger method.
            #   result = client.create_trigger request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_trigger request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::CreateTriggerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_trigger.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_trigger.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_trigger.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :create_trigger, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a single trigger.
            #
            # @overload update_trigger(request, options = nil)
            #   Pass arguments to `update_trigger` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::UpdateTriggerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::UpdateTriggerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_trigger(trigger: nil, update_mask: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `update_trigger` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param trigger [::Google::Cloud::Eventarc::V1::Trigger, ::Hash]
            #     The trigger to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The fields to be updated; only fields explicitly provided are updated.
            #     If no field mask is provided, all provided fields in the request are
            #     updated. To update all fields, provide a field mask of "*".
            #   @param allow_missing [::Boolean]
            #     If set to true, and the trigger is not found, a new trigger will be
            #     created. In this situation, `update_mask` is ignored.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::UpdateTriggerRequest.new
            #
            #   # Call the update_trigger method.
            #   result = client.update_trigger request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_trigger request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::UpdateTriggerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_trigger.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.trigger&.name
                header_params["trigger.name"] = request.trigger.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_trigger.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_trigger.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :update_trigger, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a single trigger.
            #
            # @overload delete_trigger(request, options = nil)
            #   Pass arguments to `delete_trigger` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::DeleteTriggerRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::DeleteTriggerRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_trigger(name: nil, etag: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `delete_trigger` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the trigger to be deleted.
            #   @param etag [::String]
            #     If provided, the trigger will only be deleted if the etag matches the
            #     current etag on the resource.
            #   @param allow_missing [::Boolean]
            #     If set to true, and the trigger is not found, the request will succeed
            #     but no action will be taken on the server.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::DeleteTriggerRequest.new
            #
            #   # Call the delete_trigger method.
            #   result = client.delete_trigger request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_trigger request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::DeleteTriggerRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_trigger.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_trigger.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_trigger.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :delete_trigger, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single Channel.
            #
            # @overload get_channel(request, options = nil)
            #   Pass arguments to `get_channel` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_channel(name: nil)
            #   Pass arguments to `get_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the channel to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::Channel]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::Channel]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetChannelRequest.new
            #
            #   # Call the get_channel method.
            #   result = client.get_channel request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::Channel.
            #   p result
            #
            def get_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_channel, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List channels.
            #
            # @overload list_channels(request, options = nil)
            #   Pass arguments to `list_channels` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListChannelsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListChannelsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_channels(parent: nil, page_size: nil, page_token: nil, order_by: nil)
            #   Pass arguments to `list_channels` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection to list channels on.
            #   @param page_size [::Integer]
            #     The maximum number of channels to return on each page.
            #
            #     Note: The service may send fewer.
            #   @param page_token [::String]
            #     The page token; provide the value from the `next_page_token` field in a
            #     previous `ListChannels` call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListChannels` must
            #     match the call that provided the page token.
            #   @param order_by [::String]
            #     The sorting order of the resources returned. Value should be a
            #     comma-separated list of fields. The default sorting order is ascending. To
            #     specify descending order for a field, append a `desc` suffix; for example:
            #     `name desc, channel_id`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Channel>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Channel>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListChannelsRequest.new
            #
            #   # Call the list_channels method.
            #   result = client.list_channels request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Eventarc::V1::Channel.
            #     p item
            #   end
            #
            def list_channels request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListChannelsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_channels.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_channels.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_channels.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_channels, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @eventarc_stub, :list_channels, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new channel in a particular project and location.
            #
            # @overload create_channel(request, options = nil)
            #   Pass arguments to `create_channel` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::CreateChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::CreateChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_channel(parent: nil, channel: nil, channel_id: nil, validate_only: nil)
            #   Pass arguments to `create_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection in which to add this channel.
            #   @param channel [::Google::Cloud::Eventarc::V1::Channel, ::Hash]
            #     Required. The channel to create.
            #   @param channel_id [::String]
            #     Required. The user-provided ID to be assigned to the channel.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::CreateChannelRequest.new
            #
            #   # Call the create_channel method.
            #   result = client.create_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::CreateChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :create_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a single channel.
            #
            # @overload update_channel(request, options = nil)
            #   Pass arguments to `update_channel` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::UpdateChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::UpdateChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_channel(channel: nil, update_mask: nil, validate_only: nil)
            #   Pass arguments to `update_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param channel [::Google::Cloud::Eventarc::V1::Channel, ::Hash]
            #     The channel to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The fields to be updated; only fields explicitly provided are updated.
            #     If no field mask is provided, all provided fields in the request are
            #     updated. To update all fields, provide a field mask of "*".
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::UpdateChannelRequest.new
            #
            #   # Call the update_channel method.
            #   result = client.update_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::UpdateChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.channel&.name
                header_params["channel.name"] = request.channel.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :update_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a single channel.
            #
            # @overload delete_channel(request, options = nil)
            #   Pass arguments to `delete_channel` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::DeleteChannelRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::DeleteChannelRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_channel(name: nil, validate_only: nil)
            #   Pass arguments to `delete_channel` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the channel to be deleted.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::DeleteChannelRequest.new
            #
            #   # Call the delete_channel method.
            #   result = client.delete_channel request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_channel request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::DeleteChannelRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_channel.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_channel.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_channel.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :delete_channel, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single Provider.
            #
            # @overload get_provider(request, options = nil)
            #   Pass arguments to `get_provider` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetProviderRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetProviderRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_provider(name: nil)
            #   Pass arguments to `get_provider` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the provider to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::Provider]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::Provider]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetProviderRequest.new
            #
            #   # Call the get_provider method.
            #   result = client.get_provider request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::Provider.
            #   p result
            #
            def get_provider request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetProviderRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_provider.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_provider.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_provider.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_provider, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List providers.
            #
            # @overload list_providers(request, options = nil)
            #   Pass arguments to `list_providers` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListProvidersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListProvidersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_providers(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_providers` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent of the provider to get.
            #   @param page_size [::Integer]
            #     The maximum number of providers to return on each page.
            #   @param page_token [::String]
            #     The page token; provide the value from the `next_page_token` field in a
            #     previous `ListProviders` call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListProviders` must
            #     match the call that provided the page token.
            #   @param order_by [::String]
            #     The sorting order of the resources returned. Value should be a
            #     comma-separated list of fields. The default sorting oder is ascending. To
            #     specify descending order for a field, append a `desc` suffix; for example:
            #     `name desc, _id`.
            #   @param filter [::String]
            #     The filter field that the list request will filter on.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Provider>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Provider>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListProvidersRequest.new
            #
            #   # Call the list_providers method.
            #   result = client.list_providers request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Eventarc::V1::Provider.
            #     p item
            #   end
            #
            def list_providers request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListProvidersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_providers.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_providers.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_providers.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_providers, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @eventarc_stub, :list_providers, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single ChannelConnection.
            #
            # @overload get_channel_connection(request, options = nil)
            #   Pass arguments to `get_channel_connection` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetChannelConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetChannelConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_channel_connection(name: nil)
            #   Pass arguments to `get_channel_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the channel connection to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::ChannelConnection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::ChannelConnection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetChannelConnectionRequest.new
            #
            #   # Call the get_channel_connection method.
            #   result = client.get_channel_connection request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::ChannelConnection.
            #   p result
            #
            def get_channel_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetChannelConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_channel_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_channel_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_channel_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_channel_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List channel connections.
            #
            # @overload list_channel_connections(request, options = nil)
            #   Pass arguments to `list_channel_connections` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_channel_connections(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_channel_connections` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection from which to list channel connections.
            #   @param page_size [::Integer]
            #     The maximum number of channel connections to return on each page.
            #
            #     Note: The service may send fewer responses.
            #   @param page_token [::String]
            #     The page token; provide the value from the `next_page_token` field in a
            #     previous `ListChannelConnections` call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided to `ListChannelConnetions`
            #     match the call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::ChannelConnection>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::ChannelConnection>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest.new
            #
            #   # Call the list_channel_connections method.
            #   result = client.list_channel_connections request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Eventarc::V1::ChannelConnection.
            #     p item
            #   end
            #
            def list_channel_connections request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListChannelConnectionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_channel_connections.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_channel_connections.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_channel_connections.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_channel_connections, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @eventarc_stub, :list_channel_connections, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new ChannelConnection in a particular project and location.
            #
            # @overload create_channel_connection(request, options = nil)
            #   Pass arguments to `create_channel_connection` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_channel_connection(parent: nil, channel_connection: nil, channel_connection_id: nil)
            #   Pass arguments to `create_channel_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection in which to add this channel connection.
            #   @param channel_connection [::Google::Cloud::Eventarc::V1::ChannelConnection, ::Hash]
            #     Required. Channel connection to create.
            #   @param channel_connection_id [::String]
            #     Required. The user-provided ID to be assigned to the channel connection.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest.new
            #
            #   # Call the create_channel_connection method.
            #   result = client.create_channel_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_channel_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::CreateChannelConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_channel_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_channel_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_channel_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :create_channel_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a single ChannelConnection.
            #
            # @overload delete_channel_connection(request, options = nil)
            #   Pass arguments to `delete_channel_connection` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_channel_connection(name: nil)
            #   Pass arguments to `delete_channel_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the channel connection to delete.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest.new
            #
            #   # Call the delete_channel_connection method.
            #   result = client.delete_channel_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_channel_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::DeleteChannelConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_channel_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_channel_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_channel_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :delete_channel_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a GoogleChannelConfig.
            # The name of the GoogleChannelConfig in the response is ALWAYS coded with
            # projectID.
            #
            # @overload get_google_channel_config(request, options = nil)
            #   Pass arguments to `get_google_channel_config` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_google_channel_config(name: nil)
            #   Pass arguments to `get_google_channel_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the config to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::GoogleChannelConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::GoogleChannelConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest.new
            #
            #   # Call the get_google_channel_config method.
            #   result = client.get_google_channel_config request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::GoogleChannelConfig.
            #   p result
            #
            def get_google_channel_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetGoogleChannelConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_google_channel_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_google_channel_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_google_channel_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_google_channel_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a single GoogleChannelConfig
            #
            # @overload update_google_channel_config(request, options = nil)
            #   Pass arguments to `update_google_channel_config` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_google_channel_config(google_channel_config: nil, update_mask: nil)
            #   Pass arguments to `update_google_channel_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param google_channel_config [::Google::Cloud::Eventarc::V1::GoogleChannelConfig, ::Hash]
            #     Required. The config to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     The fields to be updated; only fields explicitly provided are updated.
            #     If no field mask is provided, all provided fields in the request are
            #     updated. To update all fields, provide a field mask of "*".
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::GoogleChannelConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::GoogleChannelConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest.new
            #
            #   # Call the update_google_channel_config method.
            #   result = client.update_google_channel_config request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::GoogleChannelConfig.
            #   p result
            #
            def update_google_channel_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::UpdateGoogleChannelConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_google_channel_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.google_channel_config&.name
                header_params["google_channel_config.name"] = request.google_channel_config.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_google_channel_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_google_channel_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :update_google_channel_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single MessageBus.
            #
            # @overload get_message_bus(request, options = nil)
            #   Pass arguments to `get_message_bus` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetMessageBusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetMessageBusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_message_bus(name: nil)
            #   Pass arguments to `get_message_bus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the message bus to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::MessageBus]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::MessageBus]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetMessageBusRequest.new
            #
            #   # Call the get_message_bus method.
            #   result = client.get_message_bus request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::MessageBus.
            #   p result
            #
            def get_message_bus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetMessageBusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_message_bus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_message_bus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_message_bus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_message_bus, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List message buses.
            #
            # @overload list_message_buses(request, options = nil)
            #   Pass arguments to `list_message_buses` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListMessageBusesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListMessageBusesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_message_buses(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_message_buses` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection to list message buses on.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return on each page.
            #
            #     Note: The service may send fewer.
            #   @param page_token [::String]
            #     Optional. The page token; provide the value from the `next_page_token`
            #     field in a previous call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided must match
            #     the previous call that provided the page token.
            #   @param order_by [::String]
            #     Optional. The sorting order of the resources returned. Value should be a
            #     comma-separated list of fields. The default sorting order is ascending. To
            #     specify descending order for a field, append a `desc` suffix; for example:
            #     `name desc, update_time`.
            #   @param filter [::String]
            #     Optional. The filter field that the list request will filter on.
            #     Possible filtersare described in https://google.aip.dev/160.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::MessageBus>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::MessageBus>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListMessageBusesRequest.new
            #
            #   # Call the list_message_buses method.
            #   result = client.list_message_buses request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Eventarc::V1::MessageBus.
            #     p item
            #   end
            #
            def list_message_buses request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListMessageBusesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_message_buses.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_message_buses.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_message_buses.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_message_buses, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @eventarc_stub, :list_message_buses, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List message bus enrollments.
            #
            # @overload list_message_bus_enrollments(request, options = nil)
            #   Pass arguments to `list_message_bus_enrollments` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_message_bus_enrollments(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_message_bus_enrollments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent message bus to list enrollments on.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return on each page.
            #
            #     Note: The service may send fewer.
            #   @param page_token [::String]
            #     Optional. The page token; provide the value from the `next_page_token`
            #     field in a previous call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided must match
            #     the previous call that provided the page token.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest.new
            #
            #   # Call the list_message_bus_enrollments method.
            #   result = client.list_message_bus_enrollments request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsResponse.
            #   p result
            #
            def list_message_bus_enrollments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListMessageBusEnrollmentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_message_bus_enrollments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_message_bus_enrollments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_message_bus_enrollments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_message_bus_enrollments, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new MessageBus in a particular project and location.
            #
            # @overload create_message_bus(request, options = nil)
            #   Pass arguments to `create_message_bus` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::CreateMessageBusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::CreateMessageBusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_message_bus(parent: nil, message_bus: nil, message_bus_id: nil, validate_only: nil)
            #   Pass arguments to `create_message_bus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection in which to add this message bus.
            #   @param message_bus [::Google::Cloud::Eventarc::V1::MessageBus, ::Hash]
            #     Required. The message bus to create.
            #   @param message_bus_id [::String]
            #     Required. The user-provided ID to be assigned to the MessageBus. It should
            #     match the format `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::CreateMessageBusRequest.new
            #
            #   # Call the create_message_bus method.
            #   result = client.create_message_bus request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_message_bus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::CreateMessageBusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_message_bus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_message_bus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_message_bus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :create_message_bus, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a single message bus.
            #
            # @overload update_message_bus(request, options = nil)
            #   Pass arguments to `update_message_bus` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::UpdateMessageBusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::UpdateMessageBusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_message_bus(message_bus: nil, update_mask: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `update_message_bus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param message_bus [::Google::Cloud::Eventarc::V1::MessageBus, ::Hash]
            #     Required. The MessageBus to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The fields to be updated; only fields explicitly provided are
            #     updated. If no field mask is provided, all provided fields in the request
            #     are updated. To update all fields, provide a field mask of "*".
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the MessageBus is not found, a new MessageBus
            #     will be created. In this situation, `update_mask` is ignored.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::UpdateMessageBusRequest.new
            #
            #   # Call the update_message_bus method.
            #   result = client.update_message_bus request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_message_bus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::UpdateMessageBusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_message_bus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.message_bus&.name
                header_params["message_bus.name"] = request.message_bus.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_message_bus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_message_bus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :update_message_bus, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a single message bus.
            #
            # @overload delete_message_bus(request, options = nil)
            #   Pass arguments to `delete_message_bus` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::DeleteMessageBusRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::DeleteMessageBusRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_message_bus(name: nil, etag: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `delete_message_bus` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the MessageBus to be deleted.
            #   @param etag [::String]
            #     Optional. If provided, the MessageBus will only be deleted if the etag
            #     matches the current etag on the resource.
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the MessageBus is not found, the request will
            #     succeed but no action will be taken on the server.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::DeleteMessageBusRequest.new
            #
            #   # Call the delete_message_bus method.
            #   result = client.delete_message_bus request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_message_bus request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::DeleteMessageBusRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_message_bus.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_message_bus.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_message_bus.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :delete_message_bus, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single Enrollment.
            #
            # @overload get_enrollment(request, options = nil)
            #   Pass arguments to `get_enrollment` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetEnrollmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetEnrollmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_enrollment(name: nil)
            #   Pass arguments to `get_enrollment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Enrollment to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::Enrollment]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::Enrollment]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetEnrollmentRequest.new
            #
            #   # Call the get_enrollment method.
            #   result = client.get_enrollment request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::Enrollment.
            #   p result
            #
            def get_enrollment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetEnrollmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_enrollment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_enrollment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_enrollment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_enrollment, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List Enrollments.
            #
            # @overload list_enrollments(request, options = nil)
            #   Pass arguments to `list_enrollments` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListEnrollmentsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListEnrollmentsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_enrollments(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_enrollments` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection to list triggers on.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return on each page.
            #
            #     Note: The service may send fewer.
            #   @param page_token [::String]
            #     Optional. The page token; provide the value from the `next_page_token`
            #     field in a previous call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided must match
            #     the previous call that provided the page token.
            #   @param order_by [::String]
            #     Optional. The sorting order of the resources returned. Value should be a
            #     comma-separated list of fields. The default sorting order is ascending. To
            #     specify descending order for a field, append a `desc` suffix; for example:
            #     `name desc, update_time`.
            #   @param filter [::String]
            #     Optional. The filter field that the list request will filter on.
            #     Possible filtersare described in https://google.aip.dev/160.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Enrollment>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Enrollment>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListEnrollmentsRequest.new
            #
            #   # Call the list_enrollments method.
            #   result = client.list_enrollments request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Eventarc::V1::Enrollment.
            #     p item
            #   end
            #
            def list_enrollments request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListEnrollmentsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_enrollments.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_enrollments.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_enrollments.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_enrollments, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @eventarc_stub, :list_enrollments, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new Enrollment in a particular project and location.
            #
            # @overload create_enrollment(request, options = nil)
            #   Pass arguments to `create_enrollment` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::CreateEnrollmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::CreateEnrollmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_enrollment(parent: nil, enrollment: nil, enrollment_id: nil, validate_only: nil)
            #   Pass arguments to `create_enrollment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection in which to add this enrollment.
            #   @param enrollment [::Google::Cloud::Eventarc::V1::Enrollment, ::Hash]
            #     Required. The enrollment to create.
            #   @param enrollment_id [::String]
            #     Required. The user-provided ID to be assigned to the Enrollment. It should
            #     match the format `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::CreateEnrollmentRequest.new
            #
            #   # Call the create_enrollment method.
            #   result = client.create_enrollment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_enrollment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::CreateEnrollmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_enrollment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_enrollment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_enrollment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :create_enrollment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a single Enrollment.
            #
            # @overload update_enrollment(request, options = nil)
            #   Pass arguments to `update_enrollment` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_enrollment(enrollment: nil, update_mask: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `update_enrollment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param enrollment [::Google::Cloud::Eventarc::V1::Enrollment, ::Hash]
            #     Required. The Enrollment to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The fields to be updated; only fields explicitly provided are
            #     updated. If no field mask is provided, all provided fields in the request
            #     are updated. To update all fields, provide a field mask of "*".
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the Enrollment is not found, a new Enrollment
            #     will be created. In this situation, `update_mask` is ignored.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest.new
            #
            #   # Call the update_enrollment method.
            #   result = client.update_enrollment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_enrollment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::UpdateEnrollmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_enrollment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.enrollment&.name
                header_params["enrollment.name"] = request.enrollment.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_enrollment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_enrollment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :update_enrollment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a single Enrollment.
            #
            # @overload delete_enrollment(request, options = nil)
            #   Pass arguments to `delete_enrollment` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_enrollment(name: nil, etag: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `delete_enrollment` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Enrollment to be deleted.
            #   @param etag [::String]
            #     Optional. If provided, the Enrollment will only be deleted if the etag
            #     matches the current etag on the resource.
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the Enrollment is not found, the request will
            #     succeed but no action will be taken on the server.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest.new
            #
            #   # Call the delete_enrollment method.
            #   result = client.delete_enrollment request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_enrollment request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::DeleteEnrollmentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_enrollment.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_enrollment.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_enrollment.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :delete_enrollment, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single Pipeline.
            #
            # @overload get_pipeline(request, options = nil)
            #   Pass arguments to `get_pipeline` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetPipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetPipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_pipeline(name: nil)
            #   Pass arguments to `get_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the pipeline to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::Pipeline]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::Pipeline]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetPipelineRequest.new
            #
            #   # Call the get_pipeline method.
            #   result = client.get_pipeline request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::Pipeline.
            #   p result
            #
            def get_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetPipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_pipeline, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List pipelines.
            #
            # @overload list_pipelines(request, options = nil)
            #   Pass arguments to `list_pipelines` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListPipelinesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListPipelinesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_pipelines(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_pipelines` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection to list pipelines on.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return on each page.
            #
            #     Note: The service may send fewer.
            #   @param page_token [::String]
            #     Optional. The page token; provide the value from the `next_page_token`
            #     field in a previous call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided must match
            #     the previous call that provided the page token.
            #   @param order_by [::String]
            #     Optional. The sorting order of the resources returned. Value should be a
            #     comma-separated list of fields. The default sorting order is ascending. To
            #     specify descending order for a field, append a `desc` suffix; for example:
            #     `name desc, update_time`.
            #   @param filter [::String]
            #     Optional. The filter field that the list request will filter on.
            #     Possible filters are described in https://google.aip.dev/160.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Pipeline>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::Pipeline>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListPipelinesRequest.new
            #
            #   # Call the list_pipelines method.
            #   result = client.list_pipelines request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Eventarc::V1::Pipeline.
            #     p item
            #   end
            #
            def list_pipelines request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListPipelinesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_pipelines.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_pipelines.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_pipelines.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_pipelines, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @eventarc_stub, :list_pipelines, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new Pipeline in a particular project and location.
            #
            # @overload create_pipeline(request, options = nil)
            #   Pass arguments to `create_pipeline` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::CreatePipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::CreatePipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_pipeline(parent: nil, pipeline: nil, pipeline_id: nil, validate_only: nil)
            #   Pass arguments to `create_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection in which to add this pipeline.
            #   @param pipeline [::Google::Cloud::Eventarc::V1::Pipeline, ::Hash]
            #     Required. The pipeline to create.
            #   @param pipeline_id [::String]
            #     Required. The user-provided ID to be assigned to the Pipeline. It should
            #     match the format `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::CreatePipelineRequest.new
            #
            #   # Call the create_pipeline method.
            #   result = client.create_pipeline request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::CreatePipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :create_pipeline, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a single pipeline.
            #
            # @overload update_pipeline(request, options = nil)
            #   Pass arguments to `update_pipeline` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::UpdatePipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::UpdatePipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_pipeline(pipeline: nil, update_mask: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `update_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param pipeline [::Google::Cloud::Eventarc::V1::Pipeline, ::Hash]
            #     Required. The Pipeline to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The fields to be updated; only fields explicitly provided are
            #     updated. If no field mask is provided, all provided fields in the request
            #     are updated. To update all fields, provide a field mask of "*".
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the Pipeline is not found, a new Pipeline
            #     will be created. In this situation, `update_mask` is ignored.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::UpdatePipelineRequest.new
            #
            #   # Call the update_pipeline method.
            #   result = client.update_pipeline request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::UpdatePipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.pipeline&.name
                header_params["pipeline.name"] = request.pipeline.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :update_pipeline, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a single pipeline.
            #
            # @overload delete_pipeline(request, options = nil)
            #   Pass arguments to `delete_pipeline` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::DeletePipelineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::DeletePipelineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_pipeline(name: nil, etag: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `delete_pipeline` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the Pipeline to be deleted.
            #   @param etag [::String]
            #     Optional. If provided, the Pipeline will only be deleted if the etag
            #     matches the current etag on the resource.
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the Pipeline is not found, the request will
            #     succeed but no action will be taken on the server.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::DeletePipelineRequest.new
            #
            #   # Call the delete_pipeline method.
            #   result = client.delete_pipeline request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_pipeline request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::DeletePipelineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_pipeline.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_pipeline.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_pipeline.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :delete_pipeline, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a single GoogleApiSource.
            #
            # @overload get_google_api_source(request, options = nil)
            #   Pass arguments to `get_google_api_source` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_google_api_source(name: nil)
            #   Pass arguments to `get_google_api_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the google api source to get.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Eventarc::V1::GoogleApiSource]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Eventarc::V1::GoogleApiSource]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest.new
            #
            #   # Call the get_google_api_source method.
            #   result = client.get_google_api_source request
            #
            #   # The returned object is of type Google::Cloud::Eventarc::V1::GoogleApiSource.
            #   p result
            #
            def get_google_api_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::GetGoogleApiSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_google_api_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_google_api_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_google_api_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :get_google_api_source, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List GoogleApiSources.
            #
            # @overload list_google_api_sources(request, options = nil)
            #   Pass arguments to `list_google_api_sources` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_google_api_sources(parent: nil, page_size: nil, page_token: nil, order_by: nil, filter: nil)
            #   Pass arguments to `list_google_api_sources` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection to list GoogleApiSources on.
            #   @param page_size [::Integer]
            #     Optional. The maximum number of results to return on each page.
            #
            #     Note: The service may send fewer.
            #   @param page_token [::String]
            #     Optional. The page token; provide the value from the `next_page_token`
            #     field in a previous call to retrieve the subsequent page.
            #
            #     When paginating, all other parameters provided must match
            #     the previous call that provided the page token.
            #   @param order_by [::String]
            #     Optional. The sorting order of the resources returned. Value should be a
            #     comma-separated list of fields. The default sorting order is ascending. To
            #     specify descending order for a field, append a `desc` suffix; for example:
            #     `name desc, update_time`.
            #   @param filter [::String]
            #     Optional. The filter field that the list request will filter on.
            #     Possible filtersare described in https://google.aip.dev/160.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::GoogleApiSource>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Eventarc::V1::GoogleApiSource>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest.new
            #
            #   # Call the list_google_api_sources method.
            #   result = client.list_google_api_sources request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Eventarc::V1::GoogleApiSource.
            #     p item
            #   end
            #
            def list_google_api_sources request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::ListGoogleApiSourcesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_google_api_sources.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_google_api_sources.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_google_api_sources.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :list_google_api_sources, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @eventarc_stub, :list_google_api_sources, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a new GoogleApiSource in a particular project and location.
            #
            # @overload create_google_api_source(request, options = nil)
            #   Pass arguments to `create_google_api_source` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_google_api_source(parent: nil, google_api_source: nil, google_api_source_id: nil, validate_only: nil)
            #   Pass arguments to `create_google_api_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent collection in which to add this google api source.
            #   @param google_api_source [::Google::Cloud::Eventarc::V1::GoogleApiSource, ::Hash]
            #     Required. The google api source to create.
            #   @param google_api_source_id [::String]
            #     Required. The user-provided ID to be assigned to the GoogleApiSource. It
            #     should match the format `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest.new
            #
            #   # Call the create_google_api_source method.
            #   result = client.create_google_api_source request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_google_api_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::CreateGoogleApiSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_google_api_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_google_api_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_google_api_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :create_google_api_source, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a single GoogleApiSource.
            #
            # @overload update_google_api_source(request, options = nil)
            #   Pass arguments to `update_google_api_source` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_google_api_source(google_api_source: nil, update_mask: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `update_google_api_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param google_api_source [::Google::Cloud::Eventarc::V1::GoogleApiSource, ::Hash]
            #     Required. The GoogleApiSource to be updated.
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The fields to be updated; only fields explicitly provided are
            #     updated. If no field mask is provided, all provided fields in the request
            #     are updated. To update all fields, provide a field mask of "*".
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the GoogleApiSource is not found, a new
            #     GoogleApiSource will be created. In this situation, `update_mask` is
            #     ignored.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest.new
            #
            #   # Call the update_google_api_source method.
            #   result = client.update_google_api_source request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_google_api_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::UpdateGoogleApiSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_google_api_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.google_api_source&.name
                header_params["google_api_source.name"] = request.google_api_source.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_google_api_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_google_api_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :update_google_api_source, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a single GoogleApiSource.
            #
            # @overload delete_google_api_source(request, options = nil)
            #   Pass arguments to `delete_google_api_source` via a request object, either of type
            #   {::Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_google_api_source(name: nil, etag: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `delete_google_api_source` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name of the GoogleApiSource to be deleted.
            #   @param etag [::String]
            #     Optional. If provided, the MessageBus will only be deleted if the etag
            #     matches the current etag on the resource.
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the MessageBus is not found, the request will
            #     succeed but no action will be taken on the server.
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request and preview the review, but do not
            #     post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/eventarc/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Eventarc::V1::Eventarc::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest.new
            #
            #   # Call the delete_google_api_source method.
            #   result = client.delete_google_api_source request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_google_api_source request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Eventarc::V1::DeleteGoogleApiSourceRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_google_api_source.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Eventarc::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_google_api_source.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_google_api_source.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @eventarc_stub.call_rpc :delete_google_api_source, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Eventarc API.
            #
            # This class represents the configuration for Eventarc,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Eventarc::V1::Eventarc::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # get_trigger to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Eventarc::V1::Eventarc::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_trigger.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.get_trigger.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Eventarc::V1::Eventarc::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "eventarc.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Eventarc API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `get_trigger`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_trigger
                ##
                # RPC-specific configuration for `list_triggers`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_triggers
                ##
                # RPC-specific configuration for `create_trigger`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_trigger
                ##
                # RPC-specific configuration for `update_trigger`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_trigger
                ##
                # RPC-specific configuration for `delete_trigger`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_trigger
                ##
                # RPC-specific configuration for `get_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_channel
                ##
                # RPC-specific configuration for `list_channels`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_channels
                ##
                # RPC-specific configuration for `create_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_channel
                ##
                # RPC-specific configuration for `update_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_channel
                ##
                # RPC-specific configuration for `delete_channel`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_channel
                ##
                # RPC-specific configuration for `get_provider`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_provider
                ##
                # RPC-specific configuration for `list_providers`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_providers
                ##
                # RPC-specific configuration for `get_channel_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_channel_connection
                ##
                # RPC-specific configuration for `list_channel_connections`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_channel_connections
                ##
                # RPC-specific configuration for `create_channel_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_channel_connection
                ##
                # RPC-specific configuration for `delete_channel_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_channel_connection
                ##
                # RPC-specific configuration for `get_google_channel_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_google_channel_config
                ##
                # RPC-specific configuration for `update_google_channel_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_google_channel_config
                ##
                # RPC-specific configuration for `get_message_bus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_message_bus
                ##
                # RPC-specific configuration for `list_message_buses`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_message_buses
                ##
                # RPC-specific configuration for `list_message_bus_enrollments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_message_bus_enrollments
                ##
                # RPC-specific configuration for `create_message_bus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_message_bus
                ##
                # RPC-specific configuration for `update_message_bus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_message_bus
                ##
                # RPC-specific configuration for `delete_message_bus`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_message_bus
                ##
                # RPC-specific configuration for `get_enrollment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_enrollment
                ##
                # RPC-specific configuration for `list_enrollments`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_enrollments
                ##
                # RPC-specific configuration for `create_enrollment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_enrollment
                ##
                # RPC-specific configuration for `update_enrollment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_enrollment
                ##
                # RPC-specific configuration for `delete_enrollment`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_enrollment
                ##
                # RPC-specific configuration for `get_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_pipeline
                ##
                # RPC-specific configuration for `list_pipelines`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_pipelines
                ##
                # RPC-specific configuration for `create_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_pipeline
                ##
                # RPC-specific configuration for `update_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_pipeline
                ##
                # RPC-specific configuration for `delete_pipeline`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_pipeline
                ##
                # RPC-specific configuration for `get_google_api_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_google_api_source
                ##
                # RPC-specific configuration for `list_google_api_sources`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_google_api_sources
                ##
                # RPC-specific configuration for `create_google_api_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_google_api_source
                ##
                # RPC-specific configuration for `update_google_api_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_google_api_source
                ##
                # RPC-specific configuration for `delete_google_api_source`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_google_api_source

                # @private
                def initialize parent_rpcs = nil
                  get_trigger_config = parent_rpcs.get_trigger if parent_rpcs.respond_to? :get_trigger
                  @get_trigger = ::Gapic::Config::Method.new get_trigger_config
                  list_triggers_config = parent_rpcs.list_triggers if parent_rpcs.respond_to? :list_triggers
                  @list_triggers = ::Gapic::Config::Method.new list_triggers_config
                  create_trigger_config = parent_rpcs.create_trigger if parent_rpcs.respond_to? :create_trigger
                  @create_trigger = ::Gapic::Config::Method.new create_trigger_config
                  update_trigger_config = parent_rpcs.update_trigger if parent_rpcs.respond_to? :update_trigger
                  @update_trigger = ::Gapic::Config::Method.new update_trigger_config
                  delete_trigger_config = parent_rpcs.delete_trigger if parent_rpcs.respond_to? :delete_trigger
                  @delete_trigger = ::Gapic::Config::Method.new delete_trigger_config
                  get_channel_config = parent_rpcs.get_channel if parent_rpcs.respond_to? :get_channel
                  @get_channel = ::Gapic::Config::Method.new get_channel_config
                  list_channels_config = parent_rpcs.list_channels if parent_rpcs.respond_to? :list_channels
                  @list_channels = ::Gapic::Config::Method.new list_channels_config
                  create_channel_config = parent_rpcs.create_channel if parent_rpcs.respond_to? :create_channel
                  @create_channel = ::Gapic::Config::Method.new create_channel_config
                  update_channel_config = parent_rpcs.update_channel if parent_rpcs.respond_to? :update_channel
                  @update_channel = ::Gapic::Config::Method.new update_channel_config
                  delete_channel_config = parent_rpcs.delete_channel if parent_rpcs.respond_to? :delete_channel
                  @delete_channel = ::Gapic::Config::Method.new delete_channel_config
                  get_provider_config = parent_rpcs.get_provider if parent_rpcs.respond_to? :get_provider
                  @get_provider = ::Gapic::Config::Method.new get_provider_config
                  list_providers_config = parent_rpcs.list_providers if parent_rpcs.respond_to? :list_providers
                  @list_providers = ::Gapic::Config::Method.new list_providers_config
                  get_channel_connection_config = parent_rpcs.get_channel_connection if parent_rpcs.respond_to? :get_channel_connection
                  @get_channel_connection = ::Gapic::Config::Method.new get_channel_connection_config
                  list_channel_connections_config = parent_rpcs.list_channel_connections if parent_rpcs.respond_to? :list_channel_connections
                  @list_channel_connections = ::Gapic::Config::Method.new list_channel_connections_config
                  create_channel_connection_config = parent_rpcs.create_channel_connection if parent_rpcs.respond_to? :create_channel_connection
                  @create_channel_connection = ::Gapic::Config::Method.new create_channel_connection_config
                  delete_channel_connection_config = parent_rpcs.delete_channel_connection if parent_rpcs.respond_to? :delete_channel_connection
                  @delete_channel_connection = ::Gapic::Config::Method.new delete_channel_connection_config
                  get_google_channel_config_config = parent_rpcs.get_google_channel_config if parent_rpcs.respond_to? :get_google_channel_config
                  @get_google_channel_config = ::Gapic::Config::Method.new get_google_channel_config_config
                  update_google_channel_config_config = parent_rpcs.update_google_channel_config if parent_rpcs.respond_to? :update_google_channel_config
                  @update_google_channel_config = ::Gapic::Config::Method.new update_google_channel_config_config
                  get_message_bus_config = parent_rpcs.get_message_bus if parent_rpcs.respond_to? :get_message_bus
                  @get_message_bus = ::Gapic::Config::Method.new get_message_bus_config
                  list_message_buses_config = parent_rpcs.list_message_buses if parent_rpcs.respond_to? :list_message_buses
                  @list_message_buses = ::Gapic::Config::Method.new list_message_buses_config
                  list_message_bus_enrollments_config = parent_rpcs.list_message_bus_enrollments if parent_rpcs.respond_to? :list_message_bus_enrollments
                  @list_message_bus_enrollments = ::Gapic::Config::Method.new list_message_bus_enrollments_config
                  create_message_bus_config = parent_rpcs.create_message_bus if parent_rpcs.respond_to? :create_message_bus
                  @create_message_bus = ::Gapic::Config::Method.new create_message_bus_config
                  update_message_bus_config = parent_rpcs.update_message_bus if parent_rpcs.respond_to? :update_message_bus
                  @update_message_bus = ::Gapic::Config::Method.new update_message_bus_config
                  delete_message_bus_config = parent_rpcs.delete_message_bus if parent_rpcs.respond_to? :delete_message_bus
                  @delete_message_bus = ::Gapic::Config::Method.new delete_message_bus_config
                  get_enrollment_config = parent_rpcs.get_enrollment if parent_rpcs.respond_to? :get_enrollment
                  @get_enrollment = ::Gapic::Config::Method.new get_enrollment_config
                  list_enrollments_config = parent_rpcs.list_enrollments if parent_rpcs.respond_to? :list_enrollments
                  @list_enrollments = ::Gapic::Config::Method.new list_enrollments_config
                  create_enrollment_config = parent_rpcs.create_enrollment if parent_rpcs.respond_to? :create_enrollment
                  @create_enrollment = ::Gapic::Config::Method.new create_enrollment_config
                  update_enrollment_config = parent_rpcs.update_enrollment if parent_rpcs.respond_to? :update_enrollment
                  @update_enrollment = ::Gapic::Config::Method.new update_enrollment_config
                  delete_enrollment_config = parent_rpcs.delete_enrollment if parent_rpcs.respond_to? :delete_enrollment
                  @delete_enrollment = ::Gapic::Config::Method.new delete_enrollment_config
                  get_pipeline_config = parent_rpcs.get_pipeline if parent_rpcs.respond_to? :get_pipeline
                  @get_pipeline = ::Gapic::Config::Method.new get_pipeline_config
                  list_pipelines_config = parent_rpcs.list_pipelines if parent_rpcs.respond_to? :list_pipelines
                  @list_pipelines = ::Gapic::Config::Method.new list_pipelines_config
                  create_pipeline_config = parent_rpcs.create_pipeline if parent_rpcs.respond_to? :create_pipeline
                  @create_pipeline = ::Gapic::Config::Method.new create_pipeline_config
                  update_pipeline_config = parent_rpcs.update_pipeline if parent_rpcs.respond_to? :update_pipeline
                  @update_pipeline = ::Gapic::Config::Method.new update_pipeline_config
                  delete_pipeline_config = parent_rpcs.delete_pipeline if parent_rpcs.respond_to? :delete_pipeline
                  @delete_pipeline = ::Gapic::Config::Method.new delete_pipeline_config
                  get_google_api_source_config = parent_rpcs.get_google_api_source if parent_rpcs.respond_to? :get_google_api_source
                  @get_google_api_source = ::Gapic::Config::Method.new get_google_api_source_config
                  list_google_api_sources_config = parent_rpcs.list_google_api_sources if parent_rpcs.respond_to? :list_google_api_sources
                  @list_google_api_sources = ::Gapic::Config::Method.new list_google_api_sources_config
                  create_google_api_source_config = parent_rpcs.create_google_api_source if parent_rpcs.respond_to? :create_google_api_source
                  @create_google_api_source = ::Gapic::Config::Method.new create_google_api_source_config
                  update_google_api_source_config = parent_rpcs.update_google_api_source if parent_rpcs.respond_to? :update_google_api_source
                  @update_google_api_source = ::Gapic::Config::Method.new update_google_api_source_config
                  delete_google_api_source_config = parent_rpcs.delete_google_api_source if parent_rpcs.respond_to? :delete_google_api_source
                  @delete_google_api_source = ::Gapic::Config::Method.new delete_google_api_source_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
