# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Eventarc
      module Publishing
        module V1
          # CloudEvent represents a vendor-neutral specification for defining the format
          # of event data.
          # @!attribute [rw] id
          #   @return [::String]
          #     Required. Identifies the event. Producers MUST ensure that source + id is
          #     unique for each distinct event.
          # @!attribute [rw] source
          #   @return [::String]
          #     Required. Identifies the context in which an event happened.
          #     URI-reference
          # @!attribute [rw] spec_version
          #   @return [::String]
          #     Required. The version of the CloudEvents specification which the event
          #     uses.
          # @!attribute [rw] type
          #   @return [::String]
          #     Required. This attribute contains a value describing the type of event
          #     related to the originating occurrence.
          # @!attribute [rw] attributes
          #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Eventarc::Publishing::V1::CloudEvent::CloudEventAttributeValue}]
          #     Optional. Used for Optional & Extension Attributes
          # @!attribute [rw] binary_data
          #   @return [::String]
          #     Optional. Binary data.
          #
          #     Note: The following fields are mutually exclusive: `binary_data`, `text_data`, `proto_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] text_data
          #   @return [::String]
          #     Optional. Text data.
          #
          #     Note: The following fields are mutually exclusive: `text_data`, `binary_data`, `proto_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] proto_data
          #   @return [::Google::Protobuf::Any]
          #     Optional. Proto data.
          #
          #     NOTE: The `protoData` field only functions as expected when the payload
          #     is specifically a `CloudEvent` message type, and can't be used for
          #     arbitrary protocol buffer messages. For any other protocol buffer type,
          #     you must serialize your proto message into bytes, and use the
          #     `binaryData` field instead.
          #
          #     Note: The following fields are mutually exclusive: `proto_data`, `binary_data`, `text_data`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class CloudEvent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The following abstract data types are available for use in attributes.
            # @!attribute [rw] ce_boolean
            #   @return [::Boolean]
            #     Boolean value.
            #
            #     Note: The following fields are mutually exclusive: `ce_boolean`, `ce_integer`, `ce_string`, `ce_bytes`, `ce_uri`, `ce_uri_ref`, `ce_timestamp`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] ce_integer
            #   @return [::Integer]
            #     Integer value.
            #
            #     Note: The following fields are mutually exclusive: `ce_integer`, `ce_boolean`, `ce_string`, `ce_bytes`, `ce_uri`, `ce_uri_ref`, `ce_timestamp`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] ce_string
            #   @return [::String]
            #     String value.
            #
            #     Note: The following fields are mutually exclusive: `ce_string`, `ce_boolean`, `ce_integer`, `ce_bytes`, `ce_uri`, `ce_uri_ref`, `ce_timestamp`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] ce_bytes
            #   @return [::String]
            #     Bytes value.
            #
            #     Note: The following fields are mutually exclusive: `ce_bytes`, `ce_boolean`, `ce_integer`, `ce_string`, `ce_uri`, `ce_uri_ref`, `ce_timestamp`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] ce_uri
            #   @return [::String]
            #     URI value.
            #
            #     Note: The following fields are mutually exclusive: `ce_uri`, `ce_boolean`, `ce_integer`, `ce_string`, `ce_bytes`, `ce_uri_ref`, `ce_timestamp`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] ce_uri_ref
            #   @return [::String]
            #     URI-reference value.
            #
            #     Note: The following fields are mutually exclusive: `ce_uri_ref`, `ce_boolean`, `ce_integer`, `ce_string`, `ce_bytes`, `ce_uri`, `ce_timestamp`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] ce_timestamp
            #   @return [::Google::Protobuf::Timestamp]
            #     Timestamp value.
            #
            #     Note: The following fields are mutually exclusive: `ce_timestamp`, `ce_boolean`, `ce_integer`, `ce_string`, `ce_bytes`, `ce_uri`, `ce_uri_ref`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class CloudEventAttributeValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::Google::Cloud::Eventarc::Publishing::V1::CloudEvent::CloudEventAttributeValue]
            class AttributesEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end
      end
    end
  end
end
