# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/rest"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/eventarc/publishing/v1/version"

require "google/cloud/eventarc/publishing/v1/publisher/credentials"
require "google/cloud/eventarc/publishing/v1/publisher/rest/client"

module Google
  module Cloud
    module Eventarc
      module Publishing
        module V1
          ##
          # Eventarc processes events generated by an event provider and delivers them to
          # a subscriber.
          #
          # An event provider is a software-as-a-service (SaaS) system or
          # product that can generate and deliver events through Eventarc.
          #
          # A third-party event provider is an event provider from outside of Google.
          #
          # A partner is a third-party event provider that is integrated with Eventarc.
          #
          # A subscriber is a Google Cloud customer interested in receiving events.
          #
          # Channel is a first-class Eventarc resource that is created and managed
          # by the subscriber in their Google Cloud project. A Channel represents a
          # subscriber's intent to receive events from an event provider. A Channel is
          # associated with exactly one event provider.
          #
          # ChannelConnection is a first-class Eventarc resource that
          # is created and managed by the partner in their Google Cloud project. A
          # ChannelConnection represents a connection between a partner and a
          # subscriber's Channel. A ChannelConnection has a one-to-one mapping with a
          # Channel.
          #
          # Bus is a first-class Eventarc resource that is created and managed in a
          # Google Cloud project. A Bus provides a discoverable endpoint for events and
          # is a router that receives all events published by event providers and
          # delivers them to zero or more subscribers.
          #
          # Publisher allows an event provider to publish events to Eventarc.
          #
          # To load this service and instantiate a REST client:
          #
          #     require "google/cloud/eventarc/publishing/v1/publisher/rest"
          #     client = ::Google::Cloud::Eventarc::Publishing::V1::Publisher::Rest::Client.new
          #
          module Publisher
            # Client for the REST transport
            module Rest
            end
          end
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "rest", "helpers.rb"
require "google/cloud/eventarc/publishing/v1/publisher/rest/helpers" if ::File.file? helper_path
