# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/essentialcontacts/v1/service_pb"
require "google/cloud/essential_contacts/v1/essential_contacts_service/rest"


class ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_contact
    # Create test objects.
    client_result = ::Google::Cloud::EssentialContacts::V1::Contact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    contact = {}

    create_contact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::ServiceStub.stub :transcode_create_contact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_contact_client_stub do
        # Create client
        client = ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_contact({ parent: parent, contact: contact }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_contact parent: parent, contact: contact do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_contact ::Google::Cloud::EssentialContacts::V1::CreateContactRequest.new(parent: parent, contact: contact) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_contact({ parent: parent, contact: contact }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_contact(::Google::Cloud::EssentialContacts::V1::CreateContactRequest.new(parent: parent, contact: contact), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_contact_client_stub.call_count
      end
    end
  end

  def test_update_contact
    # Create test objects.
    client_result = ::Google::Cloud::EssentialContacts::V1::Contact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    contact = {}
    update_mask = {}

    update_contact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::ServiceStub.stub :transcode_update_contact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_contact_client_stub do
        # Create client
        client = ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_contact({ contact: contact, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_contact contact: contact, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_contact ::Google::Cloud::EssentialContacts::V1::UpdateContactRequest.new(contact: contact, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_contact({ contact: contact, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_contact(::Google::Cloud::EssentialContacts::V1::UpdateContactRequest.new(contact: contact, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_contact_client_stub.call_count
      end
    end
  end

  def test_list_contacts
    # Create test objects.
    client_result = ::Google::Cloud::EssentialContacts::V1::ListContactsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_contacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::ServiceStub.stub :transcode_list_contacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_contacts_client_stub do
        # Create client
        client = ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_contacts({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_contacts parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_contacts ::Google::Cloud::EssentialContacts::V1::ListContactsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_contacts({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_contacts(::Google::Cloud::EssentialContacts::V1::ListContactsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_contacts_client_stub.call_count
      end
    end
  end

  def test_get_contact
    # Create test objects.
    client_result = ::Google::Cloud::EssentialContacts::V1::Contact.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_contact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::ServiceStub.stub :transcode_get_contact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_contact_client_stub do
        # Create client
        client = ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_contact({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_contact name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_contact ::Google::Cloud::EssentialContacts::V1::GetContactRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_contact({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_contact(::Google::Cloud::EssentialContacts::V1::GetContactRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_contact_client_stub.call_count
      end
    end
  end

  def test_delete_contact
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_contact_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::ServiceStub.stub :transcode_delete_contact_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_contact_client_stub do
        # Create client
        client = ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_contact({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_contact name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_contact ::Google::Cloud::EssentialContacts::V1::DeleteContactRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_contact({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_contact(::Google::Cloud::EssentialContacts::V1::DeleteContactRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_contact_client_stub.call_count
      end
    end
  end

  def test_compute_contacts
    # Create test objects.
    client_result = ::Google::Cloud::EssentialContacts::V1::ComputeContactsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    notification_categories = [:NOTIFICATION_CATEGORY_UNSPECIFIED]
    page_size = 42
    page_token = "hello world"

    compute_contacts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::ServiceStub.stub :transcode_compute_contacts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, compute_contacts_client_stub do
        # Create client
        client = ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.compute_contacts({ parent: parent, notification_categories: notification_categories, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.compute_contacts parent: parent, notification_categories: notification_categories, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.compute_contacts ::Google::Cloud::EssentialContacts::V1::ComputeContactsRequest.new(parent: parent, notification_categories: notification_categories, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.compute_contacts({ parent: parent, notification_categories: notification_categories, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.compute_contacts(::Google::Cloud::EssentialContacts::V1::ComputeContactsRequest.new(parent: parent, notification_categories: notification_categories, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, compute_contacts_client_stub.call_count
      end
    end
  end

  def test_send_test_message
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    contacts = ["hello world"]
    resource = "hello world"
    notification_category = :NOTIFICATION_CATEGORY_UNSPECIFIED

    send_test_message_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::ServiceStub.stub :transcode_send_test_message_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, send_test_message_client_stub do
        # Create client
        client = ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.send_test_message({ contacts: contacts, resource: resource, notification_category: notification_category }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.send_test_message contacts: contacts, resource: resource, notification_category: notification_category do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.send_test_message ::Google::Cloud::EssentialContacts::V1::SendTestMessageRequest.new(contacts: contacts, resource: resource, notification_category: notification_category) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.send_test_message({ contacts: contacts, resource: resource, notification_category: notification_category }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.send_test_message(::Google::Cloud::EssentialContacts::V1::SendTestMessageRequest.new(contacts: contacts, resource: resource, notification_category: notification_category), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, send_test_message_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::EssentialContacts::V1::EssentialContactsService::Rest::Client::Configuration, config
  end
end
