# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module EssentialContacts
      module V1
        module EssentialContactsService
          # Path helper methods for the EssentialContactsService API.
          module Paths
            ##
            # Create a fully-qualified Contact resource string.
            #
            # @overload contact_path(project:, contact:)
            #   The resource will be in the following format:
            #
            #   `projects/{project}/contacts/{contact}`
            #
            #   @param project [String]
            #   @param contact [String]
            #
            # @overload contact_path(folder:, contact:)
            #   The resource will be in the following format:
            #
            #   `folders/{folder}/contacts/{contact}`
            #
            #   @param folder [String]
            #   @param contact [String]
            #
            # @overload contact_path(organization:, contact:)
            #   The resource will be in the following format:
            #
            #   `organizations/{organization}/contacts/{contact}`
            #
            #   @param organization [String]
            #   @param contact [String]
            #
            # @return [::String]
            def contact_path **args
              resources = {
                "contact:project" => (proc do |project:, contact:|
                  raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

                  "projects/#{project}/contacts/#{contact}"
                end),
                "contact:folder" => (proc do |folder:, contact:|
                  raise ::ArgumentError, "folder cannot contain /" if folder.to_s.include? "/"

                  "folders/#{folder}/contacts/#{contact}"
                end),
                "contact:organization" => (proc do |organization:, contact:|
                  raise ::ArgumentError, "organization cannot contain /" if organization.to_s.include? "/"

                  "organizations/#{organization}/contacts/#{contact}"
                end)
              }

              resource = resources[args.keys.sort.join(":")]
              raise ::ArgumentError, "no resource found for values #{args.keys}" if resource.nil?
              resource.call(**args)
            end

            ##
            # Create a fully-qualified Folder resource string.
            #
            # The resource will be in the following format:
            #
            # `folders/{folder}`
            #
            # @param folder [String]
            #
            # @return [::String]
            def folder_path folder:
              "folders/#{folder}"
            end

            ##
            # Create a fully-qualified Organization resource string.
            #
            # The resource will be in the following format:
            #
            # `organizations/{organization}`
            #
            # @param organization [String]
            #
            # @return [::String]
            def organization_path organization:
              "organizations/#{organization}"
            end

            ##
            # Create a fully-qualified Project resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}`
            #
            # @param project [String]
            #
            # @return [::String]
            def project_path project:
              "projects/#{project}"
            end

            extend self
          end
        end
      end
    end
  end
end
