# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/devtools/clouderrorreporting/v1beta1/error_stats_service_pb"
require "google/cloud/error_reporting/v1beta1/error_stats_service/rest"


class ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_group_stats
    # Create test objects.
    client_result = ::Google::Cloud::ErrorReporting::V1beta1::ListGroupStatsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_name = "hello world"
    group_id = ["hello world"]
    service_filter = {}
    time_range = {}
    timed_count_duration = {}
    alignment = :ERROR_COUNT_ALIGNMENT_UNSPECIFIED
    alignment_time = {}
    order = :GROUP_ORDER_UNSPECIFIED
    page_size = 42
    page_token = "hello world"

    list_group_stats_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::ServiceStub.stub :transcode_list_group_stats_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_group_stats_client_stub do
        # Create client
        client = ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_group_stats({ project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, timed_count_duration: timed_count_duration, alignment: alignment, alignment_time: alignment_time, order: order, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_group_stats project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, timed_count_duration: timed_count_duration, alignment: alignment, alignment_time: alignment_time, order: order, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_group_stats ::Google::Cloud::ErrorReporting::V1beta1::ListGroupStatsRequest.new(project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, timed_count_duration: timed_count_duration, alignment: alignment, alignment_time: alignment_time, order: order, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_group_stats({ project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, timed_count_duration: timed_count_duration, alignment: alignment, alignment_time: alignment_time, order: order, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_group_stats(::Google::Cloud::ErrorReporting::V1beta1::ListGroupStatsRequest.new(project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, timed_count_duration: timed_count_duration, alignment: alignment, alignment_time: alignment_time, order: order, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_group_stats_client_stub.call_count
      end
    end
  end

  def test_list_events
    # Create test objects.
    client_result = ::Google::Cloud::ErrorReporting::V1beta1::ListEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_name = "hello world"
    group_id = "hello world"
    service_filter = {}
    time_range = {}
    page_size = 42
    page_token = "hello world"

    list_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::ServiceStub.stub :transcode_list_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_events_client_stub do
        # Create client
        client = ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_events({ project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_events project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_events ::Google::Cloud::ErrorReporting::V1beta1::ListEventsRequest.new(project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_events({ project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_events(::Google::Cloud::ErrorReporting::V1beta1::ListEventsRequest.new(project_name: project_name, group_id: group_id, service_filter: service_filter, time_range: time_range, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_events_client_stub.call_count
      end
    end
  end

  def test_delete_events
    # Create test objects.
    client_result = ::Google::Cloud::ErrorReporting::V1beta1::DeleteEventsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_name = "hello world"

    delete_events_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::ServiceStub.stub :transcode_delete_events_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_events_client_stub do
        # Create client
        client = ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_events({ project_name: project_name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_events project_name: project_name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_events ::Google::Cloud::ErrorReporting::V1beta1::DeleteEventsRequest.new(project_name: project_name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_events({ project_name: project_name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_events(::Google::Cloud::ErrorReporting::V1beta1::DeleteEventsRequest.new(project_name: project_name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_events_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::ErrorReporting::V1beta1::ErrorStatsService::Rest::Client::Configuration, config
  end
end
