# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/edgenetwork/v1/service_pb"
require "google/cloud/edge_network/v1/edge_network"

class ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_initialize_zone
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::InitializeZoneResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    initialize_zone_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :initialize_zone, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, initialize_zone_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.initialize_zone({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.initialize_zone name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.initialize_zone ::Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.initialize_zone({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.initialize_zone(::Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, initialize_zone_client_stub.call_rpc_count
    end
  end

  def test_list_zones
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::ListZonesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_zones_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_zones, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::ListZonesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_zones_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_zones({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_zones parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_zones ::Google::Cloud::EdgeNetwork::V1::ListZonesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_zones({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_zones(::Google::Cloud::EdgeNetwork::V1::ListZonesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_zones_client_stub.call_rpc_count
    end
  end

  def test_get_zone
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::Zone.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_zone_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_zone, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::GetZoneRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_zone_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_zone({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_zone name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_zone ::Google::Cloud::EdgeNetwork::V1::GetZoneRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_zone({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_zone(::Google::Cloud::EdgeNetwork::V1::GetZoneRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_zone_client_stub.call_rpc_count
    end
  end

  def test_list_networks
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::ListNetworksResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_networks_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_networks, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::ListNetworksRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_networks_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_networks parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_networks ::Google::Cloud::EdgeNetwork::V1::ListNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_networks(::Google::Cloud::EdgeNetwork::V1::ListNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_networks_client_stub.call_rpc_count
    end
  end

  def test_get_network
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::Network.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_network, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::GetNetworkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_network_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_network({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_network name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_network ::Google::Cloud::EdgeNetwork::V1::GetNetworkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_network({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_network(::Google::Cloud::EdgeNetwork::V1::GetNetworkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_network_client_stub.call_rpc_count
    end
  end

  def test_diagnose_network
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    diagnose_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :diagnose_network, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, diagnose_network_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.diagnose_network({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.diagnose_network name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.diagnose_network ::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.diagnose_network({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.diagnose_network(::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, diagnose_network_client_stub.call_rpc_count
    end
  end

  def test_create_network
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    network_id = "hello world"
    network = {}
    request_id = "hello world"

    create_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_network, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["network_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::EdgeNetwork::V1::Network), request["network"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_network_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_network({ parent: parent, network_id: network_id, network: network, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_network parent: parent, network_id: network_id, network: network, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_network ::Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest.new(parent: parent, network_id: network_id, network: network, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_network({ parent: parent, network_id: network_id, network: network, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_network(::Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest.new(parent: parent, network_id: network_id, network: network, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_network_client_stub.call_rpc_count
    end
  end

  def test_delete_network
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_network_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_network, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_network_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_network({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_network name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_network ::Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_network({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_network(::Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_network_client_stub.call_rpc_count
    end
  end

  def test_list_subnets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::ListSubnetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_subnets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_subnets, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_subnets_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_subnets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_subnets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_subnets ::Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_subnets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_subnets(::Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_subnets_client_stub.call_rpc_count
    end
  end

  def test_get_subnet
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::Subnet.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subnet_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_subnet, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::GetSubnetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_subnet_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_subnet({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_subnet name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_subnet ::Google::Cloud::EdgeNetwork::V1::GetSubnetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_subnet({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_subnet(::Google::Cloud::EdgeNetwork::V1::GetSubnetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_subnet_client_stub.call_rpc_count
    end
  end

  def test_create_subnet
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subnet_id = "hello world"
    subnet = {}
    request_id = "hello world"

    create_subnet_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_subnet, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["subnet_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::EdgeNetwork::V1::Subnet), request["subnet"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_subnet_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_subnet({ parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_subnet parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_subnet ::Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest.new(parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_subnet({ parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_subnet(::Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest.new(parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_subnet_client_stub.call_rpc_count
    end
  end

  def test_update_subnet
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    subnet = {}
    request_id = "hello world"

    update_subnet_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_subnet, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::EdgeNetwork::V1::Subnet), request["subnet"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_subnet_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_subnet({ update_mask: update_mask, subnet: subnet, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_subnet update_mask: update_mask, subnet: subnet, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_subnet ::Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest.new(update_mask: update_mask, subnet: subnet, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_subnet({ update_mask: update_mask, subnet: subnet, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_subnet(::Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest.new(update_mask: update_mask, subnet: subnet, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_subnet_client_stub.call_rpc_count
    end
  end

  def test_delete_subnet
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_subnet_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_subnet, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_subnet_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_subnet({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_subnet name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_subnet ::Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_subnet({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_subnet(::Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_subnet_client_stub.call_rpc_count
    end
  end

  def test_list_interconnects
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::ListInterconnectsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_interconnects_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_interconnects, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_interconnects_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_interconnects({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_interconnects parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_interconnects ::Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_interconnects({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_interconnects(::Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_interconnects_client_stub.call_rpc_count
    end
  end

  def test_get_interconnect
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::Interconnect.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_interconnect_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_interconnect, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_interconnect_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_interconnect({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_interconnect name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_interconnect ::Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_interconnect({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_interconnect(::Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_interconnect_client_stub.call_rpc_count
    end
  end

  def test_diagnose_interconnect
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    diagnose_interconnect_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :diagnose_interconnect, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, diagnose_interconnect_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.diagnose_interconnect({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.diagnose_interconnect name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.diagnose_interconnect ::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.diagnose_interconnect({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.diagnose_interconnect(::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, diagnose_interconnect_client_stub.call_rpc_count
    end
  end

  def test_list_interconnect_attachments
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_interconnect_attachments_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_interconnect_attachments, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_interconnect_attachments_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_interconnect_attachments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_interconnect_attachments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_interconnect_attachments ::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_interconnect_attachments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_interconnect_attachments(::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_interconnect_attachments_client_stub.call_rpc_count
    end
  end

  def test_get_interconnect_attachment
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_interconnect_attachment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_interconnect_attachment, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_interconnect_attachment_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_interconnect_attachment({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_interconnect_attachment name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_interconnect_attachment ::Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_interconnect_attachment({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_interconnect_attachment(::Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_interconnect_attachment_client_stub.call_rpc_count
    end
  end

  def test_create_interconnect_attachment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    interconnect_attachment_id = "hello world"
    interconnect_attachment = {}
    request_id = "hello world"

    create_interconnect_attachment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_interconnect_attachment, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["interconnect_attachment_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment), request["interconnect_attachment"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_interconnect_attachment_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_interconnect_attachment({ parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_interconnect_attachment parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_interconnect_attachment ::Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest.new(parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_interconnect_attachment({ parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_interconnect_attachment(::Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest.new(parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_interconnect_attachment_client_stub.call_rpc_count
    end
  end

  def test_delete_interconnect_attachment
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_interconnect_attachment_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_interconnect_attachment, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_interconnect_attachment_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_interconnect_attachment({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_interconnect_attachment name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_interconnect_attachment ::Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_interconnect_attachment({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_interconnect_attachment(::Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_interconnect_attachment_client_stub.call_rpc_count
    end
  end

  def test_list_routers
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::ListRoutersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_routers_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_routers, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::ListRoutersRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_routers_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_routers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_routers parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_routers ::Google::Cloud::EdgeNetwork::V1::ListRoutersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_routers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_routers(::Google::Cloud::EdgeNetwork::V1::ListRoutersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_routers_client_stub.call_rpc_count
    end
  end

  def test_get_router
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::Router.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_router_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_router, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::GetRouterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_router_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_router({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_router name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_router ::Google::Cloud::EdgeNetwork::V1::GetRouterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_router({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_router(::Google::Cloud::EdgeNetwork::V1::GetRouterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_router_client_stub.call_rpc_count
    end
  end

  def test_diagnose_router
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    diagnose_router_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :diagnose_router, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, diagnose_router_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.diagnose_router({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.diagnose_router name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.diagnose_router ::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.diagnose_router({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.diagnose_router(::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, diagnose_router_client_stub.call_rpc_count
    end
  end

  def test_create_router
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    router_id = "hello world"
    router = {}
    request_id = "hello world"

    create_router_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_router, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::CreateRouterRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["router_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::EdgeNetwork::V1::Router), request["router"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_router_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_router({ parent: parent, router_id: router_id, router: router, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_router parent: parent, router_id: router_id, router: router, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_router ::Google::Cloud::EdgeNetwork::V1::CreateRouterRequest.new(parent: parent, router_id: router_id, router: router, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_router({ parent: parent, router_id: router_id, router: router, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_router(::Google::Cloud::EdgeNetwork::V1::CreateRouterRequest.new(parent: parent, router_id: router_id, router: router, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_router_client_stub.call_rpc_count
    end
  end

  def test_update_router
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    router = {}
    request_id = "hello world"

    update_router_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_router, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::EdgeNetwork::V1::Router), request["router"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_router_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_router({ update_mask: update_mask, router: router, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_router update_mask: update_mask, router: router, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_router ::Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest.new(update_mask: update_mask, router: router, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_router({ update_mask: update_mask, router: router, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_router(::Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest.new(update_mask: update_mask, router: router, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_router_client_stub.call_rpc_count
    end
  end

  def test_delete_router
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_router_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_router, name
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_router_client_stub do
      # Create client
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_router({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_router name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_router ::Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_router({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_router(::Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_router_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Operations, client.operations_client
  end
end
