# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/edgenetwork/v1/service_pb"
require "google/cloud/edge_network/v1/edge_network/rest"


class ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_initialize_zone
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::InitializeZoneResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    initialize_zone_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_initialize_zone_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, initialize_zone_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.initialize_zone({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.initialize_zone name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.initialize_zone ::Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.initialize_zone({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.initialize_zone(::Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, initialize_zone_client_stub.call_count
      end
    end
  end

  def test_list_zones
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::ListZonesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_zones_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_list_zones_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_zones_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_zones({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_zones parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_zones ::Google::Cloud::EdgeNetwork::V1::ListZonesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_zones({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_zones(::Google::Cloud::EdgeNetwork::V1::ListZonesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_zones_client_stub.call_count
      end
    end
  end

  def test_get_zone
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::Zone.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_zone_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_get_zone_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_zone_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_zone({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_zone name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_zone ::Google::Cloud::EdgeNetwork::V1::GetZoneRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_zone({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_zone(::Google::Cloud::EdgeNetwork::V1::GetZoneRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_zone_client_stub.call_count
      end
    end
  end

  def test_list_networks
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::ListNetworksResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_networks_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_list_networks_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_networks_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_networks parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_networks ::Google::Cloud::EdgeNetwork::V1::ListNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_networks({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_networks(::Google::Cloud::EdgeNetwork::V1::ListNetworksRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_networks_client_stub.call_count
      end
    end
  end

  def test_get_network
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::Network.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_get_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_network_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_network({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_network name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_network ::Google::Cloud::EdgeNetwork::V1::GetNetworkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_network({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_network(::Google::Cloud::EdgeNetwork::V1::GetNetworkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_network_client_stub.call_count
      end
    end
  end

  def test_diagnose_network
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    diagnose_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_diagnose_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, diagnose_network_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.diagnose_network({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.diagnose_network name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.diagnose_network ::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.diagnose_network({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.diagnose_network(::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, diagnose_network_client_stub.call_count
      end
    end
  end

  def test_create_network
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    network_id = "hello world"
    network = {}
    request_id = "hello world"

    create_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_create_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_network_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_network({ parent: parent, network_id: network_id, network: network, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_network parent: parent, network_id: network_id, network: network, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_network ::Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest.new(parent: parent, network_id: network_id, network: network, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_network({ parent: parent, network_id: network_id, network: network, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_network(::Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest.new(parent: parent, network_id: network_id, network: network, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_network_client_stub.call_count
      end
    end
  end

  def test_delete_network
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_network_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_delete_network_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_network_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_network({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_network name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_network ::Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_network({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_network(::Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_network_client_stub.call_count
      end
    end
  end

  def test_list_subnets
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::ListSubnetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_subnets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_list_subnets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_subnets_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_subnets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_subnets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_subnets ::Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_subnets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_subnets(::Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_subnets_client_stub.call_count
      end
    end
  end

  def test_get_subnet
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::Subnet.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_get_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_subnet({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_subnet name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_subnet ::Google::Cloud::EdgeNetwork::V1::GetSubnetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_subnet({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_subnet(::Google::Cloud::EdgeNetwork::V1::GetSubnetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_subnet_client_stub.call_count
      end
    end
  end

  def test_create_subnet
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    subnet_id = "hello world"
    subnet = {}
    request_id = "hello world"

    create_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_create_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_subnet({ parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_subnet parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_subnet ::Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest.new(parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_subnet({ parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_subnet(::Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest.new(parent: parent, subnet_id: subnet_id, subnet: subnet, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_subnet_client_stub.call_count
      end
    end
  end

  def test_update_subnet
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    subnet = {}
    request_id = "hello world"

    update_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_update_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_subnet({ update_mask: update_mask, subnet: subnet, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_subnet update_mask: update_mask, subnet: subnet, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_subnet ::Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest.new(update_mask: update_mask, subnet: subnet, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_subnet({ update_mask: update_mask, subnet: subnet, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_subnet(::Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest.new(update_mask: update_mask, subnet: subnet, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_subnet_client_stub.call_count
      end
    end
  end

  def test_delete_subnet
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_subnet_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_delete_subnet_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_subnet_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_subnet({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_subnet name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_subnet ::Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_subnet({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_subnet(::Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_subnet_client_stub.call_count
      end
    end
  end

  def test_list_interconnects
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::ListInterconnectsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_interconnects_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_list_interconnects_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_interconnects_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_interconnects({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_interconnects parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_interconnects ::Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_interconnects({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_interconnects(::Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_interconnects_client_stub.call_count
      end
    end
  end

  def test_get_interconnect
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::Interconnect.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_interconnect_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_get_interconnect_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_interconnect_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_interconnect({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_interconnect name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_interconnect ::Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_interconnect({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_interconnect(::Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_interconnect_client_stub.call_count
      end
    end
  end

  def test_diagnose_interconnect
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    diagnose_interconnect_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_diagnose_interconnect_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, diagnose_interconnect_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.diagnose_interconnect({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.diagnose_interconnect name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.diagnose_interconnect ::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.diagnose_interconnect({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.diagnose_interconnect(::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, diagnose_interconnect_client_stub.call_count
      end
    end
  end

  def test_list_interconnect_attachments
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_interconnect_attachments_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_list_interconnect_attachments_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_interconnect_attachments_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_interconnect_attachments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_interconnect_attachments parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_interconnect_attachments ::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_interconnect_attachments({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_interconnect_attachments(::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_interconnect_attachments_client_stub.call_count
      end
    end
  end

  def test_get_interconnect_attachment
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_interconnect_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_get_interconnect_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_interconnect_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_interconnect_attachment({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_interconnect_attachment name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_interconnect_attachment ::Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_interconnect_attachment({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_interconnect_attachment(::Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_interconnect_attachment_client_stub.call_count
      end
    end
  end

  def test_create_interconnect_attachment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    interconnect_attachment_id = "hello world"
    interconnect_attachment = {}
    request_id = "hello world"

    create_interconnect_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_create_interconnect_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_interconnect_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_interconnect_attachment({ parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_interconnect_attachment parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_interconnect_attachment ::Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest.new(parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_interconnect_attachment({ parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_interconnect_attachment(::Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest.new(parent: parent, interconnect_attachment_id: interconnect_attachment_id, interconnect_attachment: interconnect_attachment, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_interconnect_attachment_client_stub.call_count
      end
    end
  end

  def test_delete_interconnect_attachment
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_interconnect_attachment_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_delete_interconnect_attachment_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_interconnect_attachment_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_interconnect_attachment({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_interconnect_attachment name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_interconnect_attachment ::Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_interconnect_attachment({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_interconnect_attachment(::Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_interconnect_attachment_client_stub.call_count
      end
    end
  end

  def test_list_routers
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::ListRoutersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_routers_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_list_routers_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_routers_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_routers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_routers parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_routers ::Google::Cloud::EdgeNetwork::V1::ListRoutersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_routers({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_routers(::Google::Cloud::EdgeNetwork::V1::ListRoutersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_routers_client_stub.call_count
      end
    end
  end

  def test_get_router
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::Router.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_router_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_get_router_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_router_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_router({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_router name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_router ::Google::Cloud::EdgeNetwork::V1::GetRouterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_router({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_router(::Google::Cloud::EdgeNetwork::V1::GetRouterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_router_client_stub.call_count
      end
    end
  end

  def test_diagnose_router
    # Create test objects.
    client_result = ::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    diagnose_router_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_diagnose_router_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, diagnose_router_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.diagnose_router({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.diagnose_router name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.diagnose_router ::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.diagnose_router({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.diagnose_router(::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, diagnose_router_client_stub.call_count
      end
    end
  end

  def test_create_router
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    router_id = "hello world"
    router = {}
    request_id = "hello world"

    create_router_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_create_router_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_router_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_router({ parent: parent, router_id: router_id, router: router, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_router parent: parent, router_id: router_id, router: router, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_router ::Google::Cloud::EdgeNetwork::V1::CreateRouterRequest.new(parent: parent, router_id: router_id, router: router, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_router({ parent: parent, router_id: router_id, router: router, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_router(::Google::Cloud::EdgeNetwork::V1::CreateRouterRequest.new(parent: parent, router_id: router_id, router: router, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_router_client_stub.call_count
      end
    end
  end

  def test_update_router
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    router = {}
    request_id = "hello world"

    update_router_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_update_router_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_router_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_router({ update_mask: update_mask, router: router, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_router update_mask: update_mask, router: router, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_router ::Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest.new(update_mask: update_mask, router: router, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_router({ update_mask: update_mask, router: router, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_router(::Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest.new(update_mask: update_mask, router: router, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_router_client_stub.call_count
      end
    end
  end

  def test_delete_router
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_router_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.stub :transcode_delete_router_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_router_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_router({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_router name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_router ::Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_router({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_router(::Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_router_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client::Configuration, config
  end
end
