# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/edgenetwork/v1/service_pb"
require "google/cloud/edge_network/v1/edge_network/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module EdgeNetwork
      module V1
        module EdgeNetwork
          module Rest
            ##
            # REST client for the EdgeNetwork service.
            #
            # EdgeNetwork API provides managed, highly available cloud dynamic network
            # configuration service to the GEC customer to enable edge application and
            # network function solutions. This allows the customers to easily define and
            # configure the network setup and property to meet the workload requirement.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "edgenetwork.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :edge_network_stub

              ##
              # Configure the EdgeNetwork Client class.
              #
              # See {::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all EdgeNetwork clients
              #   ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "EdgeNetwork", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.initialize_zone.timeout = 60.0

                  default_config.rpcs.list_networks.timeout = 60.0
                  default_config.rpcs.list_networks.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_network.timeout = 60.0
                  default_config.rpcs.get_network.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.diagnose_network.timeout = 60.0
                  default_config.rpcs.diagnose_network.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_network.timeout = 60.0

                  default_config.rpcs.delete_network.timeout = 60.0

                  default_config.rpcs.list_subnets.timeout = 60.0
                  default_config.rpcs.list_subnets.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_subnet.timeout = 60.0
                  default_config.rpcs.get_subnet.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_subnet.timeout = 60.0

                  default_config.rpcs.delete_subnet.timeout = 60.0

                  default_config.rpcs.list_interconnects.timeout = 60.0
                  default_config.rpcs.list_interconnects.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_interconnect.timeout = 60.0
                  default_config.rpcs.get_interconnect.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.diagnose_interconnect.timeout = 60.0
                  default_config.rpcs.diagnose_interconnect.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_interconnect_attachments.timeout = 60.0
                  default_config.rpcs.list_interconnect_attachments.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_interconnect_attachment.timeout = 60.0
                  default_config.rpcs.get_interconnect_attachment.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_interconnect_attachment.timeout = 60.0

                  default_config.rpcs.delete_interconnect_attachment.timeout = 60.0

                  default_config.rpcs.list_routers.timeout = 60.0
                  default_config.rpcs.list_routers.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_router.timeout = 60.0
                  default_config.rpcs.get_router.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.diagnose_router.timeout = 60.0
                  default_config.rpcs.diagnose_router.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_router.timeout = 60.0

                  default_config.rpcs.update_router.timeout = 60.0

                  default_config.rpcs.delete_router.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the EdgeNetwork Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @edge_network_stub.universe_domain
              end

              ##
              # Create a new EdgeNetwork REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the EdgeNetwork client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @edge_network_stub = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @edge_network_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @edge_network_stub.endpoint
                  config.universe_domain = @edge_network_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @edge_network_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @edge_network_stub.logger
              end

              # Service calls

              ##
              # InitializeZone will initialize resources for a zone in a project.
              #
              # @overload initialize_zone(request, options = nil)
              #   Pass arguments to `initialize_zone` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload initialize_zone(name: nil)
              #   Pass arguments to `initialize_zone` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the zone resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::InitializeZoneResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::InitializeZoneResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest.new
              #
              #   # Call the initialize_zone method.
              #   result = client.initialize_zone request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::InitializeZoneResponse.
              #   p result
              #
              def initialize_zone request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::InitializeZoneRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.initialize_zone.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.initialize_zone.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.initialize_zone.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.initialize_zone request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: not implemented.
              # Lists Zones in a given project and location.
              #
              # @overload list_zones(request, options = nil)
              #   Pass arguments to `list_zones` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::ListZonesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::ListZonesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_zones(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_zones` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListZonesRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Zone>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Zone>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::ListZonesRequest.new
              #
              #   # Call the list_zones method.
              #   result = client.list_zones request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::EdgeNetwork::V1::Zone.
              #     p item
              #   end
              #
              def list_zones request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::ListZonesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_zones.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_zones.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_zones.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.list_zones request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @edge_network_stub, :list_zones, "zones", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deprecated: not implemented.
              # Gets details of a single Zone.
              #
              # @overload get_zone(request, options = nil)
              #   Pass arguments to `get_zone` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::GetZoneRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::GetZoneRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_zone(name: nil)
              #   Pass arguments to `get_zone` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::Zone]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::Zone]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::GetZoneRequest.new
              #
              #   # Call the get_zone method.
              #   result = client.get_zone request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::Zone.
              #   p result
              #
              def get_zone request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::GetZoneRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_zone.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_zone.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_zone.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.get_zone request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Networks in a given project and location.
              #
              # @overload list_networks(request, options = nil)
              #   Pass arguments to `list_networks` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::ListNetworksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::ListNetworksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_networks(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_networks` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListNetworksRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Network>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Network>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::ListNetworksRequest.new
              #
              #   # Call the list_networks method.
              #   result = client.list_networks request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::EdgeNetwork::V1::Network.
              #     p item
              #   end
              #
              def list_networks request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::ListNetworksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_networks.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_networks.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_networks.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.list_networks request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @edge_network_stub, :list_networks, "networks", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Network.
              #
              # @overload get_network(request, options = nil)
              #   Pass arguments to `get_network` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::GetNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::GetNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_network(name: nil)
              #   Pass arguments to `get_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::Network]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::Network]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::GetNetworkRequest.new
              #
              #   # Call the get_network method.
              #   result = client.get_network request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::Network.
              #   p result
              #
              def get_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::GetNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.get_network request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the diagnostics of a single network resource.
              #
              # @overload diagnose_network(request, options = nil)
              #   Pass arguments to `diagnose_network` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload diagnose_network(name: nil)
              #   Pass arguments to `diagnose_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the network resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest.new
              #
              #   # Call the diagnose_network method.
              #   result = client.diagnose_network request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkResponse.
              #   p result
              #
              def diagnose_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::DiagnoseNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.diagnose_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.diagnose_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.diagnose_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.diagnose_network request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Network in a given project and location.
              #
              # @overload create_network(request, options = nil)
              #   Pass arguments to `create_network` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_network(parent: nil, network_id: nil, network: nil, request_id: nil)
              #   Pass arguments to `create_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param network_id [::String]
              #     Required. Id of the requesting object
              #     If auto-generating Id server-side, remove this field and
              #     network_id from the method_signature of Create RPC
              #   @param network [::Google::Cloud::EdgeNetwork::V1::Network, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest.new
              #
              #   # Call the create_network method.
              #   result = client.create_network request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::CreateNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.create_network request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Network.
              #
              # @overload delete_network(request, options = nil)
              #   Pass arguments to `delete_network` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_network(name: nil, request_id: nil)
              #   Pass arguments to `delete_network` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest.new
              #
              #   # Call the delete_network method.
              #   result = client.delete_network request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_network request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::DeleteNetworkRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_network.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_network.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_network.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.delete_network request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Subnets in a given project and location.
              #
              # @overload list_subnets(request, options = nil)
              #   Pass arguments to `list_subnets` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_subnets(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_subnets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListSubnetsRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Subnet>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Subnet>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest.new
              #
              #   # Call the list_subnets method.
              #   result = client.list_subnets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::EdgeNetwork::V1::Subnet.
              #     p item
              #   end
              #
              def list_subnets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::ListSubnetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_subnets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_subnets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_subnets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.list_subnets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @edge_network_stub, :list_subnets, "subnets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Subnet.
              #
              # @overload get_subnet(request, options = nil)
              #   Pass arguments to `get_subnet` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::GetSubnetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::GetSubnetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_subnet(name: nil)
              #   Pass arguments to `get_subnet` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::Subnet]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::Subnet]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::GetSubnetRequest.new
              #
              #   # Call the get_subnet method.
              #   result = client.get_subnet request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::Subnet.
              #   p result
              #
              def get_subnet request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::GetSubnetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_subnet.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_subnet.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_subnet.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.get_subnet request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Subnet in a given project and location.
              #
              # @overload create_subnet(request, options = nil)
              #   Pass arguments to `create_subnet` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_subnet(parent: nil, subnet_id: nil, subnet: nil, request_id: nil)
              #   Pass arguments to `create_subnet` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param subnet_id [::String]
              #     Required. Id of the requesting object
              #     If auto-generating Id server-side, remove this field and
              #     subnet_id from the method_signature of Create RPC
              #   @param subnet [::Google::Cloud::EdgeNetwork::V1::Subnet, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest.new
              #
              #   # Call the create_subnet method.
              #   result = client.create_subnet request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_subnet request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::CreateSubnetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_subnet.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_subnet.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_subnet.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.create_subnet request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Subnet.
              #
              # @overload update_subnet(request, options = nil)
              #   Pass arguments to `update_subnet` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_subnet(update_mask: nil, subnet: nil, request_id: nil)
              #   Pass arguments to `update_subnet` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Subnet resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param subnet [::Google::Cloud::EdgeNetwork::V1::Subnet, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest.new
              #
              #   # Call the update_subnet method.
              #   result = client.update_subnet request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_subnet request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::UpdateSubnetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_subnet.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_subnet.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_subnet.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.update_subnet request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Subnet.
              #
              # @overload delete_subnet(request, options = nil)
              #   Pass arguments to `delete_subnet` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_subnet(name: nil, request_id: nil)
              #   Pass arguments to `delete_subnet` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest.new
              #
              #   # Call the delete_subnet method.
              #   result = client.delete_subnet request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_subnet request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::DeleteSubnetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_subnet.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_subnet.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_subnet.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.delete_subnet request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Interconnects in a given project and location.
              #
              # @overload list_interconnects(request, options = nil)
              #   Pass arguments to `list_interconnects` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_interconnects(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_interconnects` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListInterconnectsRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Interconnect>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Interconnect>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest.new
              #
              #   # Call the list_interconnects method.
              #   result = client.list_interconnects request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::EdgeNetwork::V1::Interconnect.
              #     p item
              #   end
              #
              def list_interconnects request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::ListInterconnectsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_interconnects.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_interconnects.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_interconnects.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.list_interconnects request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @edge_network_stub, :list_interconnects, "interconnects", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Interconnect.
              #
              # @overload get_interconnect(request, options = nil)
              #   Pass arguments to `get_interconnect` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_interconnect(name: nil)
              #   Pass arguments to `get_interconnect` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::Interconnect]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::Interconnect]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest.new
              #
              #   # Call the get_interconnect method.
              #   result = client.get_interconnect request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::Interconnect.
              #   p result
              #
              def get_interconnect request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::GetInterconnectRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_interconnect.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_interconnect.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_interconnect.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.get_interconnect request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the diagnostics of a single interconnect resource.
              #
              # @overload diagnose_interconnect(request, options = nil)
              #   Pass arguments to `diagnose_interconnect` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload diagnose_interconnect(name: nil)
              #   Pass arguments to `diagnose_interconnect` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the interconnect resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest.new
              #
              #   # Call the diagnose_interconnect method.
              #   result = client.diagnose_interconnect request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectResponse.
              #   p result
              #
              def diagnose_interconnect request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::DiagnoseInterconnectRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.diagnose_interconnect.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.diagnose_interconnect.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.diagnose_interconnect.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.diagnose_interconnect request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists InterconnectAttachments in a given project and location.
              #
              # @overload list_interconnect_attachments(request, options = nil)
              #   Pass arguments to `list_interconnect_attachments` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_interconnect_attachments(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_interconnect_attachments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListInterconnectAttachmentsRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest.new
              #
              #   # Call the list_interconnect_attachments method.
              #   result = client.list_interconnect_attachments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment.
              #     p item
              #   end
              #
              def list_interconnect_attachments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::ListInterconnectAttachmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_interconnect_attachments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_interconnect_attachments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_interconnect_attachments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.list_interconnect_attachments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @edge_network_stub, :list_interconnect_attachments, "interconnect_attachments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single InterconnectAttachment.
              #
              # @overload get_interconnect_attachment(request, options = nil)
              #   Pass arguments to `get_interconnect_attachment` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_interconnect_attachment(name: nil)
              #   Pass arguments to `get_interconnect_attachment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest.new
              #
              #   # Call the get_interconnect_attachment method.
              #   result = client.get_interconnect_attachment request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::InterconnectAttachment.
              #   p result
              #
              def get_interconnect_attachment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::GetInterconnectAttachmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_interconnect_attachment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_interconnect_attachment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_interconnect_attachment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.get_interconnect_attachment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new InterconnectAttachment in a given project and location.
              #
              # @overload create_interconnect_attachment(request, options = nil)
              #   Pass arguments to `create_interconnect_attachment` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_interconnect_attachment(parent: nil, interconnect_attachment_id: nil, interconnect_attachment: nil, request_id: nil)
              #   Pass arguments to `create_interconnect_attachment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param interconnect_attachment_id [::String]
              #     Required. Id of the requesting object
              #     If auto-generating Id server-side, remove this field and
              #     interconnect_attachment_id from the method_signature of Create RPC
              #   @param interconnect_attachment [::Google::Cloud::EdgeNetwork::V1::InterconnectAttachment, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest.new
              #
              #   # Call the create_interconnect_attachment method.
              #   result = client.create_interconnect_attachment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_interconnect_attachment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::CreateInterconnectAttachmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_interconnect_attachment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_interconnect_attachment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_interconnect_attachment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.create_interconnect_attachment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single InterconnectAttachment.
              #
              # @overload delete_interconnect_attachment(request, options = nil)
              #   Pass arguments to `delete_interconnect_attachment` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_interconnect_attachment(name: nil, request_id: nil)
              #   Pass arguments to `delete_interconnect_attachment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest.new
              #
              #   # Call the delete_interconnect_attachment method.
              #   result = client.delete_interconnect_attachment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_interconnect_attachment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::DeleteInterconnectAttachmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_interconnect_attachment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_interconnect_attachment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_interconnect_attachment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.delete_interconnect_attachment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Routers in a given project and location.
              #
              # @overload list_routers(request, options = nil)
              #   Pass arguments to `list_routers` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::ListRoutersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::ListRoutersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_routers(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_routers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent value for ListRoutersRequest
              #   @param page_size [::Integer]
              #     Requested page size. Server may return fewer items than requested.
              #     If unspecified, server will pick an appropriate default.
              #   @param page_token [::String]
              #     A token identifying a page of results the server should return.
              #   @param filter [::String]
              #     Filtering results
              #   @param order_by [::String]
              #     Hint for how to order the results
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Router>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::EdgeNetwork::V1::Router>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::ListRoutersRequest.new
              #
              #   # Call the list_routers method.
              #   result = client.list_routers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::EdgeNetwork::V1::Router.
              #     p item
              #   end
              #
              def list_routers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::ListRoutersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_routers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_routers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_routers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.list_routers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @edge_network_stub, :list_routers, "routers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Router.
              #
              # @overload get_router(request, options = nil)
              #   Pass arguments to `get_router` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::GetRouterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::GetRouterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_router(name: nil)
              #   Pass arguments to `get_router` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::Router]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::Router]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::GetRouterRequest.new
              #
              #   # Call the get_router method.
              #   result = client.get_router request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::Router.
              #   p result
              #
              def get_router request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::GetRouterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_router.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_router.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_router.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.get_router request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get the diagnostics of a single router resource.
              #
              # @overload diagnose_router(request, options = nil)
              #   Pass arguments to `diagnose_router` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload diagnose_router(name: nil)
              #   Pass arguments to `diagnose_router` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the router resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest.new
              #
              #   # Call the diagnose_router method.
              #   result = client.diagnose_router request
              #
              #   # The returned object is of type Google::Cloud::EdgeNetwork::V1::DiagnoseRouterResponse.
              #   p result
              #
              def diagnose_router request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::DiagnoseRouterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.diagnose_router.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.diagnose_router.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.diagnose_router.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.diagnose_router request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Router in a given project and location.
              #
              # @overload create_router(request, options = nil)
              #   Pass arguments to `create_router` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::CreateRouterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::CreateRouterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_router(parent: nil, router_id: nil, router: nil, request_id: nil)
              #   Pass arguments to `create_router` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Value for parent.
              #   @param router_id [::String]
              #     Required. Id of the requesting object
              #     If auto-generating Id server-side, remove this field and
              #     router_id from the method_signature of Create RPC
              #   @param router [::Google::Cloud::EdgeNetwork::V1::Router, ::Hash]
              #     Required. The resource being created
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::CreateRouterRequest.new
              #
              #   # Call the create_router method.
              #   result = client.create_router request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_router request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::CreateRouterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_router.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_router.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_router.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.create_router request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Router.
              #
              # @overload update_router(request, options = nil)
              #   Pass arguments to `update_router` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_router(update_mask: nil, router: nil, request_id: nil)
              #   Pass arguments to `update_router` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten in the
              #     Router resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param router [::Google::Cloud::EdgeNetwork::V1::Router, ::Hash]
              #     Required. The resource being updated
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest.new
              #
              #   # Call the update_router method.
              #   result = client.update_router request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_router request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::UpdateRouterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_router.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_router.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_router.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.update_router request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Router.
              #
              # @overload delete_router(request, options = nil)
              #   Pass arguments to `delete_router` via a request object, either of type
              #   {::Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_router(name: nil, request_id: nil)
              #   Pass arguments to `delete_router` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the resource
              #   @param request_id [::String]
              #     Optional. An optional request ID to identify requests. Specify a unique
              #     request ID so that if you must retry your request, the server will know to
              #     ignore the request if it has already been completed. The server will
              #     guarantee that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and
              #     the request times out. If you make the request again with the same request
              #     ID, the server can check if original operation with the same request ID
              #     was received, and if so, will ignore the second request. This prevents
              #     clients from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/edge_network/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest.new
              #
              #   # Call the delete_router method.
              #   result = client.delete_router request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_router request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeNetwork::V1::DeleteRouterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_router.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::EdgeNetwork::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_router.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_router.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @edge_network_stub.delete_router request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the EdgeNetwork REST API.
              #
              # This class represents the configuration for EdgeNetwork REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # initialize_zone to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.initialize_zone.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::EdgeNetwork::V1::EdgeNetwork::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.initialize_zone.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "edgenetwork.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the EdgeNetwork API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `initialize_zone`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :initialize_zone
                  ##
                  # RPC-specific configuration for `list_zones`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_zones
                  ##
                  # RPC-specific configuration for `get_zone`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_zone
                  ##
                  # RPC-specific configuration for `list_networks`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_networks
                  ##
                  # RPC-specific configuration for `get_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_network
                  ##
                  # RPC-specific configuration for `diagnose_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :diagnose_network
                  ##
                  # RPC-specific configuration for `create_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_network
                  ##
                  # RPC-specific configuration for `delete_network`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_network
                  ##
                  # RPC-specific configuration for `list_subnets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_subnets
                  ##
                  # RPC-specific configuration for `get_subnet`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_subnet
                  ##
                  # RPC-specific configuration for `create_subnet`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_subnet
                  ##
                  # RPC-specific configuration for `update_subnet`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_subnet
                  ##
                  # RPC-specific configuration for `delete_subnet`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_subnet
                  ##
                  # RPC-specific configuration for `list_interconnects`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_interconnects
                  ##
                  # RPC-specific configuration for `get_interconnect`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_interconnect
                  ##
                  # RPC-specific configuration for `diagnose_interconnect`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :diagnose_interconnect
                  ##
                  # RPC-specific configuration for `list_interconnect_attachments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_interconnect_attachments
                  ##
                  # RPC-specific configuration for `get_interconnect_attachment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_interconnect_attachment
                  ##
                  # RPC-specific configuration for `create_interconnect_attachment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_interconnect_attachment
                  ##
                  # RPC-specific configuration for `delete_interconnect_attachment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_interconnect_attachment
                  ##
                  # RPC-specific configuration for `list_routers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_routers
                  ##
                  # RPC-specific configuration for `get_router`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_router
                  ##
                  # RPC-specific configuration for `diagnose_router`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :diagnose_router
                  ##
                  # RPC-specific configuration for `create_router`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_router
                  ##
                  # RPC-specific configuration for `update_router`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_router
                  ##
                  # RPC-specific configuration for `delete_router`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_router

                  # @private
                  def initialize parent_rpcs = nil
                    initialize_zone_config = parent_rpcs.initialize_zone if parent_rpcs.respond_to? :initialize_zone
                    @initialize_zone = ::Gapic::Config::Method.new initialize_zone_config
                    list_zones_config = parent_rpcs.list_zones if parent_rpcs.respond_to? :list_zones
                    @list_zones = ::Gapic::Config::Method.new list_zones_config
                    get_zone_config = parent_rpcs.get_zone if parent_rpcs.respond_to? :get_zone
                    @get_zone = ::Gapic::Config::Method.new get_zone_config
                    list_networks_config = parent_rpcs.list_networks if parent_rpcs.respond_to? :list_networks
                    @list_networks = ::Gapic::Config::Method.new list_networks_config
                    get_network_config = parent_rpcs.get_network if parent_rpcs.respond_to? :get_network
                    @get_network = ::Gapic::Config::Method.new get_network_config
                    diagnose_network_config = parent_rpcs.diagnose_network if parent_rpcs.respond_to? :diagnose_network
                    @diagnose_network = ::Gapic::Config::Method.new diagnose_network_config
                    create_network_config = parent_rpcs.create_network if parent_rpcs.respond_to? :create_network
                    @create_network = ::Gapic::Config::Method.new create_network_config
                    delete_network_config = parent_rpcs.delete_network if parent_rpcs.respond_to? :delete_network
                    @delete_network = ::Gapic::Config::Method.new delete_network_config
                    list_subnets_config = parent_rpcs.list_subnets if parent_rpcs.respond_to? :list_subnets
                    @list_subnets = ::Gapic::Config::Method.new list_subnets_config
                    get_subnet_config = parent_rpcs.get_subnet if parent_rpcs.respond_to? :get_subnet
                    @get_subnet = ::Gapic::Config::Method.new get_subnet_config
                    create_subnet_config = parent_rpcs.create_subnet if parent_rpcs.respond_to? :create_subnet
                    @create_subnet = ::Gapic::Config::Method.new create_subnet_config
                    update_subnet_config = parent_rpcs.update_subnet if parent_rpcs.respond_to? :update_subnet
                    @update_subnet = ::Gapic::Config::Method.new update_subnet_config
                    delete_subnet_config = parent_rpcs.delete_subnet if parent_rpcs.respond_to? :delete_subnet
                    @delete_subnet = ::Gapic::Config::Method.new delete_subnet_config
                    list_interconnects_config = parent_rpcs.list_interconnects if parent_rpcs.respond_to? :list_interconnects
                    @list_interconnects = ::Gapic::Config::Method.new list_interconnects_config
                    get_interconnect_config = parent_rpcs.get_interconnect if parent_rpcs.respond_to? :get_interconnect
                    @get_interconnect = ::Gapic::Config::Method.new get_interconnect_config
                    diagnose_interconnect_config = parent_rpcs.diagnose_interconnect if parent_rpcs.respond_to? :diagnose_interconnect
                    @diagnose_interconnect = ::Gapic::Config::Method.new diagnose_interconnect_config
                    list_interconnect_attachments_config = parent_rpcs.list_interconnect_attachments if parent_rpcs.respond_to? :list_interconnect_attachments
                    @list_interconnect_attachments = ::Gapic::Config::Method.new list_interconnect_attachments_config
                    get_interconnect_attachment_config = parent_rpcs.get_interconnect_attachment if parent_rpcs.respond_to? :get_interconnect_attachment
                    @get_interconnect_attachment = ::Gapic::Config::Method.new get_interconnect_attachment_config
                    create_interconnect_attachment_config = parent_rpcs.create_interconnect_attachment if parent_rpcs.respond_to? :create_interconnect_attachment
                    @create_interconnect_attachment = ::Gapic::Config::Method.new create_interconnect_attachment_config
                    delete_interconnect_attachment_config = parent_rpcs.delete_interconnect_attachment if parent_rpcs.respond_to? :delete_interconnect_attachment
                    @delete_interconnect_attachment = ::Gapic::Config::Method.new delete_interconnect_attachment_config
                    list_routers_config = parent_rpcs.list_routers if parent_rpcs.respond_to? :list_routers
                    @list_routers = ::Gapic::Config::Method.new list_routers_config
                    get_router_config = parent_rpcs.get_router if parent_rpcs.respond_to? :get_router
                    @get_router = ::Gapic::Config::Method.new get_router_config
                    diagnose_router_config = parent_rpcs.diagnose_router if parent_rpcs.respond_to? :diagnose_router
                    @diagnose_router = ::Gapic::Config::Method.new diagnose_router_config
                    create_router_config = parent_rpcs.create_router if parent_rpcs.respond_to? :create_router
                    @create_router = ::Gapic::Config::Method.new create_router_config
                    update_router_config = parent_rpcs.update_router if parent_rpcs.respond_to? :update_router
                    @update_router = ::Gapic::Config::Method.new update_router_config
                    delete_router_config = parent_rpcs.delete_router if parent_rpcs.respond_to? :delete_router
                    @delete_router = ::Gapic::Config::Method.new delete_router_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
