# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module EdgeNetwork
      module V1
        module EdgeNetwork
          # Path helper methods for the EdgeNetwork API.
          module Paths
            ##
            # Create a fully-qualified Interconnect resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/zones/{zone}/interconnects/{interconnect}`
            #
            # @param project [String]
            # @param location [String]
            # @param zone [String]
            # @param interconnect [String]
            #
            # @return [::String]
            def interconnect_path project:, location:, zone:, interconnect:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/locations/#{location}/zones/#{zone}/interconnects/#{interconnect}"
            end

            ##
            # Create a fully-qualified InterconnectAttachment resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/zones/{zone}/interconnectAttachments/{interconnect_attachment}`
            #
            # @param project [String]
            # @param location [String]
            # @param zone [String]
            # @param interconnect_attachment [String]
            #
            # @return [::String]
            def interconnect_attachment_path project:, location:, zone:, interconnect_attachment:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/locations/#{location}/zones/#{zone}/interconnectAttachments/#{interconnect_attachment}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Network resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/zones/{zone}/networks/{network}`
            #
            # @param project [String]
            # @param location [String]
            # @param zone [String]
            # @param network [String]
            #
            # @return [::String]
            def network_path project:, location:, zone:, network:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/locations/#{location}/zones/#{zone}/networks/#{network}"
            end

            ##
            # Create a fully-qualified Router resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/zones/{zone}/routers/{router}`
            #
            # @param project [String]
            # @param location [String]
            # @param zone [String]
            # @param router [String]
            #
            # @return [::String]
            def router_path project:, location:, zone:, router:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/locations/#{location}/zones/#{zone}/routers/#{router}"
            end

            ##
            # Create a fully-qualified Subnet resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/zones/{zone}/subnets/{subnet}`
            #
            # @param project [String]
            # @param location [String]
            # @param zone [String]
            # @param subnet [String]
            #
            # @return [::String]
            def subnet_path project:, location:, zone:, subnet:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/locations/#{location}/zones/#{zone}/subnets/#{subnet}"
            end

            ##
            # Create a fully-qualified Zone resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/zones/{zone}`
            #
            # @param project [String]
            # @param location [String]
            # @param zone [String]
            #
            # @return [::String]
            def zone_path project:, location:, zone:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/zones/#{zone}"
            end

            extend self
          end
        end
      end
    end
  end
end
