# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/edgecontainer/v1/service_pb"
require "google/cloud/edge_container/v1/edge_container/rest"


class ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_clusters
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::ListClustersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_clusters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_list_clusters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_clusters_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_clusters parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_clusters ::Google::Cloud::EdgeContainer::V1::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_clusters({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_clusters(::Google::Cloud::EdgeContainer::V1::ListClustersRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_clusters_client_stub.call_count
      end
    end
  end

  def test_get_cluster
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::Cluster.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_get_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_cluster({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_cluster name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_cluster ::Google::Cloud::EdgeContainer::V1::GetClusterRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_cluster({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_cluster(::Google::Cloud::EdgeContainer::V1::GetClusterRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_cluster_client_stub.call_count
      end
    end
  end

  def test_create_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    cluster_id = "hello world"
    cluster = {}
    request_id = "hello world"

    create_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_create_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_cluster parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_cluster ::Google::Cloud::EdgeContainer::V1::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_cluster({ parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_cluster(::Google::Cloud::EdgeContainer::V1::CreateClusterRequest.new(parent: parent, cluster_id: cluster_id, cluster: cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_cluster_client_stub.call_count
      end
    end
  end

  def test_update_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    cluster = {}
    request_id = "hello world"

    update_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_update_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_cluster update_mask: update_mask, cluster: cluster, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_cluster ::Google::Cloud::EdgeContainer::V1::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_cluster({ update_mask: update_mask, cluster: cluster, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_cluster(::Google::Cloud::EdgeContainer::V1::UpdateClusterRequest.new(update_mask: update_mask, cluster: cluster, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_cluster_client_stub.call_count
      end
    end
  end

  def test_upgrade_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    target_version = "hello world"
    schedule = :SCHEDULE_UNSPECIFIED
    request_id = "hello world"

    upgrade_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_upgrade_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, upgrade_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.upgrade_cluster({ name: name, target_version: target_version, schedule: schedule, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.upgrade_cluster name: name, target_version: target_version, schedule: schedule, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.upgrade_cluster ::Google::Cloud::EdgeContainer::V1::UpgradeClusterRequest.new(name: name, target_version: target_version, schedule: schedule, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.upgrade_cluster({ name: name, target_version: target_version, schedule: schedule, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.upgrade_cluster(::Google::Cloud::EdgeContainer::V1::UpgradeClusterRequest.new(name: name, target_version: target_version, schedule: schedule, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, upgrade_cluster_client_stub.call_count
      end
    end
  end

  def test_delete_cluster
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_cluster_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_delete_cluster_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_cluster_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_cluster({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_cluster name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_cluster ::Google::Cloud::EdgeContainer::V1::DeleteClusterRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_cluster({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_cluster(::Google::Cloud::EdgeContainer::V1::DeleteClusterRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_cluster_client_stub.call_count
      end
    end
  end

  def test_generate_access_token
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::GenerateAccessTokenResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    cluster = "hello world"

    generate_access_token_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_generate_access_token_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_access_token_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_access_token({ cluster: cluster }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_access_token cluster: cluster do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_access_token ::Google::Cloud::EdgeContainer::V1::GenerateAccessTokenRequest.new(cluster: cluster) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_access_token({ cluster: cluster }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_access_token(::Google::Cloud::EdgeContainer::V1::GenerateAccessTokenRequest.new(cluster: cluster), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_access_token_client_stub.call_count
      end
    end
  end

  def test_generate_offline_credential
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    cluster = "hello world"

    generate_offline_credential_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_generate_offline_credential_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, generate_offline_credential_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.generate_offline_credential({ cluster: cluster }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.generate_offline_credential cluster: cluster do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.generate_offline_credential ::Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialRequest.new(cluster: cluster) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.generate_offline_credential({ cluster: cluster }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.generate_offline_credential(::Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialRequest.new(cluster: cluster), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, generate_offline_credential_client_stub.call_count
      end
    end
  end

  def test_list_node_pools
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::ListNodePoolsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_node_pools_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_list_node_pools_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_node_pools_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_node_pools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_node_pools parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_node_pools ::Google::Cloud::EdgeContainer::V1::ListNodePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_node_pools({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_node_pools(::Google::Cloud::EdgeContainer::V1::ListNodePoolsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_node_pools_client_stub.call_count
      end
    end
  end

  def test_get_node_pool
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::NodePool.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_get_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_node_pool({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_node_pool name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_node_pool ::Google::Cloud::EdgeContainer::V1::GetNodePoolRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_node_pool({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_node_pool(::Google::Cloud::EdgeContainer::V1::GetNodePoolRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_node_pool_client_stub.call_count
      end
    end
  end

  def test_create_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    node_pool_id = "hello world"
    node_pool = {}
    request_id = "hello world"

    create_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_create_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_node_pool({ parent: parent, node_pool_id: node_pool_id, node_pool: node_pool, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_node_pool parent: parent, node_pool_id: node_pool_id, node_pool: node_pool, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_node_pool ::Google::Cloud::EdgeContainer::V1::CreateNodePoolRequest.new(parent: parent, node_pool_id: node_pool_id, node_pool: node_pool, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_node_pool({ parent: parent, node_pool_id: node_pool_id, node_pool: node_pool, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_node_pool(::Google::Cloud::EdgeContainer::V1::CreateNodePoolRequest.new(parent: parent, node_pool_id: node_pool_id, node_pool: node_pool, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_node_pool_client_stub.call_count
      end
    end
  end

  def test_update_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    node_pool = {}
    request_id = "hello world"

    update_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_update_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_node_pool({ update_mask: update_mask, node_pool: node_pool, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_node_pool update_mask: update_mask, node_pool: node_pool, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_node_pool ::Google::Cloud::EdgeContainer::V1::UpdateNodePoolRequest.new(update_mask: update_mask, node_pool: node_pool, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_node_pool({ update_mask: update_mask, node_pool: node_pool, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_node_pool(::Google::Cloud::EdgeContainer::V1::UpdateNodePoolRequest.new(update_mask: update_mask, node_pool: node_pool, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_node_pool_client_stub.call_count
      end
    end
  end

  def test_delete_node_pool
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_node_pool_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_delete_node_pool_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_node_pool_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_node_pool({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_node_pool name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_node_pool ::Google::Cloud::EdgeContainer::V1::DeleteNodePoolRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_node_pool({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_node_pool(::Google::Cloud::EdgeContainer::V1::DeleteNodePoolRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_node_pool_client_stub.call_count
      end
    end
  end

  def test_list_machines
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::ListMachinesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_machines_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_list_machines_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_machines_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_machines({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_machines parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_machines ::Google::Cloud::EdgeContainer::V1::ListMachinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_machines({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_machines(::Google::Cloud::EdgeContainer::V1::ListMachinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_machines_client_stub.call_count
      end
    end
  end

  def test_get_machine
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::Machine.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_machine_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_get_machine_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_machine_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_machine({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_machine name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_machine ::Google::Cloud::EdgeContainer::V1::GetMachineRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_machine({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_machine(::Google::Cloud::EdgeContainer::V1::GetMachineRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_machine_client_stub.call_count
      end
    end
  end

  def test_list_vpn_connections
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::ListVpnConnectionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_vpn_connections_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_list_vpn_connections_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_vpn_connections_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_vpn_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_vpn_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_vpn_connections ::Google::Cloud::EdgeContainer::V1::ListVpnConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_vpn_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_vpn_connections(::Google::Cloud::EdgeContainer::V1::ListVpnConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_vpn_connections_client_stub.call_count
      end
    end
  end

  def test_get_vpn_connection
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::VpnConnection.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_vpn_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_get_vpn_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_vpn_connection_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_vpn_connection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_vpn_connection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_vpn_connection ::Google::Cloud::EdgeContainer::V1::GetVpnConnectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_vpn_connection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_vpn_connection(::Google::Cloud::EdgeContainer::V1::GetVpnConnectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_vpn_connection_client_stub.call_count
      end
    end
  end

  def test_create_vpn_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    vpn_connection_id = "hello world"
    vpn_connection = {}
    request_id = "hello world"

    create_vpn_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_create_vpn_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_vpn_connection_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_vpn_connection({ parent: parent, vpn_connection_id: vpn_connection_id, vpn_connection: vpn_connection, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_vpn_connection parent: parent, vpn_connection_id: vpn_connection_id, vpn_connection: vpn_connection, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_vpn_connection ::Google::Cloud::EdgeContainer::V1::CreateVpnConnectionRequest.new(parent: parent, vpn_connection_id: vpn_connection_id, vpn_connection: vpn_connection, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_vpn_connection({ parent: parent, vpn_connection_id: vpn_connection_id, vpn_connection: vpn_connection, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_vpn_connection(::Google::Cloud::EdgeContainer::V1::CreateVpnConnectionRequest.new(parent: parent, vpn_connection_id: vpn_connection_id, vpn_connection: vpn_connection, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_vpn_connection_client_stub.call_count
      end
    end
  end

  def test_delete_vpn_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_vpn_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_delete_vpn_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_vpn_connection_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_vpn_connection({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_vpn_connection name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_vpn_connection ::Google::Cloud::EdgeContainer::V1::DeleteVpnConnectionRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_vpn_connection({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_vpn_connection(::Google::Cloud::EdgeContainer::V1::DeleteVpnConnectionRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_vpn_connection_client_stub.call_count
      end
    end
  end

  def test_get_server_config
    # Create test objects.
    client_result = ::Google::Cloud::EdgeContainer::V1::ServerConfig.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_server_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::ServiceStub.stub :transcode_get_server_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_server_config_client_stub do
        # Create client
        client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_server_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_server_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_server_config ::Google::Cloud::EdgeContainer::V1::GetServerConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_server_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_server_config(::Google::Cloud::EdgeContainer::V1::GetServerConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_server_config_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client::Configuration, config
  end
end
