# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module EdgeContainer
      module V1
        # A Google Distributed Cloud Edge Kubernetes cluster.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the cluster.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the cluster was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the cluster was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this resource.
        # @!attribute [rw] fleet
        #   @return [::Google::Cloud::EdgeContainer::V1::Fleet]
        #     Required. Fleet configuration.
        # @!attribute [rw] networking
        #   @return [::Google::Cloud::EdgeContainer::V1::ClusterNetworking]
        #     Required. Cluster-wide networking configuration.
        # @!attribute [rw] authorization
        #   @return [::Google::Cloud::EdgeContainer::V1::Authorization]
        #     Required. Immutable. RBAC policy that will be applied and managed by GEC.
        # @!attribute [rw] default_max_pods_per_node
        #   @return [::Integer]
        #     Optional. The default maximum number of pods per node used if a maximum
        #     value is not specified explicitly for a node pool in this cluster. If
        #     unspecified, the Kubernetes default value will be used.
        # @!attribute [r] endpoint
        #   @return [::String]
        #     Output only. The IP address of the Kubernetes API server.
        # @!attribute [r] port
        #   @return [::Integer]
        #     Output only. The port number of the Kubernetes API server.
        # @!attribute [r] cluster_ca_certificate
        #   @return [::String]
        #     Output only. The PEM-encoded public certificate of the cluster's CA.
        # @!attribute [rw] maintenance_policy
        #   @return [::Google::Cloud::EdgeContainer::V1::MaintenancePolicy]
        #     Optional. Cluster-wide maintenance policy configuration.
        # @!attribute [r] control_plane_version
        #   @return [::String]
        #     Output only. The control plane release version
        # @!attribute [r] node_version
        #   @return [::String]
        #     Output only. The lowest release version among all worker nodes. This field
        #     can be empty if the cluster does not have any worker nodes.
        # @!attribute [rw] control_plane
        #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::ControlPlane]
        #     Optional. The configuration of the cluster control plane.
        # @!attribute [rw] system_addons_config
        #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::SystemAddonsConfig]
        #     Optional. The configuration of the system add-ons.
        # @!attribute [rw] external_load_balancer_ipv4_address_pools
        #   @return [::Array<::String>]
        #     Optional. IPv4 address pools for cluster data plane external load
        #     balancing.
        # @!attribute [rw] control_plane_encryption
        #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::ControlPlaneEncryption]
        #     Optional. Remote control plane disk encryption options. This field is only
        #     used when enabling CMEK support.
        # @!attribute [r] status
        #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::Status]
        #     Output only. The current status of the cluster.
        # @!attribute [r] maintenance_events
        #   @return [::Array<::Google::Cloud::EdgeContainer::V1::Cluster::MaintenanceEvent>]
        #     Output only. All the maintenance events scheduled for the cluster,
        #     including the ones ongoing, planned for the future and done in the past (up
        #     to 90 days).
        # @!attribute [rw] target_version
        #   @return [::String]
        #     Optional. The target cluster version. For example: "1.5.0".
        # @!attribute [rw] release_channel
        #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::ReleaseChannel]
        #     Optional. The release channel a cluster is subscribed to.
        # @!attribute [rw] survivability_config
        #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::SurvivabilityConfig]
        #     Optional. Configuration of the cluster survivability, e.g., for the case
        #     when network connectivity is lost. Note: This only applies to local control
        #     plane clusters.
        # @!attribute [rw] external_load_balancer_ipv6_address_pools
        #   @return [::Array<::String>]
        #     Optional. IPv6 address pools for cluster data plane external load
        #     balancing.
        # @!attribute [r] connection_state
        #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::ConnectionState]
        #     Output only. The current connection state of the cluster.
        class Cluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration of the cluster control plane.
          # @!attribute [rw] remote
          #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::ControlPlane::Remote]
          #     Remote control plane configuration.
          #
          #     Note: The following fields are mutually exclusive: `remote`, `local`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] local
          #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::ControlPlane::Local]
          #     Local control plane configuration.
          #
          #     Warning: Local control plane clusters must be created in their own
          #     project. Local control plane clusters cannot coexist in the same
          #     project with any other type of clusters, including non-GDCE clusters.
          #     Mixing local control plane GDCE clusters with any other type of
          #     clusters in the same project can result in data loss.
          #
          #     Note: The following fields are mutually exclusive: `local`, `remote`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class ControlPlane
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration specific to clusters with a control plane hosted remotely.
            class Remote
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration specific to clusters with a control plane hosted locally.
            #
            # Warning: Local control plane clusters must be created in their own
            # project. Local control plane clusters cannot coexist in the same
            # project with any other type of clusters, including non-GDCE clusters.
            # Mixing local control plane GDCE clusters with any other type of
            # clusters in the same project can result in data loss.
            # @!attribute [rw] node_location
            #   @return [::String]
            #     Name of the Google Distributed Cloud Edge zones where this node pool
            #     will be created. For example: `us-central1-edge-customer-a`.
            # @!attribute [rw] node_count
            #   @return [::Integer]
            #     The number of nodes to serve as replicas of the Control Plane.
            # @!attribute [rw] machine_filter
            #   @return [::String]
            #     Only machines matching this filter will be allowed to host control
            #     plane nodes. The filtering language accepts strings like "name=<name>",
            #     and is documented here: [AIP-160](https://google.aip.dev/160).
            # @!attribute [rw] shared_deployment_policy
            #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::ControlPlane::SharedDeploymentPolicy]
            #     Policy configuration about how user applications are deployed.
            # @!attribute [rw] control_plane_node_storage_schema
            #   @return [::String]
            #     Optional. Name for the storage schema of control plane nodes.
            #
            #     Warning: Configurable node local storage schema feature is an
            #     experimental feature, and is not recommended for general use
            #     in production clusters/nodepools.
            class Local
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Represents the policy configuration about how user applications are
            # deployed.
            module SharedDeploymentPolicy
              # Unspecified.
              SHARED_DEPLOYMENT_POLICY_UNSPECIFIED = 0

              # User applications can be deployed both on control plane and worker
              # nodes.
              ALLOWED = 1

              # User applications can not be deployed on control plane nodes and can
              # only be deployed on worker nodes.
              DISALLOWED = 2
            end
          end

          # Config that customers are allowed to define for GDCE system add-ons.
          # @!attribute [rw] ingress
          #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::SystemAddonsConfig::Ingress]
          #     Optional. Config for Ingress.
          # @!attribute [rw] vm_service_config
          #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::SystemAddonsConfig::VMServiceConfig]
          #     Optional. Config for VM Service.
          class SystemAddonsConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Config for the Ingress add-on which allows customers to create an Ingress
            # object to manage external access to the servers in a cluster. The add-on
            # consists of istiod and istio-ingress.
            # @!attribute [rw] disabled
            #   @return [::Boolean]
            #     Optional. Whether Ingress is disabled.
            # @!attribute [rw] ipv4_vip
            #   @return [::String]
            #     Optional. Ingress VIP.
            class Ingress
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # VMServiceConfig defines the configuration for GDCE VM Service.
            # @!attribute [rw] vmm_enabled
            #   @return [::Boolean]
            #     Optional. Whether VMM is enabled.
            class VMServiceConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Configuration for Customer-managed KMS key support for control plane nodes.
          # @!attribute [rw] kms_key
          #   @return [::String]
          #     Optional. The Cloud KMS CryptoKey e.g.
          #     projects/\\{project}/locations/\\{location}/keyRings/\\{keyRing}/cryptoKeys/\\{cryptoKey}
          #     to use for protecting control plane disks. If not specified, a
          #     Google-managed key will be used instead.
          # @!attribute [r] kms_key_active_version
          #   @return [::String]
          #     Output only. The Cloud KMS CryptoKeyVersion currently in use for
          #     protecting control plane disks. Only applicable if kms_key is set.
          # @!attribute [r] kms_key_state
          #   @return [::Google::Cloud::EdgeContainer::V1::KmsKeyState]
          #     Output only. Availability of the Cloud KMS CryptoKey. If not
          #     `KEY_AVAILABLE`, then nodes may go offline as they cannot access their
          #     local data. This can be caused by a lack of permissions to use the key,
          #     or if the key is disabled or deleted.
          # @!attribute [r] kms_status
          #   @return [::Google::Rpc::Status]
          #     Output only. Error status returned by Cloud KMS when using this key. This
          #     field may be populated only if `kms_key_state` is not
          #     `KMS_KEY_STATE_KEY_AVAILABLE`. If populated, this field contains the
          #     error status reported by Cloud KMS.
          # @!attribute [r] resource_state
          #   @return [::Google::Cloud::EdgeContainer::V1::ResourceState]
          #     Output only. The current resource state associated with the cmek.
          class ControlPlaneEncryption
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A Maintenance Event is an operation that could cause temporary disruptions
          # to the cluster workloads, including Google-driven or user-initiated cluster
          # upgrades, user-initiated cluster configuration changes that require
          # restarting nodes, etc.
          # @!attribute [r] uuid
          #   @return [::String]
          #     Output only. UUID of the maintenance event.
          # @!attribute [r] target_version
          #   @return [::String]
          #     Output only. The target version of the cluster.
          # @!attribute [r] operation
          #   @return [::String]
          #     Output only. The operation for running the maintenance event. Specified
          #     in the format projects/*/locations/*/operations/*. If the maintenance
          #     event is split into multiple operations (e.g. due to maintenance
          #     windows), the latest one is recorded.
          # @!attribute [r] type
          #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::MaintenanceEvent::Type]
          #     Output only. The type of the maintenance event.
          # @!attribute [r] schedule
          #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::MaintenanceEvent::Schedule]
          #     Output only. The schedule of the maintenance event.
          # @!attribute [r] state
          #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::MaintenanceEvent::State]
          #     Output only. The state of the maintenance event.
          # @!attribute [r] create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the maintenance event request was created.
          # @!attribute [r] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the maintenance event started.
          # @!attribute [r] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the maintenance event ended, either
          #     successfully or not. If the maintenance event is split into multiple
          #     maintenance windows, end_time is only updated when the whole flow ends.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the maintenance event message was updated.
          class MaintenanceEvent
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Indicates the maintenance event type.
            module Type
              # Unspecified.
              TYPE_UNSPECIFIED = 0

              # Upgrade initiated by users.
              USER_INITIATED_UPGRADE = 1

              # Upgrade driven by Google.
              GOOGLE_DRIVEN_UPGRADE = 2
            end

            # Indicates when the maintenance event should be performed.
            module Schedule
              # Unspecified.
              SCHEDULE_UNSPECIFIED = 0

              # Immediately after receiving the request.
              IMMEDIATELY = 1
            end

            # Indicates the maintenance event state.
            module State
              # Unspecified.
              STATE_UNSPECIFIED = 0

              # The maintenance event is ongoing. The cluster might be unusable.
              RECONCILING = 1

              # The maintenance event succeeded.
              SUCCEEDED = 2

              # The maintenance event failed.
              FAILED = 3
            end
          end

          # Configuration of the cluster survivability, e.g., for the case when network
          # connectivity is lost.
          # @!attribute [rw] offline_reboot_ttl
          #   @return [::Google::Protobuf::Duration]
          #     Optional. Time period that allows the cluster nodes to be rebooted and
          #     become functional without network connectivity to Google. The default 0
          #     means not allowed. The maximum is 7 days.
          class SurvivabilityConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # ConnectionState holds the current connection state from the cluster to
          # Google.
          # @!attribute [r] state
          #   @return [::Google::Cloud::EdgeContainer::V1::Cluster::ConnectionState::State]
          #     Output only. The current connection state.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the connection state was last changed.
          class ConnectionState
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The connection state.
            module State
              # Unknown connection state.
              STATE_UNSPECIFIED = 0

              # This cluster is currently disconnected from Google.
              DISCONNECTED = 1

              # This cluster is currently connected to Google.
              CONNECTED = 2

              # This cluster is currently connected to Google, but may have recently
              # reconnected after a disconnection. It is still syncing back.
              CONNECTED_AND_SYNCING = 3
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Indicates the status of the cluster.
          module Status
            # Status unknown.
            STATUS_UNSPECIFIED = 0

            # The cluster is being created.
            PROVISIONING = 1

            # The cluster is created and fully usable.
            RUNNING = 2

            # The cluster is being deleted.
            DELETING = 3

            # The status indicates that some errors occurred while reconciling/deleting
            # the cluster.
            ERROR = 4

            # The cluster is undergoing some work such as version upgrades, etc.
            RECONCILING = 5
          end

          # The release channel a cluster is subscribed to.
          module ReleaseChannel
            # Unspecified release channel. This will default to the REGULAR channel.
            RELEASE_CHANNEL_UNSPECIFIED = 0

            # No release channel.
            NONE = 1

            # Regular release channel.
            REGULAR = 2
          end
        end

        # Cluster-wide networking configuration.
        # @!attribute [rw] cluster_ipv4_cidr_blocks
        #   @return [::Array<::String>]
        #     Required. All pods in the cluster are assigned an RFC1918 IPv4 address from
        #     these blocks. Only a single block is supported. This field cannot be
        #     changed after creation.
        # @!attribute [rw] services_ipv4_cidr_blocks
        #   @return [::Array<::String>]
        #     Required. All services in the cluster are assigned an RFC1918 IPv4 address
        #     from these blocks. Only a single block is supported. This field cannot be
        #     changed after creation.
        class ClusterNetworking
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Fleet related configuration.
        #
        # Fleets are a Google Cloud concept for logically organizing clusters,
        # letting you use and manage multi-cluster capabilities and apply
        # consistent policies across your systems.
        # @!attribute [rw] project
        #   @return [::String]
        #     Required. The name of the Fleet host project where this cluster will be
        #     registered.
        #
        #     Project names are formatted as
        #     `projects/<project-number>`.
        # @!attribute [r] membership
        #   @return [::String]
        #     Output only. The name of the managed Hub Membership resource associated to
        #     this cluster.
        #
        #     Membership names are formatted as
        #     `projects/<project-number>/locations/global/membership/<cluster-id>`.
        class Fleet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A user principal for an RBAC policy.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. An active Google username.
        class ClusterUser
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RBAC policy that will be applied and managed by GEC.
        # @!attribute [rw] admin_users
        #   @return [::Google::Cloud::EdgeContainer::V1::ClusterUser]
        #     Required. User that will be granted the cluster-admin role on the cluster,
        #     providing full access to the cluster. Currently, this is a singular field,
        #     but will be expanded to allow multiple admins in the future.
        class Authorization
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A set of Kubernetes nodes in a cluster with common configuration and
        # specification.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the node pool.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the node pool was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the node pool was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this resource.
        # @!attribute [rw] node_location
        #   @return [::String]
        #     Name of the Google Distributed Cloud Edge zone where this node pool will be
        #     created. For example: `us-central1-edge-customer-a`.
        # @!attribute [rw] node_count
        #   @return [::Integer]
        #     Required. The number of nodes in the pool.
        # @!attribute [rw] machine_filter
        #   @return [::String]
        #     Only machines matching this filter will be allowed to join the node pool.
        #     The filtering language accepts strings like "name=<name>", and is
        #     documented in more detail in [AIP-160](https://google.aip.dev/160).
        # @!attribute [rw] local_disk_encryption
        #   @return [::Google::Cloud::EdgeContainer::V1::NodePool::LocalDiskEncryption]
        #     Optional. Local disk encryption options. This field is only used when
        #     enabling CMEK support.
        # @!attribute [r] node_version
        #   @return [::String]
        #     Output only. The lowest release version among all worker nodes.
        # @!attribute [rw] node_config
        #   @return [::Google::Cloud::EdgeContainer::V1::NodePool::NodeConfig]
        #     Optional. Configuration for each node in the NodePool
        class NodePool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for CMEK support for edge machine local disk encryption.
          # @!attribute [rw] kms_key
          #   @return [::String]
          #     Optional. The Cloud KMS CryptoKey e.g.
          #     projects/\\{project}/locations/\\{location}/keyRings/\\{keyRing}/cryptoKeys/\\{cryptoKey}
          #     to use for protecting node local disks. If not specified, a
          #     Google-managed key will be used instead.
          # @!attribute [r] kms_key_active_version
          #   @return [::String]
          #     Output only. The Cloud KMS CryptoKeyVersion currently in use for
          #     protecting node local disks. Only applicable if kms_key is set.
          # @!attribute [r] kms_key_state
          #   @return [::Google::Cloud::EdgeContainer::V1::KmsKeyState]
          #     Output only. Availability of the Cloud KMS CryptoKey. If not
          #     `KEY_AVAILABLE`, then nodes may go offline as they cannot access their
          #     local data. This can be caused by a lack of permissions to use the key,
          #     or if the key is disabled or deleted.
          # @!attribute [r] kms_status
          #   @return [::Google::Rpc::Status]
          #     Output only. Error status returned by Cloud KMS when using this key. This
          #     field may be populated only if `kms_key_state` is not
          #     `KMS_KEY_STATE_KEY_AVAILABLE`. If populated, this field contains the
          #     error status reported by Cloud KMS.
          # @!attribute [r] resource_state
          #   @return [::Google::Cloud::EdgeContainer::V1::ResourceState]
          #     Output only. The current resource state associated with the cmek.
          class LocalDiskEncryption
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration for each node in the NodePool
          # @!attribute [rw] labels
          #   @return [::Google::Protobuf::Map{::String => ::String}]
          #     Optional. The Kubernetes node labels
          # @!attribute [rw] node_storage_schema
          #   @return [::String]
          #     Optional. Name for the storage schema of worker nodes.
          #
          #     Warning: Configurable node local storage schema feature is an
          #     experimental feature, and is not recommended for general use
          #     in production clusters/nodepools.
          class NodeConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # @!attribute [rw] key
            #   @return [::String]
            # @!attribute [rw] value
            #   @return [::String]
            class LabelsEntry
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A Google Distributed Cloud Edge machine capable of acting as a Kubernetes
        # node.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the machine.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the node pool was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the node pool was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this resource.
        # @!attribute [rw] hosted_node
        #   @return [::String]
        #     Canonical resource name of the node that this machine is responsible for
        #     hosting e.g.
        #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster_id}/nodePools/\\{pool_id}/\\{node},
        #     Or empty if the machine is not assigned to assume the role of a node.
        #
        #     For control plane nodes hosted on edge machines, this will return
        #     the following format:
        #       "projects/\\{project}/locations/\\{location}/clusters/\\{cluster_id}/controlPlaneNodes/\\{node}".
        # @!attribute [rw] zone
        #   @return [::String]
        #     The Google Distributed Cloud Edge zone of this machine.
        # @!attribute [r] version
        #   @return [::String]
        #     Output only. The software version of the machine.
        # @!attribute [r] disabled
        #   @return [::Boolean]
        #     Output only. Whether the machine is disabled. If disabled, the machine is
        #     unable to enter service.
        class Machine
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A VPN connection .
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of VPN connection
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the VPN connection was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the VPN connection was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels associated with this resource.
        # @!attribute [rw] nat_gateway_ip
        #   @return [::String]
        #     NAT gateway IP, or WAN IP address. If a customer has multiple NAT IPs, the
        #     customer needs to configure NAT such that only one external IP maps to the
        #     GMEC Anthos cluster. This is empty if NAT is not used.
        # @!attribute [rw] bgp_routing_mode
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::EdgeContainer::V1::VpnConnection::BgpRoutingMode]
        #     Dynamic routing mode of the VPC network, `regional` or `global`.
        # @!attribute [rw] cluster
        #   @return [::String]
        #     The canonical Cluster name to connect to. It is in the form of
        #     projects/\\{project}/locations/\\{location}/clusters/\\{cluster}.
        # @!attribute [rw] vpc
        #   @return [::String]
        #     The network ID of VPC to connect to.
        # @!attribute [rw] vpc_project
        #   @return [::Google::Cloud::EdgeContainer::V1::VpnConnection::VpcProject]
        #     Optional. Project detail of the VPC network. Required if VPC is in a
        #     different project than the cluster project.
        # @!attribute [rw] enable_high_availability
        #   @return [::Boolean]
        #     Whether this VPN connection has HA enabled on cluster side. If enabled,
        #     when creating VPN connection we will attempt to use 2 ANG floating IPs.
        # @!attribute [rw] router
        #   @return [::String]
        #     Optional. The VPN connection Cloud Router name.
        # @!attribute [r] details
        #   @return [::Google::Cloud::EdgeContainer::V1::VpnConnection::Details]
        #     Output only. The created connection details.
        class VpnConnection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Project detail of the VPC network.
          # @!attribute [rw] project_id
          #   @return [::String]
          #     The project of the VPC to connect to. If not specified, it is the same as
          #     the cluster project.
          # @!attribute [rw] service_account
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     Optional. Deprecated: do not use.
          class VpcProject
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The created connection details.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::EdgeContainer::V1::VpnConnection::Details::State]
          #     The state of this connection.
          # @!attribute [rw] error
          #   @return [::String]
          #     The error message. This is only populated when state=ERROR.
          # @!attribute [rw] cloud_router
          #   @return [::Google::Cloud::EdgeContainer::V1::VpnConnection::Details::CloudRouter]
          #     The Cloud Router info.
          # @!attribute [rw] cloud_vpns
          #   @return [::Array<::Google::Cloud::EdgeContainer::V1::VpnConnection::Details::CloudVpn>]
          #     Each connection has multiple Cloud VPN gateways.
          class Details
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The Cloud Router info.
            # @!attribute [rw] name
            #   @return [::String]
            #     The associated Cloud Router name.
            class CloudRouter
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The Cloud VPN info.
            # @!attribute [rw] gateway
            #   @return [::String]
            #     The created Cloud VPN gateway name.
            class CloudVpn
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The current connection state.
            module State
              # Unknown.
              STATE_UNSPECIFIED = 0

              # Connected.
              STATE_CONNECTED = 1

              # Still connecting.
              STATE_CONNECTING = 2

              # Error occurred.
              STATE_ERROR = 3
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Routing mode.
          module BgpRoutingMode
            # Unknown.
            BGP_ROUTING_MODE_UNSPECIFIED = 0

            # Regional mode.
            REGIONAL = 1

            # Global mode.
            GLOBAL = 2
          end
        end

        # Metadata for a given
        # [google.cloud.location.Location][google.cloud.location.Location].
        # @!attribute [rw] available_zones
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::EdgeContainer::V1::ZoneMetadata}]
        #     The set of available Google Distributed Cloud Edge zones in the location.
        #     The map is keyed by the lowercase ID of each zone.
        class LocationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::EdgeContainer::V1::ZoneMetadata]
          class AvailableZonesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A Google Distributed Cloud Edge zone where edge machines are located.
        # @!attribute [rw] quota
        #   @return [::Array<::Google::Cloud::EdgeContainer::V1::Quota>]
        #     Quota for resources in this zone.
        # @!attribute [rw] rack_types
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::EdgeContainer::V1::ZoneMetadata::RackType}]
        #     The map keyed by rack name and has value of RackType.
        # @!attribute [rw] config_data
        #   @return [::Google::Cloud::EdgeContainer::V1::ConfigData]
        #     Config data for the zone.
        class ZoneMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::EdgeContainer::V1::ZoneMetadata::RackType]
          class RackTypesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Type of the rack.
          module RackType
            # Unspecified rack type, single rack also belongs to this type.
            RACK_TYPE_UNSPECIFIED = 0

            # Base rack type, a pair of two modified Config-1 racks containing
            # Aggregation switches.
            BASE = 1

            # Expansion rack type, also known as standalone racks,
            # added by customers on demand.
            EXPANSION = 2
          end
        end

        # Config data holds all the config related data for the zone.
        # @!attribute [rw] available_external_lb_pools_ipv4
        #   @return [::Array<::String>]
        #     list of available v4 ip pools for external loadbalancer
        # @!attribute [rw] available_external_lb_pools_ipv6
        #   @return [::Array<::String>]
        #     list of available v6 ip pools for external loadbalancer
        class ConfigData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents quota for Edge Container resources.
        # @!attribute [rw] metric
        #   @return [::String]
        #     Name of the quota metric.
        # @!attribute [rw] limit
        #   @return [::Float]
        #     Quota limit for this metric.
        # @!attribute [rw] usage
        #   @return [::Float]
        #     Current usage of this metric.
        class Quota
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Maintenance policy configuration.
        # @!attribute [rw] window
        #   @return [::Google::Cloud::EdgeContainer::V1::MaintenanceWindow]
        #     Specifies the maintenance window in which maintenance may be performed.
        # @!attribute [rw] maintenance_exclusions
        #   @return [::Array<::Google::Cloud::EdgeContainer::V1::MaintenanceExclusionWindow>]
        #     Optional. Exclusions to automatic maintenance. Non-emergency maintenance
        #     should not occur in these windows. Each exclusion has a unique name and may
        #     be active or expired. The max number of maintenance exclusions allowed at a
        #     given time is 3.
        class MaintenancePolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Maintenance window configuration
        # @!attribute [rw] recurring_window
        #   @return [::Google::Cloud::EdgeContainer::V1::RecurringTimeWindow]
        #     Configuration of a recurring maintenance window.
        class MaintenanceWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an arbitrary window of time that recurs.
        # @!attribute [rw] window
        #   @return [::Google::Cloud::EdgeContainer::V1::TimeWindow]
        #     The window of the first recurrence.
        # @!attribute [rw] recurrence
        #   @return [::String]
        #     An RRULE (https://tools.ietf.org/html/rfc5545#section-3.8.5.3) for how
        #     this window recurs. They go on for the span of time between the start and
        #     end time.
        class RecurringTimeWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a maintenance exclusion window.
        # @!attribute [rw] window
        #   @return [::Google::Cloud::EdgeContainer::V1::TimeWindow]
        #     Optional. The time window.
        # @!attribute [rw] id
        #   @return [::String]
        #     Optional. A unique (per cluster) id for the window.
        class MaintenanceExclusionWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an arbitrary window of time.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time that the window first starts.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time that the window ends. The end time must take place after the
        #     start time.
        class TimeWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Server configuration for supported versions and release channels.
        # @!attribute [r] channels
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::EdgeContainer::V1::ChannelConfig}]
        #     Output only. Mapping from release channel to channel config.
        # @!attribute [r] versions
        #   @return [::Array<::Google::Cloud::EdgeContainer::V1::Version>]
        #     Output only. Supported versions, e.g.: ["1.4.0", "1.5.0"].
        # @!attribute [r] default_version
        #   @return [::String]
        #     Output only. Default version, e.g.: "1.4.0".
        class ServerConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::EdgeContainer::V1::ChannelConfig]
          class ChannelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration for a release channel.
        # @!attribute [r] default_version
        #   @return [::String]
        #     Output only. Default version for this release channel, e.g.: "1.4.0".
        class ChannelConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Version of a cluster.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the version, e.g.: "1.4.0".
        class Version
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the accessibility state of a customer-managed KMS key used for
        # CMEK integration.
        module KmsKeyState
          # Unspecified.
          KMS_KEY_STATE_UNSPECIFIED = 0

          # The key is available for use, and dependent resources should be accessible.
          KMS_KEY_STATE_KEY_AVAILABLE = 1

          # The key is unavailable for an unspecified reason. Dependent resources may
          # be inaccessible.
          KMS_KEY_STATE_KEY_UNAVAILABLE = 2
        end

        # Represents if the resource is in lock down state or pending.
        module ResourceState
          # Default value.
          RESOURCE_STATE_UNSPECIFIED = 0

          # The resource is in LOCK DOWN state.
          RESOURCE_STATE_LOCK_DOWN = 1

          # The resource is pending lock down.
          RESOURCE_STATE_LOCK_DOWN_PENDING = 2
        end
      end
    end
  end
end
