# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/edgecontainer/v1/service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module EdgeContainer
      module V1
        module EdgeContainer
          ##
          # Client for the EdgeContainer service.
          #
          # EdgeContainer API provides management of Kubernetes Clusters on Google Edge
          # Cloud deployments.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "edgecontainer.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :edge_container_stub

            ##
            # Configure the EdgeContainer Client class.
            #
            # See {::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all EdgeContainer clients
            #   ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "EdgeContainer", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_clusters.timeout = 60.0
                default_config.rpcs.list_clusters.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_cluster.timeout = 60.0
                default_config.rpcs.get_cluster.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_cluster.timeout = 60.0

                default_config.rpcs.update_cluster.timeout = 60.0

                default_config.rpcs.upgrade_cluster.timeout = 60.0

                default_config.rpcs.delete_cluster.timeout = 60.0

                default_config.rpcs.generate_access_token.timeout = 60.0
                default_config.rpcs.generate_access_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.generate_offline_credential.timeout = 60.0
                default_config.rpcs.generate_offline_credential.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_node_pools.timeout = 60.0
                default_config.rpcs.list_node_pools.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_node_pool.timeout = 60.0
                default_config.rpcs.get_node_pool.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_node_pool.timeout = 60.0

                default_config.rpcs.update_node_pool.timeout = 60.0

                default_config.rpcs.delete_node_pool.timeout = 60.0

                default_config.rpcs.list_machines.timeout = 60.0
                default_config.rpcs.list_machines.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_machine.timeout = 60.0
                default_config.rpcs.get_machine.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_vpn_connections.timeout = 60.0
                default_config.rpcs.list_vpn_connections.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_vpn_connection.timeout = 60.0
                default_config.rpcs.get_vpn_connection.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_vpn_connection.timeout = 60.0

                default_config.rpcs.delete_vpn_connection.timeout = 60.0

                default_config.rpcs.get_server_config.timeout = 60.0
                default_config.rpcs.get_server_config.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the EdgeContainer Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @edge_container_stub.universe_domain
            end

            ##
            # Create a new EdgeContainer client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the EdgeContainer client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/edgecontainer/v1/service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @edge_container_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @edge_container_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @edge_container_stub.endpoint
                config.universe_domain = @edge_container_stub.universe_domain
                config.logger = @edge_container_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::EdgeContainer::V1::EdgeContainer::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @edge_container_stub.logger
            end

            # Service calls

            ##
            # Lists Clusters in a given project and location.
            #
            # @overload list_clusters(request, options = nil)
            #   Pass arguments to `list_clusters` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::ListClustersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::ListClustersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_clusters(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_clusters` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location, which owns this collection of clusters.
            #   @param page_size [::Integer]
            #     The maximum number of resources to list.
            #   @param page_token [::String]
            #     A page token received from previous list request.
            #     A page token received from previous list request.
            #   @param filter [::String]
            #     Only resources matching this filter will be listed.
            #   @param order_by [::String]
            #     Specifies the order in which resources will be listed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::EdgeContainer::V1::Cluster>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::EdgeContainer::V1::Cluster>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::ListClustersRequest.new
            #
            #   # Call the list_clusters method.
            #   result = client.list_clusters request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::EdgeContainer::V1::Cluster.
            #     p item
            #   end
            #
            def list_clusters request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::ListClustersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_clusters.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_clusters.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_clusters.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :list_clusters, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @edge_container_stub, :list_clusters, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Cluster.
            #
            # @overload get_cluster(request, options = nil)
            #   Pass arguments to `get_cluster` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::GetClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::GetClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_cluster(name: nil)
            #   Pass arguments to `get_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the cluster.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::EdgeContainer::V1::Cluster]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::EdgeContainer::V1::Cluster]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::GetClusterRequest.new
            #
            #   # Call the get_cluster method.
            #   result = client.get_cluster request
            #
            #   # The returned object is of type Google::Cloud::EdgeContainer::V1::Cluster.
            #   p result
            #
            def get_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::GetClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :get_cluster, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Cluster in a given project and location.
            #
            # @overload create_cluster(request, options = nil)
            #   Pass arguments to `create_cluster` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::CreateClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::CreateClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_cluster(parent: nil, cluster_id: nil, cluster: nil, request_id: nil)
            #   Pass arguments to `create_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location where this cluster will be created.
            #   @param cluster_id [::String]
            #     Required. A client-specified unique identifier for the cluster.
            #   @param cluster [::Google::Cloud::EdgeContainer::V1::Cluster, ::Hash]
            #     Required. The cluster to create.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters. A
            #     random UUID is recommended. This request is only idempotent if
            #     `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::CreateClusterRequest.new
            #
            #   # Call the create_cluster method.
            #   result = client.create_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::CreateClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :create_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Cluster.
            #
            # @overload update_cluster(request, options = nil)
            #   Pass arguments to `update_cluster` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::UpdateClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::UpdateClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_cluster(update_mask: nil, cluster: nil, request_id: nil)
            #   Pass arguments to `update_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     Cluster resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param cluster [::Google::Cloud::EdgeContainer::V1::Cluster, ::Hash]
            #     The updated cluster.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters.
            #     A random UUID is recommended.
            #     This request is only idempotent if `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::UpdateClusterRequest.new
            #
            #   # Call the update_cluster method.
            #   result = client.update_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::UpdateClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.cluster&.name
                header_params["cluster.name"] = request.cluster.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :update_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Upgrades a single cluster.
            #
            # @overload upgrade_cluster(request, options = nil)
            #   Pass arguments to `upgrade_cluster` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::UpgradeClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::UpgradeClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload upgrade_cluster(name: nil, target_version: nil, schedule: nil, request_id: nil)
            #   Pass arguments to `upgrade_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the cluster.
            #   @param target_version [::String]
            #     Required. The version the cluster is going to be upgraded to.
            #   @param schedule [::Google::Cloud::EdgeContainer::V1::UpgradeClusterRequest::Schedule]
            #     The schedule for the upgrade.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters. A
            #     random UUID is recommended. This request is only idempotent if
            #     `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::UpgradeClusterRequest.new
            #
            #   # Call the upgrade_cluster method.
            #   result = client.upgrade_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def upgrade_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::UpgradeClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.upgrade_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.upgrade_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.upgrade_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :upgrade_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Cluster.
            #
            # @overload delete_cluster(request, options = nil)
            #   Pass arguments to `delete_cluster` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::DeleteClusterRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::DeleteClusterRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_cluster(name: nil, request_id: nil)
            #   Pass arguments to `delete_cluster` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the cluster.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters. A
            #     random UUID is recommended. This request is only idempotent if
            #     `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::DeleteClusterRequest.new
            #
            #   # Call the delete_cluster method.
            #   result = client.delete_cluster request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_cluster request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::DeleteClusterRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_cluster.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_cluster.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_cluster.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :delete_cluster, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates an access token for a Cluster.
            #
            # @overload generate_access_token(request, options = nil)
            #   Pass arguments to `generate_access_token` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::GenerateAccessTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::GenerateAccessTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_access_token(cluster: nil)
            #   Pass arguments to `generate_access_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param cluster [::String]
            #     Required. The resource name of the cluster.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::EdgeContainer::V1::GenerateAccessTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::EdgeContainer::V1::GenerateAccessTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::GenerateAccessTokenRequest.new
            #
            #   # Call the generate_access_token method.
            #   result = client.generate_access_token request
            #
            #   # The returned object is of type Google::Cloud::EdgeContainer::V1::GenerateAccessTokenResponse.
            #   p result
            #
            def generate_access_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::GenerateAccessTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_access_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.cluster
                header_params["cluster"] = request.cluster
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_access_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_access_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :generate_access_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Generates an offline credential for a Cluster.
            #
            # @overload generate_offline_credential(request, options = nil)
            #   Pass arguments to `generate_offline_credential` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload generate_offline_credential(cluster: nil)
            #   Pass arguments to `generate_offline_credential` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param cluster [::String]
            #     Required. The resource name of the cluster.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialRequest.new
            #
            #   # Call the generate_offline_credential method.
            #   result = client.generate_offline_credential request
            #
            #   # The returned object is of type Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialResponse.
            #   p result
            #
            def generate_offline_credential request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::GenerateOfflineCredentialRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.generate_offline_credential.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.cluster
                header_params["cluster"] = request.cluster
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.generate_offline_credential.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.generate_offline_credential.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :generate_offline_credential, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists NodePools in a given project and location.
            #
            # @overload list_node_pools(request, options = nil)
            #   Pass arguments to `list_node_pools` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::ListNodePoolsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::ListNodePoolsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_node_pools(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_node_pools` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent cluster, which owns this collection of node pools.
            #   @param page_size [::Integer]
            #     The maximum number of resources to list.
            #   @param page_token [::String]
            #     A page token received from previous list request.
            #   @param filter [::String]
            #     Only resources matching this filter will be listed.
            #   @param order_by [::String]
            #     Specifies the order in which resources will be listed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::EdgeContainer::V1::NodePool>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::EdgeContainer::V1::NodePool>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::ListNodePoolsRequest.new
            #
            #   # Call the list_node_pools method.
            #   result = client.list_node_pools request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::EdgeContainer::V1::NodePool.
            #     p item
            #   end
            #
            def list_node_pools request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::ListNodePoolsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_node_pools.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_node_pools.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_node_pools.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :list_node_pools, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @edge_container_stub, :list_node_pools, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single NodePool.
            #
            # @overload get_node_pool(request, options = nil)
            #   Pass arguments to `get_node_pool` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::GetNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::GetNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_node_pool(name: nil)
            #   Pass arguments to `get_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the node pool.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::EdgeContainer::V1::NodePool]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::EdgeContainer::V1::NodePool]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::GetNodePoolRequest.new
            #
            #   # Call the get_node_pool method.
            #   result = client.get_node_pool request
            #
            #   # The returned object is of type Google::Cloud::EdgeContainer::V1::NodePool.
            #   p result
            #
            def get_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::GetNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :get_node_pool, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new NodePool in a given project and location.
            #
            # @overload create_node_pool(request, options = nil)
            #   Pass arguments to `create_node_pool` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::CreateNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::CreateNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_node_pool(parent: nil, node_pool_id: nil, node_pool: nil, request_id: nil)
            #   Pass arguments to `create_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent cluster where this node pool will be created.
            #   @param node_pool_id [::String]
            #     Required. A client-specified unique identifier for the node pool.
            #   @param node_pool [::Google::Cloud::EdgeContainer::V1::NodePool, ::Hash]
            #     Required. The node pool to create.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters. A
            #     random UUID is recommended. This request is only idempotent if
            #     `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::CreateNodePoolRequest.new
            #
            #   # Call the create_node_pool method.
            #   result = client.create_node_pool request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::CreateNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :create_node_pool, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single NodePool.
            #
            # @overload update_node_pool(request, options = nil)
            #   Pass arguments to `update_node_pool` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::UpdateNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::UpdateNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_node_pool(update_mask: nil, node_pool: nil, request_id: nil)
            #   Pass arguments to `update_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Field mask is used to specify the fields to be overwritten in the
            #     NodePool resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param node_pool [::Google::Cloud::EdgeContainer::V1::NodePool, ::Hash]
            #     The updated node pool.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters. A
            #     random UUID is recommended. This request is only idempotent if
            #     `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::UpdateNodePoolRequest.new
            #
            #   # Call the update_node_pool method.
            #   result = client.update_node_pool request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::UpdateNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.node_pool&.name
                header_params["node_pool.name"] = request.node_pool.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :update_node_pool, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single NodePool.
            #
            # @overload delete_node_pool(request, options = nil)
            #   Pass arguments to `delete_node_pool` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::DeleteNodePoolRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::DeleteNodePoolRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_node_pool(name: nil, request_id: nil)
            #   Pass arguments to `delete_node_pool` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the node pool.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters. A
            #     random UUID is recommended. This request is only idempotent if
            #     `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::DeleteNodePoolRequest.new
            #
            #   # Call the delete_node_pool method.
            #   result = client.delete_node_pool request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_node_pool request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::DeleteNodePoolRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_node_pool.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_node_pool.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_node_pool.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :delete_node_pool, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Machines in a given project and location.
            #
            # @overload list_machines(request, options = nil)
            #   Pass arguments to `list_machines` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::ListMachinesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::ListMachinesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_machines(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_machines` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent site, which owns this collection of machines.
            #   @param page_size [::Integer]
            #     The maximum number of resources to list.
            #   @param page_token [::String]
            #     A page token received from previous list request.
            #   @param filter [::String]
            #     Only resources matching this filter will be listed.
            #   @param order_by [::String]
            #     Specifies the order in which resources will be listed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::EdgeContainer::V1::Machine>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::EdgeContainer::V1::Machine>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::ListMachinesRequest.new
            #
            #   # Call the list_machines method.
            #   result = client.list_machines request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::EdgeContainer::V1::Machine.
            #     p item
            #   end
            #
            def list_machines request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::ListMachinesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_machines.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_machines.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_machines.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :list_machines, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @edge_container_stub, :list_machines, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Machine.
            #
            # @overload get_machine(request, options = nil)
            #   Pass arguments to `get_machine` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::GetMachineRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::GetMachineRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_machine(name: nil)
            #   Pass arguments to `get_machine` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the machine.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::EdgeContainer::V1::Machine]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::EdgeContainer::V1::Machine]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::GetMachineRequest.new
            #
            #   # Call the get_machine method.
            #   result = client.get_machine request
            #
            #   # The returned object is of type Google::Cloud::EdgeContainer::V1::Machine.
            #   p result
            #
            def get_machine request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::GetMachineRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_machine.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_machine.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_machine.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :get_machine, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists VPN connections in a given project and location.
            #
            # @overload list_vpn_connections(request, options = nil)
            #   Pass arguments to `list_vpn_connections` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::ListVpnConnectionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::ListVpnConnectionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_vpn_connections(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_vpn_connections` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location, which owns this collection of VPN
            #     connections.
            #   @param page_size [::Integer]
            #     The maximum number of resources to list.
            #   @param page_token [::String]
            #     A page token received from previous list request.
            #   @param filter [::String]
            #     Only resources matching this filter will be listed.
            #   @param order_by [::String]
            #     Specifies the order in which resources will be listed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::EdgeContainer::V1::VpnConnection>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::EdgeContainer::V1::VpnConnection>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::ListVpnConnectionsRequest.new
            #
            #   # Call the list_vpn_connections method.
            #   result = client.list_vpn_connections request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::EdgeContainer::V1::VpnConnection.
            #     p item
            #   end
            #
            def list_vpn_connections request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::ListVpnConnectionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_vpn_connections.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_vpn_connections.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_vpn_connections.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :list_vpn_connections, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @edge_container_stub, :list_vpn_connections, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single VPN connection.
            #
            # @overload get_vpn_connection(request, options = nil)
            #   Pass arguments to `get_vpn_connection` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::GetVpnConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::GetVpnConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_vpn_connection(name: nil)
            #   Pass arguments to `get_vpn_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the vpn connection.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::EdgeContainer::V1::VpnConnection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::EdgeContainer::V1::VpnConnection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::GetVpnConnectionRequest.new
            #
            #   # Call the get_vpn_connection method.
            #   result = client.get_vpn_connection request
            #
            #   # The returned object is of type Google::Cloud::EdgeContainer::V1::VpnConnection.
            #   p result
            #
            def get_vpn_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::GetVpnConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_vpn_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_vpn_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_vpn_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :get_vpn_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new VPN connection in a given project and location.
            #
            # @overload create_vpn_connection(request, options = nil)
            #   Pass arguments to `create_vpn_connection` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::CreateVpnConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::CreateVpnConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_vpn_connection(parent: nil, vpn_connection_id: nil, vpn_connection: nil, request_id: nil)
            #   Pass arguments to `create_vpn_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent location where this vpn connection will be created.
            #   @param vpn_connection_id [::String]
            #     Required. The VPN connection identifier.
            #   @param vpn_connection [::Google::Cloud::EdgeContainer::V1::VpnConnection, ::Hash]
            #     Required. The VPN connection to create.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters. A
            #     random UUID is recommended. This request is only idempotent if
            #     `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::CreateVpnConnectionRequest.new
            #
            #   # Call the create_vpn_connection method.
            #   result = client.create_vpn_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_vpn_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::CreateVpnConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_vpn_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_vpn_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_vpn_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :create_vpn_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single VPN connection.
            #
            # @overload delete_vpn_connection(request, options = nil)
            #   Pass arguments to `delete_vpn_connection` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::DeleteVpnConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::DeleteVpnConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_vpn_connection(name: nil, request_id: nil)
            #   Pass arguments to `delete_vpn_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the vpn connection.
            #   @param request_id [::String]
            #     A unique identifier for this request. Restricted to 36 ASCII characters. A
            #     random UUID is recommended. This request is only idempotent if
            #     `request_id` is provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::DeleteVpnConnectionRequest.new
            #
            #   # Call the delete_vpn_connection method.
            #   result = client.delete_vpn_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_vpn_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::DeleteVpnConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_vpn_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_vpn_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_vpn_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :delete_vpn_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets the server config.
            #
            # @overload get_server_config(request, options = nil)
            #   Pass arguments to `get_server_config` via a request object, either of type
            #   {::Google::Cloud::EdgeContainer::V1::GetServerConfigRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::EdgeContainer::V1::GetServerConfigRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_server_config(name: nil)
            #   Pass arguments to `get_server_config` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The name (project and location) of the server config to get,
            #     specified in the format `projects/*/locations/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::EdgeContainer::V1::ServerConfig]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::EdgeContainer::V1::ServerConfig]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/edge_container/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::EdgeContainer::V1::GetServerConfigRequest.new
            #
            #   # Call the get_server_config method.
            #   result = client.get_server_config request
            #
            #   # The returned object is of type Google::Cloud::EdgeContainer::V1::ServerConfig.
            #   p result
            #
            def get_server_config request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::EdgeContainer::V1::GetServerConfigRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_server_config.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::EdgeContainer::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_server_config.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_server_config.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @edge_container_stub.call_rpc :get_server_config, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the EdgeContainer API.
            #
            # This class represents the configuration for EdgeContainer,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_clusters to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_clusters.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_clusters.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "edgecontainer.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the EdgeContainer API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_clusters`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_clusters
                ##
                # RPC-specific configuration for `get_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_cluster
                ##
                # RPC-specific configuration for `create_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_cluster
                ##
                # RPC-specific configuration for `update_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_cluster
                ##
                # RPC-specific configuration for `upgrade_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :upgrade_cluster
                ##
                # RPC-specific configuration for `delete_cluster`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_cluster
                ##
                # RPC-specific configuration for `generate_access_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_access_token
                ##
                # RPC-specific configuration for `generate_offline_credential`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :generate_offline_credential
                ##
                # RPC-specific configuration for `list_node_pools`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_node_pools
                ##
                # RPC-specific configuration for `get_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_node_pool
                ##
                # RPC-specific configuration for `create_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_node_pool
                ##
                # RPC-specific configuration for `update_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_node_pool
                ##
                # RPC-specific configuration for `delete_node_pool`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_node_pool
                ##
                # RPC-specific configuration for `list_machines`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_machines
                ##
                # RPC-specific configuration for `get_machine`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_machine
                ##
                # RPC-specific configuration for `list_vpn_connections`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_vpn_connections
                ##
                # RPC-specific configuration for `get_vpn_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_vpn_connection
                ##
                # RPC-specific configuration for `create_vpn_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_vpn_connection
                ##
                # RPC-specific configuration for `delete_vpn_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_vpn_connection
                ##
                # RPC-specific configuration for `get_server_config`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_server_config

                # @private
                def initialize parent_rpcs = nil
                  list_clusters_config = parent_rpcs.list_clusters if parent_rpcs.respond_to? :list_clusters
                  @list_clusters = ::Gapic::Config::Method.new list_clusters_config
                  get_cluster_config = parent_rpcs.get_cluster if parent_rpcs.respond_to? :get_cluster
                  @get_cluster = ::Gapic::Config::Method.new get_cluster_config
                  create_cluster_config = parent_rpcs.create_cluster if parent_rpcs.respond_to? :create_cluster
                  @create_cluster = ::Gapic::Config::Method.new create_cluster_config
                  update_cluster_config = parent_rpcs.update_cluster if parent_rpcs.respond_to? :update_cluster
                  @update_cluster = ::Gapic::Config::Method.new update_cluster_config
                  upgrade_cluster_config = parent_rpcs.upgrade_cluster if parent_rpcs.respond_to? :upgrade_cluster
                  @upgrade_cluster = ::Gapic::Config::Method.new upgrade_cluster_config
                  delete_cluster_config = parent_rpcs.delete_cluster if parent_rpcs.respond_to? :delete_cluster
                  @delete_cluster = ::Gapic::Config::Method.new delete_cluster_config
                  generate_access_token_config = parent_rpcs.generate_access_token if parent_rpcs.respond_to? :generate_access_token
                  @generate_access_token = ::Gapic::Config::Method.new generate_access_token_config
                  generate_offline_credential_config = parent_rpcs.generate_offline_credential if parent_rpcs.respond_to? :generate_offline_credential
                  @generate_offline_credential = ::Gapic::Config::Method.new generate_offline_credential_config
                  list_node_pools_config = parent_rpcs.list_node_pools if parent_rpcs.respond_to? :list_node_pools
                  @list_node_pools = ::Gapic::Config::Method.new list_node_pools_config
                  get_node_pool_config = parent_rpcs.get_node_pool if parent_rpcs.respond_to? :get_node_pool
                  @get_node_pool = ::Gapic::Config::Method.new get_node_pool_config
                  create_node_pool_config = parent_rpcs.create_node_pool if parent_rpcs.respond_to? :create_node_pool
                  @create_node_pool = ::Gapic::Config::Method.new create_node_pool_config
                  update_node_pool_config = parent_rpcs.update_node_pool if parent_rpcs.respond_to? :update_node_pool
                  @update_node_pool = ::Gapic::Config::Method.new update_node_pool_config
                  delete_node_pool_config = parent_rpcs.delete_node_pool if parent_rpcs.respond_to? :delete_node_pool
                  @delete_node_pool = ::Gapic::Config::Method.new delete_node_pool_config
                  list_machines_config = parent_rpcs.list_machines if parent_rpcs.respond_to? :list_machines
                  @list_machines = ::Gapic::Config::Method.new list_machines_config
                  get_machine_config = parent_rpcs.get_machine if parent_rpcs.respond_to? :get_machine
                  @get_machine = ::Gapic::Config::Method.new get_machine_config
                  list_vpn_connections_config = parent_rpcs.list_vpn_connections if parent_rpcs.respond_to? :list_vpn_connections
                  @list_vpn_connections = ::Gapic::Config::Method.new list_vpn_connections_config
                  get_vpn_connection_config = parent_rpcs.get_vpn_connection if parent_rpcs.respond_to? :get_vpn_connection
                  @get_vpn_connection = ::Gapic::Config::Method.new get_vpn_connection_config
                  create_vpn_connection_config = parent_rpcs.create_vpn_connection if parent_rpcs.respond_to? :create_vpn_connection
                  @create_vpn_connection = ::Gapic::Config::Method.new create_vpn_connection_config
                  delete_vpn_connection_config = parent_rpcs.delete_vpn_connection if parent_rpcs.respond_to? :delete_vpn_connection
                  @delete_vpn_connection = ::Gapic::Config::Method.new delete_vpn_connection_config
                  get_server_config_config = parent_rpcs.get_server_config if parent_rpcs.respond_to? :get_server_config
                  @get_server_config = ::Gapic::Config::Method.new get_server_config_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
