# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/edge_container/v1/version"

require "google/cloud/edge_container/v1/edge_container/credentials"
require "google/cloud/edge_container/v1/edge_container/paths"
require "google/cloud/edge_container/v1/edge_container/operations"
require "google/cloud/edge_container/v1/edge_container/client"
require "google/cloud/edge_container/v1/edge_container/rest"

module Google
  module Cloud
    module EdgeContainer
      module V1
        ##
        # EdgeContainer API provides management of Kubernetes Clusters on Google Edge
        # Cloud deployments.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/edge_container/v1/edge_container"
        #     client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/edge_container/v1/edge_container/rest"
        #     client = ::Google::Cloud::EdgeContainer::V1::EdgeContainer::Rest::Client.new
        #
        module EdgeContainer
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "edge_container", "helpers.rb"
require "google/cloud/edge_container/v1/edge_container/helpers" if ::File.file? helper_path
