# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/domains/v1beta1/domains_pb"
require "google/cloud/domains/v1beta1/domains"

class ::Google::Cloud::Domains::V1beta1::Domains::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_search_domains
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Domains::V1beta1::SearchDomainsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    query = "hello world"
    location = "hello world"

    search_domains_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_domains, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::SearchDomainsRequest, request
      assert_equal "hello world", request["query"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_domains_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_domains({ query: query, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_domains query: query, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_domains ::Google::Cloud::Domains::V1beta1::SearchDomainsRequest.new(query: query, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_domains({ query: query, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_domains(::Google::Cloud::Domains::V1beta1::SearchDomainsRequest.new(query: query, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_domains_client_stub.call_rpc_count
    end
  end

  def test_retrieve_register_parameters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    domain_name = "hello world"
    location = "hello world"

    retrieve_register_parameters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retrieve_register_parameters, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest, request
      assert_equal "hello world", request["domain_name"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retrieve_register_parameters_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retrieve_register_parameters({ domain_name: domain_name, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retrieve_register_parameters domain_name: domain_name, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retrieve_register_parameters ::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest.new(domain_name: domain_name, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retrieve_register_parameters({ domain_name: domain_name, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retrieve_register_parameters(::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest.new(domain_name: domain_name, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retrieve_register_parameters_client_stub.call_rpc_count
    end
  end

  def test_register_domain
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    registration = {}
    domain_notices = [:DOMAIN_NOTICE_UNSPECIFIED]
    contact_notices = [:CONTACT_NOTICE_UNSPECIFIED]
    yearly_price = {}
    validate_only = true

    register_domain_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :register_domain, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::RegisterDomainRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Domains::V1beta1::Registration), request["registration"]
      assert_equal [:DOMAIN_NOTICE_UNSPECIFIED], request["domain_notices"]
      assert_equal [:CONTACT_NOTICE_UNSPECIFIED], request["contact_notices"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Money), request["yearly_price"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, register_domain_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.register_domain({ parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.register_domain parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.register_domain ::Google::Cloud::Domains::V1beta1::RegisterDomainRequest.new(parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.register_domain({ parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.register_domain(::Google::Cloud::Domains::V1beta1::RegisterDomainRequest.new(parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, register_domain_client_stub.call_rpc_count
    end
  end

  def test_retrieve_transfer_parameters
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    domain_name = "hello world"
    location = "hello world"

    retrieve_transfer_parameters_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retrieve_transfer_parameters, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest, request
      assert_equal "hello world", request["domain_name"]
      assert_equal "hello world", request["location"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retrieve_transfer_parameters_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retrieve_transfer_parameters({ domain_name: domain_name, location: location }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retrieve_transfer_parameters domain_name: domain_name, location: location do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retrieve_transfer_parameters ::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest.new(domain_name: domain_name, location: location) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retrieve_transfer_parameters({ domain_name: domain_name, location: location }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retrieve_transfer_parameters(::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest.new(domain_name: domain_name, location: location), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retrieve_transfer_parameters_client_stub.call_rpc_count
    end
  end

  def test_transfer_domain
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    registration = {}
    contact_notices = [:CONTACT_NOTICE_UNSPECIFIED]
    yearly_price = {}
    authorization_code = {}
    validate_only = true

    transfer_domain_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :transfer_domain, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::TransferDomainRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Domains::V1beta1::Registration), request["registration"]
      assert_equal [:CONTACT_NOTICE_UNSPECIFIED], request["contact_notices"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Type::Money), request["yearly_price"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Domains::V1beta1::AuthorizationCode), request["authorization_code"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, transfer_domain_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.transfer_domain({ parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.transfer_domain parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.transfer_domain ::Google::Cloud::Domains::V1beta1::TransferDomainRequest.new(parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.transfer_domain({ parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.transfer_domain(::Google::Cloud::Domains::V1beta1::TransferDomainRequest.new(parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, transfer_domain_client_stub.call_rpc_count
    end
  end

  def test_list_registrations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Domains::V1beta1::ListRegistrationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_registrations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_registrations, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_registrations_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_registrations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_registrations parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_registrations ::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_registrations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_registrations(::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_registrations_client_stub.call_rpc_count
    end
  end

  def test_get_registration
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Domains::V1beta1::Registration.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_registration_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_registration, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::GetRegistrationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_registration_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_registration({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_registration name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_registration ::Google::Cloud::Domains::V1beta1::GetRegistrationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_registration({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_registration(::Google::Cloud::Domains::V1beta1::GetRegistrationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_registration_client_stub.call_rpc_count
    end
  end

  def test_update_registration
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    registration = {}
    update_mask = {}

    update_registration_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_registration, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Domains::V1beta1::Registration), request["registration"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_registration_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_registration({ registration: registration, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_registration registration: registration, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_registration ::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest.new(registration: registration, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_registration({ registration: registration, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_registration(::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest.new(registration: registration, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_registration_client_stub.call_rpc_count
    end
  end

  def test_configure_management_settings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"
    management_settings = {}
    update_mask = {}

    configure_management_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :configure_management_settings, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest, request
      assert_equal "hello world", request["registration"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Domains::V1beta1::ManagementSettings), request["management_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, configure_management_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.configure_management_settings({ registration: registration, management_settings: management_settings, update_mask: update_mask }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.configure_management_settings registration: registration, management_settings: management_settings, update_mask: update_mask do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.configure_management_settings ::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest.new(registration: registration, management_settings: management_settings, update_mask: update_mask) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.configure_management_settings({ registration: registration, management_settings: management_settings, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.configure_management_settings(::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest.new(registration: registration, management_settings: management_settings, update_mask: update_mask), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, configure_management_settings_client_stub.call_rpc_count
    end
  end

  def test_configure_dns_settings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"
    dns_settings = {}
    update_mask = {}
    validate_only = true

    configure_dns_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :configure_dns_settings, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest, request
      assert_equal "hello world", request["registration"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Domains::V1beta1::DnsSettings), request["dns_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, configure_dns_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.configure_dns_settings({ registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.configure_dns_settings registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.configure_dns_settings ::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest.new(registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.configure_dns_settings({ registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.configure_dns_settings(::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest.new(registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, configure_dns_settings_client_stub.call_rpc_count
    end
  end

  def test_configure_contact_settings
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"
    contact_settings = {}
    update_mask = {}
    contact_notices = [:CONTACT_NOTICE_UNSPECIFIED]
    validate_only = true

    configure_contact_settings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :configure_contact_settings, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest, request
      assert_equal "hello world", request["registration"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Domains::V1beta1::ContactSettings), request["contact_settings"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal [:CONTACT_NOTICE_UNSPECIFIED], request["contact_notices"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, configure_contact_settings_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.configure_contact_settings({ registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.configure_contact_settings registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.configure_contact_settings ::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest.new(registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.configure_contact_settings({ registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.configure_contact_settings(::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest.new(registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, configure_contact_settings_client_stub.call_rpc_count
    end
  end

  def test_export_registration
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    export_registration_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :export_registration, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, export_registration_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.export_registration({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.export_registration name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.export_registration ::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.export_registration({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.export_registration(::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, export_registration_client_stub.call_rpc_count
    end
  end

  def test_delete_registration
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_registration_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_registration, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_registration_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_registration({ name: name }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_registration name: name do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_registration ::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest.new(name: name) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_registration({ name: name }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_registration(::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest.new(name: name), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_registration_client_stub.call_rpc_count
    end
  end

  def test_retrieve_authorization_code
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Domains::V1beta1::AuthorizationCode.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"

    retrieve_authorization_code_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retrieve_authorization_code, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest, request
      assert_equal "hello world", request["registration"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retrieve_authorization_code_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retrieve_authorization_code({ registration: registration }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retrieve_authorization_code registration: registration do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retrieve_authorization_code ::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest.new(registration: registration) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retrieve_authorization_code({ registration: registration }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retrieve_authorization_code(::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest.new(registration: registration), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retrieve_authorization_code_client_stub.call_rpc_count
    end
  end

  def test_reset_authorization_code
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Domains::V1beta1::AuthorizationCode.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"

    reset_authorization_code_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :reset_authorization_code, name
      assert_kind_of ::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest, request
      assert_equal "hello world", request["registration"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, reset_authorization_code_client_stub do
      # Create client
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.reset_authorization_code({ registration: registration }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.reset_authorization_code registration: registration do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.reset_authorization_code ::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest.new(registration: registration) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.reset_authorization_code({ registration: registration }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.reset_authorization_code(::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest.new(registration: registration), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, reset_authorization_code_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Domains::V1beta1::Domains::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Domains::V1beta1::Domains::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Domains::V1beta1::Domains::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Domains::V1beta1::Domains::Operations, client.operations_client
  end
end
