# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/domains/v1beta1/domains_pb"
require "google/cloud/domains/v1beta1/domains/rest"


class ::Google::Cloud::Domains::V1beta1::Domains::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_search_domains
    # Create test objects.
    client_result = ::Google::Cloud::Domains::V1beta1::SearchDomainsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    query = "hello world"
    location = "hello world"

    search_domains_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_search_domains_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_domains_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_domains({ query: query, location: location }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_domains query: query, location: location do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_domains ::Google::Cloud::Domains::V1beta1::SearchDomainsRequest.new(query: query, location: location) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_domains({ query: query, location: location }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_domains(::Google::Cloud::Domains::V1beta1::SearchDomainsRequest.new(query: query, location: location), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_domains_client_stub.call_count
      end
    end
  end

  def test_retrieve_register_parameters
    # Create test objects.
    client_result = ::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    domain_name = "hello world"
    location = "hello world"

    retrieve_register_parameters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_retrieve_register_parameters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, retrieve_register_parameters_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.retrieve_register_parameters({ domain_name: domain_name, location: location }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.retrieve_register_parameters domain_name: domain_name, location: location do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.retrieve_register_parameters ::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest.new(domain_name: domain_name, location: location) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.retrieve_register_parameters({ domain_name: domain_name, location: location }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.retrieve_register_parameters(::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest.new(domain_name: domain_name, location: location), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, retrieve_register_parameters_client_stub.call_count
      end
    end
  end

  def test_register_domain
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    registration = {}
    domain_notices = [:DOMAIN_NOTICE_UNSPECIFIED]
    contact_notices = [:CONTACT_NOTICE_UNSPECIFIED]
    yearly_price = {}
    validate_only = true

    register_domain_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_register_domain_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, register_domain_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.register_domain({ parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.register_domain parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.register_domain ::Google::Cloud::Domains::V1beta1::RegisterDomainRequest.new(parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.register_domain({ parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.register_domain(::Google::Cloud::Domains::V1beta1::RegisterDomainRequest.new(parent: parent, registration: registration, domain_notices: domain_notices, contact_notices: contact_notices, yearly_price: yearly_price, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, register_domain_client_stub.call_count
      end
    end
  end

  def test_retrieve_transfer_parameters
    # Create test objects.
    client_result = ::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    domain_name = "hello world"
    location = "hello world"

    retrieve_transfer_parameters_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_retrieve_transfer_parameters_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, retrieve_transfer_parameters_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.retrieve_transfer_parameters({ domain_name: domain_name, location: location }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.retrieve_transfer_parameters domain_name: domain_name, location: location do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.retrieve_transfer_parameters ::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest.new(domain_name: domain_name, location: location) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.retrieve_transfer_parameters({ domain_name: domain_name, location: location }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.retrieve_transfer_parameters(::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest.new(domain_name: domain_name, location: location), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, retrieve_transfer_parameters_client_stub.call_count
      end
    end
  end

  def test_transfer_domain
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    registration = {}
    contact_notices = [:CONTACT_NOTICE_UNSPECIFIED]
    yearly_price = {}
    authorization_code = {}
    validate_only = true

    transfer_domain_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_transfer_domain_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, transfer_domain_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.transfer_domain({ parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.transfer_domain parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.transfer_domain ::Google::Cloud::Domains::V1beta1::TransferDomainRequest.new(parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.transfer_domain({ parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.transfer_domain(::Google::Cloud::Domains::V1beta1::TransferDomainRequest.new(parent: parent, registration: registration, contact_notices: contact_notices, yearly_price: yearly_price, authorization_code: authorization_code, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, transfer_domain_client_stub.call_count
      end
    end
  end

  def test_list_registrations
    # Create test objects.
    client_result = ::Google::Cloud::Domains::V1beta1::ListRegistrationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_registrations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_list_registrations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_registrations_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_registrations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_registrations parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_registrations ::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_registrations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_registrations(::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_registrations_client_stub.call_count
      end
    end
  end

  def test_get_registration
    # Create test objects.
    client_result = ::Google::Cloud::Domains::V1beta1::Registration.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_registration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_get_registration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_registration_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_registration({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_registration name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_registration ::Google::Cloud::Domains::V1beta1::GetRegistrationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_registration({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_registration(::Google::Cloud::Domains::V1beta1::GetRegistrationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_registration_client_stub.call_count
      end
    end
  end

  def test_update_registration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    registration = {}
    update_mask = {}

    update_registration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_update_registration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_registration_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_registration({ registration: registration, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_registration registration: registration, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_registration ::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest.new(registration: registration, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_registration({ registration: registration, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_registration(::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest.new(registration: registration, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_registration_client_stub.call_count
      end
    end
  end

  def test_configure_management_settings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"
    management_settings = {}
    update_mask = {}

    configure_management_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_configure_management_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, configure_management_settings_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.configure_management_settings({ registration: registration, management_settings: management_settings, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.configure_management_settings registration: registration, management_settings: management_settings, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.configure_management_settings ::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest.new(registration: registration, management_settings: management_settings, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.configure_management_settings({ registration: registration, management_settings: management_settings, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.configure_management_settings(::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest.new(registration: registration, management_settings: management_settings, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, configure_management_settings_client_stub.call_count
      end
    end
  end

  def test_configure_dns_settings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"
    dns_settings = {}
    update_mask = {}
    validate_only = true

    configure_dns_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_configure_dns_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, configure_dns_settings_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.configure_dns_settings({ registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.configure_dns_settings registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.configure_dns_settings ::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest.new(registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.configure_dns_settings({ registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.configure_dns_settings(::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest.new(registration: registration, dns_settings: dns_settings, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, configure_dns_settings_client_stub.call_count
      end
    end
  end

  def test_configure_contact_settings
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"
    contact_settings = {}
    update_mask = {}
    contact_notices = [:CONTACT_NOTICE_UNSPECIFIED]
    validate_only = true

    configure_contact_settings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_configure_contact_settings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, configure_contact_settings_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.configure_contact_settings({ registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.configure_contact_settings registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.configure_contact_settings ::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest.new(registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.configure_contact_settings({ registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.configure_contact_settings(::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest.new(registration: registration, contact_settings: contact_settings, update_mask: update_mask, contact_notices: contact_notices, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, configure_contact_settings_client_stub.call_count
      end
    end
  end

  def test_export_registration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    export_registration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_export_registration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, export_registration_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.export_registration({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.export_registration name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.export_registration ::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.export_registration({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.export_registration(::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, export_registration_client_stub.call_count
      end
    end
  end

  def test_delete_registration
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_registration_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_delete_registration_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_registration_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_registration({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_registration name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_registration ::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_registration({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_registration(::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_registration_client_stub.call_count
      end
    end
  end

  def test_retrieve_authorization_code
    # Create test objects.
    client_result = ::Google::Cloud::Domains::V1beta1::AuthorizationCode.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"

    retrieve_authorization_code_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_retrieve_authorization_code_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, retrieve_authorization_code_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.retrieve_authorization_code({ registration: registration }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.retrieve_authorization_code registration: registration do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.retrieve_authorization_code ::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest.new(registration: registration) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.retrieve_authorization_code({ registration: registration }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.retrieve_authorization_code(::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest.new(registration: registration), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, retrieve_authorization_code_client_stub.call_count
      end
    end
  end

  def test_reset_authorization_code
    # Create test objects.
    client_result = ::Google::Cloud::Domains::V1beta1::AuthorizationCode.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    registration = "hello world"

    reset_authorization_code_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.stub :transcode_reset_authorization_code_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reset_authorization_code_client_stub do
        # Create client
        client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reset_authorization_code({ registration: registration }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reset_authorization_code registration: registration do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reset_authorization_code ::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest.new(registration: registration) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reset_authorization_code({ registration: registration }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reset_authorization_code(::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest.new(registration: registration), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reset_authorization_code_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client::Configuration, config
  end
end
