# Generated by the protocol buffer compiler.  DO NOT EDIT!
# Source: google/cloud/domains/v1beta1/domains.proto for package 'google.cloud.domains.v1beta1'
# Original file comments:
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

require 'grpc'
require 'google/cloud/domains/v1beta1/domains_pb'

module Google
  module Cloud
    module Domains
      module V1beta1
        module Domains
          # The Cloud Domains API enables management and configuration of domain names.
          class Service

            include ::GRPC::GenericService

            self.marshal_class_method = :encode
            self.unmarshal_class_method = :decode
            self.service_name = 'google.cloud.domains.v1beta1.Domains'

            # Searches for available domain names similar to the provided query.
            #
            # Availability results from this method are approximate; call
            # `RetrieveRegisterParameters` on a domain before registering to confirm
            # availability.
            rpc :SearchDomains, ::Google::Cloud::Domains::V1beta1::SearchDomainsRequest, ::Google::Cloud::Domains::V1beta1::SearchDomainsResponse
            # Gets parameters needed to register a new domain name, including price and
            # up-to-date availability. Use the returned values to call `RegisterDomain`.
            rpc :RetrieveRegisterParameters, ::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest, ::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersResponse
            # Registers a new domain name and creates a corresponding `Registration`
            # resource.
            #
            # Call `RetrieveRegisterParameters` first to check availability of the domain
            # name and determine parameters like price that are needed to build a call to
            # this method.
            #
            # A successful call creates a `Registration` resource in state
            # `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2
            # minutes, indicating that the domain was successfully registered. If the
            # resource ends up in state `REGISTRATION_FAILED`, it indicates that the
            # domain was not registered successfully, and you can safely delete the
            # resource and retry registration.
            rpc :RegisterDomain, ::Google::Cloud::Domains::V1beta1::RegisterDomainRequest, ::Google::Longrunning::Operation
            # Gets parameters needed to transfer a domain name from another registrar to
            # Cloud Domains. For domains managed by Google Domains, transferring to Cloud
            # Domains is not supported.
            #
            #
            # Use the returned values to call `TransferDomain`.
            rpc :RetrieveTransferParameters, ::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest, ::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersResponse
            # Transfers a domain name from another registrar to Cloud Domains.  For
            # domains managed by Google Domains, transferring to Cloud Domains is not
            # supported.
            #
            #
            # Before calling this method, go to the domain's current registrar to unlock
            # the domain for transfer and retrieve the domain's transfer authorization
            # code. Then call `RetrieveTransferParameters` to confirm that the domain is
            # unlocked and to get values needed to build a call to this method.
            #
            # A successful call creates a `Registration` resource in state
            # `TRANSFER_PENDING`. It can take several days to complete the transfer
            # process. The registrant can often speed up this process by approving the
            # transfer through the current registrar, either by clicking a link in an
            # email from the registrar or by visiting the registrar's website.
            #
            # A few minutes after transfer approval, the resource transitions to state
            # `ACTIVE`, indicating that the transfer was successful. If the transfer is
            # rejected or the request expires without being approved, the resource can
            # end up in state `TRANSFER_FAILED`. If transfer fails, you can safely delete
            # the resource and retry the transfer.
            rpc :TransferDomain, ::Google::Cloud::Domains::V1beta1::TransferDomainRequest, ::Google::Longrunning::Operation
            # Lists the `Registration` resources in a project.
            rpc :ListRegistrations, ::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest, ::Google::Cloud::Domains::V1beta1::ListRegistrationsResponse
            # Gets the details of a `Registration` resource.
            rpc :GetRegistration, ::Google::Cloud::Domains::V1beta1::GetRegistrationRequest, ::Google::Cloud::Domains::V1beta1::Registration
            # Updates select fields of a `Registration` resource, notably `labels`. To
            # update other fields, use the appropriate custom update method:
            #
            # * To update management settings, see `ConfigureManagementSettings`
            # * To update DNS configuration, see `ConfigureDnsSettings`
            # * To update contact information, see `ConfigureContactSettings`
            rpc :UpdateRegistration, ::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest, ::Google::Longrunning::Operation
            # Updates a `Registration`'s management settings.
            rpc :ConfigureManagementSettings, ::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest, ::Google::Longrunning::Operation
            # Updates a `Registration`'s DNS settings.
            rpc :ConfigureDnsSettings, ::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest, ::Google::Longrunning::Operation
            # Updates a `Registration`'s contact settings. Some changes require
            # confirmation by the domain's registrant contact .
            rpc :ConfigureContactSettings, ::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest, ::Google::Longrunning::Operation
            # Exports a `Registration` resource, such that it is no longer managed by
            # Cloud Domains.
            #
            # When an active domain is successfully exported, you can continue to use the
            # domain in [Google Domains](https://domains.google/) until it expires. The
            # calling user becomes the domain's sole owner in Google Domains, and
            # permissions for the domain are subsequently managed there. The domain does
            # not renew automatically unless the new owner sets up billing in Google
            # Domains.
            rpc :ExportRegistration, ::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest, ::Google::Longrunning::Operation
            # Deletes a `Registration` resource.
            #
            # This method works on any `Registration` resource using [Subscription or
            # Commitment billing](/domains/pricing#billing-models), provided that the
            # resource was created at least 1 day in the past.
            #
            # For `Registration` resources using
            # [Monthly billing](/domains/pricing#billing-models), this method works if:
            #
            # * `state` is `EXPORTED` with `expire_time` in the past
            # * `state` is `REGISTRATION_FAILED`
            # * `state` is `TRANSFER_FAILED`
            #
            # When an active registration is successfully deleted, you can continue to
            # use the domain in [Google Domains](https://domains.google/) until it
            # expires. The calling user becomes the domain's sole owner in Google
            # Domains, and permissions for the domain are subsequently managed there. The
            # domain does not renew automatically unless the new owner sets up billing in
            # Google Domains.
            rpc :DeleteRegistration, ::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest, ::Google::Longrunning::Operation
            # Gets the authorization code of the `Registration` for the purpose of
            # transferring the domain to another registrar.
            #
            # You can call this method only after 60 days have elapsed since the initial
            # domain registration.
            rpc :RetrieveAuthorizationCode, ::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest, ::Google::Cloud::Domains::V1beta1::AuthorizationCode
            # Resets the authorization code of the `Registration` to a new random string.
            #
            # You can call this method only after 60 days have elapsed since the initial
            # domain registration.
            rpc :ResetAuthorizationCode, ::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest, ::Google::Cloud::Domains::V1beta1::AuthorizationCode
          end

          Stub = Service.rpc_stub_class
        end
      end
    end
  end
end
