# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/domains/v1beta1/domains_pb"
require "google/cloud/domains/v1beta1/domains/rest/service_stub"

module Google
  module Cloud
    module Domains
      module V1beta1
        module Domains
          module Rest
            ##
            # REST client for the Domains service.
            #
            # The Cloud Domains API enables management and configuration of domain names.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "domains.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :domains_stub

              ##
              # Configure the Domains Client class.
              #
              # See {::Google::Cloud::Domains::V1beta1::Domains::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Domains clients
              #   ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Domains", "V1beta1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Domains Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Domains::V1beta1::Domains::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @domains_stub.universe_domain
              end

              ##
              # Create a new Domains REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Domains client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @domains_stub = ::Google::Cloud::Domains::V1beta1::Domains::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @domains_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Domains::V1beta1::Domains::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @domains_stub.logger
              end

              # Service calls

              ##
              # Searches for available domain names similar to the provided query.
              #
              # Availability results from this method are approximate; call
              # `RetrieveRegisterParameters` on a domain before registering to confirm
              # availability.
              #
              # @overload search_domains(request, options = nil)
              #   Pass arguments to `search_domains` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::SearchDomainsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::SearchDomainsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_domains(query: nil, location: nil)
              #   Pass arguments to `search_domains` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param query [::String]
              #     Required. String used to search for available domain names.
              #   @param location [::String]
              #     Required. The location. Must be in the format `projects/*/locations/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Domains::V1beta1::SearchDomainsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Domains::V1beta1::SearchDomainsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::SearchDomainsRequest.new
              #
              #   # Call the search_domains method.
              #   result = client.search_domains request
              #
              #   # The returned object is of type Google::Cloud::Domains::V1beta1::SearchDomainsResponse.
              #   p result
              #
              def search_domains request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::SearchDomainsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_domains.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_domains.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_domains.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.search_domains request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets parameters needed to register a new domain name, including price and
              # up-to-date availability. Use the returned values to call `RegisterDomain`.
              #
              # @overload retrieve_register_parameters(request, options = nil)
              #   Pass arguments to `retrieve_register_parameters` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload retrieve_register_parameters(domain_name: nil, location: nil)
              #   Pass arguments to `retrieve_register_parameters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param domain_name [::String]
              #     Required. The domain name. Unicode domain names must be expressed in Punycode format.
              #   @param location [::String]
              #     Required. The location. Must be in the format `projects/*/locations/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest.new
              #
              #   # Call the retrieve_register_parameters method.
              #   result = client.retrieve_register_parameters request
              #
              #   # The returned object is of type Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersResponse.
              #   p result
              #
              def retrieve_register_parameters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::RetrieveRegisterParametersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.retrieve_register_parameters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.retrieve_register_parameters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.retrieve_register_parameters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.retrieve_register_parameters request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Registers a new domain name and creates a corresponding `Registration`
              # resource.
              #
              # Call `RetrieveRegisterParameters` first to check availability of the domain
              # name and determine parameters like price that are needed to build a call to
              # this method.
              #
              # A successful call creates a `Registration` resource in state
              # `REGISTRATION_PENDING`, which resolves to `ACTIVE` within 1-2
              # minutes, indicating that the domain was successfully registered. If the
              # resource ends up in state `REGISTRATION_FAILED`, it indicates that the
              # domain was not registered successfully, and you can safely delete the
              # resource and retry registration.
              #
              # @overload register_domain(request, options = nil)
              #   Pass arguments to `register_domain` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::RegisterDomainRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::RegisterDomainRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload register_domain(parent: nil, registration: nil, domain_notices: nil, contact_notices: nil, yearly_price: nil, validate_only: nil)
              #   Pass arguments to `register_domain` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the `Registration`. Must be in the
              #     format `projects/*/locations/*`.
              #   @param registration [::Google::Cloud::Domains::V1beta1::Registration, ::Hash]
              #     Required. The complete `Registration` resource to be created.
              #   @param domain_notices [::Array<::Google::Cloud::Domains::V1beta1::DomainNotice>]
              #     The list of domain notices that you acknowledge. Call
              #     `RetrieveRegisterParameters` to see the notices that need acknowledgement.
              #   @param contact_notices [::Array<::Google::Cloud::Domains::V1beta1::ContactNotice>]
              #     The list of contact notices that the caller acknowledges. The notices
              #     needed here depend on the values specified in
              #     `registration.contact_settings`.
              #   @param yearly_price [::Google::Type::Money, ::Hash]
              #     Required. Yearly price to register or renew the domain.
              #     The value that should be put here can be obtained from
              #     RetrieveRegisterParameters or SearchDomains calls.
              #   @param validate_only [::Boolean]
              #     When true, only validation is performed, without actually registering
              #     the domain. Follows:
              #     https://cloud.google.com/apis/design/design_patterns#request_validation
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::RegisterDomainRequest.new
              #
              #   # Call the register_domain method.
              #   result = client.register_domain request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def register_domain request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::RegisterDomainRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.register_domain.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.register_domain.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.register_domain.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.register_domain request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets parameters needed to transfer a domain name from another registrar to
              # Cloud Domains. For domains managed by Google Domains, transferring to Cloud
              # Domains is not supported.
              #
              #
              # Use the returned values to call `TransferDomain`.
              #
              # @overload retrieve_transfer_parameters(request, options = nil)
              #   Pass arguments to `retrieve_transfer_parameters` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload retrieve_transfer_parameters(domain_name: nil, location: nil)
              #   Pass arguments to `retrieve_transfer_parameters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param domain_name [::String]
              #     Required. The domain name. Unicode domain names must be expressed in Punycode format.
              #   @param location [::String]
              #     Required. The location. Must be in the format `projects/*/locations/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest.new
              #
              #   # Call the retrieve_transfer_parameters method.
              #   result = client.retrieve_transfer_parameters request
              #
              #   # The returned object is of type Google::Cloud::Domains::V1beta1::RetrieveTransferParametersResponse.
              #   p result
              #
              def retrieve_transfer_parameters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::RetrieveTransferParametersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.retrieve_transfer_parameters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.retrieve_transfer_parameters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.retrieve_transfer_parameters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.retrieve_transfer_parameters request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Transfers a domain name from another registrar to Cloud Domains.  For
              # domains managed by Google Domains, transferring to Cloud Domains is not
              # supported.
              #
              #
              # Before calling this method, go to the domain's current registrar to unlock
              # the domain for transfer and retrieve the domain's transfer authorization
              # code. Then call `RetrieveTransferParameters` to confirm that the domain is
              # unlocked and to get values needed to build a call to this method.
              #
              # A successful call creates a `Registration` resource in state
              # `TRANSFER_PENDING`. It can take several days to complete the transfer
              # process. The registrant can often speed up this process by approving the
              # transfer through the current registrar, either by clicking a link in an
              # email from the registrar or by visiting the registrar's website.
              #
              # A few minutes after transfer approval, the resource transitions to state
              # `ACTIVE`, indicating that the transfer was successful. If the transfer is
              # rejected or the request expires without being approved, the resource can
              # end up in state `TRANSFER_FAILED`. If transfer fails, you can safely delete
              # the resource and retry the transfer.
              #
              # @overload transfer_domain(request, options = nil)
              #   Pass arguments to `transfer_domain` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::TransferDomainRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::TransferDomainRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload transfer_domain(parent: nil, registration: nil, contact_notices: nil, yearly_price: nil, authorization_code: nil, validate_only: nil)
              #   Pass arguments to `transfer_domain` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the `Registration`. Must be in the
              #     format `projects/*/locations/*`.
              #   @param registration [::Google::Cloud::Domains::V1beta1::Registration, ::Hash]
              #     Required. The complete `Registration` resource to be created.
              #
              #     You can leave `registration.dns_settings` unset to import the
              #     domain's current DNS configuration from its current registrar. Use this
              #     option only if you are sure that the domain's current DNS service
              #     does not cease upon transfer, as is often the case for DNS services
              #     provided for free by the registrar.
              #   @param contact_notices [::Array<::Google::Cloud::Domains::V1beta1::ContactNotice>]
              #     The list of contact notices that you acknowledge. The notices
              #     needed here depend on the values specified in
              #     `registration.contact_settings`.
              #   @param yearly_price [::Google::Type::Money, ::Hash]
              #     Required. Acknowledgement of the price to transfer or renew the domain for one year.
              #     Call `RetrieveTransferParameters` to obtain the price, which you must
              #     acknowledge.
              #   @param authorization_code [::Google::Cloud::Domains::V1beta1::AuthorizationCode, ::Hash]
              #     The domain's transfer authorization code. You can obtain this from the
              #     domain's current registrar.
              #   @param validate_only [::Boolean]
              #     Validate the request without actually transferring the domain.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::TransferDomainRequest.new
              #
              #   # Call the transfer_domain method.
              #   result = client.transfer_domain request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def transfer_domain request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::TransferDomainRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.transfer_domain.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.transfer_domain.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.transfer_domain.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.transfer_domain request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists the `Registration` resources in a project.
              #
              # @overload list_registrations(request, options = nil)
              #   Pass arguments to `list_registrations` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_registrations(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_registrations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The project and location from which to list `Registration`s, specified in
              #     the format `projects/*/locations/*`.
              #   @param page_size [::Integer]
              #     Maximum number of results to return.
              #   @param page_token [::String]
              #     When set to the `next_page_token` from a prior response, provides the next
              #     page of results.
              #   @param filter [::String]
              #     Filter expression to restrict the `Registration`s returned.
              #
              #     The expression must specify the field name, a comparison operator, and the
              #     value that you want to use for filtering. The value must be a string, a
              #     number, a boolean, or an enum value. The comparison operator should be one
              #     of =, !=, >, <, >=, <=, or : for prefix or wildcard matches.
              #
              #     For example, to filter to a specific domain name, use an expression like
              #     `domainName="example.com"`. You can also check for the existence of a
              #     field; for example, to find domains using custom DNS settings, use an
              #     expression like `dnsSettings.customDns:*`.
              #
              #     You can also create compound filters by combining expressions with the
              #     `AND` and `OR` operators. For example, to find domains that are suspended
              #     or have specific issues flagged, use an expression like
              #     `(state=SUSPENDED) OR (issue:*)`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Domains::V1beta1::Registration>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Domains::V1beta1::Registration>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::ListRegistrationsRequest.new
              #
              #   # Call the list_registrations method.
              #   result = client.list_registrations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Domains::V1beta1::Registration.
              #     p item
              #   end
              #
              def list_registrations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::ListRegistrationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_registrations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_registrations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_registrations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.list_registrations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @domains_stub, :list_registrations, "registrations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the details of a `Registration` resource.
              #
              # @overload get_registration(request, options = nil)
              #   Pass arguments to `get_registration` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::GetRegistrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::GetRegistrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_registration(name: nil)
              #   Pass arguments to `get_registration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `Registration` to get, in the format
              #     `projects/*/locations/*/registrations/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Domains::V1beta1::Registration]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Domains::V1beta1::Registration]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::GetRegistrationRequest.new
              #
              #   # Call the get_registration method.
              #   result = client.get_registration request
              #
              #   # The returned object is of type Google::Cloud::Domains::V1beta1::Registration.
              #   p result
              #
              def get_registration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::GetRegistrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_registration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_registration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_registration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.get_registration request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates select fields of a `Registration` resource, notably `labels`. To
              # update other fields, use the appropriate custom update method:
              #
              # * To update management settings, see `ConfigureManagementSettings`
              # * To update DNS configuration, see `ConfigureDnsSettings`
              # * To update contact information, see `ConfigureContactSettings`
              #
              # @overload update_registration(request, options = nil)
              #   Pass arguments to `update_registration` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_registration(registration: nil, update_mask: nil)
              #   Pass arguments to `update_registration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param registration [::Google::Cloud::Domains::V1beta1::Registration, ::Hash]
              #     Fields of the `Registration` to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The field mask describing which fields to update as a comma-separated list.
              #     For example, if only the labels are being updated, the `update_mask` is
              #     `"labels"`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest.new
              #
              #   # Call the update_registration method.
              #   result = client.update_registration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_registration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::UpdateRegistrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_registration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_registration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_registration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.update_registration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a `Registration`'s management settings.
              #
              # @overload configure_management_settings(request, options = nil)
              #   Pass arguments to `configure_management_settings` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload configure_management_settings(registration: nil, management_settings: nil, update_mask: nil)
              #   Pass arguments to `configure_management_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param registration [::String]
              #     Required. The name of the `Registration` whose management settings are being updated,
              #     in the format `projects/*/locations/*/registrations/*`.
              #   @param management_settings [::Google::Cloud::Domains::V1beta1::ManagementSettings, ::Hash]
              #     Fields of the `ManagementSettings` to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The field mask describing which fields to update as a comma-separated list.
              #     For example, if only the transfer lock is being updated, the `update_mask`
              #     is `"transfer_lock_state"`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest.new
              #
              #   # Call the configure_management_settings method.
              #   result = client.configure_management_settings request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def configure_management_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::ConfigureManagementSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.configure_management_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.configure_management_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.configure_management_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.configure_management_settings request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a `Registration`'s DNS settings.
              #
              # @overload configure_dns_settings(request, options = nil)
              #   Pass arguments to `configure_dns_settings` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload configure_dns_settings(registration: nil, dns_settings: nil, update_mask: nil, validate_only: nil)
              #   Pass arguments to `configure_dns_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param registration [::String]
              #     Required. The name of the `Registration` whose DNS settings are being updated,
              #     in the format `projects/*/locations/*/registrations/*`.
              #   @param dns_settings [::Google::Cloud::Domains::V1beta1::DnsSettings, ::Hash]
              #     Fields of the `DnsSettings` to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The field mask describing which fields to update as a comma-separated list.
              #     For example, if only the name servers are being updated for an existing
              #     Custom DNS configuration, the `update_mask` is
              #     `"custom_dns.name_servers"`.
              #
              #     When changing the DNS provider from one type to another, pass the new
              #     provider's field name as part of the field mask. For example, when changing
              #     from a Google Domains DNS configuration to a Custom DNS configuration, the
              #     `update_mask` is `"custom_dns"`. //
              #   @param validate_only [::Boolean]
              #     Validate the request without actually updating the DNS settings.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest.new
              #
              #   # Call the configure_dns_settings method.
              #   result = client.configure_dns_settings request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def configure_dns_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::ConfigureDnsSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.configure_dns_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.configure_dns_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.configure_dns_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.configure_dns_settings request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a `Registration`'s contact settings. Some changes require
              # confirmation by the domain's registrant contact .
              #
              # @overload configure_contact_settings(request, options = nil)
              #   Pass arguments to `configure_contact_settings` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload configure_contact_settings(registration: nil, contact_settings: nil, update_mask: nil, contact_notices: nil, validate_only: nil)
              #   Pass arguments to `configure_contact_settings` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param registration [::String]
              #     Required. The name of the `Registration` whose contact settings are being updated,
              #     in the format `projects/*/locations/*/registrations/*`.
              #   @param contact_settings [::Google::Cloud::Domains::V1beta1::ContactSettings, ::Hash]
              #     Fields of the `ContactSettings` to update.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. The field mask describing which fields to update as a comma-separated list.
              #     For example, if only the registrant contact is being updated, the
              #     `update_mask` is `"registrant_contact"`.
              #   @param contact_notices [::Array<::Google::Cloud::Domains::V1beta1::ContactNotice>]
              #     The list of contact notices that the caller acknowledges. The notices
              #     needed here depend on the values specified in `contact_settings`.
              #   @param validate_only [::Boolean]
              #     Validate the request without actually updating the contact settings.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest.new
              #
              #   # Call the configure_contact_settings method.
              #   result = client.configure_contact_settings request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def configure_contact_settings request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::ConfigureContactSettingsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.configure_contact_settings.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.configure_contact_settings.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.configure_contact_settings.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.configure_contact_settings request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Exports a `Registration` resource, such that it is no longer managed by
              # Cloud Domains.
              #
              # When an active domain is successfully exported, you can continue to use the
              # domain in [Google Domains](https://domains.google/) until it expires. The
              # calling user becomes the domain's sole owner in Google Domains, and
              # permissions for the domain are subsequently managed there. The domain does
              # not renew automatically unless the new owner sets up billing in Google
              # Domains.
              #
              # @overload export_registration(request, options = nil)
              #   Pass arguments to `export_registration` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload export_registration(name: nil)
              #   Pass arguments to `export_registration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `Registration` to export,
              #     in the format `projects/*/locations/*/registrations/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::ExportRegistrationRequest.new
              #
              #   # Call the export_registration method.
              #   result = client.export_registration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def export_registration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::ExportRegistrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.export_registration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.export_registration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.export_registration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.export_registration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a `Registration` resource.
              #
              # This method works on any `Registration` resource using [Subscription or
              # Commitment billing](/domains/pricing#billing-models), provided that the
              # resource was created at least 1 day in the past.
              #
              # For `Registration` resources using
              # [Monthly billing](/domains/pricing#billing-models), this method works if:
              #
              # * `state` is `EXPORTED` with `expire_time` in the past
              # * `state` is `REGISTRATION_FAILED`
              # * `state` is `TRANSFER_FAILED`
              #
              # When an active registration is successfully deleted, you can continue to
              # use the domain in [Google Domains](https://domains.google/) until it
              # expires. The calling user becomes the domain's sole owner in Google
              # Domains, and permissions for the domain are subsequently managed there. The
              # domain does not renew automatically unless the new owner sets up billing in
              # Google Domains.
              #
              # @overload delete_registration(request, options = nil)
              #   Pass arguments to `delete_registration` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_registration(name: nil)
              #   Pass arguments to `delete_registration` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `Registration` to delete,
              #     in the format `projects/*/locations/*/registrations/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest.new
              #
              #   # Call the delete_registration method.
              #   result = client.delete_registration request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_registration request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::DeleteRegistrationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_registration.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_registration.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_registration.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.delete_registration request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the authorization code of the `Registration` for the purpose of
              # transferring the domain to another registrar.
              #
              # You can call this method only after 60 days have elapsed since the initial
              # domain registration.
              #
              # @overload retrieve_authorization_code(request, options = nil)
              #   Pass arguments to `retrieve_authorization_code` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload retrieve_authorization_code(registration: nil)
              #   Pass arguments to `retrieve_authorization_code` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param registration [::String]
              #     Required. The name of the `Registration` whose authorization code is being retrieved,
              #     in the format `projects/*/locations/*/registrations/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Domains::V1beta1::AuthorizationCode]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Domains::V1beta1::AuthorizationCode]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest.new
              #
              #   # Call the retrieve_authorization_code method.
              #   result = client.retrieve_authorization_code request
              #
              #   # The returned object is of type Google::Cloud::Domains::V1beta1::AuthorizationCode.
              #   p result
              #
              def retrieve_authorization_code request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::RetrieveAuthorizationCodeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.retrieve_authorization_code.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.retrieve_authorization_code.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.retrieve_authorization_code.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.retrieve_authorization_code request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Resets the authorization code of the `Registration` to a new random string.
              #
              # You can call this method only after 60 days have elapsed since the initial
              # domain registration.
              #
              # @overload reset_authorization_code(request, options = nil)
              #   Pass arguments to `reset_authorization_code` via a request object, either of type
              #   {::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reset_authorization_code(registration: nil)
              #   Pass arguments to `reset_authorization_code` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param registration [::String]
              #     Required. The name of the `Registration` whose authorization code is being reset,
              #     in the format `projects/*/locations/*/registrations/*`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Domains::V1beta1::AuthorizationCode]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Domains::V1beta1::AuthorizationCode]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/domains/v1beta1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest.new
              #
              #   # Call the reset_authorization_code method.
              #   result = client.reset_authorization_code request
              #
              #   # The returned object is of type Google::Cloud::Domains::V1beta1::AuthorizationCode.
              #   p result
              #
              def reset_authorization_code request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Domains::V1beta1::ResetAuthorizationCodeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reset_authorization_code.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Domains::V1beta1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reset_authorization_code.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reset_authorization_code.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @domains_stub.reset_authorization_code request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Domains REST API.
              #
              # This class represents the configuration for Domains REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Domains::V1beta1::Domains::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # search_domains to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.search_domains.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Domains::V1beta1::Domains::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.search_domains.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "domains.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Domains API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `search_domains`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_domains
                  ##
                  # RPC-specific configuration for `retrieve_register_parameters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :retrieve_register_parameters
                  ##
                  # RPC-specific configuration for `register_domain`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :register_domain
                  ##
                  # RPC-specific configuration for `retrieve_transfer_parameters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :retrieve_transfer_parameters
                  ##
                  # RPC-specific configuration for `transfer_domain`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :transfer_domain
                  ##
                  # RPC-specific configuration for `list_registrations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_registrations
                  ##
                  # RPC-specific configuration for `get_registration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_registration
                  ##
                  # RPC-specific configuration for `update_registration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_registration
                  ##
                  # RPC-specific configuration for `configure_management_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :configure_management_settings
                  ##
                  # RPC-specific configuration for `configure_dns_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :configure_dns_settings
                  ##
                  # RPC-specific configuration for `configure_contact_settings`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :configure_contact_settings
                  ##
                  # RPC-specific configuration for `export_registration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :export_registration
                  ##
                  # RPC-specific configuration for `delete_registration`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_registration
                  ##
                  # RPC-specific configuration for `retrieve_authorization_code`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :retrieve_authorization_code
                  ##
                  # RPC-specific configuration for `reset_authorization_code`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reset_authorization_code

                  # @private
                  def initialize parent_rpcs = nil
                    search_domains_config = parent_rpcs.search_domains if parent_rpcs.respond_to? :search_domains
                    @search_domains = ::Gapic::Config::Method.new search_domains_config
                    retrieve_register_parameters_config = parent_rpcs.retrieve_register_parameters if parent_rpcs.respond_to? :retrieve_register_parameters
                    @retrieve_register_parameters = ::Gapic::Config::Method.new retrieve_register_parameters_config
                    register_domain_config = parent_rpcs.register_domain if parent_rpcs.respond_to? :register_domain
                    @register_domain = ::Gapic::Config::Method.new register_domain_config
                    retrieve_transfer_parameters_config = parent_rpcs.retrieve_transfer_parameters if parent_rpcs.respond_to? :retrieve_transfer_parameters
                    @retrieve_transfer_parameters = ::Gapic::Config::Method.new retrieve_transfer_parameters_config
                    transfer_domain_config = parent_rpcs.transfer_domain if parent_rpcs.respond_to? :transfer_domain
                    @transfer_domain = ::Gapic::Config::Method.new transfer_domain_config
                    list_registrations_config = parent_rpcs.list_registrations if parent_rpcs.respond_to? :list_registrations
                    @list_registrations = ::Gapic::Config::Method.new list_registrations_config
                    get_registration_config = parent_rpcs.get_registration if parent_rpcs.respond_to? :get_registration
                    @get_registration = ::Gapic::Config::Method.new get_registration_config
                    update_registration_config = parent_rpcs.update_registration if parent_rpcs.respond_to? :update_registration
                    @update_registration = ::Gapic::Config::Method.new update_registration_config
                    configure_management_settings_config = parent_rpcs.configure_management_settings if parent_rpcs.respond_to? :configure_management_settings
                    @configure_management_settings = ::Gapic::Config::Method.new configure_management_settings_config
                    configure_dns_settings_config = parent_rpcs.configure_dns_settings if parent_rpcs.respond_to? :configure_dns_settings
                    @configure_dns_settings = ::Gapic::Config::Method.new configure_dns_settings_config
                    configure_contact_settings_config = parent_rpcs.configure_contact_settings if parent_rpcs.respond_to? :configure_contact_settings
                    @configure_contact_settings = ::Gapic::Config::Method.new configure_contact_settings_config
                    export_registration_config = parent_rpcs.export_registration if parent_rpcs.respond_to? :export_registration
                    @export_registration = ::Gapic::Config::Method.new export_registration_config
                    delete_registration_config = parent_rpcs.delete_registration if parent_rpcs.respond_to? :delete_registration
                    @delete_registration = ::Gapic::Config::Method.new delete_registration_config
                    retrieve_authorization_code_config = parent_rpcs.retrieve_authorization_code if parent_rpcs.respond_to? :retrieve_authorization_code
                    @retrieve_authorization_code = ::Gapic::Config::Method.new retrieve_authorization_code_config
                    reset_authorization_code_config = parent_rpcs.reset_authorization_code if parent_rpcs.respond_to? :reset_authorization_code
                    @reset_authorization_code = ::Gapic::Config::Method.new reset_authorization_code_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
