# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/documentai/v1beta3/document_processor_service_pb"
require "google/cloud/document_ai/v1beta3/document_processor_service/rest"


class ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_process_document
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::ProcessResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    inline_document = {}
    name = "hello world"
    document = {}
    skip_human_review = true
    field_mask = {}
    process_options = {}
    labels = {}
    imageless_mode = true

    process_document_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_process_document_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, process_document_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.process_document({ inline_document: inline_document, name: name, document: document, skip_human_review: skip_human_review, field_mask: field_mask, process_options: process_options, labels: labels, imageless_mode: imageless_mode }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.process_document inline_document: inline_document, name: name, document: document, skip_human_review: skip_human_review, field_mask: field_mask, process_options: process_options, labels: labels, imageless_mode: imageless_mode do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.process_document ::Google::Cloud::DocumentAI::V1beta3::ProcessRequest.new(inline_document: inline_document, name: name, document: document, skip_human_review: skip_human_review, field_mask: field_mask, process_options: process_options, labels: labels, imageless_mode: imageless_mode) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.process_document({ inline_document: inline_document, name: name, document: document, skip_human_review: skip_human_review, field_mask: field_mask, process_options: process_options, labels: labels, imageless_mode: imageless_mode }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.process_document(::Google::Cloud::DocumentAI::V1beta3::ProcessRequest.new(inline_document: inline_document, name: name, document: document, skip_human_review: skip_human_review, field_mask: field_mask, process_options: process_options, labels: labels, imageless_mode: imageless_mode), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, process_document_client_stub.call_count
      end
    end
  end

  def test_batch_process_documents
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    input_configs = [{}]
    output_config = {}
    input_documents = {}
    document_output_config = {}
    skip_human_review = true
    process_options = {}
    labels = {}

    batch_process_documents_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_batch_process_documents_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_process_documents_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_process_documents({ name: name, input_configs: input_configs, output_config: output_config, input_documents: input_documents, document_output_config: document_output_config, skip_human_review: skip_human_review, process_options: process_options, labels: labels }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_process_documents name: name, input_configs: input_configs, output_config: output_config, input_documents: input_documents, document_output_config: document_output_config, skip_human_review: skip_human_review, process_options: process_options, labels: labels do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_process_documents ::Google::Cloud::DocumentAI::V1beta3::BatchProcessRequest.new(name: name, input_configs: input_configs, output_config: output_config, input_documents: input_documents, document_output_config: document_output_config, skip_human_review: skip_human_review, process_options: process_options, labels: labels) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_process_documents({ name: name, input_configs: input_configs, output_config: output_config, input_documents: input_documents, document_output_config: document_output_config, skip_human_review: skip_human_review, process_options: process_options, labels: labels }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_process_documents(::Google::Cloud::DocumentAI::V1beta3::BatchProcessRequest.new(name: name, input_configs: input_configs, output_config: output_config, input_documents: input_documents, document_output_config: document_output_config, skip_human_review: skip_human_review, process_options: process_options, labels: labels), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_process_documents_client_stub.call_count
      end
    end
  end

  def test_fetch_processor_types
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::FetchProcessorTypesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    fetch_processor_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_fetch_processor_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_processor_types_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_processor_types({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_processor_types parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_processor_types ::Google::Cloud::DocumentAI::V1beta3::FetchProcessorTypesRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_processor_types({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_processor_types(::Google::Cloud::DocumentAI::V1beta3::FetchProcessorTypesRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_processor_types_client_stub.call_count
      end
    end
  end

  def test_list_processor_types
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::ListProcessorTypesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_processor_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_list_processor_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_processor_types_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_processor_types({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_processor_types parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_processor_types ::Google::Cloud::DocumentAI::V1beta3::ListProcessorTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_processor_types({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_processor_types(::Google::Cloud::DocumentAI::V1beta3::ListProcessorTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_processor_types_client_stub.call_count
      end
    end
  end

  def test_get_processor_type
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::ProcessorType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_processor_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_get_processor_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_processor_type_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_processor_type({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_processor_type name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_processor_type ::Google::Cloud::DocumentAI::V1beta3::GetProcessorTypeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_processor_type({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_processor_type(::Google::Cloud::DocumentAI::V1beta3::GetProcessorTypeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_processor_type_client_stub.call_count
      end
    end
  end

  def test_list_processors
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::ListProcessorsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_processors_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_list_processors_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_processors_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_processors({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_processors parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_processors ::Google::Cloud::DocumentAI::V1beta3::ListProcessorsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_processors({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_processors(::Google::Cloud::DocumentAI::V1beta3::ListProcessorsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_processors_client_stub.call_count
      end
    end
  end

  def test_get_processor
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::Processor.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_get_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_processor_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_processor({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_processor name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_processor ::Google::Cloud::DocumentAI::V1beta3::GetProcessorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_processor({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_processor(::Google::Cloud::DocumentAI::V1beta3::GetProcessorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_processor_client_stub.call_count
      end
    end
  end

  def test_train_processor_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    custom_document_extraction_options = {}
    parent = "hello world"
    processor_version = {}
    document_schema = {}
    input_data = {}
    base_processor_version = "hello world"

    train_processor_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_train_processor_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, train_processor_version_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.train_processor_version({ custom_document_extraction_options: custom_document_extraction_options, parent: parent, processor_version: processor_version, document_schema: document_schema, input_data: input_data, base_processor_version: base_processor_version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.train_processor_version custom_document_extraction_options: custom_document_extraction_options, parent: parent, processor_version: processor_version, document_schema: document_schema, input_data: input_data, base_processor_version: base_processor_version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.train_processor_version ::Google::Cloud::DocumentAI::V1beta3::TrainProcessorVersionRequest.new(custom_document_extraction_options: custom_document_extraction_options, parent: parent, processor_version: processor_version, document_schema: document_schema, input_data: input_data, base_processor_version: base_processor_version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.train_processor_version({ custom_document_extraction_options: custom_document_extraction_options, parent: parent, processor_version: processor_version, document_schema: document_schema, input_data: input_data, base_processor_version: base_processor_version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.train_processor_version(::Google::Cloud::DocumentAI::V1beta3::TrainProcessorVersionRequest.new(custom_document_extraction_options: custom_document_extraction_options, parent: parent, processor_version: processor_version, document_schema: document_schema, input_data: input_data, base_processor_version: base_processor_version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, train_processor_version_client_stub.call_count
      end
    end
  end

  def test_get_processor_version
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_processor_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_get_processor_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_processor_version_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_processor_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_processor_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_processor_version ::Google::Cloud::DocumentAI::V1beta3::GetProcessorVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_processor_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_processor_version(::Google::Cloud::DocumentAI::V1beta3::GetProcessorVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_processor_version_client_stub.call_count
      end
    end
  end

  def test_list_processor_versions
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::ListProcessorVersionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_processor_versions_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_list_processor_versions_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_processor_versions_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_processor_versions({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_processor_versions parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_processor_versions ::Google::Cloud::DocumentAI::V1beta3::ListProcessorVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_processor_versions({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_processor_versions(::Google::Cloud::DocumentAI::V1beta3::ListProcessorVersionsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_processor_versions_client_stub.call_count
      end
    end
  end

  def test_delete_processor_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_processor_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_delete_processor_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_processor_version_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_processor_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_processor_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_processor_version ::Google::Cloud::DocumentAI::V1beta3::DeleteProcessorVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_processor_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_processor_version(::Google::Cloud::DocumentAI::V1beta3::DeleteProcessorVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_processor_version_client_stub.call_count
      end
    end
  end

  def test_deploy_processor_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    deploy_processor_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_deploy_processor_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, deploy_processor_version_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.deploy_processor_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.deploy_processor_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.deploy_processor_version ::Google::Cloud::DocumentAI::V1beta3::DeployProcessorVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.deploy_processor_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.deploy_processor_version(::Google::Cloud::DocumentAI::V1beta3::DeployProcessorVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, deploy_processor_version_client_stub.call_count
      end
    end
  end

  def test_undeploy_processor_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    undeploy_processor_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_undeploy_processor_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, undeploy_processor_version_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.undeploy_processor_version({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.undeploy_processor_version name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.undeploy_processor_version ::Google::Cloud::DocumentAI::V1beta3::UndeployProcessorVersionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.undeploy_processor_version({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.undeploy_processor_version(::Google::Cloud::DocumentAI::V1beta3::UndeployProcessorVersionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, undeploy_processor_version_client_stub.call_count
      end
    end
  end

  def test_create_processor
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::Processor.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    processor = {}

    create_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_create_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_processor_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_processor({ parent: parent, processor: processor }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_processor parent: parent, processor: processor do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_processor ::Google::Cloud::DocumentAI::V1beta3::CreateProcessorRequest.new(parent: parent, processor: processor) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_processor({ parent: parent, processor: processor }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_processor(::Google::Cloud::DocumentAI::V1beta3::CreateProcessorRequest.new(parent: parent, processor: processor), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_processor_client_stub.call_count
      end
    end
  end

  def test_delete_processor
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_delete_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_processor_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_processor({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_processor name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_processor ::Google::Cloud::DocumentAI::V1beta3::DeleteProcessorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_processor({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_processor(::Google::Cloud::DocumentAI::V1beta3::DeleteProcessorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_processor_client_stub.call_count
      end
    end
  end

  def test_enable_processor
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    enable_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_enable_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_processor_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_processor({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_processor name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_processor ::Google::Cloud::DocumentAI::V1beta3::EnableProcessorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_processor({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_processor(::Google::Cloud::DocumentAI::V1beta3::EnableProcessorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_processor_client_stub.call_count
      end
    end
  end

  def test_disable_processor
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    disable_processor_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_disable_processor_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_processor_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_processor({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_processor name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_processor ::Google::Cloud::DocumentAI::V1beta3::DisableProcessorRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_processor({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_processor(::Google::Cloud::DocumentAI::V1beta3::DisableProcessorRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_processor_client_stub.call_count
      end
    end
  end

  def test_set_default_processor_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    processor = "hello world"
    default_processor_version = "hello world"

    set_default_processor_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_set_default_processor_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, set_default_processor_version_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.set_default_processor_version({ processor: processor, default_processor_version: default_processor_version }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.set_default_processor_version processor: processor, default_processor_version: default_processor_version do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.set_default_processor_version ::Google::Cloud::DocumentAI::V1beta3::SetDefaultProcessorVersionRequest.new(processor: processor, default_processor_version: default_processor_version) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.set_default_processor_version({ processor: processor, default_processor_version: default_processor_version }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.set_default_processor_version(::Google::Cloud::DocumentAI::V1beta3::SetDefaultProcessorVersionRequest.new(processor: processor, default_processor_version: default_processor_version), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, set_default_processor_version_client_stub.call_count
      end
    end
  end

  def test_review_document
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    inline_document = {}
    human_review_config = "hello world"
    document = {}
    enable_schema_validation = true
    priority = :DEFAULT
    document_schema = {}

    review_document_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_review_document_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, review_document_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.review_document({ inline_document: inline_document, human_review_config: human_review_config, document: document, enable_schema_validation: enable_schema_validation, priority: priority, document_schema: document_schema }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.review_document inline_document: inline_document, human_review_config: human_review_config, document: document, enable_schema_validation: enable_schema_validation, priority: priority, document_schema: document_schema do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.review_document ::Google::Cloud::DocumentAI::V1beta3::ReviewDocumentRequest.new(inline_document: inline_document, human_review_config: human_review_config, document: document, enable_schema_validation: enable_schema_validation, priority: priority, document_schema: document_schema) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.review_document({ inline_document: inline_document, human_review_config: human_review_config, document: document, enable_schema_validation: enable_schema_validation, priority: priority, document_schema: document_schema }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.review_document(::Google::Cloud::DocumentAI::V1beta3::ReviewDocumentRequest.new(inline_document: inline_document, human_review_config: human_review_config, document: document, enable_schema_validation: enable_schema_validation, priority: priority, document_schema: document_schema), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, review_document_client_stub.call_count
      end
    end
  end

  def test_evaluate_processor_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    processor_version = "hello world"
    evaluation_documents = {}

    evaluate_processor_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_evaluate_processor_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, evaluate_processor_version_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.evaluate_processor_version({ processor_version: processor_version, evaluation_documents: evaluation_documents }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.evaluate_processor_version processor_version: processor_version, evaluation_documents: evaluation_documents do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.evaluate_processor_version ::Google::Cloud::DocumentAI::V1beta3::EvaluateProcessorVersionRequest.new(processor_version: processor_version, evaluation_documents: evaluation_documents) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.evaluate_processor_version({ processor_version: processor_version, evaluation_documents: evaluation_documents }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.evaluate_processor_version(::Google::Cloud::DocumentAI::V1beta3::EvaluateProcessorVersionRequest.new(processor_version: processor_version, evaluation_documents: evaluation_documents), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, evaluate_processor_version_client_stub.call_count
      end
    end
  end

  def test_get_evaluation
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::Evaluation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_evaluation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_get_evaluation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_evaluation_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_evaluation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_evaluation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_evaluation ::Google::Cloud::DocumentAI::V1beta3::GetEvaluationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_evaluation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_evaluation(::Google::Cloud::DocumentAI::V1beta3::GetEvaluationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_evaluation_client_stub.call_count
      end
    end
  end

  def test_list_evaluations
    # Create test objects.
    client_result = ::Google::Cloud::DocumentAI::V1beta3::ListEvaluationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_evaluations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_list_evaluations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_evaluations_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_evaluations({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_evaluations parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_evaluations ::Google::Cloud::DocumentAI::V1beta3::ListEvaluationsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_evaluations({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_evaluations(::Google::Cloud::DocumentAI::V1beta3::ListEvaluationsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_evaluations_client_stub.call_count
      end
    end
  end

  def test_import_processor_version
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    processor_version_source = "hello world"
    parent = "hello world"

    import_processor_version_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::ServiceStub.stub :transcode_import_processor_version_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, import_processor_version_client_stub do
        # Create client
        client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.import_processor_version({ processor_version_source: processor_version_source, parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.import_processor_version processor_version_source: processor_version_source, parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.import_processor_version ::Google::Cloud::DocumentAI::V1beta3::ImportProcessorVersionRequest.new(processor_version_source: processor_version_source, parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.import_processor_version({ processor_version_source: processor_version_source, parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.import_processor_version(::Google::Cloud::DocumentAI::V1beta3::ImportProcessorVersionRequest.new(processor_version_source: processor_version_source, parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, import_processor_version_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Rest::Client::Configuration, config
  end
end
