# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DocumentAI
      module V1beta3
        # The common metadata for long running operations.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata::State]
        #     The state of the operation.
        # @!attribute [rw] state_message
        #   @return [::String]
        #     A message providing more details about the current state of processing.
        # @!attribute [rw] resource
        #   @return [::String]
        #     A related resource to this operation.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        class CommonOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the longrunning operation.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # Operation is still running.
            RUNNING = 1

            # Operation is being cancelled.
            CANCELLING = 2

            # Operation succeeded.
            SUCCEEDED = 3

            # Operation failed.
            FAILED = 4

            # Operation is cancelled.
            CANCELLED = 5
          end
        end
      end
    end
  end
end
