# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DocumentAI
      module V1beta3
        # Gives a short summary of an evaluation, and links to the evaluation itself.
        # @!attribute [rw] operation
        #   @return [::String]
        #     The resource name of the Long Running Operation for the evaluation.
        # @!attribute [rw] evaluation
        #   @return [::String]
        #     The resource name of the evaluation.
        # @!attribute [rw] aggregate_metrics
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Evaluation::Metrics]
        #     An aggregate of the statistics for the evaluation with fuzzy matching on.
        # @!attribute [rw] aggregate_metrics_exact
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Evaluation::Metrics]
        #     An aggregate of the statistics for the evaluation with fuzzy matching off.
        class EvaluationReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An evaluation of a ProcessorVersion's performance.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the evaluation.
        #     Format:
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}/evaluations/{evaluation}`
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time that the evaluation was created.
        # @!attribute [rw] document_counters
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Evaluation::Counters]
        #     Counters for the documents used in the evaluation.
        # @!attribute [rw] all_entities_metrics
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Evaluation::MultiConfidenceMetrics]
        #     Metrics for all the entities in aggregate.
        # @!attribute [rw] entity_metrics
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::DocumentAI::V1beta3::Evaluation::MultiConfidenceMetrics}]
        #     Metrics across confidence levels, for different entities.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     The KMS key name used for encryption.
        # @!attribute [rw] kms_key_version_name
        #   @return [::String]
        #     The KMS key version with which data is encrypted.
        class Evaluation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Evaluation counters for the documents that were used.
          # @!attribute [rw] input_documents_count
          #   @return [::Integer]
          #     How many documents were sent for evaluation.
          # @!attribute [rw] invalid_documents_count
          #   @return [::Integer]
          #     How many documents were not included in the evaluation as they didn't
          #     pass validation.
          # @!attribute [rw] failed_documents_count
          #   @return [::Integer]
          #     How many documents were not included in the evaluation as Document AI
          #     failed to process them.
          # @!attribute [rw] evaluated_documents_count
          #   @return [::Integer]
          #     How many documents were used in the evaluation.
          class Counters
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Evaluation metrics, either in aggregate or about a specific entity.
          # @!attribute [rw] precision
          #   @return [::Float]
          #     The calculated precision.
          # @!attribute [rw] recall
          #   @return [::Float]
          #     The calculated recall.
          # @!attribute [rw] f1_score
          #   @return [::Float]
          #     The calculated f1 score.
          # @!attribute [rw] predicted_occurrences_count
          #   @return [::Integer]
          #     The amount of occurrences in predicted documents.
          # @!attribute [rw] ground_truth_occurrences_count
          #   @return [::Integer]
          #     The amount of occurrences in ground truth documents.
          # @!attribute [rw] predicted_document_count
          #   @return [::Integer]
          #     The amount of documents with a predicted occurrence.
          # @!attribute [rw] ground_truth_document_count
          #   @return [::Integer]
          #     The amount of documents with a ground truth occurrence.
          # @!attribute [rw] true_positives_count
          #   @return [::Integer]
          #     The amount of true positives.
          # @!attribute [rw] false_positives_count
          #   @return [::Integer]
          #     The amount of false positives.
          # @!attribute [rw] false_negatives_count
          #   @return [::Integer]
          #     The amount of false negatives.
          # @!attribute [rw] total_documents_count
          #   @return [::Integer]
          #     The amount of documents that had an occurrence of this label.
          class Metrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Evaluations metrics, at a specific confidence level.
          # @!attribute [rw] confidence_level
          #   @return [::Float]
          #     The confidence level.
          # @!attribute [rw] metrics
          #   @return [::Google::Cloud::DocumentAI::V1beta3::Evaluation::Metrics]
          #     The metrics at the specific confidence level.
          class ConfidenceLevelMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metrics across multiple confidence levels.
          # @!attribute [rw] confidence_level_metrics
          #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::Evaluation::ConfidenceLevelMetrics>]
          #     Metrics across confidence levels with fuzzy matching enabled.
          # @!attribute [rw] confidence_level_metrics_exact
          #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::Evaluation::ConfidenceLevelMetrics>]
          #     Metrics across confidence levels with only exact matching.
          # @!attribute [rw] auprc
          #   @return [::Float]
          #     The calculated area under the precision recall curve (AUPRC), computed by
          #     integrating over all confidence thresholds.
          # @!attribute [rw] estimated_calibration_error
          #   @return [::Float]
          #     The Estimated Calibration Error (ECE) of the confidence of the predicted
          #     entities.
          # @!attribute [rw] auprc_exact
          #   @return [::Float]
          #     The AUPRC for metrics with fuzzy matching disabled, i.e., exact matching
          #     only.
          # @!attribute [rw] estimated_calibration_error_exact
          #   @return [::Float]
          #     The ECE for the predicted entities with fuzzy matching disabled, i.e.,
          #     exact matching only.
          # @!attribute [rw] metrics_type
          #   @return [::Google::Cloud::DocumentAI::V1beta3::Evaluation::MultiConfidenceMetrics::MetricsType]
          #     The metrics type for the label.
          class MultiConfidenceMetrics
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A type that determines how metrics should be interpreted.
            module MetricsType
              # The metrics type is unspecified. By default, metrics without a
              # particular specification are for leaf entity types (i.e., top-level
              # entity types without child types, or child types which are not
              # parent types themselves).
              METRICS_TYPE_UNSPECIFIED = 0

              # Indicates whether metrics for this particular label type represent an
              # aggregate of metrics for other types instead of being based on actual
              # TP/FP/FN values for the label type. Metrics for parent (i.e., non-leaf)
              # entity types are an aggregate of metrics for their children.
              AGGREGATE = 1
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::DocumentAI::V1beta3::Evaluation::MultiConfidenceMetrics]
          class EntityMetricsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
