# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DocumentAI
      module V1beta3
        # @!attribute [rw] dataset
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Dataset]
        #     Required. The `name` field of the `Dataset` is used to identify the
        #     resource to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The update mask applies to the resource.
        class UpdateDatasetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class UpdateDatasetOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The dataset resource name.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset
        # @!attribute [rw] batch_documents_import_configs
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::ImportDocumentsRequest::BatchDocumentsImportConfig>]
        #     Required. The Cloud Storage uri containing raw documents that must be
        #     imported.
        class ImportDocumentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Config for importing documents.
          # Each batch can have its own dataset split type.
          # @!attribute [rw] dataset_split
          #   @return [::Google::Cloud::DocumentAI::V1beta3::DatasetSplitType]
          #     Target dataset split where the documents must be stored.
          #
          #     Note: The following fields are mutually exclusive: `dataset_split`, `auto_split_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] auto_split_config
          #   @return [::Google::Cloud::DocumentAI::V1beta3::ImportDocumentsRequest::BatchDocumentsImportConfig::AutoSplitConfig]
          #     If set, documents will be automatically split into training and test
          #     split category with the specified ratio.
          #
          #     Note: The following fields are mutually exclusive: `auto_split_config`, `dataset_split`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] batch_input_config
          #   @return [::Google::Cloud::DocumentAI::V1beta3::BatchDocumentsInputConfig]
          #     The common config to specify a set of documents used as input.
          class BatchDocumentsImportConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The config for auto-split.
            # @!attribute [rw] training_split_ratio
            #   @return [::Float]
            #     Ratio of training dataset split.
            class AutoSplitConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Response of the import document operation.
        class ImportDocumentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of the import document operation.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        # @!attribute [rw] individual_import_statuses
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::ImportDocumentsMetadata::IndividualImportStatus>]
        #     The list of response details of each document.
        # @!attribute [rw] import_config_validation_results
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::ImportDocumentsMetadata::ImportConfigValidationResult>]
        #     Validation statuses of the batch documents import config.
        # @!attribute [rw] total_document_count
        #   @return [::Integer]
        #     Total number of the documents that are qualified for importing.
        class ImportDocumentsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of each individual document in the import process.
          # @!attribute [rw] input_gcs_source
          #   @return [::String]
          #     The source Cloud Storage URI of the document.
          # @!attribute [rw] status
          #   @return [::Google::Rpc::Status]
          #     The status of the importing of the document.
          # @!attribute [rw] output_document_id
          #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentId]
          #     The document id of imported document if it was successful, otherwise
          #     empty.
          class IndividualImportStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The validation status of each import config. Status is set to an error if
          # there are no documents to import in the `import_config`, or `OK` if the
          # operation will try to proceed with at least one document.
          # @!attribute [rw] input_gcs_source
          #   @return [::String]
          #     The source Cloud Storage URI specified in the import config.
          # @!attribute [rw] status
          #   @return [::Google::Rpc::Status]
          #     The validation status of import config.
          class ImportConfigValidationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The resource name of the dataset that the document belongs to .
        #     Format:
        #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset
        # @!attribute [rw] document_id
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentId]
        #     Required. Document identifier.
        # @!attribute [rw] read_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     If set, only fields listed here will be returned. Otherwise, all fields
        #     will be returned by default.
        # @!attribute [rw] page_range
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentPageRange]
        #     List of pages for which the fields specified in the `read_mask` must
        #     be served.
        class GetDocumentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] document
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Document]
        class GetDocumentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The resource name of the dataset to be listed.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of documents to return. The service may return
        #     fewer than this value.
        #     If unspecified, at most 20 documents will be returned.
        #     The maximum value is 100; values above 100 will be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDocuments` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other parameters provided to `ListDocuments`
        #     must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Query to filter the documents based on
        #     https://google.aip.dev/160.
        #     ## Currently support query strings are:
        #
        #     `SplitType=DATASET_SPLIT_TEST|DATASET_SPLIT_TRAIN|DATASET_SPLIT_UNASSIGNED`
        #     - `LabelingState=DOCUMENT_LABELED|DOCUMENT_UNLABELED|DOCUMENT_AUTO_LABELED`
        #     - `DisplayName=\"file_name.pdf\"`
        #     - `EntityType=abc/def`
        #     - `TagName=\"auto-labeling-running\"|\"sampled\"`
        #
        #     Note:
        #     - Only `AND`, `=` and `!=` are supported.
        #         e.g. `DisplayName=file_name AND EntityType!=abc` IS supported.
        #     - Wildcard `*` is supported only in `DisplayName` filter
        #     - No duplicate filter keys are allowed,
        #         e.g. `EntityType=a AND EntityType=b` is NOT supported.
        #     - String match is case sensitive (for filter `DisplayName` & `EntityType`).
        # @!attribute [rw] return_total_size
        #   @return [::Boolean]
        #     Optional. Controls if the request requires a total size of matched
        #     documents. See
        #     {::Google::Cloud::DocumentAI::V1beta3::ListDocumentsResponse#total_size ListDocumentsResponse.total_size}.
        #
        #     Enabling this flag may adversely impact performance.
        #
        #     Defaults to false.
        # @!attribute [rw] skip
        #   @return [::Integer]
        #     Optional. Number of results to skip beginning from the `page_token` if
        #     provided. https://google.aip.dev/158#skipping-results. It must be a
        #     non-negative integer. Negative values will be rejected. Note that this is
        #     not the number of pages to skip. If this value causes the cursor to move
        #     past the end of results,
        #     {::Google::Cloud::DocumentAI::V1beta3::ListDocumentsResponse#document_metadata ListDocumentsResponse.document_metadata}
        #     and
        #     {::Google::Cloud::DocumentAI::V1beta3::ListDocumentsResponse#next_page_token ListDocumentsResponse.next_page_token}
        #     will be empty.
        class ListDocumentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] document_metadata
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::DocumentMetadata>]
        #     Document metadata corresponding to the listed documents.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as
        #     {::Google::Cloud::DocumentAI::V1beta3::ListDocumentsRequest#page_token ListDocumentsRequest.page_token}
        #     to retrieve the next page. If this field is omitted, there are no
        #     subsequent pages.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     Total count of documents queried.
        class ListDocumentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] dataset
        #   @return [::String]
        #     Required. The dataset resource name.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset
        # @!attribute [rw] dataset_documents
        #   @return [::Google::Cloud::DocumentAI::V1beta3::BatchDatasetDocuments]
        #     Required. Dataset documents input. If given `filter`, all documents
        #     satisfying the filter will be deleted. If given documentIds, a maximum of
        #     50 documents can be deleted in a batch. The request will be rejected if
        #     more than 50 document_ids are provided.
        class BatchDeleteDocumentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of the delete documents operation.
        class BatchDeleteDocumentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        # @!attribute [rw] individual_batch_delete_statuses
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::BatchDeleteDocumentsMetadata::IndividualBatchDeleteStatus>]
        #     The list of response details of each document.
        # @!attribute [rw] total_document_count
        #   @return [::Integer]
        #     Total number of documents deleting from dataset.
        # @!attribute [rw] error_document_count
        #   @return [::Integer]
        #     Total number of documents that failed to be deleted in storage.
        class BatchDeleteDocumentsMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of each individual document in the batch delete process.
          # @!attribute [rw] document_id
          #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentId]
          #     The document id of the document.
          # @!attribute [rw] status
          #   @return [::Google::Rpc::Status]
          #     The status of deleting the document in storage.
          class IndividualBatchDeleteStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request for `GetDatasetSchema`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The dataset schema resource name.
        #     Format:
        #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset/datasetSchema
        # @!attribute [rw] visible_fields_only
        #   @return [::Boolean]
        #     If set, only returns the visible fields of the schema.
        class GetDatasetSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for `UpdateDatasetSchema`.
        # @!attribute [rw] dataset_schema
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DatasetSchema]
        #     Required. The name field of the `DatasetSchema` is used to identify the
        #     resource to be updated.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The update mask applies to the resource.
        class UpdateDatasetSchemaRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Range of pages present in a document.
        # @!attribute [rw] start
        #   @return [::Integer]
        #     First page number (one-based index) to be returned.
        # @!attribute [rw] end
        #   @return [::Integer]
        #     Last page number (one-based index) to be returned.
        class DocumentPageRange
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about a document.
        # @!attribute [rw] document_id
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentId]
        #     Document identifier.
        # @!attribute [rw] page_count
        #   @return [::Integer]
        #     Number of pages in the document.
        # @!attribute [rw] dataset_type
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DatasetSplitType]
        #     Type of the dataset split to which the document belongs.
        # @!attribute [rw] labeling_state
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentLabelingState]
        #     Labeling state of the document.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the document.
        class DocumentMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Documents belonging to a dataset will be split into different groups
        # referred to as splits: train, test.
        module DatasetSplitType
          # Default value if the enum is not set.
          DATASET_SPLIT_TYPE_UNSPECIFIED = 0

          # Identifies the train documents.
          DATASET_SPLIT_TRAIN = 1

          # Identifies the test documents.
          DATASET_SPLIT_TEST = 2

          # Identifies the unassigned documents.
          DATASET_SPLIT_UNASSIGNED = 3
        end

        # Describes the labeling status of a document.
        module DocumentLabelingState
          # Default value if the enum is not set.
          DOCUMENT_LABELING_STATE_UNSPECIFIED = 0

          # Document has been labeled.
          DOCUMENT_LABELED = 1

          # Document has not been labeled.
          DOCUMENT_UNLABELED = 2

          # Document has been auto-labeled.
          DOCUMENT_AUTO_LABELED = 3
        end
      end
    end
  end
end
