# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DocumentAI
      module V1beta3
        # Metadata for document summarization.
        # @!attribute [rw] length
        #   @return [::Google::Cloud::DocumentAI::V1beta3::SummaryOptions::Length]
        #     How long the summary should be.
        # @!attribute [rw] format
        #   @return [::Google::Cloud::DocumentAI::V1beta3::SummaryOptions::Format]
        #     The format the summary should be in.
        class SummaryOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The Length enum.
          module Length
            # Default.
            LENGTH_UNSPECIFIED = 0

            # A brief summary of one or two sentences.
            BRIEF = 1

            # A paragraph-length summary.
            MODERATE = 2

            # The longest option available.
            COMPREHENSIVE = 3
          end

          # The Format enum.
          module Format
            # Default.
            FORMAT_UNSPECIFIED = 0

            # Format the output in paragraphs.
            PARAGRAPH = 1

            # Format the output in bullets.
            BULLETS = 2
          end
        end

        # Metadata for how this field value is extracted.
        # @!attribute [rw] summary_options
        #   @return [::Google::Cloud::DocumentAI::V1beta3::SummaryOptions]
        #     Summary options config.
        class FieldExtractionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about a property.
        # @!attribute [rw] inactive
        #   @return [::Boolean]
        #     Whether the property should be considered as "inactive".
        # @!attribute [rw] field_extraction_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::FieldExtractionMetadata]
        #     Field extraction metadata on the property.
        class PropertyMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata about an entity type.
        # @!attribute [rw] inactive
        #   @return [::Boolean]
        #     Whether the entity type should be considered inactive.
        class EntityTypeMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The schema defines the output of the processed document by a processor.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name to show to users.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the schema.
        # @!attribute [rw] entity_types
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::DocumentSchema::EntityType>]
        #     Entity types of the schema.
        # @!attribute [rw] metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentSchema::Metadata]
        #     Metadata of the schema.
        class DocumentSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # EntityType is the wrapper of a label of the corresponding model with
          # detailed attributes and limitations for entity-based processors. Multiple
          # types can also compose a dependency tree to represent nested types.
          # @!attribute [rw] enum_values
          #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentSchema::EntityType::EnumValues]
          #     If specified, lists all the possible values for this entity.  This
          #     should not be more than a handful of values.  If the number of values
          #     is >10 or could change frequently use the `EntityType.value_ontology`
          #     field and specify a list of all possible values in a value ontology
          #     file.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     User defined name for the type.
          # @!attribute [rw] name
          #   @return [::String]
          #     Name of the type. It must be unique within the schema file and
          #     cannot be a "Common Type".  The following naming conventions are used:
          #
          #     - Use `snake_casing`.
          #     - Name matching is case-sensitive.
          #     - Maximum 64 characters.
          #     - Must start with a letter.
          #     - Allowed characters: ASCII letters `[a-z0-9_-]`.  (For backward
          #       compatibility internal infrastructure and tooling can handle any ascii
          #       character.)
          #     - The `/` is sometimes used to denote a property of a type.  For example
          #       `line_item/amount`.  This convention is deprecated, but will still be
          #       honored for backward compatibility.
          # @!attribute [rw] description
          #   @return [::String]
          #     The description of the entity type. Could be used to provide more
          #     information about the entity type for model calls.
          # @!attribute [rw] base_types
          #   @return [::Array<::String>]
          #     The entity type that this type is derived from.  For now, one and only
          #     one should be set.
          # @!attribute [rw] properties
          #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::DocumentSchema::EntityType::Property>]
          #     Description the nested structure, or composition of an entity.
          # @!attribute [rw] entity_type_metadata
          #   @return [::Google::Cloud::DocumentAI::V1beta3::EntityTypeMetadata]
          #     Metadata for the entity type.
          class EntityType
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Defines the a list of enum values.
            # @!attribute [rw] values
            #   @return [::Array<::String>]
            #     The individual values that this enum values type can include.
            class EnumValues
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Defines properties that can be part of the entity type.
            # @!attribute [rw] name
            #   @return [::String]
            #     The name of the property.  Follows the same guidelines as the
            #     EntityType name.
            # @!attribute [rw] description
            #   @return [::String]
            #     The description of the property. Could be used to provide more
            #     information about the property for model calls.
            # @!attribute [rw] display_name
            #   @return [::String]
            #     User defined name for the property.
            # @!attribute [rw] value_type
            #   @return [::String]
            #     A reference to the value type of the property.  This type is subject
            #     to the same conventions as the `Entity.base_types` field.
            # @!attribute [rw] occurrence_type
            #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentSchema::EntityType::Property::OccurrenceType]
            #     Occurrence type limits the number of instances an entity type appears
            #     in the document.
            # @!attribute [rw] method
            #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentSchema::EntityType::Property::Method]
            #     Specifies how the entity's value is obtained.
            # @!attribute [rw] property_metadata
            #   @return [::Google::Cloud::DocumentAI::V1beta3::PropertyMetadata]
            #     Any additional metadata about the property can be added here.
            class Property
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Types of occurrences of the entity type in the document.  This
              # represents the number of instances, not mentions, of an entity.
              # For example, a bank statement might only have one
              # `account_number`, but this account number can be mentioned in several
              # places on the document.  In this case, the `account_number` is
              # considered a `REQUIRED_ONCE` entity type. If, on the other hand, we
              # expect a bank statement to contain the status of multiple different
              # accounts for the customers, the occurrence type is set to
              # `REQUIRED_MULTIPLE`.
              module OccurrenceType
                # Unspecified occurrence type.
                OCCURRENCE_TYPE_UNSPECIFIED = 0

                # There will be zero or one instance of this entity type.  The same
                # entity instance may be mentioned multiple times.
                OPTIONAL_ONCE = 1

                # The entity type will appear zero or multiple times.
                OPTIONAL_MULTIPLE = 2

                # The entity type will only appear exactly once.  The same
                # entity instance may be mentioned multiple times.
                REQUIRED_ONCE = 3

                # The entity type will appear once or more times.
                REQUIRED_MULTIPLE = 4
              end

              # Specifies how the entity's value is obtained from the document.
              module Method
                # Unspecified method. It defaults to `EXTRACT`.
                METHOD_UNSPECIFIED = 0

                # The entity's value is directly extracted as-is from the document
                # text.
                EXTRACT = 1

                # The entity's value is derived through inference and is not
                # necessarily an exact text extraction from the document.
                DERIVE = 2
              end
            end
          end

          # Metadata for global schema behavior.
          # @!attribute [rw] document_splitter
          #   @return [::Boolean]
          #     If true, a `document` entity type can be applied to subdocument
          #     (splitting). Otherwise, it can only be applied to the entire document
          #     (classification).
          # @!attribute [rw] document_allow_multiple_labels
          #   @return [::Boolean]
          #     If true, on a given page, there can be multiple `document` annotations
          #     covering it.
          # @!attribute [rw] prefixed_naming_on_properties
          #   @return [::Boolean]
          #     If set, all the nested entities must be prefixed with the parents.
          # @!attribute [rw] skip_naming_validation
          #   @return [::Boolean]
          #     If set, we will skip the naming format validation in the schema. So the
          #     string values in `DocumentSchema.EntityType.name` and
          #     `DocumentSchema.EntityType.Property.name` will not be checked.
          class Metadata
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
