# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DocumentAI
      module V1beta3
        # Options for Process API
        # @!attribute [rw] individual_page_selector
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ProcessOptions::IndividualPageSelector]
        #     Which pages to process (1-indexed).
        #
        #     Note: The following fields are mutually exclusive: `individual_page_selector`, `from_start`, `from_end`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] from_start
        #   @return [::Integer]
        #     Only process certain pages from the start. Process all if the document
        #     has fewer pages.
        #
        #     Note: The following fields are mutually exclusive: `from_start`, `individual_page_selector`, `from_end`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] from_end
        #   @return [::Integer]
        #     Only process certain pages from the end, same as above.
        #
        #     Note: The following fields are mutually exclusive: `from_end`, `individual_page_selector`, `from_start`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] ocr_config
        #   @return [::Google::Cloud::DocumentAI::V1beta3::OcrConfig]
        #     Only applicable to `OCR_PROCESSOR` and `FORM_PARSER_PROCESSOR`.
        #     Returns error if set on other processor types.
        # @!attribute [rw] layout_config
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ProcessOptions::LayoutConfig]
        #     Optional. Only applicable to `LAYOUT_PARSER_PROCESSOR`.
        #     Returns error if set on other processor types.
        # @!attribute [rw] schema_override
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentSchema]
        #     Optional. Override the schema of the
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion}. Will
        #     return an Invalid Argument error if this field is set when the underlying
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion}
        #     doesn't support schema override.
        class ProcessOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Serving config for layout parser processor.
          # @!attribute [rw] chunking_config
          #   @return [::Google::Cloud::DocumentAI::V1beta3::ProcessOptions::LayoutConfig::ChunkingConfig]
          #     Optional. Config for chunking in layout parser processor.
          # @!attribute [rw] return_images
          #   @return [::Boolean]
          #     Optional. Whether to include images in layout parser processor response.
          # @!attribute [rw] return_bounding_boxes
          #   @return [::Boolean]
          #     Optional. Whether to include bounding boxes in layout parser processor
          #     response.
          # @!attribute [rw] enable_image_annotation
          #   @return [::Boolean]
          #     Optional. Whether to include image annotations in layout parser response.
          # @!attribute [rw] enable_image_extraction
          #   @return [::Boolean]
          #     Optional. Whether to extract images in layout parser response.
          # @!attribute [rw] enable_llm_layout_parsing
          #   @return [::Boolean]
          #     Optional. Whether to refine PDF layout using LLM.
          # @!attribute [rw] enable_table_annotation
          #   @return [::Boolean]
          #     Optional. Whether to include table annotations in layout parser response.
          class LayoutConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Serving config for chunking.
            # @!attribute [rw] chunk_size
            #   @return [::Integer]
            #     Optional. The chunk sizes to use when splitting documents, in order of
            #     level.
            # @!attribute [rw] include_ancestor_headings
            #   @return [::Boolean]
            #     Optional. Whether or not to include ancestor headings when splitting.
            # @!attribute [rw] semantic_chunking_group_size
            #   @return [::Boolean]
            #     Optional. The number of tokens to group together when evaluating
            #     semantic similarity. THIS FIELD IS NOT YET USED.
            # @!attribute [rw] breakpoint_percentile_threshold
            #   @return [::Integer]
            #     Optional. The percentile of cosine dissimilarity that must be exceeded
            #     between a group of tokens and the next. The smaller this number is, the
            #     more chunks will be generated. THIS FIELD IS NOT YET USED.
            class ChunkingConfig
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # A list of individual page numbers.
          # @!attribute [rw] pages
          #   @return [::Array<::Integer>]
          #     Optional. Indices of the pages (starting from 1).
          class IndividualPageSelector
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#process_document ProcessDocument}
        # method.
        # @!attribute [rw] inline_document
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Document]
        #     An inline document proto.
        #
        #     Note: The following fields are mutually exclusive: `inline_document`, `raw_document`, `gcs_document`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] raw_document
        #   @return [::Google::Cloud::DocumentAI::V1beta3::RawDocument]
        #     A raw document content (bytes).
        #
        #     Note: The following fields are mutually exclusive: `raw_document`, `inline_document`, `gcs_document`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_document
        #   @return [::Google::Cloud::DocumentAI::V1beta3::GcsDocument]
        #     A raw document on Google Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `gcs_document`, `inline_document`, `raw_document`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::DocumentAI::V1beta3::Processor Processor} or
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion}
        #     to use for processing. If a
        #     {::Google::Cloud::DocumentAI::V1beta3::Processor Processor} is specified, the
        #     server will use its [default
        #     version][google.cloud.documentai.v1beta3.Processor.default_processor_version].
        #     Format: `projects/{project}/locations/{location}/processors/{processor}`,
        #     or
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
        # @!attribute [rw] document
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Document]
        #     The document payload, the
        #     {::Google::Cloud::DocumentAI::V1beta3::Document#content content} and
        #     {::Google::Cloud::DocumentAI::V1beta3::Document#mime_type mime_type} fields must
        #     be set.
        # @!attribute [rw] skip_human_review
        #   @return [::Boolean]
        #     Whether human review should be skipped for this request. Default to
        #     `false`.
        # @!attribute [rw] field_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Specifies which fields to include in the
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessResponse#document ProcessResponse.document}
        #     output. Only supports top-level document and pages field, so it must be in
        #     the form of `{document_field_name}` or `pages.{page_field_name}`.
        # @!attribute [rw] process_options
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ProcessOptions]
        #     Inference-time options for the process API
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels with user-defined metadata for the request.
        #
        #     Label keys and values can be no longer than 63 characters
        #     (Unicode codepoints) and can only contain lowercase letters, numeric
        #     characters, underscores, and dashes. International characters are allowed.
        #     Label values are optional. Label keys must start with a letter.
        # @!attribute [rw] imageless_mode
        #   @return [::Boolean]
        #     Optional. Option to remove images from the document.
        class ProcessRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The status of human review on a processed document.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DocumentAI::V1beta3::HumanReviewStatus::State]
        #     The state of human review on the processing request.
        # @!attribute [rw] state_message
        #   @return [::String]
        #     A message providing more details about the human review state.
        # @!attribute [rw] human_review_operation
        #   @return [::String]
        #     The name of the operation triggered by the processed document. This field
        #     is populated only when the
        #     {::Google::Cloud::DocumentAI::V1beta3::HumanReviewStatus#state state} is
        #     `HUMAN_REVIEW_IN_PROGRESS`. It has the same response type and metadata as
        #     the long-running operation returned by
        #     {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#review_document ReviewDocument}.
        class HumanReviewStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The final state of human review on a processed document.
          module State
            # Human review state is unspecified. Most likely due to an internal error.
            STATE_UNSPECIFIED = 0

            # Human review is skipped for the document. This can happen because human
            # review isn't enabled on the processor or the processing request has
            # been set to skip this document.
            SKIPPED = 1

            # Human review validation is triggered and passed, so no review is needed.
            VALIDATION_PASSED = 2

            # Human review validation is triggered and the document is under review.
            IN_PROGRESS = 3

            # Some error happened during triggering human review, see the
            # {::Google::Cloud::DocumentAI::V1beta3::HumanReviewStatus#state_message state_message}
            # for details.
            ERROR = 4
          end
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#process_document ProcessDocument}
        # method.
        # @!attribute [rw] document
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Document]
        #     The document payload, will populate fields based on the processor's
        #     behavior.
        # @!attribute [rw] human_review_operation
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     The name of the operation triggered by the processed document. If the human
        #     review process isn't triggered, this field is empty. It has the same
        #     response type and metadata as the long-running operation returned by
        #     {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#review_document ReviewDocument}.
        # @!attribute [rw] human_review_status
        #   @return [::Google::Cloud::DocumentAI::V1beta3::HumanReviewStatus]
        #     The status of human review on the processed document.
        class ProcessResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of
        #     {::Google::Cloud::DocumentAI::V1beta3::Processor Processor} or
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion}.
        #     Format: `projects/{project}/locations/{location}/processors/{processor}`,
        #     or
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
        # @!attribute [rw] input_configs
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::BatchProcessRequest::BatchInputConfig>]
        #     The input config for each single document in the batch process.
        # @!attribute [rw] output_config
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::DocumentAI::V1beta3::BatchProcessRequest::BatchOutputConfig]
        #     The overall output config for batch process.
        # @!attribute [rw] input_documents
        #   @return [::Google::Cloud::DocumentAI::V1beta3::BatchDocumentsInputConfig]
        #     The input documents for the
        #     {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}
        #     method.
        # @!attribute [rw] document_output_config
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentOutputConfig]
        #     The output configuration for the
        #     {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}
        #     method.
        # @!attribute [rw] skip_human_review
        #   @return [::Boolean]
        #     Whether human review should be skipped for this request. Default to
        #     `false`.
        # @!attribute [rw] process_options
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ProcessOptions]
        #     Inference-time options for the process API
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels with user-defined metadata for the request.
        #
        #     Label keys and values can be no longer than 63 characters
        #     (Unicode codepoints) and can only contain lowercase letters, numeric
        #     characters, underscores, and dashes. International characters are allowed.
        #     Label values are optional. Label keys must start with a letter.
        class BatchProcessRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The message for input config in batch process.
          # @deprecated This message is deprecated and may be removed in the next major version update.
          # @!attribute [rw] gcs_source
          #   @return [::String]
          #     The Cloud Storage location as the source of the document.
          # @!attribute [rw] mime_type
          #   @return [::String]
          #     An IANA published [media type (MIME
          #     type)](https://www.iana.org/assignments/media-types/media-types.xhtml) of
          #     the input. If the input is a raw document, refer to [supported file
          #     types](https://cloud.google.com/document-ai/docs/file-types) for the list
          #     of media types. If the input is a
          #     {::Google::Cloud::DocumentAI::V1beta3::Document Document}, the type should be
          #     `application/json`.
          class BatchInputConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The output configuration in the
          # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}
          # method.
          # @deprecated This message is deprecated and may be removed in the next major version update.
          # @!attribute [rw] gcs_destination
          #   @return [::String]
          #     The output Cloud Storage directory to put the processed documents.
          class BatchOutputConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Response message for
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}.
        class BatchProcessResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DocumentAI::V1beta3::BatchProcessMetadata::State]
        #     The state of the current batch processing.
        # @!attribute [rw] state_message
        #   @return [::String]
        #     A message providing more details about the current state of processing.
        #     For example, the error message if the operation is failed.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        # @!attribute [rw] individual_process_statuses
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::BatchProcessMetadata::IndividualProcessStatus>]
        #     The list of response details of each document.
        class BatchProcessMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The status of a each individual document in the batch process.
          # @!attribute [rw] input_gcs_source
          #   @return [::String]
          #     The source of the document, same as the
          #     {::Google::Cloud::DocumentAI::V1beta3::BatchProcessMetadata::IndividualProcessStatus#input_gcs_source input_gcs_source}
          #     field in the request when the batch process started.
          # @!attribute [rw] status
          #   @return [::Google::Rpc::Status]
          #     The status processing the document.
          # @!attribute [rw] output_gcs_destination
          #   @return [::String]
          #     The Cloud Storage output destination (in the request as
          #     {::Google::Cloud::DocumentAI::V1beta3::DocumentOutputConfig::GcsOutputConfig#gcs_uri DocumentOutputConfig.GcsOutputConfig.gcs_uri})
          #     of the processed document if it was successful, otherwise empty.
          # @!attribute [rw] human_review_operation
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::String]
          #     The name of the operation triggered by the processed document. If the
          #     human review process isn't triggered, this field will be empty. It has
          #     the same response type and metadata as the long-running operation
          #     returned by the
          #     {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#review_document ReviewDocument}
          #     method.
          # @!attribute [rw] human_review_status
          #   @return [::Google::Cloud::DocumentAI::V1beta3::HumanReviewStatus]
          #     The status of human review on the processed document.
          class IndividualProcessStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states of the batch processing operation.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # Request operation is waiting for scheduling.
            WAITING = 1

            # Request is being processed.
            RUNNING = 2

            # The batch processing completed successfully.
            SUCCEEDED = 3

            # The batch processing was being cancelled.
            CANCELLING = 4

            # The batch processing was cancelled.
            CANCELLED = 5

            # The batch processing has failed.
            FAILED = 6
          end
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#fetch_processor_types FetchProcessorTypes}
        # method. Some processor types may require the project be added to an
        # allowlist.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location of processor types to list.
        #     Format: `projects/{project}/locations/{location}`.
        class FetchProcessorTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#fetch_processor_types FetchProcessorTypes}
        # method.
        # @!attribute [rw] processor_types
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::ProcessorType>]
        #     The list of processor types.
        class FetchProcessorTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#list_processor_types ListProcessorTypes}
        # method. Some processor types may require the project be added to an
        # allowlist.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location of processor types to list.
        #     Format: `projects/{project}/locations/{location}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of processor types to return.
        #     If unspecified, at most `100` processor types will be returned.
        #     The maximum value is `500`. Values above `500` will be coerced to `500`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Used to retrieve the next page of results, empty if at the end of the list.
        class ListProcessorTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#list_processor_types ListProcessorTypes}
        # method.
        # @!attribute [rw] processor_types
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::ProcessorType>]
        #     The processor types.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Points to the next page, otherwise empty.
        class ListProcessorTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for list all processors belongs to a project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent (project and location) which owns this collection of
        #     Processors. Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of processors to return.
        #     If unspecified, at most `50` processors will be returned.
        #     The maximum value is `100`. Values above `100` will be coerced to `100`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     We will return the processors sorted by creation time. The page token
        #     will point to the next processor.
        class ListProcessorsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#list_processors ListProcessors}
        # method.
        # @!attribute [rw] processors
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::Processor>]
        #     The list of processors.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Points to the next processor, otherwise empty.
        class ListProcessorsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#get_processor_type GetProcessorType}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor type resource name.
        class GetProcessorTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#get_processor GetProcessor}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor resource name.
        class GetProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#get_processor_version GetProcessorVersion}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor resource name.
        class GetProcessorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for list all processor versions belongs to a processor.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent (project, location and processor) to list all
        #     versions. Format:
        #     `projects/{project}/locations/{location}/processors/{processor}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of processor versions to return.
        #     If unspecified, at most `10` processor versions will be returned.
        #     The maximum value is `20`. Values above `20` will be coerced to `20`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     We will return the processor versions sorted by creation time. The page
        #     token will point to the next processor version.
        class ListProcessorVersionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#list_processor_versions ListProcessorVersions}
        # method.
        # @!attribute [rw] processor_versions
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion>]
        #     The list of processors.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Points to the next processor, otherwise empty.
        class ListProcessorVersionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#delete_processor_version DeleteProcessorVersion}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor version resource name to be deleted.
        class DeleteProcessorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#delete_processor_version DeleteProcessorVersion}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class DeleteProcessorVersionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#deploy_processor_version DeployProcessorVersion}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor version resource name to be deployed.
        class DeployProcessorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#deploy_processor_version DeployProcessorVersion}
        # method.
        class DeployProcessorVersionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#deploy_processor_version DeployProcessorVersion}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class DeployProcessorVersionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#undeploy_processor_version UndeployProcessorVersion}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor version resource name to be undeployed.
        class UndeployProcessorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#undeploy_processor_version UndeployProcessorVersion}
        # method.
        class UndeployProcessorVersionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#undeploy_processor_version UndeployProcessorVersion}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class UndeployProcessorVersionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#create_processor CreateProcessor}
        # method. Notice this request is sent to a regionalized backend service. If the
        # {::Google::Cloud::DocumentAI::V1beta3::ProcessorType ProcessorType} isn't
        # available in that region, the creation fails.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent (project and location) under which to create the
        #     processor. Format: `projects/{project}/locations/{location}`
        # @!attribute [rw] processor
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Processor]
        #     Required. The processor to be created, requires
        #     {::Google::Cloud::DocumentAI::V1beta3::Processor#type Processor.type} and
        #     {::Google::Cloud::DocumentAI::V1beta3::Processor#display_name Processor.display_name}
        #     to be set. Also, the
        #     {::Google::Cloud::DocumentAI::V1beta3::Processor#kms_key_name Processor.kms_key_name}
        #     field must be set if the processor is under CMEK.
        class CreateProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#delete_processor DeleteProcessor}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor resource name to be deleted.
        class DeleteProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#delete_processor DeleteProcessor}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class DeleteProcessorMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#enable_processor EnableProcessor}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor resource name to be enabled.
        class EnableProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#enable_processor EnableProcessor}
        # method. Intentionally empty proto for adding fields in future.
        class EnableProcessorResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#enable_processor EnableProcessor}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class EnableProcessorMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#disable_processor DisableProcessor}
        # method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The processor resource name to be disabled.
        class DisableProcessorRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#disable_processor DisableProcessor}
        # method. Intentionally empty proto for adding fields in future.
        class DisableProcessorResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#disable_processor DisableProcessor}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class DisableProcessorMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#set_default_processor_version SetDefaultProcessorVersion}
        # method.
        # @!attribute [rw] processor
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::DocumentAI::V1beta3::Processor Processor} to change default
        #     version.
        # @!attribute [rw] default_processor_version
        #   @return [::String]
        #     Required. The resource name of child
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion} to use
        #     as default. Format:
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{version}`
        class SetDefaultProcessorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#set_default_processor_version SetDefaultProcessorVersion}
        # method.
        class SetDefaultProcessorVersionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#set_default_processor_version SetDefaultProcessorVersion}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class SetDefaultProcessorVersionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#train_processor_version TrainProcessorVersion}
        # method.
        # @!attribute [rw] custom_document_extraction_options
        #   @return [::Google::Cloud::DocumentAI::V1beta3::TrainProcessorVersionRequest::CustomDocumentExtractionOptions]
        #     Options to control Custom Document Extraction (CDE) Processor.
        #
        #     Note: The following fields are mutually exclusive: `custom_document_extraction_options`, `foundation_model_tuning_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] foundation_model_tuning_options
        #   @return [::Google::Cloud::DocumentAI::V1beta3::TrainProcessorVersionRequest::FoundationModelTuningOptions]
        #     Options to control foundation model tuning of a processor.
        #
        #     Note: The following fields are mutually exclusive: `foundation_model_tuning_options`, `custom_document_extraction_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent (project, location and processor) to create the new
        #     version for. Format:
        #     `projects/{project}/locations/{location}/processors/{processor}`.
        # @!attribute [rw] processor_version
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion]
        #     Required. The processor version to be created.
        # @!attribute [rw] document_schema
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentSchema]
        #     Optional. The schema the processor version will be trained with.
        # @!attribute [rw] input_data
        #   @return [::Google::Cloud::DocumentAI::V1beta3::TrainProcessorVersionRequest::InputData]
        #     Optional. The input data used to train the
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion}.
        # @!attribute [rw] base_processor_version
        #   @return [::String]
        #     Optional. The processor version to use as a base for training. This
        #     processor version must be a child of `parent`. Format:
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
        class TrainProcessorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The input data used to train a new
          # {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion}.
          # @!attribute [rw] training_documents
          #   @return [::Google::Cloud::DocumentAI::V1beta3::BatchDocumentsInputConfig]
          #     The documents used for training the new version.
          # @!attribute [rw] test_documents
          #   @return [::Google::Cloud::DocumentAI::V1beta3::BatchDocumentsInputConfig]
          #     The documents used for testing the trained version.
          class InputData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Options to control the training of the Custom Document Extraction (CDE)
          # Processor.
          # @!attribute [rw] training_method
          #   @return [::Google::Cloud::DocumentAI::V1beta3::TrainProcessorVersionRequest::CustomDocumentExtractionOptions::TrainingMethod]
          #     Optional. Training method to use for CDE training.
          class CustomDocumentExtractionOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Training Method for CDE. `TRAINING_METHOD_UNSPECIFIED` will fall back to
            # `MODEL_BASED`.
            module TrainingMethod
              TRAINING_METHOD_UNSPECIFIED = 0

              MODEL_BASED = 1

              TEMPLATE_BASED = 2
            end
          end

          # Options to control foundation model tuning of the processor.
          # @!attribute [rw] train_steps
          #   @return [::Integer]
          #     Optional. The number of steps to run for model tuning. Valid values are
          #     between 1 and 400. If not provided, recommended steps will be used.
          # @!attribute [rw] learning_rate_multiplier
          #   @return [::Float]
          #     Optional. The multiplier to apply to the recommended learning rate. Valid
          #     values are between 0.1 and 10. If not provided, recommended learning rate
          #     will be used.
          class FoundationModelTuningOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response for
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#train_processor_version TrainProcessorVersion}.
        # @!attribute [rw] processor_version
        #   @return [::String]
        #     The resource name of the processor version produced by training.
        class TrainProcessorVersionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The metadata that represents a processor version being created.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        # @!attribute [rw] training_dataset_validation
        #   @return [::Google::Cloud::DocumentAI::V1beta3::TrainProcessorVersionMetadata::DatasetValidation]
        #     The training dataset validation information.
        # @!attribute [rw] test_dataset_validation
        #   @return [::Google::Cloud::DocumentAI::V1beta3::TrainProcessorVersionMetadata::DatasetValidation]
        #     The test dataset validation information.
        class TrainProcessorVersionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The dataset validation information.
          # This includes any and all errors with documents and the dataset.
          # @!attribute [rw] document_error_count
          #   @return [::Integer]
          #     The total number of document errors.
          # @!attribute [rw] dataset_error_count
          #   @return [::Integer]
          #     The total number of dataset errors.
          # @!attribute [rw] document_errors
          #   @return [::Array<::Google::Rpc::Status>]
          #     Error information pertaining to specific documents. A maximum of 10
          #     document errors will be returned.
          #     Any document with errors will not be used throughout training.
          # @!attribute [rw] dataset_errors
          #   @return [::Array<::Google::Rpc::Status>]
          #     Error information for the dataset as a whole. A maximum of 10 dataset
          #     errors will be returned.
          #     A single dataset error is terminal for training.
          class DatasetValidation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#review_document ReviewDocument}
        # method.
        # @!attribute [rw] inline_document
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Document]
        #     An inline document proto.
        # @!attribute [rw] human_review_config
        #   @return [::String]
        #     Required. The resource name of the
        #     [HumanReviewConfig][google.cloud.documentai.v1beta3.HumanReviewConfig] that
        #     the document will be reviewed with.
        # @!attribute [rw] document
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::DocumentAI::V1beta3::Document]
        #     The document that needs human review.
        # @!attribute [rw] enable_schema_validation
        #   @return [::Boolean]
        #     Whether the validation should be performed on the ad-hoc review request.
        # @!attribute [rw] priority
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ReviewDocumentRequest::Priority]
        #     The priority of the human review task.
        # @!attribute [rw] document_schema
        #   @return [::Google::Cloud::DocumentAI::V1beta3::DocumentSchema]
        #     The document schema of the human review task.
        class ReviewDocumentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The priority level of the human review task.
          module Priority
            # The default priority level.
            DEFAULT = 0

            # The urgent priority level. The labeling manager should allocate labeler
            # resource to the urgent task queue to respect this priority level.
            URGENT = 1
          end
        end

        # Response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#review_document ReviewDocument}
        # method.
        # @!attribute [rw] gcs_destination
        #   @return [::String]
        #     The Cloud Storage uri for the human reviewed document if the review is
        #     succeeded.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ReviewDocumentResponse::State]
        #     The state of the review operation.
        # @!attribute [rw] rejection_reason
        #   @return [::String]
        #     The reason why the review is rejected by reviewer.
        class ReviewDocumentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of the review operation.
          module State
            # The default value. This value is used if the state is omitted.
            STATE_UNSPECIFIED = 0

            # The review operation is rejected by the reviewer.
            REJECTED = 1

            # The review operation is succeeded.
            SUCCEEDED = 2
          end
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#review_document ReviewDocument}
        # method.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ReviewDocumentOperationMetadata::State]
        #     Used only when Operation.done is false.
        # @!attribute [rw] state_message
        #   @return [::String]
        #     A message providing more details about the current state of processing.
        #     For example, the error message if the operation is failed.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The creation time of the operation.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The last update time of the operation.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        # @!attribute [rw] question_id
        #   @return [::String]
        #     The Crowd Compute question ID.
        class ReviewDocumentOperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the long-running operation.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # Operation is still running.
            RUNNING = 1

            # Operation is being cancelled.
            CANCELLING = 2

            # Operation succeeded.
            SUCCEEDED = 3

            # Operation failed.
            FAILED = 4

            # Operation is cancelled.
            CANCELLED = 5
          end
        end

        # Evaluates the given
        # {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion} against
        # the supplied documents.
        # @!attribute [rw] processor_version
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion} to
        #     evaluate.
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
        # @!attribute [rw] evaluation_documents
        #   @return [::Google::Cloud::DocumentAI::V1beta3::BatchDocumentsInputConfig]
        #     Optional. The documents used in the evaluation. If unspecified, use the
        #     processor's dataset as evaluation input.
        class EvaluateProcessorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata of the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#evaluate_processor_version EvaluateProcessorVersion}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata of the long-running operation.
        class EvaluateProcessorVersionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response of the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#evaluate_processor_version EvaluateProcessorVersion}
        # method.
        # @!attribute [rw] evaluation
        #   @return [::String]
        #     The resource name of the created evaluation.
        class EvaluateProcessorVersionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Retrieves a specific Evaluation.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::DocumentAI::V1beta3::Evaluation Evaluation} to get.
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}/evaluations/{evaluation}`
        class GetEvaluationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Retrieves a list of evaluations for a given
        # {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion}.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the
        #     {::Google::Cloud::DocumentAI::V1beta3::ProcessorVersion ProcessorVersion} to
        #     list evaluations for.
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        #     If unspecified, at most `5` evaluations are returned.
        #     The maximum value is `100`. Values above `100` are coerced to `100`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListEvaluations` call.
        #     Provide this to retrieve the subsequent page.
        class ListEvaluationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response from `ListEvaluations`.
        # @!attribute [rw] evaluations
        #   @return [::Array<::Google::Cloud::DocumentAI::V1beta3::Evaluation>]
        #     The evaluations requested.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListEvaluationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#import_processor_version ImportProcessorVersion}
        # method.
        #
        # The Document AI [Service
        # Agent](https://cloud.google.com/iam/docs/service-agents) of the destination
        # project must have [Document AI Editor
        # role](https://cloud.google.com/document-ai/docs/access-control/iam-roles) on
        # the source project.
        #
        # The destination project is specified as part of the
        # {::Google::Cloud::DocumentAI::V1beta3::ImportProcessorVersionRequest#parent parent}
        # field. The source project is specified as part of the
        # {::Google::Cloud::DocumentAI::V1beta3::ImportProcessorVersionRequest#processor_version_source source}
        # or
        # {::Google::Cloud::DocumentAI::V1beta3::ImportProcessorVersionRequest#external_processor_version_source external_processor_version_source}
        # field.
        # @!attribute [rw] processor_version_source
        #   @return [::String]
        #     The source processor version to import from. The source processor version
        #     and destination processor need to be in the same environment and region.
        #
        #     Note: The following fields are mutually exclusive: `processor_version_source`, `external_processor_version_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] external_processor_version_source
        #   @return [::Google::Cloud::DocumentAI::V1beta3::ImportProcessorVersionRequest::ExternalProcessorVersionSource]
        #     The source processor version to import from. It can be from a different
        #     environment and region than the destination processor.
        #
        #     Note: The following fields are mutually exclusive: `external_processor_version_source`, `processor_version_source`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The destination processor name to create the processor version
        #     in. Format:
        #     `projects/{project}/locations/{location}/processors/{processor}`
        class ImportProcessorVersionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The external source processor version.
          # @!attribute [rw] processor_version
          #   @return [::String]
          #     Required. The processor version name. Format:
          #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
          # @!attribute [rw] service_endpoint
          #   @return [::String]
          #     Optional. The Document AI service endpoint. For example,
          #     'https://us-documentai.googleapis.com'
          class ExternalProcessorVersionSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The response message for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#import_processor_version ImportProcessorVersion}
        # method.
        # @!attribute [rw] processor_version
        #   @return [::String]
        #     The destination processor version name.
        class ImportProcessorVersionResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The long-running operation metadata for the
        # {::Google::Cloud::DocumentAI::V1beta3::DocumentProcessorService::Client#import_processor_version ImportProcessorVersion}
        # method.
        # @!attribute [rw] common_metadata
        #   @return [::Google::Cloud::DocumentAI::V1beta3::CommonOperationMetadata]
        #     The basic metadata for the long-running operation.
        class ImportProcessorVersionMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
