# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/documentai/v1beta3/document_service_pb"
require "google/cloud/document_ai/v1beta3/document_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module DocumentAI
      module V1beta3
        module DocumentService
          module Rest
            ##
            # REST client for the DocumentService service.
            #
            # Service to call Cloud DocumentAI to manage document collection (dataset).
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "documentai.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :document_service_stub

              ##
              # Configure the DocumentService Client class.
              #
              # See {::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DocumentService clients
              #   ::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "DocumentAI", "V1beta3"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DocumentService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @document_service_stub.universe_domain
              end

              ##
              # Create a new DocumentService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DocumentService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @document_service_stub = ::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @document_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @document_service_stub.endpoint
                  config.universe_domain = @document_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @document_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @document_service_stub.logger
              end

              # Service calls

              ##
              # Updates metadata associated with a dataset.
              # Note that this method requires the
              # `documentai.googleapis.com/datasets.update` permission on the project,
              # which is highly privileged. A user or service account with this permission
              # can create new processors that can interact with any gcs bucket in your
              # project.
              #
              # @overload update_dataset(request, options = nil)
              #   Pass arguments to `update_dataset` via a request object, either of type
              #   {::Google::Cloud::DocumentAI::V1beta3::UpdateDatasetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DocumentAI::V1beta3::UpdateDatasetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_dataset(dataset: nil, update_mask: nil)
              #   Pass arguments to `update_dataset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::Google::Cloud::DocumentAI::V1beta3::Dataset, ::Hash]
              #     Required. The `name` field of the `Dataset` is used to identify the
              #     resource to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The update mask applies to the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/document_ai/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DocumentAI::V1beta3::UpdateDatasetRequest.new
              #
              #   # Call the update_dataset method.
              #   result = client.update_dataset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_dataset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1beta3::UpdateDatasetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_dataset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DocumentAI::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_dataset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_dataset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.update_dataset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Import documents into a dataset.
              #
              # @overload import_documents(request, options = nil)
              #   Pass arguments to `import_documents` via a request object, either of type
              #   {::Google::Cloud::DocumentAI::V1beta3::ImportDocumentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DocumentAI::V1beta3::ImportDocumentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload import_documents(dataset: nil, batch_documents_import_configs: nil)
              #   Pass arguments to `import_documents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::String]
              #     Required. The dataset resource name.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset
              #   @param batch_documents_import_configs [::Array<::Google::Cloud::DocumentAI::V1beta3::ImportDocumentsRequest::BatchDocumentsImportConfig, ::Hash>]
              #     Required. The Cloud Storage uri containing raw documents that must be
              #     imported.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/document_ai/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DocumentAI::V1beta3::ImportDocumentsRequest.new
              #
              #   # Call the import_documents method.
              #   result = client.import_documents request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def import_documents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1beta3::ImportDocumentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.import_documents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DocumentAI::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.import_documents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.import_documents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.import_documents request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns relevant fields present in the requested document.
              #
              # @overload get_document(request, options = nil)
              #   Pass arguments to `get_document` via a request object, either of type
              #   {::Google::Cloud::DocumentAI::V1beta3::GetDocumentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DocumentAI::V1beta3::GetDocumentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_document(dataset: nil, document_id: nil, read_mask: nil, page_range: nil)
              #   Pass arguments to `get_document` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::String]
              #     Required. The resource name of the dataset that the document belongs to .
              #     Format:
              #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset
              #   @param document_id [::Google::Cloud::DocumentAI::V1beta3::DocumentId, ::Hash]
              #     Required. Document identifier.
              #   @param read_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     If set, only fields listed here will be returned. Otherwise, all fields
              #     will be returned by default.
              #   @param page_range [::Google::Cloud::DocumentAI::V1beta3::DocumentPageRange, ::Hash]
              #     List of pages for which the fields specified in the `read_mask` must
              #     be served.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DocumentAI::V1beta3::GetDocumentResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DocumentAI::V1beta3::GetDocumentResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/document_ai/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DocumentAI::V1beta3::GetDocumentRequest.new
              #
              #   # Call the get_document method.
              #   result = client.get_document request
              #
              #   # The returned object is of type Google::Cloud::DocumentAI::V1beta3::GetDocumentResponse.
              #   p result
              #
              def get_document request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1beta3::GetDocumentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_document.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DocumentAI::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_document.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_document.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.get_document request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of documents present in the dataset.
              #
              # @overload list_documents(request, options = nil)
              #   Pass arguments to `list_documents` via a request object, either of type
              #   {::Google::Cloud::DocumentAI::V1beta3::ListDocumentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DocumentAI::V1beta3::ListDocumentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_documents(dataset: nil, page_size: nil, page_token: nil, filter: nil, return_total_size: nil, skip: nil)
              #   Pass arguments to `list_documents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::String]
              #     Required. The resource name of the dataset to be listed.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset
              #   @param page_size [::Integer]
              #     The maximum number of documents to return. The service may return
              #     fewer than this value.
              #     If unspecified, at most 20 documents will be returned.
              #     The maximum value is 100; values above 100 will be coerced to 100.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListDocuments` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListDocuments`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Query to filter the documents based on
              #     https://google.aip.dev/160.
              #     ## Currently support query strings are:
              #
              #     `SplitType=DATASET_SPLIT_TEST|DATASET_SPLIT_TRAIN|DATASET_SPLIT_UNASSIGNED`
              #     - `LabelingState=DOCUMENT_LABELED|DOCUMENT_UNLABELED|DOCUMENT_AUTO_LABELED`
              #     - `DisplayName=\"file_name.pdf\"`
              #     - `EntityType=abc/def`
              #     - `TagName=\"auto-labeling-running\"|\"sampled\"`
              #
              #     Note:
              #     - Only `AND`, `=` and `!=` are supported.
              #         e.g. `DisplayName=file_name AND EntityType!=abc` IS supported.
              #     - Wildcard `*` is supported only in `DisplayName` filter
              #     - No duplicate filter keys are allowed,
              #         e.g. `EntityType=a AND EntityType=b` is NOT supported.
              #     - String match is case sensitive (for filter `DisplayName` & `EntityType`).
              #   @param return_total_size [::Boolean]
              #     Optional. Controls if the request requires a total size of matched
              #     documents. See
              #     {::Google::Cloud::DocumentAI::V1beta3::ListDocumentsResponse#total_size ListDocumentsResponse.total_size}.
              #
              #     Enabling this flag may adversely impact performance.
              #
              #     Defaults to false.
              #   @param skip [::Integer]
              #     Optional. Number of results to skip beginning from the `page_token` if
              #     provided. https://google.aip.dev/158#skipping-results. It must be a
              #     non-negative integer. Negative values will be rejected. Note that this is
              #     not the number of pages to skip. If this value causes the cursor to move
              #     past the end of results,
              #     {::Google::Cloud::DocumentAI::V1beta3::ListDocumentsResponse#document_metadata ListDocumentsResponse.document_metadata}
              #     and
              #     {::Google::Cloud::DocumentAI::V1beta3::ListDocumentsResponse#next_page_token ListDocumentsResponse.next_page_token}
              #     will be empty.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DocumentAI::V1beta3::DocumentMetadata>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::DocumentAI::V1beta3::DocumentMetadata>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/document_ai/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DocumentAI::V1beta3::ListDocumentsRequest.new
              #
              #   # Call the list_documents method.
              #   result = client.list_documents request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::DocumentAI::V1beta3::DocumentMetadata.
              #     p item
              #   end
              #
              def list_documents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1beta3::ListDocumentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_documents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DocumentAI::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_documents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_documents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.list_documents request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @document_service_stub, :list_documents, "document_metadata", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a set of documents.
              #
              # @overload batch_delete_documents(request, options = nil)
              #   Pass arguments to `batch_delete_documents` via a request object, either of type
              #   {::Google::Cloud::DocumentAI::V1beta3::BatchDeleteDocumentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DocumentAI::V1beta3::BatchDeleteDocumentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload batch_delete_documents(dataset: nil, dataset_documents: nil)
              #   Pass arguments to `batch_delete_documents` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset [::String]
              #     Required. The dataset resource name.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset
              #   @param dataset_documents [::Google::Cloud::DocumentAI::V1beta3::BatchDatasetDocuments, ::Hash]
              #     Required. Dataset documents input. If given `filter`, all documents
              #     satisfying the filter will be deleted. If given documentIds, a maximum of
              #     50 documents can be deleted in a batch. The request will be rejected if
              #     more than 50 document_ids are provided.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/document_ai/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DocumentAI::V1beta3::BatchDeleteDocumentsRequest.new
              #
              #   # Call the batch_delete_documents method.
              #   result = client.batch_delete_documents request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def batch_delete_documents request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1beta3::BatchDeleteDocumentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.batch_delete_documents.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DocumentAI::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.batch_delete_documents.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.batch_delete_documents.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.batch_delete_documents request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the `DatasetSchema` of a `Dataset`.
              #
              # @overload get_dataset_schema(request, options = nil)
              #   Pass arguments to `get_dataset_schema` via a request object, either of type
              #   {::Google::Cloud::DocumentAI::V1beta3::GetDatasetSchemaRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DocumentAI::V1beta3::GetDatasetSchemaRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_dataset_schema(name: nil, visible_fields_only: nil)
              #   Pass arguments to `get_dataset_schema` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The dataset schema resource name.
              #     Format:
              #     projects/\\{project}/locations/\\{location}/processors/\\{processor}/dataset/datasetSchema
              #   @param visible_fields_only [::Boolean]
              #     If set, only returns the visible fields of the schema.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DocumentAI::V1beta3::DatasetSchema]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DocumentAI::V1beta3::DatasetSchema]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/document_ai/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DocumentAI::V1beta3::GetDatasetSchemaRequest.new
              #
              #   # Call the get_dataset_schema method.
              #   result = client.get_dataset_schema request
              #
              #   # The returned object is of type Google::Cloud::DocumentAI::V1beta3::DatasetSchema.
              #   p result
              #
              def get_dataset_schema request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1beta3::GetDatasetSchemaRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_dataset_schema.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DocumentAI::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_dataset_schema.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_dataset_schema.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.get_dataset_schema request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a `DatasetSchema`.
              #
              # @overload update_dataset_schema(request, options = nil)
              #   Pass arguments to `update_dataset_schema` via a request object, either of type
              #   {::Google::Cloud::DocumentAI::V1beta3::UpdateDatasetSchemaRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::DocumentAI::V1beta3::UpdateDatasetSchemaRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_dataset_schema(dataset_schema: nil, update_mask: nil)
              #   Pass arguments to `update_dataset_schema` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param dataset_schema [::Google::Cloud::DocumentAI::V1beta3::DatasetSchema, ::Hash]
              #     Required. The name field of the `DatasetSchema` is used to identify the
              #     resource to be updated.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     The update mask applies to the resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::DocumentAI::V1beta3::DatasetSchema]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::DocumentAI::V1beta3::DatasetSchema]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/document_ai/v1beta3"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::DocumentAI::V1beta3::UpdateDatasetSchemaRequest.new
              #
              #   # Call the update_dataset_schema method.
              #   result = client.update_dataset_schema request
              #
              #   # The returned object is of type Google::Cloud::DocumentAI::V1beta3::DatasetSchema.
              #   p result
              #
              def update_dataset_schema request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1beta3::UpdateDatasetSchemaRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_dataset_schema.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::DocumentAI::V1beta3::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_dataset_schema.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_dataset_schema.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @document_service_stub.update_dataset_schema request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DocumentService REST API.
              #
              # This class represents the configuration for DocumentService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # update_dataset to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.update_dataset.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::DocumentAI::V1beta3::DocumentService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.update_dataset.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "documentai.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DocumentService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `update_dataset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_dataset
                  ##
                  # RPC-specific configuration for `import_documents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :import_documents
                  ##
                  # RPC-specific configuration for `get_document`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_document
                  ##
                  # RPC-specific configuration for `list_documents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_documents
                  ##
                  # RPC-specific configuration for `batch_delete_documents`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :batch_delete_documents
                  ##
                  # RPC-specific configuration for `get_dataset_schema`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_dataset_schema
                  ##
                  # RPC-specific configuration for `update_dataset_schema`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_dataset_schema

                  # @private
                  def initialize parent_rpcs = nil
                    update_dataset_config = parent_rpcs.update_dataset if parent_rpcs.respond_to? :update_dataset
                    @update_dataset = ::Gapic::Config::Method.new update_dataset_config
                    import_documents_config = parent_rpcs.import_documents if parent_rpcs.respond_to? :import_documents
                    @import_documents = ::Gapic::Config::Method.new import_documents_config
                    get_document_config = parent_rpcs.get_document if parent_rpcs.respond_to? :get_document
                    @get_document = ::Gapic::Config::Method.new get_document_config
                    list_documents_config = parent_rpcs.list_documents if parent_rpcs.respond_to? :list_documents
                    @list_documents = ::Gapic::Config::Method.new list_documents_config
                    batch_delete_documents_config = parent_rpcs.batch_delete_documents if parent_rpcs.respond_to? :batch_delete_documents
                    @batch_delete_documents = ::Gapic::Config::Method.new batch_delete_documents_config
                    get_dataset_schema_config = parent_rpcs.get_dataset_schema if parent_rpcs.respond_to? :get_dataset_schema
                    @get_dataset_schema = ::Gapic::Config::Method.new get_dataset_schema_config
                    update_dataset_schema_config = parent_rpcs.update_dataset_schema if parent_rpcs.respond_to? :update_dataset_schema
                    @update_dataset_schema = ::Gapic::Config::Method.new update_dataset_schema_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
