# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DocumentAI
      module V1
        # A processor version is an implementation of a processor. Each processor
        # can have multiple versions, pretrained by Google internally or uptrained
        # by the customer. A processor can only have one default version at a time.
        # Its document-processing behavior is defined by that version.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the processor version.
        #     Format:
        #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processor_version}`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the processor version.
        # @!attribute [r] document_schema
        #   @return [::Google::Cloud::DocumentAI::V1::DocumentSchema]
        #     Output only. The schema of the processor version. Describes the output.
        # @!attribute [r] state
        #   @return [::Google::Cloud::DocumentAI::V1::ProcessorVersion::State]
        #     Output only. The state of the processor version.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the processor version was created.
        # @!attribute [r] latest_evaluation
        #   @return [::Google::Cloud::DocumentAI::V1::EvaluationReference]
        #     Output only. The most recently invoked evaluation for the processor
        #     version.
        # @!attribute [r] kms_key_name
        #   @return [::String]
        #     Output only. The KMS key name used for encryption.
        # @!attribute [r] kms_key_version_name
        #   @return [::String]
        #     Output only. The KMS key version with which data is encrypted.
        # @!attribute [r] google_managed
        #   @return [::Boolean]
        #     Output only. Denotes that this `ProcessorVersion` is managed by Google.
        # @!attribute [r] deprecation_info
        #   @return [::Google::Cloud::DocumentAI::V1::ProcessorVersion::DeprecationInfo]
        #     Output only. If set, information about the eventual deprecation of this
        #     version.
        # @!attribute [r] model_type
        #   @return [::Google::Cloud::DocumentAI::V1::ProcessorVersion::ModelType]
        #     Output only. The model type of this processor version.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] gen_ai_model_info
        #   @return [::Google::Cloud::DocumentAI::V1::ProcessorVersion::GenAiModelInfo]
        #     Output only. Information about Generative AI model-based processor
        #     versions.
        class ProcessorVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information about the upcoming deprecation of this processor version.
          # @!attribute [rw] deprecation_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which this processor version will be deprecated.
          # @!attribute [rw] replacement_processor_version
          #   @return [::String]
          #     If set, the processor version that will be used as a replacement.
          class DeprecationInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Information about Generative AI model-based processor versions.
          # @!attribute [rw] foundation_gen_ai_model_info
          #   @return [::Google::Cloud::DocumentAI::V1::ProcessorVersion::GenAiModelInfo::FoundationGenAiModelInfo]
          #     Information for a pretrained Google-managed foundation model.
          #
          #     Note: The following fields are mutually exclusive: `foundation_gen_ai_model_info`, `custom_gen_ai_model_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] custom_gen_ai_model_info
          #   @return [::Google::Cloud::DocumentAI::V1::ProcessorVersion::GenAiModelInfo::CustomGenAiModelInfo]
          #     Information for a custom Generative AI model created by the user.
          #
          #     Note: The following fields are mutually exclusive: `custom_gen_ai_model_info`, `foundation_gen_ai_model_info`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class GenAiModelInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Information for a pretrained Google-managed foundation model.
            # @!attribute [rw] finetuning_allowed
            #   @return [::Boolean]
            #     Whether finetuning is allowed for this base processor version.
            # @!attribute [rw] min_train_labeled_documents
            #   @return [::Integer]
            #     The minimum number of labeled documents in the training dataset
            #     required for finetuning.
            class FoundationGenAiModelInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Information for a custom Generative AI model created by the user. These
            # are created with `Create New Version` in either the `Call foundation
            # model` or `Fine tuning` tabs.
            # @!attribute [rw] custom_model_type
            #   @return [::Google::Cloud::DocumentAI::V1::ProcessorVersion::GenAiModelInfo::CustomGenAiModelInfo::CustomModelType]
            #     The type of custom model created by the user.
            # @!attribute [rw] base_processor_version_id
            #   @return [::String]
            #     The base processor version ID for the custom model.
            class CustomGenAiModelInfo
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The type of custom model created by the user.
              module CustomModelType
                # The model type is unspecified.
                CUSTOM_MODEL_TYPE_UNSPECIFIED = 0

                # The model is a versioned foundation model.
                VERSIONED_FOUNDATION = 1

                # The model is a finetuned foundation model.
                FINE_TUNED = 2
              end
            end
          end

          # The possible states of the processor version.
          module State
            # The processor version is in an unspecified state.
            STATE_UNSPECIFIED = 0

            # The processor version is deployed and can be used for processing.
            DEPLOYED = 1

            # The processor version is being deployed.
            DEPLOYING = 2

            # The processor version is not deployed and cannot be used for processing.
            UNDEPLOYED = 3

            # The processor version is being undeployed.
            UNDEPLOYING = 4

            # The processor version is being created.
            CREATING = 5

            # The processor version is being deleted.
            DELETING = 6

            # The processor version failed and is in an indeterminate state.
            FAILED = 7

            # The processor version is being imported.
            IMPORTING = 8
          end

          # The possible model types of the processor version.
          module ModelType
            # The processor version has unspecified model type.
            MODEL_TYPE_UNSPECIFIED = 0

            # The processor version has generative model type.
            MODEL_TYPE_GENERATIVE = 1

            # The processor version has custom model type.
            MODEL_TYPE_CUSTOM = 2
          end
        end

        # Contains the alias and the aliased resource name of processor version.
        # @!attribute [rw] alias
        #   @return [::String]
        #     The alias in the form of `processor_version` resource name.
        # @!attribute [rw] processor_version
        #   @return [::String]
        #     The resource name of aliased processor version.
        class ProcessorVersionAlias
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The first-class citizen for Document AI. Each processor defines how to
        # extract structural information from a document.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Immutable. The resource name of the processor.
        #     Format: `projects/{project}/locations/{location}/processors/{processor}`
        # @!attribute [rw] type
        #   @return [::String]
        #     The processor type, such as: `OCR_PROCESSOR`, `INVOICE_PROCESSOR`.
        #     To get a list of processor types, see
        #     {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client#fetch_processor_types FetchProcessorTypes}.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     The display name of the processor.
        # @!attribute [r] state
        #   @return [::Google::Cloud::DocumentAI::V1::Processor::State]
        #     Output only. The state of the processor.
        # @!attribute [rw] default_processor_version
        #   @return [::String]
        #     The default processor version.
        # @!attribute [r] processor_version_aliases
        #   @return [::Array<::Google::Cloud::DocumentAI::V1::ProcessorVersionAlias>]
        #     Output only. The processor version aliases.
        # @!attribute [r] process_endpoint
        #   @return [::String]
        #     Output only. Immutable. The http endpoint that can be called to invoke
        #     processing.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the processor was created.
        # @!attribute [rw] kms_key_name
        #   @return [::String]
        #     The [KMS key](https://cloud.google.com/security-key-management) used for
        #     encryption and decryption in CMEK scenarios.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        class Processor
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The possible states of the processor.
          module State
            # The processor is in an unspecified state.
            STATE_UNSPECIFIED = 0

            # The processor is enabled, i.e., has an enabled version which can
            # currently serve processing requests and all the feature dependencies have
            # been successfully initialized.
            ENABLED = 1

            # The processor is disabled.
            DISABLED = 2

            # The processor is being enabled, will become `ENABLED` if successful.
            ENABLING = 3

            # The processor is being disabled, will become `DISABLED` if successful.
            DISABLING = 4

            # The processor is being created, will become either `ENABLED` (for
            # successful creation) or `FAILED` (for failed ones).
            # Once a processor is in this state, it can then be used for document
            # processing, but the feature dependencies of the processor might not be
            # fully created yet.
            CREATING = 5

            # The processor failed during creation or initialization of feature
            # dependencies. The user should delete the processor and recreate one as
            # all the functionalities of the processor are disabled.
            FAILED = 6

            # The processor is being deleted, will be removed if successful.
            DELETING = 7
          end
        end
      end
    end
  end
end
