# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/documentai/v1/document_processor_service_pb"
require "google/cloud/location"

module Google
  module Cloud
    module DocumentAI
      module V1
        module DocumentProcessorService
          ##
          # Client for the DocumentProcessorService service.
          #
          # Service to call Document AI to process documents according to the
          # processor's definition. Processors are built using state-of-the-art Google
          # AI such as natural language, computer vision, and translation to extract
          # structured information from unstructured or semi-structured documents.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "documentai.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :document_processor_service_stub

            ##
            # Configure the DocumentProcessorService Client class.
            #
            # See {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DocumentProcessorService clients
            #   ::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DocumentAI", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.process_document.timeout = 300.0
                default_config.rpcs.process_document.retry_policy = {
                  initial_delay: 1.0, max_delay: 90.0, multiplier: 9.0, retry_codes: [4, 14, 8]
                }

                default_config.rpcs.batch_process_documents.timeout = 120.0
                default_config.rpcs.batch_process_documents.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.5, retry_codes: [4, 14]
                }

                default_config.rpcs.review_document.timeout = 120.0
                default_config.rpcs.review_document.retry_policy = {
                  initial_delay: 1.0, max_delay: 60.0, multiplier: 1.5, retry_codes: [4, 14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DocumentProcessorService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @document_processor_service_stub.universe_domain
            end

            ##
            # Create a new DocumentProcessorService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DocumentProcessorService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/documentai/v1/document_processor_service_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @document_processor_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @document_processor_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @document_processor_service_stub.endpoint
                config.universe_domain = @document_processor_service_stub.universe_domain
                config.logger = @document_processor_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @document_processor_service_stub.logger
            end

            # Service calls

            ##
            # Processes a single document.
            #
            # @overload process_document(request, options = nil)
            #   Pass arguments to `process_document` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::ProcessRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::ProcessRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload process_document(inline_document: nil, raw_document: nil, gcs_document: nil, name: nil, skip_human_review: nil, field_mask: nil, process_options: nil, labels: nil, imageless_mode: nil)
            #   Pass arguments to `process_document` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param inline_document [::Google::Cloud::DocumentAI::V1::Document, ::Hash]
            #     An inline document proto.
            #
            #     Note: The following parameters are mutually exclusive: `inline_document`, `raw_document`, `gcs_document`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param raw_document [::Google::Cloud::DocumentAI::V1::RawDocument, ::Hash]
            #     A raw document content (bytes).
            #
            #     Note: The following parameters are mutually exclusive: `raw_document`, `inline_document`, `gcs_document`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param gcs_document [::Google::Cloud::DocumentAI::V1::GcsDocument, ::Hash]
            #     A raw document on Google Cloud Storage.
            #
            #     Note: The following parameters are mutually exclusive: `gcs_document`, `inline_document`, `raw_document`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::DocumentAI::V1::Processor Processor} or
            #     {::Google::Cloud::DocumentAI::V1::ProcessorVersion ProcessorVersion}
            #     to use for processing. If a
            #     {::Google::Cloud::DocumentAI::V1::Processor Processor} is specified, the server
            #     will use its [default
            #     version][google.cloud.documentai.v1.Processor.default_processor_version].
            #     Format: `projects/{project}/locations/{location}/processors/{processor}`,
            #     or
            #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
            #   @param skip_human_review [::Boolean]
            #     Whether human review should be skipped for this request. Default to
            #     `false`.
            #   @param field_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Specifies which fields to include in the
            #     {::Google::Cloud::DocumentAI::V1::ProcessResponse#document ProcessResponse.document}
            #     output. Only supports top-level document and pages field, so it must be in
            #     the form of `{document_field_name}` or `pages.{page_field_name}`.
            #   @param process_options [::Google::Cloud::DocumentAI::V1::ProcessOptions, ::Hash]
            #     Inference-time options for the process API
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. The labels with user-defined metadata for the request.
            #
            #     Label keys and values can be no longer than 63 characters
            #     (Unicode codepoints) and can only contain lowercase letters, numeric
            #     characters, underscores, and dashes. International characters are allowed.
            #     Label values are optional. Label keys must start with a letter.
            #   @param imageless_mode [::Boolean]
            #     Optional. Option to remove images from the document.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DocumentAI::V1::ProcessResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DocumentAI::V1::ProcessResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::ProcessRequest.new
            #
            #   # Call the process_document method.
            #   result = client.process_document request
            #
            #   # The returned object is of type Google::Cloud::DocumentAI::V1::ProcessResponse.
            #   p result
            #
            def process_document request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::ProcessRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.process_document.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.process_document.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.process_document.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :process_document, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # LRO endpoint to batch process many documents. The output is written
            # to Cloud Storage as JSON in the [Document] format.
            #
            # @overload batch_process_documents(request, options = nil)
            #   Pass arguments to `batch_process_documents` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::BatchProcessRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::BatchProcessRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload batch_process_documents(name: nil, input_documents: nil, document_output_config: nil, skip_human_review: nil, process_options: nil, labels: nil)
            #   Pass arguments to `batch_process_documents` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of
            #     {::Google::Cloud::DocumentAI::V1::Processor Processor} or
            #     {::Google::Cloud::DocumentAI::V1::ProcessorVersion ProcessorVersion}.
            #     Format: `projects/{project}/locations/{location}/processors/{processor}`,
            #     or
            #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
            #   @param input_documents [::Google::Cloud::DocumentAI::V1::BatchDocumentsInputConfig, ::Hash]
            #     The input documents for the
            #     {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}
            #     method.
            #   @param document_output_config [::Google::Cloud::DocumentAI::V1::DocumentOutputConfig, ::Hash]
            #     The output configuration for the
            #     {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}
            #     method.
            #   @param skip_human_review [::Boolean]
            #     Whether human review should be skipped for this request. Default to
            #     `false`.
            #   @param process_options [::Google::Cloud::DocumentAI::V1::ProcessOptions, ::Hash]
            #     Inference-time options for the process API
            #   @param labels [::Hash{::String => ::String}]
            #     Optional. The labels with user-defined metadata for the request.
            #
            #     Label keys and values can be no longer than 63 characters
            #     (Unicode codepoints) and can only contain lowercase letters, numeric
            #     characters, underscores, and dashes. International characters are allowed.
            #     Label values are optional. Label keys must start with a letter.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::BatchProcessRequest.new
            #
            #   # Call the batch_process_documents method.
            #   result = client.batch_process_documents request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def batch_process_documents request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::BatchProcessRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.batch_process_documents.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.batch_process_documents.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.batch_process_documents.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :batch_process_documents, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches processor types. Note that we don't use
            # {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client#list_processor_types ListProcessorTypes}
            # here, because it isn't paginated.
            #
            # @overload fetch_processor_types(request, options = nil)
            #   Pass arguments to `fetch_processor_types` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::FetchProcessorTypesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::FetchProcessorTypesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_processor_types(parent: nil)
            #   Pass arguments to `fetch_processor_types` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location of processor types to list.
            #     Format: `projects/{project}/locations/{location}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DocumentAI::V1::FetchProcessorTypesResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DocumentAI::V1::FetchProcessorTypesResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::FetchProcessorTypesRequest.new
            #
            #   # Call the fetch_processor_types method.
            #   result = client.fetch_processor_types request
            #
            #   # The returned object is of type Google::Cloud::DocumentAI::V1::FetchProcessorTypesResponse.
            #   p result
            #
            def fetch_processor_types request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::FetchProcessorTypesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_processor_types.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_processor_types.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_processor_types.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :fetch_processor_types, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists the processor types that exist.
            #
            # @overload list_processor_types(request, options = nil)
            #   Pass arguments to `list_processor_types` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::ListProcessorTypesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::ListProcessorTypesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_processor_types(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_processor_types` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The location of processor types to list.
            #     Format: `projects/{project}/locations/{location}`.
            #   @param page_size [::Integer]
            #     The maximum number of processor types to return.
            #     If unspecified, at most `100` processor types will be returned.
            #     The maximum value is `500`. Values above `500` will be coerced to `500`.
            #   @param page_token [::String]
            #     Used to retrieve the next page of results, empty if at the end of the list.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DocumentAI::V1::ProcessorType>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DocumentAI::V1::ProcessorType>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::ListProcessorTypesRequest.new
            #
            #   # Call the list_processor_types method.
            #   result = client.list_processor_types request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DocumentAI::V1::ProcessorType.
            #     p item
            #   end
            #
            def list_processor_types request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::ListProcessorTypesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_processor_types.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_processor_types.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_processor_types.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :list_processor_types, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @document_processor_service_stub, :list_processor_types, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a processor type detail.
            #
            # @overload get_processor_type(request, options = nil)
            #   Pass arguments to `get_processor_type` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::GetProcessorTypeRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::GetProcessorTypeRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_processor_type(name: nil)
            #   Pass arguments to `get_processor_type` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor type resource name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DocumentAI::V1::ProcessorType]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DocumentAI::V1::ProcessorType]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::GetProcessorTypeRequest.new
            #
            #   # Call the get_processor_type method.
            #   result = client.get_processor_type request
            #
            #   # The returned object is of type Google::Cloud::DocumentAI::V1::ProcessorType.
            #   p result
            #
            def get_processor_type request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::GetProcessorTypeRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_processor_type.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_processor_type.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_processor_type.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :get_processor_type, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all processors which belong to this project.
            #
            # @overload list_processors(request, options = nil)
            #   Pass arguments to `list_processors` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::ListProcessorsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::ListProcessorsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_processors(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_processors` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent (project and location) which owns this collection of
            #     Processors. Format: `projects/{project}/locations/{location}`
            #   @param page_size [::Integer]
            #     The maximum number of processors to return.
            #     If unspecified, at most `50` processors will be returned.
            #     The maximum value is `100`. Values above `100` will be coerced to `100`.
            #   @param page_token [::String]
            #     We will return the processors sorted by creation time. The page token
            #     will point to the next processor.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DocumentAI::V1::Processor>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DocumentAI::V1::Processor>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::ListProcessorsRequest.new
            #
            #   # Call the list_processors method.
            #   result = client.list_processors request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DocumentAI::V1::Processor.
            #     p item
            #   end
            #
            def list_processors request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::ListProcessorsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_processors.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_processors.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_processors.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :list_processors, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @document_processor_service_stub, :list_processors, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a processor detail.
            #
            # @overload get_processor(request, options = nil)
            #   Pass arguments to `get_processor` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::GetProcessorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::GetProcessorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_processor(name: nil)
            #   Pass arguments to `get_processor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor resource name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DocumentAI::V1::Processor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DocumentAI::V1::Processor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::GetProcessorRequest.new
            #
            #   # Call the get_processor method.
            #   result = client.get_processor request
            #
            #   # The returned object is of type Google::Cloud::DocumentAI::V1::Processor.
            #   p result
            #
            def get_processor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::GetProcessorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_processor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_processor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_processor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :get_processor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Trains a new processor version.
            # Operation metadata is returned as
            # {::Google::Cloud::DocumentAI::V1::TrainProcessorVersionMetadata TrainProcessorVersionMetadata}.
            #
            # @overload train_processor_version(request, options = nil)
            #   Pass arguments to `train_processor_version` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::TrainProcessorVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::TrainProcessorVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload train_processor_version(custom_document_extraction_options: nil, foundation_model_tuning_options: nil, parent: nil, processor_version: nil, document_schema: nil, input_data: nil, base_processor_version: nil)
            #   Pass arguments to `train_processor_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param custom_document_extraction_options [::Google::Cloud::DocumentAI::V1::TrainProcessorVersionRequest::CustomDocumentExtractionOptions, ::Hash]
            #     Options to control Custom Document Extraction (CDE) Processor.
            #
            #     Note: The following parameters are mutually exclusive: `custom_document_extraction_options`, `foundation_model_tuning_options`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param foundation_model_tuning_options [::Google::Cloud::DocumentAI::V1::TrainProcessorVersionRequest::FoundationModelTuningOptions, ::Hash]
            #     Options to control foundation model tuning of a processor.
            #
            #     Note: The following parameters are mutually exclusive: `foundation_model_tuning_options`, `custom_document_extraction_options`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param parent [::String]
            #     Required. The parent (project, location and processor) to create the new
            #     version for. Format:
            #     `projects/{project}/locations/{location}/processors/{processor}`.
            #   @param processor_version [::Google::Cloud::DocumentAI::V1::ProcessorVersion, ::Hash]
            #     Required. The processor version to be created.
            #   @param document_schema [::Google::Cloud::DocumentAI::V1::DocumentSchema, ::Hash]
            #     Optional. The schema the processor version will be trained with.
            #   @param input_data [::Google::Cloud::DocumentAI::V1::TrainProcessorVersionRequest::InputData, ::Hash]
            #     Optional. The input data used to train the
            #     {::Google::Cloud::DocumentAI::V1::ProcessorVersion ProcessorVersion}.
            #   @param base_processor_version [::String]
            #     Optional. The processor version to use as a base for training. This
            #     processor version must be a child of `parent`. Format:
            #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::TrainProcessorVersionRequest.new
            #
            #   # Call the train_processor_version method.
            #   result = client.train_processor_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def train_processor_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::TrainProcessorVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.train_processor_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.train_processor_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.train_processor_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :train_processor_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets a processor version detail.
            #
            # @overload get_processor_version(request, options = nil)
            #   Pass arguments to `get_processor_version` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::GetProcessorVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::GetProcessorVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_processor_version(name: nil)
            #   Pass arguments to `get_processor_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor resource name.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DocumentAI::V1::ProcessorVersion]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DocumentAI::V1::ProcessorVersion]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::GetProcessorVersionRequest.new
            #
            #   # Call the get_processor_version method.
            #   result = client.get_processor_version request
            #
            #   # The returned object is of type Google::Cloud::DocumentAI::V1::ProcessorVersion.
            #   p result
            #
            def get_processor_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::GetProcessorVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_processor_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_processor_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_processor_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :get_processor_version, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists all versions of a processor.
            #
            # @overload list_processor_versions(request, options = nil)
            #   Pass arguments to `list_processor_versions` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::ListProcessorVersionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::ListProcessorVersionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_processor_versions(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_processor_versions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent (project, location and processor) to list all
            #     versions. Format:
            #     `projects/{project}/locations/{location}/processors/{processor}`
            #   @param page_size [::Integer]
            #     The maximum number of processor versions to return.
            #     If unspecified, at most `10` processor versions will be returned.
            #     The maximum value is `20`. Values above `20` will be coerced to `20`.
            #   @param page_token [::String]
            #     We will return the processor versions sorted by creation time. The page
            #     token will point to the next processor version.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DocumentAI::V1::ProcessorVersion>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DocumentAI::V1::ProcessorVersion>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::ListProcessorVersionsRequest.new
            #
            #   # Call the list_processor_versions method.
            #   result = client.list_processor_versions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DocumentAI::V1::ProcessorVersion.
            #     p item
            #   end
            #
            def list_processor_versions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::ListProcessorVersionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_processor_versions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_processor_versions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_processor_versions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :list_processor_versions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @document_processor_service_stub, :list_processor_versions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the processor version, all artifacts under the processor version
            # will be deleted.
            #
            # @overload delete_processor_version(request, options = nil)
            #   Pass arguments to `delete_processor_version` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::DeleteProcessorVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::DeleteProcessorVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_processor_version(name: nil)
            #   Pass arguments to `delete_processor_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor version resource name to be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::DeleteProcessorVersionRequest.new
            #
            #   # Call the delete_processor_version method.
            #   result = client.delete_processor_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_processor_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::DeleteProcessorVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_processor_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_processor_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_processor_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :delete_processor_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deploys the processor version.
            #
            # @overload deploy_processor_version(request, options = nil)
            #   Pass arguments to `deploy_processor_version` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::DeployProcessorVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::DeployProcessorVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload deploy_processor_version(name: nil)
            #   Pass arguments to `deploy_processor_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor version resource name to be deployed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::DeployProcessorVersionRequest.new
            #
            #   # Call the deploy_processor_version method.
            #   result = client.deploy_processor_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def deploy_processor_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::DeployProcessorVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.deploy_processor_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.deploy_processor_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.deploy_processor_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :deploy_processor_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Undeploys the processor version.
            #
            # @overload undeploy_processor_version(request, options = nil)
            #   Pass arguments to `undeploy_processor_version` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::UndeployProcessorVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::UndeployProcessorVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload undeploy_processor_version(name: nil)
            #   Pass arguments to `undeploy_processor_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor version resource name to be undeployed.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::UndeployProcessorVersionRequest.new
            #
            #   # Call the undeploy_processor_version method.
            #   result = client.undeploy_processor_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def undeploy_processor_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::UndeployProcessorVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.undeploy_processor_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.undeploy_processor_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.undeploy_processor_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :undeploy_processor_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a processor from the
            # {::Google::Cloud::DocumentAI::V1::ProcessorType ProcessorType} provided. The
            # processor will be at `ENABLED` state by default after its creation. Note
            # that this method requires the `documentai.processors.create` permission on
            # the project, which is highly privileged. A user or service account with
            # this permission can create new processors that can interact with any gcs
            # bucket in your project.
            #
            # @overload create_processor(request, options = nil)
            #   Pass arguments to `create_processor` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::CreateProcessorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::CreateProcessorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_processor(parent: nil, processor: nil)
            #   Pass arguments to `create_processor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The parent (project and location) under which to create the
            #     processor. Format: `projects/{project}/locations/{location}`
            #   @param processor [::Google::Cloud::DocumentAI::V1::Processor, ::Hash]
            #     Required. The processor to be created, requires
            #     {::Google::Cloud::DocumentAI::V1::Processor#type Processor.type} and
            #     {::Google::Cloud::DocumentAI::V1::Processor#display_name Processor.display_name}
            #     to be set. Also, the
            #     {::Google::Cloud::DocumentAI::V1::Processor#kms_key_name Processor.kms_key_name}
            #     field must be set if the processor is under CMEK.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DocumentAI::V1::Processor]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DocumentAI::V1::Processor]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::CreateProcessorRequest.new
            #
            #   # Call the create_processor method.
            #   result = client.create_processor request
            #
            #   # The returned object is of type Google::Cloud::DocumentAI::V1::Processor.
            #   p result
            #
            def create_processor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::CreateProcessorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_processor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_processor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_processor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :create_processor, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes the processor, unloads all deployed model artifacts if it was
            # enabled and then deletes all artifacts associated with this processor.
            #
            # @overload delete_processor(request, options = nil)
            #   Pass arguments to `delete_processor` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::DeleteProcessorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::DeleteProcessorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_processor(name: nil)
            #   Pass arguments to `delete_processor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor resource name to be deleted.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::DeleteProcessorRequest.new
            #
            #   # Call the delete_processor method.
            #   result = client.delete_processor request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_processor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::DeleteProcessorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_processor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_processor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_processor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :delete_processor, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Enables a processor
            #
            # @overload enable_processor(request, options = nil)
            #   Pass arguments to `enable_processor` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::EnableProcessorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::EnableProcessorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload enable_processor(name: nil)
            #   Pass arguments to `enable_processor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor resource name to be enabled.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::EnableProcessorRequest.new
            #
            #   # Call the enable_processor method.
            #   result = client.enable_processor request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def enable_processor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::EnableProcessorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.enable_processor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.enable_processor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.enable_processor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :enable_processor, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Disables a processor
            #
            # @overload disable_processor(request, options = nil)
            #   Pass arguments to `disable_processor` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::DisableProcessorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::DisableProcessorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload disable_processor(name: nil)
            #   Pass arguments to `disable_processor` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The processor resource name to be disabled.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::DisableProcessorRequest.new
            #
            #   # Call the disable_processor method.
            #   result = client.disable_processor request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def disable_processor request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::DisableProcessorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.disable_processor.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.disable_processor.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.disable_processor.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :disable_processor, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Set the default (active) version of a
            # {::Google::Cloud::DocumentAI::V1::Processor Processor} that will be used in
            # {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client#process_document ProcessDocument}
            # and
            # {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client#batch_process_documents BatchProcessDocuments}.
            #
            # @overload set_default_processor_version(request, options = nil)
            #   Pass arguments to `set_default_processor_version` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::SetDefaultProcessorVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::SetDefaultProcessorVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload set_default_processor_version(processor: nil, default_processor_version: nil)
            #   Pass arguments to `set_default_processor_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param processor [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::DocumentAI::V1::Processor Processor} to change default
            #     version.
            #   @param default_processor_version [::String]
            #     Required. The resource name of child
            #     {::Google::Cloud::DocumentAI::V1::ProcessorVersion ProcessorVersion} to use as
            #     default. Format:
            #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{version}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::SetDefaultProcessorVersionRequest.new
            #
            #   # Call the set_default_processor_version method.
            #   result = client.set_default_processor_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def set_default_processor_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::SetDefaultProcessorVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.set_default_processor_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.processor
                header_params["processor"] = request.processor
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.set_default_processor_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.set_default_processor_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :set_default_processor_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Send a document for Human Review. The input document should be processed by
            # the specified processor.
            #
            # @overload review_document(request, options = nil)
            #   Pass arguments to `review_document` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::ReviewDocumentRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::ReviewDocumentRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload review_document(inline_document: nil, human_review_config: nil, enable_schema_validation: nil, priority: nil, document_schema: nil)
            #   Pass arguments to `review_document` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param inline_document [::Google::Cloud::DocumentAI::V1::Document, ::Hash]
            #     An inline document proto.
            #   @param human_review_config [::String]
            #     Required. The resource name of the
            #     [HumanReviewConfig][google.cloud.documentai.v1.HumanReviewConfig] that the
            #     document will be reviewed with.
            #   @param enable_schema_validation [::Boolean]
            #     Whether the validation should be performed on the ad-hoc review request.
            #   @param priority [::Google::Cloud::DocumentAI::V1::ReviewDocumentRequest::Priority]
            #     The priority of the human review task.
            #   @param document_schema [::Google::Cloud::DocumentAI::V1::DocumentSchema, ::Hash]
            #     The document schema of the human review task.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::ReviewDocumentRequest.new
            #
            #   # Call the review_document method.
            #   result = client.review_document request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def review_document request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::ReviewDocumentRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.review_document.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.human_review_config
                header_params["human_review_config"] = request.human_review_config
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.review_document.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.review_document.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :review_document, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Evaluates a ProcessorVersion against annotated documents, producing an
            # Evaluation.
            #
            # @overload evaluate_processor_version(request, options = nil)
            #   Pass arguments to `evaluate_processor_version` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::EvaluateProcessorVersionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::EvaluateProcessorVersionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload evaluate_processor_version(processor_version: nil, evaluation_documents: nil)
            #   Pass arguments to `evaluate_processor_version` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param processor_version [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::DocumentAI::V1::ProcessorVersion ProcessorVersion} to
            #     evaluate.
            #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
            #   @param evaluation_documents [::Google::Cloud::DocumentAI::V1::BatchDocumentsInputConfig, ::Hash]
            #     Optional. The documents used in the evaluation. If unspecified, use the
            #     processor's dataset as evaluation input.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::EvaluateProcessorVersionRequest.new
            #
            #   # Call the evaluate_processor_version method.
            #   result = client.evaluate_processor_version request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def evaluate_processor_version request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::EvaluateProcessorVersionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.evaluate_processor_version.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.processor_version
                header_params["processor_version"] = request.processor_version
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.evaluate_processor_version.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.evaluate_processor_version.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :evaluate_processor_version, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a specific evaluation.
            #
            # @overload get_evaluation(request, options = nil)
            #   Pass arguments to `get_evaluation` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::GetEvaluationRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::GetEvaluationRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_evaluation(name: nil)
            #   Pass arguments to `get_evaluation` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::DocumentAI::V1::Evaluation Evaluation} to get.
            #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}/evaluations/{evaluation}`
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DocumentAI::V1::Evaluation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DocumentAI::V1::Evaluation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::GetEvaluationRequest.new
            #
            #   # Call the get_evaluation method.
            #   result = client.get_evaluation request
            #
            #   # The returned object is of type Google::Cloud::DocumentAI::V1::Evaluation.
            #   p result
            #
            def get_evaluation request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::GetEvaluationRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_evaluation.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_evaluation.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_evaluation.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :get_evaluation, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Retrieves a set of evaluations for a given processor version.
            #
            # @overload list_evaluations(request, options = nil)
            #   Pass arguments to `list_evaluations` via a request object, either of type
            #   {::Google::Cloud::DocumentAI::V1::ListEvaluationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DocumentAI::V1::ListEvaluationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_evaluations(parent: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `list_evaluations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the
            #     {::Google::Cloud::DocumentAI::V1::ProcessorVersion ProcessorVersion} to list
            #     evaluations for.
            #     `projects/{project}/locations/{location}/processors/{processor}/processorVersions/{processorVersion}`
            #   @param page_size [::Integer]
            #     The standard list page size.
            #     If unspecified, at most `5` evaluations are returned.
            #     The maximum value is `100`. Values above `100` are coerced to `100`.
            #   @param page_token [::String]
            #     A page token, received from a previous `ListEvaluations` call.
            #     Provide this to retrieve the subsequent page.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DocumentAI::V1::Evaluation>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DocumentAI::V1::Evaluation>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/document_ai/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DocumentAI::V1::ListEvaluationsRequest.new
            #
            #   # Call the list_evaluations method.
            #   result = client.list_evaluations request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DocumentAI::V1::Evaluation.
            #     p item
            #   end
            #
            def list_evaluations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DocumentAI::V1::ListEvaluationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_evaluations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DocumentAI::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_evaluations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_evaluations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @document_processor_service_stub.call_rpc :list_evaluations, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @document_processor_service_stub, :list_evaluations, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DocumentProcessorService API.
            #
            # This class represents the configuration for DocumentProcessorService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # process_document to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.process_document.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.process_document.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DocumentAI::V1::DocumentProcessorService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "documentai.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DocumentProcessorService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `process_document`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :process_document
                ##
                # RPC-specific configuration for `batch_process_documents`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :batch_process_documents
                ##
                # RPC-specific configuration for `fetch_processor_types`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_processor_types
                ##
                # RPC-specific configuration for `list_processor_types`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_processor_types
                ##
                # RPC-specific configuration for `get_processor_type`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_processor_type
                ##
                # RPC-specific configuration for `list_processors`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_processors
                ##
                # RPC-specific configuration for `get_processor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_processor
                ##
                # RPC-specific configuration for `train_processor_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :train_processor_version
                ##
                # RPC-specific configuration for `get_processor_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_processor_version
                ##
                # RPC-specific configuration for `list_processor_versions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_processor_versions
                ##
                # RPC-specific configuration for `delete_processor_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_processor_version
                ##
                # RPC-specific configuration for `deploy_processor_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :deploy_processor_version
                ##
                # RPC-specific configuration for `undeploy_processor_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :undeploy_processor_version
                ##
                # RPC-specific configuration for `create_processor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_processor
                ##
                # RPC-specific configuration for `delete_processor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_processor
                ##
                # RPC-specific configuration for `enable_processor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :enable_processor
                ##
                # RPC-specific configuration for `disable_processor`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :disable_processor
                ##
                # RPC-specific configuration for `set_default_processor_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :set_default_processor_version
                ##
                # RPC-specific configuration for `review_document`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :review_document
                ##
                # RPC-specific configuration for `evaluate_processor_version`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :evaluate_processor_version
                ##
                # RPC-specific configuration for `get_evaluation`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_evaluation
                ##
                # RPC-specific configuration for `list_evaluations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_evaluations

                # @private
                def initialize parent_rpcs = nil
                  process_document_config = parent_rpcs.process_document if parent_rpcs.respond_to? :process_document
                  @process_document = ::Gapic::Config::Method.new process_document_config
                  batch_process_documents_config = parent_rpcs.batch_process_documents if parent_rpcs.respond_to? :batch_process_documents
                  @batch_process_documents = ::Gapic::Config::Method.new batch_process_documents_config
                  fetch_processor_types_config = parent_rpcs.fetch_processor_types if parent_rpcs.respond_to? :fetch_processor_types
                  @fetch_processor_types = ::Gapic::Config::Method.new fetch_processor_types_config
                  list_processor_types_config = parent_rpcs.list_processor_types if parent_rpcs.respond_to? :list_processor_types
                  @list_processor_types = ::Gapic::Config::Method.new list_processor_types_config
                  get_processor_type_config = parent_rpcs.get_processor_type if parent_rpcs.respond_to? :get_processor_type
                  @get_processor_type = ::Gapic::Config::Method.new get_processor_type_config
                  list_processors_config = parent_rpcs.list_processors if parent_rpcs.respond_to? :list_processors
                  @list_processors = ::Gapic::Config::Method.new list_processors_config
                  get_processor_config = parent_rpcs.get_processor if parent_rpcs.respond_to? :get_processor
                  @get_processor = ::Gapic::Config::Method.new get_processor_config
                  train_processor_version_config = parent_rpcs.train_processor_version if parent_rpcs.respond_to? :train_processor_version
                  @train_processor_version = ::Gapic::Config::Method.new train_processor_version_config
                  get_processor_version_config = parent_rpcs.get_processor_version if parent_rpcs.respond_to? :get_processor_version
                  @get_processor_version = ::Gapic::Config::Method.new get_processor_version_config
                  list_processor_versions_config = parent_rpcs.list_processor_versions if parent_rpcs.respond_to? :list_processor_versions
                  @list_processor_versions = ::Gapic::Config::Method.new list_processor_versions_config
                  delete_processor_version_config = parent_rpcs.delete_processor_version if parent_rpcs.respond_to? :delete_processor_version
                  @delete_processor_version = ::Gapic::Config::Method.new delete_processor_version_config
                  deploy_processor_version_config = parent_rpcs.deploy_processor_version if parent_rpcs.respond_to? :deploy_processor_version
                  @deploy_processor_version = ::Gapic::Config::Method.new deploy_processor_version_config
                  undeploy_processor_version_config = parent_rpcs.undeploy_processor_version if parent_rpcs.respond_to? :undeploy_processor_version
                  @undeploy_processor_version = ::Gapic::Config::Method.new undeploy_processor_version_config
                  create_processor_config = parent_rpcs.create_processor if parent_rpcs.respond_to? :create_processor
                  @create_processor = ::Gapic::Config::Method.new create_processor_config
                  delete_processor_config = parent_rpcs.delete_processor if parent_rpcs.respond_to? :delete_processor
                  @delete_processor = ::Gapic::Config::Method.new delete_processor_config
                  enable_processor_config = parent_rpcs.enable_processor if parent_rpcs.respond_to? :enable_processor
                  @enable_processor = ::Gapic::Config::Method.new enable_processor_config
                  disable_processor_config = parent_rpcs.disable_processor if parent_rpcs.respond_to? :disable_processor
                  @disable_processor = ::Gapic::Config::Method.new disable_processor_config
                  set_default_processor_version_config = parent_rpcs.set_default_processor_version if parent_rpcs.respond_to? :set_default_processor_version
                  @set_default_processor_version = ::Gapic::Config::Method.new set_default_processor_version_config
                  review_document_config = parent_rpcs.review_document if parent_rpcs.respond_to? :review_document
                  @review_document = ::Gapic::Config::Method.new review_document_config
                  evaluate_processor_version_config = parent_rpcs.evaluate_processor_version if parent_rpcs.respond_to? :evaluate_processor_version
                  @evaluate_processor_version = ::Gapic::Config::Method.new evaluate_processor_version_config
                  get_evaluation_config = parent_rpcs.get_evaluation if parent_rpcs.respond_to? :get_evaluation
                  @get_evaluation = ::Gapic::Config::Method.new get_evaluation_config
                  list_evaluations_config = parent_rpcs.list_evaluations if parent_rpcs.respond_to? :list_evaluations
                  @list_evaluations = ::Gapic::Config::Method.new list_evaluations_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
