# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dlp
      module V2
        # Type of information detected by the API.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the information type. Either a name of your choosing when
        #     creating a CustomInfoType, or one of the names listed
        #     at
        #     https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
        #     when specifying a built-in type.  When sending Cloud DLP results to Data
        #     Catalog, infoType names should conform to the pattern
        #     `[A-Za-z0-9$_-]{1,64}`.
        # @!attribute [rw] version
        #   @return [::String]
        #     Optional version name for this InfoType.
        # @!attribute [rw] sensitivity_score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
        #     Optional custom sensitivity for this InfoType.
        #     This only applies to data profiling.
        class InfoType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Score is calculated from of all elements in the data profile.
        # A higher level means the data is more sensitive.
        # @!attribute [rw] score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore::SensitivityScoreLevel]
        #     The sensitivity score applied to the resource.
        class SensitivityScore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Various sensitivity score levels for resources.
          module SensitivityScoreLevel
            # Unused.
            SENSITIVITY_SCORE_UNSPECIFIED = 0

            # No sensitive information detected. The resource isn't publicly
            # accessible.
            SENSITIVITY_LOW = 10

            # Unable to determine sensitivity.
            SENSITIVITY_UNKNOWN = 12

            # Medium risk. Contains personally identifiable information (PII),
            # potentially sensitive data, or fields with free-text data that are at a
            # higher risk of having intermittent sensitive data. Consider limiting
            # access.
            SENSITIVITY_MODERATE = 20

            # High risk. Sensitive personally identifiable information (SPII) can be
            # present. Exfiltration of data can lead to user data loss.
            # Re-identification of users might be possible. Consider limiting usage and
            # or removing SPII.
            SENSITIVITY_HIGH = 30
          end
        end

        # A reference to a StoredInfoType to use with scanning.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name of the requested `StoredInfoType`, for example
        #     `organizations/433245324/storedInfoTypes/432452342` or
        #     `projects/project-id/storedInfoTypes/432452342`.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp indicating when the version of the `StoredInfoType` used for
        #     inspection was created. Output-only field, populated by the system.
        class StoredType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Custom information type provided by the user. Used to find domain-specific
        # sensitive information configurable to the data in question.
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     CustomInfoType can either be a new infoType, or an extension of built-in
        #     infoType, when the name matches one of existing infoTypes and that infoType
        #     is specified in `InspectContent.info_types` field. Specifying the latter
        #     adds findings to the one detected by the system. If built-in info type is
        #     not specified in `InspectContent.info_types` list then the name is treated
        #     as a custom info type.
        # @!attribute [rw] likelihood
        #   @return [::Google::Cloud::Dlp::V2::Likelihood]
        #     Likelihood to return for this CustomInfoType. This base value can be
        #     altered by a detection rule if the finding meets the criteria specified by
        #     the rule. Defaults to `VERY_LIKELY` if not specified.
        # @!attribute [rw] dictionary
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Dictionary]
        #     A list of phrases to detect as a CustomInfoType.
        #
        #     Note: The following fields are mutually exclusive: `dictionary`, `regex`, `surrogate_type`, `stored_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] regex
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Regex]
        #     Regular expression based CustomInfoType.
        #
        #     Note: The following fields are mutually exclusive: `regex`, `dictionary`, `surrogate_type`, `stored_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] surrogate_type
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::SurrogateType]
        #     Message for detecting output from deidentification transformations that
        #     support reversing.
        #
        #     Note: The following fields are mutually exclusive: `surrogate_type`, `dictionary`, `regex`, `stored_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] stored_type
        #   @return [::Google::Cloud::Dlp::V2::StoredType]
        #     Load an existing `StoredInfoType` resource for use in
        #     `InspectDataSource`. Not currently supported in `InspectContent`.
        #
        #     Note: The following fields are mutually exclusive: `stored_type`, `dictionary`, `regex`, `surrogate_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] detection_rules
        #   @return [::Array<::Google::Cloud::Dlp::V2::CustomInfoType::DetectionRule>]
        #     Set of detection rules to apply to all findings of this CustomInfoType.
        #     Rules are applied in order that they are specified. Not supported for the
        #     `surrogate_type` CustomInfoType.
        # @!attribute [rw] exclusion_type
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::ExclusionType]
        #     If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
        #     to be returned. It still can be used for rules matching.
        # @!attribute [rw] sensitivity_score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
        #     Sensitivity for this CustomInfoType. If this CustomInfoType extends an
        #     existing InfoType, the sensitivity here will take precedence over that of
        #     the original InfoType. If unset for a CustomInfoType, it will default to
        #     HIGH.
        #     This only applies to data profiling.
        class CustomInfoType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Custom information type based on a dictionary of words or phrases. This can
          # be used to match sensitive information specific to the data, such as a list
          # of employee IDs or job titles.
          #
          # Dictionary words are case-insensitive and all characters other than letters
          # and digits in the unicode [Basic Multilingual
          # Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane)
          # will be replaced with whitespace when scanning for matches, so the
          # dictionary phrase "Sam Johnson" will match all three phrases "sam johnson",
          # "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters
          # surrounding any match must be of a different type than the adjacent
          # characters within the word, so letters must be next to non-letters and
          # digits next to non-digits. For example, the dictionary word "jen" will
          # match the first three letters of the text "jen123" but will return no
          # matches for "jennifer".
          #
          # Dictionary words containing a large number of characters that are not
          # letters or digits may result in unexpected findings because such characters
          # are treated as whitespace. The
          # [limits](https://cloud.google.com/sensitive-data-protection/limits) page
          # contains details about the size limits of dictionaries. For dictionaries
          # that do not fit within these constraints, consider using
          # `LargeCustomDictionaryConfig` in the `StoredInfoType` API.
          # @!attribute [rw] word_list
          #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Dictionary::WordList]
          #     List of words or phrases to search for.
          #
          #     Note: The following fields are mutually exclusive: `word_list`, `cloud_storage_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] cloud_storage_path
          #   @return [::Google::Cloud::Dlp::V2::CloudStoragePath]
          #     Newline-delimited file of words in Cloud Storage. Only a single file
          #     is accepted.
          #
          #     Note: The following fields are mutually exclusive: `cloud_storage_path`, `word_list`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Dictionary
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Message defining a list of words or phrases to search for in the data.
            # @!attribute [rw] words
            #   @return [::Array<::String>]
            #     Words or phrases defining the dictionary. The dictionary must contain
            #     at least one phrase and every phrase must contain at least 2 characters
            #     that are letters or digits. [required]
            class WordList
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Message defining a custom regular expression.
          # @!attribute [rw] pattern
          #   @return [::String]
          #     Pattern defining the regular expression. Its syntax
          #     (https://github.com/google/re2/wiki/Syntax) can be found under the
          #     google/re2 repository on GitHub.
          # @!attribute [rw] group_indexes
          #   @return [::Array<::Integer>]
          #     The index of the submatch to extract as findings. When not
          #     specified, the entire match is returned. No more than 3 may be included.
          class Regex
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message for detecting output from deidentification transformations
          # such as
          # [`CryptoReplaceFfxFpeConfig`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig).
          # These types of transformations are
          # those that perform pseudonymization, thereby producing a "surrogate" as
          # output. This should be used in conjunction with a field on the
          # transformation such as `surrogate_info_type`. This CustomInfoType does
          # not support the use of `detection_rules`.
          class SurrogateType
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Deprecated; use `InspectionRuleSet` instead. Rule for modifying a
          # `CustomInfoType` to alter behavior under certain circumstances, depending
          # on the specific details of the rule. Not supported for the `surrogate_type`
          # custom infoType.
          # @!attribute [rw] hotword_rule
          #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::DetectionRule::HotwordRule]
          #     Hotword-based detection rule.
          class DetectionRule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Message for specifying a window around a finding to apply a detection
            # rule.
            # @!attribute [rw] window_before
            #   @return [::Integer]
            #     Number of characters before the finding to consider. For tabular data,
            #     if you want to modify the likelihood of an entire column of findngs,
            #     set this to 1. For more information, see
            #     [Hotword example: Set the match likelihood of a table column]
            #     (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
            # @!attribute [rw] window_after
            #   @return [::Integer]
            #     Number of characters after the finding to consider.
            class Proximity
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Message for specifying an adjustment to the likelihood of a finding as
            # part of a detection rule.
            # @!attribute [rw] fixed_likelihood
            #   @return [::Google::Cloud::Dlp::V2::Likelihood]
            #     Set the likelihood of a finding to a fixed value.
            #
            #     Note: The following fields are mutually exclusive: `fixed_likelihood`, `relative_likelihood`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] relative_likelihood
            #   @return [::Integer]
            #     Increase or decrease the likelihood by the specified number of
            #     levels. For example, if a finding would be `POSSIBLE` without the
            #     detection rule and `relative_likelihood` is 1, then it is upgraded to
            #     `LIKELY`, while a value of -1 would downgrade it to `UNLIKELY`.
            #     Likelihood may never drop below `VERY_UNLIKELY` or exceed
            #     `VERY_LIKELY`, so applying an adjustment of 1 followed by an
            #     adjustment of -1 when base likelihood is `VERY_LIKELY` will result in
            #     a final likelihood of `LIKELY`.
            #
            #     Note: The following fields are mutually exclusive: `relative_likelihood`, `fixed_likelihood`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class LikelihoodAdjustment
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # The rule that adjusts the likelihood of findings within a certain
            # proximity of hotwords.
            # @!attribute [rw] hotword_regex
            #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Regex]
            #     Regular expression pattern defining what qualifies as a hotword.
            # @!attribute [rw] proximity
            #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::DetectionRule::Proximity]
            #     Range of characters within which the entire hotword must reside.
            #     The total length of the window cannot exceed 1000 characters.
            #     The finding itself will be included in the window, so that hotwords can
            #     be used to match substrings of the finding itself. Suppose you
            #     want Cloud DLP to promote the likelihood of the phone number
            #     regex "\(\d\\{3}\) \d\\{3}-\d\\{4}" if the area code is known to be the
            #     area code of a company's office. In this case, use the hotword regex
            #     "\(xxx\)", where "xxx" is the area code in question.
            #
            #     For tabular data, if you want to modify the likelihood of an entire
            #     column of findngs, see
            #     [Hotword example: Set the match likelihood of a table column]
            #     (https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes-likelihood#match-column-values).
            # @!attribute [rw] likelihood_adjustment
            #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::DetectionRule::LikelihoodAdjustment]
            #     Likelihood adjustment to apply to all matching findings.
            class HotwordRule
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Type of exclusion rule.
          module ExclusionType
            # A finding of this custom info type will not be excluded from results.
            EXCLUSION_TYPE_UNSPECIFIED = 0

            # A finding of this custom info type will be excluded from final results,
            # but can still affect rule execution.
            EXCLUSION_TYPE_EXCLUDE = 1
          end
        end

        # General identifier of a data field in a storage service.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name describing the field.
        class FieldId
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Datastore partition ID.
        # A partition ID identifies a grouping of entities. The grouping is always
        # by project and namespace, however the namespace ID may be empty.
        #
        # A partition ID contains several dimensions:
        # project ID and namespace ID.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The ID of the project to which the entities belong.
        # @!attribute [rw] namespace_id
        #   @return [::String]
        #     If not empty, the ID of the namespace to which the entities belong.
        class PartitionId
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A representation of a Datastore kind.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the kind.
        class KindExpression
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options defining a data set within Google Cloud Datastore.
        # @!attribute [rw] partition_id
        #   @return [::Google::Cloud::Dlp::V2::PartitionId]
        #     A partition ID identifies a grouping of entities. The grouping is always
        #     by project and namespace, however the namespace ID may be empty.
        # @!attribute [rw] kind
        #   @return [::Google::Cloud::Dlp::V2::KindExpression]
        #     The kind to process.
        class DatastoreOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a set of files in a Cloud Storage bucket. Regular
        # expressions are used to allow fine-grained control over which files in the
        # bucket to include.
        #
        # Included files are those that match at least one item in `include_regex` and
        # do not match any items in `exclude_regex`. Note that a file that matches
        # items from both lists will _not_ be included. For a match to occur, the
        # entire file path (i.e., everything in the url after the bucket name) must
        # match the regular expression.
        #
        # For example, given the input `{bucket_name: "mybucket", include_regex:
        # ["directory1/.*"], exclude_regex:
        # ["directory1/excluded.*"]}`:
        #
        # * `gs://mybucket/directory1/myfile` will be included
        # * `gs://mybucket/directory1/directory2/myfile` will be included (`.*` matches
        # across `/`)
        # * `gs://mybucket/directory0/directory1/myfile` will _not_ be included (the
        # full path doesn't match any items in `include_regex`)
        # * `gs://mybucket/directory1/excludedfile` will _not_ be included (the path
        # matches an item in `exclude_regex`)
        #
        # If `include_regex` is left empty, it will match all files by default
        # (this is equivalent to setting `include_regex: [".*"]`).
        #
        # Some other common use cases:
        #
        # * `{bucket_name: "mybucket", exclude_regex: [".*\.pdf"]}` will include all
        # files in `mybucket` except for .pdf files
        # * `{bucket_name: "mybucket", include_regex: ["directory/[^/]+"]}` will
        # include all files directly under `gs://mybucket/directory/`, without matching
        # across `/`
        # @!attribute [rw] bucket_name
        #   @return [::String]
        #     The name of a Cloud Storage bucket. Required.
        # @!attribute [rw] include_regex
        #   @return [::Array<::String>]
        #     A list of regular expressions matching file paths to include. All files in
        #     the bucket that match at least one of these regular expressions will be
        #     included in the set of files, except for those that also match an item in
        #     `exclude_regex`. Leaving this field empty will match all files by default
        #     (this is equivalent to including `.*` in the list).
        #
        #     Regular expressions use RE2
        #     [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
        #     under the google/re2 repository on GitHub.
        # @!attribute [rw] exclude_regex
        #   @return [::Array<::String>]
        #     A list of regular expressions matching file paths to exclude. All files in
        #     the bucket that match at least one of these regular expressions will be
        #     excluded from the scan.
        #
        #     Regular expressions use RE2
        #     [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
        #     under the google/re2 repository on GitHub.
        class CloudStorageRegexFileSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options defining a file or a set of files within a Cloud Storage
        # bucket.
        # @!attribute [rw] file_set
        #   @return [::Google::Cloud::Dlp::V2::CloudStorageOptions::FileSet]
        #     The set of one or more files to scan.
        # @!attribute [rw] bytes_limit_per_file
        #   @return [::Integer]
        #     Max number of bytes to scan from a file. If a scanned file's size is bigger
        #     than this value then the rest of the bytes are omitted. Only one of
        #     `bytes_limit_per_file` and `bytes_limit_per_file_percent` can be specified.
        #     This field can't be set if de-identification is requested. For certain file
        #     types, setting this field has no effect. For more information, see [Limits
        #     on bytes scanned per
        #     file](https://cloud.google.com/sensitive-data-protection/docs/supported-file-types#max-byte-size-per-file).
        # @!attribute [rw] bytes_limit_per_file_percent
        #   @return [::Integer]
        #     Max percentage of bytes to scan from a file. The rest are omitted. The
        #     number of bytes scanned is rounded down. Must be between 0 and 100,
        #     inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one of
        #     bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
        #     This field can't be set if de-identification is requested. For certain file
        #     types, setting this field has no effect. For more information, see [Limits
        #     on bytes scanned per
        #     file](https://cloud.google.com/sensitive-data-protection/docs/supported-file-types#max-byte-size-per-file).
        # @!attribute [rw] file_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::FileType>]
        #     List of file type groups to include in the scan.
        #     If empty, all files are scanned and available data format processors
        #     are applied. In addition, the binary content of the selected files
        #     is always scanned as well.
        #     Images are scanned only as binary if the specified region
        #     does not support image inspection and no file_types were specified.
        #     Image inspection is restricted to 'global', 'us', 'asia', and 'europe'.
        # @!attribute [rw] sample_method
        #   @return [::Google::Cloud::Dlp::V2::CloudStorageOptions::SampleMethod]
        #     How to sample the data.
        # @!attribute [rw] files_limit_percent
        #   @return [::Integer]
        #     Limits the number of files to scan to this percentage of the input FileSet.
        #     Number of files scanned is rounded down. Must be between 0 and 100,
        #     inclusively. Both 0 and 100 means no limit. Defaults to 0.
        class CloudStorageOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Set of files to scan.
          # @!attribute [rw] url
          #   @return [::String]
          #     The Cloud Storage url of the file(s) to scan, in the format
          #     `gs://<bucket>/<path>`. Trailing wildcard in the path is allowed.
          #
          #     If the url ends in a trailing slash, the bucket or directory represented
          #     by the url will be scanned non-recursively (content in sub-directories
          #     will not be scanned). This means that `gs://mybucket/` is equivalent to
          #     `gs://mybucket/*`, and `gs://mybucket/directory/` is equivalent to
          #     `gs://mybucket/directory/*`.
          #
          #     Exactly one of `url` or `regex_file_set` must be set.
          # @!attribute [rw] regex_file_set
          #   @return [::Google::Cloud::Dlp::V2::CloudStorageRegexFileSet]
          #     The regex-filtered set of files to scan. Exactly one of `url` or
          #     `regex_file_set` must be set.
          class FileSet
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # How to sample bytes if not all bytes are scanned. Meaningful only when used
          # in conjunction with bytes_limit_per_file. If not specified, scanning would
          # start from the top.
          module SampleMethod
            # No sampling.
            SAMPLE_METHOD_UNSPECIFIED = 0

            # Scan from the top (default).
            TOP = 1

            # For each file larger than bytes_limit_per_file, randomly pick the offset
            # to start scanning. The scanned bytes are contiguous.
            RANDOM_START = 2
          end
        end

        # Message representing a set of files in Cloud Storage.
        # @!attribute [rw] url
        #   @return [::String]
        #     The url, in the format `gs://<bucket>/<path>`. Trailing wildcard in the
        #     path is allowed.
        class CloudStorageFileSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message representing a single file or path in Cloud Storage.
        # @!attribute [rw] path
        #   @return [::String]
        #     A URL representing a file or path (no wildcards) in Cloud Storage.
        #     Example: `gs://[BUCKET_NAME]/dictionary.txt`
        class CloudStoragePath
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Options defining BigQuery table and row identifiers.
        # @!attribute [rw] table_reference
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     Complete BigQuery table reference.
        # @!attribute [rw] identifying_fields
        #   @return [::Array<::Google::Cloud::Dlp::V2::FieldId>]
        #     Table fields that may uniquely identify a row within the table. When
        #     `actions.saveFindings.outputConfig.table` is specified, the values of
        #     columns specified here are available in the output table under
        #     `location.content_locations.record_location.record_key.id_values`. Nested
        #     fields such as `person.birthdate.year` are allowed.
        # @!attribute [rw] rows_limit
        #   @return [::Integer]
        #     Max number of rows to scan. If the table has more rows than this value, the
        #     rest of the rows are omitted. If not set, or if set to 0, all rows will be
        #     scanned. Only one of rows_limit and rows_limit_percent can be specified.
        #     Cannot be used in conjunction with TimespanConfig.
        # @!attribute [rw] rows_limit_percent
        #   @return [::Integer]
        #     Max percentage of rows to scan. The rest are omitted. The number of rows
        #     scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and
        #     100 means no limit. Defaults to 0. Only one of rows_limit and
        #     rows_limit_percent can be specified. Cannot be used in conjunction with
        #     TimespanConfig.
        #
        #     Caution: A [known
        #     issue](https://cloud.google.com/sensitive-data-protection/docs/known-issues#bq-sampling)
        #     is causing the `rowsLimitPercent` field to behave unexpectedly. We
        #     recommend using `rowsLimit` instead.
        # @!attribute [rw] sample_method
        #   @return [::Google::Cloud::Dlp::V2::BigQueryOptions::SampleMethod]
        #     How to sample the data.
        # @!attribute [rw] excluded_fields
        #   @return [::Array<::Google::Cloud::Dlp::V2::FieldId>]
        #     References to fields excluded from scanning. This allows you to skip
        #     inspection of entire columns which you know have no findings.
        #     When inspecting a table, we recommend that you inspect all columns.
        #     Otherwise, findings might be affected because hints from excluded columns
        #     will not be used.
        # @!attribute [rw] included_fields
        #   @return [::Array<::Google::Cloud::Dlp::V2::FieldId>]
        #     Limit scanning only to these fields.
        #     When inspecting a table, we recommend that you inspect all columns.
        #     Otherwise, findings might be affected because hints from excluded columns
        #     will not be used.
        class BigQueryOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # How to sample rows if not all rows are scanned. Meaningful only when used
          # in conjunction with either rows_limit or rows_limit_percent. If not
          # specified, rows are scanned in the order BigQuery reads them.
          module SampleMethod
            # No sampling.
            SAMPLE_METHOD_UNSPECIFIED = 0

            # Scan groups of rows in the order BigQuery provides (default). Multiple
            # groups of rows may be scanned in parallel, so results may not appear in
            # the same order the rows are read.
            TOP = 1

            # Randomly pick groups of rows to scan.
            RANDOM_START = 2
          end
        end

        # Shared message indicating Cloud storage type.
        # @!attribute [rw] datastore_options
        #   @return [::Google::Cloud::Dlp::V2::DatastoreOptions]
        #     Google Cloud Datastore options.
        #
        #     Note: The following fields are mutually exclusive: `datastore_options`, `cloud_storage_options`, `big_query_options`, `hybrid_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_storage_options
        #   @return [::Google::Cloud::Dlp::V2::CloudStorageOptions]
        #     Cloud Storage options.
        #
        #     Note: The following fields are mutually exclusive: `cloud_storage_options`, `datastore_options`, `big_query_options`, `hybrid_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] big_query_options
        #   @return [::Google::Cloud::Dlp::V2::BigQueryOptions]
        #     BigQuery options.
        #
        #     Note: The following fields are mutually exclusive: `big_query_options`, `datastore_options`, `cloud_storage_options`, `hybrid_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] hybrid_options
        #   @return [::Google::Cloud::Dlp::V2::HybridOptions]
        #     Hybrid inspection options.
        #
        #     Note: The following fields are mutually exclusive: `hybrid_options`, `datastore_options`, `cloud_storage_options`, `big_query_options`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] timespan_config
        #   @return [::Google::Cloud::Dlp::V2::StorageConfig::TimespanConfig]
        #     Configuration of the timespan of the items to include in scanning.
        class StorageConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration of the timespan of the items to include in scanning.
          # Currently only supported when inspecting Cloud Storage and BigQuery.
          # @!attribute [rw] start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Exclude files, tables, or rows older than this value.
          #     If not set, no lower time limit is applied.
          # @!attribute [rw] end_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Exclude files, tables, or rows newer than this value.
          #     If not set, no upper time limit is applied.
          # @!attribute [rw] timestamp_field
          #   @return [::Google::Cloud::Dlp::V2::FieldId]
          #     Specification of the field containing the timestamp of scanned items.
          #     Used for data sources like Datastore and BigQuery.
          #
          #     **For BigQuery**
          #
          #     If this value is not specified and the table was modified between the
          #     given start and end times, the entire table will be scanned. If this
          #     value is specified, then rows are filtered based on the given start and
          #     end times. Rows with a `NULL` value in the provided BigQuery column are
          #     skipped.
          #     Valid data types of the provided BigQuery column are: `INTEGER`, `DATE`,
          #     `TIMESTAMP`, and `DATETIME`.
          #
          #     If your BigQuery table is [partitioned at ingestion
          #     time](https://cloud.google.com/bigquery/docs/partitioned-tables#ingestion_time),
          #     you can use any of the following pseudo-columns as your timestamp field.
          #     When used with Cloud DLP, these pseudo-column names are case sensitive.
          #
          #     - `_PARTITIONTIME`
          #     - `_PARTITIONDATE`
          #     - `_PARTITION_LOAD_TIME`
          #
          #     **For Datastore**
          #
          #     If this value is specified, then entities are filtered based on the given
          #     start and end times. If an entity does not contain the provided timestamp
          #     property or contains empty or invalid values, then it is included.
          #     Valid data types of the provided timestamp property are: `TIMESTAMP`.
          #
          #     See the
          #     [known
          #     issue](https://cloud.google.com/sensitive-data-protection/docs/known-issues#bq-timespan)
          #     related to this operation.
          # @!attribute [rw] enable_auto_population_of_timespan_config
          #   @return [::Boolean]
          #     When the job is started by a JobTrigger we will automatically figure out
          #     a valid start_time to avoid scanning files that have not been modified
          #     since the last time the JobTrigger executed. This will be based on the
          #     time of the execution of the last run of the JobTrigger or the timespan
          #     end_time used in the last run of the JobTrigger.
          #
          #     **For BigQuery**
          #
          #     Inspect jobs triggered by automatic population will scan data that is at
          #     least three hours old when the job starts. This is because streaming
          #     buffer rows are not read during inspection and reading up to the current
          #     timestamp will result in skipped rows.
          #
          #     See the [known
          #     issue](https://cloud.google.com/sensitive-data-protection/docs/known-issues#recently-streamed-data)
          #     related to this operation.
          class TimespanConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration to control jobs where the content being inspected is outside
        # of Google Cloud Platform.
        # @!attribute [rw] description
        #   @return [::String]
        #     A short description of where the data is coming from. Will be stored once
        #     in the job. 256 max length.
        # @!attribute [rw] required_finding_label_keys
        #   @return [::Array<::String>]
        #     These are labels that each inspection request must include within their
        #     'finding_labels' map. Request may contain others, but any missing one of
        #     these will be rejected.
        #
        #     Label keys must be between 1 and 63 characters long and must conform
        #     to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
        #
        #     No more than 10 keys can be required.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     To organize findings, these labels will be added to each finding.
        #
        #     Label keys must be between 1 and 63 characters long and must conform
        #     to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
        #
        #     Label values must be between 0 and 63 characters long and must conform
        #     to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
        #
        #     No more than 10 labels can be associated with a given finding.
        #
        #     Examples:
        #
        #     * `"environment" : "production"`
        #     * `"pipeline" : "etl"`
        # @!attribute [rw] table_options
        #   @return [::Google::Cloud::Dlp::V2::TableOptions]
        #     If the container is a table, additional information to make findings
        #     meaningful such as the columns that are primary keys.
        class HybridOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Row key for identifying a record in BigQuery table.
        # @!attribute [rw] table_reference
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     Complete BigQuery table reference.
        # @!attribute [rw] row_number
        #   @return [::Integer]
        #     Row number inferred at the time the table was scanned. This value is
        #     nondeterministic, cannot be queried, and may be null for inspection
        #     jobs. To locate findings within a table, specify
        #     `inspect_job.storage_config.big_query_options.identifying_fields` in
        #     `CreateDlpJobRequest`.
        class BigQueryKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Record key for a finding in Cloud Datastore.
        # @!attribute [rw] entity_key
        #   @return [::Google::Cloud::Dlp::V2::Key]
        #     Datastore entity key.
        class DatastoreKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A unique identifier for a Datastore entity.
        # If a key's partition ID or any of its path kinds or names are
        # reserved/read-only, the key is reserved/read-only.
        # A reserved/read-only key is forbidden in certain documented contexts.
        # @!attribute [rw] partition_id
        #   @return [::Google::Cloud::Dlp::V2::PartitionId]
        #     Entities are partitioned into subsets, currently identified by a project
        #     ID and namespace ID.
        #     Queries are scoped to a single partition.
        # @!attribute [rw] path
        #   @return [::Array<::Google::Cloud::Dlp::V2::Key::PathElement>]
        #     The entity path.
        #     An entity path consists of one or more elements composed of a kind and a
        #     string or numerical identifier, which identify entities. The first
        #     element identifies a _root entity_, the second element identifies
        #     a _child_ of the root entity, the third element identifies a child of the
        #     second entity, and so forth. The entities identified by all prefixes of
        #     the path are called the element's _ancestors_.
        #
        #     A path can never be empty, and a path can have at most 100 elements.
        class Key
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A (kind, ID/name) pair used to construct a key path.
          #
          # If either name or ID is set, the element is complete.
          # If neither is set, the element is incomplete.
          # @!attribute [rw] kind
          #   @return [::String]
          #     The kind of the entity.
          #     A kind matching regex `__.*__` is reserved/read-only.
          #     A kind must not contain more than 1500 bytes when UTF-8 encoded.
          #     Cannot be `""`.
          # @!attribute [rw] id
          #   @return [::Integer]
          #     The auto-allocated ID of the entity.
          #     Never equal to zero. Values less than zero are discouraged and may not
          #     be supported in the future.
          #
          #     Note: The following fields are mutually exclusive: `id`, `name`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] name
          #   @return [::String]
          #     The name of the entity.
          #     A name matching regex `__.*__` is reserved/read-only.
          #     A name must not be more than 1500 bytes when UTF-8 encoded.
          #     Cannot be `""`.
          #
          #     Note: The following fields are mutually exclusive: `name`, `id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class PathElement
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Message for a unique key indicating a record that contains a finding.
        # @!attribute [rw] datastore_key
        #   @return [::Google::Cloud::Dlp::V2::DatastoreKey]
        #     BigQuery key
        #
        #     Note: The following fields are mutually exclusive: `datastore_key`, `big_query_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] big_query_key
        #   @return [::Google::Cloud::Dlp::V2::BigQueryKey]
        #     Datastore key
        #
        #     Note: The following fields are mutually exclusive: `big_query_key`, `datastore_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] id_values
        #   @return [::Array<::String>]
        #     Values of identifying columns in the given row. Order of values matches
        #     the order of `identifying_fields` specified in the scanning request.
        class RecordKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message defining the location of a BigQuery table. A table is uniquely
        # identified  by its project_id, dataset_id, and table_name. Within a query
        # a table is often referenced with a string in the format of:
        # `<project_id>:<dataset_id>.<table_id>` or
        # `<project_id>.<dataset_id>.<table_id>`.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The Google Cloud project ID of the project containing the table.
        #     If omitted, project ID is inferred from the API call.
        # @!attribute [rw] dataset_id
        #   @return [::String]
        #     Dataset ID of the table.
        # @!attribute [rw] table_id
        #   @return [::String]
        #     Name of the table.
        class BigQueryTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message defining the location of a BigQuery table with the projectId inferred
        # from the parent project.
        # @!attribute [rw] dataset_id
        #   @return [::String]
        #     Dataset ID of the table.
        # @!attribute [rw] table_id
        #   @return [::String]
        #     Name of the table.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The Google Cloud project ID of the project containing the table.
        #     If omitted, the project ID is inferred from the parent project. This field
        #     is required if the parent resource is an organization.
        class TableReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message defining a field of a BigQuery table.
        # @!attribute [rw] table
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     Source table of the field.
        # @!attribute [rw] field
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     Designated field in the BigQuery table.
        class BigQueryField
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An entity in a dataset is a field or set of fields that correspond to a
        # single person. For example, in medical records the `EntityId` might be a
        # patient identifier, or for financial records it might be an account
        # identifier. This message is used when generalizations or analysis must take
        # into account that multiple rows correspond to the same entity.
        # @!attribute [rw] field
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     Composite key indicating which field contains the entity identifier.
        class EntityId
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Instructions regarding the table content being inspected.
        # @!attribute [rw] identifying_fields
        #   @return [::Array<::Google::Cloud::Dlp::V2::FieldId>]
        #     The columns that are the primary keys for table objects included in
        #     ContentItem. A copy of this cell's value will stored alongside alongside
        #     each finding so that the finding can be traced to the specific row it came
        #     from. No more than 3 may be provided.
        class TableOptions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Coarse-grained confidence level of how well a particular finding
        # satisfies the criteria to match a particular infoType.
        #
        # Likelihood is calculated based on the number of signals a
        # finding has that implies that the finding matches the infoType. For
        # example, a string that has an '@' and a '.com' is more likely to be a
        # match for an email address than a string that only has an '@'.
        #
        # In general, the highest likelihood level has the strongest signals that
        # indicate a match. That is, a finding with a high likelihood has a low chance
        # of being a false positive.
        #
        # For more information about each likelihood level
        # and how likelihood works, see [Match
        # likelihood](https://cloud.google.com/sensitive-data-protection/docs/likelihood).
        module Likelihood
          # Default value; same as POSSIBLE.
          LIKELIHOOD_UNSPECIFIED = 0

          # Highest chance of a false positive.
          VERY_UNLIKELY = 1

          # High chance of a false positive.
          UNLIKELY = 2

          # Some matching signals. The default value.
          POSSIBLE = 3

          # Low chance of a false positive.
          LIKELY = 4

          # Confidence level is high. Lowest chance of a false positive.
          VERY_LIKELY = 5
        end

        # Definitions of file type groups to scan. New types will be added to this
        # list.
        module FileType
          # Includes all files.
          FILE_TYPE_UNSPECIFIED = 0

          # Includes all file extensions not covered by another entry. Binary
          # scanning attempts to convert the content of the file to utf_8 to scan
          # the file.
          # If you wish to avoid this fall back, specify one or more of the other
          # file types in your storage scan.
          BINARY_FILE = 1

          # Included file extensions:
          #   asc,asp, aspx, brf, c, cc,cfm, cgi, cpp, csv, cxx, c++, cs, css, dart,
          #   dat, dot, eml,, epbub, ged, go, h, hh, hpp, hxx, h++, hs, html, htm,
          #   mkd, markdown, m, ml, mli, perl, pl, plist, pm, php, phtml, pht,
          #   properties, py, pyw, rb, rbw, rs, rss,  rc, scala, sh, sql, swift, tex,
          #   shtml, shtm, xhtml, lhs, ics, ini, java, js, json, jsonl, kix, kml,
          #   ocaml, md, txt, text, tsv, vb, vcard, vcs, wml, xcodeproj, xml, xsl, xsd,
          #   yml, yaml.
          TEXT_FILE = 2

          # Included file extensions:
          #   bmp, gif, jpg, jpeg, jpe, png. Setting
          # {::Google::Cloud::Dlp::V2::CloudStorageOptions#bytes_limit_per_file bytes_limit_per_file}
          # or
          # {::Google::Cloud::Dlp::V2::CloudStorageOptions#bytes_limit_per_file bytes_limit_per_file_percent}
          # has no effect on image files. Image inspection is restricted to the
          # `global`, `us`, `asia`, and `europe` regions.
          IMAGE = 3

          # Microsoft Word files larger than 30 MB will be scanned as binary files.
          # Included file extensions:
          #   docx, dotx, docm, dotm. Setting `bytes_limit_per_file` or
          #   `bytes_limit_per_file_percent` has no effect on Word files.
          WORD = 5

          # PDF files larger than 30 MB will be scanned as binary files.
          # Included file extensions:
          #   pdf. Setting `bytes_limit_per_file` or `bytes_limit_per_file_percent`
          # has no effect on PDF files.
          PDF = 6

          # Included file extensions:
          #   avro
          AVRO = 7

          # Included file extensions:
          #   csv
          CSV = 8

          # Included file extensions:
          #   tsv
          TSV = 9

          # Microsoft PowerPoint files larger than 30 MB will be scanned as binary
          # files. Included file extensions:
          #   pptx, pptm, potx, potm, pot. Setting `bytes_limit_per_file` or
          #   `bytes_limit_per_file_percent` has no effect on PowerPoint files.
          POWERPOINT = 11

          # Microsoft Excel files larger than 30 MB will be scanned as binary files.
          # Included file extensions:
          #   xlsx, xlsm, xltx, xltm. Setting `bytes_limit_per_file` or
          #   `bytes_limit_per_file_percent` has no effect on Excel files.
          EXCEL = 12
        end
      end
    end
  end
end
