# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dlp
      module V2
        # List of excluded infoTypes.
        # @!attribute [rw] info_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::InfoType>]
        #     InfoType list in ExclusionRule rule drops a finding when it overlaps or
        #     contained within with a finding of an infoType from this list. For
        #     example, for `InspectionRuleSet.info_types` containing "PHONE_NUMBER"` and
        #     `exclusion_rule` containing `exclude_info_types.info_types` with
        #     "EMAIL_ADDRESS" the phone number findings are dropped if they overlap
        #     with EMAIL_ADDRESS finding.
        #     That leads to "555-222-2222@example.org" to generate only a single
        #     finding, namely email address.
        class ExcludeInfoTypes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The rule to exclude findings based on a hotword. For record inspection of
        # tables, column names are considered hotwords. An example of this is to
        # exclude a finding if it belongs to a BigQuery column that matches a specific
        # pattern.
        # @!attribute [rw] hotword_regex
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Regex]
        #     Regular expression pattern defining what qualifies as a hotword.
        # @!attribute [rw] proximity
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::DetectionRule::Proximity]
        #     Range of characters within which the entire hotword must reside.
        #     The total length of the window cannot exceed 1000 characters.
        #     The windowBefore property in proximity should be set to 1 if the hotword
        #     needs to be included in a column header.
        class ExcludeByHotword
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The rule that specifies conditions when findings of infoTypes specified in
        # `InspectionRuleSet` are removed from results.
        # @!attribute [rw] dictionary
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Dictionary]
        #     Dictionary which defines the rule.
        #
        #     Note: The following fields are mutually exclusive: `dictionary`, `regex`, `exclude_info_types`, `exclude_by_hotword`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] regex
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Regex]
        #     Regular expression which defines the rule.
        #
        #     Note: The following fields are mutually exclusive: `regex`, `dictionary`, `exclude_info_types`, `exclude_by_hotword`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclude_info_types
        #   @return [::Google::Cloud::Dlp::V2::ExcludeInfoTypes]
        #     Set of infoTypes for which findings would affect this rule.
        #
        #     Note: The following fields are mutually exclusive: `exclude_info_types`, `dictionary`, `regex`, `exclude_by_hotword`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclude_by_hotword
        #   @return [::Google::Cloud::Dlp::V2::ExcludeByHotword]
        #     Drop if the hotword rule is contained in the proximate context. For
        #     tabular data, the context includes the column name.
        #
        #     Note: The following fields are mutually exclusive: `exclude_by_hotword`, `dictionary`, `regex`, `exclude_info_types`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] matching_type
        #   @return [::Google::Cloud::Dlp::V2::MatchingType]
        #     How the rule is applied, see MatchingType documentation for details.
        class ExclusionRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single inspection rule to be applied to infoTypes, specified in
        # `InspectionRuleSet`.
        # @!attribute [rw] hotword_rule
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::DetectionRule::HotwordRule]
        #     Hotword-based detection rule.
        #
        #     Note: The following fields are mutually exclusive: `hotword_rule`, `exclusion_rule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] exclusion_rule
        #   @return [::Google::Cloud::Dlp::V2::ExclusionRule]
        #     Exclusion rule.
        #
        #     Note: The following fields are mutually exclusive: `exclusion_rule`, `hotword_rule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class InspectionRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Rule set for modifying a set of infoTypes to alter behavior under certain
        # circumstances, depending on the specific details of the rules within the set.
        # @!attribute [rw] info_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::InfoType>]
        #     List of infoTypes this rule set is applied to.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::Dlp::V2::InspectionRule>]
        #     Set of rules to be applied to infoTypes. The rules are applied in order.
        class InspectionRuleSet
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration description of the scanning process.
        # When used with redactContent only info_types and min_likelihood are currently
        # used.
        # @!attribute [rw] info_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::InfoType>]
        #     Restricts what info_types to look for. The values must correspond to
        #     InfoType values returned by ListInfoTypes or listed at
        #     https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference.
        #
        #     When no InfoTypes or CustomInfoTypes are specified in a request, the
        #     system may automatically choose a default list of detectors to run, which
        #     may change over time.
        #
        #     If you need precise control and predictability as to what detectors are
        #     run you should specify specific InfoTypes listed in the reference,
        #     otherwise a default list will be used, which may change over time.
        # @!attribute [rw] min_likelihood
        #   @return [::Google::Cloud::Dlp::V2::Likelihood]
        #     Only returns findings equal to or above this threshold. The default is
        #     POSSIBLE.
        #
        #     In general, the highest likelihood setting yields the fewest findings in
        #     results and the lowest chance of a false positive. For more information,
        #     see [Match
        #     likelihood](https://cloud.google.com/sensitive-data-protection/docs/likelihood).
        # @!attribute [rw] min_likelihood_per_info_type
        #   @return [::Array<::Google::Cloud::Dlp::V2::InspectConfig::InfoTypeLikelihood>]
        #     Minimum likelihood per infotype. For each infotype, a user can specify a
        #     minimum likelihood. The system only returns a finding if its likelihood is
        #     above this threshold. If this field is not set, the system uses the
        #     InspectConfig min_likelihood.
        # @!attribute [rw] limits
        #   @return [::Google::Cloud::Dlp::V2::InspectConfig::FindingLimits]
        #     Configuration to control the number of findings returned.
        #     This is not used for data profiling.
        #
        #     When redacting sensitive data from images, finding limits don't apply. They
        #     can cause unexpected or inconsistent results, where only some data is
        #     redacted. Don't include finding limits in
        #     {::Google::Cloud::Dlp::V2::DlpService::Client#redact_image RedactImage}
        #     requests. Otherwise, Cloud DLP returns an error.
        #
        #     When set within an
        #     {::Google::Cloud::Dlp::V2::InspectJobConfig InspectJobConfig}, the specified
        #     maximum values aren't hard limits. If an inspection job reaches these
        #     limits, the job ends gradually, not abruptly. Therefore, the actual number
        #     of findings that Cloud DLP returns can be multiple times higher than these
        #     maximum values.
        # @!attribute [rw] include_quote
        #   @return [::Boolean]
        #     When true, a contextual quote from the data that triggered a finding is
        #     included in the response; see
        #     {::Google::Cloud::Dlp::V2::Finding#quote Finding.quote}. This is not used for
        #     data profiling.
        # @!attribute [rw] exclude_info_types
        #   @return [::Boolean]
        #     When true, excludes type information of the findings.
        #     This is not used for data profiling.
        # @!attribute [rw] custom_info_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::CustomInfoType>]
        #     CustomInfoTypes provided by the user. See
        #     https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes
        #     to learn more.
        # @!attribute [rw] content_options
        #   @return [::Array<::Google::Cloud::Dlp::V2::ContentOption>]
        #     Deprecated and unused.
        # @!attribute [rw] rule_set
        #   @return [::Array<::Google::Cloud::Dlp::V2::InspectionRuleSet>]
        #     Set of rules to apply to the findings for this InspectConfig.
        #     Exclusion rules, contained in the set are executed in the end, other
        #     rules are executed in the order they are specified for each info type.
        class InspectConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for setting a minimum likelihood per infotype. Used to
          # customize the minimum likelihood level for specific infotypes in the
          # request. For example, use this if you want to lower the precision for
          # PERSON_NAME without lowering the precision for the other infotypes in the
          # request.
          # @!attribute [rw] info_type
          #   @return [::Google::Cloud::Dlp::V2::InfoType]
          #     Type of information the likelihood threshold applies to. Only one
          #     likelihood per info_type should be provided. If InfoTypeLikelihood does
          #     not have an info_type, the configuration fails.
          # @!attribute [rw] min_likelihood
          #   @return [::Google::Cloud::Dlp::V2::Likelihood]
          #     Only returns findings equal to or above this threshold. This field is
          #     required or else the configuration fails.
          class InfoTypeLikelihood
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration to control the number of findings returned for inspection.
          # This is not used for de-identification or data profiling.
          #
          # When redacting sensitive data from images, finding limits don't apply. They
          # can cause unexpected or inconsistent results, where only some data is
          # redacted. Don't include finding limits in
          # {::Google::Cloud::Dlp::V2::DlpService::Client#redact_image RedactImage}
          # requests. Otherwise, Cloud DLP returns an error.
          # @!attribute [rw] max_findings_per_item
          #   @return [::Integer]
          #     Max number of findings that are returned for each item scanned.
          #
          #     When set within an
          #     {::Google::Cloud::Dlp::V2::InspectContentRequest InspectContentRequest},
          #     this field is ignored.
          #
          #     This value isn't a hard limit. If the number of findings for an item
          #     reaches this limit, the inspection of that item ends gradually, not
          #     abruptly. Therefore, the actual number of findings that Cloud DLP returns
          #     for the item can be multiple times higher than this value.
          # @!attribute [rw] max_findings_per_request
          #   @return [::Integer]
          #     Max number of findings that are returned per request or job.
          #
          #     If you set this field in an
          #     {::Google::Cloud::Dlp::V2::InspectContentRequest InspectContentRequest}, the
          #     resulting maximum value is the value that you set or 3,000, whichever is
          #     lower.
          #
          #     This value isn't a hard limit. If an inspection reaches this limit, the
          #     inspection ends gradually, not abruptly. Therefore, the actual number of
          #     findings that Cloud DLP returns can be multiple times higher than this
          #     value.
          # @!attribute [rw] max_findings_per_info_type
          #   @return [::Array<::Google::Cloud::Dlp::V2::InspectConfig::FindingLimits::InfoTypeLimit>]
          #     Configuration of findings limit given for specified infoTypes.
          class FindingLimits
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Max findings configuration per infoType, per content item or long
            # running DlpJob.
            # @!attribute [rw] info_type
            #   @return [::Google::Cloud::Dlp::V2::InfoType]
            #     Type of information the findings limit applies to. Only one limit per
            #     info_type should be provided. If InfoTypeLimit does not have an
            #     info_type, the DLP API applies the limit against all info_types that
            #     are found but not specified in another InfoTypeLimit.
            # @!attribute [rw] max_findings
            #   @return [::Integer]
            #     Max findings limit for the given infoType.
            class InfoTypeLimit
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # Container for bytes to inspect or redact.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dlp::V2::ByteContentItem::BytesType]
        #     The type of data stored in the bytes string. Default will be TEXT_UTF8.
        # @!attribute [rw] data
        #   @return [::String]
        #     Content data to inspect or redact.
        class ByteContentItem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The type of data being sent for inspection. To learn more, see
          # [Supported file
          # types](https://cloud.google.com/sensitive-data-protection/docs/supported-file-types).
          #
          # Only the first frame of each multiframe image is inspected. Metadata and
          # other frames aren't inspected.
          module BytesType
            # Unused
            BYTES_TYPE_UNSPECIFIED = 0

            # Any image type.
            IMAGE = 6

            # jpeg
            IMAGE_JPEG = 1

            # bmp
            IMAGE_BMP = 2

            # png
            IMAGE_PNG = 3

            # svg
            IMAGE_SVG = 4

            # plain text
            TEXT_UTF8 = 5

            # docx, docm, dotx, dotm
            WORD_DOCUMENT = 7

            # pdf
            PDF = 8

            # pptx, pptm, potx, potm, pot
            POWERPOINT_DOCUMENT = 9

            # xlsx, xlsm, xltx, xltm
            EXCEL_DOCUMENT = 10

            # avro
            AVRO = 11

            # csv
            CSV = 12

            # tsv
            TSV = 13

            # Audio file types. Only used for profiling.
            AUDIO = 15

            # Video file types. Only used for profiling.
            VIDEO = 16

            # Executable file types. Only used for profiling.
            EXECUTABLE = 17

            # AI model file types. Only used for profiling.
            AI_MODEL = 18
          end
        end

        # Type of content to inspect.
        # @!attribute [rw] value
        #   @return [::String]
        #     String data to inspect or redact.
        #
        #     Note: The following fields are mutually exclusive: `value`, `table`, `byte_item`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] table
        #   @return [::Google::Cloud::Dlp::V2::Table]
        #     Structured content for inspection. See
        #     https://cloud.google.com/sensitive-data-protection/docs/inspecting-text#inspecting_a_table
        #     to learn more.
        #
        #     Note: The following fields are mutually exclusive: `table`, `value`, `byte_item`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] byte_item
        #   @return [::Google::Cloud::Dlp::V2::ByteContentItem]
        #     Content data to inspect or redact. Replaces `type` and `data`.
        #
        #     Note: The following fields are mutually exclusive: `byte_item`, `value`, `table`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ContentItem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Structured content to inspect. Up to 50,000 `Value`s per request allowed. See
        # https://cloud.google.com/sensitive-data-protection/docs/inspecting-structured-text#inspecting_a_table
        # to learn more.
        # @!attribute [rw] headers
        #   @return [::Array<::Google::Cloud::Dlp::V2::FieldId>]
        #     Headers of the table.
        # @!attribute [rw] rows
        #   @return [::Array<::Google::Cloud::Dlp::V2::Table::Row>]
        #     Rows of the table.
        class Table
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Values of the row.
          # @!attribute [rw] values
          #   @return [::Array<::Google::Cloud::Dlp::V2::Value>]
          #     Individual cells.
          class Row
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # All the findings for a single scanned item.
        # @!attribute [rw] findings
        #   @return [::Array<::Google::Cloud::Dlp::V2::Finding>]
        #     List of findings for an item.
        # @!attribute [rw] findings_truncated
        #   @return [::Boolean]
        #     If true, then this item might have more findings than were returned,
        #     and the findings returned are an arbitrary subset of all findings.
        #     The findings list might be truncated because the input items were too
        #     large, or because the server reached the maximum amount of resources
        #     allowed for a single API call. For best results, divide the input into
        #     smaller batches.
        class InspectResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a piece of potentially sensitive content.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name in format
        #     projects/\\{project}/locations/\\{location}/findings/\\{finding} Populated only
        #     when viewing persisted findings.
        # @!attribute [rw] quote
        #   @return [::String]
        #     The content that was found. Even if the content is not textual, it
        #     may be converted to a textual representation here.
        #     Provided if `include_quote` is true and the finding is
        #     less than or equal to 4096 bytes long. If the finding exceeds 4096 bytes
        #     in length, the quote may be omitted.
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     The type of content that might have been found.
        #     Provided if `excluded_types` is false.
        # @!attribute [rw] likelihood
        #   @return [::Google::Cloud::Dlp::V2::Likelihood]
        #     Confidence of how likely it is that the `info_type` is correct.
        # @!attribute [rw] location
        #   @return [::Google::Cloud::Dlp::V2::Location]
        #     Where the content was found.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp when finding was detected.
        # @!attribute [rw] quote_info
        #   @return [::Google::Cloud::Dlp::V2::QuoteInfo]
        #     Contains data parsed from quotes. Only populated if include_quote was set
        #     to true and a supported infoType was requested. Currently supported
        #     infoTypes: DATE, DATE_OF_BIRTH and TIME.
        # @!attribute [rw] resource_name
        #   @return [::String]
        #     The job that stored the finding.
        # @!attribute [rw] trigger_name
        #   @return [::String]
        #     Job trigger name, if applicable, for this finding.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels associated with this `Finding`.
        #
        #     Label keys must be between 1 and 63 characters long and must conform
        #     to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
        #
        #     Label values must be between 0 and 63 characters long and must conform
        #     to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
        #
        #     No more than 10 labels can be associated with a given finding.
        #
        #     Examples:
        #
        #     * `"environment" : "production"`
        #     * `"pipeline" : "etl"`
        # @!attribute [rw] job_create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time the job started that produced this finding.
        # @!attribute [rw] job_name
        #   @return [::String]
        #     The job that stored the finding.
        # @!attribute [rw] finding_id
        #   @return [::String]
        #     The unique finding id.
        class Finding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Specifies the location of the finding.
        # @!attribute [rw] byte_range
        #   @return [::Google::Cloud::Dlp::V2::Range]
        #     Zero-based byte offsets delimiting the finding.
        #     These are relative to the finding's containing element.
        #     Note that when the content is not textual, this references
        #     the UTF-8 encoded textual representation of the content.
        #     Omitted if content is an image.
        # @!attribute [rw] codepoint_range
        #   @return [::Google::Cloud::Dlp::V2::Range]
        #     Unicode character offsets delimiting the finding.
        #     These are relative to the finding's containing element.
        #     Provided when the content is text.
        # @!attribute [rw] content_locations
        #   @return [::Array<::Google::Cloud::Dlp::V2::ContentLocation>]
        #     List of nested objects pointing to the precise location of the finding
        #     within the file or record.
        # @!attribute [rw] container
        #   @return [::Google::Cloud::Dlp::V2::Container]
        #     Information about the container where this finding occurred, if available.
        class Location
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Precise location of the finding within a document, record, image, or metadata
        # container.
        # @!attribute [rw] container_name
        #   @return [::String]
        #     Name of the container where the finding is located.
        #     The top level name is the source file name or table name. Names of some
        #     common storage containers are formatted as follows:
        #
        #     * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
        #     * Cloud Storage files: `gs://{bucket}/{path}`
        #     * Datastore namespace: \\{namespace}
        #
        #     Nested names could be absent if the embedded object has no string
        #     identifier (for example, an image contained within a document).
        # @!attribute [rw] record_location
        #   @return [::Google::Cloud::Dlp::V2::RecordLocation]
        #     Location within a row or record of a database table.
        #
        #     Note: The following fields are mutually exclusive: `record_location`, `image_location`, `document_location`, `metadata_location`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image_location
        #   @return [::Google::Cloud::Dlp::V2::ImageLocation]
        #     Location within an image's pixels.
        #
        #     Note: The following fields are mutually exclusive: `image_location`, `record_location`, `document_location`, `metadata_location`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] document_location
        #   @return [::Google::Cloud::Dlp::V2::DocumentLocation]
        #     Location data for document files.
        #
        #     Note: The following fields are mutually exclusive: `document_location`, `record_location`, `image_location`, `metadata_location`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] metadata_location
        #   @return [::Google::Cloud::Dlp::V2::MetadataLocation]
        #     Location within the metadata for inspected content.
        #
        #     Note: The following fields are mutually exclusive: `metadata_location`, `record_location`, `image_location`, `document_location`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] container_timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Finding container modification timestamp, if applicable. For Cloud Storage,
        #     this field contains the last file modification timestamp. For a BigQuery
        #     table, this field contains the last_modified_time property. For Datastore,
        #     this field isn't populated.
        # @!attribute [rw] container_version
        #   @return [::String]
        #     Finding container version, if available
        #     ("generation" for Cloud Storage).
        class ContentLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Metadata Location
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dlp::V2::MetadataType]
        #     Type of metadata containing the finding.
        # @!attribute [rw] storage_label
        #   @return [::Google::Cloud::Dlp::V2::StorageMetadataLabel]
        #     Storage metadata.
        class MetadataLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Storage metadata label to indicate which metadata entry contains findings.
        # @!attribute [rw] key
        #   @return [::String]
        #     Label name.
        class StorageMetadataLabel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of a finding within a document.
        # @!attribute [rw] file_offset
        #   @return [::Integer]
        #     Offset of the line, from the beginning of the file, where the finding
        #     is located.
        class DocumentLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of a finding within a row or record.
        # @!attribute [rw] record_key
        #   @return [::Google::Cloud::Dlp::V2::RecordKey]
        #     Key of the finding.
        # @!attribute [rw] field_id
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     Field id of the field containing the finding.
        # @!attribute [rw] table_location
        #   @return [::Google::Cloud::Dlp::V2::TableLocation]
        #     Location within a `ContentItem.Table`.
        class RecordLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of a finding within a table.
        # @!attribute [rw] row_index
        #   @return [::Integer]
        #     The zero-based index of the row where the finding is located. Only
        #     populated for resources that have a natural ordering, not BigQuery. In
        #     BigQuery, to identify the row a finding came from, populate
        #     BigQueryOptions.identifying_fields with your primary key column names and
        #     when you store the findings the value of those columns will be stored
        #     inside of Finding.
        class TableLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents a container that may contain DLP findings.
        # Examples of a container include a file, table, or database record.
        # @!attribute [rw] type
        #   @return [::String]
        #     Container type, for example BigQuery or Cloud Storage.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project where the finding was found.
        #     Can be different from the project that owns the finding.
        # @!attribute [rw] full_path
        #   @return [::String]
        #     A string representation of the full container name.
        #     Examples:
        #     - BigQuery: 'Project:DataSetId.TableId'
        #     - Cloud Storage: 'gs://Bucket/folders/filename.txt'
        # @!attribute [rw] root_path
        #   @return [::String]
        #     The root of the container.
        #     Examples:
        #
        #     - For BigQuery table `project_id:dataset_id.table_id`, the root is
        #      `dataset_id`
        #     - For Cloud Storage file `gs://bucket/folder/filename.txt`, the root
        #      is `gs://bucket`
        # @!attribute [rw] relative_path
        #   @return [::String]
        #     The rest of the path after the root.
        #     Examples:
        #
        #     - For BigQuery table `project_id:dataset_id.table_id`, the relative path is
        #      `table_id`
        #     - For Cloud Storage file `gs://bucket/folder/filename.txt`, the relative
        #      path is `folder/filename.txt`
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Findings container modification timestamp, if applicable. For Cloud
        #     Storage, this field contains the last file modification timestamp. For a
        #     BigQuery table, this field contains the last_modified_time property. For
        #     Datastore, this field isn't populated.
        # @!attribute [rw] version
        #   @return [::String]
        #     Findings container version, if available
        #     ("generation" for Cloud Storage).
        class Container
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Generic half-open interval [start, end)
        # @!attribute [rw] start
        #   @return [::Integer]
        #     Index of the first character of the range (inclusive).
        # @!attribute [rw] end
        #   @return [::Integer]
        #     Index of the last character of the range (exclusive).
        class Range
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of the finding within an image.
        # @!attribute [rw] bounding_boxes
        #   @return [::Array<::Google::Cloud::Dlp::V2::BoundingBox>]
        #     Bounding boxes locating the pixels within the image containing the finding.
        class ImageLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Bounding box encompassing detected text within an image.
        # @!attribute [rw] top
        #   @return [::Integer]
        #     Top coordinate of the bounding box. (0,0) is upper left.
        # @!attribute [rw] left
        #   @return [::Integer]
        #     Left coordinate of the bounding box. (0,0) is upper left.
        # @!attribute [rw] width
        #   @return [::Integer]
        #     Width of the bounding box in pixels.
        # @!attribute [rw] height
        #   @return [::Integer]
        #     Height of the bounding box in pixels.
        class BoundingBox
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to search for potentially sensitive info in an image and redact it
        # by covering it with a colored rectangle.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Parent resource name.
        #
        #     The format of this value varies depending on whether you have [specified a
        #     processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        # @!attribute [rw] inspect_config
        #   @return [::Google::Cloud::Dlp::V2::InspectConfig]
        #     Configuration for the inspector.
        # @!attribute [rw] image_redaction_configs
        #   @return [::Array<::Google::Cloud::Dlp::V2::RedactImageRequest::ImageRedactionConfig>]
        #     The configuration for specifying what content to redact from images.
        # @!attribute [rw] include_findings
        #   @return [::Boolean]
        #     Whether the response should include findings along with the redacted
        #     image.
        # @!attribute [rw] byte_item
        #   @return [::Google::Cloud::Dlp::V2::ByteContentItem]
        #     The content must be PNG, JPEG, SVG or BMP.
        # @!attribute [rw] inspect_template
        #   @return [::String]
        #     The full resource name of the inspection template to use. Settings in the
        #     main `inspect_config` field override the corresponding settings in this
        #     inspection template.
        #
        #     The merge behavior is as follows:
        #
        #       - Singular field: The main field's value replaces the value of the
        #       corresponding field in the template.
        #       - Repeated fields: The field values are appended to the list defined in
        #       the template.
        #       - Sub-messages and groups: The fields are recursively merged.
        # @!attribute [rw] deidentify_template
        #   @return [::String]
        #     The full resource name of the de-identification template to use. Settings
        #     in the main `image_redaction_configs` field override the corresponding
        #     settings in this de-identification template. The request fails if the
        #     type of the template's deidentify_config is not image_transformations.
        class RedactImageRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for determining how redaction of images should occur.
          # @!attribute [rw] info_type
          #   @return [::Google::Cloud::Dlp::V2::InfoType]
          #     Only one per info_type should be provided per request. If not
          #     specified, and redact_all_text is false, the DLP API will redact all
          #     text that it matches against all info_types that are found, but not
          #     specified in another ImageRedactionConfig.
          #
          #     Note: The following fields are mutually exclusive: `info_type`, `redact_all_text`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] redact_all_text
          #   @return [::Boolean]
          #     If true, all text found in the image, regardless whether it matches an
          #     info_type, is redacted. Only one should be provided.
          #
          #     Note: The following fields are mutually exclusive: `redact_all_text`, `info_type`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] redaction_color
          #   @return [::Google::Cloud::Dlp::V2::Color]
          #     The color to use when redacting content from an image. If not specified,
          #     the default is black.
          class ImageRedactionConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a color in the RGB color space.
        # @!attribute [rw] red
        #   @return [::Float]
        #     The amount of red in the color as a value in the interval [0, 1].
        # @!attribute [rw] green
        #   @return [::Float]
        #     The amount of green in the color as a value in the interval [0, 1].
        # @!attribute [rw] blue
        #   @return [::Float]
        #     The amount of blue in the color as a value in the interval [0, 1].
        class Color
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results of redacting an image.
        # @!attribute [rw] redacted_image
        #   @return [::String]
        #     The redacted image. The type will be the same as the original image.
        # @!attribute [rw] extracted_text
        #   @return [::String]
        #     If an image was being inspected and the InspectConfig's include_quote was
        #     set to true, then this field will include all text, if any, that was found
        #     in the image.
        # @!attribute [rw] inspect_result
        #   @return [::Google::Cloud::Dlp::V2::InspectResult]
        #     The findings. Populated when include_findings in the request is true.
        class RedactImageResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to de-identify a ContentItem.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Parent resource name.
        #
        #     The format of this value varies depending on whether you have [specified a
        #     processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] deidentify_config
        #   @return [::Google::Cloud::Dlp::V2::DeidentifyConfig]
        #     Configuration for the de-identification of the content item.
        #     Items specified here will override the template referenced by the
        #     deidentify_template_name argument.
        # @!attribute [rw] inspect_config
        #   @return [::Google::Cloud::Dlp::V2::InspectConfig]
        #     Configuration for the inspector.
        #     Items specified here will override the template referenced by the
        #     inspect_template_name argument.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::Dlp::V2::ContentItem]
        #     The item to de-identify. Will be treated as text.
        #
        #     This value must be of type
        #     {::Google::Cloud::Dlp::V2::Table Table} if your
        #     {::Google::Cloud::Dlp::V2::DeidentifyContentRequest#deidentify_config deidentify_config}
        #     is a
        #     {::Google::Cloud::Dlp::V2::RecordTransformations RecordTransformations}
        #     object.
        # @!attribute [rw] inspect_template_name
        #   @return [::String]
        #     Template to use. Any configuration directly specified in
        #     inspect_config will override those set in the template. Singular fields
        #     that are set in this request will replace their corresponding fields in the
        #     template. Repeated fields are appended. Singular sub-messages and groups
        #     are recursively merged.
        # @!attribute [rw] deidentify_template_name
        #   @return [::String]
        #     Template to use. Any configuration directly specified in
        #     deidentify_config will override those set in the template. Singular fields
        #     that are set in this request will replace their corresponding fields in the
        #     template. Repeated fields are appended. Singular sub-messages and groups
        #     are recursively merged.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class DeidentifyContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results of de-identifying a ContentItem.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::Dlp::V2::ContentItem]
        #     The de-identified item.
        # @!attribute [rw] overview
        #   @return [::Google::Cloud::Dlp::V2::TransformationOverview]
        #     An overview of the changes that were made on the `item`.
        class DeidentifyContentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to re-identify an item.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on whether you have [specified a
        #     processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] reidentify_config
        #   @return [::Google::Cloud::Dlp::V2::DeidentifyConfig]
        #     Configuration for the re-identification of the content item.
        #     This field shares the same proto message type that is used for
        #     de-identification, however its usage here is for the reversal of the
        #     previous de-identification. Re-identification is performed by examining
        #     the transformations used to de-identify the items and executing the
        #     reverse. This requires that only reversible transformations
        #     be provided here. The reversible transformations are:
        #
        #      - `CryptoDeterministicConfig`
        #      - `CryptoReplaceFfxFpeConfig`
        # @!attribute [rw] inspect_config
        #   @return [::Google::Cloud::Dlp::V2::InspectConfig]
        #     Configuration for the inspector.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::Dlp::V2::ContentItem]
        #     The item to re-identify. Will be treated as text.
        # @!attribute [rw] inspect_template_name
        #   @return [::String]
        #     Template to use. Any configuration directly specified in
        #     `inspect_config` will override those set in the template. Singular fields
        #     that are set in this request will replace their corresponding fields in the
        #     template. Repeated fields are appended. Singular sub-messages and groups
        #     are recursively merged.
        # @!attribute [rw] reidentify_template_name
        #   @return [::String]
        #     Template to use. References an instance of `DeidentifyTemplate`.
        #     Any configuration directly specified in `reidentify_config` or
        #     `inspect_config` will override those set in the template. The
        #     `DeidentifyTemplate` used must include only reversible transformations.
        #     Singular fields that are set in this request will replace their
        #     corresponding fields in the template. Repeated fields are appended.
        #     Singular sub-messages and groups are recursively merged.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class ReidentifyContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results of re-identifying an item.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::Dlp::V2::ContentItem]
        #     The re-identified item.
        # @!attribute [rw] overview
        #   @return [::Google::Cloud::Dlp::V2::TransformationOverview]
        #     An overview of the changes that were made to the `item`.
        class ReidentifyContentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to search for potentially sensitive info in a ContentItem.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Parent resource name.
        #
        #     The format of this value varies depending on whether you have [specified a
        #     processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] inspect_config
        #   @return [::Google::Cloud::Dlp::V2::InspectConfig]
        #     Configuration for the inspector. What specified here will override
        #     the template referenced by the inspect_template_name argument.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::Dlp::V2::ContentItem]
        #     The item to inspect.
        # @!attribute [rw] inspect_template_name
        #   @return [::String]
        #     Template to use. Any configuration directly specified in
        #     inspect_config will override those set in the template. Singular fields
        #     that are set in this request will replace their corresponding fields in the
        #     template. Repeated fields are appended. Singular sub-messages and groups
        #     are recursively merged.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class InspectContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Results of inspecting an item.
        # @!attribute [rw] result
        #   @return [::Google::Cloud::Dlp::V2::InspectResult]
        #     The findings.
        class InspectContentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cloud repository for storing output.
        # @!attribute [rw] table
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     Store findings in an existing table or a new table in an existing
        #     dataset. If table_id is not set a new one will be generated
        #     for you with the following format:
        #     dlp_googleapis_yyyy_mm_dd_[dlp_job_id]. Pacific time zone will be used
        #     for generating the date details.
        #
        #     For Inspect, each column in an existing output table must have the same
        #     name, type, and mode of a field in the `Finding` object.
        #
        #     For Risk, an existing output table should be the output of a previous
        #     Risk analysis job run on the same source table, with the same privacy
        #     metric and quasi-identifiers. Risk jobs that analyze the same table but
        #     compute a different privacy metric, or use different sets of
        #     quasi-identifiers, cannot store their results in the same table.
        #
        #     Note: The following fields are mutually exclusive: `table`, `storage_path`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] storage_path
        #   @return [::Google::Cloud::Dlp::V2::CloudStoragePath]
        #     Store findings in an existing Cloud Storage bucket. Files will be
        #     generated with the job ID and file part number as the filename and will
        #     contain findings in textproto format as
        #     {::Google::Cloud::Dlp::V2::SaveToGcsFindingsOutput SaveToGcsFindingsOutput}.
        #     The filename will follow the naming convention `<job_id>-<shard_number>`.
        #     Example: `my-job-id-2`.
        #
        #     Supported for {::Google::Cloud::Dlp::V2::InspectJobConfig Inspect jobs}. The
        #     bucket must not be the same as the bucket being inspected. If storing
        #     findings to Cloud Storage, the output schema field should not be set. If
        #     set, it will be ignored.
        #
        #     Note: The following fields are mutually exclusive: `storage_path`, `table`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] output_schema
        #   @return [::Google::Cloud::Dlp::V2::OutputStorageConfig::OutputSchema]
        #     Schema used for writing the findings for Inspect jobs. This field is only
        #     used for Inspect and must be unspecified for Risk jobs. Columns are derived
        #     from the `Finding` object. If appending to an existing table, any columns
        #     from the predefined schema that are missing will be added. No columns in
        #     the existing table will be deleted.
        #
        #     If unspecified, then all available columns will be used for a new table or
        #     an (existing) table with no schema, and no changes will be made to an
        #     existing table that has a schema.
        #     Only for use with external storage.
        class OutputStorageConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Predefined schemas for storing findings.
          # Only for use with external storage.
          module OutputSchema
            # Unused.
            OUTPUT_SCHEMA_UNSPECIFIED = 0

            # Basic schema including only `info_type`, `quote`, `certainty`, and
            # `timestamp`.
            BASIC_COLUMNS = 1

            # Schema tailored to findings from scanning Cloud Storage.
            GCS_COLUMNS = 2

            # Schema tailored to findings from scanning Google Datastore.
            DATASTORE_COLUMNS = 3

            # Schema tailored to findings from scanning Google BigQuery.
            BIG_QUERY_COLUMNS = 4

            # Schema containing all columns.
            ALL_COLUMNS = 5
          end
        end

        # Statistics regarding a specific InfoType.
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     The type of finding this stat is for.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     Number of findings for this infoType.
        class InfoTypeStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The results of an inspect DataSource job.
        # @!attribute [rw] requested_options
        #   @return [::Google::Cloud::Dlp::V2::InspectDataSourceDetails::RequestedOptions]
        #     The configuration used for this job.
        # @!attribute [rw] result
        #   @return [::Google::Cloud::Dlp::V2::InspectDataSourceDetails::Result]
        #     A summary of the outcome of this inspection job.
        class InspectDataSourceDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Snapshot of the inspection configuration.
          # @!attribute [rw] snapshot_inspect_template
          #   @return [::Google::Cloud::Dlp::V2::InspectTemplate]
          #     If run with an InspectTemplate, a snapshot of its state at the time of
          #     this run.
          # @!attribute [rw] job_config
          #   @return [::Google::Cloud::Dlp::V2::InspectJobConfig]
          #     Inspect config.
          class RequestedOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # All Result fields are updated while the job is processing.
          # @!attribute [rw] processed_bytes
          #   @return [::Integer]
          #     Total size in bytes that were processed.
          # @!attribute [rw] total_estimated_bytes
          #   @return [::Integer]
          #     Estimate of the number of bytes to process.
          # @!attribute [rw] info_type_stats
          #   @return [::Array<::Google::Cloud::Dlp::V2::InfoTypeStats>]
          #     Statistics of how many instances of each info type were found during
          #     inspect job.
          # @!attribute [rw] num_rows_processed
          #   @return [::Integer]
          #     Number of rows scanned after sampling and time filtering (applicable for
          #     row based stores such as BigQuery).
          # @!attribute [rw] hybrid_stats
          #   @return [::Google::Cloud::Dlp::V2::HybridInspectStatistics]
          #     Statistics related to the processing of hybrid inspect.
          class Result
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The schema of data to be saved to the BigQuery table when the
        # `DataProfileAction` is enabled.
        # @!attribute [rw] table_profile
        #   @return [::Google::Cloud::Dlp::V2::TableDataProfile]
        #     Table data profile column
        #
        #     Note: The following fields are mutually exclusive: `table_profile`, `column_profile`, `file_store_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] column_profile
        #   @return [::Google::Cloud::Dlp::V2::ColumnDataProfile]
        #     Column data profile column
        #
        #     Note: The following fields are mutually exclusive: `column_profile`, `table_profile`, `file_store_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] file_store_profile
        #   @return [::Google::Cloud::Dlp::V2::FileStoreDataProfile]
        #     File store data profile column.
        #
        #     Note: The following fields are mutually exclusive: `file_store_profile`, `table_profile`, `column_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DataProfileBigQueryRowSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Statistics related to processing hybrid inspect requests.
        # @!attribute [rw] processed_count
        #   @return [::Integer]
        #     The number of hybrid inspection requests processed within this job.
        # @!attribute [rw] aborted_count
        #   @return [::Integer]
        #     The number of hybrid inspection requests aborted because the job ran
        #     out of quota or was ended before they could be processed.
        # @!attribute [rw] pending_count
        #   @return [::Integer]
        #     The number of hybrid requests currently being processed. Only populated
        #     when called via method `getDlpJob`.
        #     A burst of traffic may cause hybrid inspect requests to be enqueued.
        #     Processing will take place as quickly as possible, but resource limitations
        #     may impact how long a request is enqueued for.
        class HybridInspectStatistics
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The results of an {::Google::Cloud::Dlp::V2::Action Action}.
        # @!attribute [rw] deidentify_details
        #   @return [::Google::Cloud::Dlp::V2::DeidentifyDataSourceDetails]
        #     Outcome of a de-identification action.
        class ActionDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Summary of what was modified during a transformation.
        # @!attribute [rw] transformed_bytes
        #   @return [::Integer]
        #     Total size in bytes that were transformed in some way.
        # @!attribute [rw] transformation_count
        #   @return [::Integer]
        #     Number of successfully applied transformations.
        # @!attribute [rw] transformation_error_count
        #   @return [::Integer]
        #     Number of errors encountered while trying to apply transformations.
        class DeidentifyDataSourceStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The results of a {::Google::Cloud::Dlp::V2::Action::Deidentify Deidentify} action
        # from an inspect job.
        # @!attribute [rw] requested_options
        #   @return [::Google::Cloud::Dlp::V2::DeidentifyDataSourceDetails::RequestedDeidentifyOptions]
        #     De-identification config used for the request.
        # @!attribute [rw] deidentify_stats
        #   @return [::Google::Cloud::Dlp::V2::DeidentifyDataSourceStats]
        #     Stats about the de-identification operation.
        class DeidentifyDataSourceDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # De-identification options.
          # @!attribute [rw] snapshot_deidentify_template
          #   @return [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
          #     Snapshot of the state of the `DeidentifyTemplate` from the
          #     {::Google::Cloud::Dlp::V2::Action::Deidentify Deidentify} action at the time
          #     this job was run.
          # @!attribute [rw] snapshot_structured_deidentify_template
          #   @return [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
          #     Snapshot of the state of the structured `DeidentifyTemplate` from the
          #     `Deidentify` action at the time this job was run.
          # @!attribute [rw] snapshot_image_redact_template
          #   @return [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
          #     Snapshot of the state of the image transformation `DeidentifyTemplate`
          #     from the `Deidentify` action at the time this job was run.
          class RequestedDeidentifyOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Locations at which a feature can be used.
        # @!attribute [rw] regionalization_scope
        #   @return [::Google::Cloud::Dlp::V2::LocationSupport::RegionalizationScope]
        #     The current scope for location on this feature. This may expand over time.
        # @!attribute [rw] locations
        #   @return [::Array<::String>]
        #     Specific locations where the feature may be used.
        #     Examples: us-central1, us, asia, global
        #     If scope is ANY_LOCATION, no regions will be listed.
        class LocationSupport
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The location scope for a feature.
          module RegionalizationScope
            # Invalid.
            REGIONALIZATION_SCOPE_UNSPECIFIED = 0

            # Feature may be used with one or more regions. See locations for details.
            REGIONAL = 1

            # Feature may be used anywhere. Default value.
            ANY_LOCATION = 2
          end
        end

        # InfoType description.
        # @!attribute [rw] name
        #   @return [::String]
        #     Internal name of the infoType.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Human readable form of the infoType name.
        # @!attribute [rw] supported_by
        #   @return [::Array<::Google::Cloud::Dlp::V2::InfoTypeSupportedBy>]
        #     Which parts of the API supports this InfoType.
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the infotype. Translated when language is provided in the
        #     request.
        # @!attribute [rw] location_support
        #   @return [::Google::Cloud::Dlp::V2::LocationSupport]
        #     Locations at which this feature can be used. May change over time.
        # @!attribute [rw] example
        #   @return [::String]
        #     A sample that is a true positive for this infoType.
        # @!attribute [rw] versions
        #   @return [::Array<::Google::Cloud::Dlp::V2::VersionDescription>]
        #     A list of available versions for the infotype.
        # @!attribute [rw] categories
        #   @return [::Array<::Google::Cloud::Dlp::V2::InfoTypeCategory>]
        #     The category of the infoType.
        # @!attribute [rw] sensitivity_score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
        #     The default sensitivity of the infoType.
        # @!attribute [rw] specific_info_types
        #   @return [::Array<::String>]
        #     If this field is set, this infoType is a general infoType and these
        #     specific infoTypes are contained within it.
        #     General infoTypes are infoTypes that encompass multiple specific infoTypes.
        #     For example, the "GEOGRAPHIC_DATA" general infoType would have set for this
        #     field "LOCATION", "LOCATION_COORDINATES", and "STREET_ADDRESS".
        class InfoTypeDescription
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Classification of infoTypes to organize them according to geographic
        # location, industry, and data type.
        # @!attribute [rw] location_category
        #   @return [::Google::Cloud::Dlp::V2::InfoTypeCategory::LocationCategory]
        #     The region or country that issued the ID or document represented by the
        #     infoType.
        #
        #     Note: The following fields are mutually exclusive: `location_category`, `industry_category`, `type_category`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] industry_category
        #   @return [::Google::Cloud::Dlp::V2::InfoTypeCategory::IndustryCategory]
        #     The group of relevant businesses where this infoType is commonly used
        #
        #     Note: The following fields are mutually exclusive: `industry_category`, `location_category`, `type_category`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] type_category
        #   @return [::Google::Cloud::Dlp::V2::InfoTypeCategory::TypeCategory]
        #     The class of identifiers where this infoType belongs
        #
        #     Note: The following fields are mutually exclusive: `type_category`, `location_category`, `industry_category`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class InfoTypeCategory
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum of the current locations.
          # We might add more locations in the future.
          module LocationCategory
            # Unused location
            LOCATION_UNSPECIFIED = 0

            # The infoType is not issued by or tied to a specific region, but is used
            # almost everywhere.
            GLOBAL = 1

            # The infoType is typically used in Argentina.
            ARGENTINA = 2

            # The infoType is typically used in Armenia.
            ARMENIA = 51

            # The infoType is typically used in Australia.
            AUSTRALIA = 3

            # The infoType is typically used in Austria.
            AUSTRIA = 53

            # The infoType is typically used in Azerbaijan.
            AZERBAIJAN = 48

            # The infoType is typically used in Belarus.
            BELARUS = 50

            # The infoType is typically used in Belgium.
            BELGIUM = 4

            # The infoType is typically used in Brazil.
            BRAZIL = 5

            # The infoType is typically used in Canada.
            CANADA = 6

            # The infoType is typically used in Chile.
            CHILE = 7

            # The infoType is typically used in China.
            CHINA = 8

            # The infoType is typically used in Colombia.
            COLOMBIA = 9

            # The infoType is typically used in Croatia.
            CROATIA = 42

            # The infoType is typically used in Czechia.
            CZECHIA = 52

            # The infoType is typically used in Denmark.
            DENMARK = 10

            # The infoType is typically used in France.
            FRANCE = 11

            # The infoType is typically used in Finland.
            FINLAND = 12

            # The infoType is typically used in Germany.
            GERMANY = 13

            # The infoType is typically used in Hong Kong.
            HONG_KONG = 14

            # The infoType is typically used in India.
            INDIA = 15

            # The infoType is typically used in Indonesia.
            INDONESIA = 16

            # The infoType is typically used in Ireland.
            IRELAND = 17

            # The infoType is typically used in Israel.
            ISRAEL = 18

            # The infoType is typically used in Italy.
            ITALY = 19

            # The infoType is typically used in Japan.
            JAPAN = 20

            # The infoType is typically used in Kazakhstan.
            KAZAKHSTAN = 47

            # The infoType is typically used in Korea.
            KOREA = 21

            # The infoType is typically used in Mexico.
            MEXICO = 22

            # The infoType is typically used in the Netherlands.
            THE_NETHERLANDS = 23

            # The infoType is typically used in New Zealand.
            NEW_ZEALAND = 41

            # The infoType is typically used in Norway.
            NORWAY = 24

            # The infoType is typically used in Paraguay.
            PARAGUAY = 25

            # The infoType is typically used in Peru.
            PERU = 26

            # The infoType is typically used in Poland.
            POLAND = 27

            # The infoType is typically used in Portugal.
            PORTUGAL = 28

            # The infoType is typically used in Russia.
            RUSSIA = 44

            # The infoType is typically used in Singapore.
            SINGAPORE = 29

            # The infoType is typically used in South Africa.
            SOUTH_AFRICA = 30

            # The infoType is typically used in Spain.
            SPAIN = 31

            # The infoType is typically used in Sweden.
            SWEDEN = 32

            # The infoType is typically used in Switzerland.
            SWITZERLAND = 43

            # The infoType is typically used in Taiwan.
            TAIWAN = 33

            # The infoType is typically used in Thailand.
            THAILAND = 34

            # The infoType is typically used in Turkey.
            TURKEY = 35

            # The infoType is typically used in Ukraine.
            UKRAINE = 45

            # The infoType is typically used in the United Kingdom.
            UNITED_KINGDOM = 36

            # The infoType is typically used in the United States.
            UNITED_STATES = 37

            # The infoType is typically used in Uruguay.
            URUGUAY = 38

            # The infoType is typically used in Uzbekistan.
            UZBEKISTAN = 46

            # The infoType is typically used in Venezuela.
            VENEZUELA = 39

            # The infoType is typically used in Google internally.
            INTERNAL = 40
          end

          # Enum of the current industries in the category.
          # We might add more industries in the future.
          module IndustryCategory
            # Unused industry
            INDUSTRY_UNSPECIFIED = 0

            # The infoType is typically used in the finance industry.
            FINANCE = 1

            # The infoType is typically used in the health industry.
            HEALTH = 2

            # The infoType is typically used in the telecommunications industry.
            TELECOMMUNICATIONS = 3
          end

          # Enum of the current types in the category.
          # We might add more types in the future.
          module TypeCategory
            # Unused type
            TYPE_UNSPECIFIED = 0

            # Personally identifiable information, for example, a
            # name or phone number
            PII = 1

            # Personally identifiable information that is especially sensitive, for
            # example, a passport number.
            SPII = 2

            # Attributes that can partially identify someone, especially in
            # combination with other attributes, like age, height, and gender.
            DEMOGRAPHIC = 3

            # Confidential or secret information, for example, a password.
            CREDENTIAL = 4

            # An identification document issued by a government.
            GOVERNMENT_ID = 5

            # A document, for example, a resume or source code.
            DOCUMENT = 6

            # Information that is not sensitive on its own, but provides details about
            # the circumstances surrounding an entity or an event.
            CONTEXTUAL_INFORMATION = 7

            # Category for `CustomInfoType` types.
            CUSTOM = 8
          end
        end

        # Details about each available version for an infotype.
        # @!attribute [rw] version
        #   @return [::String]
        #     Name of the version
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the version.
        class VersionDescription
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for the list of infoTypes.
        # @!attribute [rw] parent
        #   @return [::String]
        #     The parent resource name.
        #
        #     The format of this value is as follows:
        #
        #         `locations/{location_id}`
        # @!attribute [rw] language_code
        #   @return [::String]
        #     BCP-47 language code for localized infoType friendly
        #     names. If omitted, or if localized strings are not available,
        #     en-US strings will be returned.
        # @!attribute [rw] filter
        #   @return [::String]
        #     filter to only return infoTypes supported by certain parts of the
        #     API. Defaults to supported_by=INSPECT.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class ListInfoTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response to the ListInfoTypes request.
        # @!attribute [rw] info_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::InfoTypeDescription>]
        #     Set of sensitive infoTypes.
        class ListInfoTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for a risk analysis job. See
        # https://cloud.google.com/sensitive-data-protection/docs/concepts-risk-analysis
        # to learn more.
        # @!attribute [rw] privacy_metric
        #   @return [::Google::Cloud::Dlp::V2::PrivacyMetric]
        #     Privacy metric to compute.
        # @!attribute [rw] source_table
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     Input dataset to compute metrics over.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::Dlp::V2::Action>]
        #     Actions to execute at the completion of the job. Are executed in the order
        #     provided.
        class RiskAnalysisJobConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A column with a semantic tag attached.
        # @!attribute [rw] field
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     Required. Identifies the column.
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     A column can be tagged with a InfoType to use the relevant public
        #     dataset as a statistical model of population, if available. We
        #     currently support US ZIP codes, region codes, ages and genders.
        #     To programmatically obtain the list of supported InfoTypes, use
        #     ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
        #
        #     Note: The following fields are mutually exclusive: `info_type`, `custom_tag`, `inferred`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] custom_tag
        #   @return [::String]
        #     A column can be tagged with a custom tag. In this case, the user must
        #     indicate an auxiliary table that contains statistical information on
        #     the possible values of this column.
        #
        #     Note: The following fields are mutually exclusive: `custom_tag`, `info_type`, `inferred`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] inferred
        #   @return [::Google::Protobuf::Empty]
        #     If no semantic tag is indicated, we infer the statistical model from
        #     the distribution of values in the input data
        #
        #     Note: The following fields are mutually exclusive: `inferred`, `info_type`, `custom_tag`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class QuasiId
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An auxiliary table containing statistical information on the relative
        # frequency of different quasi-identifiers values. It has one or several
        # quasi-identifiers columns, and one column that indicates the relative
        # frequency of each quasi-identifier tuple.
        # If a tuple is present in the data but not in the auxiliary table, the
        # corresponding relative frequency is assumed to be zero (and thus, the
        # tuple is highly reidentifiable).
        # @!attribute [rw] table
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     Required. Auxiliary table location.
        # @!attribute [rw] quasi_ids
        #   @return [::Array<::Google::Cloud::Dlp::V2::StatisticalTable::QuasiIdentifierField>]
        #     Required. Quasi-identifier columns.
        # @!attribute [rw] relative_frequency
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     Required. The relative frequency column must contain a floating-point
        #     number between 0 and 1 (inclusive). Null values are assumed to be zero.
        class StatisticalTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A quasi-identifier column has a custom_tag, used to know which column
          # in the data corresponds to which column in the statistical model.
          # @!attribute [rw] field
          #   @return [::Google::Cloud::Dlp::V2::FieldId]
          #     Identifies the column.
          # @!attribute [rw] custom_tag
          #   @return [::String]
          #     A column can be tagged with a custom tag. In this case, the user must
          #     indicate an auxiliary table that contains statistical information on
          #     the possible values of this column.
          class QuasiIdentifierField
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Privacy metric to compute for reidentification risk analysis.
        # @!attribute [rw] numerical_stats_config
        #   @return [::Google::Cloud::Dlp::V2::PrivacyMetric::NumericalStatsConfig]
        #     Numerical stats
        #
        #     Note: The following fields are mutually exclusive: `numerical_stats_config`, `categorical_stats_config`, `k_anonymity_config`, `l_diversity_config`, `k_map_estimation_config`, `delta_presence_estimation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] categorical_stats_config
        #   @return [::Google::Cloud::Dlp::V2::PrivacyMetric::CategoricalStatsConfig]
        #     Categorical stats
        #
        #     Note: The following fields are mutually exclusive: `categorical_stats_config`, `numerical_stats_config`, `k_anonymity_config`, `l_diversity_config`, `k_map_estimation_config`, `delta_presence_estimation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] k_anonymity_config
        #   @return [::Google::Cloud::Dlp::V2::PrivacyMetric::KAnonymityConfig]
        #     K-anonymity
        #
        #     Note: The following fields are mutually exclusive: `k_anonymity_config`, `numerical_stats_config`, `categorical_stats_config`, `l_diversity_config`, `k_map_estimation_config`, `delta_presence_estimation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] l_diversity_config
        #   @return [::Google::Cloud::Dlp::V2::PrivacyMetric::LDiversityConfig]
        #     l-diversity
        #
        #     Note: The following fields are mutually exclusive: `l_diversity_config`, `numerical_stats_config`, `categorical_stats_config`, `k_anonymity_config`, `k_map_estimation_config`, `delta_presence_estimation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] k_map_estimation_config
        #   @return [::Google::Cloud::Dlp::V2::PrivacyMetric::KMapEstimationConfig]
        #     k-map
        #
        #     Note: The following fields are mutually exclusive: `k_map_estimation_config`, `numerical_stats_config`, `categorical_stats_config`, `k_anonymity_config`, `l_diversity_config`, `delta_presence_estimation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] delta_presence_estimation_config
        #   @return [::Google::Cloud::Dlp::V2::PrivacyMetric::DeltaPresenceEstimationConfig]
        #     delta-presence
        #
        #     Note: The following fields are mutually exclusive: `delta_presence_estimation_config`, `numerical_stats_config`, `categorical_stats_config`, `k_anonymity_config`, `l_diversity_config`, `k_map_estimation_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class PrivacyMetric
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Compute numerical stats over an individual column, including
          # min, max, and quantiles.
          # @!attribute [rw] field
          #   @return [::Google::Cloud::Dlp::V2::FieldId]
          #     Field to compute numerical stats on. Supported types are
          #     integer, float, date, datetime, timestamp, time.
          class NumericalStatsConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Compute numerical stats over an individual column, including
          # number of distinct values and value count distribution.
          # @!attribute [rw] field
          #   @return [::Google::Cloud::Dlp::V2::FieldId]
          #     Field to compute categorical stats on. All column types are
          #     supported except for arrays and structs. However, it may be more
          #     informative to use NumericalStats when the field type is supported,
          #     depending on the data.
          class CategoricalStatsConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # k-anonymity metric, used for analysis of reidentification risk.
          # @!attribute [rw] quasi_ids
          #   @return [::Array<::Google::Cloud::Dlp::V2::FieldId>]
          #     Set of fields to compute k-anonymity over. When multiple fields are
          #     specified, they are considered a single composite key. Structs and
          #     repeated data types are not supported; however, nested fields are
          #     supported so long as they are not structs themselves or nested within
          #     a repeated field.
          # @!attribute [rw] entity_id
          #   @return [::Google::Cloud::Dlp::V2::EntityId]
          #     Message indicating that multiple rows might be associated to a
          #     single individual. If the same entity_id is associated to multiple
          #     quasi-identifier tuples over distinct rows, we consider the entire
          #     collection of tuples as the composite quasi-identifier. This collection
          #     is a multiset: the order in which the different tuples appear in the
          #     dataset is ignored, but their frequency is taken into account.
          #
          #     Important note: a maximum of 1000 rows can be associated to a single
          #     entity ID. If more rows are associated with the same entity ID, some
          #     might be ignored.
          class KAnonymityConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # l-diversity metric, used for analysis of reidentification risk.
          # @!attribute [rw] quasi_ids
          #   @return [::Array<::Google::Cloud::Dlp::V2::FieldId>]
          #     Set of quasi-identifiers indicating how equivalence classes are
          #     defined for the l-diversity computation. When multiple fields are
          #     specified, they are considered a single composite key.
          # @!attribute [rw] sensitive_attribute
          #   @return [::Google::Cloud::Dlp::V2::FieldId]
          #     Sensitive field for computing the l-value.
          class LDiversityConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Reidentifiability metric. This corresponds to a risk model similar to what
          # is called "journalist risk" in the literature, except the attack dataset is
          # statistically modeled instead of being perfectly known. This can be done
          # using publicly available data (like the US Census), or using a custom
          # statistical model (indicated as one or several BigQuery tables), or by
          # extrapolating from the distribution of values in the input dataset.
          # @!attribute [rw] quasi_ids
          #   @return [::Array<::Google::Cloud::Dlp::V2::PrivacyMetric::KMapEstimationConfig::TaggedField>]
          #     Required. Fields considered to be quasi-identifiers. No two columns can
          #     have the same tag.
          # @!attribute [rw] region_code
          #   @return [::String]
          #     ISO 3166-1 alpha-2 region code to use in the statistical modeling.
          #     Set if no column is tagged with a region-specific InfoType (like
          #     US_ZIP_5) or a region code.
          # @!attribute [rw] auxiliary_tables
          #   @return [::Array<::Google::Cloud::Dlp::V2::PrivacyMetric::KMapEstimationConfig::AuxiliaryTable>]
          #     Several auxiliary tables can be used in the analysis. Each custom_tag
          #     used to tag a quasi-identifiers column must appear in exactly one column
          #     of one auxiliary table.
          class KMapEstimationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A column with a semantic tag attached.
            # @!attribute [rw] field
            #   @return [::Google::Cloud::Dlp::V2::FieldId]
            #     Required. Identifies the column.
            # @!attribute [rw] info_type
            #   @return [::Google::Cloud::Dlp::V2::InfoType]
            #     A column can be tagged with a InfoType to use the relevant public
            #     dataset as a statistical model of population, if available. We
            #     currently support US ZIP codes, region codes, ages and genders.
            #     To programmatically obtain the list of supported InfoTypes, use
            #     ListInfoTypes with the supported_by=RISK_ANALYSIS filter.
            #
            #     Note: The following fields are mutually exclusive: `info_type`, `custom_tag`, `inferred`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] custom_tag
            #   @return [::String]
            #     A column can be tagged with a custom tag. In this case, the user must
            #     indicate an auxiliary table that contains statistical information on
            #     the possible values of this column.
            #
            #     Note: The following fields are mutually exclusive: `custom_tag`, `info_type`, `inferred`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            # @!attribute [rw] inferred
            #   @return [::Google::Protobuf::Empty]
            #     If no semantic tag is indicated, we infer the statistical model from
            #     the distribution of values in the input data
            #
            #     Note: The following fields are mutually exclusive: `inferred`, `info_type`, `custom_tag`. If a field in that set is populated, all other fields in the set will automatically be cleared.
            class TaggedField
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # An auxiliary table contains statistical information on the relative
            # frequency of different quasi-identifiers values. It has one or several
            # quasi-identifiers columns, and one column that indicates the relative
            # frequency of each quasi-identifier tuple.
            # If a tuple is present in the data but not in the auxiliary table, the
            # corresponding relative frequency is assumed to be zero (and thus, the
            # tuple is highly reidentifiable).
            # @!attribute [rw] table
            #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
            #     Required. Auxiliary table location.
            # @!attribute [rw] quasi_ids
            #   @return [::Array<::Google::Cloud::Dlp::V2::PrivacyMetric::KMapEstimationConfig::AuxiliaryTable::QuasiIdField>]
            #     Required. Quasi-identifier columns.
            # @!attribute [rw] relative_frequency
            #   @return [::Google::Cloud::Dlp::V2::FieldId]
            #     Required. The relative frequency column must contain a floating-point
            #     number between 0 and 1 (inclusive). Null values are assumed to be zero.
            class AuxiliaryTable
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # A quasi-identifier column has a custom_tag, used to know which column
              # in the data corresponds to which column in the statistical model.
              # @!attribute [rw] field
              #   @return [::Google::Cloud::Dlp::V2::FieldId]
              #     Identifies the column.
              # @!attribute [rw] custom_tag
              #   @return [::String]
              #     A auxiliary field.
              class QuasiIdField
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods
              end
            end
          end

          # δ-presence metric, used to estimate how likely it is for an attacker to
          # figure out that one given individual appears in a de-identified dataset.
          # Similarly to the k-map metric, we cannot compute δ-presence exactly without
          # knowing the attack dataset, so we use a statistical model instead.
          # @!attribute [rw] quasi_ids
          #   @return [::Array<::Google::Cloud::Dlp::V2::QuasiId>]
          #     Required. Fields considered to be quasi-identifiers. No two fields can
          #     have the same tag.
          # @!attribute [rw] region_code
          #   @return [::String]
          #     ISO 3166-1 alpha-2 region code to use in the statistical modeling.
          #     Set if no column is tagged with a region-specific InfoType (like
          #     US_ZIP_5) or a region code.
          # @!attribute [rw] auxiliary_tables
          #   @return [::Array<::Google::Cloud::Dlp::V2::StatisticalTable>]
          #     Several auxiliary tables can be used in the analysis. Each custom_tag
          #     used to tag a quasi-identifiers field must appear in exactly one
          #     field of one auxiliary table.
          class DeltaPresenceEstimationConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Result of a risk analysis operation request.
        # @!attribute [rw] requested_privacy_metric
        #   @return [::Google::Cloud::Dlp::V2::PrivacyMetric]
        #     Privacy metric to compute.
        # @!attribute [rw] requested_source_table
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     Input dataset to compute metrics over.
        # @!attribute [rw] numerical_stats_result
        #   @return [::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::NumericalStatsResult]
        #     Numerical stats result
        #
        #     Note: The following fields are mutually exclusive: `numerical_stats_result`, `categorical_stats_result`, `k_anonymity_result`, `l_diversity_result`, `k_map_estimation_result`, `delta_presence_estimation_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] categorical_stats_result
        #   @return [::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::CategoricalStatsResult]
        #     Categorical stats result
        #
        #     Note: The following fields are mutually exclusive: `categorical_stats_result`, `numerical_stats_result`, `k_anonymity_result`, `l_diversity_result`, `k_map_estimation_result`, `delta_presence_estimation_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] k_anonymity_result
        #   @return [::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::KAnonymityResult]
        #     K-anonymity result
        #
        #     Note: The following fields are mutually exclusive: `k_anonymity_result`, `numerical_stats_result`, `categorical_stats_result`, `l_diversity_result`, `k_map_estimation_result`, `delta_presence_estimation_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] l_diversity_result
        #   @return [::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::LDiversityResult]
        #     L-divesity result
        #
        #     Note: The following fields are mutually exclusive: `l_diversity_result`, `numerical_stats_result`, `categorical_stats_result`, `k_anonymity_result`, `k_map_estimation_result`, `delta_presence_estimation_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] k_map_estimation_result
        #   @return [::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::KMapEstimationResult]
        #     K-map result
        #
        #     Note: The following fields are mutually exclusive: `k_map_estimation_result`, `numerical_stats_result`, `categorical_stats_result`, `k_anonymity_result`, `l_diversity_result`, `delta_presence_estimation_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] delta_presence_estimation_result
        #   @return [::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::DeltaPresenceEstimationResult]
        #     Delta-presence result
        #
        #     Note: The following fields are mutually exclusive: `delta_presence_estimation_result`, `numerical_stats_result`, `categorical_stats_result`, `k_anonymity_result`, `l_diversity_result`, `k_map_estimation_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] requested_options
        #   @return [::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::RequestedRiskAnalysisOptions]
        #     The configuration used for this job.
        class AnalyzeDataSourceRiskDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Result of the numerical stats computation.
          # @!attribute [rw] min_value
          #   @return [::Google::Cloud::Dlp::V2::Value]
          #     Minimum value appearing in the column.
          # @!attribute [rw] max_value
          #   @return [::Google::Cloud::Dlp::V2::Value]
          #     Maximum value appearing in the column.
          # @!attribute [rw] quantile_values
          #   @return [::Array<::Google::Cloud::Dlp::V2::Value>]
          #     List of 99 values that partition the set of field values into 100 equal
          #     sized buckets.
          class NumericalStatsResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Result of the categorical stats computation.
          # @!attribute [rw] value_frequency_histogram_buckets
          #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::CategoricalStatsResult::CategoricalStatsHistogramBucket>]
          #     Histogram of value frequencies in the column.
          class CategoricalStatsResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Histogram of value frequencies in the column.
            # @!attribute [rw] value_frequency_lower_bound
            #   @return [::Integer]
            #     Lower bound on the value frequency of the values in this bucket.
            # @!attribute [rw] value_frequency_upper_bound
            #   @return [::Integer]
            #     Upper bound on the value frequency of the values in this bucket.
            # @!attribute [rw] bucket_size
            #   @return [::Integer]
            #     Total number of values in this bucket.
            # @!attribute [rw] bucket_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::ValueFrequency>]
            #     Sample of value frequencies in this bucket. The total number of
            #     values returned per bucket is capped at 20.
            # @!attribute [rw] bucket_value_count
            #   @return [::Integer]
            #     Total number of distinct values in this bucket.
            class CategoricalStatsHistogramBucket
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Result of the k-anonymity computation.
          # @!attribute [rw] equivalence_class_histogram_buckets
          #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::KAnonymityResult::KAnonymityHistogramBucket>]
          #     Histogram of k-anonymity equivalence classes.
          class KAnonymityResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The set of columns' values that share the same ldiversity value
            # @!attribute [rw] quasi_ids_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::Value>]
            #     Set of values defining the equivalence class. One value per
            #     quasi-identifier column in the original KAnonymity metric message.
            #     The order is always the same as the original request.
            # @!attribute [rw] equivalence_class_size
            #   @return [::Integer]
            #     Size of the equivalence class, for example number of rows with the
            #     above set of values.
            class KAnonymityEquivalenceClass
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Histogram of k-anonymity equivalence classes.
            # @!attribute [rw] equivalence_class_size_lower_bound
            #   @return [::Integer]
            #     Lower bound on the size of the equivalence classes in this bucket.
            # @!attribute [rw] equivalence_class_size_upper_bound
            #   @return [::Integer]
            #     Upper bound on the size of the equivalence classes in this bucket.
            # @!attribute [rw] bucket_size
            #   @return [::Integer]
            #     Total number of equivalence classes in this bucket.
            # @!attribute [rw] bucket_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::KAnonymityResult::KAnonymityEquivalenceClass>]
            #     Sample of equivalence classes in this bucket. The total number of
            #     classes returned per bucket is capped at 20.
            # @!attribute [rw] bucket_value_count
            #   @return [::Integer]
            #     Total number of distinct equivalence classes in this bucket.
            class KAnonymityHistogramBucket
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Result of the l-diversity computation.
          # @!attribute [rw] sensitive_value_frequency_histogram_buckets
          #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::LDiversityResult::LDiversityHistogramBucket>]
          #     Histogram of l-diversity equivalence class sensitive value frequencies.
          class LDiversityResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The set of columns' values that share the same ldiversity value.
            # @!attribute [rw] quasi_ids_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::Value>]
            #     Quasi-identifier values defining the k-anonymity equivalence
            #     class. The order is always the same as the original request.
            # @!attribute [rw] equivalence_class_size
            #   @return [::Integer]
            #     Size of the k-anonymity equivalence class.
            # @!attribute [rw] num_distinct_sensitive_values
            #   @return [::Integer]
            #     Number of distinct sensitive values in this equivalence class.
            # @!attribute [rw] top_sensitive_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::ValueFrequency>]
            #     Estimated frequencies of top sensitive values.
            class LDiversityEquivalenceClass
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Histogram of l-diversity equivalence class sensitive value frequencies.
            # @!attribute [rw] sensitive_value_frequency_lower_bound
            #   @return [::Integer]
            #     Lower bound on the sensitive value frequencies of the equivalence
            #     classes in this bucket.
            # @!attribute [rw] sensitive_value_frequency_upper_bound
            #   @return [::Integer]
            #     Upper bound on the sensitive value frequencies of the equivalence
            #     classes in this bucket.
            # @!attribute [rw] bucket_size
            #   @return [::Integer]
            #     Total number of equivalence classes in this bucket.
            # @!attribute [rw] bucket_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::LDiversityResult::LDiversityEquivalenceClass>]
            #     Sample of equivalence classes in this bucket. The total number of
            #     classes returned per bucket is capped at 20.
            # @!attribute [rw] bucket_value_count
            #   @return [::Integer]
            #     Total number of distinct equivalence classes in this bucket.
            class LDiversityHistogramBucket
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Result of the reidentifiability analysis. Note that these results are an
          # estimation, not exact values.
          # @!attribute [rw] k_map_estimation_histogram
          #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::KMapEstimationResult::KMapEstimationHistogramBucket>]
          #     The intervals [min_anonymity, max_anonymity] do not overlap. If a value
          #     doesn't correspond to any such interval, the associated frequency is
          #     zero. For example, the following records:
          #       \\{min_anonymity: 1, max_anonymity: 1, frequency: 17}
          #       \\{min_anonymity: 2, max_anonymity: 3, frequency: 42}
          #       \\{min_anonymity: 5, max_anonymity: 10, frequency: 99}
          #     mean that there are no record with an estimated anonymity of 4, 5, or
          #     larger than 10.
          class KMapEstimationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A tuple of values for the quasi-identifier columns.
            # @!attribute [rw] quasi_ids_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::Value>]
            #     The quasi-identifier values.
            # @!attribute [rw] estimated_anonymity
            #   @return [::Integer]
            #     The estimated anonymity for these quasi-identifier values.
            class KMapEstimationQuasiIdValues
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A KMapEstimationHistogramBucket message with the following values:
            #   min_anonymity: 3
            #   max_anonymity: 5
            #   frequency: 42
            # means that there are 42 records whose quasi-identifier values correspond
            # to 3, 4 or 5 people in the overlying population. An important particular
            # case is when min_anonymity = max_anonymity = 1: the frequency field then
            # corresponds to the number of uniquely identifiable records.
            # @!attribute [rw] min_anonymity
            #   @return [::Integer]
            #     Always positive.
            # @!attribute [rw] max_anonymity
            #   @return [::Integer]
            #     Always greater than or equal to min_anonymity.
            # @!attribute [rw] bucket_size
            #   @return [::Integer]
            #     Number of records within these anonymity bounds.
            # @!attribute [rw] bucket_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::KMapEstimationResult::KMapEstimationQuasiIdValues>]
            #     Sample of quasi-identifier tuple values in this bucket. The total
            #     number of classes returned per bucket is capped at 20.
            # @!attribute [rw] bucket_value_count
            #   @return [::Integer]
            #     Total number of distinct quasi-identifier tuple values in this bucket.
            class KMapEstimationHistogramBucket
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Result of the δ-presence computation. Note that these results are an
          # estimation, not exact values.
          # @!attribute [rw] delta_presence_estimation_histogram
          #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::DeltaPresenceEstimationResult::DeltaPresenceEstimationHistogramBucket>]
          #     The intervals [min_probability, max_probability) do not overlap. If a
          #     value doesn't correspond to any such interval, the associated frequency
          #     is zero. For example, the following records:
          #       \\{min_probability: 0, max_probability: 0.1, frequency: 17}
          #       \\{min_probability: 0.2, max_probability: 0.3, frequency: 42}
          #       \\{min_probability: 0.3, max_probability: 0.4, frequency: 99}
          #     mean that there are no record with an estimated probability in [0.1, 0.2)
          #     nor larger or equal to 0.4.
          class DeltaPresenceEstimationResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A tuple of values for the quasi-identifier columns.
            # @!attribute [rw] quasi_ids_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::Value>]
            #     The quasi-identifier values.
            # @!attribute [rw] estimated_probability
            #   @return [::Float]
            #     The estimated probability that a given individual sharing these
            #     quasi-identifier values is in the dataset. This value, typically
            #     called δ, is the ratio between the number of records in the dataset
            #     with these quasi-identifier values, and the total number of individuals
            #     (inside *and* outside the dataset) with these quasi-identifier values.
            #     For example, if there are 15 individuals in the dataset who share the
            #     same quasi-identifier values, and an estimated 100 people in the entire
            #     population with these values, then δ is 0.15.
            class DeltaPresenceEstimationQuasiIdValues
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A DeltaPresenceEstimationHistogramBucket message with the following
            # values:
            #   min_probability: 0.1
            #   max_probability: 0.2
            #   frequency: 42
            # means that there are 42 records for which δ is in [0.1, 0.2). An
            # important particular case is when min_probability = max_probability = 1:
            # then, every individual who shares this quasi-identifier combination is in
            # the dataset.
            # @!attribute [rw] min_probability
            #   @return [::Float]
            #     Between 0 and 1.
            # @!attribute [rw] max_probability
            #   @return [::Float]
            #     Always greater than or equal to min_probability.
            # @!attribute [rw] bucket_size
            #   @return [::Integer]
            #     Number of records within these probability bounds.
            # @!attribute [rw] bucket_values
            #   @return [::Array<::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails::DeltaPresenceEstimationResult::DeltaPresenceEstimationQuasiIdValues>]
            #     Sample of quasi-identifier tuple values in this bucket. The total
            #     number of classes returned per bucket is capped at 20.
            # @!attribute [rw] bucket_value_count
            #   @return [::Integer]
            #     Total number of distinct quasi-identifier tuple values in this bucket.
            class DeltaPresenceEstimationHistogramBucket
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Risk analysis options.
          # @!attribute [rw] job_config
          #   @return [::Google::Cloud::Dlp::V2::RiskAnalysisJobConfig]
          #     The job config for the risk job.
          class RequestedRiskAnalysisOptions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A value of a field, including its frequency.
        # @!attribute [rw] value
        #   @return [::Google::Cloud::Dlp::V2::Value]
        #     A value contained in the field in question.
        # @!attribute [rw] count
        #   @return [::Integer]
        #     How many times the value is contained in the field.
        class ValueFrequency
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Set of primitive values supported by the system.
        # Note that for the purposes of inspection or transformation, the number
        # of bytes considered to comprise a 'Value' is based on its representation
        # as a UTF-8 encoded string. For example, if 'integer_value' is set to
        # 123456789, the number of bytes would be counted as 9, even though an
        # int64 only holds up to 8 bytes of data.
        # @!attribute [rw] integer_value
        #   @return [::Integer]
        #     integer
        #
        #     Note: The following fields are mutually exclusive: `integer_value`, `float_value`, `string_value`, `boolean_value`, `timestamp_value`, `time_value`, `date_value`, `day_of_week_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] float_value
        #   @return [::Float]
        #     float
        #
        #     Note: The following fields are mutually exclusive: `float_value`, `integer_value`, `string_value`, `boolean_value`, `timestamp_value`, `time_value`, `date_value`, `day_of_week_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] string_value
        #   @return [::String]
        #     string
        #
        #     Note: The following fields are mutually exclusive: `string_value`, `integer_value`, `float_value`, `boolean_value`, `timestamp_value`, `time_value`, `date_value`, `day_of_week_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] boolean_value
        #   @return [::Boolean]
        #     boolean
        #
        #     Note: The following fields are mutually exclusive: `boolean_value`, `integer_value`, `float_value`, `string_value`, `timestamp_value`, `time_value`, `date_value`, `day_of_week_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] timestamp_value
        #   @return [::Google::Protobuf::Timestamp]
        #     timestamp
        #
        #     Note: The following fields are mutually exclusive: `timestamp_value`, `integer_value`, `float_value`, `string_value`, `boolean_value`, `time_value`, `date_value`, `day_of_week_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] time_value
        #   @return [::Google::Type::TimeOfDay]
        #     time of day
        #
        #     Note: The following fields are mutually exclusive: `time_value`, `integer_value`, `float_value`, `string_value`, `boolean_value`, `timestamp_value`, `date_value`, `day_of_week_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] date_value
        #   @return [::Google::Type::Date]
        #     date
        #
        #     Note: The following fields are mutually exclusive: `date_value`, `integer_value`, `float_value`, `string_value`, `boolean_value`, `timestamp_value`, `time_value`, `day_of_week_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] day_of_week_value
        #   @return [::Google::Type::DayOfWeek]
        #     day of week
        #
        #     Note: The following fields are mutually exclusive: `day_of_week_value`, `integer_value`, `float_value`, `string_value`, `boolean_value`, `timestamp_value`, `time_value`, `date_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Value
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for infoType-dependent details parsed from quote.
        # @!attribute [rw] date_time
        #   @return [::Google::Cloud::Dlp::V2::DateTime]
        #     The date time indicated by the quote.
        class QuoteInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message for a date time object.
        # e.g. 2018-01-01, 5th August.
        # @!attribute [rw] date
        #   @return [::Google::Type::Date]
        #     One or more of the following must be set.
        #     Must be a valid date or time value.
        # @!attribute [rw] day_of_week
        #   @return [::Google::Type::DayOfWeek]
        #     Day of week
        # @!attribute [rw] time
        #   @return [::Google::Type::TimeOfDay]
        #     Time of day
        # @!attribute [rw] time_zone
        #   @return [::Google::Cloud::Dlp::V2::DateTime::TimeZone]
        #     Time zone
        class DateTime
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Time zone of the date time object.
          # @!attribute [rw] offset_minutes
          #   @return [::Integer]
          #     Set only if the offset can be determined. Positive for time ahead of UTC.
          #     E.g. For "UTC-9", this value is -540.
          class TimeZone
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The configuration that controls how the data will change.
        # @!attribute [rw] info_type_transformations
        #   @return [::Google::Cloud::Dlp::V2::InfoTypeTransformations]
        #     Treat the dataset as free-form text and apply the same free text
        #     transformation everywhere.
        #
        #     Note: The following fields are mutually exclusive: `info_type_transformations`, `record_transformations`, `image_transformations`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] record_transformations
        #   @return [::Google::Cloud::Dlp::V2::RecordTransformations]
        #     Treat the dataset as structured. Transformations can be applied to
        #     specific locations within structured datasets, such as transforming
        #     a column within a table.
        #
        #     Note: The following fields are mutually exclusive: `record_transformations`, `info_type_transformations`, `image_transformations`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] image_transformations
        #   @return [::Google::Cloud::Dlp::V2::ImageTransformations]
        #     Treat the dataset as an image and redact.
        #
        #     Note: The following fields are mutually exclusive: `image_transformations`, `info_type_transformations`, `record_transformations`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] transformation_error_handling
        #   @return [::Google::Cloud::Dlp::V2::TransformationErrorHandling]
        #     Mode for handling transformation errors. If left unspecified, the default
        #     mode is `TransformationErrorHandling.ThrowError`.
        class DeidentifyConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A type of transformation that is applied over images.
        # @!attribute [rw] transforms
        #   @return [::Array<::Google::Cloud::Dlp::V2::ImageTransformations::ImageTransformation>]
        #     List of transforms to make.
        class ImageTransformations
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration for determining how redaction of images should occur.
          # @!attribute [rw] selected_info_types
          #   @return [::Google::Cloud::Dlp::V2::ImageTransformations::ImageTransformation::SelectedInfoTypes]
          #     Apply transformation to the selected info_types.
          #
          #     Note: The following fields are mutually exclusive: `selected_info_types`, `all_info_types`, `all_text`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] all_info_types
          #   @return [::Google::Cloud::Dlp::V2::ImageTransformations::ImageTransformation::AllInfoTypes]
          #     Apply transformation to all findings not specified in other
          #     ImageTransformation's selected_info_types. Only one instance is allowed
          #     within the ImageTransformations message.
          #
          #     Note: The following fields are mutually exclusive: `all_info_types`, `selected_info_types`, `all_text`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] all_text
          #   @return [::Google::Cloud::Dlp::V2::ImageTransformations::ImageTransformation::AllText]
          #     Apply transformation to all text that doesn't match an infoType. Only
          #     one instance is allowed within the ImageTransformations message.
          #
          #     Note: The following fields are mutually exclusive: `all_text`, `selected_info_types`, `all_info_types`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] redaction_color
          #   @return [::Google::Cloud::Dlp::V2::Color]
          #     The color to use when redacting content from an image. If not
          #     specified, the default is black.
          class ImageTransformation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Apply transformation to the selected info_types.
            # @!attribute [rw] info_types
            #   @return [::Array<::Google::Cloud::Dlp::V2::InfoType>]
            #     Required. InfoTypes to apply the transformation to. Required. Provided
            #     InfoType must be unique within the ImageTransformations message.
            class SelectedInfoTypes
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Apply transformation to all findings.
            class AllInfoTypes
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Apply to all text.
            class AllText
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # How to handle transformation errors during de-identification. A
        # transformation error occurs when the requested transformation is incompatible
        # with the data. For example, trying to de-identify an IP address using a
        # `DateShift` transformation would result in a transformation error, since date
        # info cannot be extracted from an IP address.
        # Information about any incompatible transformations, and how they were
        # handled, is returned in the response as part of the
        # `TransformationOverviews`.
        # @!attribute [rw] throw_error
        #   @return [::Google::Cloud::Dlp::V2::TransformationErrorHandling::ThrowError]
        #     Throw an error
        #
        #     Note: The following fields are mutually exclusive: `throw_error`, `leave_untransformed`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] leave_untransformed
        #   @return [::Google::Cloud::Dlp::V2::TransformationErrorHandling::LeaveUntransformed]
        #     Ignore errors
        #
        #     Note: The following fields are mutually exclusive: `leave_untransformed`, `throw_error`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class TransformationErrorHandling
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Throw an error and fail the request when a transformation error occurs.
          class ThrowError
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Skips the data without modifying it if the requested transformation would
          # cause an error. For example, if a `DateShift` transformation were applied
          # an an IP address, this mode would leave the IP address unchanged in the
          # response.
          class LeaveUntransformed
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A rule for transforming a value.
        # @!attribute [rw] replace_config
        #   @return [::Google::Cloud::Dlp::V2::ReplaceValueConfig]
        #     Replace with a specified value.
        #
        #     Note: The following fields are mutually exclusive: `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] redact_config
        #   @return [::Google::Cloud::Dlp::V2::RedactConfig]
        #     Redact
        #
        #     Note: The following fields are mutually exclusive: `redact_config`, `replace_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] character_mask_config
        #   @return [::Google::Cloud::Dlp::V2::CharacterMaskConfig]
        #     Mask
        #
        #     Note: The following fields are mutually exclusive: `character_mask_config`, `replace_config`, `redact_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] crypto_replace_ffx_fpe_config
        #   @return [::Google::Cloud::Dlp::V2::CryptoReplaceFfxFpeConfig]
        #     Ffx-Fpe. Strongly discouraged, consider using CryptoDeterministicConfig
        #     instead. Fpe is computationally expensive incurring latency costs.
        #
        #     Note: The following fields are mutually exclusive: `crypto_replace_ffx_fpe_config`, `replace_config`, `redact_config`, `character_mask_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] fixed_size_bucketing_config
        #   @return [::Google::Cloud::Dlp::V2::FixedSizeBucketingConfig]
        #     Fixed size bucketing
        #
        #     Note: The following fields are mutually exclusive: `fixed_size_bucketing_config`, `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bucketing_config
        #   @return [::Google::Cloud::Dlp::V2::BucketingConfig]
        #     Bucketing
        #
        #     Note: The following fields are mutually exclusive: `bucketing_config`, `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] replace_with_info_type_config
        #   @return [::Google::Cloud::Dlp::V2::ReplaceWithInfoTypeConfig]
        #     Replace with infotype
        #
        #     Note: The following fields are mutually exclusive: `replace_with_info_type_config`, `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] time_part_config
        #   @return [::Google::Cloud::Dlp::V2::TimePartConfig]
        #     Time extraction
        #
        #     Note: The following fields are mutually exclusive: `time_part_config`, `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] crypto_hash_config
        #   @return [::Google::Cloud::Dlp::V2::CryptoHashConfig]
        #     Crypto
        #
        #     Note: The following fields are mutually exclusive: `crypto_hash_config`, `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `date_shift_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] date_shift_config
        #   @return [::Google::Cloud::Dlp::V2::DateShiftConfig]
        #     Date Shift
        #
        #     Note: The following fields are mutually exclusive: `date_shift_config`, `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `crypto_deterministic_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] crypto_deterministic_config
        #   @return [::Google::Cloud::Dlp::V2::CryptoDeterministicConfig]
        #     Deterministic Crypto
        #
        #     Note: The following fields are mutually exclusive: `crypto_deterministic_config`, `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `replace_dictionary_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] replace_dictionary_config
        #   @return [::Google::Cloud::Dlp::V2::ReplaceDictionaryConfig]
        #     Replace with a value randomly drawn (with replacement) from a dictionary.
        #
        #     Note: The following fields are mutually exclusive: `replace_dictionary_config`, `replace_config`, `redact_config`, `character_mask_config`, `crypto_replace_ffx_fpe_config`, `fixed_size_bucketing_config`, `bucketing_config`, `replace_with_info_type_config`, `time_part_config`, `crypto_hash_config`, `date_shift_config`, `crypto_deterministic_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class PrimitiveTransformation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # For use with `Date`, `Timestamp`, and `TimeOfDay`, extract or preserve a
        # portion of the value.
        # @!attribute [rw] part_to_extract
        #   @return [::Google::Cloud::Dlp::V2::TimePartConfig::TimePart]
        #     The part of the time to keep.
        class TimePartConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Components that make up time.
          module TimePart
            # Unused
            TIME_PART_UNSPECIFIED = 0

            # [0-9999]
            YEAR = 1

            # [1-12]
            MONTH = 2

            # [1-31]
            DAY_OF_MONTH = 3

            # [1-7]
            DAY_OF_WEEK = 4

            # [1-53]
            WEEK_OF_YEAR = 5

            # [0-23]
            HOUR_OF_DAY = 6
          end
        end

        # Pseudonymization method that generates surrogates via cryptographic hashing.
        # Uses SHA-256.
        # The key size must be either 32 or 64 bytes.
        # Outputs a base64 encoded representation of the hashed output
        # (for example, L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=).
        # Currently, only string and integer values can be hashed.
        # See https://cloud.google.com/sensitive-data-protection/docs/pseudonymization
        # to learn more.
        # @!attribute [rw] crypto_key
        #   @return [::Google::Cloud::Dlp::V2::CryptoKey]
        #     The key used by the hash function.
        class CryptoHashConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Pseudonymization method that generates deterministic encryption for the given
        # input. Outputs a base64 encoded representation of the encrypted output.
        # Uses AES-SIV based on the RFC https://tools.ietf.org/html/rfc5297.
        # @!attribute [rw] crypto_key
        #   @return [::Google::Cloud::Dlp::V2::CryptoKey]
        #     The key used by the encryption function. For deterministic encryption
        #     using AES-SIV, the provided key is internally expanded to 64 bytes prior to
        #     use.
        # @!attribute [rw] surrogate_info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     The custom info type to annotate the surrogate with.
        #     This annotation will be applied to the surrogate by prefixing it with
        #     the name of the custom info type followed by the number of
        #     characters comprising the surrogate. The following scheme defines the
        #     format: \\{info type name}(\\{surrogate character count}):\\{surrogate}
        #
        #     For example, if the name of custom info type is 'MY_TOKEN_INFO_TYPE' and
        #     the surrogate is 'abc', the full replacement value
        #     will be: 'MY_TOKEN_INFO_TYPE(3):abc'
        #
        #     This annotation identifies the surrogate when inspecting content using the
        #     custom info type 'Surrogate'. This facilitates reversal of the
        #     surrogate when it occurs in free text.
        #
        #     Note: For record transformations where the entire cell in a table is being
        #     transformed, surrogates are not mandatory. Surrogates are used to denote
        #     the location of the token and are necessary for re-identification in free
        #     form text.
        #
        #     In order for inspection to work properly, the name of this info type must
        #     not occur naturally anywhere in your data; otherwise, inspection may either
        #
        #     - reverse a surrogate that does not correspond to an actual identifier
        #     - be unable to parse the surrogate and result in an error
        #
        #     Therefore, choose your custom info type name carefully after considering
        #     what your data looks like. One way to select a name that has a high chance
        #     of yielding reliable detection is to include one or more unicode characters
        #     that are highly improbable to exist in your data.
        #     For example, assuming your data is entered from a regular ASCII keyboard,
        #     the symbol with the hex code point 29DD might be used like so:
        #     ⧝MY_TOKEN_TYPE.
        # @!attribute [rw] context
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     A context may be used for higher security and maintaining
        #     referential integrity such that the same identifier in two different
        #     contexts will be given a distinct surrogate. The context is appended to
        #     plaintext value being encrypted. On decryption the provided context is
        #     validated against the value used during encryption. If a context was
        #     provided during encryption, same context must be provided during decryption
        #     as well.
        #
        #     If the context is not set, plaintext would be used as is for encryption.
        #     If the context is set but:
        #
        #     1. there is no record present when transforming a given value or
        #     2. the field is not present when transforming a given value,
        #
        #     plaintext would be used as is for encryption.
        #
        #     Note that case (1) is expected when an `InfoTypeTransformation` is
        #     applied to both structured and unstructured `ContentItem`s.
        class CryptoDeterministicConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Replace each input value with a given `Value`.
        # @!attribute [rw] new_value
        #   @return [::Google::Cloud::Dlp::V2::Value]
        #     Value to replace it with.
        class ReplaceValueConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Replace each input value with a value randomly selected from the dictionary.
        # @!attribute [rw] word_list
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Dictionary::WordList]
        #     A list of words to select from for random replacement. The
        #     [limits](https://cloud.google.com/sensitive-data-protection/limits) page
        #     contains details about the size limits of dictionaries.
        class ReplaceDictionaryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Replace each matching finding with the name of the info_type.
        class ReplaceWithInfoTypeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Redact a given value. For example, if used with an `InfoTypeTransformation`
        # transforming PHONE_NUMBER, and input 'My phone number is 206-555-0123', the
        # output would be 'My phone number is '.
        class RedactConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Characters to skip when doing deidentification of a value. These will be left
        # alone and skipped.
        # @!attribute [rw] characters_to_skip
        #   @return [::String]
        #     Characters to not transform when masking.
        #
        #     Note: The following fields are mutually exclusive: `characters_to_skip`, `common_characters_to_ignore`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] common_characters_to_ignore
        #   @return [::Google::Cloud::Dlp::V2::CharsToIgnore::CommonCharsToIgnore]
        #     Common characters to not transform when masking. Useful to avoid removing
        #     punctuation.
        #
        #     Note: The following fields are mutually exclusive: `common_characters_to_ignore`, `characters_to_skip`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class CharsToIgnore
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Convenience enum for indicating common characters to not transform.
          module CommonCharsToIgnore
            # Unused.
            COMMON_CHARS_TO_IGNORE_UNSPECIFIED = 0

            # 0-9
            NUMERIC = 1

            # A-Z
            ALPHA_UPPER_CASE = 2

            # a-z
            ALPHA_LOWER_CASE = 3

            # US Punctuation, one of !"#$%&'()*+,-./:;<=>?@[\]^_`{|}~
            PUNCTUATION = 4

            # Whitespace character, one of [ \t\n\x0B\f\r]
            WHITESPACE = 5
          end
        end

        # Partially mask a string by replacing a given number of characters with a
        # fixed character. Masking can start from the beginning or end of the string.
        # This can be used on data of any type (numbers, longs, and so on) and when
        # de-identifying structured data we'll attempt to preserve the original data's
        # type. (This allows you to take a long like 123 and modify it to a string like
        # **3.
        # @!attribute [rw] masking_character
        #   @return [::String]
        #     Character to use to mask the sensitive values&mdash;for example, `*` for an
        #     alphabetic string such as a name, or `0` for a numeric string such as ZIP
        #     code or credit card number. This string must have a length of 1. If not
        #     supplied, this value defaults to `*` for strings, and `0` for digits.
        # @!attribute [rw] number_to_mask
        #   @return [::Integer]
        #     Number of characters to mask. If not set, all matching chars will be
        #     masked. Skipped characters do not count towards this tally.
        #
        #     If `number_to_mask` is negative, this denotes inverse masking. Cloud DLP
        #     masks all but a number of characters.
        #     For example, suppose you have the following values:
        #
        #     - `masking_character` is `*`
        #     - `number_to_mask` is `-4`
        #     - `reverse_order` is `false`
        #     - `CharsToIgnore` includes `-`
        #     - Input string is `1234-5678-9012-3456`
        #
        #     The resulting de-identified string is
        #     `****-****-****-3456`. Cloud DLP masks all but the last four characters.
        #     If `reverse_order` is `true`, all but the first four characters are masked
        #     as `1234-****-****-****`.
        # @!attribute [rw] reverse_order
        #   @return [::Boolean]
        #     Mask characters in reverse order. For example, if `masking_character` is
        #     `0`, `number_to_mask` is `14`, and `reverse_order` is `false`, then the
        #     input string `1234-5678-9012-3456` is masked as `00000000000000-3456`.
        #     If `masking_character` is `*`, `number_to_mask` is `3`, and `reverse_order`
        #     is `true`, then the string `12345` is masked as `12***`.
        # @!attribute [rw] characters_to_ignore
        #   @return [::Array<::Google::Cloud::Dlp::V2::CharsToIgnore>]
        #     When masking a string, items in this list will be skipped when replacing
        #     characters. For example, if the input string is `555-555-5555` and you
        #     instruct Cloud DLP to skip `-` and mask 5 characters with `*`, Cloud DLP
        #     returns `***-**5-5555`.
        class CharacterMaskConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Buckets values based on fixed size ranges. The
        # Bucketing transformation can provide all of this functionality,
        # but requires more configuration. This message is provided as a convenience to
        # the user for simple bucketing strategies.
        #
        # The transformed value will be a hyphenated string of
        # \\{lower_bound}-\\{upper_bound}. For example, if lower_bound = 10 and upper_bound
        # = 20, all values that are within this bucket will be replaced with "10-20".
        #
        # This can be used on data of type: double, long.
        #
        # If the bound Value type differs from the type of data
        # being transformed, we will first attempt converting the type of the data to
        # be transformed to match the type of the bound before comparing.
        #
        # See
        # https://cloud.google.com/sensitive-data-protection/docs/concepts-bucketing to
        # learn more.
        # @!attribute [rw] lower_bound
        #   @return [::Google::Cloud::Dlp::V2::Value]
        #     Required. Lower bound value of buckets. All values less than `lower_bound`
        #     are grouped together into a single bucket; for example if `lower_bound` =
        #     10, then all values less than 10 are replaced with the value "-10".
        # @!attribute [rw] upper_bound
        #   @return [::Google::Cloud::Dlp::V2::Value]
        #     Required. Upper bound value of buckets. All values greater than upper_bound
        #     are grouped together into a single bucket; for example if `upper_bound` =
        #     89, then all values greater than 89 are replaced with the value "89+".
        # @!attribute [rw] bucket_size
        #   @return [::Float]
        #     Required. Size of each bucket (except for minimum and maximum buckets). So
        #     if `lower_bound` = 10, `upper_bound` = 89, and `bucket_size` = 10, then the
        #     following buckets would be used: -10, 10-20, 20-30, 30-40, 40-50, 50-60,
        #     60-70, 70-80, 80-89, 89+. Precision up to 2 decimals works.
        class FixedSizeBucketingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Generalization function that buckets values based on ranges. The ranges and
        # replacement values are dynamically provided by the user for custom behavior,
        # such as 1-30 -> LOW, 31-65 -> MEDIUM, 66-100 -> HIGH.
        #
        # This can be used on data of type: number, long, string, timestamp.
        #
        # If the bound `Value` type differs from the type of data being transformed, we
        # will first attempt converting the type of the data to be transformed to match
        # the type of the bound before comparing.
        # See
        # https://cloud.google.com/sensitive-data-protection/docs/concepts-bucketing to
        # learn more.
        # @!attribute [rw] buckets
        #   @return [::Array<::Google::Cloud::Dlp::V2::BucketingConfig::Bucket>]
        #     Set of buckets. Ranges must be non-overlapping.
        class BucketingConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Bucket is represented as a range, along with replacement values.
          # @!attribute [rw] min
          #   @return [::Google::Cloud::Dlp::V2::Value]
          #     Lower bound of the range, inclusive. Type should be the same as max if
          #     used.
          # @!attribute [rw] max
          #   @return [::Google::Cloud::Dlp::V2::Value]
          #     Upper bound of the range, exclusive; type must match min.
          # @!attribute [rw] replacement_value
          #   @return [::Google::Cloud::Dlp::V2::Value]
          #     Required. Replacement value for this bucket.
          class Bucket
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Replaces an identifier with a surrogate using Format Preserving Encryption
        # (FPE) with the FFX mode of operation; however when used in the
        # `ReidentifyContent` API method, it serves the opposite function by reversing
        # the surrogate back into the original identifier. The identifier must be
        # encoded as ASCII. For a given crypto key and context, the same identifier
        # will be replaced with the same surrogate. Identifiers must be at least two
        # characters long. In the case that the identifier is the empty string, it will
        # be skipped. See
        # https://cloud.google.com/sensitive-data-protection/docs/pseudonymization to
        # learn more.
        #
        # Note: We recommend using  CryptoDeterministicConfig for all use cases which
        # do not require preserving the input alphabet space and size, plus warrant
        # referential integrity. FPE incurs significant latency costs.
        # @!attribute [rw] crypto_key
        #   @return [::Google::Cloud::Dlp::V2::CryptoKey]
        #     Required. The key used by the encryption algorithm.
        # @!attribute [rw] context
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     The 'tweak', a context may be used for higher security since the same
        #     identifier in two different contexts won't be given the same surrogate. If
        #     the context is not set, a default tweak will be used.
        #
        #     If the context is set but:
        #
        #     1. there is no record present when transforming a given value or
        #     1. the field is not present when transforming a given value,
        #
        #     a default tweak will be used.
        #
        #     Note that case (1) is expected when an `InfoTypeTransformation` is
        #     applied to both structured and unstructured `ContentItem`s.
        #     Currently, the referenced field may be of value type integer or string.
        #
        #     The tweak is constructed as a sequence of bytes in big endian byte order
        #     such that:
        #
        #     - a 64 bit integer is encoded followed by a single byte of value 1
        #     - a string is encoded in UTF-8 format followed by a single byte of value 2
        # @!attribute [rw] common_alphabet
        #   @return [::Google::Cloud::Dlp::V2::CryptoReplaceFfxFpeConfig::FfxCommonNativeAlphabet]
        #     Common alphabets.
        #
        #     Note: The following fields are mutually exclusive: `common_alphabet`, `custom_alphabet`, `radix`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] custom_alphabet
        #   @return [::String]
        #     This is supported by mapping these to the alphanumeric characters
        #     that the FFX mode natively supports. This happens before/after
        #     encryption/decryption.
        #     Each character listed must appear only once.
        #     Number of characters must be in the range [2, 95].
        #     This must be encoded as ASCII.
        #     The order of characters does not matter.
        #     The full list of allowed characters is:
        #     ``0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz~`!@#$%^&*()_-+={[}]|\:;"'<,>.?/``
        #
        #     Note: The following fields are mutually exclusive: `custom_alphabet`, `common_alphabet`, `radix`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] radix
        #   @return [::Integer]
        #     The native way to select the alphabet. Must be in the range [2, 95].
        #
        #     Note: The following fields are mutually exclusive: `radix`, `common_alphabet`, `custom_alphabet`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] surrogate_info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     The custom infoType to annotate the surrogate with.
        #     This annotation will be applied to the surrogate by prefixing it with
        #     the name of the custom infoType followed by the number of
        #     characters comprising the surrogate. The following scheme defines the
        #     format: info_type_name(surrogate_character_count):surrogate
        #
        #     For example, if the name of custom infoType is 'MY_TOKEN_INFO_TYPE' and
        #     the surrogate is 'abc', the full replacement value
        #     will be: 'MY_TOKEN_INFO_TYPE(3):abc'
        #
        #     This annotation identifies the surrogate when inspecting content using the
        #     custom infoType
        #     [`SurrogateType`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/InspectConfig#surrogatetype).
        #     This facilitates reversal of the surrogate when it occurs in free text.
        #
        #     In order for inspection to work properly, the name of this infoType must
        #     not occur naturally anywhere in your data; otherwise, inspection may
        #     find a surrogate that does not correspond to an actual identifier.
        #     Therefore, choose your custom infoType name carefully after considering
        #     what your data looks like. One way to select a name that has a high chance
        #     of yielding reliable detection is to include one or more unicode characters
        #     that are highly improbable to exist in your data.
        #     For example, assuming your data is entered from a regular ASCII keyboard,
        #     the symbol with the hex code point 29DD might be used like so:
        #     ⧝MY_TOKEN_TYPE
        class CryptoReplaceFfxFpeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # These are commonly used subsets of the alphabet that the FFX mode
          # natively supports. In the algorithm, the alphabet is selected using
          # the "radix". Therefore each corresponds to a particular radix.
          module FfxCommonNativeAlphabet
            # Unused.
            FFX_COMMON_NATIVE_ALPHABET_UNSPECIFIED = 0

            # `[0-9]` (radix of 10)
            NUMERIC = 1

            # `[0-9A-F]` (radix of 16)
            HEXADECIMAL = 2

            # `[0-9A-Z]` (radix of 36)
            UPPER_CASE_ALPHA_NUMERIC = 3

            # `[0-9A-Za-z]` (radix of 62)
            ALPHA_NUMERIC = 4
          end
        end

        # This is a data encryption key (DEK) (as opposed to
        # a key encryption key (KEK) stored by Cloud Key Management Service
        # (Cloud KMS).
        # When using Cloud KMS to wrap or unwrap a DEK, be sure to set an appropriate
        # IAM policy on the KEK to ensure an attacker cannot
        # unwrap the DEK.
        # @!attribute [rw] transient
        #   @return [::Google::Cloud::Dlp::V2::TransientCryptoKey]
        #     Transient crypto key
        #
        #     Note: The following fields are mutually exclusive: `transient`, `unwrapped`, `kms_wrapped`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] unwrapped
        #   @return [::Google::Cloud::Dlp::V2::UnwrappedCryptoKey]
        #     Unwrapped crypto key
        #
        #     Note: The following fields are mutually exclusive: `unwrapped`, `transient`, `kms_wrapped`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] kms_wrapped
        #   @return [::Google::Cloud::Dlp::V2::KmsWrappedCryptoKey]
        #     Key wrapped using Cloud KMS
        #
        #     Note: The following fields are mutually exclusive: `kms_wrapped`, `transient`, `unwrapped`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class CryptoKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Use this to have a random data crypto key generated.
        # It will be discarded after the request finishes.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the key.
        #     This is an arbitrary string used to differentiate different keys.
        #     A unique key is generated per name: two separate `TransientCryptoKey`
        #     protos share the same generated key if their names are the same.
        #     When the data crypto key is generated, this name is not used in any way
        #     (repeating the api call will result in a different key being generated).
        class TransientCryptoKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Using raw keys is prone to security risks due to accidentally
        # leaking the key. Choose another type of key if possible.
        # @!attribute [rw] key
        #   @return [::String]
        #     Required. A 128/192/256 bit key.
        class UnwrappedCryptoKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Include to use an existing data crypto key wrapped by KMS.
        # The wrapped key must be a 128-, 192-, or 256-bit key.
        # Authorization requires the following IAM permissions when sending a request
        # to perform a crypto transformation using a KMS-wrapped crypto key:
        # dlp.kms.encrypt
        #
        # For more information, see [Creating a wrapped key]
        # (https://cloud.google.com/sensitive-data-protection/docs/create-wrapped-key).
        #
        # Note: When you use Cloud KMS for cryptographic operations,
        # [charges apply](https://cloud.google.com/kms/pricing).
        # @!attribute [rw] wrapped_key
        #   @return [::String]
        #     Required. The wrapped data crypto key.
        # @!attribute [rw] crypto_key_name
        #   @return [::String]
        #     Required. The resource name of the KMS CryptoKey to use for unwrapping.
        class KmsWrappedCryptoKey
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Shifts dates by random number of days, with option to be consistent for the
        # same context. See
        # https://cloud.google.com/sensitive-data-protection/docs/concepts-date-shifting
        # to learn more.
        # @!attribute [rw] upper_bound_days
        #   @return [::Integer]
        #     Required. Range of shift in days. Actual shift will be selected at random
        #     within this range (inclusive ends). Negative means shift to earlier in
        #     time. Must not be more than 365250 days (1000 years) each direction.
        #
        #     For example, 3 means shift date to at most 3 days into the future.
        # @!attribute [rw] lower_bound_days
        #   @return [::Integer]
        #     Required. For example, -5 means shift date to at most 5 days back in the
        #     past.
        # @!attribute [rw] context
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     Points to the field that contains the context, for example, an entity id.
        #     If set, must also set cryptoKey. If set, shift will be consistent for the
        #     given context.
        # @!attribute [rw] crypto_key
        #   @return [::Google::Cloud::Dlp::V2::CryptoKey]
        #     Causes the shift to be computed based on this key and the context. This
        #     results in the same shift for the same context and crypto_key. If
        #     set, must also set context. Can only be applied to table items.
        class DateShiftConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A type of transformation that will scan unstructured text and
        # apply various `PrimitiveTransformation`s to each finding, where the
        # transformation is applied to only values that were identified as a specific
        # info_type.
        # @!attribute [rw] transformations
        #   @return [::Array<::Google::Cloud::Dlp::V2::InfoTypeTransformations::InfoTypeTransformation>]
        #     Required. Transformation for each infoType. Cannot specify more than one
        #     for a given infoType.
        class InfoTypeTransformations
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A transformation to apply to text that is identified as a specific
          # info_type.
          # @!attribute [rw] info_types
          #   @return [::Array<::Google::Cloud::Dlp::V2::InfoType>]
          #     InfoTypes to apply the transformation to. An empty list will cause
          #     this transformation to apply to all findings that correspond to
          #     infoTypes that were requested in `InspectConfig`.
          # @!attribute [rw] primitive_transformation
          #   @return [::Google::Cloud::Dlp::V2::PrimitiveTransformation]
          #     Required. Primitive transformation to apply to the infoType.
          class InfoTypeTransformation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The transformation to apply to the field.
        # @!attribute [rw] fields
        #   @return [::Array<::Google::Cloud::Dlp::V2::FieldId>]
        #     Required. Input field(s) to apply the transformation to.
        #     When you have columns that reference their position within a list,
        #     omit the index from the FieldId. FieldId name matching ignores the index.
        #     For example, instead of "contact.nums[0].type", use "contact.nums.type".
        # @!attribute [rw] condition
        #   @return [::Google::Cloud::Dlp::V2::RecordCondition]
        #     Only apply the transformation if the condition evaluates to true for the
        #     given `RecordCondition`. The conditions are allowed to reference fields
        #     that are not used in the actual transformation.
        #
        #     Example Use Cases:
        #
        #     - Apply a different bucket transformation to an age column if the zip code
        #     column for the same record is within a specific range.
        #     - Redact a field if the date of birth field is greater than 85.
        # @!attribute [rw] primitive_transformation
        #   @return [::Google::Cloud::Dlp::V2::PrimitiveTransformation]
        #     Apply the transformation to the entire field.
        #
        #     Note: The following fields are mutually exclusive: `primitive_transformation`, `info_type_transformations`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] info_type_transformations
        #   @return [::Google::Cloud::Dlp::V2::InfoTypeTransformations]
        #     Treat the contents of the field as free text, and selectively
        #     transform content that matches an `InfoType`.
        #
        #     Note: The following fields are mutually exclusive: `info_type_transformations`, `primitive_transformation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class FieldTransformation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A type of transformation that is applied over structured data such as a
        # table.
        # @!attribute [rw] field_transformations
        #   @return [::Array<::Google::Cloud::Dlp::V2::FieldTransformation>]
        #     Transform the record by applying various field transformations.
        # @!attribute [rw] record_suppressions
        #   @return [::Array<::Google::Cloud::Dlp::V2::RecordSuppression>]
        #     Configuration defining which records get suppressed entirely. Records that
        #     match any suppression rule are omitted from the output.
        class RecordTransformations
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration to suppress records whose suppression conditions evaluate to
        # true.
        # @!attribute [rw] condition
        #   @return [::Google::Cloud::Dlp::V2::RecordCondition]
        #     A condition that when it evaluates to true will result in the record being
        #     evaluated to be suppressed from the transformed content.
        class RecordSuppression
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A condition for determining whether a transformation should be applied to
        # a field.
        # @!attribute [rw] expressions
        #   @return [::Google::Cloud::Dlp::V2::RecordCondition::Expressions]
        #     An expression.
        class RecordCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The field type of `value` and `field` do not need to match to be
          # considered equal, but not all comparisons are possible.
          # EQUAL_TO and NOT_EQUAL_TO attempt to compare even with incompatible types,
          # but all other comparisons are invalid with incompatible types.
          # A `value` of type:
          #
          # - `string` can be compared against all other types
          # - `boolean` can only be compared against other booleans
          # - `integer` can be compared against doubles or a string if the string value
          # can be parsed as an integer.
          # - `double` can be compared against integers or a string if the string can
          # be parsed as a double.
          # - `Timestamp` can be compared against strings in RFC 3339 date string
          # format.
          # - `TimeOfDay` can be compared against timestamps and strings in the format
          # of 'HH:mm:ss'.
          #
          # If we fail to compare do to type mismatch, a warning will be given and
          # the condition will evaluate to false.
          # @!attribute [rw] field
          #   @return [::Google::Cloud::Dlp::V2::FieldId]
          #     Required. Field within the record this condition is evaluated against.
          # @!attribute [rw] operator
          #   @return [::Google::Cloud::Dlp::V2::RelationalOperator]
          #     Required. Operator used to compare the field or infoType to the value.
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dlp::V2::Value]
          #     Value to compare against. [Mandatory, except for `EXISTS` tests.]
          class Condition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A collection of conditions.
          # @!attribute [rw] conditions
          #   @return [::Array<::Google::Cloud::Dlp::V2::RecordCondition::Condition>]
          #     A collection of conditions.
          class Conditions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An expression, consisting of an operator and conditions.
          # @!attribute [rw] logical_operator
          #   @return [::Google::Cloud::Dlp::V2::RecordCondition::Expressions::LogicalOperator]
          #     The operator to apply to the result of conditions. Default and currently
          #     only supported value is `AND`.
          # @!attribute [rw] conditions
          #   @return [::Google::Cloud::Dlp::V2::RecordCondition::Conditions]
          #     Conditions to apply to the expression.
          class Expressions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Logical operators for conditional checks.
            module LogicalOperator
              # Unused
              LOGICAL_OPERATOR_UNSPECIFIED = 0

              # Conditional AND
              AND = 1
            end
          end
        end

        # Overview of the modifications that occurred.
        # @!attribute [rw] transformed_bytes
        #   @return [::Integer]
        #     Total size in bytes that were transformed in some way.
        # @!attribute [rw] transformation_summaries
        #   @return [::Array<::Google::Cloud::Dlp::V2::TransformationSummary>]
        #     Transformations applied to the dataset.
        class TransformationOverview
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Summary of a single transformation.
        # Only one of 'transformation', 'field_transformation', or 'record_suppress'
        # will be set.
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     Set if the transformation was limited to a specific InfoType.
        # @!attribute [rw] field
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     Set if the transformation was limited to a specific FieldId.
        # @!attribute [rw] transformation
        #   @return [::Google::Cloud::Dlp::V2::PrimitiveTransformation]
        #     The specific transformation these stats apply to.
        # @!attribute [rw] field_transformations
        #   @return [::Array<::Google::Cloud::Dlp::V2::FieldTransformation>]
        #     The field transformation that was applied.
        #     If multiple field transformations are requested for a single field,
        #     this list will contain all of them; otherwise, only one is supplied.
        # @!attribute [rw] record_suppress
        #   @return [::Google::Cloud::Dlp::V2::RecordSuppression]
        #     The specific suppression option these stats apply to.
        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Dlp::V2::TransformationSummary::SummaryResult>]
        #     Collection of all transformations that took place or had an error.
        # @!attribute [rw] transformed_bytes
        #   @return [::Integer]
        #     Total size in bytes that were transformed in some way.
        class TransformationSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A collection that informs the user the number of times a particular
          # `TransformationResultCode` and error details occurred.
          # @!attribute [rw] count
          #   @return [::Integer]
          #     Number of transformations counted by this result.
          # @!attribute [rw] code
          #   @return [::Google::Cloud::Dlp::V2::TransformationSummary::TransformationResultCode]
          #     Outcome of the transformation.
          # @!attribute [rw] details
          #   @return [::String]
          #     A place for warnings or errors to show up if a transformation didn't
          #     work as expected.
          class SummaryResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible outcomes of transformations.
          module TransformationResultCode
            # Unused
            TRANSFORMATION_RESULT_CODE_UNSPECIFIED = 0

            # Transformation completed without an error.
            SUCCESS = 1

            # Transformation had an error.
            ERROR = 2
          end
        end

        # A flattened description of a `PrimitiveTransformation` or
        # `RecordSuppression`.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dlp::V2::TransformationType]
        #     The transformation type.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of the transformation. This is empty for a
        #     RECORD_SUPPRESSION, or is the output of calling toString() on the
        #     `PrimitiveTransformation` protocol buffer message for any other type of
        #     transformation.
        # @!attribute [rw] condition
        #   @return [::String]
        #     A human-readable string representation of the `RecordCondition`
        #     corresponding to this transformation. Set if a `RecordCondition` was used
        #     to determine whether or not to apply this transformation.
        #
        #     Examples:
        #         * (age_field > 85)
        #         * (age_field <= 18)
        #         * (zip_field exists)
        #         * (zip_field == 01234) && (city_field != "Springville")
        #         * (zip_field == 01234) && (age_field <= 18) && (city_field exists)
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     Set if the transformation was limited to a specific `InfoType`.
        class TransformationDescription
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details about a single transformation. This object contains a description of
        # the transformation, information about whether the transformation was
        # successfully applied, and the precise location where the transformation
        # occurred. These details are stored in a user-specified BigQuery table.
        # @!attribute [rw] resource_name
        #   @return [::String]
        #     The name of the job that completed the transformation.
        # @!attribute [rw] container_name
        #   @return [::String]
        #     The top level name of the container where the transformation is located
        #     (this will be the source file name or table name).
        # @!attribute [rw] transformation
        #   @return [::Array<::Google::Cloud::Dlp::V2::TransformationDescription>]
        #     Description of transformation. This would only contain more than one
        #     element if there were multiple matching transformations and which one to
        #     apply was ambiguous. Not set for states that contain no transformation,
        #     currently only state that contains no transformation is
        #     TransformationResultStateType.METADATA_UNRETRIEVABLE.
        # @!attribute [rw] status_details
        #   @return [::Google::Cloud::Dlp::V2::TransformationResultStatus]
        #     Status of the transformation, if transformation was not successful, this
        #     will specify what caused it to fail, otherwise it will show that the
        #     transformation was successful.
        # @!attribute [rw] transformed_bytes
        #   @return [::Integer]
        #     The number of bytes that were transformed. If transformation was
        #     unsuccessful or did not take place because there was no content to
        #     transform, this will be zero.
        # @!attribute [rw] transformation_location
        #   @return [::Google::Cloud::Dlp::V2::TransformationLocation]
        #     The precise location of the transformed content in the original container.
        class TransformationDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Specifies the location of a transformation.
        # @!attribute [rw] finding_id
        #   @return [::String]
        #     For infotype transformations, link to the corresponding findings ID so
        #     that location information does not need to be duplicated. Each findings
        #     ID correlates to an entry in the findings output table, this table only
        #     gets created when users specify to save findings (add the save findings
        #     action to the request).
        #
        #     Note: The following fields are mutually exclusive: `finding_id`, `record_transformation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] record_transformation
        #   @return [::Google::Cloud::Dlp::V2::RecordTransformation]
        #     For record transformations, provide a field and container information.
        #
        #     Note: The following fields are mutually exclusive: `record_transformation`, `finding_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] container_type
        #   @return [::Google::Cloud::Dlp::V2::TransformationContainerType]
        #     Information about the functionality of the container where this finding
        #     occurred, if available.
        class TransformationLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The field in a record to transform.
        # @!attribute [rw] field_id
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     For record transformations, provide a field.
        # @!attribute [rw] container_timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Findings container modification timestamp, if applicable.
        # @!attribute [rw] container_version
        #   @return [::String]
        #     Container version, if available ("generation" for Cloud Storage).
        class RecordTransformation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The outcome of a transformation.
        # @!attribute [rw] result_status_type
        #   @return [::Google::Cloud::Dlp::V2::TransformationResultStatusType]
        #     Transformation result status type, this will be either SUCCESS, or it will
        #     be the reason for why the transformation was not completely successful.
        # @!attribute [rw] details
        #   @return [::Google::Rpc::Status]
        #     Detailed error codes and messages
        class TransformationResultStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Config for storing transformation details.
        # @!attribute [rw] table
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     The BigQuery table in which to store the output. This may be an existing
        #     table or in a new table in an existing dataset.
        #     If table_id is not set a new one will be generated for you with the
        #     following format:
        #     dlp_googleapis_transformation_details_yyyy_mm_dd_[dlp_job_id]. Pacific
        #     time zone will be used for generating the date details.
        class TransformationDetailsStorageConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Schedule for inspect job triggers.
        # @!attribute [rw] recurrence_period_duration
        #   @return [::Google::Protobuf::Duration]
        #     With this option a job is started on a regular periodic basis. For
        #     example: every day (86400 seconds).
        #
        #     A scheduled start time will be skipped if the previous
        #     execution has not ended when its scheduled time occurs.
        #
        #     This value must be set to a time duration greater than or equal
        #     to 1 day and can be no longer than 60 days.
        class Schedule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Job trigger option for hybrid jobs. Jobs must be manually created
        # and finished.
        class Manual
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The inspectTemplate contains a configuration (set of types of sensitive data
        # to be detected) to be used anywhere you otherwise would normally specify
        # InspectConfig. See
        # https://cloud.google.com/sensitive-data-protection/docs/concepts-templates to
        # learn more.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The template name.
        #
        #     The template will have one of the following formats:
        #     `projects/PROJECT_ID/inspectTemplates/TEMPLATE_ID` OR
        #     `organizations/ORGANIZATION_ID/inspectTemplates/TEMPLATE_ID`;
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name (max 256 chars).
        # @!attribute [rw] description
        #   @return [::String]
        #     Short description (max 256 chars).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of an inspectTemplate.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of an inspectTemplate.
        # @!attribute [rw] inspect_config
        #   @return [::Google::Cloud::Dlp::V2::InspectConfig]
        #     The core content of the template. Configuration of the scanning process.
        class InspectTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeidentifyTemplates contains instructions on how to de-identify content.
        # See
        # https://cloud.google.com/sensitive-data-protection/docs/concepts-templates to
        # learn more.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The template name.
        #
        #     The template will have one of the following formats:
        #     `projects/PROJECT_ID/deidentifyTemplates/TEMPLATE_ID` OR
        #     `organizations/ORGANIZATION_ID/deidentifyTemplates/TEMPLATE_ID`
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name (max 256 chars).
        # @!attribute [rw] description
        #   @return [::String]
        #     Short description (max 256 chars).
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of an inspectTemplate.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of an inspectTemplate.
        # @!attribute [rw] deidentify_config
        #   @return [::Google::Cloud::Dlp::V2::DeidentifyConfig]
        #     The core content of the template.
        class DeidentifyTemplate
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details information about an error encountered during job execution or
        # the results of an unsuccessful activation of the JobTrigger.
        # @!attribute [rw] details
        #   @return [::Google::Rpc::Status]
        #     Detailed error codes and messages.
        # @!attribute [rw] timestamps
        #   @return [::Array<::Google::Protobuf::Timestamp>]
        #     The times the error occurred. List includes the oldest timestamp and the
        #     last 9 timestamps.
        # @!attribute [rw] extra_info
        #   @return [::Google::Cloud::Dlp::V2::Error::ErrorExtraInfo]
        #     Additional information about the error.
        class Error
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Additional information about the error.
          module ErrorExtraInfo
            # Unused.
            ERROR_INFO_UNSPECIFIED = 0

            # Image scan is not available in the region.
            IMAGE_SCAN_UNAVAILABLE_IN_REGION = 1

            # File store cluster is not supported for profile generation.
            FILE_STORE_CLUSTER_UNSUPPORTED = 2
          end
        end

        # Contains a configuration to make API calls on a repeating basis.
        # See
        # https://cloud.google.com/sensitive-data-protection/docs/concepts-job-triggers
        # to learn more.
        # @!attribute [rw] name
        #   @return [::String]
        #     Unique resource name for the triggeredJob, assigned by the service when the
        #     triggeredJob is created, for example
        #     `projects/dlp-test-project/jobTriggers/53234423`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name (max 100 chars)
        # @!attribute [rw] description
        #   @return [::String]
        #     User provided description (max 256 chars)
        # @!attribute [rw] inspect_job
        #   @return [::Google::Cloud::Dlp::V2::InspectJobConfig]
        #     For inspect jobs, a snapshot of the configuration.
        # @!attribute [rw] triggers
        #   @return [::Array<::Google::Cloud::Dlp::V2::JobTrigger::Trigger>]
        #     A list of triggers which will be OR'ed together. Only one in the list
        #     needs to trigger for a job to be started. The list may contain only
        #     a single Schedule trigger and must have at least one object.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Cloud::Dlp::V2::Error>]
        #     Output only. A stream of errors encountered when the trigger was activated.
        #     Repeated errors may result in the JobTrigger automatically being paused.
        #     Will return the last 100 errors. Whenever the JobTrigger is modified
        #     this list will be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of a triggeredJob.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of a triggeredJob.
        # @!attribute [r] last_run_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of the last time this trigger executed.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::Dlp::V2::JobTrigger::Status]
        #     Required. A status for this trigger.
        class JobTrigger
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # What event needs to occur for a new job to be started.
          # @!attribute [rw] schedule
          #   @return [::Google::Cloud::Dlp::V2::Schedule]
          #     Create a job on a repeating basis based on the elapse of time.
          #
          #     Note: The following fields are mutually exclusive: `schedule`, `manual`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] manual
          #   @return [::Google::Cloud::Dlp::V2::Manual]
          #     For use with hybrid jobs. Jobs must be manually created and finished.
          #
          #     Note: The following fields are mutually exclusive: `manual`, `schedule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class Trigger
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Whether the trigger is currently active. If PAUSED or CANCELLED, no jobs
          # will be created with this configuration. The service may automatically
          # pause triggers experiencing frequent errors. To restart a job, set the
          # status to HEALTHY after correcting user errors.
          module Status
            # Unused.
            STATUS_UNSPECIFIED = 0

            # Trigger is healthy.
            HEALTHY = 1

            # Trigger is temporarily paused.
            PAUSED = 2

            # Trigger is cancelled and can not be resumed.
            CANCELLED = 3
          end
        end

        # A task to execute on the completion of a job.
        # See https://cloud.google.com/sensitive-data-protection/docs/concepts-actions
        # to learn more.
        # @!attribute [rw] save_findings
        #   @return [::Google::Cloud::Dlp::V2::Action::SaveFindings]
        #     Save resulting findings in a provided location.
        #
        #     Note: The following fields are mutually exclusive: `save_findings`, `pub_sub`, `publish_summary_to_cscc`, `publish_findings_to_cloud_data_catalog`, `publish_findings_to_dataplex_catalog`, `deidentify`, `job_notification_emails`, `publish_to_stackdriver`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pub_sub
        #   @return [::Google::Cloud::Dlp::V2::Action::PublishToPubSub]
        #     Publish a notification to a Pub/Sub topic.
        #
        #     Note: The following fields are mutually exclusive: `pub_sub`, `save_findings`, `publish_summary_to_cscc`, `publish_findings_to_cloud_data_catalog`, `publish_findings_to_dataplex_catalog`, `deidentify`, `job_notification_emails`, `publish_to_stackdriver`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] publish_summary_to_cscc
        #   @return [::Google::Cloud::Dlp::V2::Action::PublishSummaryToCscc]
        #     Publish summary to Cloud Security Command Center (Alpha).
        #
        #     Note: The following fields are mutually exclusive: `publish_summary_to_cscc`, `save_findings`, `pub_sub`, `publish_findings_to_cloud_data_catalog`, `publish_findings_to_dataplex_catalog`, `deidentify`, `job_notification_emails`, `publish_to_stackdriver`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] publish_findings_to_cloud_data_catalog
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Dlp::V2::Action::PublishFindingsToCloudDataCatalog]
        #     Deprecated because Data Catalog is being turned down. Use
        #     publish_findings_to_dataplex_catalog to publish findings to Dataplex
        #     Universal Catalog.
        #
        #     Note: The following fields are mutually exclusive: `publish_findings_to_cloud_data_catalog`, `save_findings`, `pub_sub`, `publish_summary_to_cscc`, `publish_findings_to_dataplex_catalog`, `deidentify`, `job_notification_emails`, `publish_to_stackdriver`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] publish_findings_to_dataplex_catalog
        #   @return [::Google::Cloud::Dlp::V2::Action::PublishFindingsToDataplexCatalog]
        #     Publish findings as an aspect to Dataplex Universal Catalog.
        #
        #     Note: The following fields are mutually exclusive: `publish_findings_to_dataplex_catalog`, `save_findings`, `pub_sub`, `publish_summary_to_cscc`, `publish_findings_to_cloud_data_catalog`, `deidentify`, `job_notification_emails`, `publish_to_stackdriver`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] deidentify
        #   @return [::Google::Cloud::Dlp::V2::Action::Deidentify]
        #     Create a de-identified copy of the input data.
        #
        #     Note: The following fields are mutually exclusive: `deidentify`, `save_findings`, `pub_sub`, `publish_summary_to_cscc`, `publish_findings_to_cloud_data_catalog`, `publish_findings_to_dataplex_catalog`, `job_notification_emails`, `publish_to_stackdriver`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] job_notification_emails
        #   @return [::Google::Cloud::Dlp::V2::Action::JobNotificationEmails]
        #     Sends an email when the job completes. The email goes to IAM project
        #     owners and technical [Essential
        #     Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
        #
        #     Note: The following fields are mutually exclusive: `job_notification_emails`, `save_findings`, `pub_sub`, `publish_summary_to_cscc`, `publish_findings_to_cloud_data_catalog`, `publish_findings_to_dataplex_catalog`, `deidentify`, `publish_to_stackdriver`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] publish_to_stackdriver
        #   @return [::Google::Cloud::Dlp::V2::Action::PublishToStackdriver]
        #     Enable Stackdriver metric dlp.googleapis.com/finding_count.
        #
        #     Note: The following fields are mutually exclusive: `publish_to_stackdriver`, `save_findings`, `pub_sub`, `publish_summary_to_cscc`, `publish_findings_to_cloud_data_catalog`, `publish_findings_to_dataplex_catalog`, `deidentify`, `job_notification_emails`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Action
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # If set, the detailed findings will be persisted to the specified
          # OutputStorageConfig. Only a single instance of this action can be
          # specified.
          # Compatible with: Inspect, Risk
          # @!attribute [rw] output_config
          #   @return [::Google::Cloud::Dlp::V2::OutputStorageConfig]
          #     Location to store findings outside of DLP.
          class SaveFindings
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Publish a message into a given Pub/Sub topic when DlpJob has completed. The
          # message contains a single field, `DlpJobName`, which is equal to the
          # finished job's
          # [`DlpJob.name`](https://cloud.google.com/sensitive-data-protection/docs/reference/rest/v2/projects.dlpJobs#DlpJob).
          # Compatible with: Inspect, Risk
          # @!attribute [rw] topic
          #   @return [::String]
          #     Cloud Pub/Sub topic to send notifications to. The topic must have given
          #     publishing access rights to the DLP API service account executing
          #     the long running DlpJob sending the notifications.
          #     Format is projects/\\{project}/topics/\\{topic}.
          class PublishToPubSub
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Publish the result summary of a DlpJob to [Security Command
          # Center](https://cloud.google.com/security-command-center). This action is
          # available for only projects that belong to an organization. This action
          # publishes the count of finding instances and their infoTypes. The summary
          # of findings are persisted in Security Command Center and are governed by
          # [service-specific policies for Security Command
          # Center](https://cloud.google.com/terms/service-terms). Only a single
          # instance of this action can be specified. Compatible with: Inspect
          class PublishSummaryToCscc
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Publish findings of a DlpJob to Data Catalog. In Data Catalog, tag
          # templates are applied to the resource that Cloud DLP scanned. Data
          # Catalog tag templates are stored in the same project and region where the
          # BigQuery table exists. For Cloud DLP to create and apply the tag template,
          # the Cloud DLP service agent must have the
          # `roles/datacatalog.tagTemplateOwner` permission on the project. The tag
          # template contains fields summarizing the results of the DlpJob. Any field
          # values previously written by another DlpJob are deleted. [InfoType naming
          # patterns][google.privacy.dlp.v2.InfoType] are strictly enforced when using
          # this feature.
          #
          # Findings are persisted in Data Catalog storage and are governed by
          # service-specific policies for Data Catalog. For more information, see
          # [Service Specific Terms](https://cloud.google.com/terms/service-terms).
          #
          # Only a single instance of this action can be specified. This action is
          # allowed only if all resources being scanned are BigQuery tables.
          # Compatible with: Inspect
          class PublishFindingsToCloudDataCatalog
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Publish findings of a DlpJob to Dataplex Universal Catalog as a
          # `sensitive-data-protection-job-result` aspect. For more information,
          # see [Send inspection results to Dataplex Universal Catalog as
          # aspects](https://cloud.google.com/sensitive-data-protection/docs/add-aspects-inspection-job).
          #
          # Aspects are stored in Dataplex Universal Catalog storage and are
          # governed by service-specific policies for Dataplex Universal Catalog. For
          # more information, see [Service Specific
          # Terms](https://cloud.google.com/terms/service-terms).
          #
          # Only a single instance of this action can be specified. This action is
          # allowed only if all resources being scanned are BigQuery tables.
          # Compatible with: Inspect
          class PublishFindingsToDataplexCatalog
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Create a de-identified copy of a storage bucket. Only compatible
          # with Cloud Storage buckets.
          #
          #
          # A TransformationDetail will be created for each transformation.
          #
          #
          # Compatible with: Inspection of Cloud Storage
          # @!attribute [rw] transformation_config
          #   @return [::Google::Cloud::Dlp::V2::TransformationConfig]
          #     User specified deidentify templates and configs for structured,
          #     unstructured, and image files.
          # @!attribute [rw] transformation_details_storage_config
          #   @return [::Google::Cloud::Dlp::V2::TransformationDetailsStorageConfig]
          #     Config for storing transformation details.
          #
          #     This field specifies the configuration for storing detailed metadata
          #     about each transformation performed during a de-identification process.
          #     The metadata is stored separately from the de-identified content itself
          #     and provides a granular record of both successful transformations and any
          #     failures that occurred.
          #
          #     Enabling this configuration is essential for users who need to access
          #     comprehensive information about the status, outcome, and specifics of
          #     each transformation. The details are captured in the
          #     {::Google::Cloud::Dlp::V2::TransformationDetails TransformationDetails}
          #     message for each operation.
          #
          #     Key use cases:
          #
          #     * **Auditing and compliance**
          #         * Provides a verifiable audit trail of de-identification activities,
          #         which is crucial for meeting regulatory requirements and internal
          #         data governance policies.
          #         * Logs what data was transformed, what transformations were applied,
          #         when they occurred, and their success status. This helps
          #         demonstrate accountability and due diligence in protecting
          #         sensitive data.
          #
          #     * **Troubleshooting and debugging**
          #         * Offers detailed error messages and context if a transformation
          #         fails. This information is useful for diagnosing and resolving
          #         issues in the de-identification pipeline.
          #         * Helps pinpoint the exact location and nature of failures, speeding
          #         up the debugging process.
          #
          #     * **Process verification and quality assurance**
          #         * Allows users to confirm that de-identification rules and
          #         transformations were applied correctly and consistently across
          #         the dataset as intended.
          #         * Helps in verifying the effectiveness of the chosen
          #         de-identification strategies.
          #
          #     * **Data lineage and impact analysis**
          #         * Creates a record of how data elements were modified, contributing
          #         to data lineage. This is useful for understanding the provenance
          #         of de-identified data.
          #         * Aids in assessing the potential impact of de-identification choices
          #         on downstream analytical processes or data usability.
          #
          #     * **Reporting and operational insights**
          #         * You can analyze the metadata stored in a queryable BigQuery table
          #         to generate reports on transformation success rates, common
          #         error types, processing volumes (e.g., transformedBytes), and the
          #         types of transformations applied.
          #         * These insights can inform optimization of de-identification
          #         configurations and resource planning.
          #
          #     To take advantage of these benefits, set this configuration. The stored
          #     details include a description of the transformation, success or
          #     error codes, error messages, the number of bytes transformed, the
          #     location of the transformed content, and identifiers for the job and
          #     source data.
          # @!attribute [rw] cloud_storage_output
          #   @return [::String]
          #     Required. User settable Cloud Storage bucket and folders to store
          #     de-identified files. This field must be set for Cloud Storage
          #     deidentification. The output Cloud Storage bucket must be different
          #     from the input bucket. De-identified files will overwrite files in the
          #     output path.
          #
          #     Form of: gs://bucket/folder/ or gs://bucket
          # @!attribute [rw] file_types_to_transform
          #   @return [::Array<::Google::Cloud::Dlp::V2::FileType>]
          #     List of user-specified file type groups to transform. If specified, only
          #     the files with these file types are transformed. If empty, all
          #     supported files are transformed. Supported types may be automatically
          #     added over time. Any unsupported file types that are set in this field
          #     are excluded from de-identification. An error is recorded for each
          #     unsupported file in the TransformationDetails output table. Currently the
          #     only file types supported are: IMAGES, TEXT_FILES, CSV, TSV.
          class Deidentify
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Sends an email when the job completes. The email goes to IAM project owners
          # and technical [Essential
          # Contacts](https://cloud.google.com/resource-manager/docs/managing-notification-contacts).
          class JobNotificationEmails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enable Stackdriver metric dlp.googleapis.com/finding_count. This
          # will publish a metric to stack driver on each infotype requested and
          # how many findings were found for it. CustomDetectors will be bucketed
          # as 'Custom' under the Stackdriver label 'info_type'.
          class PublishToStackdriver
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # User specified templates and configs for how to deidentify structured,
        # unstructures, and image files. User must provide either a unstructured
        # deidentify template or at least one redact image config.
        # @!attribute [rw] deidentify_template
        #   @return [::String]
        #     De-identify template.
        #     If this template is specified, it will serve as the default de-identify
        #     template. This template cannot contain `record_transformations` since it
        #     can be used for unstructured content such as free-form text files. If this
        #     template is not set, a default `ReplaceWithInfoTypeConfig` will be used to
        #     de-identify unstructured content.
        # @!attribute [rw] structured_deidentify_template
        #   @return [::String]
        #     Structured de-identify template.
        #     If this template is specified, it will serve as the de-identify template
        #     for structured content such as delimited files and tables. If this template
        #     is not set but the `deidentify_template` is set, then `deidentify_template`
        #     will also apply to the structured content. If neither template is set, a
        #     default `ReplaceWithInfoTypeConfig` will be used to de-identify structured
        #     content.
        # @!attribute [rw] image_redact_template
        #   @return [::String]
        #     Image redact template.
        #     If this template is specified, it will serve as the de-identify template
        #     for images. If this template is not set, all findings in the image will be
        #     redacted with a black box.
        class TransformationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateInspectTemplate.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on the scope of the request
        #     (project or organization) and whether you have [specified a processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #     + Organizations scope, location specified:
        #       `organizations/{org_id}/locations/{location_id}`
        #     + Organizations scope, no location specified (defaults to global):
        #       `organizations/{org_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] inspect_template
        #   @return [::Google::Cloud::Dlp::V2::InspectTemplate]
        #     Required. The InspectTemplate to create.
        # @!attribute [rw] template_id
        #   @return [::String]
        #     The template id can contain uppercase and lowercase letters,
        #     numbers, and hyphens; that is, it must match the regular
        #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
        #     characters. Can be empty to allow the system to generate one.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class CreateInspectTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateInspectTemplate.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of organization and inspectTemplate to be updated,
        #     for example `organizations/433245324/inspectTemplates/432452342` or
        #     projects/project-id/inspectTemplates/432452342.
        # @!attribute [rw] inspect_template
        #   @return [::Google::Cloud::Dlp::V2::InspectTemplate]
        #     New InspectTemplate value.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask to control which fields get updated.
        class UpdateInspectTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetInspectTemplate.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the organization and inspectTemplate to be read,
        #     for example `organizations/433245324/inspectTemplates/432452342` or
        #     projects/project-id/inspectTemplates/432452342.
        class GetInspectTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListInspectTemplates.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on the scope of the request
        #     (project or organization) and whether you have [specified a processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #     + Organizations scope, location specified:
        #       `organizations/{org_id}/locations/{location_id}`
        #     + Organizations scope, no location specified (defaults to global):
        #       `organizations/{org_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token to continue retrieval. Comes from the previous call
        #     to `ListInspectTemplates`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Size of the page. This value can be limited by the server. If zero server
        #     returns a page of max size 100.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of fields to order by,
        #     followed by `asc` or `desc` postfix. This list is case insensitive. The
        #     default sorting order is ascending. Redundant space characters are
        #     insignificant.
        #
        #     Example: `name asc,update_time, create_time desc`
        #
        #     Supported fields are:
        #
        #     - `create_time`: corresponds to the time the template was created.
        #     - `update_time`: corresponds to the time the template was last updated.
        #     - `name`: corresponds to the template's name.
        #     - `display_name`: corresponds to the template's display name.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class ListInspectTemplatesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListInspectTemplates.
        # @!attribute [rw] inspect_templates
        #   @return [::Array<::Google::Cloud::Dlp::V2::InspectTemplate>]
        #     List of inspectTemplates, up to page_size in ListInspectTemplatesRequest.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If the next page is available then the next page token to be used in the
        #     following ListInspectTemplates request.
        class ListInspectTemplatesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteInspectTemplate.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the organization and inspectTemplate to be
        #     deleted, for example `organizations/433245324/inspectTemplates/432452342`
        #     or projects/project-id/inspectTemplates/432452342.
        class DeleteInspectTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateJobTrigger.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on whether you have [specified a
        #     processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] job_trigger
        #   @return [::Google::Cloud::Dlp::V2::JobTrigger]
        #     Required. The JobTrigger to create.
        # @!attribute [rw] trigger_id
        #   @return [::String]
        #     The trigger id can contain uppercase and lowercase letters,
        #     numbers, and hyphens; that is, it must match the regular
        #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
        #     characters. Can be empty to allow the system to generate one.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class CreateJobTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ActivateJobTrigger.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the trigger to activate, for example
        #     `projects/dlp-test-project/jobTriggers/53234423`.
        class ActivateJobTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateJobTrigger.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the project and the triggeredJob, for example
        #     `projects/dlp-test-project/jobTriggers/53234423`.
        # @!attribute [rw] job_trigger
        #   @return [::Google::Cloud::Dlp::V2::JobTrigger]
        #     New JobTrigger value.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask to control which fields get updated.
        class UpdateJobTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetJobTrigger.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the project and the triggeredJob, for example
        #     `projects/dlp-test-project/jobTriggers/53234423`.
        class GetJobTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDiscoveryConfig.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on the scope of the request
        #     (project or organization):
        #
        #     + Projects scope:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Organizations scope:
        #       `organizations/{org_id}/locations/{location_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] discovery_config
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryConfig]
        #     Required. The DiscoveryConfig to create.
        # @!attribute [rw] config_id
        #   @return [::String]
        #     The config ID can contain uppercase and lowercase letters,
        #     numbers, and hyphens; that is, it must match the regular
        #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
        #     characters. Can be empty to allow the system to generate one.
        class CreateDiscoveryConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDiscoveryConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the project and the configuration, for example
        #     `projects/dlp-test-project/discoveryConfigs/53234423`.
        # @!attribute [rw] discovery_config
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryConfig]
        #     Required. New DiscoveryConfig value.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask to control which fields get updated.
        class UpdateDiscoveryConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDiscoveryConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the project and the configuration, for example
        #     `projects/dlp-test-project/discoveryConfigs/53234423`.
        class GetDiscoveryConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDiscoveryConfigs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value is as follows:
        #     `projects/{project_id}/locations/{location_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token to continue retrieval. Comes from the previous call
        #     to ListDiscoveryConfigs. `order_by` field must not
        #     change for subsequent calls.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Size of the page. This value can be limited by a server.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of config fields to order by,
        #     followed by `asc` or `desc` postfix. This list is case insensitive. The
        #     default sorting order is ascending. Redundant space characters are
        #     insignificant.
        #
        #     Example: `name asc,update_time, create_time desc`
        #
        #     Supported fields are:
        #
        #     - `last_run_time`: corresponds to the last time the DiscoveryConfig ran.
        #     - `name`: corresponds to the DiscoveryConfig's name.
        #     - `status`: corresponds to DiscoveryConfig's status.
        class ListDiscoveryConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDiscoveryConfigs.
        # @!attribute [rw] discovery_configs
        #   @return [::Array<::Google::Cloud::Dlp::V2::DiscoveryConfig>]
        #     List of configs, up to page_size in ListDiscoveryConfigsRequest.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If the next page is available then this value is the next page token to be
        #     used in the following ListDiscoveryConfigs request.
        class ListDiscoveryConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteDiscoveryConfig.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the project and the config, for example
        #     `projects/dlp-test-project/discoveryConfigs/53234423`.
        class DeleteDiscoveryConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDlpJobRequest. Used to initiate long running
        # jobs such as calculating risk metrics or inspecting Google Cloud
        # Storage.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on whether you have [specified a
        #     processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] inspect_job
        #   @return [::Google::Cloud::Dlp::V2::InspectJobConfig]
        #     An inspection job scans a storage repository for InfoTypes.
        #
        #     Note: The following fields are mutually exclusive: `inspect_job`, `risk_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] risk_job
        #   @return [::Google::Cloud::Dlp::V2::RiskAnalysisJobConfig]
        #     A risk analysis job calculates re-identification risk metrics for a
        #     BigQuery table.
        #
        #     Note: The following fields are mutually exclusive: `risk_job`, `inspect_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     The job id can contain uppercase and lowercase letters,
        #     numbers, and hyphens; that is, it must match the regular
        #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
        #     characters. Can be empty to allow the system to generate one.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class CreateDlpJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListJobTriggers.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on whether you have [specified a
        #     processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token to continue retrieval. Comes from the previous call
        #     to ListJobTriggers. `order_by` field must not
        #     change for subsequent calls.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Size of the page. This value can be limited by a server.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of triggeredJob fields to order by,
        #     followed by `asc` or `desc` postfix. This list is case insensitive. The
        #     default sorting order is ascending. Redundant space characters are
        #     insignificant.
        #
        #     Example: `name asc,update_time, create_time desc`
        #
        #     Supported fields are:
        #
        #     - `create_time`: corresponds to the time the JobTrigger was created.
        #     - `update_time`: corresponds to the time the JobTrigger was last updated.
        #     - `last_run_time`: corresponds to the last time the JobTrigger ran.
        #     - `name`: corresponds to the JobTrigger's name.
        #     - `display_name`: corresponds to the JobTrigger's display name.
        #     - `status`: corresponds to JobTrigger's status.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Allows filtering.
        #
        #     Supported syntax:
        #
        #     * Filter expressions are made up of one or more restrictions.
        #     * Restrictions can be combined by `AND` or `OR` logical operators. A
        #     sequence of restrictions implicitly uses `AND`.
        #     * A restriction has the form of `{field} {operator} {value}`.
        #     * Supported fields/values for inspect triggers:
        #         - `status` - HEALTHY|PAUSED|CANCELLED
        #         - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
        #         - 'last_run_time` - RFC 3339 formatted timestamp, surrounded by
        #         quotation marks. Nanoseconds are ignored.
        #         - 'error_count' - Number of errors that have occurred while running.
        #     * The operator must be `=` or `!=` for status and inspected_storage.
        #
        #     The syntax is based on https://google.aip.dev/160.
        #
        #     Examples:
        #
        #     * inspected_storage = cloud_storage AND status = HEALTHY
        #     * inspected_storage = cloud_storage OR inspected_storage = bigquery
        #     * inspected_storage = cloud_storage AND (state = PAUSED OR state = HEALTHY)
        #     * last_run_time > \"2017-12-12T00:00:00+00:00\"
        #
        #     The length of this field should be no more than 500 characters.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dlp::V2::DlpJobType]
        #     The type of jobs. Will use `DlpJobType.INSPECT` if not set.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class ListJobTriggersRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListJobTriggers.
        # @!attribute [rw] job_triggers
        #   @return [::Array<::Google::Cloud::Dlp::V2::JobTrigger>]
        #     List of triggeredJobs, up to page_size in ListJobTriggersRequest.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If the next page is available then this value is the next page token to be
        #     used in the following ListJobTriggers request.
        class ListJobTriggersResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteJobTrigger.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the project and the triggeredJob, for example
        #     `projects/dlp-test-project/jobTriggers/53234423`.
        class DeleteJobTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Controls what and how to inspect for findings.
        # @!attribute [rw] storage_config
        #   @return [::Google::Cloud::Dlp::V2::StorageConfig]
        #     The data to scan.
        # @!attribute [rw] inspect_config
        #   @return [::Google::Cloud::Dlp::V2::InspectConfig]
        #     How and what to scan for.
        # @!attribute [rw] inspect_template_name
        #   @return [::String]
        #     If provided, will be used as the default for all values in InspectConfig.
        #     `inspect_config` will be merged into the values persisted as part of the
        #     template.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::Dlp::V2::Action>]
        #     Actions to execute at the completion of the job.
        class InspectJobConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A task to execute when a data profile has been generated.
        # @!attribute [rw] export_data
        #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::Export]
        #     Export data profiles into a provided location.
        #
        #     Note: The following fields are mutually exclusive: `export_data`, `pub_sub_notification`, `publish_to_chronicle`, `publish_to_scc`, `tag_resources`, `publish_to_dataplex_catalog`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] pub_sub_notification
        #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::PubSubNotification]
        #     Publish a message into the Pub/Sub topic.
        #
        #     Note: The following fields are mutually exclusive: `pub_sub_notification`, `export_data`, `publish_to_chronicle`, `publish_to_scc`, `tag_resources`, `publish_to_dataplex_catalog`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] publish_to_chronicle
        #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::PublishToChronicle]
        #     Publishes generated data profiles to Google Security Operations.
        #     For more information, see [Use Sensitive Data Protection data in
        #     context-aware
        #     analytics](https://cloud.google.com/chronicle/docs/detection/usecase-dlp-high-risk-user-download).
        #
        #     Note: The following fields are mutually exclusive: `publish_to_chronicle`, `export_data`, `pub_sub_notification`, `publish_to_scc`, `tag_resources`, `publish_to_dataplex_catalog`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] publish_to_scc
        #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::PublishToSecurityCommandCenter]
        #     Publishes findings to Security Command Center for each data profile.
        #
        #     Note: The following fields are mutually exclusive: `publish_to_scc`, `export_data`, `pub_sub_notification`, `publish_to_chronicle`, `tag_resources`, `publish_to_dataplex_catalog`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] tag_resources
        #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::TagResources]
        #     Tags the profiled resources with the specified tag values.
        #
        #     Note: The following fields are mutually exclusive: `tag_resources`, `export_data`, `pub_sub_notification`, `publish_to_chronicle`, `publish_to_scc`, `publish_to_dataplex_catalog`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] publish_to_dataplex_catalog
        #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::PublishToDataplexCatalog]
        #     Publishes a portion of each profile to Dataplex Universal Catalog with
        #     the aspect type Sensitive Data Protection Profile.
        #
        #     Note: The following fields are mutually exclusive: `publish_to_dataplex_catalog`, `export_data`, `pub_sub_notification`, `publish_to_chronicle`, `publish_to_scc`, `tag_resources`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DataProfileAction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # If set, the detailed data profiles will be persisted to the location
          # of your choice whenever updated.
          # @!attribute [rw] profile_table
          #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
          #     Store all profiles to BigQuery.
          #
          #     * The system will create a new dataset and table for you if none are
          #       are provided. The dataset will be named
          #       `sensitive_data_protection_discovery` and table will be named
          #       `discovery_profiles`. This table will be placed in the same project as
          #       the container project running the scan. After the first profile is
          #       generated and the dataset and table are created, the discovery scan
          #       configuration will be updated with the dataset and table names.
          #     * See [Analyze data profiles stored in
          #     BigQuery](https://cloud.google.com/sensitive-data-protection/docs/analyze-data-profiles).
          #     * See [Sample queries for your BigQuery
          #     table](https://cloud.google.com/sensitive-data-protection/docs/analyze-data-profiles#sample_sql_queries).
          #     *  Data is inserted using [streaming
          #        insert](https://cloud.google.com/blog/products/bigquery/life-of-a-bigquery-streaming-insert)
          #        and so data may be in the buffer for a period of time after the
          #        profile has finished.
          #      * The Pub/Sub notification is sent before the streaming buffer is
          #        guaranteed to be written, so data may not be instantly
          #        visible to queries by the time your topic receives the Pub/Sub
          #        notification.
          #      * The best practice is to use the same table for an entire organization
          #        so that you can take advantage of the [provided Looker
          #        reports](https://cloud.google.com/sensitive-data-protection/docs/analyze-data-profiles#use_a_premade_report).
          #        If you use VPC Service Controls to define security perimeters, then
          #        you must use a separate table for each boundary.
          # @!attribute [rw] sample_findings_table
          #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
          #     Store sample [data profile
          #     findings][google.privacy.dlp.v2.DataProfileFinding] in an existing table
          #     or a new table in an existing dataset. Each regeneration will result in
          #     new rows in BigQuery. Data is inserted using [streaming
          #     insert](https://cloud.google.com/blog/products/bigquery/life-of-a-bigquery-streaming-insert)
          #     and so data may be in the buffer for a period of time after the profile
          #     has finished.
          class Export
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Send a Pub/Sub message into the given Pub/Sub topic to connect other
          # systems to data profile generation. The message payload data will
          # be the byte serialization of `DataProfilePubSubMessage`.
          # @!attribute [rw] topic
          #   @return [::String]
          #     Cloud Pub/Sub topic to send notifications to.
          #     Format is projects/\\{project}/topics/\\{topic}.
          # @!attribute [rw] event
          #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::EventType]
          #     The type of event that triggers a Pub/Sub. At most one
          #     `PubSubNotification` per EventType is permitted.
          # @!attribute [rw] pubsub_condition
          #   @return [::Google::Cloud::Dlp::V2::DataProfilePubSubCondition]
          #     Conditions (e.g., data risk or sensitivity level) for triggering a
          #     Pub/Sub.
          # @!attribute [rw] detail_of_message
          #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::PubSubNotification::DetailLevel]
          #     How much data to include in the Pub/Sub message. If the user wishes to
          #     limit the size of the message, they can use resource_name and fetch the
          #     profile fields they wish to. Per table profile (not per column).
          class PubSubNotification
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The levels of detail that can be included in the Pub/Sub message.
            module DetailLevel
              # Unused.
              DETAIL_LEVEL_UNSPECIFIED = 0

              # The full table data profile.
              TABLE_PROFILE = 1

              # The name of the profiled resource.
              RESOURCE_NAME = 2

              # The full file store data profile.
              FILE_STORE_PROFILE = 3
            end
          end

          # Message expressing intention to publish to Google Security Operations.
          class PublishToChronicle
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # If set, a summary finding will be created or updated in Security Command
          # Center for each profile.
          class PublishToSecurityCommandCenter
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Create Dataplex Universal Catalog aspects for profiled resources with the
          # aspect type Sensitive Data Protection Profile. To learn more about aspects,
          # see https://cloud.google.com/sensitive-data-protection/docs/add-aspects.
          # @!attribute [rw] lower_data_risk_to_low
          #   @return [::Boolean]
          #     Whether creating a Dataplex Universal Catalog aspect for a profiled
          #     resource should lower the risk of the profile for that resource. This
          #     also lowers the data risk of resources at the lower levels of the
          #     resource hierarchy. For example, reducing the data risk of a table data
          #     profile also reduces the data risk of the constituent column data
          #     profiles.
          class PublishToDataplexCatalog
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # If set, attaches the [tags]
          # (https://cloud.google.com/resource-manager/docs/tags/tags-overview)
          # provided to profiled resources. Tags support [access
          # control](https://cloud.google.com/iam/docs/tags-access-control). You can
          # conditionally grant or deny access to a resource based on whether the
          # resource has a specific tag.
          # @!attribute [rw] tag_conditions
          #   @return [::Array<::Google::Cloud::Dlp::V2::DataProfileAction::TagResources::TagCondition>]
          #     The tags to associate with different conditions.
          # @!attribute [rw] profile_generations_to_tag
          #   @return [::Array<::Google::Cloud::Dlp::V2::ProfileGeneration>]
          #     The profile generations for which the tag should be attached to
          #     resources. If you attach a tag to only new profiles, then if the
          #     sensitivity score of a profile subsequently changes, its tag doesn't
          #     change. By default, this field includes only new profiles. To include
          #     both new and updated profiles for tagging, this field should explicitly
          #     include both `PROFILE_GENERATION_NEW` and `PROFILE_GENERATION_UPDATE`.
          # @!attribute [rw] lower_data_risk_to_low
          #   @return [::Boolean]
          #     Whether applying a tag to a resource should lower the risk of the profile
          #     for that resource. For example, in conjunction with an [IAM deny
          #     policy](https://cloud.google.com/iam/docs/deny-overview), you can deny
          #     all principals a permission if a tag value is present, mitigating the
          #     risk of the resource. This also lowers the data risk of resources at the
          #     lower levels of the resource hierarchy. For example, reducing the data
          #     risk of a table data profile also reduces the data risk of the
          #     constituent column data profiles.
          class TagResources
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The tag to attach to profiles matching the condition. At most one
            # `TagCondition` can be specified per sensitivity level.
            # @!attribute [rw] tag
            #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::TagResources::TagValue]
            #     The tag value to attach to resources.
            # @!attribute [rw] sensitivity_score
            #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
            #     Conditions attaching the tag to a resource on its profile having this
            #     sensitivity score.
            class TagCondition
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # A value of a tag.
            # @!attribute [rw] namespaced_value
            #   @return [::String]
            #     The namespaced name for the tag value to attach to resources. Must be
            #     in the format `{parent_id}/{tag_key_short_name}/{short_name}`, for
            #     example, "123456/environment/prod" for an organization parent, or
            #     "my-project/environment/prod" for a project parent.
            class TagValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Types of event that can trigger an action.
          module EventType
            # Unused.
            EVENT_TYPE_UNSPECIFIED = 0

            # New profile (not a re-profile).
            NEW_PROFILE = 1

            # One of the following profile metrics changed: Data risk score,
            # Sensitivity score, Resource visibility, Encryption type, Predicted
            # infoTypes, Other infoTypes
            CHANGED_PROFILE = 2

            # Table data risk score or sensitivity score increased.
            SCORE_INCREASED = 3

            # A user (non-internal) error occurred.
            ERROR_CHANGED = 4
          end
        end

        # Details about a piece of potentially sensitive information that was detected
        # when the data resource was profiled.
        # @!attribute [rw] quote
        #   @return [::String]
        #     The content that was found. Even if the content is not textual, it
        #     may be converted to a textual representation here. If the finding exceeds
        #     4096 bytes in length, the quote may be omitted.
        # @!attribute [rw] infotype
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     The [type of
        #     content](https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference)
        #     that might have been found.
        # @!attribute [rw] quote_info
        #   @return [::Google::Cloud::Dlp::V2::QuoteInfo]
        #     Contains data parsed from quotes. Currently supported infoTypes: DATE,
        #     DATE_OF_BIRTH, and TIME.
        # @!attribute [rw] data_profile_resource_name
        #   @return [::String]
        #     Resource name of the data profile associated with the finding.
        # @!attribute [rw] finding_id
        #   @return [::String]
        #     A unique identifier for the finding.
        # @!attribute [rw] timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp when the finding was detected.
        # @!attribute [rw] location
        #   @return [::Google::Cloud::Dlp::V2::DataProfileFindingLocation]
        #     Where the content was found.
        # @!attribute [rw] resource_visibility
        #   @return [::Google::Cloud::Dlp::V2::ResourceVisibility]
        #     How broadly a resource has been shared.
        # @!attribute [rw] full_resource_name
        #   @return [::String]
        #     The [full resource
        #     name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
        #     of the resource profiled for this finding.
        # @!attribute [rw] data_source_type
        #   @return [::Google::Cloud::Dlp::V2::DataSourceType]
        #     The type of the resource that was profiled.
        class DataProfileFinding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of a data profile finding within a resource.
        # @!attribute [rw] container_name
        #   @return [::String]
        #     Name of the container where the finding is located.
        #     The top-level name is the source file name or table name. Names of some
        #     common storage containers are formatted as follows:
        #
        #     * BigQuery tables:  `{project_id}:{dataset_id}.{table_id}`
        #     * Cloud Storage files: `gs://{bucket}/{path}`
        # @!attribute [rw] data_profile_finding_record_location
        #   @return [::Google::Cloud::Dlp::V2::DataProfileFindingRecordLocation]
        #     Location of a finding within a resource that produces a table data
        #     profile.
        class DataProfileFindingLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Location of a finding within a resource that produces a table data profile.
        # @!attribute [rw] field
        #   @return [::Google::Cloud::Dlp::V2::FieldId]
        #     Field ID of the column containing the finding.
        class DataProfileFindingRecordLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for setting up a job to scan resources for profile generation.
        # Only one data profile configuration may exist per organization, folder,
        # or project.
        #
        # The generated data profiles are retained according to the
        # [data retention policy]
        # (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
        # @!attribute [rw] location
        #   @return [::Google::Cloud::Dlp::V2::DataProfileLocation]
        #     The data to scan.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The project that will run the scan. The DLP service
        #     account that exists within this project must have access to all resources
        #     that are profiled, and the DLP API must be enabled.
        # @!attribute [rw] other_cloud_starting_location
        #   @return [::Google::Cloud::Dlp::V2::OtherCloudDiscoveryStartingLocation]
        #     Must be set only when scanning other clouds.
        # @!attribute [rw] inspect_templates
        #   @return [::Array<::String>]
        #     Detection logic for profile generation.
        #
        #     Not all template features are used by profiles. FindingLimits,
        #     include_quote and exclude_info_types have no impact on
        #     data profiling.
        #
        #     Multiple templates may be provided if there is data in multiple regions.
        #     At most one template must be specified per-region (including "global").
        #     Each region is scanned using the applicable template. If no region-specific
        #     template is specified, but a "global" template is specified, it will be
        #     copied to that region and used instead. If no global or region-specific
        #     template is provided for a region with data, that region's data will not be
        #     scanned.
        #
        #     For more information, see
        #     https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
        # @!attribute [rw] data_profile_actions
        #   @return [::Array<::Google::Cloud::Dlp::V2::DataProfileAction>]
        #     Actions to execute at the completion of the job.
        class DataProfileJobConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A pattern to match against one or more tables, datasets, or projects that
        # contain BigQuery tables. At least one pattern must be specified.
        # Regular expressions use RE2
        # [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
        # under the google/re2 repository on GitHub.
        # @!attribute [rw] project_id_regex
        #   @return [::String]
        #     For organizations, if unset, will match all projects. Has no effect
        #     for data profile configurations created within a project.
        # @!attribute [rw] dataset_id_regex
        #   @return [::String]
        #     If unset, this property matches all datasets.
        # @!attribute [rw] table_id_regex
        #   @return [::String]
        #     If unset, this property matches all tables.
        class BigQueryRegex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of regular expressions to determine what tables to match
        # against.
        # @!attribute [rw] patterns
        #   @return [::Array<::Google::Cloud::Dlp::V2::BigQueryRegex>]
        #     A single BigQuery regular expression pattern to match against one or more
        #     tables, datasets, or projects that contain BigQuery tables.
        class BigQueryRegexes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The types of BigQuery tables supported by Cloud DLP.
        # @!attribute [rw] types
        #   @return [::Array<::Google::Cloud::Dlp::V2::BigQueryTableType>]
        #     A set of BigQuery table types.
        class BigQueryTableTypes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Do not profile the tables.
        class Disabled
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The data that will be profiled.
        # @!attribute [rw] organization_id
        #   @return [::Integer]
        #     The ID of an organization to scan.
        #
        #     Note: The following fields are mutually exclusive: `organization_id`, `folder_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] folder_id
        #   @return [::Integer]
        #     The ID of the folder within an organization to scan.
        #
        #     Note: The following fields are mutually exclusive: `folder_id`, `organization_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DataProfileLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for discovery to scan resources for profile generation.
        # Only one discovery configuration may exist per organization, folder,
        # or project.
        #
        # The generated data profiles are retained according to the
        # [data retention policy]
        # (https://cloud.google.com/sensitive-data-protection/docs/data-profiles#retention).
        # @!attribute [rw] name
        #   @return [::String]
        #     Unique resource name for the DiscoveryConfig, assigned by the service when
        #     the DiscoveryConfig is created, for example
        #     `projects/dlp-test-project/locations/global/discoveryConfigs/53234423`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name (max 100 chars)
        # @!attribute [rw] org_config
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryConfig::OrgConfig]
        #     Only set when the parent is an org.
        # @!attribute [rw] other_cloud_starting_location
        #   @return [::Google::Cloud::Dlp::V2::OtherCloudDiscoveryStartingLocation]
        #     Must be set only when scanning other clouds.
        # @!attribute [rw] inspect_templates
        #   @return [::Array<::String>]
        #     Detection logic for profile generation.
        #
        #     Not all template features are used by Discovery. FindingLimits,
        #     include_quote and exclude_info_types have no impact on
        #     Discovery.
        #
        #     Multiple templates may be provided if there is data in multiple regions.
        #     At most one template must be specified per-region (including "global").
        #     Each region is scanned using the applicable template. If no region-specific
        #     template is specified, but a "global" template is specified, it will be
        #     copied to that region and used instead. If no global or region-specific
        #     template is provided for a region with data, that region's data will not be
        #     scanned.
        #
        #     For more information, see
        #     https://cloud.google.com/sensitive-data-protection/docs/data-profiles#data-residency.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::Dlp::V2::DataProfileAction>]
        #     Actions to execute at the completion of scanning.
        # @!attribute [rw] targets
        #   @return [::Array<::Google::Cloud::Dlp::V2::DiscoveryTarget>]
        #     Target to match against for determining what to scan and how frequently.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Cloud::Dlp::V2::Error>]
        #     Output only. A stream of errors encountered when the config was activated.
        #     Repeated errors may result in the config automatically being paused. Output
        #     only field. Will return the last 100 errors. Whenever the config is
        #     modified this list will be cleared.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation timestamp of a DiscoveryConfig.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update timestamp of a DiscoveryConfig.
        # @!attribute [r] last_run_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The timestamp of the last time this config was executed.
        # @!attribute [rw] status
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryConfig::Status]
        #     Required. A status for this configuration.
        # @!attribute [rw] processing_location
        #   @return [::Google::Cloud::Dlp::V2::ProcessingLocation]
        #     Optional. Processing location configuration. Vertex AI dataset scanning
        #     will set processing_location.image_fallback_type to MultiRegionProcessing
        #     by default.
        class DiscoveryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Project and scan location information. Only set when the parent is an org.
          # @!attribute [rw] location
          #   @return [::Google::Cloud::Dlp::V2::DiscoveryStartingLocation]
          #     The data to scan: folder, org, or project
          # @!attribute [rw] project_id
          #   @return [::String]
          #     The project that will run the scan. The DLP service
          #     account that exists within this project must have access to all resources
          #     that are profiled, and the DLP API must be enabled.
          class OrgConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Whether the discovery config is currently active. New options may be added
          # at a later time.
          module Status
            # Unused
            STATUS_UNSPECIFIED = 0

            # The discovery config is currently active.
            RUNNING = 1

            # The discovery config is paused temporarily.
            PAUSED = 2
          end
        end

        # Target used to match against for Discovery.
        # @!attribute [rw] big_query_target
        #   @return [::Google::Cloud::Dlp::V2::BigQueryDiscoveryTarget]
        #     BigQuery target for Discovery. The first target to match a table will be
        #     the one applied.
        #
        #     Note: The following fields are mutually exclusive: `big_query_target`, `cloud_sql_target`, `secrets_target`, `cloud_storage_target`, `other_cloud_target`, `vertex_dataset_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_sql_target
        #   @return [::Google::Cloud::Dlp::V2::CloudSqlDiscoveryTarget]
        #     Cloud SQL target for Discovery. The first target to match a table will be
        #     the one applied.
        #
        #     Note: The following fields are mutually exclusive: `cloud_sql_target`, `big_query_target`, `secrets_target`, `cloud_storage_target`, `other_cloud_target`, `vertex_dataset_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] secrets_target
        #   @return [::Google::Cloud::Dlp::V2::SecretsDiscoveryTarget]
        #     Discovery target that looks for credentials and secrets stored in cloud
        #     resource metadata and reports them as vulnerabilities to Security Command
        #     Center. Only one target of this type is allowed.
        #
        #     Note: The following fields are mutually exclusive: `secrets_target`, `big_query_target`, `cloud_sql_target`, `cloud_storage_target`, `other_cloud_target`, `vertex_dataset_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_storage_target
        #   @return [::Google::Cloud::Dlp::V2::CloudStorageDiscoveryTarget]
        #     Cloud Storage target for Discovery. The first target to match a table
        #     will be the one applied.
        #
        #     Note: The following fields are mutually exclusive: `cloud_storage_target`, `big_query_target`, `cloud_sql_target`, `secrets_target`, `other_cloud_target`, `vertex_dataset_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] other_cloud_target
        #   @return [::Google::Cloud::Dlp::V2::OtherCloudDiscoveryTarget]
        #     Other clouds target for discovery. The first target to match a resource
        #     will be the one applied.
        #
        #     Note: The following fields are mutually exclusive: `other_cloud_target`, `big_query_target`, `cloud_sql_target`, `secrets_target`, `cloud_storage_target`, `vertex_dataset_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vertex_dataset_target
        #   @return [::Google::Cloud::Dlp::V2::VertexDatasetDiscoveryTarget]
        #     Vertex AI dataset target for Discovery. The first target to match a
        #     dataset will be the one applied. Note that discovery for Vertex AI can
        #     incur Cloud Storage Class B operation charges for storage.objects.get
        #     operations and retrieval fees. For more information, see [Cloud Storage
        #     pricing](https://cloud.google.com/storage/pricing#price-tables).
        #     Note that discovery for Vertex AI dataset will not be able to scan images
        #     unless DiscoveryConfig.processing_location.image_fallback_location has
        #     multi_region_processing or global_processing configured.
        #
        #     Note: The following fields are mutually exclusive: `vertex_dataset_target`, `big_query_target`, `cloud_sql_target`, `secrets_target`, `cloud_storage_target`, `other_cloud_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DiscoveryTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Target used to match against for discovery with BigQuery tables
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryBigQueryFilter]
        #     Required. The tables the discovery cadence applies to. The first target
        #     with a matching filter will be the one to apply to a table.
        # @!attribute [rw] conditions
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryBigQueryConditions]
        #     In addition to matching the filter, these conditions must be true
        #     before a profile is generated.
        # @!attribute [rw] cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryGenerationCadence]
        #     How often and when to update profiles. New tables that match both the
        #     filter and conditions are scanned as quickly as possible depending on
        #     system capacity.
        #
        #     Note: The following fields are mutually exclusive: `cadence`, `disabled`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disabled
        #   @return [::Google::Cloud::Dlp::V2::Disabled]
        #     Tables that match this filter will not have profiles created.
        #
        #     Note: The following fields are mutually exclusive: `disabled`, `cadence`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BigQueryDiscoveryTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Determines what tables will have profiles generated within an organization
        # or project. Includes the ability to filter by regular expression patterns
        # on project ID, dataset ID, and table ID.
        # @!attribute [rw] tables
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTableCollection]
        #     A specific set of tables for this filter to apply to. A table collection
        #     must be specified in only one filter per config.
        #     If a table id or dataset is empty, Cloud DLP assumes all tables in that
        #     collection must be profiled. Must specify a project ID.
        #
        #     Note: The following fields are mutually exclusive: `tables`, `other_tables`, `table_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] other_tables
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryBigQueryFilter::AllOtherBigQueryTables]
        #     Catch-all. This should always be the last filter in the list because
        #     anything above it will apply first. Should only appear once in a
        #     configuration. If none is specified, a default one will be added
        #     automatically.
        #
        #     Note: The following fields are mutually exclusive: `other_tables`, `tables`, `table_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] table_reference
        #   @return [::Google::Cloud::Dlp::V2::TableReference]
        #     The table to scan. Discovery configurations including this can only
        #     include one DiscoveryTarget (the DiscoveryTarget with this
        #     TableReference).
        #
        #     Note: The following fields are mutually exclusive: `table_reference`, `tables`, `other_tables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DiscoveryBigQueryFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Catch-all for all other tables not specified by other filters. Should
          # always be last, except for single-table configurations, which will only
          # have a TableReference target.
          class AllOtherBigQueryTables
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Specifies a collection of BigQuery tables. Used for Discovery.
        # @!attribute [rw] include_regexes
        #   @return [::Google::Cloud::Dlp::V2::BigQueryRegexes]
        #     A collection of regular expressions to match a BigQuery table against.
        class BigQueryTableCollection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Requirements that must be true before a table is scanned in discovery for the
        # first time. There is an AND relationship between the top-level attributes.
        # Additionally, minimum conditions with an OR relationship that must be met
        # before Cloud DLP scans a table can be set (like a minimum row count or a
        # minimum table age).
        # @!attribute [rw] created_after
        #   @return [::Google::Protobuf::Timestamp]
        #     BigQuery table must have been created after this date. Used to avoid
        #     backfilling.
        # @!attribute [rw] types
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTableTypes]
        #     Restrict discovery to specific table types.
        #
        #     Note: The following fields are mutually exclusive: `types`, `type_collection`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] type_collection
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTableTypeCollection]
        #     Restrict discovery to categories of table types.
        #
        #     Note: The following fields are mutually exclusive: `type_collection`, `types`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] or_conditions
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryBigQueryConditions::OrConditions]
        #     At least one of the conditions must be true for a table to be scanned.
        class DiscoveryBigQueryConditions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # There is an OR relationship between these attributes. They are used to
          # determine if a table should be scanned or not in Discovery.
          # @!attribute [rw] min_row_count
          #   @return [::Integer]
          #     Minimum number of rows that should be present before Cloud DLP
          #     profiles a table
          # @!attribute [rw] min_age
          #   @return [::Google::Protobuf::Duration]
          #     Minimum age a table must have before Cloud DLP can profile it. Value must
          #     be 1 hour or greater.
          class OrConditions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # What must take place for a profile to be updated and how
        # frequently it should occur.
        # New tables are scanned as quickly as possible depending on system
        # capacity.
        # @!attribute [rw] schema_modified_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoverySchemaModifiedCadence]
        #     Governs when to update data profiles when a schema is modified.
        # @!attribute [rw] table_modified_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryTableModifiedCadence]
        #     Governs when to update data profiles when a table is modified.
        # @!attribute [rw] inspect_template_modified_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryInspectTemplateModifiedCadence]
        #     Governs when to update data profiles when the inspection rules
        #     defined by the `InspectTemplate` change.
        #     If not set, changing the template will not cause a data profile to update.
        # @!attribute [rw] refresh_frequency
        #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
        #     Frequency at which profiles should be updated, regardless of whether the
        #     underlying resource has changed. Defaults to never.
        class DiscoveryGenerationCadence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The cadence at which to update data profiles when a table is modified.
        # @!attribute [rw] types
        #   @return [::Array<::Google::Cloud::Dlp::V2::BigQueryTableModification>]
        #     The type of events to consider when deciding if the table has been
        #     modified and should have the profile updated. Defaults to
        #     MODIFIED_TIMESTAMP.
        # @!attribute [rw] frequency
        #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
        #     How frequently data profiles can be updated when tables are modified.
        #     Defaults to never.
        class DiscoveryTableModifiedCadence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The cadence at which to update data profiles when a schema is modified.
        # @!attribute [rw] types
        #   @return [::Array<::Google::Cloud::Dlp::V2::BigQuerySchemaModification>]
        #     The type of events to consider when deciding if the table's schema
        #     has been modified and should have the profile updated. Defaults to
        #     NEW_COLUMNS.
        # @!attribute [rw] frequency
        #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
        #     How frequently profiles may be updated when schemas are
        #     modified. Defaults to monthly.
        class DiscoverySchemaModifiedCadence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The cadence at which to update data profiles when the inspection rules
        # defined by the `InspectTemplate` change.
        # @!attribute [rw] frequency
        #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
        #     How frequently data profiles can be updated when the template is modified.
        #     Defaults to never.
        class DiscoveryInspectTemplateModifiedCadence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Target used to match against for discovery with Cloud SQL tables.
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryCloudSqlFilter]
        #     Required. The tables the discovery cadence applies to. The first target
        #     with a matching filter will be the one to apply to a table.
        # @!attribute [rw] conditions
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryCloudSqlConditions]
        #     In addition to matching the filter, these conditions must be true
        #     before a profile is generated.
        # @!attribute [rw] generation_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryCloudSqlGenerationCadence]
        #     How often and when to update profiles. New tables that match both the
        #     filter and conditions are scanned as quickly as possible depending on
        #     system capacity.
        #
        #     Note: The following fields are mutually exclusive: `generation_cadence`, `disabled`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disabled
        #   @return [::Google::Cloud::Dlp::V2::Disabled]
        #     Disable profiling for database resources that match this filter.
        #
        #     Note: The following fields are mutually exclusive: `disabled`, `generation_cadence`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class CloudSqlDiscoveryTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Determines what tables will have profiles generated within an organization
        # or project. Includes the ability to filter by regular expression patterns
        # on project ID, location, instance, database, and database resource name.
        # @!attribute [rw] collection
        #   @return [::Google::Cloud::Dlp::V2::DatabaseResourceCollection]
        #     A specific set of database resources for this filter to apply to.
        #
        #     Note: The following fields are mutually exclusive: `collection`, `others`, `database_resource_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] others
        #   @return [::Google::Cloud::Dlp::V2::AllOtherDatabaseResources]
        #     Catch-all. This should always be the last target in the list because
        #     anything above it will apply first. Should only appear once in a
        #     configuration. If none is specified, a default one will be added
        #     automatically.
        #
        #     Note: The following fields are mutually exclusive: `others`, `collection`, `database_resource_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] database_resource_reference
        #   @return [::Google::Cloud::Dlp::V2::DatabaseResourceReference]
        #     The database resource to scan. Targets including this can only include
        #     one target (the target with this database resource reference).
        #
        #     Note: The following fields are mutually exclusive: `database_resource_reference`, `collection`, `others`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DiscoveryCloudSqlFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Match database resources using regex filters. Examples of database
        # resources are tables, views, and stored procedures.
        # @!attribute [rw] include_regexes
        #   @return [::Google::Cloud::Dlp::V2::DatabaseResourceRegexes]
        #     A collection of regular expressions to match a database resource against.
        class DatabaseResourceCollection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of regular expressions to determine what database resources to
        # match against.
        # @!attribute [rw] patterns
        #   @return [::Array<::Google::Cloud::Dlp::V2::DatabaseResourceRegex>]
        #     A group of regular expression patterns to match against one or more
        #     database resources.
        #     Maximum of 100 entries. The sum of all regular expression's length can't
        #     exceed 10 KiB.
        class DatabaseResourceRegexes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A pattern to match against one or more database resources. At least one
        # pattern must be specified. Regular expressions use RE2
        # [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
        # under the google/re2 repository on GitHub.
        # @!attribute [rw] project_id_regex
        #   @return [::String]
        #     For organizations, if unset, will match all projects. Has no effect
        #     for configurations created within a project.
        # @!attribute [rw] instance_regex
        #   @return [::String]
        #     Regex to test the instance name against. If empty, all instances match.
        # @!attribute [rw] database_regex
        #   @return [::String]
        #     Regex to test the database name against. If empty, all databases match.
        # @!attribute [rw] database_resource_name_regex
        #   @return [::String]
        #     Regex to test the database resource's name against. An example of a
        #     database resource name is a table's name. Other database resource names
        #     like view names could be included in the future. If empty, all database
        #     resources match.
        class DatabaseResourceRegex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Match database resources not covered by any other filter.
        class AllOtherDatabaseResources
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Identifies a single database resource, like a table within a database.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. If within a project-level config, then this must match the
        #     config's project ID.
        # @!attribute [rw] instance
        #   @return [::String]
        #     Required. The instance where this resource is located. For example: Cloud
        #     SQL instance ID.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. Name of a database within the instance.
        # @!attribute [rw] database_resource
        #   @return [::String]
        #     Required. Name of a database resource, for example, a table within the
        #     database.
        class DatabaseResourceReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Requirements that must be true before a table is profiled for the
        # first time.
        # @!attribute [rw] database_engines
        #   @return [::Array<::Google::Cloud::Dlp::V2::DiscoveryCloudSqlConditions::DatabaseEngine>]
        #     Optional. Database engines that should be profiled.
        #     Optional. Defaults to ALL_SUPPORTED_DATABASE_ENGINES if unspecified.
        # @!attribute [rw] types
        #   @return [::Array<::Google::Cloud::Dlp::V2::DiscoveryCloudSqlConditions::DatabaseResourceType>]
        #     Data profiles will only be generated for the database resource types
        #     specified in this field.
        #     If not specified, defaults to [DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES].
        class DiscoveryCloudSqlConditions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The database engines that should be profiled.
          module DatabaseEngine
            # Unused.
            DATABASE_ENGINE_UNSPECIFIED = 0

            # Include all supported database engines.
            ALL_SUPPORTED_DATABASE_ENGINES = 1

            # MySQL database.
            MYSQL = 2

            # PostgreSQL database.
            POSTGRES = 3
          end

          # Cloud SQL database resource types. New values can be added at a later time.
          module DatabaseResourceType
            # Unused.
            DATABASE_RESOURCE_TYPE_UNSPECIFIED = 0

            # Includes database resource types that become supported at a later time.
            DATABASE_RESOURCE_TYPE_ALL_SUPPORTED_TYPES = 1

            # Tables.
            DATABASE_RESOURCE_TYPE_TABLE = 2
          end
        end

        # How often existing tables should have their profiles refreshed.
        # New tables are scanned as quickly as possible depending on system
        # capacity.
        # @!attribute [rw] schema_modified_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryCloudSqlGenerationCadence::SchemaModifiedCadence]
        #     When to reprofile if the schema has changed.
        # @!attribute [rw] refresh_frequency
        #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
        #     Data changes (non-schema changes) in Cloud SQL tables can't trigger
        #     reprofiling. If you set this field, profiles are refreshed at this
        #     frequency regardless of whether the underlying tables have changed.
        #     Defaults to never.
        # @!attribute [rw] inspect_template_modified_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryInspectTemplateModifiedCadence]
        #     Governs when to update data profiles when the inspection rules
        #     defined by the `InspectTemplate` change.
        #     If not set, changing the template will not cause a data profile to update.
        class DiscoveryCloudSqlGenerationCadence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # How frequently to modify the profile when the table's schema is modified.
          # @!attribute [rw] types
          #   @return [::Array<::Google::Cloud::Dlp::V2::DiscoveryCloudSqlGenerationCadence::SchemaModifiedCadence::CloudSqlSchemaModification>]
          #     The types of schema modifications to consider.
          #     Defaults to NEW_COLUMNS.
          # @!attribute [rw] frequency
          #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
          #     Frequency to regenerate data profiles when the schema is modified.
          #     Defaults to monthly.
          class SchemaModifiedCadence
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The type of modification that causes a profile update.
            module CloudSqlSchemaModification
              # Unused.
              SQL_SCHEMA_MODIFICATION_UNSPECIFIED = 0

              # New columns have appeared.
              NEW_COLUMNS = 1

              # Columns have been removed from the table.
              REMOVED_COLUMNS = 2
            end
          end
        end

        # Discovery target for credentials and secrets in cloud resource metadata.
        #
        # This target does not include any filtering or frequency controls. Cloud
        # DLP will scan cloud resource metadata for secrets daily.
        #
        # No inspect template should be included in the discovery config for a
        # security benchmarks scan. Instead, the built-in list of secrets and
        # credentials infoTypes will be used (see
        # https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference#credentials_and_secrets).
        #
        # Credentials and secrets discovered will be reported as vulnerabilities to
        # Security Command Center.
        class SecretsDiscoveryTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Target used to match against for discovery with Cloud Storage buckets.
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryCloudStorageFilter]
        #     Required. The buckets the generation_cadence applies to. The first target
        #     with a matching filter will be the one to apply to a bucket.
        # @!attribute [rw] conditions
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryFileStoreConditions]
        #     Optional. In addition to matching the filter, these conditions must be true
        #     before a profile is generated.
        # @!attribute [rw] generation_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryCloudStorageGenerationCadence]
        #     Optional. How often and when to update profiles. New buckets that match
        #     both the filter and conditions are scanned as quickly as possible
        #     depending on system capacity.
        #
        #     Note: The following fields are mutually exclusive: `generation_cadence`, `disabled`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disabled
        #   @return [::Google::Cloud::Dlp::V2::Disabled]
        #     Optional. Disable profiling for buckets that match this filter.
        #
        #     Note: The following fields are mutually exclusive: `disabled`, `generation_cadence`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class CloudStorageDiscoveryTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Determines which buckets will have profiles generated within an organization
        # or project. Includes the ability to filter by regular expression patterns
        # on project ID and bucket name.
        # @!attribute [rw] collection
        #   @return [::Google::Cloud::Dlp::V2::FileStoreCollection]
        #     Optional. A specific set of buckets for this filter to apply to.
        #
        #     Note: The following fields are mutually exclusive: `collection`, `cloud_storage_resource_reference`, `others`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_storage_resource_reference
        #   @return [::Google::Cloud::Dlp::V2::CloudStorageResourceReference]
        #     Optional. The bucket to scan. Targets including this can only include one
        #     target (the target with this bucket). This enables profiling the contents
        #     of a single bucket, while the other options allow for easy profiling of
        #     many bucets within a project or an organization.
        #
        #     Note: The following fields are mutually exclusive: `cloud_storage_resource_reference`, `collection`, `others`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] others
        #   @return [::Google::Cloud::Dlp::V2::AllOtherResources]
        #     Optional. Catch-all. This should always be the last target in the list
        #     because anything above it will apply first. Should only appear once in a
        #     configuration. If none is specified, a default one will be added
        #     automatically.
        #
        #     Note: The following fields are mutually exclusive: `others`, `collection`, `cloud_storage_resource_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DiscoveryCloudStorageFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Match file stores (e.g. buckets) using filters.
        # @!attribute [rw] include_regexes
        #   @return [::Google::Cloud::Dlp::V2::FileStoreRegexes]
        #     Optional. A collection of regular expressions to match a file store
        #     against.
        # @!attribute [rw] include_tags
        #   @return [::Google::Cloud::Dlp::V2::TagFilters]
        #     Optional. To be included in the collection, a resource must meet all of the
        #     following requirements:
        #
        #      - If tag filters are provided, match all provided tag filters.
        #      - If one or more patterns are specified, match at least one pattern.
        #
        #     For a resource to match the tag filters, the resource must have all of the
        #     provided tags attached. Tags refer to Resource Manager tags bound to the
        #     resource or its ancestors. For more information, see [Manage
        #     schedules](https://cloud.google.com/sensitive-data-protection/docs/profile-project-cloud-storage#manage-schedules).
        class FileStoreCollection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of regular expressions to determine what file store to match
        # against.
        # @!attribute [rw] patterns
        #   @return [::Array<::Google::Cloud::Dlp::V2::FileStoreRegex>]
        #     Required. The group of regular expression patterns to match against one or
        #     more file stores. Maximum of 100 entries. The sum of all regular
        #     expression's length can't exceed 10 KiB.
        class FileStoreRegexes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A pattern to match against one or more file stores.
        # @!attribute [rw] cloud_storage_regex
        #   @return [::Google::Cloud::Dlp::V2::CloudStorageRegex]
        #     Optional. Regex for Cloud Storage.
        class FileStoreRegex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A pattern to match against one or more file stores. At least one
        # pattern must be specified. Regular expressions use RE2
        # [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
        # under the google/re2 repository on GitHub.
        # @!attribute [rw] project_id_regex
        #   @return [::String]
        #     Optional. For organizations, if unset, will match all projects.
        # @!attribute [rw] bucket_name_regex
        #   @return [::String]
        #     Optional. Regex to test the bucket name against. If empty, all buckets
        #     match. Example: "marketing2021" or "(marketing)\d\\{4}" will both match the
        #     bucket gs://marketing2021
        class CloudStorageRegex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Identifies a single Cloud Storage bucket.
        # @!attribute [rw] bucket_name
        #   @return [::String]
        #     Required. The bucket to scan.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Required. If within a project-level config, then this must match the
        #     config's project id.
        class CloudStorageResourceReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # How often existing buckets should have their profiles refreshed.
        # New buckets are scanned as quickly as possible depending on system
        # capacity.
        # @!attribute [rw] refresh_frequency
        #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
        #     Optional. Data changes in Cloud Storage can't trigger reprofiling. If you
        #     set this field, profiles are refreshed at this frequency regardless of
        #     whether the underlying buckets have changed. Defaults to never.
        # @!attribute [rw] inspect_template_modified_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryInspectTemplateModifiedCadence]
        #     Optional. Governs when to update data profiles when the inspection rules
        #     defined by the `InspectTemplate` change.
        #     If not set, changing the template will not cause a data profile to update.
        class DiscoveryCloudStorageGenerationCadence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Requirements that must be true before a Cloud Storage bucket or object is
        # scanned in discovery for the first time. There is an AND relationship between
        # the top-level attributes.
        # @!attribute [rw] included_object_attributes
        #   @return [::Array<::Google::Cloud::Dlp::V2::DiscoveryCloudStorageConditions::CloudStorageObjectAttribute>]
        #     Required. Only objects with the specified attributes will be scanned. If an
        #     object has one of the specified attributes but is inside an excluded
        #     bucket, it will not be scanned. Defaults to [ALL_SUPPORTED_OBJECTS]. A
        #     profile will be created even if no objects match the
        #     included_object_attributes.
        # @!attribute [rw] included_bucket_attributes
        #   @return [::Array<::Google::Cloud::Dlp::V2::DiscoveryCloudStorageConditions::CloudStorageBucketAttribute>]
        #     Required. Only objects with the specified attributes will be scanned.
        #     Defaults to [ALL_SUPPORTED_BUCKETS] if unset.
        class DiscoveryCloudStorageConditions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The attribute of an object. See
          # https://cloud.google.com/storage/docs/storage-classes for more information
          # on storage classes.
          module CloudStorageObjectAttribute
            # Unused.
            CLOUD_STORAGE_OBJECT_ATTRIBUTE_UNSPECIFIED = 0

            # Scan objects regardless of the attribute.
            ALL_SUPPORTED_OBJECTS = 1

            # Scan objects with the standard storage class.
            STANDARD = 2

            # Scan objects with the nearline storage class. This will incur retrieval
            # fees.
            NEARLINE = 3

            # Scan objects with the coldline storage class. This will incur retrieval
            # fees.
            COLDLINE = 4

            # Scan objects with the archive storage class. This will incur retrieval
            # fees.
            ARCHIVE = 5

            # Scan objects with the regional storage class.
            REGIONAL = 6

            # Scan objects with the multi-regional storage class.
            MULTI_REGIONAL = 7

            # Scan objects with the dual-regional storage class. This will incur
            # retrieval fees.
            DURABLE_REDUCED_AVAILABILITY = 8
          end

          # The attribute of a bucket.
          module CloudStorageBucketAttribute
            # Unused.
            CLOUD_STORAGE_BUCKET_ATTRIBUTE_UNSPECIFIED = 0

            # Scan buckets regardless of the attribute.
            ALL_SUPPORTED_BUCKETS = 1

            # Buckets with [Autoclass](https://cloud.google.com/storage/docs/autoclass)
            # disabled. Only one of
            # AUTOCLASS_DISABLED or AUTOCLASS_ENABLED should be set.
            AUTOCLASS_DISABLED = 2

            # Buckets with [Autoclass](https://cloud.google.com/storage/docs/autoclass)
            # enabled. Only one of
            # AUTOCLASS_DISABLED or AUTOCLASS_ENABLED should be set. Scanning
            # Autoclass-enabled buckets can affect object storage classes.
            AUTOCLASS_ENABLED = 3
          end
        end

        # Requirements that must be true before a file store is scanned in discovery
        # for the first time. There is an AND relationship between the top-level
        # attributes.
        # @!attribute [rw] created_after
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. File store must have been created after this date. Used to avoid
        #     backfilling.
        # @!attribute [rw] min_age
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Minimum age a file store must have. If set, the value must be 1
        #     hour or greater.
        # @!attribute [rw] cloud_storage_conditions
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryCloudStorageConditions]
        #     Optional. Cloud Storage conditions.
        class DiscoveryFileStoreConditions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Target used to match against for discovery of resources from other clouds.
        # An [AWS connector in Security Command Center
        # (Enterprise](https://cloud.google.com/security-command-center/docs/connect-scc-to-aws)
        # is required to use this feature.
        # @!attribute [rw] data_source_type
        #   @return [::Google::Cloud::Dlp::V2::DataSourceType]
        #     Required. The type of data profiles generated by this discovery target.
        #     Supported values are:
        #     * aws/s3/bucket
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryOtherCloudFilter]
        #     Required. The resources that the discovery cadence applies to. The
        #     first target with a matching filter will be the one to apply to a resource.
        # @!attribute [rw] conditions
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryOtherCloudConditions]
        #     Optional. In addition to matching the filter, these conditions must be true
        #     before a profile is generated.
        # @!attribute [rw] generation_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryOtherCloudGenerationCadence]
        #     How often and when to update data profiles. New resources that match both
        #     the filter and conditions are scanned as quickly as possible depending on
        #     system capacity.
        #
        #     Note: The following fields are mutually exclusive: `generation_cadence`, `disabled`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disabled
        #   @return [::Google::Cloud::Dlp::V2::Disabled]
        #     Disable profiling for resources that match this filter.
        #
        #     Note: The following fields are mutually exclusive: `disabled`, `generation_cadence`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class OtherCloudDiscoveryTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Determines which resources from the other cloud will have profiles generated.
        # Includes the ability to filter by resource names.
        # @!attribute [rw] collection
        #   @return [::Google::Cloud::Dlp::V2::OtherCloudResourceCollection]
        #     A collection of resources for this filter to apply to.
        #
        #     Note: The following fields are mutually exclusive: `collection`, `single_resource`, `others`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] single_resource
        #   @return [::Google::Cloud::Dlp::V2::OtherCloudSingleResourceReference]
        #     The resource to scan. Configs using this filter can only have one target
        #     (the target with this single resource reference).
        #
        #     Note: The following fields are mutually exclusive: `single_resource`, `collection`, `others`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] others
        #   @return [::Google::Cloud::Dlp::V2::AllOtherResources]
        #     Optional. Catch-all. This should always be the last target in the list
        #     because anything above it will apply first. Should only appear once in a
        #     configuration. If none is specified, a default one will be added
        #     automatically.
        #
        #     Note: The following fields are mutually exclusive: `others`, `collection`, `single_resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DiscoveryOtherCloudFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Match resources using regex filters.
        # @!attribute [rw] include_regexes
        #   @return [::Google::Cloud::Dlp::V2::OtherCloudResourceRegexes]
        #     A collection of regular expressions to match a resource against.
        class OtherCloudResourceCollection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of regular expressions to determine what resources to match
        # against.
        # @!attribute [rw] patterns
        #   @return [::Array<::Google::Cloud::Dlp::V2::OtherCloudResourceRegex>]
        #     A group of regular expression patterns to match against one or more
        #     resources.
        #     Maximum of 100 entries. The sum of all regular expression's length can't
        #     exceed 10 KiB.
        class OtherCloudResourceRegexes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A pattern to match against one or more resources. At least one pattern must
        # be specified. Regular expressions use RE2
        # [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
        # under the google/re2 repository on GitHub.
        # @!attribute [rw] amazon_s3_bucket_regex
        #   @return [::Google::Cloud::Dlp::V2::AmazonS3BucketRegex]
        #     Regex for Amazon S3 buckets.
        class OtherCloudResourceRegex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AWS account regex.
        # @!attribute [rw] account_id_regex
        #   @return [::String]
        #     Optional. Regex to test the AWS account ID against.
        #     If empty, all accounts match.
        class AwsAccountRegex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Amazon S3 bucket regex.
        # @!attribute [rw] aws_account_regex
        #   @return [::Google::Cloud::Dlp::V2::AwsAccountRegex]
        #     The AWS account regex.
        # @!attribute [rw] bucket_name_regex
        #   @return [::String]
        #     Optional. Regex to test the bucket name against.
        #     If empty, all buckets match.
        class AmazonS3BucketRegex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Identifies a single resource, like a single Amazon S3 bucket.
        # @!attribute [rw] amazon_s3_bucket
        #   @return [::Google::Cloud::Dlp::V2::AmazonS3Bucket]
        #     Amazon S3 bucket.
        class OtherCloudSingleResourceReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AWS account.
        # @!attribute [rw] account_id
        #   @return [::String]
        #     Required. AWS account ID.
        class AwsAccount
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Amazon S3 bucket.
        # @!attribute [rw] aws_account
        #   @return [::Google::Cloud::Dlp::V2::AwsAccount]
        #     The AWS account.
        # @!attribute [rw] bucket_name
        #   @return [::String]
        #     Required. The bucket name.
        class AmazonS3Bucket
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Requirements that must be true before a resource is profiled for the first
        # time.
        # @!attribute [rw] min_age
        #   @return [::Google::Protobuf::Duration]
        #     Minimum age a resource must be before Cloud DLP can profile it. Value must
        #     be 1 hour or greater.
        # @!attribute [rw] amazon_s3_bucket_conditions
        #   @return [::Google::Cloud::Dlp::V2::AmazonS3BucketConditions]
        #     Amazon S3 bucket conditions.
        class DiscoveryOtherCloudConditions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Amazon S3 bucket conditions.
        # @!attribute [rw] bucket_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::AmazonS3BucketConditions::BucketType>]
        #     Optional. Bucket types that should be profiled.
        #     Optional. Defaults to TYPE_ALL_SUPPORTED if unspecified.
        # @!attribute [rw] object_storage_classes
        #   @return [::Array<::Google::Cloud::Dlp::V2::AmazonS3BucketConditions::ObjectStorageClass>]
        #     Optional. Object classes that should be profiled.
        #     Optional. Defaults to ALL_SUPPORTED_CLASSES if unspecified.
        class AmazonS3BucketConditions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Supported Amazon S3 bucket types.
          # Defaults to TYPE_ALL_SUPPORTED.
          module BucketType
            # Unused.
            TYPE_UNSPECIFIED = 0

            # All supported classes.
            TYPE_ALL_SUPPORTED = 1

            # A general purpose Amazon S3 bucket.
            TYPE_GENERAL_PURPOSE = 2
          end

          # Supported Amazon S3 object storage classes.
          # Defaults to ALL_SUPPORTED_CLASSES.
          module ObjectStorageClass
            # Unused.
            UNSPECIFIED = 0

            # All supported classes.
            ALL_SUPPORTED_CLASSES = 1

            # Standard object class.
            STANDARD = 2

            # Standard - infrequent access object class.
            STANDARD_INFREQUENT_ACCESS = 4

            # Glacier - instant retrieval object class.
            GLACIER_INSTANT_RETRIEVAL = 6

            # Objects in the S3 Intelligent-Tiering access tiers.
            INTELLIGENT_TIERING = 7
          end
        end

        # How often existing resources should have their profiles refreshed.
        # New resources are scanned as quickly as possible depending on system
        # capacity.
        # @!attribute [rw] refresh_frequency
        #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
        #     Optional. Frequency to update profiles regardless of whether the underlying
        #     resource has changes. Defaults to never.
        # @!attribute [rw] inspect_template_modified_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryInspectTemplateModifiedCadence]
        #     Optional. Governs when to update data profiles when the inspection rules
        #     defined by the `InspectTemplate` change.
        #     If not set, changing the template will not cause a data profile to update.
        class DiscoveryOtherCloudGenerationCadence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The location to begin a discovery scan. Denotes an organization ID or folder
        # ID within an organization.
        # @!attribute [rw] organization_id
        #   @return [::Integer]
        #     The ID of an organization to scan.
        #
        #     Note: The following fields are mutually exclusive: `organization_id`, `folder_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] folder_id
        #   @return [::Integer]
        #     The ID of the folder within an organization to be scanned.
        #
        #     Note: The following fields are mutually exclusive: `folder_id`, `organization_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DiscoveryStartingLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The other cloud starting location for discovery.
        # @!attribute [rw] aws_location
        #   @return [::Google::Cloud::Dlp::V2::OtherCloudDiscoveryStartingLocation::AwsDiscoveryStartingLocation]
        #     The AWS starting location for discovery.
        class OtherCloudDiscoveryStartingLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The AWS starting location for discovery.
          # @!attribute [rw] account_id
          #   @return [::String]
          #     The AWS account ID that this discovery config applies to.
          #     Within an AWS organization, you can find the AWS account ID inside an
          #     AWS account ARN. Example:
          #     arn:\\{partition}:organizations::\\{management_account_id}:account/\\{org_id}/\\{account_id}
          #
          #     Note: The following fields are mutually exclusive: `account_id`, `all_asset_inventory_assets`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] all_asset_inventory_assets
          #   @return [::Boolean]
          #     All AWS assets stored in Asset Inventory that didn't match other AWS
          #     discovery configs.
          #
          #     Note: The following fields are mutually exclusive: `all_asset_inventory_assets`, `account_id`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class AwsDiscoveryStartingLocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Match discovery resources not covered by any other filter.
        class AllOtherResources
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Target used to match against for discovery with Vertex AI datasets.
        # @!attribute [rw] filter
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryVertexDatasetFilter]
        #     Required. The datasets the discovery cadence applies to. The first target
        #     with a matching filter will be the one to apply to a dataset.
        # @!attribute [rw] conditions
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryVertexDatasetConditions]
        #     In addition to matching the filter, these conditions must be true
        #     before a profile is generated.
        # @!attribute [rw] generation_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryVertexDatasetGenerationCadence]
        #     How often and when to update profiles. New datasets that match both the
        #     filter and conditions are scanned as quickly as possible depending on
        #     system capacity.
        #
        #     Note: The following fields are mutually exclusive: `generation_cadence`, `disabled`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] disabled
        #   @return [::Google::Cloud::Dlp::V2::Disabled]
        #     Disable profiling for datasets that match this filter.
        #
        #     Note: The following fields are mutually exclusive: `disabled`, `generation_cadence`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class VertexDatasetDiscoveryTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Determines what datasets will have profiles generated within an organization
        # or project. Includes the ability to filter by regular expression patterns
        # on project ID or dataset regex.
        # @!attribute [rw] collection
        #   @return [::Google::Cloud::Dlp::V2::VertexDatasetCollection]
        #     A specific set of Vertex AI datasets for this filter to apply to.
        #
        #     Note: The following fields are mutually exclusive: `collection`, `vertex_dataset_resource_reference`, `others`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] vertex_dataset_resource_reference
        #   @return [::Google::Cloud::Dlp::V2::VertexDatasetResourceReference]
        #     The dataset resource to scan. Targets including this can only include
        #     one target (the target with this dataset resource reference).
        #
        #     Note: The following fields are mutually exclusive: `vertex_dataset_resource_reference`, `collection`, `others`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] others
        #   @return [::Google::Cloud::Dlp::V2::AllOtherResources]
        #     Catch-all. This should always be the last target in the list because
        #     anything above it will apply first. Should only appear once in a
        #     configuration. If none is specified, a default one will be added
        #     automatically.
        #
        #     Note: The following fields are mutually exclusive: `others`, `collection`, `vertex_dataset_resource_reference`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DiscoveryVertexDatasetFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Match dataset resources using regex filters.
        # @!attribute [rw] vertex_dataset_regexes
        #   @return [::Google::Cloud::Dlp::V2::VertexDatasetRegexes]
        #     The regex used to filter dataset resources.
        class VertexDatasetCollection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A collection of regular expressions to determine what datasets to match
        # against.
        # @!attribute [rw] patterns
        #   @return [::Array<::Google::Cloud::Dlp::V2::VertexDatasetRegex>]
        #     Required. The group of regular expression patterns to match against one or
        #     more datasets. Maximum of 100 entries. The sum of the lengths of all
        #     regular expressions can't exceed 10 KiB.
        class VertexDatasetRegexes
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A pattern to match against one or more dataset resources.
        # @!attribute [rw] project_id_regex
        #   @return [::String]
        #     For organizations, if unset, will match all projects. Has no effect
        #     for configurations created within a project.
        class VertexDatasetRegex
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Identifies a single Vertex AI resource. Only datasets are
        # supported.
        # @!attribute [rw] dataset_resource_name
        #   @return [::String]
        #     Required. The name of the Vertex AI resource. If set within a project-level
        #     configuration, the specified resource must be within the project.
        #     Examples:
        #
        #     * `projects/{project}/locations/{location}/datasets/{dataset}`
        class VertexDatasetResourceReference
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Requirements that must be true before a dataset is profiled for the
        # first time.
        # @!attribute [rw] created_after
        #   @return [::Google::Protobuf::Timestamp]
        #     Vertex AI dataset must have been created after this date. Used to avoid
        #     backfilling.
        # @!attribute [rw] min_age
        #   @return [::Google::Protobuf::Duration]
        #     Minimum age a Vertex AI dataset must have. If set, the value must be 1 hour
        #     or greater.
        class DiscoveryVertexDatasetConditions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # How often existing datasets should have their profiles refreshed.
        # New datasets are scanned as quickly as possible depending on system
        # capacity.
        # @!attribute [rw] refresh_frequency
        #   @return [::Google::Cloud::Dlp::V2::DataProfileUpdateFrequency]
        #     If you set this field, profiles are refreshed at this
        #     frequency regardless of whether the underlying datasets have changed.
        #     Defaults to never.
        # @!attribute [rw] inspect_template_modified_cadence
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryInspectTemplateModifiedCadence]
        #     Governs when to update data profiles when the inspection rules
        #     defined by the `InspectTemplate` change.
        #     If not set, changing the template will not cause a data profile to be
        #     updated.
        class DiscoveryVertexDatasetGenerationCadence
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Combines all of the information about a DLP job.
        # @!attribute [rw] name
        #   @return [::String]
        #     The server-assigned name.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dlp::V2::DlpJobType]
        #     The type of job.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dlp::V2::DlpJob::JobState]
        #     State of a job.
        # @!attribute [rw] risk_details
        #   @return [::Google::Cloud::Dlp::V2::AnalyzeDataSourceRiskDetails]
        #     Results from analyzing risk of a data source.
        #
        #     Note: The following fields are mutually exclusive: `risk_details`, `inspect_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] inspect_details
        #   @return [::Google::Cloud::Dlp::V2::InspectDataSourceDetails]
        #     Results from inspecting a data source.
        #
        #     Note: The following fields are mutually exclusive: `inspect_details`, `risk_details`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the job was created.
        # @!attribute [rw] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the job started.
        # @!attribute [rw] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the job finished.
        # @!attribute [rw] last_modified
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the job was last modified by the system.
        # @!attribute [rw] job_trigger_name
        #   @return [::String]
        #     If created by a job trigger, the resource name of the trigger that
        #     instantiated the job.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Cloud::Dlp::V2::Error>]
        #     A stream of errors encountered running the job.
        # @!attribute [rw] action_details
        #   @return [::Array<::Google::Cloud::Dlp::V2::ActionDetails>]
        #     Events that should occur after the job has completed.
        class DlpJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of a job. New items may be added.
          module JobState
            # Unused.
            JOB_STATE_UNSPECIFIED = 0

            # The job has not yet started.
            PENDING = 1

            # The job is currently running. Once a job has finished it will transition
            # to FAILED or DONE.
            RUNNING = 2

            # The job is no longer running.
            DONE = 3

            # The job was canceled before it could be completed.
            CANCELED = 4

            # The job had an error and did not complete.
            FAILED = 5

            # The job is currently accepting findings via hybridInspect.
            # A hybrid job in ACTIVE state may continue to have findings added to it
            # through the calling of hybridInspect. After the job has finished no more
            # calls to hybridInspect may be made. ACTIVE jobs can transition to DONE.
            ACTIVE = 6
          end
        end

        # The request message for
        # {::Google::Cloud::Dlp::V2::DlpService::Client#get_dlp_job GetDlpJob}.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DlpJob resource.
        class GetDlpJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for listing DLP jobs.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on whether you have [specified a
        #     processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] filter
        #   @return [::String]
        #     Allows filtering.
        #
        #     Supported syntax:
        #
        #     * Filter expressions are made up of one or more restrictions.
        #     * Restrictions can be combined by `AND` or `OR` logical operators. A
        #     sequence of restrictions implicitly uses `AND`.
        #     * A restriction has the form of `{field} {operator} {value}`.
        #     * Supported fields/values for inspect jobs:
        #         - `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED
        #         - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
        #         - `trigger_name` - The name of the trigger that created the job.
        #         - 'end_time` - Corresponds to the time the job finished.
        #         - 'start_time` - Corresponds to the time the job finished.
        #     * Supported fields for risk analysis jobs:
        #         - `state` - RUNNING|CANCELED|FINISHED|FAILED
        #         - 'end_time` - Corresponds to the time the job finished.
        #         - 'start_time` - Corresponds to the time the job finished.
        #     * The operator must be `=` or `!=`.
        #
        #     The syntax is based on https://google.aip.dev/160.
        #
        #     Examples:
        #
        #     * inspected_storage = cloud_storage AND state = done
        #     * inspected_storage = cloud_storage OR inspected_storage = bigquery
        #     * inspected_storage = cloud_storage AND (state = done OR state = canceled)
        #     * end_time > \"2017-12-12T00:00:00+00:00\"
        #
        #     The length of this field should be no more than 500 characters.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The standard list page size.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     The standard list page token.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dlp::V2::DlpJobType]
        #     The type of job. Defaults to `DlpJobType.INSPECT`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of fields to order by,
        #     followed by `asc` or `desc` postfix. This list is case insensitive. The
        #     default sorting order is ascending. Redundant space characters are
        #     insignificant.
        #
        #     Example: `name asc, end_time asc, create_time desc`
        #
        #     Supported fields are:
        #
        #     - `create_time`: corresponds to the time the job was created.
        #     - `end_time`: corresponds to the time the job ended.
        #     - `name`: corresponds to the job's name.
        #     - `state`: corresponds to `state`
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class ListDlpJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response message for listing DLP jobs.
        # @!attribute [rw] jobs
        #   @return [::Array<::Google::Cloud::Dlp::V2::DlpJob>]
        #     A list of DlpJobs that matches the specified filter in the request.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The standard List next-page token.
        class ListDlpJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for canceling a DLP job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DlpJob resource to be cancelled.
        class CancelDlpJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for finishing a DLP hybrid job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DlpJob resource to be finished.
        class FinishDlpJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request message for deleting a DLP job.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the DlpJob resource to be deleted.
        class DeleteDlpJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateDeidentifyTemplate.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on the scope of the request
        #     (project or organization) and whether you have [specified a processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #     + Organizations scope, location specified:
        #       `organizations/{org_id}/locations/{location_id}`
        #     + Organizations scope, no location specified (defaults to global):
        #       `organizations/{org_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] deidentify_template
        #   @return [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
        #     Required. The DeidentifyTemplate to create.
        # @!attribute [rw] template_id
        #   @return [::String]
        #     The template id can contain uppercase and lowercase letters,
        #     numbers, and hyphens; that is, it must match the regular
        #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
        #     characters. Can be empty to allow the system to generate one.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class CreateDeidentifyTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateDeidentifyTemplate.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of organization and deidentify template to be
        #     updated, for example
        #     `organizations/433245324/deidentifyTemplates/432452342` or
        #     projects/project-id/deidentifyTemplates/432452342.
        # @!attribute [rw] deidentify_template
        #   @return [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
        #     New DeidentifyTemplate value.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask to control which fields get updated.
        class UpdateDeidentifyTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetDeidentifyTemplate.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the organization and deidentify template to be
        #     read, for example `organizations/433245324/deidentifyTemplates/432452342`
        #     or projects/project-id/deidentifyTemplates/432452342.
        class GetDeidentifyTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListDeidentifyTemplates.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on the scope of the request
        #     (project or organization) and whether you have [specified a processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #     + Organizations scope, location specified:
        #       `organizations/{org_id}/locations/{location_id}`
        #     + Organizations scope, no location specified (defaults to global):
        #       `organizations/{org_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token to continue retrieval. Comes from the previous call
        #     to `ListDeidentifyTemplates`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Size of the page. This value can be limited by the server. If zero server
        #     returns a page of max size 100.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of fields to order by,
        #     followed by `asc` or `desc` postfix. This list is case insensitive. The
        #     default sorting order is ascending. Redundant space characters are
        #     insignificant.
        #
        #     Example: `name asc,update_time, create_time desc`
        #
        #     Supported fields are:
        #
        #     - `create_time`: corresponds to the time the template was created.
        #     - `update_time`: corresponds to the time the template was last updated.
        #     - `name`: corresponds to the template's name.
        #     - `display_name`: corresponds to the template's display name.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class ListDeidentifyTemplatesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListDeidentifyTemplates.
        # @!attribute [rw] deidentify_templates
        #   @return [::Array<::Google::Cloud::Dlp::V2::DeidentifyTemplate>]
        #     List of deidentify templates, up to page_size in
        #     ListDeidentifyTemplatesRequest.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If the next page is available then the next page token to be used in the
        #     following ListDeidentifyTemplates request.
        class ListDeidentifyTemplatesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteDeidentifyTemplate.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the organization and deidentify template to be
        #     deleted, for example
        #     `organizations/433245324/deidentifyTemplates/432452342` or
        #     projects/project-id/deidentifyTemplates/432452342.
        class DeleteDeidentifyTemplateRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for a custom dictionary created from a data source of any size
        # up to the maximum size defined in the
        # [limits](https://cloud.google.com/sensitive-data-protection/limits) page. The
        # artifacts of dictionary creation are stored in the specified Cloud Storage
        # location. Consider using `CustomInfoType.Dictionary` for smaller dictionaries
        # that satisfy the size requirements.
        # @!attribute [rw] output_path
        #   @return [::Google::Cloud::Dlp::V2::CloudStoragePath]
        #     Location to store dictionary artifacts in Cloud Storage. These files
        #     will only be accessible by project owners and the DLP API. If any of these
        #     artifacts are modified, the dictionary is considered invalid and can no
        #     longer be used.
        # @!attribute [rw] cloud_storage_file_set
        #   @return [::Google::Cloud::Dlp::V2::CloudStorageFileSet]
        #     Set of files containing newline-delimited lists of dictionary phrases.
        #
        #     Note: The following fields are mutually exclusive: `cloud_storage_file_set`, `big_query_field`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] big_query_field
        #   @return [::Google::Cloud::Dlp::V2::BigQueryField]
        #     Field in a BigQuery table where each cell represents a dictionary phrase.
        #
        #     Note: The following fields are mutually exclusive: `big_query_field`, `cloud_storage_file_set`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class LargeCustomDictionaryConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Summary statistics of a custom dictionary.
        # @!attribute [rw] approx_num_phrases
        #   @return [::Integer]
        #     Approximate number of distinct phrases in the dictionary.
        class LargeCustomDictionaryStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration for stored infoTypes. All fields and subfield are provided
        # by the user. For more information, see
        # https://cloud.google.com/sensitive-data-protection/docs/creating-custom-infotypes.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Display name of the StoredInfoType (max 256 characters).
        # @!attribute [rw] description
        #   @return [::String]
        #     Description of the StoredInfoType (max 256 characters).
        # @!attribute [rw] large_custom_dictionary
        #   @return [::Google::Cloud::Dlp::V2::LargeCustomDictionaryConfig]
        #     StoredInfoType where findings are defined by a dictionary of phrases.
        #
        #     Note: The following fields are mutually exclusive: `large_custom_dictionary`, `dictionary`, `regex`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] dictionary
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Dictionary]
        #     Store dictionary-based CustomInfoType.
        #
        #     Note: The following fields are mutually exclusive: `dictionary`, `large_custom_dictionary`, `regex`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] regex
        #   @return [::Google::Cloud::Dlp::V2::CustomInfoType::Regex]
        #     Store regular expression-based StoredInfoType.
        #
        #     Note: The following fields are mutually exclusive: `regex`, `large_custom_dictionary`, `dictionary`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class StoredInfoTypeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Statistics for a StoredInfoType.
        # @!attribute [rw] large_custom_dictionary
        #   @return [::Google::Cloud::Dlp::V2::LargeCustomDictionaryStats]
        #     StoredInfoType where findings are defined by a dictionary of phrases.
        class StoredInfoTypeStats
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Version of a StoredInfoType, including the configuration used to build it,
        # create timestamp, and current state.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Dlp::V2::StoredInfoTypeConfig]
        #     StoredInfoType configuration.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Create timestamp of the version. Read-only, determined by the system
        #     when the version is created.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dlp::V2::StoredInfoTypeState]
        #     Stored info type version state. Read-only, updated by the system
        #     during dictionary creation.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Cloud::Dlp::V2::Error>]
        #     Errors that occurred when creating this storedInfoType version, or
        #     anomalies detected in the storedInfoType data that render it unusable. Only
        #     the five most recent errors will be displayed, with the most recent error
        #     appearing first.
        #
        #     For example, some of the data for stored custom dictionaries is put in
        #     the user's Cloud Storage bucket, and if this data is modified or
        #     deleted by the user or another system, the dictionary becomes invalid.
        #
        #     If any errors occur, fix the problem indicated by the error message and
        #     use the UpdateStoredInfoType API method to create another version of the
        #     storedInfoType to continue using it, reusing the same `config` if it was
        #     not the source of the error.
        # @!attribute [rw] stats
        #   @return [::Google::Cloud::Dlp::V2::StoredInfoTypeStats]
        #     Statistics about this storedInfoType version.
        class StoredInfoTypeVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # StoredInfoType resource message that contains information about the current
        # version and any pending updates.
        # @!attribute [rw] name
        #   @return [::String]
        #     Resource name.
        # @!attribute [rw] current_version
        #   @return [::Google::Cloud::Dlp::V2::StoredInfoTypeVersion]
        #     Current version of the stored info type.
        # @!attribute [rw] pending_versions
        #   @return [::Array<::Google::Cloud::Dlp::V2::StoredInfoTypeVersion>]
        #     Pending versions of the stored info type. Empty if no versions are
        #     pending.
        class StoredInfoType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateStoredInfoType.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on the scope of the request
        #     (project or organization) and whether you have [specified a processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #     + Organizations scope, location specified:
        #       `organizations/{org_id}/locations/{location_id}`
        #     + Organizations scope, no location specified (defaults to global):
        #       `organizations/{org_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Dlp::V2::StoredInfoTypeConfig]
        #     Required. Configuration of the storedInfoType to create.
        # @!attribute [rw] stored_info_type_id
        #   @return [::String]
        #     The storedInfoType ID can contain uppercase and lowercase letters,
        #     numbers, and hyphens; that is, it must match the regular
        #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
        #     characters. Can be empty to allow the system to generate one.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class CreateStoredInfoTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateStoredInfoType.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of organization and storedInfoType to be updated,
        #     for example `organizations/433245324/storedInfoTypes/432452342` or
        #     projects/project-id/storedInfoTypes/432452342.
        # @!attribute [rw] config
        #   @return [::Google::Cloud::Dlp::V2::StoredInfoTypeConfig]
        #     Updated configuration for the storedInfoType. If not provided, a new
        #     version of the storedInfoType will be created with the existing
        #     configuration.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Mask to control which fields get updated.
        class UpdateStoredInfoTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetStoredInfoType.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the organization and storedInfoType to be read,
        #     for example `organizations/433245324/storedInfoTypes/432452342` or
        #     projects/project-id/storedInfoTypes/432452342.
        class GetStoredInfoTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListStoredInfoTypes.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on the scope of the request
        #     (project or organization) and whether you have [specified a processing
        #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
        #
        #     + Projects scope, location specified:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Projects scope, no location specified (defaults to global):
        #       `projects/{project_id}`
        #
        #     The following example `parent` string specifies a parent project with the
        #     identifier `example-project`, and specifies the `europe-west3` location
        #     for processing data:
        #
        #         parent=projects/example-project/locations/europe-west3
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token to continue retrieval. Comes from the previous call
        #     to `ListStoredInfoTypes`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Size of the page. This value can be limited by the server. If zero server
        #     returns a page of max size 100.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of fields to order by,
        #     followed by `asc` or `desc` postfix. This list is case insensitive. The
        #     default sorting order is ascending. Redundant space characters are
        #     insignificant.
        #
        #     Example: `name asc, display_name, create_time desc`
        #
        #     Supported fields are:
        #
        #     - `create_time`: corresponds to the time the most recent version of the
        #     resource was created.
        #     - `state`: corresponds to the state of the resource.
        #     - `name`: corresponds to resource name.
        #     - `display_name`: corresponds to info type's display name.
        # @!attribute [rw] location_id
        #   @return [::String]
        #     Deprecated. This field has no effect.
        class ListStoredInfoTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListStoredInfoTypes.
        # @!attribute [rw] stored_info_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::StoredInfoType>]
        #     List of storedInfoTypes, up to page_size in ListStoredInfoTypesRequest.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     If the next page is available then the next page token to be used
        #     in the following ListStoredInfoTypes request.
        class ListStoredInfoTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteStoredInfoType.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the organization and storedInfoType to be
        #     deleted, for example `organizations/433245324/storedInfoTypes/432452342` or
        #     projects/project-id/storedInfoTypes/432452342.
        class DeleteStoredInfoTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to search for potentially sensitive info in a custom location.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the trigger to execute a hybrid inspect on, for
        #     example `projects/dlp-test-project/jobTriggers/53234423`.
        # @!attribute [rw] hybrid_item
        #   @return [::Google::Cloud::Dlp::V2::HybridContentItem]
        #     The item to inspect.
        class HybridInspectJobTriggerRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to search for potentially sensitive info in a custom location.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the job to execute a hybrid inspect on, for
        #     example `projects/dlp-test-project/dlpJob/53234423`.
        # @!attribute [rw] hybrid_item
        #   @return [::Google::Cloud::Dlp::V2::HybridContentItem]
        #     The item to inspect.
        class HybridInspectDlpJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An individual hybrid item to inspect. Will be stored temporarily during
        # processing.
        # @!attribute [rw] item
        #   @return [::Google::Cloud::Dlp::V2::ContentItem]
        #     The item to inspect.
        # @!attribute [rw] finding_details
        #   @return [::Google::Cloud::Dlp::V2::HybridFindingDetails]
        #     Supplementary information that will be added to each finding.
        class HybridContentItem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Populate to associate additional data with each finding.
        # @!attribute [rw] container_details
        #   @return [::Google::Cloud::Dlp::V2::Container]
        #     Details about the container where the content being inspected is from.
        # @!attribute [rw] file_offset
        #   @return [::Integer]
        #     Offset in bytes of the line, from the beginning of the file, where the
        #     finding  is located. Populate if the item being scanned is only part of a
        #     bigger item, such as a shard of a file and you want to track the absolute
        #     position of the finding.
        # @!attribute [rw] row_offset
        #   @return [::Integer]
        #     Offset of the row for tables. Populate if the row(s) being scanned are
        #     part of a bigger dataset and you want to keep track of their absolute
        #     position.
        # @!attribute [rw] table_options
        #   @return [::Google::Cloud::Dlp::V2::TableOptions]
        #     If the container is a table, additional information to make findings
        #     meaningful such as the columns that are primary keys. If not known ahead
        #     of time, can also be set within each inspect hybrid call and the two
        #     will be merged. Note that identifying_fields will only be stored to
        #     BigQuery, and only if the BigQuery action has been included.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels to represent user provided metadata about the data being inspected.
        #     If configured by the job, some key values may be required.
        #     The labels associated with `Finding`'s produced by hybrid
        #     inspection.
        #
        #     Label keys must be between 1 and 63 characters long and must conform
        #     to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
        #
        #     Label values must be between 0 and 63 characters long and must conform
        #     to the regular expression `([a-z]([-a-z0-9]*[a-z0-9])?)?`.
        #
        #     No more than 10 labels can be associated with a given finding.
        #
        #     Examples:
        #
        #     * `"environment" : "production"`
        #     * `"pipeline" : "etl"`
        class HybridFindingDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Quota exceeded errors will be thrown once quota has been met.
        class HybridInspectResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list the profiles generated for a given organization or project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. organizations/\\{org_id}/locations/\\{loc_id}
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token to continue retrieval.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Size of the page. This value can be limited by the server. If zero, server
        #     returns a page of max size 100.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of fields to order by, followed by `asc` or `desc`
        #     postfix. This list is case insensitive. The default sorting order is
        #     ascending. Redundant space characters are insignificant. Only one order
        #     field at a time is allowed.
        #
        #     Examples:
        #     * `project_id`
        #     * `sensitivity_level desc`
        #
        #     Supported fields:
        #
        #     - `project_id`: Google Cloud project ID
        #     - `sensitivity_level`: How sensitive the data in a project is, at most
        #     - `data_risk_level`: How much risk is associated with this data
        #     - `profile_last_generated`: Date and time (in epoch seconds) the profile
        #       was last generated
        # @!attribute [rw] filter
        #   @return [::String]
        #     Allows filtering.
        #
        #     Supported syntax:
        #
        #     * Filter expressions are made up of one or more restrictions.
        #     * Restrictions can be combined by `AND` or `OR` logical operators. A
        #     sequence of restrictions implicitly uses `AND`.
        #     * A restriction has the form of `{field} {operator} {value}`.
        #     * Supported fields:
        #         - `project_id`: the Google Cloud project ID
        #         - `sensitivity_level`: HIGH|MODERATE|LOW
        #         - `data_risk_level`: HIGH|MODERATE|LOW
        #         - `status_code`: an RPC status code as defined in
        #         https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
        #         - `profile_last_generated`: Date and time the profile was last
        #           generated
        #     * The operator must be `=` or `!=`. The `profile_last_generated` filter
        #       also supports `<` and `>`.
        #
        #     The syntax is based on https://google.aip.dev/160.
        #
        #     Examples:
        #
        #     * `project_id = 12345 AND status_code = 1`
        #     * `project_id = 12345 AND sensitivity_level = HIGH`
        #     * `profile_last_generated < "2025-01-01T00:00:00.000Z"`
        #
        #     The length of this field should be no more than 500 characters.
        class ListProjectDataProfilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of profiles generated for a given organization or project.
        # @!attribute [rw] project_data_profiles
        #   @return [::Array<::Google::Cloud::Dlp::V2::ProjectDataProfile>]
        #     List of data profiles.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token.
        class ListProjectDataProfilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list the profiles generated for a given organization or project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the organization or project, for
        #     example `organizations/433245324/locations/europe` or
        #     `projects/project-id/locations/asia`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token to continue retrieval.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Size of the page. This value can be limited by the server. If zero, server
        #     returns a page of max size 100.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of fields to order by, followed by `asc` or `desc`
        #     postfix. This list is case insensitive. The default sorting order is
        #     ascending. Redundant space characters are insignificant. Only one order
        #     field at a time is allowed.
        #
        #     Examples:
        #     * `project_id asc`
        #     * `table_id`
        #     * `sensitivity_level desc`
        #
        #     Supported fields are:
        #
        #     - `project_id`: The Google Cloud project ID.
        #     - `dataset_id`: The ID of a BigQuery dataset.
        #     - `table_id`: The ID of a BigQuery table.
        #     - `sensitivity_level`: How sensitive the data in a table is, at most.
        #     - `data_risk_level`: How much risk is associated with this data.
        #     - `profile_last_generated`: When the profile was last updated in epoch
        #     seconds.
        #     - `last_modified`: The last time the resource was modified.
        #     - `resource_visibility`: Visibility restriction for this resource.
        #     - `row_count`: Number of rows in this resource.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Allows filtering.
        #
        #     Supported syntax:
        #
        #     * Filter expressions are made up of one or more restrictions.
        #     * Restrictions can be combined by `AND` or `OR` logical operators. A
        #     sequence of restrictions implicitly uses `AND`.
        #     * A restriction has the form of `{field} {operator} {value}`.
        #     * Supported fields:
        #         - `project_id`: The Google Cloud project ID
        #         - `dataset_id`: The BigQuery dataset ID
        #         - `table_id`: The ID of the BigQuery table
        #         - `sensitivity_level`: HIGH|MODERATE|LOW
        #         - `data_risk_level`: HIGH|MODERATE|LOW
        #         - `resource_visibility`: PUBLIC|RESTRICTED
        #         - `status_code`: an RPC status code as defined in
        #         https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
        #         - `profile_last_generated`: Date and time the profile was last
        #           generated
        #
        #     * The operator must be `=` or `!=`. The `profile_last_generated` filter
        #       also supports `<` and `>`.
        #
        #     The syntax is based on https://google.aip.dev/160.
        #
        #     Examples:
        #
        #     * `project_id = 12345 AND status_code = 1`
        #     * `project_id = 12345 AND sensitivity_level = HIGH`
        #     * `project_id = 12345 AND resource_visibility = PUBLIC`
        #     * `profile_last_generated < "2025-01-01T00:00:00.000Z"`
        #
        #     The length of this field should be no more than 500 characters.
        class ListTableDataProfilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of profiles generated for a given organization or project.
        # @!attribute [rw] table_data_profiles
        #   @return [::Array<::Google::Cloud::Dlp::V2::TableDataProfile>]
        #     List of data profiles.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token.
        class ListTableDataProfilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list the profiles generated for a given organization or project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the organization or project, for
        #     example `organizations/433245324/locations/europe` or
        #     `projects/project-id/locations/asia`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Page token to continue retrieval.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Size of the page. This value can be limited by the server. If zero, server
        #     returns a page of max size 100.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Comma-separated list of fields to order by, followed by `asc` or `desc`
        #     postfix. This list is case insensitive. The default sorting order is
        #     ascending. Redundant space characters are insignificant. Only one order
        #     field at a time is allowed.
        #
        #     Examples:
        #
        #     * `project_id asc`
        #     * `table_id`
        #     * `sensitivity_level desc`
        #
        #     Supported fields are:
        #
        #     - `project_id`: The Google Cloud project ID.
        #     - `dataset_id`: The ID of a BigQuery dataset.
        #     - `table_id`: The ID of a BigQuery table.
        #     - `sensitivity_level`: How sensitive the data in a column is, at most.
        #     - `data_risk_level`: How much risk is associated with this data.
        #     - `profile_last_generated`: When the profile was last updated in epoch
        #     seconds.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Allows filtering.
        #
        #     Supported syntax:
        #
        #     * Filter expressions are made up of one or more restrictions.
        #     * Restrictions can be combined by `AND` or `OR` logical operators. A
        #     sequence of restrictions implicitly uses `AND`.
        #     * A restriction has the form of `{field} {operator} {value}`.
        #     * Supported fields:
        #         - `table_data_profile_name`: The name of the related table data
        #         profile
        #         - `project_id`: The Google Cloud project ID (REQUIRED)
        #         - `dataset_id`: The BigQuery dataset ID (REQUIRED)
        #         - `table_id`: The BigQuery table ID (REQUIRED)
        #         - `field_id`: The ID of the BigQuery field
        #         - `info_type`: The infotype detected in the resource
        #         - `sensitivity_level`: HIGH|MEDIUM|LOW
        #         - `data_risk_level`: How much risk is associated with this data
        #         - `status_code`: An RPC status code as defined in
        #         https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
        #         - `profile_last_generated`: Date and time the profile was last
        #           generated
        #     * The operator must be `=` for project_id, dataset_id, and table_id. Other
        #       filters also support `!=`. The `profile_last_generated` filter also
        #       supports `<` and `>`.
        #
        #     The syntax is based on https://google.aip.dev/160.
        #
        #     Examples:
        #
        #     * project_id = 12345 AND status_code = 1
        #     * project_id = 12345 AND sensitivity_level = HIGH
        #     * project_id = 12345 AND info_type = STREET_ADDRESS
        #     * profile_last_generated < "2025-01-01T00:00:00.000Z"
        #
        #     The length of this field should be no more than 500 characters.
        class ListColumnDataProfilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of profiles generated for a given organization or project.
        # @!attribute [rw] column_data_profiles
        #   @return [::Array<::Google::Cloud::Dlp::V2::ColumnDataProfile>]
        #     List of data profiles.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token.
        class ListColumnDataProfilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Score is a summary of all elements in the data profile.
        # A higher number means more risk.
        # @!attribute [rw] score
        #   @return [::Google::Cloud::Dlp::V2::DataRiskLevel::DataRiskLevelScore]
        #     The score applied to the resource.
        class DataRiskLevel
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Various score levels for resources.
          module DataRiskLevelScore
            # Unused.
            RISK_SCORE_UNSPECIFIED = 0

            # Low risk - Lower indication of sensitive data that appears to have
            # additional access restrictions in place or no indication of sensitive
            # data found.
            RISK_LOW = 10

            # Unable to determine risk.
            RISK_UNKNOWN = 12

            # Medium risk - Sensitive data may be present but additional access or fine
            # grain access restrictions appear to be present.  Consider limiting
            # access even further or transform data to mask.
            RISK_MODERATE = 20

            # High risk – SPII may be present. Access controls may include public
            # ACLs. Exfiltration of data may lead to user data loss. Re-identification
            # of users may be possible. Consider limiting usage and or removing SPII.
            RISK_HIGH = 30
          end
        end

        # An aggregated profile for this project, based on the resources profiled
        # within it.
        # @!attribute [rw] name
        #   @return [::String]
        #     The resource name of the profile.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     Project ID or account that was profiled.
        # @!attribute [rw] profile_last_generated
        #   @return [::Google::Protobuf::Timestamp]
        #     The last time the profile was generated.
        # @!attribute [rw] sensitivity_score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
        #     The sensitivity score of this project.
        # @!attribute [rw] data_risk_level
        #   @return [::Google::Cloud::Dlp::V2::DataRiskLevel]
        #     The data risk level of this project.
        # @!attribute [rw] profile_status
        #   @return [::Google::Cloud::Dlp::V2::ProfileStatus]
        #     Success or error status of the last attempt to profile the project.
        # @!attribute [rw] table_data_profile_count
        #   @return [::Integer]
        #     The number of table data profiles generated for this project.
        # @!attribute [rw] file_store_data_profile_count
        #   @return [::Integer]
        #     The number of file store data profiles generated for this project.
        class ProjectDataProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Snapshot of the configurations used to generate the profile.
        # @!attribute [rw] inspect_config
        #   @return [::Google::Cloud::Dlp::V2::InspectConfig]
        #     A copy of the inspection config used to generate this profile. This
        #     is a copy of the inspect_template specified in `DataProfileJobConfig`.
        # @!attribute [rw] data_profile_job
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Dlp::V2::DataProfileJobConfig]
        #     A copy of the configuration used to generate this profile. This is
        #     deprecated, and the DiscoveryConfig field is preferred moving forward.
        #     DataProfileJobConfig will still be written here for Discovery in BigQuery
        #     for backwards compatibility, but will not be updated with new fields, while
        #     DiscoveryConfig will.
        # @!attribute [rw] discovery_config
        #   @return [::Google::Cloud::Dlp::V2::DiscoveryConfig]
        #     A copy of the configuration used to generate this profile.
        # @!attribute [rw] inspect_template_name
        #   @return [::String]
        #     Name of the inspection template used to generate this profile
        # @!attribute [rw] inspect_template_modified_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Timestamp when the template was modified
        class DataProfileConfigSnapshot
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The profile for a scanned table.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the profile.
        # @!attribute [rw] data_source_type
        #   @return [::Google::Cloud::Dlp::V2::DataSourceType]
        #     The resource type that was profiled.
        # @!attribute [rw] project_data_profile
        #   @return [::String]
        #     The resource name of the project data profile for this table.
        # @!attribute [rw] dataset_project_id
        #   @return [::String]
        #     The Google Cloud project ID that owns the resource.
        # @!attribute [rw] dataset_location
        #   @return [::String]
        #     If supported, the location where the dataset's data is stored.
        #     See https://cloud.google.com/bigquery/docs/locations for supported
        #     locations.
        # @!attribute [rw] dataset_id
        #   @return [::String]
        #     If the resource is BigQuery, the dataset ID.
        # @!attribute [rw] table_id
        #   @return [::String]
        #     The table ID.
        # @!attribute [rw] full_resource
        #   @return [::String]
        #     The Cloud Asset Inventory resource that was profiled in order to generate
        #     this TableDataProfile.
        #     https://cloud.google.com/apis/design/resource_names#full_resource_name
        # @!attribute [rw] profile_status
        #   @return [::Google::Cloud::Dlp::V2::ProfileStatus]
        #     Success or error status from the most recent profile generation attempt.
        #     May be empty if the profile is still being generated.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dlp::V2::TableDataProfile::State]
        #     State of a profile. This will always be set to DONE when the table data
        #     profile is written to another service like BigQuery or Pub/Sub.
        # @!attribute [rw] sensitivity_score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
        #     The sensitivity score of this table.
        # @!attribute [rw] data_risk_level
        #   @return [::Google::Cloud::Dlp::V2::DataRiskLevel]
        #     The data risk level of this table.
        # @!attribute [rw] predicted_info_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::InfoTypeSummary>]
        #     The infoTypes predicted from this table's data.
        # @!attribute [rw] other_info_types
        #   @return [::Array<::Google::Cloud::Dlp::V2::OtherInfoTypeSummary>]
        #     Other infoTypes found in this table's data.
        # @!attribute [rw] config_snapshot
        #   @return [::Google::Cloud::Dlp::V2::DataProfileConfigSnapshot]
        #     The snapshot of the configurations used to generate the profile.
        # @!attribute [rw] last_modified_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when this table was last modified
        # @!attribute [rw] expiration_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Optional. The time when this table expires.
        # @!attribute [rw] scanned_column_count
        #   @return [::Integer]
        #     The number of columns profiled in the table.
        # @!attribute [rw] failed_column_count
        #   @return [::Integer]
        #     The number of columns skipped in the table because of an error.
        # @!attribute [rw] table_size_bytes
        #   @return [::Integer]
        #     The size of the table when the profile was generated.
        # @!attribute [rw] row_count
        #   @return [::Integer]
        #     Number of rows in the table when the profile was generated.
        #     This will not be populated for BigLake tables.
        # @!attribute [rw] encryption_status
        #   @return [::Google::Cloud::Dlp::V2::EncryptionStatus]
        #     How the table is encrypted.
        # @!attribute [rw] resource_visibility
        #   @return [::Google::Cloud::Dlp::V2::ResourceVisibility]
        #     How broadly a resource has been shared.
        # @!attribute [rw] profile_last_generated
        #   @return [::Google::Protobuf::Timestamp]
        #     The last time the profile was generated.
        # @!attribute [rw] resource_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels applied to the resource at the time the profile was generated.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which the table was created.
        # @!attribute [rw] sample_findings_table
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     The BigQuery table to which the sample findings are written.
        # @!attribute [rw] tags
        #   @return [::Array<::Google::Cloud::Dlp::V2::Tag>]
        #     The tags attached to the table, including any tags attached during
        #     profiling. Because tags are attached to Cloud SQL instances rather than
        #     Cloud SQL tables, this field is empty for Cloud SQL table profiles.
        # @!attribute [rw] related_resources
        #   @return [::Array<::Google::Cloud::Dlp::V2::RelatedResource>]
        #     Resources related to this profile.
        # @!attribute [rw] domains
        #   @return [::Array<::Google::Cloud::Dlp::V2::Domain>]
        #     Domains associated with the profile.
        class TableDataProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states of a profile. New items may be added.
          module State
            # Unused.
            STATE_UNSPECIFIED = 0

            # The profile is currently running. Once a profile has finished it will
            # transition to DONE.
            RUNNING = 1

            # The profile is no longer generating.
            # If profile_status.status.code is 0, the profile succeeded, otherwise, it
            # failed.
            DONE = 2
          end
        end

        # Success or errors for the profile generation.
        # @!attribute [rw] status
        #   @return [::Google::Rpc::Status]
        #     Profiling status code and optional message. The `status.code` value is 0
        #     (default value) for OK.
        # @!attribute [rw] timestamp
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the profile generation status was updated
        class ProfileStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The infoType details for this column.
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     The infoType.
        # @!attribute [rw] estimated_prevalence
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Integer]
        #     Not populated for predicted infotypes.
        class InfoTypeSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Infotype details for other infoTypes found within a column.
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     The other infoType.
        # @!attribute [rw] estimated_prevalence
        #   @return [::Integer]
        #     Approximate percentage of non-null rows that contained data detected by
        #     this infotype.
        # @!attribute [rw] excluded_from_analysis
        #   @return [::Boolean]
        #     Whether this infoType was excluded from sensitivity and risk analysis due
        #     to factors such as low prevalence (subject to change).
        class OtherInfoTypeSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The profile for a scanned column within a table.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the profile.
        # @!attribute [rw] profile_status
        #   @return [::Google::Cloud::Dlp::V2::ProfileStatus]
        #     Success or error status from the most recent profile generation attempt.
        #     May be empty if the profile is still being generated.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dlp::V2::ColumnDataProfile::State]
        #     State of a profile.
        # @!attribute [rw] profile_last_generated
        #   @return [::Google::Protobuf::Timestamp]
        #     The last time the profile was generated.
        # @!attribute [rw] table_data_profile
        #   @return [::String]
        #     The resource name of the table data profile.
        # @!attribute [rw] table_full_resource
        #   @return [::String]
        #     The resource name of the resource this column is within.
        # @!attribute [rw] dataset_project_id
        #   @return [::String]
        #     The Google Cloud project ID that owns the profiled resource.
        # @!attribute [rw] dataset_location
        #   @return [::String]
        #     If supported, the location where the dataset's data is stored.
        #     See https://cloud.google.com/bigquery/docs/locations for supported
        #     BigQuery locations.
        # @!attribute [rw] dataset_id
        #   @return [::String]
        #     The BigQuery dataset ID, if the resource profiled is a BigQuery table.
        # @!attribute [rw] table_id
        #   @return [::String]
        #     The table ID.
        # @!attribute [rw] column
        #   @return [::String]
        #     The name of the column.
        # @!attribute [rw] sensitivity_score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
        #     The sensitivity of this column.
        # @!attribute [rw] data_risk_level
        #   @return [::Google::Cloud::Dlp::V2::DataRiskLevel]
        #     The data risk level for this column.
        # @!attribute [rw] column_info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoTypeSummary]
        #     If it's been determined this column can be identified as a single type,
        #     this will be set. Otherwise the column either has unidentifiable content
        #     or mixed types.
        # @!attribute [rw] other_matches
        #   @return [::Array<::Google::Cloud::Dlp::V2::OtherInfoTypeSummary>]
        #     Other types found within this column. List will be unordered.
        # @!attribute [rw] estimated_null_percentage
        #   @return [::Google::Cloud::Dlp::V2::NullPercentageLevel]
        #     Approximate percentage of entries being null in the column.
        # @!attribute [rw] estimated_uniqueness_score
        #   @return [::Google::Cloud::Dlp::V2::UniquenessScoreLevel]
        #     Approximate uniqueness of the column.
        # @!attribute [rw] free_text_score
        #   @return [::Float]
        #     The likelihood that this column contains free-form text.
        #     A value close to 1 may indicate the column is likely to contain
        #     free-form or natural language text.
        #     Range in 0-1.
        # @!attribute [rw] column_type
        #   @return [::Google::Cloud::Dlp::V2::ColumnDataProfile::ColumnDataType]
        #     The data type of a given column.
        # @!attribute [rw] policy_state
        #   @return [::Google::Cloud::Dlp::V2::ColumnDataProfile::ColumnPolicyState]
        #     Indicates if a policy tag has been applied to the column.
        class ColumnDataProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible states of a profile. New items may be added.
          module State
            # Unused.
            STATE_UNSPECIFIED = 0

            # The profile is currently running. Once a profile has finished it will
            # transition to DONE.
            RUNNING = 1

            # The profile is no longer generating.
            # If profile_status.status.code is 0, the profile succeeded, otherwise, it
            # failed.
            DONE = 2
          end

          # Data types of the data in a column. Types may be added over time.
          module ColumnDataType
            # Invalid type.
            COLUMN_DATA_TYPE_UNSPECIFIED = 0

            # Encoded as a string in decimal format.
            TYPE_INT64 = 1

            # Encoded as a boolean "false" or "true".
            TYPE_BOOL = 2

            # Encoded as a number, or string "NaN", "Infinity" or "-Infinity".
            TYPE_FLOAT64 = 3

            # Encoded as a string value.
            TYPE_STRING = 4

            # Encoded as a base64 string per RFC 4648, section 4.
            TYPE_BYTES = 5

            # Encoded as an RFC 3339 timestamp with mandatory "Z" time zone string:
            # 1985-04-12T23:20:50.52Z
            TYPE_TIMESTAMP = 6

            # Encoded as RFC 3339 full-date format string: 1985-04-12
            TYPE_DATE = 7

            # Encoded as RFC 3339 partial-time format string: 23:20:50.52
            TYPE_TIME = 8

            # Encoded as RFC 3339 full-date "T" partial-time: 1985-04-12T23:20:50.52
            TYPE_DATETIME = 9

            # Encoded as WKT
            TYPE_GEOGRAPHY = 10

            # Encoded as a decimal string.
            TYPE_NUMERIC = 11

            # Container of ordered fields, each with a type and field name.
            TYPE_RECORD = 12

            # Decimal type.
            TYPE_BIGNUMERIC = 13

            # Json type.
            TYPE_JSON = 14

            # Interval type.
            TYPE_INTERVAL = 15

            # `Range<Date>` type.
            TYPE_RANGE_DATE = 16

            # `Range<Datetime>` type.
            TYPE_RANGE_DATETIME = 17

            # `Range<Timestamp>` type.
            TYPE_RANGE_TIMESTAMP = 18
          end

          # The possible policy states for a column.
          module ColumnPolicyState
            # No policy tags.
            COLUMN_POLICY_STATE_UNSPECIFIED = 0

            # Column has policy tag applied.
            COLUMN_POLICY_TAGGED = 1
          end
        end

        # The profile for a file store.
        #
        # * Cloud Storage: maps 1:1 with a bucket.
        # * Amazon S3: maps 1:1 with a bucket.
        # @!attribute [rw] name
        #   @return [::String]
        #     The name of the profile.
        # @!attribute [rw] data_source_type
        #   @return [::Google::Cloud::Dlp::V2::DataSourceType]
        #     The resource type that was profiled.
        # @!attribute [rw] project_data_profile
        #   @return [::String]
        #     The resource name of the project data profile for this file store.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The Google Cloud project ID that owns the resource.
        #     For Amazon S3 buckets, this is the AWS Account Id.
        # @!attribute [rw] file_store_location
        #   @return [::String]
        #     The location of the file store.
        #
        #     * Cloud Storage:
        #     https://cloud.google.com/storage/docs/locations#available-locations
        #     * Amazon S3:
        #     https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints
        # @!attribute [rw] data_storage_locations
        #   @return [::Array<::String>]
        #     For resources that have multiple storage locations, these are those
        #     regions. For Cloud Storage this is the list of regions chosen for
        #     dual-region storage. `file_store_location` will normally be the
        #     corresponding multi-region for the list of individual locations. The first
        #     region is always picked as the processing and storage location for the data
        #     profile.
        # @!attribute [rw] location_type
        #   @return [::String]
        #     The location type of the file store (region, dual-region, multi-region,
        #     etc). If dual-region, expect data_storage_locations to be populated.
        # @!attribute [rw] file_store_path
        #   @return [::String]
        #     The file store path.
        #
        #     * Cloud Storage: `gs://{bucket}`
        #     * Amazon S3: `s3://{bucket}`
        #     * Vertex AI dataset:
        #     `projects/{project_number}/locations/{location}/datasets/{dataset_id}`
        # @!attribute [rw] full_resource
        #   @return [::String]
        #     The resource name of the resource profiled.
        #     https://cloud.google.com/apis/design/resource_names#full_resource_name
        #
        #     Example format of an S3 bucket full resource name:
        #     `//cloudasset.googleapis.com/organizations/{org_id}/otherCloudConnections/aws/arn:aws:s3:::{bucket_name}`
        # @!attribute [rw] config_snapshot
        #   @return [::Google::Cloud::Dlp::V2::DataProfileConfigSnapshot]
        #     The snapshot of the configurations used to generate the profile.
        # @!attribute [rw] profile_status
        #   @return [::Google::Cloud::Dlp::V2::ProfileStatus]
        #     Success or error status from the most recent profile generation attempt.
        #     May be empty if the profile is still being generated.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dlp::V2::FileStoreDataProfile::State]
        #     State of a profile.
        # @!attribute [rw] profile_last_generated
        #   @return [::Google::Protobuf::Timestamp]
        #     The last time the profile was generated.
        # @!attribute [rw] resource_visibility
        #   @return [::Google::Cloud::Dlp::V2::ResourceVisibility]
        #     How broadly a resource has been shared.
        # @!attribute [rw] sensitivity_score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
        #     The sensitivity score of this resource.
        # @!attribute [rw] data_risk_level
        #   @return [::Google::Cloud::Dlp::V2::DataRiskLevel]
        #     The data risk level of this resource.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the file store was first created.
        # @!attribute [rw] last_modified_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the file store was last modified.
        # @!attribute [rw] file_cluster_summaries
        #   @return [::Array<::Google::Cloud::Dlp::V2::FileClusterSummary>]
        #     FileClusterSummary per each cluster.
        # @!attribute [rw] resource_attributes
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dlp::V2::Value}]
        #     Attributes of the resource being profiled.
        #     Currently used attributes:
        #
        #     * customer_managed_encryption: boolean
        #         - true: the resource is encrypted with a customer-managed key.
        #         - false: the resource is encrypted with a provider-managed key.
        # @!attribute [rw] resource_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     The labels applied to the resource at the time the profile was generated.
        # @!attribute [rw] file_store_info_type_summaries
        #   @return [::Array<::Google::Cloud::Dlp::V2::FileStoreInfoTypeSummary>]
        #     InfoTypes detected in this file store.
        # @!attribute [rw] sample_findings_table
        #   @return [::Google::Cloud::Dlp::V2::BigQueryTable]
        #     The BigQuery table to which the sample findings are written.
        # @!attribute [rw] file_store_is_empty
        #   @return [::Boolean]
        #     The file store does not have any files. If the profiling operation failed,
        #     this is false.
        # @!attribute [rw] tags
        #   @return [::Array<::Google::Cloud::Dlp::V2::Tag>]
        #     The tags attached to the resource, including any tags attached during
        #     profiling.
        # @!attribute [rw] related_resources
        #   @return [::Array<::Google::Cloud::Dlp::V2::RelatedResource>]
        #     Resources related to this profile.
        # @!attribute [rw] domains
        #   @return [::Array<::Google::Cloud::Dlp::V2::Domain>]
        #     Domains associated with the profile.
        class FileStoreDataProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dlp::V2::Value]
          class ResourceAttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ResourceLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Possible states of a profile. New items may be added.
          module State
            # Unused.
            STATE_UNSPECIFIED = 0

            # The profile is currently running. Once a profile has finished it will
            # transition to DONE.
            RUNNING = 1

            # The profile is no longer generating.
            # If profile_status.status.code is 0, the profile succeeded, otherwise, it
            # failed.
            DONE = 2
          end
        end

        # A tag associated with a resource.
        # @!attribute [rw] namespaced_tag_value
        #   @return [::String]
        #     The namespaced name for the tag value to attach to Google Cloud resources.
        #     Must be in the format `{parent_id}/{tag_key_short_name}/{short_name}`, for
        #     example, "123456/environment/prod" for an organization parent, or
        #     "my-project/environment/prod" for a project parent. This is only set for
        #     Google Cloud resources.
        # @!attribute [rw] key
        #   @return [::String]
        #     The key of a tag key-value pair. For Google Cloud resources, this is the
        #     resource name of the key, for example, "tagKeys/123456".
        # @!attribute [rw] value
        #   @return [::String]
        #     The value of a tag key-value pair. For Google Cloud resources, this is the
        #     resource name of the value, for example, "tagValues/123456".
        class Tag
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Tags to match against for filtering.
        # @!attribute [rw] tag_filters
        #   @return [::Array<::Google::Cloud::Dlp::V2::TagFilter>]
        #     Required. A resource must match ALL of the specified tag filters to be
        #     included in the collection.
        class TagFilters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single tag to filter against.
        # @!attribute [rw] namespaced_tag_value
        #   @return [::String]
        #     The namespaced name for the tag value. Must be in the format
        #     `{parent_id}/{tag_key_short_name}/{short_name}`, for example,
        #     "123456/environment/prod" for an organization parent, or
        #     "my-project/environment/prod" for a project parent.
        #
        #     Note: The following fields are mutually exclusive: `namespaced_tag_value`, `namespaced_tag_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] namespaced_tag_key
        #   @return [::String]
        #     The namespaced name for the tag key. Must be in the format
        #     `{parent_id}/{tag_key_short_name}`, for example, "123456/sensitive" for
        #     an organization parent, or "my-project/sensitive" for a project parent.
        #
        #     Note: The following fields are mutually exclusive: `namespaced_tag_key`, `namespaced_tag_value`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class TagFilter
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A related resource.
        # Examples:
        #
        # * The source BigQuery table for a Vertex AI dataset.
        # * The source Cloud Storage bucket for a Vertex AI dataset.
        # @!attribute [rw] full_resource
        #   @return [::String]
        #     The full resource name of the related resource.
        class RelatedResource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information regarding the discovered InfoType.
        # @!attribute [rw] info_type
        #   @return [::Google::Cloud::Dlp::V2::InfoType]
        #     The InfoType seen.
        class FileStoreInfoTypeSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information regarding the discovered file extension.
        # @!attribute [rw] file_extension
        #   @return [::String]
        #     The file extension if set. (aka .pdf, .jpg, .txt)
        class FileExtensionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The file cluster summary.
        # @!attribute [rw] file_cluster_type
        #   @return [::Google::Cloud::Dlp::V2::FileClusterType]
        #     The file cluster type.
        # @!attribute [rw] file_store_info_type_summaries
        #   @return [::Array<::Google::Cloud::Dlp::V2::FileStoreInfoTypeSummary>]
        #     InfoTypes detected in this cluster.
        # @!attribute [rw] sensitivity_score
        #   @return [::Google::Cloud::Dlp::V2::SensitivityScore]
        #     The sensitivity score of this cluster. The score will be SENSITIVITY_LOW
        #     if nothing has been scanned.
        # @!attribute [rw] data_risk_level
        #   @return [::Google::Cloud::Dlp::V2::DataRiskLevel]
        #     The data risk level of this cluster. RISK_LOW if nothing has been
        #     scanned.
        # @!attribute [rw] errors
        #   @return [::Array<::Google::Cloud::Dlp::V2::Error>]
        #     A list of errors detected while scanning this cluster. The list is
        #     truncated to 10 per cluster.
        # @!attribute [rw] file_extensions_scanned
        #   @return [::Array<::Google::Cloud::Dlp::V2::FileExtensionInfo>]
        #     A sample of file types scanned in this cluster. Empty if no files were
        #     scanned. File extensions can be derived from the file name or the file
        #     content.
        # @!attribute [rw] file_extensions_seen
        #   @return [::Array<::Google::Cloud::Dlp::V2::FileExtensionInfo>]
        #     A sample of file types seen in this cluster. Empty if no files were seen.
        #     File extensions can be derived from the file name or the file content.
        # @!attribute [rw] no_files_exist
        #   @return [::Boolean]
        #     True if no files exist in this cluster. If the file store had more files
        #     than could be listed, this will be false even if no files for this cluster
        #     were seen and file_extensions_seen is empty.
        class FileClusterSummary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a project data profile.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name, for example
        #     `organizations/12345/locations/us/projectDataProfiles/53234423`.
        class GetProjectDataProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a file store data profile.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name, for example
        #     `organizations/12345/locations/us/fileStoreDataProfiles/53234423`.
        class GetFileStoreDataProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to list the file store profiles generated for a given organization or
        # project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the organization or project, for
        #     example `organizations/433245324/locations/europe` or
        #     `projects/project-id/locations/asia`.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token to continue retrieval.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Size of the page. This value can be limited by the server. If
        #     zero, server returns a page of max size 100.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Comma-separated list of fields to order by, followed by `asc` or
        #     `desc` postfix. This list is case insensitive. The default sorting order is
        #     ascending. Redundant space characters are insignificant. Only one order
        #     field at a time is allowed.
        #
        #     Examples:
        #
        #     * `project_id asc`
        #     * `name`
        #     * `sensitivity_level desc`
        #
        #     Supported fields are:
        #
        #     - `project_id`: The Google Cloud project ID.
        #     - `sensitivity_level`: How sensitive the data in a table is, at most.
        #     - `data_risk_level`: How much risk is associated with this data.
        #     - `profile_last_generated`: When the profile was last updated in epoch
        #     seconds.
        #     - `last_modified`: The last time the resource was modified.
        #     - `resource_visibility`: Visibility restriction for this resource.
        #     - `name`: The name of the profile.
        #     - `create_time`: The time the file store was first created.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Allows filtering.
        #
        #     Supported syntax:
        #
        #     * Filter expressions are made up of one or more restrictions.
        #     * Restrictions can be combined by `AND` or `OR` logical operators. A
        #     sequence of restrictions implicitly uses `AND`.
        #     * A restriction has the form of `{field} {operator} {value}`.
        #     * Supported fields:
        #         - `project_id`: The Google Cloud project ID
        #         - `account_id`: The AWS account ID
        #         - `file_store_path`: The path like "gs://bucket"
        #         - `data_source_type`: The profile's data source type, like
        #         "google/storage/bucket"
        #         - `data_storage_location`: The location where the file store's data is
        #         stored, like "us-central1"
        #         - `sensitivity_level`: HIGH|MODERATE|LOW
        #         - `data_risk_level`: HIGH|MODERATE|LOW
        #         - `resource_visibility`: PUBLIC|RESTRICTED
        #         - `status_code`: an RPC status code as defined in
        #         https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
        #         - `profile_last_generated`: Date and time the profile was last
        #           generated
        #
        #     * The operator must be `=` or `!=`. The `profile_last_generated` filter
        #       also supports `<` and `>`.
        #
        #     The syntax is based on https://google.aip.dev/160.
        #
        #     Examples:
        #
        #     * `project_id = 12345 AND status_code = 1`
        #     * `project_id = 12345 AND sensitivity_level = HIGH`
        #     * `project_id = 12345 AND resource_visibility = PUBLIC`
        #     * `file_store_path = "gs://mybucket"`
        #     * `profile_last_generated < "2025-01-01T00:00:00.000Z"`
        #
        #     The length of this field should be no more than 500 characters.
        class ListFileStoreDataProfilesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List of file store data profiles generated for a given organization or
        # project.
        # @!attribute [rw] file_store_data_profiles
        #   @return [::Array<::Google::Cloud::Dlp::V2::FileStoreDataProfile>]
        #     List of data profiles.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     The next page token.
        class ListFileStoreDataProfilesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteFileStoreProfile.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the file store data profile.
        class DeleteFileStoreDataProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a table data profile.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name, for example
        #     `organizations/12345/locations/us/tableDataProfiles/53234423`.
        class GetTableDataProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a column data profile.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name, for example
        #     `organizations/12345/locations/us/columnDataProfiles/53234423`.
        class GetColumnDataProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A condition for determining whether a Pub/Sub should be triggered.
        # @!attribute [rw] expressions
        #   @return [::Google::Cloud::Dlp::V2::DataProfilePubSubCondition::PubSubExpressions]
        #     An expression.
        class DataProfilePubSubCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A condition consisting of a value.
          # @!attribute [rw] minimum_risk_score
          #   @return [::Google::Cloud::Dlp::V2::DataProfilePubSubCondition::ProfileScoreBucket]
          #     The minimum data risk score that triggers the condition.
          #
          #     Note: The following fields are mutually exclusive: `minimum_risk_score`, `minimum_sensitivity_score`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] minimum_sensitivity_score
          #   @return [::Google::Cloud::Dlp::V2::DataProfilePubSubCondition::ProfileScoreBucket]
          #     The minimum sensitivity level that triggers the condition.
          #
          #     Note: The following fields are mutually exclusive: `minimum_sensitivity_score`, `minimum_risk_score`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class PubSubCondition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # An expression, consisting of an operator and conditions.
          # @!attribute [rw] logical_operator
          #   @return [::Google::Cloud::Dlp::V2::DataProfilePubSubCondition::PubSubExpressions::PubSubLogicalOperator]
          #     The operator to apply to the collection of conditions.
          # @!attribute [rw] conditions
          #   @return [::Array<::Google::Cloud::Dlp::V2::DataProfilePubSubCondition::PubSubCondition>]
          #     Conditions to apply to the expression.
          class PubSubExpressions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Logical operators for conditional checks.
            module PubSubLogicalOperator
              # Unused.
              LOGICAL_OPERATOR_UNSPECIFIED = 0

              # Conditional OR.
              OR = 1

              # Conditional AND.
              AND = 2
            end
          end

          # Various score levels for resources.
          module ProfileScoreBucket
            # Unused.
            PROFILE_SCORE_BUCKET_UNSPECIFIED = 0

            # High risk/sensitivity detected.
            HIGH = 1

            # Medium or high risk/sensitivity detected.
            MEDIUM_OR_HIGH = 2
          end
        end

        # Pub/Sub topic message for a DataProfileAction.PubSubNotification event.
        # To receive a message of protocol buffer schema type, convert the message data
        # to an object of this proto class.
        # @!attribute [rw] profile
        #   @return [::Google::Cloud::Dlp::V2::TableDataProfile]
        #     If `DetailLevel` is `TABLE_PROFILE` this will be fully populated.
        #     Otherwise, if `DetailLevel` is `RESOURCE_NAME`, then only `name` and
        #     `full_resource` will be populated.
        # @!attribute [rw] file_store_profile
        #   @return [::Google::Cloud::Dlp::V2::FileStoreDataProfile]
        #     If `DetailLevel` is `FILE_STORE_PROFILE` this will be fully populated.
        #     Otherwise, if `DetailLevel` is `RESOURCE_NAME`, then only `name` and
        #     `file_store_path` will be populated.
        # @!attribute [rw] event
        #   @return [::Google::Cloud::Dlp::V2::DataProfileAction::EventType]
        #     The event that caused the Pub/Sub message to be sent.
        class DataProfilePubSubMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CreateConnection.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Parent resource name.
        #
        #     The format of this value varies depending on the scope of the request
        #     (project or organization):
        #
        #     + Projects scope:
        #       `projects/{project_id}/locations/{location_id}`
        #     + Organizations scope:
        #       `organizations/{org_id}/locations/{location_id}`
        # @!attribute [rw] connection
        #   @return [::Google::Cloud::Dlp::V2::Connection]
        #     Required. The connection resource.
        class CreateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetConnection.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name in the format:
        #     `projects/{project}/locations/{location}/connections/{connection}`.
        class GetConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for ListConnections.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the organization or project, for
        #     example, `organizations/433245324/locations/europe` or
        #     `projects/project-id/locations/asia`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Number of results per page, max 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token from a previous page to return the next set of
        #     results. If set, all other request fields must match the original request.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Supported field/value: `state` - MISSING|AVAILABLE|ERROR
        #
        #     The syntax is based on https://google.aip.dev/160.
        class ListConnectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for SearchConnections.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Resource name of the organization or project with a wildcard
        #     location, for example, `organizations/433245324/locations/-` or
        #     `projects/project-id/locations/-`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Number of results per page, max 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token from a previous page to return the next set of
        #     results. If set, all other request fields must match the original request.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Supported field/value: - `state` - MISSING|AVAILABLE|ERROR
        #
        #     The syntax is based on https://google.aip.dev/160.
        class SearchConnectionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for ListConnections.
        # @!attribute [rw] connections
        #   @return [::Array<::Google::Cloud::Dlp::V2::Connection>]
        #     List of connections.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. An empty value means there are
        #     no more results.
        class ListConnectionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response message for SearchConnections.
        # @!attribute [rw] connections
        #   @return [::Array<::Google::Cloud::Dlp::V2::Connection>]
        #     List of connections that match the search query. Note that only a subset
        #     of the fields will be populated, and only "name" is guaranteed to be set.
        #     For full details of a Connection, call GetConnection with the name.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results. An empty value means there are
        #     no more results.
        class SearchConnectionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for UpdateConnection.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name in the format:
        #     `projects/{project}/locations/{location}/connections/{connection}`.
        # @!attribute [rw] connection
        #   @return [::Google::Cloud::Dlp::V2::Connection]
        #     Required. The connection with new values for the relevant fields.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Mask to control which fields get updated.
        class UpdateConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteConnection.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the Connection to be deleted, in the format:
        #     `projects/{project}/locations/{location}/connections/{connection}`.
        class DeleteConnectionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A data connection to allow the DLP API to profile data in locations that
        # require additional configuration.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the connection:
        #     `projects/{project}/locations/{location}/connections/{name}`.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Dlp::V2::ConnectionState]
        #     Required. The connection's state in its lifecycle.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Cloud::Dlp::V2::Error>]
        #     Output only. Set if status == ERROR, to provide additional details. Will
        #     store the last 10 errors sorted with the most recent first.
        # @!attribute [rw] cloud_sql
        #   @return [::Google::Cloud::Dlp::V2::CloudSqlProperties]
        #     Connect to a Cloud SQL instance.
        class Connection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A credential consisting of a username and password, where the password is
        # stored in a Secret Manager resource.
        # Note: Secret Manager [charges
        # apply](https://cloud.google.com/secret-manager/pricing).
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. The username.
        # @!attribute [rw] password_secret_version_name
        #   @return [::String]
        #     Required. The name of the Secret Manager resource that stores the password,
        #     in the form `projects/project-id/secrets/secret-name/versions/version`.
        class SecretManagerCredential
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Use IAM authentication to connect. This requires the Cloud SQL IAM feature
        # to be enabled on the instance, which is not the default for Cloud SQL.
        # See https://cloud.google.com/sql/docs/postgres/authentication and
        # https://cloud.google.com/sql/docs/mysql/authentication.
        class CloudSqlIamCredential
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cloud SQL connection properties.
        # @!attribute [rw] connection_name
        #   @return [::String]
        #     Optional. Immutable. The Cloud SQL instance for which the connection is
        #     defined. Only one connection per instance is allowed. This can only be set
        #     at creation time, and cannot be updated.
        #
        #     It is an error to use a connection_name from different project or region
        #     than the one that holds the connection.
        #     For example, a Connection resource for Cloud SQL connection_name
        #     `project-id:us-central1:sql-instance`
        #     must be created under the parent
        #     `projects/project-id/locations/us-central1`
        # @!attribute [rw] username_password
        #   @return [::Google::Cloud::Dlp::V2::SecretManagerCredential]
        #     A username and password stored in Secret Manager.
        #
        #     Note: The following fields are mutually exclusive: `username_password`, `cloud_sql_iam`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_sql_iam
        #   @return [::Google::Cloud::Dlp::V2::CloudSqlIamCredential]
        #     Built-in IAM authentication (must be configured in Cloud SQL).
        #
        #     Note: The following fields are mutually exclusive: `cloud_sql_iam`, `username_password`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] max_connections
        #   @return [::Integer]
        #     Required. The DLP API will limit its connections to max_connections.
        #     Must be 2 or greater.
        # @!attribute [rw] database_engine
        #   @return [::Google::Cloud::Dlp::V2::CloudSqlProperties::DatabaseEngine]
        #     Required. The database engine used by the Cloud SQL instance that this
        #     connection configures.
        class CloudSqlProperties
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Database engine of a Cloud SQL instance.
          # New values may be added over time.
          module DatabaseEngine
            # An engine that is not currently supported by Sensitive Data Protection.
            DATABASE_ENGINE_UNKNOWN = 0

            # Cloud SQL for MySQL instance.
            DATABASE_ENGINE_MYSQL = 1

            # Cloud SQL for PostgreSQL instance.
            DATABASE_ENGINE_POSTGRES = 2
          end
        end

        # Request message for DeleteTableProfile.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Resource name of the table data profile.
        class DeleteTableDataProfileRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message used to identify the type of resource being profiled.
        # @!attribute [rw] data_source
        #   @return [::String]
        #     A string that identifies the type of resource being profiled.
        #     Current values:
        #
        #     * google/bigquery/table
        #     * google/project
        #     * google/sql/table
        #     * google/gcs/bucket
        class DataSourceType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Message used to identify file cluster type being profiled.
        # @!attribute [rw] cluster
        #   @return [::Google::Cloud::Dlp::V2::FileClusterType::Cluster]
        #     Cluster type.
        class FileClusterType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Cluster type. Each cluster corresponds to a set of file types.
          # Over time, new types may be added and files may move between clusters.
          module Cluster
            # Unused.
            CLUSTER_UNSPECIFIED = 0

            # Unsupported files.
            CLUSTER_UNKNOWN = 1

            # Plain text.
            CLUSTER_TEXT = 2

            # Structured data like CSV, TSV etc.
            CLUSTER_STRUCTURED_DATA = 3

            # Source code.
            CLUSTER_SOURCE_CODE = 4

            # Rich document like docx, xlsx etc.
            CLUSTER_RICH_DOCUMENT = 5

            # Images like jpeg, bmp.
            CLUSTER_IMAGE = 6

            # Archives and containers like .zip, .tar etc.
            CLUSTER_ARCHIVE = 7

            # Multimedia like .mp4, .avi etc.
            CLUSTER_MULTIMEDIA = 8

            # Executable files like .exe, .class, .apk etc.
            CLUSTER_EXECUTABLE = 9

            # AI models like .tflite etc.
            CLUSTER_AI_MODEL = 10
          end
        end

        # Configure processing location for discovery and inspection. For example,
        # image OCR is only provided in limited regions but configuring
        # ProcessingLocation will redirect OCR to a location where OCR is provided.
        # @!attribute [rw] image_fallback_location
        #   @return [::Google::Cloud::Dlp::V2::ProcessingLocation::ImageFallbackLocation]
        #     Image processing falls back using this configuration.
        # @!attribute [rw] document_fallback_location
        #   @return [::Google::Cloud::Dlp::V2::ProcessingLocation::DocumentFallbackLocation]
        #     Document processing falls back using this configuration.
        class ProcessingLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Processing occurs in a multi-region that contains the current region
          # if available.
          class MultiRegionProcessing
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Processing occurs in the global region.
          class GlobalProcessing
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configure image processing to fall back to any of the following processing
          # options if image processing is unavailable in the original request
          # location.
          # @!attribute [rw] multi_region_processing
          #   @return [::Google::Cloud::Dlp::V2::ProcessingLocation::MultiRegionProcessing]
          #     Processing occurs in a multi-region that contains the current region
          #     if available.
          # @!attribute [rw] global_processing
          #   @return [::Google::Cloud::Dlp::V2::ProcessingLocation::GlobalProcessing]
          #     Processing occurs in the global region.
          class ImageFallbackLocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configure document processing to fall back to any of the following
          # processing options if document processing is unavailable in the original
          # request location.
          # @!attribute [rw] multi_region_processing
          #   @return [::Google::Cloud::Dlp::V2::ProcessingLocation::MultiRegionProcessing]
          #     Processing occurs in a multi-region that contains the current region
          #     if available.
          # @!attribute [rw] global_processing
          #   @return [::Google::Cloud::Dlp::V2::ProcessingLocation::GlobalProcessing]
          #     Processing occurs in the global region.
          class DocumentFallbackLocation
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Collection of findings saved to a Cloud Storage bucket. This is used as the
        # proto schema for textproto files created when specifying a cloud storage
        # path to save Inspect findings.
        # @!attribute [rw] findings
        #   @return [::Array<::Google::Cloud::Dlp::V2::Finding>]
        #     List of findings.
        class SaveToGcsFindingsOutput
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A domain represents a thematic category that a data profile can fall under.
        # @!attribute [rw] category
        #   @return [::Google::Cloud::Dlp::V2::Domain::Category]
        #     A domain category that this profile is related to.
        # @!attribute [rw] signals
        #   @return [::Array<::Google::Cloud::Dlp::V2::Domain::Signal>]
        #     The collection of signals that influenced selection of the category.
        class Domain
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # This enum defines the various domain categories a data profile can fall
          # under.
          module Category
            # Category unspecified.
            CATEGORY_UNSPECIFIED = 0

            # Indicates that the data profile is related to artificial intelligence.
            # When set, all findings stored to Security Command Center will set the
            # corresponding AI domain field of `Finding` objects.
            AI = 1

            # Indicates that the data profile is related to code.
            CODE = 2
          end

          # The signal used to determine the category.
          # This list may increase over time.
          module Signal
            # Unused.
            SIGNAL_UNSPECIFIED = 0

            # One or more machine learning models are present.
            MODEL = 1

            # A table appears to be a text embedding.
            TEXT_EMBEDDING = 2

            # The [Cloud SQL Vertex
            # AI](https://cloud.google.com/sql/docs/postgres/integrate-cloud-sql-with-vertex-ai)
            # plugin is installed on the database.
            VERTEX_PLUGIN = 3

            # Support for [Cloud SQL vector
            # embeddings](https://cloud.google.com/sql/docs/mysql/enable-vector-search)
            # is enabled on the database.
            VECTOR_PLUGIN = 4

            # Source code is present.
            SOURCE_CODE = 5

            # If the service determines the category type. For example, Vertex AI
            # assets would always have a `Category` of `AI`.
            SERVICE = 6
          end
        end

        # Enum of possible outcomes of transformations. SUCCESS if transformation and
        # storing of transformation was successful, otherwise, reason for not
        # transforming.
        module TransformationResultStatusType
          # Unused.
          STATE_TYPE_UNSPECIFIED = 0

          # This will be set when a finding could not be transformed (i.e. outside user
          # set bucket range).
          INVALID_TRANSFORM = 1

          # This will be set when a BigQuery transformation was successful but could
          # not be stored back in BigQuery because the transformed row exceeds
          # BigQuery's max row size.
          BIGQUERY_MAX_ROW_SIZE_EXCEEDED = 2

          # This will be set when there is a finding in the custom metadata of a file,
          # but at the write time of the transformed file, this key / value pair is
          # unretrievable.
          METADATA_UNRETRIEVABLE = 3

          # This will be set when the transformation and storing of it is successful.
          SUCCESS = 4
        end

        # Describes functionality of a given container in its original format.
        module TransformationContainerType
          # Unused.
          TRANSFORM_UNKNOWN_CONTAINER = 0

          # Body of a file.
          TRANSFORM_BODY = 1

          # Metadata for a file.
          TRANSFORM_METADATA = 2

          # A table.
          TRANSFORM_TABLE = 3
        end

        # An enum of rules that can be used to transform a value. Can be a
        # record suppression, or one of the transformation rules specified under
        # `PrimitiveTransformation`.
        module TransformationType
          # Unused
          TRANSFORMATION_TYPE_UNSPECIFIED = 0

          # Record suppression
          RECORD_SUPPRESSION = 1

          # Replace value
          REPLACE_VALUE = 2

          # Replace value using a dictionary.
          REPLACE_DICTIONARY = 15

          # Redact
          REDACT = 3

          # Character mask
          CHARACTER_MASK = 4

          # FFX-FPE
          CRYPTO_REPLACE_FFX_FPE = 5

          # Fixed size bucketing
          FIXED_SIZE_BUCKETING = 6

          # Bucketing
          BUCKETING = 7

          # Replace with info type
          REPLACE_WITH_INFO_TYPE = 8

          # Time part
          TIME_PART = 9

          # Crypto hash
          CRYPTO_HASH = 10

          # Date shift
          DATE_SHIFT = 12

          # Deterministic crypto
          CRYPTO_DETERMINISTIC_CONFIG = 13

          # Redact image
          REDACT_IMAGE = 14
        end

        # Whether a profile being created is the first generation or an update.
        module ProfileGeneration
          # Unused.
          PROFILE_GENERATION_UNSPECIFIED = 0

          # The profile is the first profile for the resource.
          PROFILE_GENERATION_NEW = 1

          # The profile is an update to a previous profile.
          PROFILE_GENERATION_UPDATE = 2
        end

        # Over time new types may be added. Currently VIEW, MATERIALIZED_VIEW, and
        # non-BigLake external tables are not supported.
        module BigQueryTableTypeCollection
          # Unused.
          BIG_QUERY_COLLECTION_UNSPECIFIED = 0

          # Automatically generate profiles for all tables, even if the table type is
          # not yet fully supported for analysis. Profiles for unsupported tables will
          # be generated with errors to indicate their partial support. When full
          # support is added, the tables will automatically be profiled during the next
          # scheduled run.
          BIG_QUERY_COLLECTION_ALL_TYPES = 1

          # Only those types fully supported will be profiled. Will expand
          # automatically as Cloud DLP adds support for new table types. Unsupported
          # table types will not have partial profiles generated.
          BIG_QUERY_COLLECTION_ONLY_SUPPORTED_TYPES = 2
        end

        # Over time new types may be added. Currently VIEW, MATERIALIZED_VIEW, and
        # non-BigLake external tables are not supported.
        module BigQueryTableType
          # Unused.
          BIG_QUERY_TABLE_TYPE_UNSPECIFIED = 0

          # A normal BigQuery table.
          BIG_QUERY_TABLE_TYPE_TABLE = 1

          # A table that references data stored in Cloud Storage.
          BIG_QUERY_TABLE_TYPE_EXTERNAL_BIG_LAKE = 2

          # A snapshot of a BigQuery table.
          BIG_QUERY_TABLE_TYPE_SNAPSHOT = 3
        end

        # How frequently data profiles can be updated. New options can be added at a
        # later time.
        module DataProfileUpdateFrequency
          # Unspecified.
          UPDATE_FREQUENCY_UNSPECIFIED = 0

          # After the data profile is created, it will never be updated.
          UPDATE_FREQUENCY_NEVER = 1

          # The data profile can be updated up to once every 24 hours.
          UPDATE_FREQUENCY_DAILY = 2

          # The data profile can be updated up to once every 30 days. Default.
          UPDATE_FREQUENCY_MONTHLY = 4
        end

        # Attributes evaluated to determine if a table has been modified. New values
        # may be added at a later time.
        module BigQueryTableModification
          # Unused.
          TABLE_MODIFICATION_UNSPECIFIED = 0

          # A table will be considered modified when the last_modified_time from
          # BigQuery has been updated.
          TABLE_MODIFIED_TIMESTAMP = 1
        end

        # Attributes evaluated to determine if a schema has been modified. New values
        # may be added at a later time.
        module BigQuerySchemaModification
          # Unused
          SCHEMA_MODIFICATION_UNSPECIFIED = 0

          # Profiles should be regenerated when new columns are added to the table.
          # Default.
          SCHEMA_NEW_COLUMNS = 1

          # Profiles should be regenerated when columns are removed from the table.
          SCHEMA_REMOVED_COLUMNS = 2
        end

        # Operators available for comparing the value of fields.
        module RelationalOperator
          # Unused
          RELATIONAL_OPERATOR_UNSPECIFIED = 0

          # Equal. Attempts to match even with incompatible types.
          EQUAL_TO = 1

          # Not equal to. Attempts to match even with incompatible types.
          NOT_EQUAL_TO = 2

          # Greater than.
          GREATER_THAN = 3

          # Less than.
          LESS_THAN = 4

          # Greater than or equals.
          GREATER_THAN_OR_EQUALS = 5

          # Less than or equals.
          LESS_THAN_OR_EQUALS = 6

          # Exists
          EXISTS = 7
        end

        # Type of the match which can be applied to different ways of matching, like
        # Dictionary, regular expression and intersecting with findings of another
        # infoType.
        module MatchingType
          # Invalid.
          MATCHING_TYPE_UNSPECIFIED = 0

          # Full match.
          #
          # - Dictionary: join of Dictionary results matched the complete finding quote
          # - Regex: all regex matches fill a finding quote from start to end
          # - Exclude infoType: completely inside affecting infoTypes findings
          MATCHING_TYPE_FULL_MATCH = 1

          # Partial match.
          #
          # - Dictionary: at least one of the tokens in the finding matches
          # - Regex: substring of the finding matches
          # - Exclude infoType: intersects with affecting infoTypes findings
          MATCHING_TYPE_PARTIAL_MATCH = 2

          # Inverse match.
          #
          # - Dictionary: no tokens in the finding match the dictionary
          # - Regex: finding doesn't match the regex
          # - Exclude infoType: no intersection with affecting infoTypes findings
          MATCHING_TYPE_INVERSE_MATCH = 3
        end

        # Deprecated and unused.
        module ContentOption
          # Includes entire content of a file or a data stream.
          CONTENT_UNSPECIFIED = 0

          # Text content within the data, excluding any metadata.
          CONTENT_TEXT = 1

          # Images found in the data.
          CONTENT_IMAGE = 2
        end

        # Type of metadata containing the finding.
        module MetadataType
          # Unused
          METADATATYPE_UNSPECIFIED = 0

          # General file metadata provided by Cloud Storage.
          STORAGE_METADATA = 2
        end

        # Parts of the APIs which use certain infoTypes.
        module InfoTypeSupportedBy
          # Unused.
          ENUM_TYPE_UNSPECIFIED = 0

          # Supported by the inspect operations.
          INSPECT = 1

          # Supported by the risk analysis operations.
          RISK_ANALYSIS = 2
        end

        # An enum to represent the various types of DLP jobs.
        module DlpJobType
          # Defaults to INSPECT_JOB.
          DLP_JOB_TYPE_UNSPECIFIED = 0

          # The job inspected Google Cloud for sensitive data.
          INSPECT_JOB = 1

          # The job executed a Risk Analysis computation.
          RISK_ANALYSIS_JOB = 2
        end

        # State of a StoredInfoType version.
        module StoredInfoTypeState
          # Unused
          STORED_INFO_TYPE_STATE_UNSPECIFIED = 0

          # StoredInfoType version is being created.
          PENDING = 1

          # StoredInfoType version is ready for use.
          READY = 2

          # StoredInfoType creation failed. All relevant error messages are returned in
          # the `StoredInfoTypeVersion` message.
          FAILED = 3

          # StoredInfoType is no longer valid because artifacts stored in
          # user-controlled storage were modified. To fix an invalid StoredInfoType,
          # use the `UpdateStoredInfoType` method to create a new version.
          INVALID = 4
        end

        # How broadly the data in the resource has been shared. New items may be added
        # over time. A higher number means more restricted.
        module ResourceVisibility
          # Unused.
          RESOURCE_VISIBILITY_UNSPECIFIED = 0

          # Visible to any user.
          RESOURCE_VISIBILITY_PUBLIC = 10

          # May contain public items.
          # For example, if a Cloud Storage bucket has uniform bucket level access
          # disabled, some objects inside it may be public, but none are known yet.
          RESOURCE_VISIBILITY_INCONCLUSIVE = 15

          # Visible only to specific users.
          RESOURCE_VISIBILITY_RESTRICTED = 20
        end

        # How a resource is encrypted.
        module EncryptionStatus
          # Unused.
          ENCRYPTION_STATUS_UNSPECIFIED = 0

          # Google manages server-side encryption keys on your behalf.
          ENCRYPTION_GOOGLE_MANAGED = 1

          # Customer provides the key.
          ENCRYPTION_CUSTOMER_MANAGED = 2
        end

        # Bucketized nullness percentage levels. A higher level means a higher
        # percentage of the column is null.
        module NullPercentageLevel
          # Unused.
          NULL_PERCENTAGE_LEVEL_UNSPECIFIED = 0

          # Very few null entries.
          NULL_PERCENTAGE_VERY_LOW = 1

          # Some null entries.
          NULL_PERCENTAGE_LOW = 2

          # A few null entries.
          NULL_PERCENTAGE_MEDIUM = 3

          # A lot of null entries.
          NULL_PERCENTAGE_HIGH = 4
        end

        # Bucketized uniqueness score levels. A higher uniqueness score is a strong
        # signal that the column may contain a unique identifier like user id. A low
        # value indicates that the column contains few unique values like booleans or
        # other classifiers.
        module UniquenessScoreLevel
          # Some columns do not have estimated uniqueness. Possible reasons include
          # having too few values.
          UNIQUENESS_SCORE_LEVEL_UNSPECIFIED = 0

          # Low uniqueness, possibly a boolean, enum or similiarly typed column.
          UNIQUENESS_SCORE_LOW = 1

          # Medium uniqueness.
          UNIQUENESS_SCORE_MEDIUM = 2

          # High uniqueness, possibly a column of free text or unique identifiers.
          UNIQUENESS_SCORE_HIGH = 3
        end

        # State of the connection.
        # New values may be added over time.
        module ConnectionState
          # Unused
          CONNECTION_STATE_UNSPECIFIED = 0

          # The DLP API automatically created this connection during an initial scan,
          # and it is awaiting full configuration by a user.
          MISSING_CREDENTIALS = 1

          # A configured connection that has not encountered any errors.
          AVAILABLE = 2

          # A configured connection that encountered errors during its last use. It
          # will not be used again until it is set to AVAILABLE.
          #
          # If the resolution requires external action, then the client must send a
          # request to set the status to AVAILABLE when the connection is ready for
          # use. If the resolution doesn't require external action, then any changes to
          # the connection properties will automatically mark it as AVAILABLE.
          ERROR = 3
        end
      end
    end
  end
end
