# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/privacy/dlp/v2/dlp_pb"
require "google/cloud/dlp/v2/dlp_service/rest/service_stub"
require "google/cloud/location/rest"

module Google
  module Cloud
    module Dlp
      module V2
        module DlpService
          module Rest
            ##
            # REST client for the DlpService service.
            #
            # Sensitive Data Protection provides access to a powerful sensitive data
            # inspection, classification, and de-identification platform that works
            # on text, images, and Google Cloud storage repositories.
            # To learn more about concepts and find how-to guides see
            # https://cloud.google.com/sensitive-data-protection/docs/.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dlp.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :dlp_service_stub

              ##
              # Configure the DlpService Client class.
              #
              # See {::Google::Cloud::Dlp::V2::DlpService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DlpService clients
              #   ::Google::Cloud::Dlp::V2::DlpService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dlp", "V2"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.inspect_content.timeout = 300.0
                  default_config.rpcs.inspect_content.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.redact_image.timeout = 300.0
                  default_config.rpcs.redact_image.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.deidentify_content.timeout = 300.0
                  default_config.rpcs.deidentify_content.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.reidentify_content.timeout = 300.0
                  default_config.rpcs.reidentify_content.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_info_types.timeout = 300.0
                  default_config.rpcs.list_info_types.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.create_inspect_template.timeout = 300.0

                  default_config.rpcs.update_inspect_template.timeout = 300.0

                  default_config.rpcs.get_inspect_template.timeout = 300.0
                  default_config.rpcs.get_inspect_template.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_inspect_templates.timeout = 300.0
                  default_config.rpcs.list_inspect_templates.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_inspect_template.timeout = 300.0
                  default_config.rpcs.delete_inspect_template.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.create_deidentify_template.timeout = 300.0

                  default_config.rpcs.update_deidentify_template.timeout = 300.0

                  default_config.rpcs.get_deidentify_template.timeout = 300.0
                  default_config.rpcs.get_deidentify_template.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_deidentify_templates.timeout = 300.0
                  default_config.rpcs.list_deidentify_templates.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_deidentify_template.timeout = 300.0
                  default_config.rpcs.delete_deidentify_template.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.create_job_trigger.timeout = 300.0

                  default_config.rpcs.update_job_trigger.timeout = 300.0

                  default_config.rpcs.hybrid_inspect_job_trigger.timeout = 300.0

                  default_config.rpcs.get_job_trigger.timeout = 300.0
                  default_config.rpcs.get_job_trigger.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_job_triggers.timeout = 300.0
                  default_config.rpcs.list_job_triggers.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_job_trigger.timeout = 300.0
                  default_config.rpcs.delete_job_trigger.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.activate_job_trigger.timeout = 300.0

                  default_config.rpcs.create_discovery_config.timeout = 300.0

                  default_config.rpcs.update_discovery_config.timeout = 300.0

                  default_config.rpcs.get_discovery_config.timeout = 300.0
                  default_config.rpcs.get_discovery_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_discovery_configs.timeout = 300.0
                  default_config.rpcs.list_discovery_configs.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_discovery_config.timeout = 300.0
                  default_config.rpcs.delete_discovery_config.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.create_dlp_job.timeout = 300.0

                  default_config.rpcs.list_dlp_jobs.timeout = 300.0
                  default_config.rpcs.list_dlp_jobs.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_dlp_job.timeout = 300.0
                  default_config.rpcs.get_dlp_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_dlp_job.timeout = 300.0
                  default_config.rpcs.delete_dlp_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.cancel_dlp_job.timeout = 300.0

                  default_config.rpcs.create_stored_info_type.timeout = 300.0

                  default_config.rpcs.update_stored_info_type.timeout = 300.0

                  default_config.rpcs.get_stored_info_type.timeout = 300.0
                  default_config.rpcs.get_stored_info_type.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_stored_info_types.timeout = 300.0
                  default_config.rpcs.list_stored_info_types.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_stored_info_type.timeout = 300.0
                  default_config.rpcs.delete_stored_info_type.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_project_data_profiles.timeout = 300.0
                  default_config.rpcs.list_project_data_profiles.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_table_data_profiles.timeout = 300.0
                  default_config.rpcs.list_table_data_profiles.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_column_data_profiles.timeout = 300.0
                  default_config.rpcs.list_column_data_profiles.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_project_data_profile.timeout = 300.0
                  default_config.rpcs.get_project_data_profile.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.list_file_store_data_profiles.timeout = 300.0
                  default_config.rpcs.list_file_store_data_profiles.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_file_store_data_profile.timeout = 300.0
                  default_config.rpcs.get_file_store_data_profile.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.delete_file_store_data_profile.timeout = 300.0
                  default_config.rpcs.delete_file_store_data_profile.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_table_data_profile.timeout = 300.0
                  default_config.rpcs.get_table_data_profile.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.get_column_data_profile.timeout = 300.0
                  default_config.rpcs.get_column_data_profile.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                  }

                  default_config.rpcs.hybrid_inspect_dlp_job.timeout = 300.0

                  default_config.rpcs.finish_dlp_job.timeout = 300.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DlpService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dlp::V2::DlpService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @dlp_service_stub.universe_domain
              end

              ##
              # Create a new DlpService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dlp::V2::DlpService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DlpService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @dlp_service_stub = ::Google::Cloud::Dlp::V2::DlpService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @dlp_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dlp_service_stub.endpoint
                  config.universe_domain = @dlp_service_stub.universe_domain
                  config.logger = @dlp_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @dlp_service_stub.logger
              end

              # Service calls

              ##
              # Finds potentially sensitive info in content.
              # This method has limits on input size, processing time, and output size.
              #
              # When no InfoTypes or CustomInfoTypes are specified in this request, the
              # system will automatically choose what detectors to run. By default this may
              # be all types, but may change over time as detectors are updated.
              #
              # For how to guides, see
              # https://cloud.google.com/sensitive-data-protection/docs/inspecting-images
              # and
              # https://cloud.google.com/sensitive-data-protection/docs/inspecting-text,
              #
              # @overload inspect_content(request, options = nil)
              #   Pass arguments to `inspect_content` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::InspectContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::InspectContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload inspect_content(parent: nil, inspect_config: nil, item: nil, inspect_template_name: nil, location_id: nil)
              #   Pass arguments to `inspect_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Parent resource name.
              #
              #     The format of this value varies depending on whether you have [specified a
              #     processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param inspect_config [::Google::Cloud::Dlp::V2::InspectConfig, ::Hash]
              #     Configuration for the inspector. What specified here will override
              #     the template referenced by the inspect_template_name argument.
              #   @param item [::Google::Cloud::Dlp::V2::ContentItem, ::Hash]
              #     The item to inspect.
              #   @param inspect_template_name [::String]
              #     Template to use. Any configuration directly specified in
              #     inspect_config will override those set in the template. Singular fields
              #     that are set in this request will replace their corresponding fields in the
              #     template. Repeated fields are appended. Singular sub-messages and groups
              #     are recursively merged.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::InspectContentResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::InspectContentResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::InspectContentRequest.new
              #
              #   # Call the inspect_content method.
              #   result = client.inspect_content request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::InspectContentResponse.
              #   p result
              #
              def inspect_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::InspectContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.inspect_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.inspect_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.inspect_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.inspect_content request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Redacts potentially sensitive info from an image.
              # This method has limits on input size, processing time, and output size.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/redacting-sensitive-data-images
              # to learn more.
              #
              # When no InfoTypes or CustomInfoTypes are specified in this request, the
              # system will automatically choose what detectors to run. By default this may
              # be all types, but may change over time as detectors are updated.
              #
              # Only the first frame of each multiframe image is redacted. Metadata and
              # other frames are omitted in the response.
              #
              # @overload redact_image(request, options = nil)
              #   Pass arguments to `redact_image` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::RedactImageRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::RedactImageRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload redact_image(parent: nil, location_id: nil, inspect_config: nil, image_redaction_configs: nil, include_findings: nil, byte_item: nil, inspect_template: nil, deidentify_template: nil)
              #   Pass arguments to `redact_image` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Parent resource name.
              #
              #     The format of this value varies depending on whether you have [specified a
              #     processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              #   @param inspect_config [::Google::Cloud::Dlp::V2::InspectConfig, ::Hash]
              #     Configuration for the inspector.
              #   @param image_redaction_configs [::Array<::Google::Cloud::Dlp::V2::RedactImageRequest::ImageRedactionConfig, ::Hash>]
              #     The configuration for specifying what content to redact from images.
              #   @param include_findings [::Boolean]
              #     Whether the response should include findings along with the redacted
              #     image.
              #   @param byte_item [::Google::Cloud::Dlp::V2::ByteContentItem, ::Hash]
              #     The content must be PNG, JPEG, SVG or BMP.
              #   @param inspect_template [::String]
              #     The full resource name of the inspection template to use. Settings in the
              #     main `inspect_config` field override the corresponding settings in this
              #     inspection template.
              #
              #     The merge behavior is as follows:
              #
              #       - Singular field: The main field's value replaces the value of the
              #       corresponding field in the template.
              #       - Repeated fields: The field values are appended to the list defined in
              #       the template.
              #       - Sub-messages and groups: The fields are recursively merged.
              #   @param deidentify_template [::String]
              #     The full resource name of the de-identification template to use. Settings
              #     in the main `image_redaction_configs` field override the corresponding
              #     settings in this de-identification template. The request fails if the
              #     type of the template's deidentify_config is not image_transformations.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::RedactImageResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::RedactImageResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::RedactImageRequest.new
              #
              #   # Call the redact_image method.
              #   result = client.redact_image request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::RedactImageResponse.
              #   p result
              #
              def redact_image request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::RedactImageRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.redact_image.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.redact_image.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.redact_image.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.redact_image request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # De-identifies potentially sensitive info from a ContentItem.
              # This method has limits on input size and output size.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/deidentify-sensitive-data
              # to learn more.
              #
              # When no InfoTypes or CustomInfoTypes are specified in this request, the
              # system will automatically choose what detectors to run. By default this may
              # be all types, but may change over time as detectors are updated.
              #
              # @overload deidentify_content(request, options = nil)
              #   Pass arguments to `deidentify_content` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeidentifyContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeidentifyContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload deidentify_content(parent: nil, deidentify_config: nil, inspect_config: nil, item: nil, inspect_template_name: nil, deidentify_template_name: nil, location_id: nil)
              #   Pass arguments to `deidentify_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Parent resource name.
              #
              #     The format of this value varies depending on whether you have [specified a
              #     processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param deidentify_config [::Google::Cloud::Dlp::V2::DeidentifyConfig, ::Hash]
              #     Configuration for the de-identification of the content item.
              #     Items specified here will override the template referenced by the
              #     deidentify_template_name argument.
              #   @param inspect_config [::Google::Cloud::Dlp::V2::InspectConfig, ::Hash]
              #     Configuration for the inspector.
              #     Items specified here will override the template referenced by the
              #     inspect_template_name argument.
              #   @param item [::Google::Cloud::Dlp::V2::ContentItem, ::Hash]
              #     The item to de-identify. Will be treated as text.
              #
              #     This value must be of type
              #     {::Google::Cloud::Dlp::V2::Table Table} if your
              #     {::Google::Cloud::Dlp::V2::DeidentifyContentRequest#deidentify_config deidentify_config}
              #     is a
              #     {::Google::Cloud::Dlp::V2::RecordTransformations RecordTransformations}
              #     object.
              #   @param inspect_template_name [::String]
              #     Template to use. Any configuration directly specified in
              #     inspect_config will override those set in the template. Singular fields
              #     that are set in this request will replace their corresponding fields in the
              #     template. Repeated fields are appended. Singular sub-messages and groups
              #     are recursively merged.
              #   @param deidentify_template_name [::String]
              #     Template to use. Any configuration directly specified in
              #     deidentify_config will override those set in the template. Singular fields
              #     that are set in this request will replace their corresponding fields in the
              #     template. Repeated fields are appended. Singular sub-messages and groups
              #     are recursively merged.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DeidentifyContentResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DeidentifyContentResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeidentifyContentRequest.new
              #
              #   # Call the deidentify_content method.
              #   result = client.deidentify_content request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DeidentifyContentResponse.
              #   p result
              #
              def deidentify_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeidentifyContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.deidentify_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.deidentify_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.deidentify_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.deidentify_content request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Re-identifies content that has been de-identified.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/pseudonymization#re-identification_in_free_text_code_example
              # to learn more.
              #
              # @overload reidentify_content(request, options = nil)
              #   Pass arguments to `reidentify_content` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ReidentifyContentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ReidentifyContentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload reidentify_content(parent: nil, reidentify_config: nil, inspect_config: nil, item: nil, inspect_template_name: nil, reidentify_template_name: nil, location_id: nil)
              #   Pass arguments to `reidentify_content` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on whether you have [specified a
              #     processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param reidentify_config [::Google::Cloud::Dlp::V2::DeidentifyConfig, ::Hash]
              #     Configuration for the re-identification of the content item.
              #     This field shares the same proto message type that is used for
              #     de-identification, however its usage here is for the reversal of the
              #     previous de-identification. Re-identification is performed by examining
              #     the transformations used to de-identify the items and executing the
              #     reverse. This requires that only reversible transformations
              #     be provided here. The reversible transformations are:
              #
              #      - `CryptoDeterministicConfig`
              #      - `CryptoReplaceFfxFpeConfig`
              #   @param inspect_config [::Google::Cloud::Dlp::V2::InspectConfig, ::Hash]
              #     Configuration for the inspector.
              #   @param item [::Google::Cloud::Dlp::V2::ContentItem, ::Hash]
              #     The item to re-identify. Will be treated as text.
              #   @param inspect_template_name [::String]
              #     Template to use. Any configuration directly specified in
              #     `inspect_config` will override those set in the template. Singular fields
              #     that are set in this request will replace their corresponding fields in the
              #     template. Repeated fields are appended. Singular sub-messages and groups
              #     are recursively merged.
              #   @param reidentify_template_name [::String]
              #     Template to use. References an instance of `DeidentifyTemplate`.
              #     Any configuration directly specified in `reidentify_config` or
              #     `inspect_config` will override those set in the template. The
              #     `DeidentifyTemplate` used must include only reversible transformations.
              #     Singular fields that are set in this request will replace their
              #     corresponding fields in the template. Repeated fields are appended.
              #     Singular sub-messages and groups are recursively merged.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::ReidentifyContentResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::ReidentifyContentResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ReidentifyContentRequest.new
              #
              #   # Call the reidentify_content method.
              #   result = client.reidentify_content request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::ReidentifyContentResponse.
              #   p result
              #
              def reidentify_content request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ReidentifyContentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.reidentify_content.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.reidentify_content.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.reidentify_content.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.reidentify_content request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Returns a list of the sensitive information types that the DLP API
              # supports. See
              # https://cloud.google.com/sensitive-data-protection/docs/infotypes-reference
              # to learn more.
              #
              # @overload list_info_types(request, options = nil)
              #   Pass arguments to `list_info_types` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListInfoTypesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListInfoTypesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_info_types(parent: nil, language_code: nil, filter: nil, location_id: nil)
              #   Pass arguments to `list_info_types` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     The parent resource name.
              #
              #     The format of this value is as follows:
              #
              #         `locations/{location_id}`
              #   @param language_code [::String]
              #     BCP-47 language code for localized infoType friendly
              #     names. If omitted, or if localized strings are not available,
              #     en-US strings will be returned.
              #   @param filter [::String]
              #     filter to only return infoTypes supported by certain parts of the
              #     API. Defaults to supported_by=INSPECT.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::ListInfoTypesResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::ListInfoTypesResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListInfoTypesRequest.new
              #
              #   # Call the list_info_types method.
              #   result = client.list_info_types request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::ListInfoTypesResponse.
              #   p result
              #
              def list_info_types request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListInfoTypesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_info_types.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_info_types.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_info_types.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_info_types request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an InspectTemplate for reusing frequently used configuration
              # for inspecting content, images, and storage.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates
              # to learn more.
              #
              # @overload create_inspect_template(request, options = nil)
              #   Pass arguments to `create_inspect_template` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::CreateInspectTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::CreateInspectTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_inspect_template(parent: nil, inspect_template: nil, template_id: nil, location_id: nil)
              #   Pass arguments to `create_inspect_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on the scope of the request
              #     (project or organization) and whether you have [specified a processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #     + Organizations scope, location specified:
              #       `organizations/{org_id}/locations/{location_id}`
              #     + Organizations scope, no location specified (defaults to global):
              #       `organizations/{org_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param inspect_template [::Google::Cloud::Dlp::V2::InspectTemplate, ::Hash]
              #     Required. The InspectTemplate to create.
              #   @param template_id [::String]
              #     The template id can contain uppercase and lowercase letters,
              #     numbers, and hyphens; that is, it must match the regular
              #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
              #     characters. Can be empty to allow the system to generate one.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::InspectTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::InspectTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::CreateInspectTemplateRequest.new
              #
              #   # Call the create_inspect_template method.
              #   result = client.create_inspect_template request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::InspectTemplate.
              #   p result
              #
              def create_inspect_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::CreateInspectTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_inspect_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_inspect_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_inspect_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.create_inspect_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the InspectTemplate.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates
              # to learn more.
              #
              # @overload update_inspect_template(request, options = nil)
              #   Pass arguments to `update_inspect_template` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::UpdateInspectTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::UpdateInspectTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_inspect_template(name: nil, inspect_template: nil, update_mask: nil)
              #   Pass arguments to `update_inspect_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of organization and inspectTemplate to be updated,
              #     for example `organizations/433245324/inspectTemplates/432452342` or
              #     projects/project-id/inspectTemplates/432452342.
              #   @param inspect_template [::Google::Cloud::Dlp::V2::InspectTemplate, ::Hash]
              #     New InspectTemplate value.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask to control which fields get updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::InspectTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::InspectTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::UpdateInspectTemplateRequest.new
              #
              #   # Call the update_inspect_template method.
              #   result = client.update_inspect_template request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::InspectTemplate.
              #   p result
              #
              def update_inspect_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::UpdateInspectTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_inspect_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_inspect_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_inspect_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.update_inspect_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets an InspectTemplate.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates
              # to learn more.
              #
              # @overload get_inspect_template(request, options = nil)
              #   Pass arguments to `get_inspect_template` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetInspectTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetInspectTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_inspect_template(name: nil)
              #   Pass arguments to `get_inspect_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the organization and inspectTemplate to be read,
              #     for example `organizations/433245324/inspectTemplates/432452342` or
              #     projects/project-id/inspectTemplates/432452342.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::InspectTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::InspectTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetInspectTemplateRequest.new
              #
              #   # Call the get_inspect_template method.
              #   result = client.get_inspect_template request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::InspectTemplate.
              #   p result
              #
              def get_inspect_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetInspectTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_inspect_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_inspect_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_inspect_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_inspect_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists InspectTemplates.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates
              # to learn more.
              #
              # @overload list_inspect_templates(request, options = nil)
              #   Pass arguments to `list_inspect_templates` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListInspectTemplatesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListInspectTemplatesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_inspect_templates(parent: nil, page_token: nil, page_size: nil, order_by: nil, location_id: nil)
              #   Pass arguments to `list_inspect_templates` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on the scope of the request
              #     (project or organization) and whether you have [specified a processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #     + Organizations scope, location specified:
              #       `organizations/{org_id}/locations/{location_id}`
              #     + Organizations scope, no location specified (defaults to global):
              #       `organizations/{org_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param page_token [::String]
              #     Page token to continue retrieval. Comes from the previous call
              #     to `ListInspectTemplates`.
              #   @param page_size [::Integer]
              #     Size of the page. This value can be limited by the server. If zero server
              #     returns a page of max size 100.
              #   @param order_by [::String]
              #     Comma-separated list of fields to order by,
              #     followed by `asc` or `desc` postfix. This list is case insensitive. The
              #     default sorting order is ascending. Redundant space characters are
              #     insignificant.
              #
              #     Example: `name asc,update_time, create_time desc`
              #
              #     Supported fields are:
              #
              #     - `create_time`: corresponds to the time the template was created.
              #     - `update_time`: corresponds to the time the template was last updated.
              #     - `name`: corresponds to the template's name.
              #     - `display_name`: corresponds to the template's display name.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::InspectTemplate>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::InspectTemplate>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListInspectTemplatesRequest.new
              #
              #   # Call the list_inspect_templates method.
              #   result = client.list_inspect_templates request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::InspectTemplate.
              #     p item
              #   end
              #
              def list_inspect_templates request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListInspectTemplatesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_inspect_templates.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_inspect_templates.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_inspect_templates.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_inspect_templates request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_inspect_templates, "inspect_templates", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an InspectTemplate.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates
              # to learn more.
              #
              # @overload delete_inspect_template(request, options = nil)
              #   Pass arguments to `delete_inspect_template` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteInspectTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteInspectTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_inspect_template(name: nil)
              #   Pass arguments to `delete_inspect_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the organization and inspectTemplate to be
              #     deleted, for example `organizations/433245324/inspectTemplates/432452342`
              #     or projects/project-id/inspectTemplates/432452342.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteInspectTemplateRequest.new
              #
              #   # Call the delete_inspect_template method.
              #   result = client.delete_inspect_template request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_inspect_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteInspectTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_inspect_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_inspect_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_inspect_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_inspect_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a DeidentifyTemplate for reusing frequently used configuration
              # for de-identifying content, images, and storage.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
              # to learn more.
              #
              # @overload create_deidentify_template(request, options = nil)
              #   Pass arguments to `create_deidentify_template` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::CreateDeidentifyTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::CreateDeidentifyTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_deidentify_template(parent: nil, deidentify_template: nil, template_id: nil, location_id: nil)
              #   Pass arguments to `create_deidentify_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on the scope of the request
              #     (project or organization) and whether you have [specified a processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #     + Organizations scope, location specified:
              #       `organizations/{org_id}/locations/{location_id}`
              #     + Organizations scope, no location specified (defaults to global):
              #       `organizations/{org_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param deidentify_template [::Google::Cloud::Dlp::V2::DeidentifyTemplate, ::Hash]
              #     Required. The DeidentifyTemplate to create.
              #   @param template_id [::String]
              #     The template id can contain uppercase and lowercase letters,
              #     numbers, and hyphens; that is, it must match the regular
              #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
              #     characters. Can be empty to allow the system to generate one.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::CreateDeidentifyTemplateRequest.new
              #
              #   # Call the create_deidentify_template method.
              #   result = client.create_deidentify_template request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DeidentifyTemplate.
              #   p result
              #
              def create_deidentify_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::CreateDeidentifyTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_deidentify_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_deidentify_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_deidentify_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.create_deidentify_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the DeidentifyTemplate.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
              # to learn more.
              #
              # @overload update_deidentify_template(request, options = nil)
              #   Pass arguments to `update_deidentify_template` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::UpdateDeidentifyTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::UpdateDeidentifyTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_deidentify_template(name: nil, deidentify_template: nil, update_mask: nil)
              #   Pass arguments to `update_deidentify_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of organization and deidentify template to be
              #     updated, for example
              #     `organizations/433245324/deidentifyTemplates/432452342` or
              #     projects/project-id/deidentifyTemplates/432452342.
              #   @param deidentify_template [::Google::Cloud::Dlp::V2::DeidentifyTemplate, ::Hash]
              #     New DeidentifyTemplate value.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask to control which fields get updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::UpdateDeidentifyTemplateRequest.new
              #
              #   # Call the update_deidentify_template method.
              #   result = client.update_deidentify_template request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DeidentifyTemplate.
              #   p result
              #
              def update_deidentify_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::UpdateDeidentifyTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_deidentify_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_deidentify_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_deidentify_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.update_deidentify_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a DeidentifyTemplate.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
              # to learn more.
              #
              # @overload get_deidentify_template(request, options = nil)
              #   Pass arguments to `get_deidentify_template` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetDeidentifyTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetDeidentifyTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_deidentify_template(name: nil)
              #   Pass arguments to `get_deidentify_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the organization and deidentify template to be
              #     read, for example `organizations/433245324/deidentifyTemplates/432452342`
              #     or projects/project-id/deidentifyTemplates/432452342.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DeidentifyTemplate]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetDeidentifyTemplateRequest.new
              #
              #   # Call the get_deidentify_template method.
              #   result = client.get_deidentify_template request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DeidentifyTemplate.
              #   p result
              #
              def get_deidentify_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetDeidentifyTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_deidentify_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_deidentify_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_deidentify_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_deidentify_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DeidentifyTemplates.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
              # to learn more.
              #
              # @overload list_deidentify_templates(request, options = nil)
              #   Pass arguments to `list_deidentify_templates` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListDeidentifyTemplatesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListDeidentifyTemplatesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_deidentify_templates(parent: nil, page_token: nil, page_size: nil, order_by: nil, location_id: nil)
              #   Pass arguments to `list_deidentify_templates` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on the scope of the request
              #     (project or organization) and whether you have [specified a processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #     + Organizations scope, location specified:
              #       `organizations/{org_id}/locations/{location_id}`
              #     + Organizations scope, no location specified (defaults to global):
              #       `organizations/{org_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param page_token [::String]
              #     Page token to continue retrieval. Comes from the previous call
              #     to `ListDeidentifyTemplates`.
              #   @param page_size [::Integer]
              #     Size of the page. This value can be limited by the server. If zero server
              #     returns a page of max size 100.
              #   @param order_by [::String]
              #     Comma-separated list of fields to order by,
              #     followed by `asc` or `desc` postfix. This list is case insensitive. The
              #     default sorting order is ascending. Redundant space characters are
              #     insignificant.
              #
              #     Example: `name asc,update_time, create_time desc`
              #
              #     Supported fields are:
              #
              #     - `create_time`: corresponds to the time the template was created.
              #     - `update_time`: corresponds to the time the template was last updated.
              #     - `name`: corresponds to the template's name.
              #     - `display_name`: corresponds to the template's display name.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::DeidentifyTemplate>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::DeidentifyTemplate>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListDeidentifyTemplatesRequest.new
              #
              #   # Call the list_deidentify_templates method.
              #   result = client.list_deidentify_templates request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::DeidentifyTemplate.
              #     p item
              #   end
              #
              def list_deidentify_templates request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListDeidentifyTemplatesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_deidentify_templates.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_deidentify_templates.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_deidentify_templates.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_deidentify_templates request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_deidentify_templates, "deidentify_templates", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a DeidentifyTemplate.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-templates-deid
              # to learn more.
              #
              # @overload delete_deidentify_template(request, options = nil)
              #   Pass arguments to `delete_deidentify_template` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteDeidentifyTemplateRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteDeidentifyTemplateRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_deidentify_template(name: nil)
              #   Pass arguments to `delete_deidentify_template` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the organization and deidentify template to be
              #     deleted, for example
              #     `organizations/433245324/deidentifyTemplates/432452342` or
              #     projects/project-id/deidentifyTemplates/432452342.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteDeidentifyTemplateRequest.new
              #
              #   # Call the delete_deidentify_template method.
              #   result = client.delete_deidentify_template request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_deidentify_template request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteDeidentifyTemplateRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_deidentify_template.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_deidentify_template.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_deidentify_template.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_deidentify_template request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a job trigger to run DLP actions such as scanning storage for
              # sensitive information on a set schedule.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
              # to learn more.
              #
              # @overload create_job_trigger(request, options = nil)
              #   Pass arguments to `create_job_trigger` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::CreateJobTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::CreateJobTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_job_trigger(parent: nil, job_trigger: nil, trigger_id: nil, location_id: nil)
              #   Pass arguments to `create_job_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on whether you have [specified a
              #     processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param job_trigger [::Google::Cloud::Dlp::V2::JobTrigger, ::Hash]
              #     Required. The JobTrigger to create.
              #   @param trigger_id [::String]
              #     The trigger id can contain uppercase and lowercase letters,
              #     numbers, and hyphens; that is, it must match the regular
              #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
              #     characters. Can be empty to allow the system to generate one.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::JobTrigger]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::JobTrigger]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::CreateJobTriggerRequest.new
              #
              #   # Call the create_job_trigger method.
              #   result = client.create_job_trigger request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::JobTrigger.
              #   p result
              #
              def create_job_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::CreateJobTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_job_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_job_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_job_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.create_job_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a job trigger.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
              # to learn more.
              #
              # @overload update_job_trigger(request, options = nil)
              #   Pass arguments to `update_job_trigger` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::UpdateJobTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::UpdateJobTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_job_trigger(name: nil, job_trigger: nil, update_mask: nil)
              #   Pass arguments to `update_job_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the project and the triggeredJob, for example
              #     `projects/dlp-test-project/jobTriggers/53234423`.
              #   @param job_trigger [::Google::Cloud::Dlp::V2::JobTrigger, ::Hash]
              #     New JobTrigger value.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask to control which fields get updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::JobTrigger]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::JobTrigger]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::UpdateJobTriggerRequest.new
              #
              #   # Call the update_job_trigger method.
              #   result = client.update_job_trigger request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::JobTrigger.
              #   p result
              #
              def update_job_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::UpdateJobTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_job_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_job_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_job_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.update_job_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Inspect hybrid content and store findings to a trigger. The inspection
              # will be processed asynchronously. To review the findings monitor the
              # jobs within the trigger.
              #
              # @overload hybrid_inspect_job_trigger(request, options = nil)
              #   Pass arguments to `hybrid_inspect_job_trigger` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::HybridInspectJobTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::HybridInspectJobTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload hybrid_inspect_job_trigger(name: nil, hybrid_item: nil)
              #   Pass arguments to `hybrid_inspect_job_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the trigger to execute a hybrid inspect on, for
              #     example `projects/dlp-test-project/jobTriggers/53234423`.
              #   @param hybrid_item [::Google::Cloud::Dlp::V2::HybridContentItem, ::Hash]
              #     The item to inspect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::HybridInspectResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::HybridInspectResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::HybridInspectJobTriggerRequest.new
              #
              #   # Call the hybrid_inspect_job_trigger method.
              #   result = client.hybrid_inspect_job_trigger request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::HybridInspectResponse.
              #   p result
              #
              def hybrid_inspect_job_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::HybridInspectJobTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.hybrid_inspect_job_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.hybrid_inspect_job_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.hybrid_inspect_job_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.hybrid_inspect_job_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a job trigger.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
              # to learn more.
              #
              # @overload get_job_trigger(request, options = nil)
              #   Pass arguments to `get_job_trigger` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetJobTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetJobTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_job_trigger(name: nil)
              #   Pass arguments to `get_job_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the project and the triggeredJob, for example
              #     `projects/dlp-test-project/jobTriggers/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::JobTrigger]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::JobTrigger]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetJobTriggerRequest.new
              #
              #   # Call the get_job_trigger method.
              #   result = client.get_job_trigger request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::JobTrigger.
              #   p result
              #
              def get_job_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetJobTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_job_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_job_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_job_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_job_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists job triggers.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
              # to learn more.
              #
              # @overload list_job_triggers(request, options = nil)
              #   Pass arguments to `list_job_triggers` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListJobTriggersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListJobTriggersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_job_triggers(parent: nil, page_token: nil, page_size: nil, order_by: nil, filter: nil, type: nil, location_id: nil)
              #   Pass arguments to `list_job_triggers` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on whether you have [specified a
              #     processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param page_token [::String]
              #     Page token to continue retrieval. Comes from the previous call
              #     to ListJobTriggers. `order_by` field must not
              #     change for subsequent calls.
              #   @param page_size [::Integer]
              #     Size of the page. This value can be limited by a server.
              #   @param order_by [::String]
              #     Comma-separated list of triggeredJob fields to order by,
              #     followed by `asc` or `desc` postfix. This list is case insensitive. The
              #     default sorting order is ascending. Redundant space characters are
              #     insignificant.
              #
              #     Example: `name asc,update_time, create_time desc`
              #
              #     Supported fields are:
              #
              #     - `create_time`: corresponds to the time the JobTrigger was created.
              #     - `update_time`: corresponds to the time the JobTrigger was last updated.
              #     - `last_run_time`: corresponds to the last time the JobTrigger ran.
              #     - `name`: corresponds to the JobTrigger's name.
              #     - `display_name`: corresponds to the JobTrigger's display name.
              #     - `status`: corresponds to JobTrigger's status.
              #   @param filter [::String]
              #     Allows filtering.
              #
              #     Supported syntax:
              #
              #     * Filter expressions are made up of one or more restrictions.
              #     * Restrictions can be combined by `AND` or `OR` logical operators. A
              #     sequence of restrictions implicitly uses `AND`.
              #     * A restriction has the form of `{field} {operator} {value}`.
              #     * Supported fields/values for inspect triggers:
              #         - `status` - HEALTHY|PAUSED|CANCELLED
              #         - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
              #         - 'last_run_time` - RFC 3339 formatted timestamp, surrounded by
              #         quotation marks. Nanoseconds are ignored.
              #         - 'error_count' - Number of errors that have occurred while running.
              #     * The operator must be `=` or `!=` for status and inspected_storage.
              #
              #     The syntax is based on https://google.aip.dev/160.
              #
              #     Examples:
              #
              #     * inspected_storage = cloud_storage AND status = HEALTHY
              #     * inspected_storage = cloud_storage OR inspected_storage = bigquery
              #     * inspected_storage = cloud_storage AND (state = PAUSED OR state = HEALTHY)
              #     * last_run_time > \"2017-12-12T00:00:00+00:00\"
              #
              #     The length of this field should be no more than 500 characters.
              #   @param type [::Google::Cloud::Dlp::V2::DlpJobType]
              #     The type of jobs. Will use `DlpJobType.INSPECT` if not set.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::JobTrigger>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::JobTrigger>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListJobTriggersRequest.new
              #
              #   # Call the list_job_triggers method.
              #   result = client.list_job_triggers request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::JobTrigger.
              #     p item
              #   end
              #
              def list_job_triggers request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListJobTriggersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_job_triggers.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_job_triggers.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_job_triggers.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_job_triggers request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_job_triggers, "job_triggers", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a job trigger.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-job-triggers
              # to learn more.
              #
              # @overload delete_job_trigger(request, options = nil)
              #   Pass arguments to `delete_job_trigger` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteJobTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteJobTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_job_trigger(name: nil)
              #   Pass arguments to `delete_job_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the project and the triggeredJob, for example
              #     `projects/dlp-test-project/jobTriggers/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteJobTriggerRequest.new
              #
              #   # Call the delete_job_trigger method.
              #   result = client.delete_job_trigger request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_job_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteJobTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_job_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_job_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_job_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_job_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Activate a job trigger. Causes the immediate execute of a trigger
              # instead of waiting on the trigger event to occur.
              #
              # @overload activate_job_trigger(request, options = nil)
              #   Pass arguments to `activate_job_trigger` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ActivateJobTriggerRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ActivateJobTriggerRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload activate_job_trigger(name: nil)
              #   Pass arguments to `activate_job_trigger` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the trigger to activate, for example
              #     `projects/dlp-test-project/jobTriggers/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DlpJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DlpJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ActivateJobTriggerRequest.new
              #
              #   # Call the activate_job_trigger method.
              #   result = client.activate_job_trigger request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DlpJob.
              #   p result
              #
              def activate_job_trigger request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ActivateJobTriggerRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.activate_job_trigger.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.activate_job_trigger.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.activate_job_trigger.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.activate_job_trigger request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a config for discovery to scan and profile storage.
              #
              # @overload create_discovery_config(request, options = nil)
              #   Pass arguments to `create_discovery_config` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::CreateDiscoveryConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::CreateDiscoveryConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_discovery_config(parent: nil, discovery_config: nil, config_id: nil)
              #   Pass arguments to `create_discovery_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on the scope of the request
              #     (project or organization):
              #
              #     + Projects scope:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Organizations scope:
              #       `organizations/{org_id}/locations/{location_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param discovery_config [::Google::Cloud::Dlp::V2::DiscoveryConfig, ::Hash]
              #     Required. The DiscoveryConfig to create.
              #   @param config_id [::String]
              #     The config ID can contain uppercase and lowercase letters,
              #     numbers, and hyphens; that is, it must match the regular
              #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
              #     characters. Can be empty to allow the system to generate one.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DiscoveryConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DiscoveryConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::CreateDiscoveryConfigRequest.new
              #
              #   # Call the create_discovery_config method.
              #   result = client.create_discovery_config request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DiscoveryConfig.
              #   p result
              #
              def create_discovery_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::CreateDiscoveryConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_discovery_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_discovery_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_discovery_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.create_discovery_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a discovery configuration.
              #
              # @overload update_discovery_config(request, options = nil)
              #   Pass arguments to `update_discovery_config` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::UpdateDiscoveryConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::UpdateDiscoveryConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_discovery_config(name: nil, discovery_config: nil, update_mask: nil)
              #   Pass arguments to `update_discovery_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the project and the configuration, for example
              #     `projects/dlp-test-project/discoveryConfigs/53234423`.
              #   @param discovery_config [::Google::Cloud::Dlp::V2::DiscoveryConfig, ::Hash]
              #     Required. New DiscoveryConfig value.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask to control which fields get updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DiscoveryConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DiscoveryConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::UpdateDiscoveryConfigRequest.new
              #
              #   # Call the update_discovery_config method.
              #   result = client.update_discovery_config request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DiscoveryConfig.
              #   p result
              #
              def update_discovery_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::UpdateDiscoveryConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_discovery_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_discovery_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_discovery_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.update_discovery_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a discovery configuration.
              #
              # @overload get_discovery_config(request, options = nil)
              #   Pass arguments to `get_discovery_config` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetDiscoveryConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetDiscoveryConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_discovery_config(name: nil)
              #   Pass arguments to `get_discovery_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the project and the configuration, for example
              #     `projects/dlp-test-project/discoveryConfigs/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DiscoveryConfig]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DiscoveryConfig]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetDiscoveryConfigRequest.new
              #
              #   # Call the get_discovery_config method.
              #   result = client.get_discovery_config request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DiscoveryConfig.
              #   p result
              #
              def get_discovery_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetDiscoveryConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_discovery_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_discovery_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_discovery_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_discovery_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists discovery configurations.
              #
              # @overload list_discovery_configs(request, options = nil)
              #   Pass arguments to `list_discovery_configs` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListDiscoveryConfigsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListDiscoveryConfigsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_discovery_configs(parent: nil, page_token: nil, page_size: nil, order_by: nil)
              #   Pass arguments to `list_discovery_configs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value is as follows:
              #     `projects/{project_id}/locations/{location_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param page_token [::String]
              #     Page token to continue retrieval. Comes from the previous call
              #     to ListDiscoveryConfigs. `order_by` field must not
              #     change for subsequent calls.
              #   @param page_size [::Integer]
              #     Size of the page. This value can be limited by a server.
              #   @param order_by [::String]
              #     Comma-separated list of config fields to order by,
              #     followed by `asc` or `desc` postfix. This list is case insensitive. The
              #     default sorting order is ascending. Redundant space characters are
              #     insignificant.
              #
              #     Example: `name asc,update_time, create_time desc`
              #
              #     Supported fields are:
              #
              #     - `last_run_time`: corresponds to the last time the DiscoveryConfig ran.
              #     - `name`: corresponds to the DiscoveryConfig's name.
              #     - `status`: corresponds to DiscoveryConfig's status.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::DiscoveryConfig>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::DiscoveryConfig>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListDiscoveryConfigsRequest.new
              #
              #   # Call the list_discovery_configs method.
              #   result = client.list_discovery_configs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::DiscoveryConfig.
              #     p item
              #   end
              #
              def list_discovery_configs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListDiscoveryConfigsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_discovery_configs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_discovery_configs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_discovery_configs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_discovery_configs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_discovery_configs, "discovery_configs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a discovery configuration.
              #
              # @overload delete_discovery_config(request, options = nil)
              #   Pass arguments to `delete_discovery_config` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteDiscoveryConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteDiscoveryConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_discovery_config(name: nil)
              #   Pass arguments to `delete_discovery_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the project and the config, for example
              #     `projects/dlp-test-project/discoveryConfigs/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteDiscoveryConfigRequest.new
              #
              #   # Call the delete_discovery_config method.
              #   result = client.delete_discovery_config request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_discovery_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteDiscoveryConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_discovery_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_discovery_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_discovery_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_discovery_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new job to inspect storage or calculate risk metrics.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
              # and
              # https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
              # to learn more.
              #
              # When no InfoTypes or CustomInfoTypes are specified in inspect jobs, the
              # system will automatically choose what detectors to run. By default this may
              # be all types, but may change over time as detectors are updated.
              #
              # @overload create_dlp_job(request, options = nil)
              #   Pass arguments to `create_dlp_job` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::CreateDlpJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::CreateDlpJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_dlp_job(parent: nil, inspect_job: nil, risk_job: nil, job_id: nil, location_id: nil)
              #   Pass arguments to `create_dlp_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on whether you have [specified a
              #     processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param inspect_job [::Google::Cloud::Dlp::V2::InspectJobConfig, ::Hash]
              #     An inspection job scans a storage repository for InfoTypes.
              #
              #     Note: The following parameters are mutually exclusive: `inspect_job`, `risk_job`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param risk_job [::Google::Cloud::Dlp::V2::RiskAnalysisJobConfig, ::Hash]
              #     A risk analysis job calculates re-identification risk metrics for a
              #     BigQuery table.
              #
              #     Note: The following parameters are mutually exclusive: `risk_job`, `inspect_job`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param job_id [::String]
              #     The job id can contain uppercase and lowercase letters,
              #     numbers, and hyphens; that is, it must match the regular
              #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
              #     characters. Can be empty to allow the system to generate one.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DlpJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DlpJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::CreateDlpJobRequest.new
              #
              #   # Call the create_dlp_job method.
              #   result = client.create_dlp_job request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DlpJob.
              #   p result
              #
              def create_dlp_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::CreateDlpJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_dlp_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_dlp_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_dlp_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.create_dlp_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DlpJobs that match the specified filter in the request.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
              # and
              # https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
              # to learn more.
              #
              # @overload list_dlp_jobs(request, options = nil)
              #   Pass arguments to `list_dlp_jobs` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListDlpJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListDlpJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_dlp_jobs(parent: nil, filter: nil, page_size: nil, page_token: nil, type: nil, order_by: nil, location_id: nil)
              #   Pass arguments to `list_dlp_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on whether you have [specified a
              #     processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param filter [::String]
              #     Allows filtering.
              #
              #     Supported syntax:
              #
              #     * Filter expressions are made up of one or more restrictions.
              #     * Restrictions can be combined by `AND` or `OR` logical operators. A
              #     sequence of restrictions implicitly uses `AND`.
              #     * A restriction has the form of `{field} {operator} {value}`.
              #     * Supported fields/values for inspect jobs:
              #         - `state` - PENDING|RUNNING|CANCELED|FINISHED|FAILED
              #         - `inspected_storage` - DATASTORE|CLOUD_STORAGE|BIGQUERY
              #         - `trigger_name` - The name of the trigger that created the job.
              #         - 'end_time` - Corresponds to the time the job finished.
              #         - 'start_time` - Corresponds to the time the job finished.
              #     * Supported fields for risk analysis jobs:
              #         - `state` - RUNNING|CANCELED|FINISHED|FAILED
              #         - 'end_time` - Corresponds to the time the job finished.
              #         - 'start_time` - Corresponds to the time the job finished.
              #     * The operator must be `=` or `!=`.
              #
              #     The syntax is based on https://google.aip.dev/160.
              #
              #     Examples:
              #
              #     * inspected_storage = cloud_storage AND state = done
              #     * inspected_storage = cloud_storage OR inspected_storage = bigquery
              #     * inspected_storage = cloud_storage AND (state = done OR state = canceled)
              #     * end_time > \"2017-12-12T00:00:00+00:00\"
              #
              #     The length of this field should be no more than 500 characters.
              #   @param page_size [::Integer]
              #     The standard list page size.
              #   @param page_token [::String]
              #     The standard list page token.
              #   @param type [::Google::Cloud::Dlp::V2::DlpJobType]
              #     The type of job. Defaults to `DlpJobType.INSPECT`
              #   @param order_by [::String]
              #     Comma-separated list of fields to order by,
              #     followed by `asc` or `desc` postfix. This list is case insensitive. The
              #     default sorting order is ascending. Redundant space characters are
              #     insignificant.
              #
              #     Example: `name asc, end_time asc, create_time desc`
              #
              #     Supported fields are:
              #
              #     - `create_time`: corresponds to the time the job was created.
              #     - `end_time`: corresponds to the time the job ended.
              #     - `name`: corresponds to the job's name.
              #     - `state`: corresponds to `state`
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::DlpJob>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::DlpJob>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListDlpJobsRequest.new
              #
              #   # Call the list_dlp_jobs method.
              #   result = client.list_dlp_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::DlpJob.
              #     p item
              #   end
              #
              def list_dlp_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListDlpJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_dlp_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_dlp_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_dlp_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_dlp_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_dlp_jobs, "jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the latest state of a long-running DlpJob.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
              # and
              # https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
              # to learn more.
              #
              # @overload get_dlp_job(request, options = nil)
              #   Pass arguments to `get_dlp_job` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetDlpJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetDlpJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_dlp_job(name: nil)
              #   Pass arguments to `get_dlp_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DlpJob resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::DlpJob]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::DlpJob]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetDlpJobRequest.new
              #
              #   # Call the get_dlp_job method.
              #   result = client.get_dlp_job request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::DlpJob.
              #   p result
              #
              def get_dlp_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetDlpJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_dlp_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_dlp_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_dlp_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_dlp_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a long-running DlpJob. This method indicates that the client is
              # no longer interested in the DlpJob result. The job will be canceled if
              # possible.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
              # and
              # https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
              # to learn more.
              #
              # @overload delete_dlp_job(request, options = nil)
              #   Pass arguments to `delete_dlp_job` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteDlpJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteDlpJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_dlp_job(name: nil)
              #   Pass arguments to `delete_dlp_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DlpJob resource to be deleted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteDlpJobRequest.new
              #
              #   # Call the delete_dlp_job method.
              #   result = client.delete_dlp_job request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_dlp_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteDlpJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_dlp_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_dlp_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_dlp_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_dlp_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts asynchronous cancellation on a long-running DlpJob. The server
              # makes a best effort to cancel the DlpJob, but success is not
              # guaranteed.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/inspecting-storage
              # and
              # https://cloud.google.com/sensitive-data-protection/docs/compute-risk-analysis
              # to learn more.
              #
              # @overload cancel_dlp_job(request, options = nil)
              #   Pass arguments to `cancel_dlp_job` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::CancelDlpJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::CancelDlpJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_dlp_job(name: nil)
              #   Pass arguments to `cancel_dlp_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DlpJob resource to be cancelled.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::CancelDlpJobRequest.new
              #
              #   # Call the cancel_dlp_job method.
              #   result = client.cancel_dlp_job request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def cancel_dlp_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::CancelDlpJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_dlp_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_dlp_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_dlp_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.cancel_dlp_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a pre-built stored infoType to be used for inspection.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
              # to learn more.
              #
              # @overload create_stored_info_type(request, options = nil)
              #   Pass arguments to `create_stored_info_type` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::CreateStoredInfoTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::CreateStoredInfoTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_stored_info_type(parent: nil, config: nil, stored_info_type_id: nil, location_id: nil)
              #   Pass arguments to `create_stored_info_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on the scope of the request
              #     (project or organization) and whether you have [specified a processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #     + Organizations scope, location specified:
              #       `organizations/{org_id}/locations/{location_id}`
              #     + Organizations scope, no location specified (defaults to global):
              #       `organizations/{org_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param config [::Google::Cloud::Dlp::V2::StoredInfoTypeConfig, ::Hash]
              #     Required. Configuration of the storedInfoType to create.
              #   @param stored_info_type_id [::String]
              #     The storedInfoType ID can contain uppercase and lowercase letters,
              #     numbers, and hyphens; that is, it must match the regular
              #     expression: `[a-zA-Z\d-_]+`. The maximum length is 100
              #     characters. Can be empty to allow the system to generate one.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::StoredInfoType]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::StoredInfoType]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::CreateStoredInfoTypeRequest.new
              #
              #   # Call the create_stored_info_type method.
              #   result = client.create_stored_info_type request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::StoredInfoType.
              #   p result
              #
              def create_stored_info_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::CreateStoredInfoTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_stored_info_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_stored_info_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_stored_info_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.create_stored_info_type request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the stored infoType by creating a new version. The existing version
              # will continue to be used until the new version is ready.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
              # to learn more.
              #
              # @overload update_stored_info_type(request, options = nil)
              #   Pass arguments to `update_stored_info_type` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::UpdateStoredInfoTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::UpdateStoredInfoTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_stored_info_type(name: nil, config: nil, update_mask: nil)
              #   Pass arguments to `update_stored_info_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of organization and storedInfoType to be updated,
              #     for example `organizations/433245324/storedInfoTypes/432452342` or
              #     projects/project-id/storedInfoTypes/432452342.
              #   @param config [::Google::Cloud::Dlp::V2::StoredInfoTypeConfig, ::Hash]
              #     Updated configuration for the storedInfoType. If not provided, a new
              #     version of the storedInfoType will be created with the existing
              #     configuration.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Mask to control which fields get updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::StoredInfoType]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::StoredInfoType]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::UpdateStoredInfoTypeRequest.new
              #
              #   # Call the update_stored_info_type method.
              #   result = client.update_stored_info_type request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::StoredInfoType.
              #   p result
              #
              def update_stored_info_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::UpdateStoredInfoTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_stored_info_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_stored_info_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_stored_info_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.update_stored_info_type request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a stored infoType.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
              # to learn more.
              #
              # @overload get_stored_info_type(request, options = nil)
              #   Pass arguments to `get_stored_info_type` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetStoredInfoTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetStoredInfoTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_stored_info_type(name: nil)
              #   Pass arguments to `get_stored_info_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the organization and storedInfoType to be read,
              #     for example `organizations/433245324/storedInfoTypes/432452342` or
              #     projects/project-id/storedInfoTypes/432452342.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::StoredInfoType]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::StoredInfoType]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetStoredInfoTypeRequest.new
              #
              #   # Call the get_stored_info_type method.
              #   result = client.get_stored_info_type request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::StoredInfoType.
              #   p result
              #
              def get_stored_info_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetStoredInfoTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_stored_info_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_stored_info_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_stored_info_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_stored_info_type request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists stored infoTypes.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
              # to learn more.
              #
              # @overload list_stored_info_types(request, options = nil)
              #   Pass arguments to `list_stored_info_types` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListStoredInfoTypesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListStoredInfoTypesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_stored_info_types(parent: nil, page_token: nil, page_size: nil, order_by: nil, location_id: nil)
              #   Pass arguments to `list_stored_info_types` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on the scope of the request
              #     (project or organization) and whether you have [specified a processing
              #     location](https://cloud.google.com/sensitive-data-protection/docs/specifying-location):
              #
              #     + Projects scope, location specified:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Projects scope, no location specified (defaults to global):
              #       `projects/{project_id}`
              #
              #     The following example `parent` string specifies a parent project with the
              #     identifier `example-project`, and specifies the `europe-west3` location
              #     for processing data:
              #
              #         parent=projects/example-project/locations/europe-west3
              #   @param page_token [::String]
              #     Page token to continue retrieval. Comes from the previous call
              #     to `ListStoredInfoTypes`.
              #   @param page_size [::Integer]
              #     Size of the page. This value can be limited by the server. If zero server
              #     returns a page of max size 100.
              #   @param order_by [::String]
              #     Comma-separated list of fields to order by,
              #     followed by `asc` or `desc` postfix. This list is case insensitive. The
              #     default sorting order is ascending. Redundant space characters are
              #     insignificant.
              #
              #     Example: `name asc, display_name, create_time desc`
              #
              #     Supported fields are:
              #
              #     - `create_time`: corresponds to the time the most recent version of the
              #     resource was created.
              #     - `state`: corresponds to the state of the resource.
              #     - `name`: corresponds to resource name.
              #     - `display_name`: corresponds to info type's display name.
              #   @param location_id [::String]
              #     Deprecated. This field has no effect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::StoredInfoType>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::StoredInfoType>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListStoredInfoTypesRequest.new
              #
              #   # Call the list_stored_info_types method.
              #   result = client.list_stored_info_types request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::StoredInfoType.
              #     p item
              #   end
              #
              def list_stored_info_types request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListStoredInfoTypesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_stored_info_types.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_stored_info_types.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_stored_info_types.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_stored_info_types request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_stored_info_types, "stored_info_types", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a stored infoType.
              # See
              # https://cloud.google.com/sensitive-data-protection/docs/creating-stored-infotypes
              # to learn more.
              #
              # @overload delete_stored_info_type(request, options = nil)
              #   Pass arguments to `delete_stored_info_type` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteStoredInfoTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteStoredInfoTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_stored_info_type(name: nil)
              #   Pass arguments to `delete_stored_info_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the organization and storedInfoType to be
              #     deleted, for example `organizations/433245324/storedInfoTypes/432452342` or
              #     projects/project-id/storedInfoTypes/432452342.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteStoredInfoTypeRequest.new
              #
              #   # Call the delete_stored_info_type method.
              #   result = client.delete_stored_info_type request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_stored_info_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteStoredInfoTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_stored_info_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_stored_info_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_stored_info_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_stored_info_type request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists project data profiles for an organization.
              #
              # @overload list_project_data_profiles(request, options = nil)
              #   Pass arguments to `list_project_data_profiles` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListProjectDataProfilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListProjectDataProfilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_project_data_profiles(parent: nil, page_token: nil, page_size: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_project_data_profiles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. organizations/\\{org_id}/locations/\\{loc_id}
              #   @param page_token [::String]
              #     Page token to continue retrieval.
              #   @param page_size [::Integer]
              #     Size of the page. This value can be limited by the server. If zero, server
              #     returns a page of max size 100.
              #   @param order_by [::String]
              #     Comma-separated list of fields to order by, followed by `asc` or `desc`
              #     postfix. This list is case insensitive. The default sorting order is
              #     ascending. Redundant space characters are insignificant. Only one order
              #     field at a time is allowed.
              #
              #     Examples:
              #     * `project_id`
              #     * `sensitivity_level desc`
              #
              #     Supported fields:
              #
              #     - `project_id`: Google Cloud project ID
              #     - `sensitivity_level`: How sensitive the data in a project is, at most
              #     - `data_risk_level`: How much risk is associated with this data
              #     - `profile_last_generated`: Date and time (in epoch seconds) the profile
              #       was last generated
              #   @param filter [::String]
              #     Allows filtering.
              #
              #     Supported syntax:
              #
              #     * Filter expressions are made up of one or more restrictions.
              #     * Restrictions can be combined by `AND` or `OR` logical operators. A
              #     sequence of restrictions implicitly uses `AND`.
              #     * A restriction has the form of `{field} {operator} {value}`.
              #     * Supported fields:
              #         - `project_id`: the Google Cloud project ID
              #         - `sensitivity_level`: HIGH|MODERATE|LOW
              #         - `data_risk_level`: HIGH|MODERATE|LOW
              #         - `status_code`: an RPC status code as defined in
              #         https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
              #         - `profile_last_generated`: Date and time the profile was last
              #           generated
              #     * The operator must be `=` or `!=`. The `profile_last_generated` filter
              #       also supports `<` and `>`.
              #
              #     The syntax is based on https://google.aip.dev/160.
              #
              #     Examples:
              #
              #     * `project_id = 12345 AND status_code = 1`
              #     * `project_id = 12345 AND sensitivity_level = HIGH`
              #     * `profile_last_generated < "2025-01-01T00:00:00.000Z"`
              #
              #     The length of this field should be no more than 500 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::ProjectDataProfile>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::ProjectDataProfile>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListProjectDataProfilesRequest.new
              #
              #   # Call the list_project_data_profiles method.
              #   result = client.list_project_data_profiles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::ProjectDataProfile.
              #     p item
              #   end
              #
              def list_project_data_profiles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListProjectDataProfilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_project_data_profiles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_project_data_profiles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_project_data_profiles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_project_data_profiles request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_project_data_profiles, "project_data_profiles", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists table data profiles for an organization.
              #
              # @overload list_table_data_profiles(request, options = nil)
              #   Pass arguments to `list_table_data_profiles` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListTableDataProfilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListTableDataProfilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_table_data_profiles(parent: nil, page_token: nil, page_size: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_table_data_profiles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the organization or project, for
              #     example `organizations/433245324/locations/europe` or
              #     `projects/project-id/locations/asia`.
              #   @param page_token [::String]
              #     Page token to continue retrieval.
              #   @param page_size [::Integer]
              #     Size of the page. This value can be limited by the server. If zero, server
              #     returns a page of max size 100.
              #   @param order_by [::String]
              #     Comma-separated list of fields to order by, followed by `asc` or `desc`
              #     postfix. This list is case insensitive. The default sorting order is
              #     ascending. Redundant space characters are insignificant. Only one order
              #     field at a time is allowed.
              #
              #     Examples:
              #     * `project_id asc`
              #     * `table_id`
              #     * `sensitivity_level desc`
              #
              #     Supported fields are:
              #
              #     - `project_id`: The Google Cloud project ID.
              #     - `dataset_id`: The ID of a BigQuery dataset.
              #     - `table_id`: The ID of a BigQuery table.
              #     - `sensitivity_level`: How sensitive the data in a table is, at most.
              #     - `data_risk_level`: How much risk is associated with this data.
              #     - `profile_last_generated`: When the profile was last updated in epoch
              #     seconds.
              #     - `last_modified`: The last time the resource was modified.
              #     - `resource_visibility`: Visibility restriction for this resource.
              #     - `row_count`: Number of rows in this resource.
              #   @param filter [::String]
              #     Allows filtering.
              #
              #     Supported syntax:
              #
              #     * Filter expressions are made up of one or more restrictions.
              #     * Restrictions can be combined by `AND` or `OR` logical operators. A
              #     sequence of restrictions implicitly uses `AND`.
              #     * A restriction has the form of `{field} {operator} {value}`.
              #     * Supported fields:
              #         - `project_id`: The Google Cloud project ID
              #         - `dataset_id`: The BigQuery dataset ID
              #         - `table_id`: The ID of the BigQuery table
              #         - `sensitivity_level`: HIGH|MODERATE|LOW
              #         - `data_risk_level`: HIGH|MODERATE|LOW
              #         - `resource_visibility`: PUBLIC|RESTRICTED
              #         - `status_code`: an RPC status code as defined in
              #         https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
              #         - `profile_last_generated`: Date and time the profile was last
              #           generated
              #
              #     * The operator must be `=` or `!=`. The `profile_last_generated` filter
              #       also supports `<` and `>`.
              #
              #     The syntax is based on https://google.aip.dev/160.
              #
              #     Examples:
              #
              #     * `project_id = 12345 AND status_code = 1`
              #     * `project_id = 12345 AND sensitivity_level = HIGH`
              #     * `project_id = 12345 AND resource_visibility = PUBLIC`
              #     * `profile_last_generated < "2025-01-01T00:00:00.000Z"`
              #
              #     The length of this field should be no more than 500 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::TableDataProfile>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::TableDataProfile>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListTableDataProfilesRequest.new
              #
              #   # Call the list_table_data_profiles method.
              #   result = client.list_table_data_profiles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::TableDataProfile.
              #     p item
              #   end
              #
              def list_table_data_profiles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListTableDataProfilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_table_data_profiles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_table_data_profiles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_table_data_profiles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_table_data_profiles request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_table_data_profiles, "table_data_profiles", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists column data profiles for an organization.
              #
              # @overload list_column_data_profiles(request, options = nil)
              #   Pass arguments to `list_column_data_profiles` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListColumnDataProfilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListColumnDataProfilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_column_data_profiles(parent: nil, page_token: nil, page_size: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_column_data_profiles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the organization or project, for
              #     example `organizations/433245324/locations/europe` or
              #     `projects/project-id/locations/asia`.
              #   @param page_token [::String]
              #     Page token to continue retrieval.
              #   @param page_size [::Integer]
              #     Size of the page. This value can be limited by the server. If zero, server
              #     returns a page of max size 100.
              #   @param order_by [::String]
              #     Comma-separated list of fields to order by, followed by `asc` or `desc`
              #     postfix. This list is case insensitive. The default sorting order is
              #     ascending. Redundant space characters are insignificant. Only one order
              #     field at a time is allowed.
              #
              #     Examples:
              #
              #     * `project_id asc`
              #     * `table_id`
              #     * `sensitivity_level desc`
              #
              #     Supported fields are:
              #
              #     - `project_id`: The Google Cloud project ID.
              #     - `dataset_id`: The ID of a BigQuery dataset.
              #     - `table_id`: The ID of a BigQuery table.
              #     - `sensitivity_level`: How sensitive the data in a column is, at most.
              #     - `data_risk_level`: How much risk is associated with this data.
              #     - `profile_last_generated`: When the profile was last updated in epoch
              #     seconds.
              #   @param filter [::String]
              #     Allows filtering.
              #
              #     Supported syntax:
              #
              #     * Filter expressions are made up of one or more restrictions.
              #     * Restrictions can be combined by `AND` or `OR` logical operators. A
              #     sequence of restrictions implicitly uses `AND`.
              #     * A restriction has the form of `{field} {operator} {value}`.
              #     * Supported fields:
              #         - `table_data_profile_name`: The name of the related table data
              #         profile
              #         - `project_id`: The Google Cloud project ID (REQUIRED)
              #         - `dataset_id`: The BigQuery dataset ID (REQUIRED)
              #         - `table_id`: The BigQuery table ID (REQUIRED)
              #         - `field_id`: The ID of the BigQuery field
              #         - `info_type`: The infotype detected in the resource
              #         - `sensitivity_level`: HIGH|MEDIUM|LOW
              #         - `data_risk_level`: How much risk is associated with this data
              #         - `status_code`: An RPC status code as defined in
              #         https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
              #         - `profile_last_generated`: Date and time the profile was last
              #           generated
              #     * The operator must be `=` for project_id, dataset_id, and table_id. Other
              #       filters also support `!=`. The `profile_last_generated` filter also
              #       supports `<` and `>`.
              #
              #     The syntax is based on https://google.aip.dev/160.
              #
              #     Examples:
              #
              #     * project_id = 12345 AND status_code = 1
              #     * project_id = 12345 AND sensitivity_level = HIGH
              #     * project_id = 12345 AND info_type = STREET_ADDRESS
              #     * profile_last_generated < "2025-01-01T00:00:00.000Z"
              #
              #     The length of this field should be no more than 500 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::ColumnDataProfile>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::ColumnDataProfile>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListColumnDataProfilesRequest.new
              #
              #   # Call the list_column_data_profiles method.
              #   result = client.list_column_data_profiles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::ColumnDataProfile.
              #     p item
              #   end
              #
              def list_column_data_profiles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListColumnDataProfilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_column_data_profiles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_column_data_profiles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_column_data_profiles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_column_data_profiles request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_column_data_profiles, "column_data_profiles", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a project data profile.
              #
              # @overload get_project_data_profile(request, options = nil)
              #   Pass arguments to `get_project_data_profile` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetProjectDataProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetProjectDataProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_project_data_profile(name: nil)
              #   Pass arguments to `get_project_data_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name, for example
              #     `organizations/12345/locations/us/projectDataProfiles/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::ProjectDataProfile]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::ProjectDataProfile]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetProjectDataProfileRequest.new
              #
              #   # Call the get_project_data_profile method.
              #   result = client.get_project_data_profile request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::ProjectDataProfile.
              #   p result
              #
              def get_project_data_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetProjectDataProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_project_data_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_project_data_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_project_data_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_project_data_profile request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists file store data profiles for an organization.
              #
              # @overload list_file_store_data_profiles(request, options = nil)
              #   Pass arguments to `list_file_store_data_profiles` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListFileStoreDataProfilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListFileStoreDataProfilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_file_store_data_profiles(parent: nil, page_token: nil, page_size: nil, order_by: nil, filter: nil)
              #   Pass arguments to `list_file_store_data_profiles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the organization or project, for
              #     example `organizations/433245324/locations/europe` or
              #     `projects/project-id/locations/asia`.
              #   @param page_token [::String]
              #     Optional. Page token to continue retrieval.
              #   @param page_size [::Integer]
              #     Optional. Size of the page. This value can be limited by the server. If
              #     zero, server returns a page of max size 100.
              #   @param order_by [::String]
              #     Optional. Comma-separated list of fields to order by, followed by `asc` or
              #     `desc` postfix. This list is case insensitive. The default sorting order is
              #     ascending. Redundant space characters are insignificant. Only one order
              #     field at a time is allowed.
              #
              #     Examples:
              #
              #     * `project_id asc`
              #     * `name`
              #     * `sensitivity_level desc`
              #
              #     Supported fields are:
              #
              #     - `project_id`: The Google Cloud project ID.
              #     - `sensitivity_level`: How sensitive the data in a table is, at most.
              #     - `data_risk_level`: How much risk is associated with this data.
              #     - `profile_last_generated`: When the profile was last updated in epoch
              #     seconds.
              #     - `last_modified`: The last time the resource was modified.
              #     - `resource_visibility`: Visibility restriction for this resource.
              #     - `name`: The name of the profile.
              #     - `create_time`: The time the file store was first created.
              #   @param filter [::String]
              #     Optional. Allows filtering.
              #
              #     Supported syntax:
              #
              #     * Filter expressions are made up of one or more restrictions.
              #     * Restrictions can be combined by `AND` or `OR` logical operators. A
              #     sequence of restrictions implicitly uses `AND`.
              #     * A restriction has the form of `{field} {operator} {value}`.
              #     * Supported fields:
              #         - `project_id`: The Google Cloud project ID
              #         - `account_id`: The AWS account ID
              #         - `file_store_path`: The path like "gs://bucket"
              #         - `data_source_type`: The profile's data source type, like
              #         "google/storage/bucket"
              #         - `data_storage_location`: The location where the file store's data is
              #         stored, like "us-central1"
              #         - `sensitivity_level`: HIGH|MODERATE|LOW
              #         - `data_risk_level`: HIGH|MODERATE|LOW
              #         - `resource_visibility`: PUBLIC|RESTRICTED
              #         - `status_code`: an RPC status code as defined in
              #         https://github.com/googleapis/googleapis/blob/master/google/rpc/code.proto
              #         - `profile_last_generated`: Date and time the profile was last
              #           generated
              #
              #     * The operator must be `=` or `!=`. The `profile_last_generated` filter
              #       also supports `<` and `>`.
              #
              #     The syntax is based on https://google.aip.dev/160.
              #
              #     Examples:
              #
              #     * `project_id = 12345 AND status_code = 1`
              #     * `project_id = 12345 AND sensitivity_level = HIGH`
              #     * `project_id = 12345 AND resource_visibility = PUBLIC`
              #     * `file_store_path = "gs://mybucket"`
              #     * `profile_last_generated < "2025-01-01T00:00:00.000Z"`
              #
              #     The length of this field should be no more than 500 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::FileStoreDataProfile>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::FileStoreDataProfile>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListFileStoreDataProfilesRequest.new
              #
              #   # Call the list_file_store_data_profiles method.
              #   result = client.list_file_store_data_profiles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::FileStoreDataProfile.
              #     p item
              #   end
              #
              def list_file_store_data_profiles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListFileStoreDataProfilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_file_store_data_profiles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_file_store_data_profiles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_file_store_data_profiles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_file_store_data_profiles request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_file_store_data_profiles, "file_store_data_profiles", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a file store data profile.
              #
              # @overload get_file_store_data_profile(request, options = nil)
              #   Pass arguments to `get_file_store_data_profile` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetFileStoreDataProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetFileStoreDataProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_file_store_data_profile(name: nil)
              #   Pass arguments to `get_file_store_data_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name, for example
              #     `organizations/12345/locations/us/fileStoreDataProfiles/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::FileStoreDataProfile]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::FileStoreDataProfile]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetFileStoreDataProfileRequest.new
              #
              #   # Call the get_file_store_data_profile method.
              #   result = client.get_file_store_data_profile request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::FileStoreDataProfile.
              #   p result
              #
              def get_file_store_data_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetFileStoreDataProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_file_store_data_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_file_store_data_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_file_store_data_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_file_store_data_profile request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a FileStoreDataProfile. Will not prevent the profile from being
              # regenerated if the resource is still included in a discovery configuration.
              #
              # @overload delete_file_store_data_profile(request, options = nil)
              #   Pass arguments to `delete_file_store_data_profile` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteFileStoreDataProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteFileStoreDataProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_file_store_data_profile(name: nil)
              #   Pass arguments to `delete_file_store_data_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the file store data profile.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteFileStoreDataProfileRequest.new
              #
              #   # Call the delete_file_store_data_profile method.
              #   result = client.delete_file_store_data_profile request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_file_store_data_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteFileStoreDataProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_file_store_data_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_file_store_data_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_file_store_data_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_file_store_data_profile request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a table data profile.
              #
              # @overload get_table_data_profile(request, options = nil)
              #   Pass arguments to `get_table_data_profile` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetTableDataProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetTableDataProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_table_data_profile(name: nil)
              #   Pass arguments to `get_table_data_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name, for example
              #     `organizations/12345/locations/us/tableDataProfiles/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::TableDataProfile]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::TableDataProfile]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetTableDataProfileRequest.new
              #
              #   # Call the get_table_data_profile method.
              #   result = client.get_table_data_profile request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::TableDataProfile.
              #   p result
              #
              def get_table_data_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetTableDataProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_table_data_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_table_data_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_table_data_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_table_data_profile request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets a column data profile.
              #
              # @overload get_column_data_profile(request, options = nil)
              #   Pass arguments to `get_column_data_profile` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetColumnDataProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetColumnDataProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_column_data_profile(name: nil)
              #   Pass arguments to `get_column_data_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name, for example
              #     `organizations/12345/locations/us/columnDataProfiles/53234423`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::ColumnDataProfile]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::ColumnDataProfile]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetColumnDataProfileRequest.new
              #
              #   # Call the get_column_data_profile method.
              #   result = client.get_column_data_profile request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::ColumnDataProfile.
              #   p result
              #
              def get_column_data_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetColumnDataProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_column_data_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_column_data_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_column_data_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_column_data_profile request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a TableDataProfile. Will not prevent the profile from being
              # regenerated if the table is still included in a discovery configuration.
              #
              # @overload delete_table_data_profile(request, options = nil)
              #   Pass arguments to `delete_table_data_profile` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteTableDataProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteTableDataProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_table_data_profile(name: nil)
              #   Pass arguments to `delete_table_data_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the table data profile.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteTableDataProfileRequest.new
              #
              #   # Call the delete_table_data_profile method.
              #   result = client.delete_table_data_profile request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_table_data_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteTableDataProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_table_data_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_table_data_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_table_data_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_table_data_profile request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Inspect hybrid content and store findings to a job.
              # To review the findings, inspect the job. Inspection will occur
              # asynchronously.
              #
              # @overload hybrid_inspect_dlp_job(request, options = nil)
              #   Pass arguments to `hybrid_inspect_dlp_job` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::HybridInspectDlpJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::HybridInspectDlpJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload hybrid_inspect_dlp_job(name: nil, hybrid_item: nil)
              #   Pass arguments to `hybrid_inspect_dlp_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the job to execute a hybrid inspect on, for
              #     example `projects/dlp-test-project/dlpJob/53234423`.
              #   @param hybrid_item [::Google::Cloud::Dlp::V2::HybridContentItem, ::Hash]
              #     The item to inspect.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::HybridInspectResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::HybridInspectResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::HybridInspectDlpJobRequest.new
              #
              #   # Call the hybrid_inspect_dlp_job method.
              #   result = client.hybrid_inspect_dlp_job request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::HybridInspectResponse.
              #   p result
              #
              def hybrid_inspect_dlp_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::HybridInspectDlpJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.hybrid_inspect_dlp_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.hybrid_inspect_dlp_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.hybrid_inspect_dlp_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.hybrid_inspect_dlp_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Finish a running hybrid DlpJob. Triggers the finalization steps and running
              # of any enabled actions that have not yet run.
              #
              # @overload finish_dlp_job(request, options = nil)
              #   Pass arguments to `finish_dlp_job` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::FinishDlpJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::FinishDlpJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload finish_dlp_job(name: nil)
              #   Pass arguments to `finish_dlp_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the DlpJob resource to be finished.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::FinishDlpJobRequest.new
              #
              #   # Call the finish_dlp_job method.
              #   result = client.finish_dlp_job request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def finish_dlp_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::FinishDlpJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.finish_dlp_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.finish_dlp_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.finish_dlp_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.finish_dlp_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create a Connection to an external data source.
              #
              # @overload create_connection(request, options = nil)
              #   Pass arguments to `create_connection` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::CreateConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::CreateConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_connection(parent: nil, connection: nil)
              #   Pass arguments to `create_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Parent resource name.
              #
              #     The format of this value varies depending on the scope of the request
              #     (project or organization):
              #
              #     + Projects scope:
              #       `projects/{project_id}/locations/{location_id}`
              #     + Organizations scope:
              #       `organizations/{org_id}/locations/{location_id}`
              #   @param connection [::Google::Cloud::Dlp::V2::Connection, ::Hash]
              #     Required. The connection resource.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::Connection]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::Connection]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::CreateConnectionRequest.new
              #
              #   # Call the create_connection method.
              #   result = client.create_connection request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::Connection.
              #   p result
              #
              def create_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::CreateConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.create_connection request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get a Connection by name.
              #
              # @overload get_connection(request, options = nil)
              #   Pass arguments to `get_connection` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::GetConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::GetConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connection(name: nil)
              #   Pass arguments to `get_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name in the format:
              #     `projects/{project}/locations/{location}/connections/{connection}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::Connection]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::Connection]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::GetConnectionRequest.new
              #
              #   # Call the get_connection method.
              #   result = client.get_connection request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::Connection.
              #   p result
              #
              def get_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::GetConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.get_connection request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Connections in a parent. Use SearchConnections to see all connections
              # within an organization.
              #
              # @overload list_connections(request, options = nil)
              #   Pass arguments to `list_connections` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::ListConnectionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::ListConnectionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_connections(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_connections` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the organization or project, for
              #     example, `organizations/433245324/locations/europe` or
              #     `projects/project-id/locations/asia`.
              #   @param page_size [::Integer]
              #     Optional. Number of results per page, max 1000.
              #   @param page_token [::String]
              #     Optional. Page token from a previous page to return the next set of
              #     results. If set, all other request fields must match the original request.
              #   @param filter [::String]
              #     Optional. Supported field/value: `state` - MISSING|AVAILABLE|ERROR
              #
              #     The syntax is based on https://google.aip.dev/160.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::Connection>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::Connection>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::ListConnectionsRequest.new
              #
              #   # Call the list_connections method.
              #   result = client.list_connections request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::Connection.
              #     p item
              #   end
              #
              def list_connections request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::ListConnectionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_connections.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_connections.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_connections.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.list_connections request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :list_connections, "connections", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Searches for Connections in a parent.
              #
              # @overload search_connections(request, options = nil)
              #   Pass arguments to `search_connections` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::SearchConnectionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::SearchConnectionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload search_connections(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `search_connections` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. Resource name of the organization or project with a wildcard
              #     location, for example, `organizations/433245324/locations/-` or
              #     `projects/project-id/locations/-`.
              #   @param page_size [::Integer]
              #     Optional. Number of results per page, max 1000.
              #   @param page_token [::String]
              #     Optional. Page token from a previous page to return the next set of
              #     results. If set, all other request fields must match the original request.
              #   @param filter [::String]
              #     Optional. Supported field/value: - `state` - MISSING|AVAILABLE|ERROR
              #
              #     The syntax is based on https://google.aip.dev/160.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::Connection>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dlp::V2::Connection>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::SearchConnectionsRequest.new
              #
              #   # Call the search_connections method.
              #   result = client.search_connections request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dlp::V2::Connection.
              #     p item
              #   end
              #
              def search_connections request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::SearchConnectionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.search_connections.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.search_connections.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.search_connections.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.search_connections request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dlp_service_stub, :search_connections, "connections", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete a Connection.
              #
              # @overload delete_connection(request, options = nil)
              #   Pass arguments to `delete_connection` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::DeleteConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::DeleteConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_connection(name: nil)
              #   Pass arguments to `delete_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name of the Connection to be deleted, in the format:
              #     `projects/{project}/locations/{location}/connections/{connection}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::DeleteConnectionRequest.new
              #
              #   # Call the delete_connection method.
              #   result = client.delete_connection request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::DeleteConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.delete_connection request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update a Connection.
              #
              # @overload update_connection(request, options = nil)
              #   Pass arguments to `update_connection` via a request object, either of type
              #   {::Google::Cloud::Dlp::V2::UpdateConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dlp::V2::UpdateConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_connection(name: nil, connection: nil, update_mask: nil)
              #   Pass arguments to `update_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Resource name in the format:
              #     `projects/{project}/locations/{location}/connections/{connection}`.
              #   @param connection [::Google::Cloud::Dlp::V2::Connection, ::Hash]
              #     Required. The connection with new values for the relevant fields.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Mask to control which fields get updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dlp::V2::Connection]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dlp::V2::Connection]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dlp/v2"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dlp::V2::UpdateConnectionRequest.new
              #
              #   # Call the update_connection method.
              #   result = client.update_connection request
              #
              #   # The returned object is of type Google::Cloud::Dlp::V2::Connection.
              #   p result
              #
              def update_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dlp::V2::UpdateConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dlp::V2::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dlp_service_stub.update_connection request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DlpService REST API.
              #
              # This class represents the configuration for DlpService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dlp::V2::DlpService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # inspect_content to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dlp::V2::DlpService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.inspect_content.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dlp::V2::DlpService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.inspect_content.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dlp.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DlpService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `inspect_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :inspect_content
                  ##
                  # RPC-specific configuration for `redact_image`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :redact_image
                  ##
                  # RPC-specific configuration for `deidentify_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :deidentify_content
                  ##
                  # RPC-specific configuration for `reidentify_content`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :reidentify_content
                  ##
                  # RPC-specific configuration for `list_info_types`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_info_types
                  ##
                  # RPC-specific configuration for `create_inspect_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_inspect_template
                  ##
                  # RPC-specific configuration for `update_inspect_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_inspect_template
                  ##
                  # RPC-specific configuration for `get_inspect_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_inspect_template
                  ##
                  # RPC-specific configuration for `list_inspect_templates`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_inspect_templates
                  ##
                  # RPC-specific configuration for `delete_inspect_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_inspect_template
                  ##
                  # RPC-specific configuration for `create_deidentify_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_deidentify_template
                  ##
                  # RPC-specific configuration for `update_deidentify_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_deidentify_template
                  ##
                  # RPC-specific configuration for `get_deidentify_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_deidentify_template
                  ##
                  # RPC-specific configuration for `list_deidentify_templates`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_deidentify_templates
                  ##
                  # RPC-specific configuration for `delete_deidentify_template`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_deidentify_template
                  ##
                  # RPC-specific configuration for `create_job_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_job_trigger
                  ##
                  # RPC-specific configuration for `update_job_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_job_trigger
                  ##
                  # RPC-specific configuration for `hybrid_inspect_job_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :hybrid_inspect_job_trigger
                  ##
                  # RPC-specific configuration for `get_job_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_job_trigger
                  ##
                  # RPC-specific configuration for `list_job_triggers`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_job_triggers
                  ##
                  # RPC-specific configuration for `delete_job_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_job_trigger
                  ##
                  # RPC-specific configuration for `activate_job_trigger`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :activate_job_trigger
                  ##
                  # RPC-specific configuration for `create_discovery_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_discovery_config
                  ##
                  # RPC-specific configuration for `update_discovery_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_discovery_config
                  ##
                  # RPC-specific configuration for `get_discovery_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_discovery_config
                  ##
                  # RPC-specific configuration for `list_discovery_configs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_discovery_configs
                  ##
                  # RPC-specific configuration for `delete_discovery_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_discovery_config
                  ##
                  # RPC-specific configuration for `create_dlp_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_dlp_job
                  ##
                  # RPC-specific configuration for `list_dlp_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_dlp_jobs
                  ##
                  # RPC-specific configuration for `get_dlp_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_dlp_job
                  ##
                  # RPC-specific configuration for `delete_dlp_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_dlp_job
                  ##
                  # RPC-specific configuration for `cancel_dlp_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_dlp_job
                  ##
                  # RPC-specific configuration for `create_stored_info_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_stored_info_type
                  ##
                  # RPC-specific configuration for `update_stored_info_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_stored_info_type
                  ##
                  # RPC-specific configuration for `get_stored_info_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_stored_info_type
                  ##
                  # RPC-specific configuration for `list_stored_info_types`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_stored_info_types
                  ##
                  # RPC-specific configuration for `delete_stored_info_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_stored_info_type
                  ##
                  # RPC-specific configuration for `list_project_data_profiles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_project_data_profiles
                  ##
                  # RPC-specific configuration for `list_table_data_profiles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_table_data_profiles
                  ##
                  # RPC-specific configuration for `list_column_data_profiles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_column_data_profiles
                  ##
                  # RPC-specific configuration for `get_project_data_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_project_data_profile
                  ##
                  # RPC-specific configuration for `list_file_store_data_profiles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_file_store_data_profiles
                  ##
                  # RPC-specific configuration for `get_file_store_data_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_file_store_data_profile
                  ##
                  # RPC-specific configuration for `delete_file_store_data_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_file_store_data_profile
                  ##
                  # RPC-specific configuration for `get_table_data_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_table_data_profile
                  ##
                  # RPC-specific configuration for `get_column_data_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_column_data_profile
                  ##
                  # RPC-specific configuration for `delete_table_data_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_table_data_profile
                  ##
                  # RPC-specific configuration for `hybrid_inspect_dlp_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :hybrid_inspect_dlp_job
                  ##
                  # RPC-specific configuration for `finish_dlp_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :finish_dlp_job
                  ##
                  # RPC-specific configuration for `create_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_connection
                  ##
                  # RPC-specific configuration for `get_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connection
                  ##
                  # RPC-specific configuration for `list_connections`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_connections
                  ##
                  # RPC-specific configuration for `search_connections`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :search_connections
                  ##
                  # RPC-specific configuration for `delete_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_connection
                  ##
                  # RPC-specific configuration for `update_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_connection

                  # @private
                  def initialize parent_rpcs = nil
                    inspect_content_config = parent_rpcs.inspect_content if parent_rpcs.respond_to? :inspect_content
                    @inspect_content = ::Gapic::Config::Method.new inspect_content_config
                    redact_image_config = parent_rpcs.redact_image if parent_rpcs.respond_to? :redact_image
                    @redact_image = ::Gapic::Config::Method.new redact_image_config
                    deidentify_content_config = parent_rpcs.deidentify_content if parent_rpcs.respond_to? :deidentify_content
                    @deidentify_content = ::Gapic::Config::Method.new deidentify_content_config
                    reidentify_content_config = parent_rpcs.reidentify_content if parent_rpcs.respond_to? :reidentify_content
                    @reidentify_content = ::Gapic::Config::Method.new reidentify_content_config
                    list_info_types_config = parent_rpcs.list_info_types if parent_rpcs.respond_to? :list_info_types
                    @list_info_types = ::Gapic::Config::Method.new list_info_types_config
                    create_inspect_template_config = parent_rpcs.create_inspect_template if parent_rpcs.respond_to? :create_inspect_template
                    @create_inspect_template = ::Gapic::Config::Method.new create_inspect_template_config
                    update_inspect_template_config = parent_rpcs.update_inspect_template if parent_rpcs.respond_to? :update_inspect_template
                    @update_inspect_template = ::Gapic::Config::Method.new update_inspect_template_config
                    get_inspect_template_config = parent_rpcs.get_inspect_template if parent_rpcs.respond_to? :get_inspect_template
                    @get_inspect_template = ::Gapic::Config::Method.new get_inspect_template_config
                    list_inspect_templates_config = parent_rpcs.list_inspect_templates if parent_rpcs.respond_to? :list_inspect_templates
                    @list_inspect_templates = ::Gapic::Config::Method.new list_inspect_templates_config
                    delete_inspect_template_config = parent_rpcs.delete_inspect_template if parent_rpcs.respond_to? :delete_inspect_template
                    @delete_inspect_template = ::Gapic::Config::Method.new delete_inspect_template_config
                    create_deidentify_template_config = parent_rpcs.create_deidentify_template if parent_rpcs.respond_to? :create_deidentify_template
                    @create_deidentify_template = ::Gapic::Config::Method.new create_deidentify_template_config
                    update_deidentify_template_config = parent_rpcs.update_deidentify_template if parent_rpcs.respond_to? :update_deidentify_template
                    @update_deidentify_template = ::Gapic::Config::Method.new update_deidentify_template_config
                    get_deidentify_template_config = parent_rpcs.get_deidentify_template if parent_rpcs.respond_to? :get_deidentify_template
                    @get_deidentify_template = ::Gapic::Config::Method.new get_deidentify_template_config
                    list_deidentify_templates_config = parent_rpcs.list_deidentify_templates if parent_rpcs.respond_to? :list_deidentify_templates
                    @list_deidentify_templates = ::Gapic::Config::Method.new list_deidentify_templates_config
                    delete_deidentify_template_config = parent_rpcs.delete_deidentify_template if parent_rpcs.respond_to? :delete_deidentify_template
                    @delete_deidentify_template = ::Gapic::Config::Method.new delete_deidentify_template_config
                    create_job_trigger_config = parent_rpcs.create_job_trigger if parent_rpcs.respond_to? :create_job_trigger
                    @create_job_trigger = ::Gapic::Config::Method.new create_job_trigger_config
                    update_job_trigger_config = parent_rpcs.update_job_trigger if parent_rpcs.respond_to? :update_job_trigger
                    @update_job_trigger = ::Gapic::Config::Method.new update_job_trigger_config
                    hybrid_inspect_job_trigger_config = parent_rpcs.hybrid_inspect_job_trigger if parent_rpcs.respond_to? :hybrid_inspect_job_trigger
                    @hybrid_inspect_job_trigger = ::Gapic::Config::Method.new hybrid_inspect_job_trigger_config
                    get_job_trigger_config = parent_rpcs.get_job_trigger if parent_rpcs.respond_to? :get_job_trigger
                    @get_job_trigger = ::Gapic::Config::Method.new get_job_trigger_config
                    list_job_triggers_config = parent_rpcs.list_job_triggers if parent_rpcs.respond_to? :list_job_triggers
                    @list_job_triggers = ::Gapic::Config::Method.new list_job_triggers_config
                    delete_job_trigger_config = parent_rpcs.delete_job_trigger if parent_rpcs.respond_to? :delete_job_trigger
                    @delete_job_trigger = ::Gapic::Config::Method.new delete_job_trigger_config
                    activate_job_trigger_config = parent_rpcs.activate_job_trigger if parent_rpcs.respond_to? :activate_job_trigger
                    @activate_job_trigger = ::Gapic::Config::Method.new activate_job_trigger_config
                    create_discovery_config_config = parent_rpcs.create_discovery_config if parent_rpcs.respond_to? :create_discovery_config
                    @create_discovery_config = ::Gapic::Config::Method.new create_discovery_config_config
                    update_discovery_config_config = parent_rpcs.update_discovery_config if parent_rpcs.respond_to? :update_discovery_config
                    @update_discovery_config = ::Gapic::Config::Method.new update_discovery_config_config
                    get_discovery_config_config = parent_rpcs.get_discovery_config if parent_rpcs.respond_to? :get_discovery_config
                    @get_discovery_config = ::Gapic::Config::Method.new get_discovery_config_config
                    list_discovery_configs_config = parent_rpcs.list_discovery_configs if parent_rpcs.respond_to? :list_discovery_configs
                    @list_discovery_configs = ::Gapic::Config::Method.new list_discovery_configs_config
                    delete_discovery_config_config = parent_rpcs.delete_discovery_config if parent_rpcs.respond_to? :delete_discovery_config
                    @delete_discovery_config = ::Gapic::Config::Method.new delete_discovery_config_config
                    create_dlp_job_config = parent_rpcs.create_dlp_job if parent_rpcs.respond_to? :create_dlp_job
                    @create_dlp_job = ::Gapic::Config::Method.new create_dlp_job_config
                    list_dlp_jobs_config = parent_rpcs.list_dlp_jobs if parent_rpcs.respond_to? :list_dlp_jobs
                    @list_dlp_jobs = ::Gapic::Config::Method.new list_dlp_jobs_config
                    get_dlp_job_config = parent_rpcs.get_dlp_job if parent_rpcs.respond_to? :get_dlp_job
                    @get_dlp_job = ::Gapic::Config::Method.new get_dlp_job_config
                    delete_dlp_job_config = parent_rpcs.delete_dlp_job if parent_rpcs.respond_to? :delete_dlp_job
                    @delete_dlp_job = ::Gapic::Config::Method.new delete_dlp_job_config
                    cancel_dlp_job_config = parent_rpcs.cancel_dlp_job if parent_rpcs.respond_to? :cancel_dlp_job
                    @cancel_dlp_job = ::Gapic::Config::Method.new cancel_dlp_job_config
                    create_stored_info_type_config = parent_rpcs.create_stored_info_type if parent_rpcs.respond_to? :create_stored_info_type
                    @create_stored_info_type = ::Gapic::Config::Method.new create_stored_info_type_config
                    update_stored_info_type_config = parent_rpcs.update_stored_info_type if parent_rpcs.respond_to? :update_stored_info_type
                    @update_stored_info_type = ::Gapic::Config::Method.new update_stored_info_type_config
                    get_stored_info_type_config = parent_rpcs.get_stored_info_type if parent_rpcs.respond_to? :get_stored_info_type
                    @get_stored_info_type = ::Gapic::Config::Method.new get_stored_info_type_config
                    list_stored_info_types_config = parent_rpcs.list_stored_info_types if parent_rpcs.respond_to? :list_stored_info_types
                    @list_stored_info_types = ::Gapic::Config::Method.new list_stored_info_types_config
                    delete_stored_info_type_config = parent_rpcs.delete_stored_info_type if parent_rpcs.respond_to? :delete_stored_info_type
                    @delete_stored_info_type = ::Gapic::Config::Method.new delete_stored_info_type_config
                    list_project_data_profiles_config = parent_rpcs.list_project_data_profiles if parent_rpcs.respond_to? :list_project_data_profiles
                    @list_project_data_profiles = ::Gapic::Config::Method.new list_project_data_profiles_config
                    list_table_data_profiles_config = parent_rpcs.list_table_data_profiles if parent_rpcs.respond_to? :list_table_data_profiles
                    @list_table_data_profiles = ::Gapic::Config::Method.new list_table_data_profiles_config
                    list_column_data_profiles_config = parent_rpcs.list_column_data_profiles if parent_rpcs.respond_to? :list_column_data_profiles
                    @list_column_data_profiles = ::Gapic::Config::Method.new list_column_data_profiles_config
                    get_project_data_profile_config = parent_rpcs.get_project_data_profile if parent_rpcs.respond_to? :get_project_data_profile
                    @get_project_data_profile = ::Gapic::Config::Method.new get_project_data_profile_config
                    list_file_store_data_profiles_config = parent_rpcs.list_file_store_data_profiles if parent_rpcs.respond_to? :list_file_store_data_profiles
                    @list_file_store_data_profiles = ::Gapic::Config::Method.new list_file_store_data_profiles_config
                    get_file_store_data_profile_config = parent_rpcs.get_file_store_data_profile if parent_rpcs.respond_to? :get_file_store_data_profile
                    @get_file_store_data_profile = ::Gapic::Config::Method.new get_file_store_data_profile_config
                    delete_file_store_data_profile_config = parent_rpcs.delete_file_store_data_profile if parent_rpcs.respond_to? :delete_file_store_data_profile
                    @delete_file_store_data_profile = ::Gapic::Config::Method.new delete_file_store_data_profile_config
                    get_table_data_profile_config = parent_rpcs.get_table_data_profile if parent_rpcs.respond_to? :get_table_data_profile
                    @get_table_data_profile = ::Gapic::Config::Method.new get_table_data_profile_config
                    get_column_data_profile_config = parent_rpcs.get_column_data_profile if parent_rpcs.respond_to? :get_column_data_profile
                    @get_column_data_profile = ::Gapic::Config::Method.new get_column_data_profile_config
                    delete_table_data_profile_config = parent_rpcs.delete_table_data_profile if parent_rpcs.respond_to? :delete_table_data_profile
                    @delete_table_data_profile = ::Gapic::Config::Method.new delete_table_data_profile_config
                    hybrid_inspect_dlp_job_config = parent_rpcs.hybrid_inspect_dlp_job if parent_rpcs.respond_to? :hybrid_inspect_dlp_job
                    @hybrid_inspect_dlp_job = ::Gapic::Config::Method.new hybrid_inspect_dlp_job_config
                    finish_dlp_job_config = parent_rpcs.finish_dlp_job if parent_rpcs.respond_to? :finish_dlp_job
                    @finish_dlp_job = ::Gapic::Config::Method.new finish_dlp_job_config
                    create_connection_config = parent_rpcs.create_connection if parent_rpcs.respond_to? :create_connection
                    @create_connection = ::Gapic::Config::Method.new create_connection_config
                    get_connection_config = parent_rpcs.get_connection if parent_rpcs.respond_to? :get_connection
                    @get_connection = ::Gapic::Config::Method.new get_connection_config
                    list_connections_config = parent_rpcs.list_connections if parent_rpcs.respond_to? :list_connections
                    @list_connections = ::Gapic::Config::Method.new list_connections_config
                    search_connections_config = parent_rpcs.search_connections if parent_rpcs.respond_to? :search_connections
                    @search_connections = ::Gapic::Config::Method.new search_connections_config
                    delete_connection_config = parent_rpcs.delete_connection if parent_rpcs.respond_to? :delete_connection
                    @delete_connection = ::Gapic::Config::Method.new delete_connection_config
                    update_connection_config = parent_rpcs.update_connection if parent_rpcs.respond_to? :update_connection
                    @update_connection = ::Gapic::Config::Method.new update_connection_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
