# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/dlp/v2/version"

require "google/cloud/dlp/v2/dlp_service/credentials"
require "google/cloud/dlp/v2/dlp_service/paths"
require "google/cloud/dlp/v2/dlp_service/client"
require "google/cloud/dlp/v2/dlp_service/rest"

module Google
  module Cloud
    module Dlp
      module V2
        ##
        # Sensitive Data Protection provides access to a powerful sensitive data
        # inspection, classification, and de-identification platform that works
        # on text, images, and Google Cloud storage repositories.
        # To learn more about concepts and find how-to guides see
        # https://cloud.google.com/sensitive-data-protection/docs/.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/dlp/v2/dlp_service"
        #     client = ::Google::Cloud::Dlp::V2::DlpService::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/dlp/v2/dlp_service/rest"
        #     client = ::Google::Cloud::Dlp::V2::DlpService::Rest::Client.new
        #
        module DlpService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "dlp_service", "helpers.rb"
require "google/cloud/dlp/v2/dlp_service/helpers" if ::File.file? helper_path
