# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/discovery_engine/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :discovery_engine do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module DiscoveryEngine
      ##
      # Create a new client object for SearchService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::SearchService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-SearchService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the SearchService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the SearchService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.search_service_available?}.
      #
      # ## About SearchService
      #
      # Service for search.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.search_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:SearchService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the SearchService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.search_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the SearchService service,
      # or if the versioned client gem needs an update to support the SearchService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.search_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :SearchService
        service_module = service_module.const_get :SearchService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for AssistantService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::AssistantService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-AssistantService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the AssistantService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the AssistantService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.assistant_service_available?}.
      #
      # ## About AssistantService
      #
      # Service for managing Assistant configuration and assisting users.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.assistant_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:AssistantService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the AssistantService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.assistant_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the AssistantService service,
      # or if the versioned client gem needs an update to support the AssistantService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.assistant_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :AssistantService
        service_module = service_module.const_get :AssistantService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CmekConfigService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::CmekConfigService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-CmekConfigService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CmekConfigService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the CmekConfigService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.cmek_config_service_available?}.
      #
      # ## About CmekConfigService
      #
      # Service for managing CMEK related tasks
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.cmek_config_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:CmekConfigService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CmekConfigService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.cmek_config_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CmekConfigService service,
      # or if the versioned client gem needs an update to support the CmekConfigService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.cmek_config_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :CmekConfigService
        service_module = service_module.const_get :CmekConfigService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CompletionService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::CompletionService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-CompletionService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CompletionService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the CompletionService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.completion_service_available?}.
      #
      # ## About CompletionService
      #
      # Service for Auto-Completion.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.completion_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:CompletionService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CompletionService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.completion_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CompletionService service,
      # or if the versioned client gem needs an update to support the CompletionService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.completion_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :CompletionService
        service_module = service_module.const_get :CompletionService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ControlService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::ControlService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-ControlService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ControlService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ControlService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.control_service_available?}.
      #
      # ## About ControlService
      #
      # Service for performing CRUD operations on Controls.
      # Controls allow for custom logic to be implemented in the serving path.
      # Controls need to be attached to a Serving Config to be considered during a
      # request.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.control_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:ControlService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ControlService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.control_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ControlService service,
      # or if the versioned client gem needs an update to support the ControlService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.control_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :ControlService
        service_module = service_module.const_get :ControlService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ConversationalSearchService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::ConversationalSearchService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-ConversationalSearchService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ConversationalSearchService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ConversationalSearchService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.conversational_search_service_available?}.
      #
      # ## About ConversationalSearchService
      #
      # Service for conversational search.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.conversational_search_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:ConversationalSearchService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ConversationalSearchService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.conversational_search_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ConversationalSearchService service,
      # or if the versioned client gem needs an update to support the ConversationalSearchService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.conversational_search_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :ConversationalSearchService
        service_module = service_module.const_get :ConversationalSearchService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DataStoreService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::DataStoreService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-DataStoreService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DataStoreService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DataStoreService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.data_store_service_available?}.
      #
      # ## About DataStoreService
      #
      # Service for managing DataStore
      # configuration.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.data_store_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:DataStoreService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DataStoreService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.data_store_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DataStoreService service,
      # or if the versioned client gem needs an update to support the DataStoreService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.data_store_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :DataStoreService
        service_module = service_module.const_get :DataStoreService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DocumentService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::DocumentService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-DocumentService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DocumentService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DocumentService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.document_service_available?}.
      #
      # ## About DocumentService
      #
      # Service for ingesting Document
      # information of the customer's website.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.document_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:DocumentService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DocumentService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.document_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DocumentService service,
      # or if the versioned client gem needs an update to support the DocumentService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.document_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :DocumentService
        service_module = service_module.const_get :DocumentService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for EngineService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::EngineService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-EngineService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the EngineService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the EngineService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.engine_service_available?}.
      #
      # ## About EngineService
      #
      # Service for managing Engine
      # configuration.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.engine_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:EngineService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the EngineService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.engine_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the EngineService service,
      # or if the versioned client gem needs an update to support the EngineService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.engine_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :EngineService
        service_module = service_module.const_get :EngineService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for GroundedGenerationService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::GroundedGenerationService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-GroundedGenerationService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the GroundedGenerationService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the GroundedGenerationService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.grounded_generation_service_available?}.
      #
      # ## About GroundedGenerationService
      #
      # Service for grounded generation.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.grounded_generation_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:GroundedGenerationService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the GroundedGenerationService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.grounded_generation_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the GroundedGenerationService service,
      # or if the versioned client gem needs an update to support the GroundedGenerationService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.grounded_generation_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :GroundedGenerationService
        service_module = service_module.const_get :GroundedGenerationService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for IdentityMappingStoreService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::IdentityMappingStoreService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-IdentityMappingStoreService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the IdentityMappingStoreService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the IdentityMappingStoreService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.identity_mapping_store_service_available?}.
      #
      # ## About IdentityMappingStoreService
      #
      # Service for managing Identity Mapping Stores.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.identity_mapping_store_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:IdentityMappingStoreService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the IdentityMappingStoreService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.identity_mapping_store_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the IdentityMappingStoreService service,
      # or if the versioned client gem needs an update to support the IdentityMappingStoreService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.identity_mapping_store_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :IdentityMappingStoreService
        service_module = service_module.const_get :IdentityMappingStoreService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ProjectService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::ProjectService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-ProjectService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ProjectService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ProjectService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.project_service_available?}.
      #
      # ## About ProjectService
      #
      # Service for operations on the
      # Project.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.project_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:ProjectService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ProjectService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.project_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ProjectService service,
      # or if the versioned client gem needs an update to support the ProjectService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.project_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :ProjectService
        service_module = service_module.const_get :ProjectService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for RankService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::RankService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-RankService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the RankService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the RankService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.rank_service_available?}.
      #
      # ## About RankService
      #
      # Service for ranking text records.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.rank_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:RankService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the RankService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.rank_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the RankService service,
      # or if the versioned client gem needs an update to support the RankService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.rank_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :RankService
        service_module = service_module.const_get :RankService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for RecommendationService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::RecommendationService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-RecommendationService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the RecommendationService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the RecommendationService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.recommendation_service_available?}.
      #
      # ## About RecommendationService
      #
      # Service for making recommendations.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.recommendation_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:RecommendationService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the RecommendationService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.recommendation_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the RecommendationService service,
      # or if the versioned client gem needs an update to support the RecommendationService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.recommendation_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :RecommendationService
        service_module = service_module.const_get :RecommendationService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for SchemaService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::SchemaService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-SchemaService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the SchemaService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the SchemaService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.schema_service_available?}.
      #
      # ## About SchemaService
      #
      # Service for managing Schemas.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.schema_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:SchemaService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the SchemaService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.schema_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the SchemaService service,
      # or if the versioned client gem needs an update to support the SchemaService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.schema_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :SchemaService
        service_module = service_module.const_get :SchemaService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for SearchTuningService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::SearchTuningService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-SearchTuningService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the SearchTuningService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the SearchTuningService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.search_tuning_service_available?}.
      #
      # ## About SearchTuningService
      #
      # Service for search tuning.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.search_tuning_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:SearchTuningService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the SearchTuningService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.search_tuning_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the SearchTuningService service,
      # or if the versioned client gem needs an update to support the SearchTuningService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.search_tuning_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :SearchTuningService
        service_module = service_module.const_get :SearchTuningService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ServingConfigService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::ServingConfigService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-ServingConfigService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ServingConfigService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ServingConfigService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.serving_config_service_available?}.
      #
      # ## About ServingConfigService
      #
      # Service for operations related to
      # ServingConfig.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.serving_config_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:ServingConfigService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ServingConfigService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.serving_config_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ServingConfigService service,
      # or if the versioned client gem needs an update to support the ServingConfigService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.serving_config_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :ServingConfigService
        service_module = service_module.const_get :ServingConfigService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for SessionService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::SessionService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-SessionService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the SessionService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the SessionService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.session_service_available?}.
      #
      # ## About SessionService
      #
      # Service for managing Sessions and Session-related resources.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.session_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:SessionService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the SessionService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.session_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the SessionService service,
      # or if the versioned client gem needs an update to support the SessionService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.session_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :SessionService
        service_module = service_module.const_get :SessionService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for SiteSearchEngineService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::SiteSearchEngineService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-SiteSearchEngineService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the SiteSearchEngineService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the SiteSearchEngineService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.site_search_engine_service_available?}.
      #
      # ## About SiteSearchEngineService
      #
      # Service for managing site search related resources.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.site_search_engine_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:SiteSearchEngineService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the SiteSearchEngineService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.site_search_engine_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the SiteSearchEngineService service,
      # or if the versioned client gem needs an update to support the SiteSearchEngineService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.site_search_engine_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :SiteSearchEngineService
        service_module = service_module.const_get :SiteSearchEngineService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for UserEventService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::UserEventService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-UserEventService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the UserEventService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the UserEventService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.user_event_service_available?}.
      #
      # ## About UserEventService
      #
      # Service for ingesting end user actions on a website to Discovery Engine API.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.user_event_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:UserEventService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the UserEventService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.user_event_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the UserEventService service,
      # or if the versioned client gem needs an update to support the UserEventService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.user_event_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :UserEventService
        service_module = service_module.const_get :UserEventService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for UserLicenseService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::DiscoveryEngine::V1::UserLicenseService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-discovery_engine-v1/latest/Google-Cloud-DiscoveryEngine-V1-UserLicenseService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the UserLicenseService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the UserLicenseService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::DiscoveryEngine.user_license_service_available?}.
      #
      # ## About UserLicenseService
      #
      # Service for managing User Licenses.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.user_license_service version: :v1, transport: :grpc, &block
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"

        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::DiscoveryEngine.const_get(package_name).const_get(:UserLicenseService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the UserLicenseService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::DiscoveryEngine.user_license_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the UserLicenseService service,
      # or if the versioned client gem needs an update to support the UserLicenseService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.user_license_service_available? version: :v1, transport: :grpc
        require "google/cloud/discovery_engine/#{version.to_s.downcase}"
        package_name = Google::Cloud::DiscoveryEngine
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::DiscoveryEngine.const_get package_name
        return false unless service_module.const_defined? :UserLicenseService
        service_module = service_module.const_get :UserLicenseService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-discovery_engine library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
      #   An array of interceptors that are run before calls are executed.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.discovery_engine if block_given?

        ::Google::Cloud.configure.discovery_engine
      end
    end
  end
end

helper_path = ::File.join __dir__, "discovery_engine", "helpers.rb"
require "google/cloud/discovery_engine/helpers" if ::File.file? helper_path
