# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/discoveryengine/v1beta/site_search_engine_service_pb"
require "google/cloud/discovery_engine/v1beta/site_search_engine_service/rest"


class ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_site_search_engine
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngine.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_site_search_engine_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_get_site_search_engine_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_site_search_engine_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_site_search_engine({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_site_search_engine name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_site_search_engine ::Google::Cloud::DiscoveryEngine::V1beta::GetSiteSearchEngineRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_site_search_engine({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_site_search_engine(::Google::Cloud::DiscoveryEngine::V1beta::GetSiteSearchEngineRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_site_search_engine_client_stub.call_count
      end
    end
  end

  def test_create_target_site
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    target_site = {}

    create_target_site_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_create_target_site_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_target_site_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_target_site({ parent: parent, target_site: target_site }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_target_site parent: parent, target_site: target_site do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_target_site ::Google::Cloud::DiscoveryEngine::V1beta::CreateTargetSiteRequest.new(parent: parent, target_site: target_site) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_target_site({ parent: parent, target_site: target_site }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_target_site(::Google::Cloud::DiscoveryEngine::V1beta::CreateTargetSiteRequest.new(parent: parent, target_site: target_site), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_target_site_client_stub.call_count
      end
    end
  end

  def test_batch_create_target_sites
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    requests = [{}]

    batch_create_target_sites_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_batch_create_target_sites_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_create_target_sites_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_create_target_sites({ parent: parent, requests: requests }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_create_target_sites parent: parent, requests: requests do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_create_target_sites ::Google::Cloud::DiscoveryEngine::V1beta::BatchCreateTargetSitesRequest.new(parent: parent, requests: requests) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_create_target_sites({ parent: parent, requests: requests }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_create_target_sites(::Google::Cloud::DiscoveryEngine::V1beta::BatchCreateTargetSitesRequest.new(parent: parent, requests: requests), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_create_target_sites_client_stub.call_count
      end
    end
  end

  def test_get_target_site
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1beta::TargetSite.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_target_site_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_get_target_site_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_target_site_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_target_site({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_target_site name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_target_site ::Google::Cloud::DiscoveryEngine::V1beta::GetTargetSiteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_target_site({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_target_site(::Google::Cloud::DiscoveryEngine::V1beta::GetTargetSiteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_target_site_client_stub.call_count
      end
    end
  end

  def test_update_target_site
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    target_site = {}

    update_target_site_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_update_target_site_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_target_site_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_target_site({ target_site: target_site }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_target_site target_site: target_site do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_target_site ::Google::Cloud::DiscoveryEngine::V1beta::UpdateTargetSiteRequest.new(target_site: target_site) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_target_site({ target_site: target_site }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_target_site(::Google::Cloud::DiscoveryEngine::V1beta::UpdateTargetSiteRequest.new(target_site: target_site), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_target_site_client_stub.call_count
      end
    end
  end

  def test_delete_target_site
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_target_site_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_delete_target_site_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_target_site_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_target_site({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_target_site name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_target_site ::Google::Cloud::DiscoveryEngine::V1beta::DeleteTargetSiteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_target_site({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_target_site(::Google::Cloud::DiscoveryEngine::V1beta::DeleteTargetSiteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_target_site_client_stub.call_count
      end
    end
  end

  def test_list_target_sites
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1beta::ListTargetSitesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_target_sites_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_list_target_sites_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_target_sites_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_target_sites({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_target_sites parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_target_sites ::Google::Cloud::DiscoveryEngine::V1beta::ListTargetSitesRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_target_sites({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_target_sites(::Google::Cloud::DiscoveryEngine::V1beta::ListTargetSitesRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_target_sites_client_stub.call_count
      end
    end
  end

  def test_create_sitemap
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    sitemap = {}

    create_sitemap_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_create_sitemap_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_sitemap_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_sitemap({ parent: parent, sitemap: sitemap }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_sitemap parent: parent, sitemap: sitemap do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_sitemap ::Google::Cloud::DiscoveryEngine::V1beta::CreateSitemapRequest.new(parent: parent, sitemap: sitemap) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_sitemap({ parent: parent, sitemap: sitemap }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_sitemap(::Google::Cloud::DiscoveryEngine::V1beta::CreateSitemapRequest.new(parent: parent, sitemap: sitemap), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_sitemap_client_stub.call_count
      end
    end
  end

  def test_delete_sitemap
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_sitemap_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_delete_sitemap_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_sitemap_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_sitemap({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_sitemap name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_sitemap ::Google::Cloud::DiscoveryEngine::V1beta::DeleteSitemapRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_sitemap({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_sitemap(::Google::Cloud::DiscoveryEngine::V1beta::DeleteSitemapRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_sitemap_client_stub.call_count
      end
    end
  end

  def test_fetch_sitemaps
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    matcher = {}

    fetch_sitemaps_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_fetch_sitemaps_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_sitemaps_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_sitemaps({ parent: parent, matcher: matcher }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_sitemaps parent: parent, matcher: matcher do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_sitemaps ::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsRequest.new(parent: parent, matcher: matcher) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_sitemaps({ parent: parent, matcher: matcher }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_sitemaps(::Google::Cloud::DiscoveryEngine::V1beta::FetchSitemapsRequest.new(parent: parent, matcher: matcher), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_sitemaps_client_stub.call_count
      end
    end
  end

  def test_enable_advanced_site_search
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    site_search_engine = "hello world"

    enable_advanced_site_search_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_enable_advanced_site_search_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, enable_advanced_site_search_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.enable_advanced_site_search({ site_search_engine: site_search_engine }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.enable_advanced_site_search site_search_engine: site_search_engine do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.enable_advanced_site_search ::Google::Cloud::DiscoveryEngine::V1beta::EnableAdvancedSiteSearchRequest.new(site_search_engine: site_search_engine) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.enable_advanced_site_search({ site_search_engine: site_search_engine }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.enable_advanced_site_search(::Google::Cloud::DiscoveryEngine::V1beta::EnableAdvancedSiteSearchRequest.new(site_search_engine: site_search_engine), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, enable_advanced_site_search_client_stub.call_count
      end
    end
  end

  def test_disable_advanced_site_search
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    site_search_engine = "hello world"

    disable_advanced_site_search_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_disable_advanced_site_search_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, disable_advanced_site_search_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.disable_advanced_site_search({ site_search_engine: site_search_engine }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.disable_advanced_site_search site_search_engine: site_search_engine do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.disable_advanced_site_search ::Google::Cloud::DiscoveryEngine::V1beta::DisableAdvancedSiteSearchRequest.new(site_search_engine: site_search_engine) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.disable_advanced_site_search({ site_search_engine: site_search_engine }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.disable_advanced_site_search(::Google::Cloud::DiscoveryEngine::V1beta::DisableAdvancedSiteSearchRequest.new(site_search_engine: site_search_engine), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, disable_advanced_site_search_client_stub.call_count
      end
    end
  end

  def test_recrawl_uris
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    site_search_engine = "hello world"
    uris = ["hello world"]
    site_credential = "hello world"

    recrawl_uris_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_recrawl_uris_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, recrawl_uris_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.recrawl_uris({ site_search_engine: site_search_engine, uris: uris, site_credential: site_credential }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.recrawl_uris site_search_engine: site_search_engine, uris: uris, site_credential: site_credential do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.recrawl_uris ::Google::Cloud::DiscoveryEngine::V1beta::RecrawlUrisRequest.new(site_search_engine: site_search_engine, uris: uris, site_credential: site_credential) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.recrawl_uris({ site_search_engine: site_search_engine, uris: uris, site_credential: site_credential }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.recrawl_uris(::Google::Cloud::DiscoveryEngine::V1beta::RecrawlUrisRequest.new(site_search_engine: site_search_engine, uris: uris, site_credential: site_credential), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, recrawl_uris_client_stub.call_count
      end
    end
  end

  def test_batch_verify_target_sites
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    batch_verify_target_sites_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_batch_verify_target_sites_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, batch_verify_target_sites_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.batch_verify_target_sites({ parent: parent }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.batch_verify_target_sites parent: parent do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.batch_verify_target_sites ::Google::Cloud::DiscoveryEngine::V1beta::BatchVerifyTargetSitesRequest.new(parent: parent) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.batch_verify_target_sites({ parent: parent }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.batch_verify_target_sites(::Google::Cloud::DiscoveryEngine::V1beta::BatchVerifyTargetSitesRequest.new(parent: parent), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, batch_verify_target_sites_client_stub.call_count
      end
    end
  end

  def test_fetch_domain_verification_status
    # Create test objects.
    client_result = ::Google::Cloud::DiscoveryEngine::V1beta::FetchDomainVerificationStatusResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    site_search_engine = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_domain_verification_status_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::ServiceStub.stub :transcode_fetch_domain_verification_status_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_domain_verification_status_client_stub do
        # Create client
        client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_domain_verification_status({ site_search_engine: site_search_engine, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_domain_verification_status site_search_engine: site_search_engine, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_domain_verification_status ::Google::Cloud::DiscoveryEngine::V1beta::FetchDomainVerificationStatusRequest.new(site_search_engine: site_search_engine, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_domain_verification_status({ site_search_engine: site_search_engine, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_domain_verification_status(::Google::Cloud::DiscoveryEngine::V1beta::FetchDomainVerificationStatusRequest.new(site_search_engine: site_search_engine, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_domain_verification_status_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::SiteSearchEngineService::Rest::Client::Configuration, config
  end
end
