# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/discoveryengine/v1beta/completion_service_pb"
require "google/cloud/discovery_engine/v1beta/completion_service"

class ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_complete_query
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DiscoveryEngine::V1beta::CompleteQueryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    data_store = "hello world"
    query = "hello world"
    query_model = "hello world"
    user_pseudo_id = "hello world"
    include_tail_suggestions = true

    complete_query_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :complete_query, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::CompleteQueryRequest, request
      assert_equal "hello world", request["data_store"]
      assert_equal "hello world", request["query"]
      assert_equal "hello world", request["query_model"]
      assert_equal "hello world", request["user_pseudo_id"]
      assert_equal true, request["include_tail_suggestions"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, complete_query_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.complete_query({ data_store: data_store, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, include_tail_suggestions: include_tail_suggestions }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.complete_query data_store: data_store, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, include_tail_suggestions: include_tail_suggestions do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.complete_query ::Google::Cloud::DiscoveryEngine::V1beta::CompleteQueryRequest.new(data_store: data_store, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, include_tail_suggestions: include_tail_suggestions) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.complete_query({ data_store: data_store, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, include_tail_suggestions: include_tail_suggestions }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.complete_query(::Google::Cloud::DiscoveryEngine::V1beta::CompleteQueryRequest.new(data_store: data_store, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, include_tail_suggestions: include_tail_suggestions), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, complete_query_client_stub.call_rpc_count
    end
  end

  def test_advanced_complete_query
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    completion_config = "hello world"
    query = "hello world"
    query_model = "hello world"
    user_pseudo_id = "hello world"
    user_info = {}
    include_tail_suggestions = true
    boost_spec = {}
    suggestion_types = [:SUGGESTION_TYPE_UNSPECIFIED]

    advanced_complete_query_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :advanced_complete_query, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryRequest, request
      assert_equal "hello world", request["completion_config"]
      assert_equal "hello world", request["query"]
      assert_equal "hello world", request["query_model"]
      assert_equal "hello world", request["user_pseudo_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1beta::UserInfo), request["user_info"]
      assert_equal true, request["include_tail_suggestions"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryRequest::BoostSpec), request["boost_spec"]
      assert_equal [:SUGGESTION_TYPE_UNSPECIFIED], request["suggestion_types"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, advanced_complete_query_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.advanced_complete_query({ completion_config: completion_config, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, user_info: user_info, include_tail_suggestions: include_tail_suggestions, boost_spec: boost_spec, suggestion_types: suggestion_types }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.advanced_complete_query completion_config: completion_config, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, user_info: user_info, include_tail_suggestions: include_tail_suggestions, boost_spec: boost_spec, suggestion_types: suggestion_types do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.advanced_complete_query ::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryRequest.new(completion_config: completion_config, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, user_info: user_info, include_tail_suggestions: include_tail_suggestions, boost_spec: boost_spec, suggestion_types: suggestion_types) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.advanced_complete_query({ completion_config: completion_config, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, user_info: user_info, include_tail_suggestions: include_tail_suggestions, boost_spec: boost_spec, suggestion_types: suggestion_types }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.advanced_complete_query(::Google::Cloud::DiscoveryEngine::V1beta::AdvancedCompleteQueryRequest.new(completion_config: completion_config, query: query, query_model: query_model, user_pseudo_id: user_pseudo_id, user_info: user_info, include_tail_suggestions: include_tail_suggestions, boost_spec: boost_spec, suggestion_types: suggestion_types), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, advanced_complete_query_client_stub.call_rpc_count
    end
  end

  def test_import_suggestion_deny_list_entries
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    inline_source = {}
    parent = "hello world"

    import_suggestion_deny_list_entries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_suggestion_deny_list_entries, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::ImportSuggestionDenyListEntriesRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1beta::ImportSuggestionDenyListEntriesRequest::InlineSource), request["inline_source"]
      assert_equal :inline_source, request.source
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_suggestion_deny_list_entries_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_suggestion_deny_list_entries({ inline_source: inline_source, parent: parent }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_suggestion_deny_list_entries inline_source: inline_source, parent: parent do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_suggestion_deny_list_entries ::Google::Cloud::DiscoveryEngine::V1beta::ImportSuggestionDenyListEntriesRequest.new(inline_source: inline_source, parent: parent) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_suggestion_deny_list_entries({ inline_source: inline_source, parent: parent }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_suggestion_deny_list_entries(::Google::Cloud::DiscoveryEngine::V1beta::ImportSuggestionDenyListEntriesRequest.new(inline_source: inline_source, parent: parent), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_suggestion_deny_list_entries_client_stub.call_rpc_count
    end
  end

  def test_purge_suggestion_deny_list_entries
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    purge_suggestion_deny_list_entries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :purge_suggestion_deny_list_entries, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::PurgeSuggestionDenyListEntriesRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, purge_suggestion_deny_list_entries_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.purge_suggestion_deny_list_entries({ parent: parent }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.purge_suggestion_deny_list_entries parent: parent do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.purge_suggestion_deny_list_entries ::Google::Cloud::DiscoveryEngine::V1beta::PurgeSuggestionDenyListEntriesRequest.new(parent: parent) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.purge_suggestion_deny_list_entries({ parent: parent }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.purge_suggestion_deny_list_entries(::Google::Cloud::DiscoveryEngine::V1beta::PurgeSuggestionDenyListEntriesRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, purge_suggestion_deny_list_entries_client_stub.call_rpc_count
    end
  end

  def test_import_completion_suggestions
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    inline_source = {}
    parent = "hello world"
    error_config = {}

    import_completion_suggestions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :import_completion_suggestions, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::ImportCompletionSuggestionsRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1beta::ImportCompletionSuggestionsRequest::InlineSource), request["inline_source"]
      assert_equal :inline_source, request.source
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DiscoveryEngine::V1beta::ImportErrorConfig), request["error_config"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, import_completion_suggestions_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.import_completion_suggestions({ inline_source: inline_source, parent: parent, error_config: error_config }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.import_completion_suggestions inline_source: inline_source, parent: parent, error_config: error_config do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.import_completion_suggestions ::Google::Cloud::DiscoveryEngine::V1beta::ImportCompletionSuggestionsRequest.new(inline_source: inline_source, parent: parent, error_config: error_config) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.import_completion_suggestions({ inline_source: inline_source, parent: parent, error_config: error_config }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.import_completion_suggestions(::Google::Cloud::DiscoveryEngine::V1beta::ImportCompletionSuggestionsRequest.new(inline_source: inline_source, parent: parent, error_config: error_config), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, import_completion_suggestions_client_stub.call_rpc_count
    end
  end

  def test_purge_completion_suggestions
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"

    purge_completion_suggestions_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :purge_completion_suggestions, name
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::PurgeCompletionSuggestionsRequest, request
      assert_equal "hello world", request["parent"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, purge_completion_suggestions_client_stub do
      # Create client
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.purge_completion_suggestions({ parent: parent }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.purge_completion_suggestions parent: parent do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.purge_completion_suggestions ::Google::Cloud::DiscoveryEngine::V1beta::PurgeCompletionSuggestionsRequest.new(parent: parent) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.purge_completion_suggestions({ parent: parent }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.purge_completion_suggestions(::Google::Cloud::DiscoveryEngine::V1beta::PurgeCompletionSuggestionsRequest.new(parent: parent), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, purge_completion_suggestions_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::DiscoveryEngine::V1beta::CompletionService::Operations, client.operations_client
  end
end
