# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request message for WriteUserEvent method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource name.
        #     If the write user event action is applied in
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore} level, the
        #     format is:
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.
        #     If the write user event action is applied in [Location][] level, for
        #     example, the event with
        #     {::Google::Cloud::DiscoveryEngine::V1beta::Document Document} across multiple
        #     {::Google::Cloud::DiscoveryEngine::V1beta::DataStore DataStore}, the format is:
        #     `projects/{project}/locations/{location}`.
        # @!attribute [rw] user_event
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::UserEvent]
        #     Required. User event to write.
        # @!attribute [rw] write_async
        #   @return [::Boolean]
        #     If set to true, the user event is written asynchronously after
        #     validation, and the API responds without waiting for the write.
        class WriteUserEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for CollectUserEvent method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent DataStore resource name, such as
        #     `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}`.
        # @!attribute [rw] user_event
        #   @return [::String]
        #     Required. URL encoded UserEvent proto with a length limit of 2,000,000
        #     characters.
        # @!attribute [rw] uri
        #   @return [::String]
        #     The URL including cgi-parameters but excluding the hash fragment with a
        #     length limit of 5,000 characters. This is often more useful than the
        #     referer URL, because many browsers only send the domain for third-party
        #     requests.
        # @!attribute [rw] ets
        #   @return [::Integer]
        #     The event timestamp in milliseconds. This prevents browser caching of
        #     otherwise identical get requests. The name is abbreviated to reduce the
        #     payload bytes.
        class CollectUserEventRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
