# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DiscoveryEngine
      module V1beta
        # Request for UpdateServingConfig method.
        # @!attribute [rw] serving_config
        #   @return [::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig]
        #     Required. The ServingConfig to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Indicates which fields in the provided
        #     {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig ServingConfig} to
        #     update. The following are NOT supported:
        #
        #     * {::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig#name ServingConfig.name}
        #
        #     If not set, all supported fields are updated.
        class UpdateServingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for GetServingConfig method.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the ServingConfig to get. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/servingConfigs/{serving_config_id}`
        class GetServingConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request for ListServingConfigs method.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. Full resource name of the parent resource. Format:
        #     `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of results to return. If unspecified, defaults
        #     to 100. If a value greater than 100 is provided, at most 100 results are
        #     returned.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListServingConfigs` call.
        #     Provide this to retrieve the subsequent page.
        class ListServingConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Response for ListServingConfigs method.
        # @!attribute [rw] serving_configs
        #   @return [::Array<::Google::Cloud::DiscoveryEngine::V1beta::ServingConfig>]
        #     All the ServingConfigs for a given dataStore.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Pagination token, if not returned indicates the last page.
        class ListServingConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
